/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_KNoid2
extends PgWeierstrassDescr {
    private final int m_defaultSymmetry = 3;
    private final double m_defaultRadius = 0.8;
    protected PuInteger m_iSymmetry;
    protected PuDouble m_dRadius;
    private int m_symmetry = 3;
    private double m_radius = 0.8;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_KNoid2;

    public PgWeierstrass_KNoid2() {
        super(1);
        this.setName("K-Noid Conjugate");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        this.m_bMarkBnd = true;
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_KNoid2 == null ? (class$vgp$minimal$weier$PgWeierstrass_KNoid2 = PgWeierstrass_KNoid2.class$("vgp.minimal.weier.PgWeierstrass_KNoid2")) : class$vgp$minimal$weier$PgWeierstrass_KNoid2)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(7);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.2, 1.0, 0.01, 0.1);
        this.m_dRadius.setDefValue(0.8);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_iSymmetry.setDefBounds(2, 20, 1, 5);
        this.m_iSymmetry.setDefValue(3);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.setDomain(0, 0.0, 0.8, 0.0, 1.5707963267948966);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)(1.0 - puComplex.re), (double)(1.5707963267948966 - puComplex.im));
        puComplex2 = PuComplex.div((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)PuComplex.I), (PuComplex)PuComplex.add((PuComplex)puComplex2, (PuComplex)PuComplex.I));
        puComplex2 = PuComplex.polarToRect((double)Math.exp(2.0 / (double)this.m_symmetry * Math.log(PuComplex.abs((PuComplex)puComplex2))), (double)(2.0 / (double)this.m_symmetry * PuComplex.arg((PuComplex)puComplex2)));
        return puComplex2;
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)this.m_symmetry);
        PuComplex puComplex3 = PuComplex.rotJ((PuComplex)PuComplex.inv((PuComplex)PuComplex.sqr((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)PuComplex.ONE))));
        return puComplex3;
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)(this.m_symmetry - 1));
        return puComplex2;
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 4;
        }
        return this.m_numUserReflections + 1;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(3, 3, 2, 3);
        }
    }

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 3);
            this.reflectPart(2, 0, 2);
            this.reflectPart(3, 1, 2);
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0) && n == 0) {
            piVector2.m_data[0] = 1;
            piVector2.m_data[3] = 1;
            piVector2.m_data[2] = 1;
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

