/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsToolbar;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.rsrc.PsJavaView;
import jv.viewer.PvControlMenu;
import jv.viewer.PvDisplay;
import jv.viewer.PvViewer;

final class PvControl
extends PsMainFrame
implements ContainerListener,
KeyListener {
    private static final int NUM_PANELS = 16;
    private static final int PROJECT_ARR = 0;
    private static final int INFO_ARR = 1;
    private static final int MATERIAL_ARR = 2;
    private static final int BOUNDARY_ARR = 3;
    private static final int TEXTURE_ARR = 4;
    private static final int VECTOR_ARR = 5;
    private static final int LABEL_ARR = 6;
    private static final int CONFIG_ARR = 7;
    private static final int LIGHT_ARR = 8;
    private static final int AXES_ARR = 9;
    private static final int AXIS_X_ARR = 10;
    private static final int AXIS_Y_ARR = 11;
    private static final int AXIS_Z_ARR = 12;
    private static final int CAMERA_ARR = 13;
    private static final int DISPLAY_ARR = 14;
    private static final int DUMMY_ARR = 15;
    protected static final String[] m_panelName = new String[]{"Project", "Info", "Material", "Boundary", "Texture", "Vector", "Label", "Config", "Light", "Axis", "X-Axis", "Y-Axis", "Z-Axis", "Camera", "Display", "Dummy"};
    protected PsPanel[] m_oldPanel = new PsPanel[16];
    protected boolean[] m_bPanelOutside = new boolean[16];
    protected CardLayout m_crd;
    protected PsPanel m_inspector;
    protected int m_currentPanel_Id;
    private boolean m_firstShowing;
    protected PvControlMenu m_menuBar;
    protected PvViewer m_viewer;
    protected PjProject m_project;
    protected PgGeometryIf m_geometry;
    protected PvDisplayIf m_display;

    public PvControl(PvViewer pvViewer) {
        super(PsConfig.getMessage(24245) + " - " + PsConfig.getProgram(), (String[])null);
        this.setShortTitle(PsConfig.getMessage(24245));
        this.m_viewer = pvViewer;
        this.addKeyAndContainerListenerRecursively(this);
        this.m_firstShowing = true;
        this.m_currentPanel_Id = 15;
        this.init();
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
        for (int i = 0; i < 16; ++i) {
            this.m_bPanelOutside[i] = false;
        }
        this.m_crd = new CardLayout();
        this.m_inspector = new PsPanel(this.m_crd);
        this.add((Component)this.m_inspector, "Center");
        this.m_menuBar = this.m_viewer.newMenuBar(this);
        this.setMenuBar(this.m_menuBar);
    }

    public PsPanel getPanel(int n) {
        int n2 = PvControl.getPanelPosition(n);
        PsPanel psPanel = this.assurePanelAtPosition(n2);
        if (psPanel == null) {
            return null;
        }
        this.setEnabledPanel(n, false);
        this.m_bPanelOutside[n2] = true;
        return psPanel;
    }

    protected PsPanel releasePanel(int n) {
        int n2 = PvControl.getPanelPosition(n);
        PsPanel psPanel = this.assurePanelAtPosition(n2);
        if (psPanel == null) {
            return null;
        }
        this.setEnabledPanel(n, true);
        this.m_bPanelOutside[n2] = false;
        return psPanel;
    }

    protected boolean setEnabledPanel(int n, boolean bl) {
        int n2 = this.getMenuIdOfPanel(n);
        if (n2 == -1) {
            return false;
        }
        this.m_viewer.setEnabledMenu(n2, bl);
        return true;
    }

    protected boolean isEnabledPanel(int n) {
        int n2 = this.getMenuIdOfPanel(n);
        if (n2 == -1) {
            return false;
        }
        return this.m_viewer.isEnabledMenu(n2);
    }

    protected int getMenuIdOfPanel(int n) {
        int n2 = -1;
        switch (n) {
            case 10: {
                n2 = 21;
                break;
            }
            case 12: {
                n2 = 220;
                break;
            }
            case 13: {
                n2 = 221;
                break;
            }
            case 14: {
                n2 = 222;
                break;
            }
            case 15: {
                n2 = 223;
                break;
            }
            case 16: {
                n2 = 224;
                break;
            }
            case 18: {
                n2 = 225;
                break;
            }
            case 17: {
                n2 = 226;
                break;
            }
            case 19: {
                n2 = 23;
                break;
            }
            case 20: {
                n2 = 24;
                break;
            }
            case 23: {
                n2 = 241;
                break;
            }
            case 24: {
                n2 = 242;
                break;
            }
            case 25: {
                n2 = 243;
                break;
            }
            case 21: {
                n2 = 25;
                break;
            }
            case 22: {
                n2 = 26;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public void setVisible(boolean bl) {
        PsPanel psPanel;
        if (super.isVisible() == bl) {
            return;
        }
        if (!bl || !this.m_firstShowing) {
            super.setVisible(bl);
            return;
        }
        this.m_firstShowing = false;
        Image image = PsToolbar.getImage(this, 66);
        if (image != null) {
            this.setIconImage(image);
        }
        if ((psPanel = this.assurePanelAtPosition(this.m_currentPanel_Id)) == null || this.m_bPanelOutside[this.m_currentPanel_Id]) {
            for (int i = 1; i <= 16; ++i) {
                this.setEnabledPanel(PvControl.getPanelId(this.m_currentPanel_Id), false);
                this.m_currentPanel_Id = (this.m_currentPanel_Id + i) % 16;
                psPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
                if (psPanel != null && !this.m_bPanelOutside[this.m_currentPanel_Id]) break;
            }
            if (psPanel == null) {
                PsDebug.error("missing panel = " + m_panelName[this.m_currentPanel_Id], this);
                return;
            }
        }
        this.addInspectorPanel(this.m_currentPanel_Id, psPanel);
        this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
        this.pack();
        int[] nArray = PsJavaView.getWindowSize(1);
        this.setLocation(nArray[0], nArray[1]);
        ((Component)this).setSize(nArray[2], nArray[3]);
        super.setVisible(true);
    }

    protected boolean showPanelAtPosition(int n) {
        if (n < 0) {
            PsDebug.warning("wrong panelPos = " + n);
            return false;
        }
        if (this.m_bPanelOutside[n]) {
            return false;
        }
        this.m_currentPanel_Id = n;
        if (this.isShowing()) {
            PsPanel psPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
            if (psPanel == null) {
                return false;
            }
            boolean bl = true;
            Container container = psPanel.getParent();
            if (psPanel.isShowing() && this.m_inspector != container) {
                bl = false;
                int n2 = PvControl.getPanelId(this.m_currentPanel_Id);
                this.setEnabledPanel(n2, true);
                PsDebug.warning("Requested panel is not associated to control window", psPanel);
            }
            this.addInspectorPanel(this.m_currentPanel_Id, psPanel);
            this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
            if (!bl) {
                ((Component)container).validate();
            }
        } else {
            this.m_firstShowing = true;
        }
        return true;
    }

    public boolean showPanel(int n) {
        int n2 = PvControl.getPanelPosition(n);
        return this.showPanelAtPosition(n2);
    }

    private static int getPanelPosition(int n) {
        if (n == 10) {
            return 0;
        }
        if (n == 12) {
            return 1;
        }
        if (n == 13) {
            return 2;
        }
        if (n == 14) {
            return 3;
        }
        if (n == 15) {
            return 4;
        }
        if (n == 16) {
            return 5;
        }
        if (n == 18) {
            return 6;
        }
        if (n == 17) {
            return 7;
        }
        if (n == 19) {
            return 8;
        }
        if (n == 20) {
            return 9;
        }
        if (n == 23) {
            return 10;
        }
        if (n == 24) {
            return 11;
        }
        if (n == 25) {
            return 12;
        }
        if (n == 21) {
            return 13;
        }
        if (n == 22) {
            return 14;
        }
        return -1;
    }

    private static int getPanelId(int n) {
        if (n == 0) {
            return 10;
        }
        if (n == 1) {
            return 12;
        }
        if (n == 2) {
            return 13;
        }
        if (n == 3) {
            return 14;
        }
        if (n == 4) {
            return 15;
        }
        if (n == 5) {
            return 16;
        }
        if (n == 6) {
            return 18;
        }
        if (n == 7) {
            return 17;
        }
        if (n == 8) {
            return 19;
        }
        if (n == 9) {
            return 20;
        }
        if (n == 10) {
            return 23;
        }
        if (n == 11) {
            return 24;
        }
        if (n == 12) {
            return 25;
        }
        if (n == 13) {
            return 21;
        }
        if (n == 14) {
            return 22;
        }
        PsDebug.warning("panel not found = " + n);
        return -1;
    }

    private PsPanel assurePanelAtPosition(int n) {
        PsPanel psPanel = null;
        if (this.m_oldPanel[n] != null) {
            if (this.m_oldPanel[n].getPanelVersion() == PsConfig.getPanelVersion()) {
                return this.m_oldPanel[n];
            }
            this.m_oldPanel[n] = null;
        }
        switch (n) {
            case 15: {
                psPanel = new PsPanel();
                psPanel.setInsetSize(4);
                psPanel.setBorderType(1);
                psPanel.addTitle("Empty Control Window");
                String string = PsConfig.getMessage(24365);
                PsMultiLineLabel psMultiLineLabel = new PsMultiLineLabel("\n" + string);
                psPanel.add(psMultiLineLabel);
                break;
            }
            case 0: {
                if (this.m_project == null) {
                    return null;
                }
                psPanel = this.m_project.getInfoPanel();
                break;
            }
            case 1: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Info", "_IP");
                break;
            }
            case 2: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Material", "_MP");
                break;
            }
            case 3: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Boundary", "_BP");
                break;
            }
            case 4: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Texture", "_TP");
                break;
            }
            case 5: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Vector", "_VP");
                break;
            }
            case 6: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Label", "_LP");
                break;
            }
            case 7: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Config", "_CP");
                break;
            }
            case 8: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = ((PvDisplay)this.m_display).getLightPanel();
                break;
            }
            case 9: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = ((PvDisplay)this.m_display).getAxisPanel();
                break;
            }
            case 10: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = ((PvDisplay)this.m_display).getAxisPanel(23);
                break;
            }
            case 11: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = ((PvDisplay)this.m_display).getAxisPanel(24);
                break;
            }
            case 12: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = ((PvDisplay)this.m_display).getAxisPanel(25);
                break;
            }
            case 13: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = this.m_display.getCameraPanel();
                break;
            }
            case 14: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = this.m_display.getInfoPanel();
                break;
            }
            default: {
                PsDebug.warning("index of panel = " + n + " not found");
                return null;
            }
        }
        if (psPanel == null) {
            return null;
        }
        return psPanel;
    }

    protected void setProject(PjProject pjProject) {
        if (this.m_project == pjProject) {
            return;
        }
        PsPanel psPanel = null;
        if (pjProject != null && this.isShowing() && this.m_currentPanel_Id == 0) {
            psPanel = this.m_oldPanel[this.m_currentPanel_Id];
            this.m_oldPanel[this.m_currentPanel_Id] = null;
        }
        this.removeInspectorPanel(0);
        this.m_project = pjProject;
        if (!this.isShowing()) {
            return;
        }
        boolean bl = this.reassurePanel(this.m_currentPanel_Id);
        if (psPanel != null) {
            this.m_inspector.remove(psPanel);
        }
        if (!bl && this.m_project != null) {
            bl = this.showPanelAtPosition(0);
        }
        if (!bl && this.m_display != null) {
            bl = this.showPanelAtPosition(14);
        }
        if (!bl && this.m_geometry != null) {
            bl = this.showPanelAtPosition(2);
        }
        if (!bl) {
            this.showPanelAtPosition(15);
        }
    }

    protected void setGeometry(PgGeometryIf pgGeometryIf) {
        if (this.m_geometry == pgGeometryIf) {
            return;
        }
        PsPanel psPanel = null;
        if (pgGeometryIf != null && this.isShowing() && (this.m_currentPanel_Id == 1 || this.m_currentPanel_Id == 2 || this.m_currentPanel_Id == 3 || this.m_currentPanel_Id == 4 || this.m_currentPanel_Id == 5 || this.m_currentPanel_Id == 6 || this.m_currentPanel_Id == 7)) {
            psPanel = this.m_oldPanel[this.m_currentPanel_Id];
            this.m_oldPanel[this.m_currentPanel_Id] = null;
        }
        this.removeInspectorPanel(1);
        this.removeInspectorPanel(2);
        this.removeInspectorPanel(3);
        this.removeInspectorPanel(4);
        this.removeInspectorPanel(5);
        this.removeInspectorPanel(6);
        this.removeInspectorPanel(7);
        this.m_geometry = pgGeometryIf;
        if (!this.isShowing()) {
            return;
        }
        if (this.m_currentPanel_Id != 1 && this.m_currentPanel_Id != 2 && this.m_currentPanel_Id != 3 && this.m_currentPanel_Id != 4 && this.m_currentPanel_Id != 5 && this.m_currentPanel_Id != 6 && this.m_currentPanel_Id != 7) {
            return;
        }
        boolean bl = this.reassurePanel(this.m_currentPanel_Id);
        if (psPanel != null) {
            this.m_inspector.remove(psPanel);
        }
        if (!bl && this.m_geometry != null) {
            bl = this.showPanelAtPosition(2);
        }
        if (!bl && this.m_project != null) {
            bl = this.showPanelAtPosition(0);
        }
        if (!bl && this.m_display != null) {
            bl = this.showPanelAtPosition(14);
        }
        if (!bl) {
            this.showPanelAtPosition(15);
        }
    }

    protected PvDisplayIf getDisplay() {
        return this.m_display;
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display == pvDisplayIf) {
            return;
        }
        PsPanel psPanel = null;
        if (pvDisplayIf != null && this.isShowing() && (this.m_currentPanel_Id == 14 || this.m_currentPanel_Id == 13 || this.m_currentPanel_Id == 8 || this.m_currentPanel_Id == 9 || this.m_currentPanel_Id == 10 || this.m_currentPanel_Id == 11 || this.m_currentPanel_Id == 12)) {
            psPanel = this.m_oldPanel[this.m_currentPanel_Id];
            this.m_oldPanel[this.m_currentPanel_Id] = null;
        }
        this.removeInspectorPanel(14);
        this.removeInspectorPanel(13);
        this.removeInspectorPanel(8);
        this.removeInspectorPanel(9);
        this.removeInspectorPanel(10);
        this.removeInspectorPanel(11);
        this.removeInspectorPanel(12);
        this.m_display = pvDisplayIf;
        if (!this.isShowing()) {
            return;
        }
        if (this.m_currentPanel_Id != 14 && this.m_currentPanel_Id != 13 && this.m_currentPanel_Id != 8 && this.m_currentPanel_Id != 9 && this.m_currentPanel_Id != 10 && this.m_currentPanel_Id != 11 && this.m_currentPanel_Id != 12) {
            return;
        }
        boolean bl = this.reassurePanel(this.m_currentPanel_Id);
        if (psPanel != null) {
            this.m_inspector.remove(psPanel);
        }
        if (!bl && this.m_display != null) {
            bl = this.showPanelAtPosition(14);
        }
        if (!bl && this.m_project != null) {
            bl = this.showPanelAtPosition(0);
        }
        if (!bl && this.m_geometry != null) {
            bl = this.showPanelAtPosition(2);
        }
        if (!bl) {
            this.showPanelAtPosition(15);
        }
    }

    private boolean reassurePanel(int n) {
        boolean bl = false;
        if (this.m_project != null && n == 0 || this.m_geometry != null && (n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7) || this.m_display != null && (n == 8 || n == 9 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14)) {
            bl = this.showPanelAtPosition(n);
        }
        return bl;
    }

    public boolean update(Object object) {
        if (this.m_viewer != null) {
            return this.m_viewer.update(this);
        }
        return false;
    }

    private void addInspectorPanel(int n, PsPanel psPanel) {
        if (psPanel == null) {
            return;
        }
        if (this.m_oldPanel[n] == psPanel) {
            return;
        }
        this.removeInspectorPanel(n);
        this.m_oldPanel[n] = psPanel;
        this.m_inspector.add(m_panelName[n], psPanel);
        this.m_inspector.validate();
    }

    private void removeInspectorPanel(int n) {
        if (!this.hasInspectorPanel(n)) {
            return;
        }
        this.m_inspector.remove(this.m_oldPanel[n]);
        this.m_oldPanel[n] = null;
    }

    private boolean hasInspectorPanel(int n) {
        return this.m_oldPanel[n] != null;
    }

    protected void recreatePanels() {
        for (int i = 0; i < 16; ++i) {
            if (!this.hasInspectorPanel(i)) continue;
            this.removeInspectorPanel(i);
        }
        if (!this.isVisible()) {
            return;
        }
        this.showPanelAtPosition(this.m_currentPanel_Id);
    }

    public void componentAdded(ContainerEvent containerEvent) {
    }

    public void componentRemoved(ContainerEvent containerEvent) {
    }

    private void addKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            container.addContainerListener(this);
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.addKeyAndContainerListenerRecursively(componentArray[i]);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 27 && this.m_viewer != null) {
            this.m_viewer.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

