/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrixIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdMatrix
implements Serializable,
PdMatrixIf {
    private int m_size = 0;
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public double[][] m_data;

    public static PdMatrix[] realloc(PdMatrix[] pdMatrixArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 0) {
            return PdMatrix.realloc(pdMatrixArray, n);
        }
        if (pdMatrixArray != null && pdMatrixArray.length == n) {
            for (int i = 0; i < pdMatrixArray.length; ++i) {
                if (pdMatrixArray[i] == null) {
                    pdMatrixArray[i] = new PdMatrix(n2, n3);
                    continue;
                }
                if (pdMatrixArray[i].m_data != null && pdMatrixArray[i].m_data.length == n2 && pdMatrixArray[i].m_data[0].length == n3) continue;
                pdMatrixArray[i].setSize(n2, n3);
            }
            return pdMatrixArray;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        if (pdMatrixArray == null) {
            n5 = 0;
        } else {
            n5 = Math.min(pdMatrixArray.length, n);
            System.arraycopy(pdMatrixArray, 0, pdMatrixArray2, 0, n5);
            for (n4 = 0; n4 < n5; ++n4) {
                if (pdMatrixArray2[n4] == null) {
                    pdMatrixArray2[n4] = new PdMatrix(n2, n3);
                    continue;
                }
                if (pdMatrixArray2[n4].m_data != null && pdMatrixArray2[n4].m_data.length == n2 && pdMatrixArray[n4].m_data[0].length == n3) continue;
                pdMatrixArray2[n4].setSize(n2, n3);
            }
        }
        for (n4 = n5; n4 < n; ++n4) {
            pdMatrixArray2[n4] = new PdMatrix(n2, n3);
        }
        return pdMatrixArray2;
    }

    public static PdMatrix[] realloc(PdMatrix[] pdMatrixArray, int n) {
        int n2;
        int n3;
        if (pdMatrixArray != null && pdMatrixArray.length == n) {
            return pdMatrixArray;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        if (pdMatrixArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdMatrixArray.length, n);
            System.arraycopy(pdMatrixArray, 0, pdMatrixArray2, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                if (pdMatrixArray2[n2] != null) continue;
                pdMatrixArray2[n2] = new PdMatrix();
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            pdMatrixArray2[n2] = new PdMatrix();
        }
        return pdMatrixArray2;
    }

    public Object clone() {
        return PdMatrix.copyNew(this);
    }

    public static PdMatrix[] copyNew(PdMatrix[] pdMatrixArray) {
        if (pdMatrixArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdMatrix.copyNew(pdMatrixArray, pdMatrixArray.length);
    }

    public static PdMatrix[] copyNew(PdMatrix[] pdMatrixArray, int n) {
        if (pdMatrixArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        for (int i = 0; i < n; ++i) {
            pdMatrixArray2[i] = new PdMatrix(pdMatrixArray[i].m_iSize, pdMatrixArray[i].m_jSize);
            pdMatrixArray2[i].copy(pdMatrixArray[i]);
        }
        return pdMatrixArray2;
    }

    public static PdMatrix copyNew(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix pdMatrix2 = new PdMatrix(pdMatrix.m_iSize, pdMatrix.m_jSize);
        pdMatrix2.copy(pdMatrix);
        return pdMatrix2;
    }

    public static boolean copy(PdMatrix[] pdMatrixArray, int n, PdMatrix[] pdMatrixArray2, int n2, int n3) {
        if (pdMatrixArray == null || pdMatrixArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            pdMatrixArray[n + i].copy(pdMatrixArray2[n2 + i]);
        }
        return true;
    }

    public PdMatrix() {
        this(0);
    }

    public PdMatrix(int n) {
        this.setSize(n, n);
    }

    public PdMatrix(int n, int n2) {
        this.setSize(n, n2);
    }

    public PdMatrix(double[][] dArray) {
        this();
        this.set(dArray);
    }

    public void set(double[][] dArray) {
        if (dArray == null || dArray.length == 0) {
            this.setSize(0, 0);
            return;
        }
        if (dArray[0] == null) {
            this.setSize(dArray.length, 0);
            return;
        }
        this.setSize(dArray.length, dArray[0].length);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == null || dArray[i].length != dArray[0].length) {
                PsDebug.warning("non-matrix double array");
                return;
            }
            for (int j = 0; j < dArray[0].length; ++j) {
                this.m_data[i][j] = dArray[i][j];
            }
        }
    }

    public void set(double[] dArray) {
        int n;
        int n2 = n = dArray == null ? 0 : dArray.length;
        if (n < this.m_iSize * this.m_jSize) {
            PsDebug.warning("size of argument vector too small to fill matrix");
            return;
        }
        int n3 = 0;
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = dArray[n3++];
            }
        }
    }

    public int getNumRows() {
        return this.getISize();
    }

    public int getNumCols() {
        return this.getJSize();
    }

    public int getISize() {
        return this.m_iSize;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.m_iSize == this.m_jSize) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int n) {
        this.setSize(n, n);
    }

    public void setSize(int n, int n2) {
        int n3;
        if (this.m_iSize == n && this.m_jSize == n2) {
            return;
        }
        double[][] dArrayArray = new double[n][];
        int n4 = Math.min(this.m_iSize, n);
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            dArrayArray[n3] = PuData.realloc(this.m_data[n3], n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            dArrayArray[n3] = new double[n2];
        }
        this.m_size = n;
        this.m_iSize = n;
        this.m_jSize = n2;
        this.m_data = dArrayArray;
    }

    public double[][] getEntries() {
        double[][] dArrayArray = new double[this.m_iSize][];
        for (int i = 0; i < this.m_iSize; ++i) {
            dArrayArray[i] = (double[])this.m_data[i].clone();
        }
        return dArrayArray;
    }

    public double getEntry(int n, int n2) {
        if (n < 0 || this.m_iSize <= n) {
            PsDebug.warning("index i out of range, index=" + n);
            return 0.0;
        }
        if (n2 < 0 || this.m_jSize <= n2) {
            PsDebug.warning("index j out of range, index=" + n2);
            return 0.0;
        }
        return this.m_data[n][n2];
    }

    public void setEntry(int n, int n2, double d) {
        if (this.m_iSize <= n) {
            this.setSize(n + 1, this.m_jSize);
        }
        if (this.m_jSize <= n2) {
            this.setSize(this.m_iSize, n2 + 1);
        }
        this.m_data[n][n2] = d;
    }

    public void addEntry(int n, int n2, double d) {
        if (this.m_iSize <= n || this.m_jSize <= n2) {
            this.setSize(n + 1, n2 + 1);
        }
        double[] dArray = this.m_data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public void setIdentity() {
        this.setConstant(0.0);
        this.setDiagonal(1.0);
    }

    public void setConstant(double d) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = d;
            }
        }
    }

    public void clear() {
        this.setConstant(0.0);
    }

    public void setDiagonal(double d) {
        for (int i = 0; i < this.m_size; ++i) {
            this.m_data[i][i] = d;
        }
    }

    public void setDiagonal(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.getSize() < this.m_size) {
            PsDebug.warning("vector too small");
            return;
        }
        for (int i = 0; i < this.m_size; ++i) {
            this.m_data[i][i] = pdVector.m_data[i];
        }
    }

    public PdVector getRow(int n) {
        if (n < 0 || n >= this.m_iSize) {
            PsDebug.warning("invalid row index");
            return null;
        }
        PdVector pdVector = new PdVector(this.m_jSize);
        for (int i = 0; i < this.m_jSize; ++i) {
            pdVector.m_data[i] = this.m_data[n][i];
        }
        return pdVector;
    }

    public void setRow(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_iSize || pdVector.getSize() != this.m_jSize) {
            PsDebug.warning("invalid row index or vector size");
            return;
        }
        for (int i = 0; i < this.m_jSize; ++i) {
            this.m_data[n][i] = pdVector.m_data[i];
        }
    }

    public PdVector getColumn(int n) {
        if (n < 0 || n >= this.m_jSize) {
            PsDebug.warning("invalid column index");
            return null;
        }
        PdVector pdVector = new PdVector(this.m_iSize);
        for (int i = 0; i < this.m_iSize; ++i) {
            pdVector.m_data[i] = this.m_data[i][n];
        }
        return pdVector;
    }

    public void setColumn(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_jSize || pdVector.getSize() != this.m_iSize) {
            PsDebug.warning("invalid column index or vector size");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            this.m_data[i][n] = pdVector.m_data[i];
        }
    }

    public void setRows(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length < this.m_iSize) {
            PsDebug.warning("missing vector list, or invalid number of rows");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            this.setRow(i, pdVectorArray[i]);
        }
    }

    public void setColumns(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length < this.m_jSize) {
            PsDebug.warning("missing vector list, or invalid number of columns");
            return;
        }
        for (int i = 0; i < this.m_jSize; ++i) {
            this.setColumn(i, pdVectorArray[i]);
        }
    }

    public void add(PdMatrix pdMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                double[] dArray = this.m_data[i];
                int n = j;
                dArray[n] = dArray[n] + pdMatrix.m_data[i][j];
            }
        }
    }

    public void add(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdMatrix.m_data[i][j] + pdMatrix2.m_data[i][j];
            }
        }
    }

    public void sub(PdMatrix pdMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                double[] dArray = this.m_data[i];
                int n = j;
                dArray[n] = dArray[n] - pdMatrix.m_data[i][j];
            }
        }
    }

    public void sub(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdMatrix.m_data[i][j] - pdMatrix2.m_data[i][j];
            }
        }
    }

    public void copy(PdMatrix pdMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdMatrix.m_data[i][j];
            }
        }
    }

    public void multScalar(double d) {
        for (int i = 0; i < this.m_iSize; ++i) {
            int n = 0;
            while (n < this.m_jSize) {
                double[] dArray = this.m_data[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public void multScalar(PdMatrix pdMatrix, double d) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdMatrix.m_data[i][j] * d;
            }
        }
    }

    public double det() {
        double[][] dArray = this.m_data;
        switch (this.m_size) {
            case 1: {
                return dArray[0][0];
            }
            case 2: {
                return dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            }
            case 3: {
                return dArray[0][0] * (dArray[1][1] * dArray[2][2] - dArray[2][1] * dArray[1][2]) - dArray[0][1] * (dArray[1][0] * dArray[2][2] - dArray[2][0] * dArray[1][2]) + dArray[0][2] * (dArray[1][0] * dArray[2][1] - dArray[2][0] * dArray[1][1]);
            }
            case 4: {
                return dArray[0][0] * (dArray[1][1] * (dArray[2][2] * dArray[3][3] - dArray[3][2] * dArray[2][3]) - dArray[1][2] * (dArray[2][1] * dArray[3][3] - dArray[3][1] * dArray[2][3]) + dArray[1][3] * (dArray[2][1] * dArray[3][2] - dArray[3][1] * dArray[2][2])) - dArray[0][1] * (dArray[1][0] * (dArray[2][2] * dArray[3][3] - dArray[3][2] * dArray[2][3]) - dArray[1][2] * (dArray[2][0] * dArray[3][3] - dArray[3][0] * dArray[2][3]) + dArray[1][3] * (dArray[2][0] * dArray[3][2] - dArray[3][0] * dArray[2][2])) + dArray[0][2] * (dArray[1][0] * (dArray[2][1] * dArray[3][3] - dArray[3][1] * dArray[2][3]) - dArray[1][1] * (dArray[2][0] * dArray[3][3] - dArray[3][0] * dArray[2][3]) + dArray[1][3] * (dArray[2][0] * dArray[3][1] - dArray[3][0] * dArray[2][1])) - dArray[0][3] * (dArray[1][0] * (dArray[2][1] * dArray[3][2] - dArray[3][1] * dArray[2][2]) - dArray[1][1] * (dArray[2][0] * dArray[3][2] - dArray[3][0] * dArray[2][2]) + dArray[1][2] * (dArray[2][0] * dArray[3][1] - dArray[3][0] * dArray[2][1]));
            }
        }
        PsDebug.warning("not implemented for m_size>4");
        return 1.0;
    }

    public double det33() {
        double[][] dArray = this.m_data;
        if (this.m_size < 3) {
            PsDebug.warning("not implemented for m_size<3");
            return 1.0;
        }
        return dArray[0][0] * (dArray[1][1] * dArray[2][2] - dArray[2][1] * dArray[1][2]) - dArray[0][1] * (dArray[1][0] * dArray[2][2] - dArray[2][0] * dArray[1][2]) + dArray[0][2] * (dArray[1][0] * dArray[2][1] - dArray[2][0] * dArray[1][1]);
    }

    public void leftMult(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null || pdMatrix.m_iSize < n || pdMatrix.m_jSize < n) {
            PsDebug.warning("size of parameter matrix too large");
            return;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = 0.0;
                for (int j = 0; j < n; ++j) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + pdMatrix.m_data[n2][j] * this.m_data[j][i];
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.m_data[n2][i] = dArray[n2];
            }
        }
    }

    public void leftMult(PdMatrix pdMatrix) {
        if (pdMatrix == null || pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_jSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] dArray = new double[this.m_iSize];
        for (int i = 0; i < this.m_jSize; ++i) {
            int n;
            for (n = 0; n < this.m_iSize; ++n) {
                dArray[n] = 0.0;
                for (int j = 0; j < this.m_iSize; ++j) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] + pdMatrix.m_data[n][j] * this.m_data[j][i];
                }
            }
            for (n = 0; n < this.m_iSize; ++n) {
                this.m_data[n][i] = dArray[n];
            }
        }
    }

    public void rightMult(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null || pdMatrix.m_iSize < n || pdMatrix.m_jSize < n) {
            PsDebug.warning("size of parameter matrix too large");
            return;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = 0.0;
                for (int j = 0; j < n; ++j) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + this.m_data[i][j] * pdMatrix.m_data[j][n2];
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.m_data[i][n2] = dArray[n2];
            }
        }
    }

    public void rightMult(PdMatrix pdMatrix) {
        if (pdMatrix == null || pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] dArray = new double[this.m_jSize];
        for (int i = 0; i < this.m_iSize; ++i) {
            int n;
            for (n = 0; n < this.m_jSize; ++n) {
                dArray[n] = 0.0;
                for (int j = 0; j < this.m_jSize; ++j) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] + this.m_data[i][j] * pdMatrix.m_data[j][n];
                }
            }
            for (n = 0; n < this.m_jSize; ++n) {
                this.m_data[i][n] = dArray[n];
            }
        }
    }

    public void mult(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this == pdMatrix || this == pdMatrix2) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        int n = pdMatrix.m_iSize;
        int n2 = pdMatrix2.m_jSize;
        int n3 = pdMatrix.m_jSize;
        if (n3 != pdMatrix2.m_iSize) {
            PsDebug.warning("Number of columns in first matrix differs from number of rows in second matrix!");
            return;
        }
        if (this.m_iSize != n || this.m_jSize != n2) {
            this.setSize(n, n2);
        }
        this.setConstant(0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (pdMatrix.m_data[i][j] == 0.0) continue;
                for (int k = 0; k < n2; ++k) {
                    double[] dArray = this.m_data[i];
                    int n4 = k;
                    dArray[n4] = dArray[n4] + pdMatrix.m_data[i][j] * pdMatrix2.m_data[j][k];
                }
            }
        }
    }

    public PdVector leftMultMatrix(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            PsDebug.warning("missing input vector.");
            return null;
        }
        int n = this.getNumRows();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        pdVector.leftMultMatrix(this, pdVector2);
        return pdVector;
    }

    public PdVector rightMultMatrix(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            PsDebug.warning("missing input vector.");
            return null;
        }
        int n = this.getNumCols();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        pdVector.rightMultMatrix(pdVector2, this);
        return pdVector;
    }

    public void transpose() {
        if (!this.isSquare()) {
            PsDebug.warning("matrix is not square.");
            return;
        }
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = i + 1; j < this.m_size; ++j) {
                double d = this.m_data[i][j];
                this.m_data[i][j] = this.m_data[j][i];
                this.m_data[j][i] = d;
            }
        }
    }

    public void transpose(PdMatrix pdMatrix) {
        if (this.m_iSize != pdMatrix.m_jSize || this.m_jSize != pdMatrix.m_iSize) {
            PsDebug.warning("sizes of this matrix and argument matrix do not match.");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdMatrix.m_data[j][i];
            }
        }
    }

    public boolean invert() {
        PdMatrix pdMatrix = new PdMatrix(this.m_size);
        pdMatrix.copy(this);
        return this.invert(pdMatrix);
    }

    public boolean invert(PdMatrix pdMatrix) {
        if (this.m_size != pdMatrix.m_size) {
            PsDebug.warning("different size of this matrix and argument matrix.");
            return false;
        }
        double d = 1.0;
        if (1 <= this.m_size && this.m_size <= 4) {
            d = pdMatrix.det();
            if (Math.abs(d) < 1.0E-10) {
                this.setIdentity();
                return false;
            }
        } else {
            PsDebug.warning("cannot invert matrix of size = " + String.valueOf(this.m_size));
            return false;
        }
        switch (this.m_size) {
            case 1: {
                this.m_data[0][0] = 1.0 / d;
                break;
            }
            case 2: {
                this.m_data[0][0] = pdMatrix.m_data[1][1] / d;
                this.m_data[0][1] = -pdMatrix.m_data[0][1] / d;
                this.m_data[1][0] = -pdMatrix.m_data[1][0] / d;
                this.m_data[1][1] = pdMatrix.m_data[0][0] / d;
                break;
            }
            case 3: {
                this.m_data[0][0] = (pdMatrix.m_data[1][1] * pdMatrix.m_data[2][2] - pdMatrix.m_data[2][1] * pdMatrix.m_data[1][2]) / d;
                this.m_data[0][1] = (pdMatrix.m_data[0][2] * pdMatrix.m_data[2][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[2][2]) / d;
                this.m_data[0][2] = (pdMatrix.m_data[0][1] * pdMatrix.m_data[1][2] - pdMatrix.m_data[0][2] * pdMatrix.m_data[1][1]) / d;
                this.m_data[1][0] = (pdMatrix.m_data[1][2] * pdMatrix.m_data[2][0] - pdMatrix.m_data[1][0] * pdMatrix.m_data[2][2]) / d;
                this.m_data[1][1] = (pdMatrix.m_data[0][0] * pdMatrix.m_data[2][2] - pdMatrix.m_data[0][2] * pdMatrix.m_data[2][0]) / d;
                this.m_data[1][2] = (pdMatrix.m_data[0][2] * pdMatrix.m_data[1][0] - pdMatrix.m_data[0][0] * pdMatrix.m_data[1][2]) / d;
                this.m_data[2][0] = (pdMatrix.m_data[1][0] * pdMatrix.m_data[2][1] - pdMatrix.m_data[1][1] * pdMatrix.m_data[2][0]) / d;
                this.m_data[2][1] = (pdMatrix.m_data[0][1] * pdMatrix.m_data[2][0] - pdMatrix.m_data[0][0] * pdMatrix.m_data[2][1]) / d;
                this.m_data[2][2] = (pdMatrix.m_data[0][0] * pdMatrix.m_data[1][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[1][0]) / d;
                break;
            }
            case 4: {
                int n;
                int n2;
                double[] dArray = new double[4];
                double[][] dArrayArray = new double[4][];
                for (n2 = 0; n2 < 4; ++n2) {
                    dArrayArray[n2] = (double[])pdMatrix.m_data[n2].clone();
                }
                this.setIdentity();
                for (n2 = 0; n2 < 4; ++n2) {
                    int n3;
                    int n4 = n2;
                    for (n = n2 + 1; n < 4; ++n) {
                        if (!(Math.abs(dArrayArray[n][n2]) > Math.abs(dArrayArray[n4][n2]))) continue;
                        n4 = n;
                    }
                    if (dArrayArray[n4][n2] == 0.0) {
                        return false;
                    }
                    if (n4 != n2) {
                        for (n = 0; n < 4; ++n) {
                            dArray[n] = dArrayArray[n4][n];
                            dArrayArray[n4][n] = dArrayArray[n2][n];
                            dArrayArray[n2][n] = dArray[n];
                        }
                        for (n = 0; n < 4; ++n) {
                            dArray[n] = this.m_data[n4][n];
                            this.m_data[n4][n] = this.m_data[n2][n];
                            this.m_data[n2][n] = dArray[n];
                        }
                    }
                    for (n = 0; n < 4; ++n) {
                        dArray[n] = dArrayArray[n][n2] / dArrayArray[n2][n2];
                    }
                    for (n = 0; n < n2; ++n) {
                        for (n3 = 0; n3 < 4; ++n3) {
                            double[] dArray2 = dArrayArray[n];
                            int n5 = n3;
                            dArray2[n5] = dArray2[n5] - dArrayArray[n2][n3] * dArray[n];
                        }
                        for (n3 = 0; n3 < 4; ++n3) {
                            double[] dArray3 = this.m_data[n];
                            int n6 = n3;
                            dArray3[n6] = dArray3[n6] - this.m_data[n2][n3] * dArray[n];
                        }
                    }
                    for (n = n2 + 1; n < 4; ++n) {
                        for (n3 = 0; n3 < 4; ++n3) {
                            double[] dArray4 = dArrayArray[n];
                            int n7 = n3;
                            dArray4[n7] = dArray4[n7] - dArrayArray[n2][n3] * dArray[n];
                        }
                        for (n3 = 0; n3 < 4; ++n3) {
                            double[] dArray5 = this.m_data[n];
                            int n8 = n3;
                            dArray5[n8] = dArray5[n8] - this.m_data[n2][n3] * dArray[n];
                        }
                    }
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    n = 0;
                    while (n < 4) {
                        double[] dArray6 = this.m_data[n2];
                        int n9 = n++;
                        dArray6[n9] = dArray6[n9] / dArrayArray[n2][n2];
                    }
                }
                break;
            }
        }
        return true;
    }

    public boolean invertTopLeft(PdMatrix pdMatrix, int n) {
        int n2;
        int n3;
        if (this.m_size < n || pdMatrix.m_size < n) {
            PsDebug.warning("method 'invertTopLeft' not applicable");
            return false;
        }
        PdMatrix pdMatrix2 = new PdMatrix(n);
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                pdMatrix2.m_data[n3][n2] = pdMatrix.m_data[n3][n2];
            }
        }
        if (!pdMatrix2.invert()) {
            PsDebug.warning("matrix singular");
            this.setIdentity();
            return false;
        }
        this.copy(pdMatrix);
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                this.m_data[n3][n2] = pdMatrix2.m_data[n3][n2];
            }
        }
        return true;
    }

    public boolean invert34(PdMatrix pdMatrix) {
        if (!this.invertTopLeft(pdMatrix, 3)) {
            PsDebug.warning("matrix singular");
            this.setIdentity();
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            this.m_data[i][3] = 0.0;
            for (int j = 0; j < 3; ++j) {
                double[] dArray = this.m_data[i];
                dArray[3] = dArray[3] - this.m_data[i][j] * pdMatrix.m_data[j][3];
            }
        }
        return true;
    }

    public boolean adjoint(PdVector pdVector) {
        return this.adjoint(pdVector, pdVector);
    }

    public boolean adjoint(PdVector pdVector, PdVector pdVector2) {
        if (this.m_iSize != pdVector.m_data.length || this.m_jSize != pdVector2.m_data.length) {
            this.setSize(pdVector.m_data.length, pdVector2.m_data.length);
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = pdVector.m_data[i] * pdVector2.m_data[j];
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("PdMatrix\n");
        stringBuffer.append("\t m_iSize = " + this.m_iSize + ", m_jSize = " + this.m_jSize + ", m_size  = " + this.m_size + "\n");
        stringBuffer.append(this.toShortString());
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_iSize > 0) {
            for (int i = 0; i < this.m_iSize; ++i) {
                stringBuffer.append("\t [" + PuString.intToString(i, 4) + "] = ");
                if (this.m_jSize > 0) {
                    stringBuffer.append("{ " + String.valueOf(this.m_data[i][0]));
                    for (int j = 1; j < this.m_jSize; ++j) {
                        stringBuffer.append(", " + String.valueOf(this.m_data[i][j]));
                    }
                    stringBuffer.append("}\n");
                    continue;
                }
                if (this.m_data[i] != null) {
                    stringBuffer.append("{}\n");
                    continue;
                }
                stringBuffer.append("null\n");
            }
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public static PdMatrix expandComponents(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument matrix");
            return null;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize) {
            PsDebug.warning("argument matrix not square");
            return null;
        }
        int n2 = pdMatrix.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n2 * n);
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            for (int j = 0; j < n2; ++j) {
                int n4 = j * n;
                for (int k = 0; k < n; ++k) {
                    pdMatrix2.m_data[n3 + k][n4 + k] = pdMatrix.m_data[i][j];
                }
            }
        }
        return pdMatrix2;
    }

    public void blend(double d, PdMatrix pdMatrix, double d2, PdMatrix pdMatrix2, double d3, PdMatrix pdMatrix3) {
        if (pdMatrix == null || pdMatrix2 == null || pdMatrix3 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.getISize() == 0 || this.getJSize() == 0) {
            this.setSize(pdMatrix.getISize(), pdMatrix.getJSize());
        }
        int n = this.getISize();
        int n2 = this.getJSize();
        if (n < pdMatrix.m_data.length || n < pdMatrix2.m_data.length || n < pdMatrix3.m_data.length || n2 < pdMatrix.m_data[0].length || n2 < pdMatrix2.m_data[0].length || n2 < pdMatrix3.m_data[0].length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_data[i][j] = d * pdMatrix.m_data[i][j] + d2 * pdMatrix2.m_data[i][j] + d3 * pdMatrix3.m_data[i][j];
            }
        }
    }

    public void blend(PdBary pdBary, PdMatrix pdMatrix, PdMatrix pdMatrix2, PdMatrix pdMatrix3) {
        if (pdBary.m_data == null || pdBary.m_data.length < 3) {
            PsDebug.warning("argument bary has wrong size");
            return;
        }
        this.blend(pdBary.m_data[0], pdMatrix, pdBary.m_data[1], pdMatrix2, pdBary.m_data[2], pdMatrix3);
    }

    public double multQuadratic(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null || pdVector.getSize() != this.m_iSize || pdVector2.getSize() != this.m_jSize) {
            PsDebug.warning("Illegal argument to PdMatrix#multQuadratic(PdVector, PdVector).");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.m_iSize; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m_jSize; ++j) {
                d2 += this.m_data[i][j] * pdVector2.m_data[j];
            }
            d += pdVector.m_data[i] * d2;
        }
        return d;
    }
}

