/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PuData;

public final class PsAuthorInfo
extends PsObject {
    public static final int FIRST_NAME = 0;
    public static final int LAST_NAME = 1;
    public static final int ORGANIZATION = 2;
    public static final int ADDRESS = 3;
    public static final int EMAIL = 4;
    public static final int URL = 5;
    private static final int m_numCodes = 6;
    protected int m_maxNumAuthors;
    protected int m_numAuthors;
    protected int m_currAuthor;
    protected String m_profession = "Author";
    protected String[][] m_info = new String[6][];
    protected boolean m_bEnableLoading = false;

    public PsAuthorInfo() {
        this.init();
    }

    public void init() {
        super.init();
        this.m_maxNumAuthors = 0;
        this.m_numAuthors = 0;
        this.m_currAuthor = 0;
        for (int i = 0; i < 6; ++i) {
            this.m_info[i] = null;
        }
    }

    public Object clone() {
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)super.clone();
        if (psAuthorInfo == null) {
            return null;
        }
        if (this.m_info != null) {
            psAuthorInfo.m_info = PuString.clone(this.m_info);
        }
        return psAuthorInfo;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PsAuthorInfo)) {
            return;
        }
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)psObject;
        this.m_maxNumAuthors = psAuthorInfo.m_maxNumAuthors;
        this.m_numAuthors = psAuthorInfo.m_numAuthors;
        this.m_currAuthor = psAuthorInfo.m_currAuthor;
        this.m_profession = psAuthorInfo.m_profession;
        this.m_info = PuString.clone(psAuthorInfo.m_info);
        this.m_bEnableLoading = psAuthorInfo.m_bEnableLoading;
    }

    public int getSelectedAuthor() {
        return this.m_currAuthor;
    }

    public void setSelectedAuthor(int n) {
        this.m_currAuthor = n;
    }

    protected static int getNumCodes() {
        return 6;
    }

    public int getMaxNumAuthors() {
        return this.m_maxNumAuthors;
    }

    public void setMaxNumAuthors(int n) {
        this.m_maxNumAuthors = n;
        if (this.m_maxNumAuthors > 0 && this.m_numAuthors > this.m_maxNumAuthors) {
            this.setNumAuthors(this.m_maxNumAuthors);
        }
    }

    public int getNumAuthors() {
        return this.m_numAuthors;
    }

    public void setNumAuthors(int n) {
        if (this.m_maxNumAuthors > 0 && n > this.m_maxNumAuthors) {
            n = this.m_maxNumAuthors;
        }
        if (this.m_numAuthors == n) {
            return;
        }
        this.m_numAuthors = n;
        for (int i = 0; i < 6; ++i) {
            this.m_info[i] = PuData.realloc(this.m_info[i], n);
        }
    }

    public boolean isEnabledLoading() {
        return this.m_bEnableLoading;
    }

    public void setEnabledLoading(boolean bl) {
        this.m_bEnableLoading = bl;
    }

    public String getProfession() {
        return this.m_profession;
    }

    public void setProfession(String string) {
        this.m_profession = string;
    }

    public String getInfo(int n, int n2) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        if (n2 < 0 || 6 <= n2) {
            PsDebug.warning("index out of range, code = " + n2);
            return null;
        }
        return this.m_info[n2][n];
    }

    public void setInfo(int n, int n2, String string) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range][ind = " + n);
            return;
        }
        this.m_info[n2][n] = string;
    }

    public String toString() {
        String string = null;
        if (this.m_numAuthors == 1) {
            for (int i = 0; i < this.m_numAuthors; ++i) {
                String[] stringArray;
                string = this.m_info[0][i] + " " + this.m_info[1][i] + "\n";
                if (!PuString.isEmpty(this.m_info[2][i])) {
                    string = string + this.m_info[2][i] + "\n";
                }
                if (!PuString.isEmpty(this.m_info[3][i]) && (stringArray = PuString.splitString(this.m_info[3][i], '\n')) != null && stringArray.length > 0) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        string = string + stringArray[j] + "\n";
                    }
                }
                if (this.m_info[4][i] != null) {
                    string = string + this.m_info[4][i] + "\n";
                }
                if (this.m_info[5][i] == null) continue;
                string = string + this.m_info[5][i] + "\n";
            }
        } else if (this.m_numAuthors > 1) {
            string = "";
            for (int i = 0; i < this.m_numAuthors; ++i) {
                string = string + this.m_info[0][i] + " " + this.m_info[1][i] + "\n";
            }
        }
        if (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public PsXmlNode getXmlNode() {
        PsXmlNode psXmlNode = new PsXmlNode("authors");
        for (int i = 0; i < this.m_numAuthors; ++i) {
            PsXmlNode psXmlNode2 = psXmlNode.addChild(this.m_profession.toLowerCase());
            psXmlNode2.addChild("firstname", this.m_info[0][i]);
            psXmlNode2.addChild("lastname", this.m_info[1][i]);
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("affiliation");
            psXmlNode3.addChild("organization", this.m_info[2][i]);
            PsXmlNode psXmlNode4 = psXmlNode3.addChild("address");
            if (!PuString.isEmpty(this.m_info[3][i])) {
                String[] stringArray = PuString.splitString(this.m_info[3][i], '\n');
                if (stringArray != null && stringArray.length > 0) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        psXmlNode4.addChild("line", stringArray[j]);
                    }
                }
            } else {
                psXmlNode4.addChild("line", "");
            }
            psXmlNode2.addChild("email", this.m_info[4][i]);
            psXmlNode2.addChild("url", this.m_info[5][i]);
        }
        return psXmlNode;
    }

    public int setXmlNode(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing method argument.");
            return 0;
        }
        String string = psXmlNode.getType();
        if (string == null || !string.equals("authors")) {
            PsDebug.error("source node has wrong type = " + string);
            return 0;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, this.m_profession.toLowerCase());
        int n = 0;
        if (psXmlNodeArray != null) {
            this.setMaxNumAuthors(psXmlNodeArray.length);
            this.setNumAuthors(psXmlNodeArray.length);
            int n2 = 0;
            for (int i = 0; i < psXmlNodeArray.length; ++i) {
                String string2 = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "lastname");
                if (PuString.isEmpty(string2)) continue;
                this.m_info[0][n2] = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "firstname");
                this.m_info[1][n2] = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "lastname");
                this.m_info[2][n2] = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "organization");
                PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n2], "address");
                PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "line");
                if (psXmlNodeArray2 == null) {
                    psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "l");
                    if (psXmlNodeArray2 != null) {
                        PsDebug.warning("usage of deprecated address <l> element tag found.\n\tPlease, replace all occurrences of <l> with new tag <line>.");
                    } else {
                        PsDebug.warning("<address> element must contain at least one <line> element.");
                    }
                }
                this.m_info[3][n2] = "";
                if (psXmlNodeArray2 != null && psXmlNodeArray2.length > 0) {
                    for (int j = 0; j < psXmlNodeArray2.length; ++j) {
                        if (psXmlNodeArray2[j].getContent() == null) continue;
                        if (!PuString.isEmpty(this.m_info[3][n2])) {
                            String[] stringArray = this.m_info[3];
                            int n3 = n2;
                            stringArray[n3] = stringArray[n3] + "\n";
                        }
                        String[] stringArray = this.m_info[3];
                        int n4 = n2;
                        stringArray[n4] = stringArray[n4] + psXmlNodeArray2[j].getContent();
                    }
                }
                this.m_info[4][n2] = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "email");
                this.m_info[5][n2] = PsXmlSrc.getRsrc(psXmlNodeArray[n2], "url");
                ++n2;
            }
            n = n2;
        } else {
            PsDebug.warning("missing authors.");
        }
        this.setNumAuthors(n);
        return n;
    }
}

