/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.vecmath.PiVector;

public class PuColorPicker
extends PsPanel
implements MouseListener,
MouseMotionListener {
    private static final int m_preferredWidth = 600;
    private static final int m_preferredHeight = 220;
    protected PuInteger m_red;
    protected PuInteger m_green;
    protected PuInteger m_blue;
    protected PuInteger m_bright;
    protected int m_prevBright = -1;
    protected final int m_wheelWidth = 176;
    protected final int m_wheelHeight = 176;
    protected PiVector m_pix;
    protected MemoryImageSource m_mis;
    protected PsPanel m_pWheel;
    protected PsPanel m_pDefColor;
    protected PsPanel m_pNewColor;
    protected Color m_defColor;
    static /* synthetic */ Class class$jv$number$PuColorPicker;

    public PuColorPicker(Color color) {
        this.setLayout(new BorderLayout());
        this.setInsetSize(8);
        if (color == null) {
            color = Color.white;
        }
        this.m_defColor = color;
        this.m_pix = new PiVector(30976);
        this.m_mis = new MemoryImageSource(176, 176, this.m_pix.m_data, 0, 176);
        this.m_mis.setAnimated(true);
        Panel panel = new Panel(new FlowLayout());
        this.m_pWheel = new PsPanel();
        this.m_pWheel.setInsetSize(2);
        this.m_pWheel.setPreferredSize(176, 176);
        this.m_pWheel.setBorderType(2);
        this.m_pWheel.setImage(PsConfig.getFrame().createImage(this.m_mis));
        this.m_pWheel.addMouseListener(this);
        this.m_pWheel.addMouseMotionListener(this);
        this.m_pWheel.validate();
        panel.add(this.m_pWheel);
        this.add((Component)panel, "West");
        PsPanel psPanel = new PsPanel(new PsStackLayout(5));
        psPanel.setInsetSize(5);
        psPanel.addTitle(PsConfig.getMessage(24121));
        PsPanel psPanel2 = new PsPanel(new BorderLayout());
        PsPanel psPanel3 = new PsPanel(new PsStackLayout(10));
        psPanel3.setInsetSize(2);
        this.m_pDefColor = new PsPanel(null);
        this.m_pDefColor.addMouseListener(this);
        this.m_pDefColor.setBorderType(3);
        this.m_pDefColor.setPreferredSize(40, 60);
        this.m_pDefColor.setBackColor(this.m_defColor);
        psPanel3.add(this.m_pDefColor);
        this.m_pNewColor = new PsPanel(null);
        this.m_pNewColor.setBorderType(3);
        this.m_pNewColor.setPreferredSize(40, 60);
        this.m_pNewColor.setBackColor(this.m_defColor);
        psPanel3.add(this.m_pNewColor);
        psPanel2.add((Component)psPanel3, "West");
        PsPanel psPanel4 = new PsPanel(new PsStackLayout(3));
        psPanel4.setInsetSize(2);
        this.m_red = new PuInteger(PsConfig.getMessage(24122), this);
        psPanel4.add(this.m_red.getInfoPanel());
        this.m_green = new PuInteger(PsConfig.getMessage(24123), this);
        psPanel4.add(this.m_green.getInfoPanel());
        this.m_blue = new PuInteger(PsConfig.getMessage(24124), this);
        psPanel4.add(this.m_blue.getInfoPanel());
        psPanel4.addLine(1);
        this.m_bright = new PuInteger(PsConfig.getMessage(24125), this);
        psPanel4.add(this.m_bright.getInfoPanel());
        psPanel4.addLine(1);
        psPanel2.add((Component)psPanel4, "Center");
        psPanel.add(psPanel2);
        this.add((Component)psPanel, "Center");
        this.validate();
        if (this.getClass() == (class$jv$number$PuColorPicker == null ? (class$jv$number$PuColorPicker = PuColorPicker.class$("jv.number.PuColorPicker")) : class$jv$number$PuColorPicker)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_red.setDefBounds(0, 255, 1, 10);
        this.m_red.setDefValue(this.m_defColor.getRed());
        this.m_red.init();
        this.m_green.setDefBounds(0, 255, 1, 10);
        this.m_green.setDefValue(this.m_defColor.getGreen());
        this.m_green.init();
        this.m_blue.setDefBounds(0, 255, 1, 10);
        this.m_blue.setDefValue(this.m_defColor.getBlue());
        this.m_blue.init();
        this.m_bright.setDefBounds(0, 255, 1, 10);
        this.m_bright.setDefValue(0);
        this.m_bright.init();
        this.setColor(this.m_defColor);
        this.update(this);
    }

    private Color colorAt(int n, int n2) {
        if (this.m_pix == null || this.m_pix.getSize() == 0) {
            PsDebug.warning("missing or empty pixel array m_pix");
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= 176) {
            n = 175;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 176) {
            n2 = 175;
        }
        int n3 = this.m_pix.getEntry(n + n2 * 176);
        return new Color(n3);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.m_pWheel) {
            this.setColor(this.colorAt(mouseEvent.getX(), mouseEvent.getY()));
        } else if (object == this.m_pDefColor) {
            this.setColor(this.m_defColor);
        }
        this.update(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public Color getDefColor() {
        return this.m_defColor;
    }

    public void setDefColor(Color color) {
        this.m_defColor = color;
    }

    public Color getColor() {
        return this.m_pNewColor.getBackground();
    }

    public void setColor(Color color) {
        this.m_red.setValue(color.getRed());
        this.m_green.setValue(color.getGreen());
        this.m_blue.setValue(color.getBlue());
        int n = Math.max(this.m_red.getValue(), Math.max(this.m_green.getValue(), this.m_blue.getValue()));
        if (n != this.m_bright.getValue()) {
            this.m_bright.setValue(n);
        }
        this.m_pNewColor.setBackColor(color);
    }

    protected void setBrightness(int n) {
        int n2 = Math.max(this.m_red.getValue(), Math.max(this.m_green.getValue(), this.m_blue.getValue()));
        if (n2 == n) {
            return;
        }
        if (n2 == 0) {
            this.setColor(new Color(n, n, n));
        } else {
            double d = (double)n / (double)n2;
            int n3 = (int)((double)this.m_red.getValue() * d + 0.5);
            int n4 = (int)((double)this.m_green.getValue() * d + 0.5);
            int n5 = (int)((double)this.m_blue.getValue() * d + 0.5);
            this.setColor(new Color(n3, n4, n5));
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            if (this.m_prevBright != this.m_bright.getValue()) {
                PuColorPicker.getWheel(176, 176, this.m_bright.getValue(), this.m_pix.m_data);
                this.m_mis.newPixels();
                this.m_prevBright = this.m_bright.getValue();
                this.m_pWheel.repaint();
                this.repaint();
            } else {
                this.m_pNewColor.repaint();
            }
            return super.update(this);
        }
        if (object == this.m_red || object == this.m_green || object == this.m_blue) {
            this.setColor(new Color(this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue()));
            return this.update(this);
        }
        if (object == this.m_bright) {
            this.setBrightness(this.m_bright.getValue());
            return this.update(this);
        }
        return super.update(object);
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 220);
    }

    public static int[] getWheelAsInt(int n, int n2, int n3, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n * n2];
        }
        int n4 = 0;
        int n5 = (n >> 1) - 1;
        int n6 = (n2 >> 1) - 1;
        int n7 = n5;
        int n8 = -16777216;
        int n9 = n8 | 0xFF0000 | 0xFF00 | 0xFF;
        int n10 = n8 | 0xC00000 | 0xC000 | 0xC0;
        int n11 = n8 | 0x550000 | 0x5500 | 0x55;
        int n12 = n8;
        int n13 = n6;
        for (int i = 0; i < n2; ++i) {
            int n14 = -n5;
            for (int j = 0; j < n; ++j) {
                int n15;
                if (n7 == 0) {
                    n15 = n9;
                } else {
                    int n16 = (int)(255.0 * Math.sqrt(n14 * n14 + n13 * n13) / (double)n7 + 0.5);
                    int n17 = (int)(255.0 * (Math.atan2(-n13, -n14) + Math.PI) / (Math.PI * 2) + 0.5);
                    n15 = n16 > 255 ? (n14 < 0 && n13 > 0 ? n9 : (n14 > 0 && n13 > 0 ? n10 : (n14 < 0 && n13 < 0 ? n11 : n12))) : PdColor.hsv2rgbAsInt(n17, n16, n3);
                }
                nArray[n4++] = n15;
                ++n14;
            }
            --n13;
        }
        return nArray;
    }

    public static Image getWheel(int n, int n2, int n3, int[] nArray) {
        nArray = PuColorPicker.getWheelAsInt(n, n2, n3, nArray);
        return PsConfig.getFrame().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

