/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PvCameraIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PvDisplayLoader {
    protected BitSet m_geometryOption;
    private int m_jvdVersion = Integer.MAX_VALUE;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public static PvDisplayOption[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        PvDisplayOption[] pvDisplayOptionArray = pvDisplayLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pvDisplayOptionArray != null && pvDisplayOptionArray.length > 0) {
            String[] stringArray = new String[]{PsUtil.getFilePath(string)};
            for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
                pvDisplayOptionArray[i].setSearchPaths(stringArray);
            }
        }
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parsing XML in reader");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = this.parseRsrcTree(psXmlSrc);
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("failed to interpret content of JVD in reader");
            return null;
        }
        return pvDisplayOptionArray;
    }

    public String write(PvDisplayOption[] pvDisplayOptionArray) {
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pvDisplayOptionArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected PvDisplayOption[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        Object[] objectArray;
        Object object;
        Object object2;
        String[] stringArray;
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        if (psXmlNode2.getType() == null || !psXmlNode2.getType().equalsIgnoreCase("jv-disp")) {
            PsDebug.warning("missing <jv-disp> element,\nthis is not a valid JavaView display file.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "meta");
        if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
            block2: for (int i = 0; i < psXmlNodeArray.length; ++i) {
                int n;
                stringArray = psXmlNodeArray[i].getAttribute("generator");
                if (stringArray != null && (object2 = stringArray).startsWith("JavaView v.")) {
                    object = object2.substring(object2.indexOf(".") + 1);
                    objectArray = PuString.splitString((String)object, '.');
                    if (objectArray != null && objectArray.length <= 3) {
                        for (n = 0; n < objectArray.length; ++n) {
                            if (n == 0) {
                                this.m_jvdVersion = 100000 * Integer.parseInt(objectArray[n]);
                                continue;
                            }
                            if (n == 1) {
                                this.m_jvdVersion += 1000 * Integer.parseInt(objectArray[n]);
                                continue;
                            }
                            if (n != 2) continue;
                            try {
                                this.m_jvdVersion += Integer.parseInt(objectArray[n]);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    } else {
                        PsDebug.warning("void JavaView version information in meta tag, generator = " + (String)object2);
                    }
                }
                if ((stringArray = psXmlNodeArray[i].getAttribute("dtd")) == null || (object2 = PuString.splitString((String)stringArray, '.')) == null || ((String[])object2).length <= 0) continue;
                object = new int[((String[])object2).length];
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    if (j == 0) {
                        this.m_jvdVersion = 100000 * Integer.parseInt(object2[j]);
                    } else if (j == 1) {
                        this.m_jvdVersion += 1000 * Integer.parseInt(object2[j]);
                    } else if (j == 2) {
                        this.m_jvdVersion += Integer.parseInt(object2[j]);
                    }
                    object[j] = Integer.parseInt(object2[j]);
                }
                objectArray = PsConfig.getVersion(12);
                for (n = 0; n < Math.min(1, ((String[])object2).length); ++n) {
                    if (objectArray[n] == object[n]) continue;
                    if (objectArray[n] > object[n]) continue block2;
                    PsDebug.message("Parsing a JVD file with jv-disp.dtd version=" + (String)stringArray + " which is newer than\n" + "\tversion=" + (int)objectArray[0] + "." + (int)objectArray[1] + "." + (int)objectArray[2] + " implemented by the loader of this JavaView program." + "\n\tMight need to upgrade JavaView.", false);
                    continue block2;
                }
            }
        }
        String string = null;
        stringArray = null;
        object2 = null;
        object = PsXmlSrc.getRsrcNode(psXmlNode2, "version");
        if (object == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            stringArray = "dump";
        } else {
            string = ((PsXmlNode)object).getContent();
            stringArray = ((PsXmlNode)object).getAttribute("type");
        }
        objectArray = PsXmlSrc.getRsrc(psXmlNode2, "title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode2, "authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode3 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.setXmlNode(psXmlNode3);
        }
        object2 = (psXmlNode = PsXmlSrc.getRsrcNode(psXmlNode2, "description")) != null ? PsXmlSrc.getRsrc(psXmlNode, "abstract") : PsXmlSrc.getRsrc(psXmlNode2, "abstract");
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode2, "displays");
        if (psXmlNode4 == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] stringArray2 = new String[]{"tag", "name"};
        PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode4, "display");
        if (psXmlNodeArray2 == null || psXmlNodeArray2.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[psXmlNodeArray2.length];
        for (int i = 0; i < psXmlNodeArray2.length; ++i) {
            int n;
            PsXmlNode psXmlNode5;
            Object object3;
            Object object4;
            int n2;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            int n3;
            Object object13;
            Object object14;
            pvDisplayOptionArray[i] = new PvDisplayOption();
            pvDisplayOptionArray[i].setVersion(string);
            pvDisplayOptionArray[i].setVersionType((String)stringArray);
            pvDisplayOptionArray[i].setAuthorInfo(psAuthorInfo);
            pvDisplayOptionArray[i].setAbstract((String)object2);
            String string2 = psXmlNodeArray2[i].getAttribute("name");
            if (objectArray != null) {
                pvDisplayOptionArray[i].setTitle((String)objectArray);
            } else if (string2 != null) {
                pvDisplayOptionArray[i].setTitle(string2);
            }
            pvDisplayOptionArray[i].setName(string2);
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 1, psXmlNodeArray2[i].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 4, psXmlNodeArray2[i].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 5, psXmlNodeArray2[i].getAttribute("axes"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 6, psXmlNodeArray2[i].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 11, psXmlNodeArray2[i].getAttribute("border"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 12, psXmlNodeArray2[i].getAttribute("boundingBox"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 13, psXmlNodeArray2[i].getAttribute("center"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 44, psXmlNodeArray2[i].getAttribute("clearScreen"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 34, psXmlNodeArray2[i].getAttribute("copyright"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 14, psXmlNodeArray2[i].getAttribute("cross"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 15, psXmlNodeArray2[i].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 16, psXmlNodeArray2[i].getAttribute("doubleBuffer"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 17, psXmlNodeArray2[i].getAttribute("drawing"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 18, psXmlNodeArray2[i].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 40, psXmlNodeArray2[i].getAttribute("edgesOnce"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 46, psXmlNodeArray2[i].getAttribute("fillDisplay"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 20, psXmlNodeArray2[i].getAttribute("frame"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 21, psXmlNodeArray2[i].getAttribute("info"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 39, psXmlNodeArray2[i].getAttribute("integerPick"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 23, psXmlNodeArray2[i].getAttribute("magnet"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 47, psXmlNodeArray2[i].getAttribute("scenegraph"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 24, psXmlNodeArray2[i].getAttribute("single"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 25, psXmlNodeArray2[i].getAttribute("sorting"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 33, psXmlNodeArray2[i].getAttribute("title"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 26, psXmlNodeArray2[i].getAttribute("visible"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 27, psXmlNodeArray2[i].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 28, psXmlNodeArray2[i].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 29, psXmlNodeArray2[i].getAttribute("yzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 30, psXmlNodeArray2[i].getAttribute("zBuffer"));
            String string3 = psXmlNodeArray2[i].getAttribute("3dLook");
            if (string3 != null) {
                PsDebug.warning("found deprecated display attribute \"3dLook\", change to \"thickLook\"");
                PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 37, string3);
            }
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 37, psXmlNodeArray2[i].getAttribute("thickLook"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[i], 38, psXmlNodeArray2[i].getAttribute("adaptiveSize"));
            PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "axes");
            if (psXmlNode6 != null) {
                object14 = psXmlNode6.getAttribute("longHash");
                if (object14 != null && ((String)object14).length() == 6) {
                    object13 = new boolean[6];
                    object14 = ((String)object14).toLowerCase();
                    for (n3 = 0; n3 < 6; ++n3) {
                        object13[n3] = ((String)object14).charAt(n3) == 't';
                    }
                    pvDisplayOptionArray[i].setAxesHash((boolean[])object13);
                }
                object13 = psXmlNode6.getAttribute("dim");
                int n4 = 3;
                if (object13 != null && ((String)object13).equalsIgnoreCase("2")) {
                    n4 = 2;
                }
                if ((object12 = psXmlNode6.getAttribute("visible")) != null && ((String)object12).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(5, true);
                }
                if ((object11 = psXmlNode6.getAttribute("autoBounds")) != null && ((String)object11).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[i].setOption(42, false);
                }
                if ((object10 = psXmlNode6.getAttribute("autoHashing")) == null) {
                    object10 = psXmlNode6.getAttribute("autoConfigure");
                }
                if (object10 != null && ((String)object10).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[i].setOption(41, false);
                }
                if ((object9 = psXmlNode6.getAttribute("autoLayout")) != null && ((String)object9).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[i].setOption(43, false);
                }
                if ((object8 = psXmlNode6.getAttribute("coordSystem")) != null) {
                    if (((String)object8).equalsIgnoreCase("adjust")) {
                        pvDisplayOptionArray[i].setAxesCoordSystem(0);
                    } else if (((String)object8).equalsIgnoreCase("scene")) {
                        pvDisplayOptionArray[i].setAxesCoordSystem(1);
                    } else if (((String)object8).equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[i].setAxesCoordSystem(2);
                    } else if (((String)object8).equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[i].setAxesCoordSystem(3);
                    } else {
                        PsDebug.warning("unknown coordinate system of axes, coordSystem = " + (String)object8);
                    }
                }
                if ((object7 = psXmlNode6.getAttribute("type")) == null) {
                    object7 = "center";
                }
                if ((object6 = psXmlNode6.getAttribute("span")) == null) {
                    object6 = "xy";
                }
                if (((String)object7).equalsIgnoreCase("bndbox")) {
                    if (n4 == 2) {
                        pvDisplayOptionArray[i].setAxesType(9);
                    } else {
                        pvDisplayOptionArray[i].setAxesType(2);
                    }
                } else if (((String)object7).equalsIgnoreCase("center")) {
                    if (n4 == 2) {
                        if (((String)object6).equalsIgnoreCase("xy")) {
                            pvDisplayOptionArray[i].setAxesType(3);
                        } else if (((String)object6).equalsIgnoreCase("yz")) {
                            pvDisplayOptionArray[i].setAxesType(4);
                        } else if (((String)object6).equalsIgnoreCase("zx")) {
                            pvDisplayOptionArray[i].setAxesType(5);
                        } else {
                            PsDebug.warning("unknown span of axes, span = " + (String)object6);
                        }
                    } else {
                        pvDisplayOptionArray[i].setAxesType(0);
                    }
                } else if (((String)object7).equalsIgnoreCase("corner")) {
                    if (n4 == 2) {
                        if (((String)object6).equalsIgnoreCase("xy")) {
                            pvDisplayOptionArray[i].setAxesType(6);
                        } else if (((String)object6).equalsIgnoreCase("yz")) {
                            pvDisplayOptionArray[i].setAxesType(7);
                        } else if (((String)object6).equalsIgnoreCase("zx")) {
                            pvDisplayOptionArray[i].setAxesType(8);
                        } else {
                            PsDebug.warning("unknown span of axes, span = " + (String)object6);
                        }
                    } else {
                        pvDisplayOptionArray[i].setAxesType(1);
                    }
                } else {
                    PsDebug.warning("unknown type of axes, type = " + (String)object7);
                }
                object5 = PsXmlSrc.getRsrcNodes(psXmlNode6, "ruler");
                if (object5 != null) {
                    n2 = ((PsXmlNode[])object5).length;
                    pvDisplayOptionArray[i].setNumRulers(n2);
                    for (n3 = 0; n3 < n2; ++n3) {
                        Color color;
                        int n5;
                        object4 = object5[n3].getAttribute("name");
                        if (object4 != null) {
                            pvDisplayOptionArray[i].setRulerName(n3, (String)object4);
                        }
                        if ((object3 = ((PsXmlNode)object5[n3]).getAttribute("mode")) != null) {
                            if (((String)object3).equalsIgnoreCase("fixed")) {
                                pvDisplayOptionArray[i].setRulerMode(n3, 0);
                            } else if (((String)object3).equalsIgnoreCase("partitioned")) {
                                pvDisplayOptionArray[i].setRulerMode(n3, 1);
                            }
                        }
                        pvDisplayOptionArray[i].showRulerArrow(n3, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "arrow", "show"));
                        pvDisplayOptionArray[i].showRulerName(n3, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "label", "show"));
                        pvDisplayOptionArray[i].showRulerNumbers(n3, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "numbers", "hide"));
                        pvDisplayOptionArray[i].showRulerHashingsNormal(n3, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "hashsNormal", "show"));
                        pvDisplayOptionArray[i].showRulerHashingsUp(n3, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "hashsUp", "show"));
                        pvDisplayOptionArray[i].showRulerTicksMajor(n3, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "ticksMajor", "hide"));
                        pvDisplayOptionArray[i].showRulerTicksMinor(n3, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "ticksMinor", "hide"));
                        pvDisplayOptionArray[i].showRuler(n3, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n3], "visible", "hide"));
                        double d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n3], "minValue");
                        if (d != 0.0) {
                            pvDisplayOptionArray[i].setRulerMinValue(n3, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n3], "maxValue")) != 0.0) {
                            pvDisplayOptionArray[i].setRulerMaxValue(n3, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n3], "minorUnit")) != 0.0) {
                            pvDisplayOptionArray[i].setRulerMinorHashUnit(n3, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n3], "majorUnit")) != 0.0) {
                            pvDisplayOptionArray[i].setRulerMajorHashUnit(n3, d);
                        }
                        if (((PsXmlNode)object5[n3]).hasChild("majorHashings") && !((PsXmlNode)object5[n3]).hasChild("minorHashings")) {
                            PsDebug.error("known bug encountered, ruler has majorHashings but no minorHashings.\n\tThis is a known bug of the JavaView, todo: correct your JVD file!");
                        }
                        if ((n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[n3], "minorHashings")) != 0) {
                            pvDisplayOptionArray[i].setRulerNumMinorHashings(n3, n5);
                        }
                        if ((n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[n3], "majorHashings")) != 0) {
                            pvDisplayOptionArray[i].setRulerNumMajorHashings(n3, n5);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object5[n3], "color")) != null) {
                            pvDisplayOptionArray[i].setRulerColor(n3, color);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n3], "thickness")) == 0.0) continue;
                        pvDisplayOptionArray[i].setRulerSize(n3, d);
                    }
                }
            }
            if ((object14 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "bndbox")) != null) {
                double d;
                Color color;
                object13 = ((PsXmlNode)object14).getAttribute("visible");
                if (object13 != null && ((String)object13).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(12, true);
                }
                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object14, "color")) != null) {
                    pvDisplayOptionArray[i].setBndBoxColor(color);
                }
                if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object14, "thickness")) != 0.0) {
                    pvDisplayOptionArray[i].setBndBoxSize(d);
                }
            }
            if ((object13 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "boxRatio")) != null) {
                String string4 = ((PsXmlNode)object13).getAttribute("visible");
                if (string4 != null && string4.equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(35, true);
                }
                if ((object12 = PsXmlLoader.parsePdVector((PsXmlNode)object13, null)) != null) {
                    pvDisplayOptionArray[i].setBoxRatio((PdVector)object12);
                }
            }
            if ((psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "clipRange")) != null) {
                int n6;
                object12 = new String("XYZ");
                object11 = psXmlNode5.getAttribute("autoBounds");
                if (object11 != null && ((String)object11).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[i].setOption(45, false);
                }
                if ((object10 = psXmlNode5.getAttribute("select")) != null) {
                    n6 = ((String)object12).indexOf((String)object10);
                    if (n6 < 0) {
                        PsDebug.warning("unknown range type, select = " + (String)object10);
                        n6 = 0;
                    }
                    pvDisplayOptionArray[i].setClipBoundsType(n6);
                }
                if ((object9 = psXmlNode5.getAttribute("visible")) != null && ((String)object9).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(36, true);
                }
                if ((object8 = PsXmlSrc.getRsrcNodes(psXmlNode5, "range")) != null && ((PsXmlNode[])object8).length > 0) {
                    for (n3 = 0; n3 < ((PsXmlNode[])object8).length; ++n3) {
                        object7 = object8[n3].getAttribute("type");
                        n6 = ((String)object12).indexOf((String)object7);
                        if (n6 < 0) {
                            PsDebug.warning("unknown range type = " + (String)object7);
                            n6 = n3;
                        }
                        if ((object6 = PsXmlLoader.parsePdVector((PsXmlNode)object8[n3], null)) == null || ((PdVector)object6).getSize() != 2) continue;
                        pvDisplayOptionArray[i].setClipBounds(n6, ((PdVector)object6).m_data);
                    }
                }
            }
            if ((object12 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "cameras")) != null) {
                object11 = ((PsXmlNode)object12).getAttribute("select");
                int n7 = -1;
                for (n3 = 0; n3 < PvCameraIf.CAMERA_NAME.length; ++n3) {
                    if (((String)object11).equals(PvCameraIf.CAMERA_NAME[n3])) {
                        n7 = n3;
                        break;
                    }
                    if (!((String)object11).equals(PvCameraIf.CAMERA_NAME[n3] + " Projection")) continue;
                    n7 = n3;
                    break;
                }
                if (n7 == -1) {
                    PsDebug.warning("unknown selected camera type = " + (String)object11);
                    n7 = 0;
                }
                pvDisplayOptionArray[i].setCurrentCamera(n7);
                object9 = PsXmlSrc.getRsrcNodes((PsXmlNode)object12, "camera");
                if (object9 != null) {
                    pvDisplayOptionArray[i].setNumCameras(((Object)object9).length);
                    for (n = 0; n < ((Object)object9).length; ++n) {
                        double d;
                        object8 = ((PsXmlNode)object9[n]).getAttribute("name");
                        if (object8 != null) {
                            pvDisplayOptionArray[i].setCameraName(n, (String)object8);
                        }
                        if ((object7 = ((PsXmlNode)object9[n]).getAttribute("sceneRatio")) != null && ((String)object7).equalsIgnoreCase("show")) {
                            pvDisplayOptionArray[i].setEnabledCameraSceneRatio(n, true);
                        }
                        object11 = ((PsXmlNode)object9[n]).getAttribute("projection");
                        int n8 = -1;
                        for (n3 = 0; n3 < PvCameraIf.CAMERA_NAME.length; ++n3) {
                            if (((String)object11).equals(PvCameraIf.CAMERA_NAME[n3])) {
                                n8 = n3;
                                break;
                            }
                            if (!((String)object11).equals(PvCameraIf.CAMERA_NAME[n3] + " Projection")) continue;
                            n8 = n3;
                            break;
                        }
                        if (n8 == -1) {
                            PsDebug.warning("unknown type of camera[" + n3 + "], type = " + (String)object11);
                            n8 = 0;
                        }
                        pvDisplayOptionArray[i].setCameraProjection(n, n8);
                        object5 = PsXmlLoader.parsePdVector((PsXmlNode)object9[n], "position", stringArray2);
                        if (object5 != null) {
                            pvDisplayOptionArray[i].setCameraPosition(n, (PdVector)object5);
                        }
                        if ((object5 = PsXmlLoader.parsePdVector((PsXmlNode)object9[n], "interest", stringArray2)) != null) {
                            pvDisplayOptionArray[i].setCameraInterest(n, (PdVector)object5);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object9[n], "fieldOfView")) == 53.13) {
                            d = 0.0;
                        }
                        pvDisplayOptionArray[i].setCameraFieldOfView(n, d);
                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object9[n], "roll");
                        if (d != 0.0) {
                            pvDisplayOptionArray[i].setCameraRoll(n, d);
                        }
                        if ((object3 = PsXmlSrc.getRsrcNode((PsXmlNode)object9[n], "clipping")) == null) continue;
                        String string5 = ((PsXmlNode)object3).getAttribute("enable");
                        if (string5 != null && string5.equalsIgnoreCase("show")) {
                            pvDisplayOptionArray[i].setEnabledCameraClip(n, true);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object9[n], "near")) != 0.0) {
                            pvDisplayOptionArray[i].setCameraNearClip(n, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object9[n], "far")) == 0.0) continue;
                        pvDisplayOptionArray[i].setCameraFarClip(n, d);
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            object11 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "lights");
            if (object11 != null) {
                String string6 = ((PsXmlNode)object11).getAttribute("lightingModel");
                if (string6 != null) {
                    if (string6.equals("Material")) {
                        pvDisplayOptionArray[i].setLightingModel(0);
                    } else if (string6.equals("Light")) {
                        pvDisplayOptionArray[i].setLightingModel(1);
                    } else if (string6.equals("Lighting")) {
                        PsDebug.warning("deprecated lighting model = " + string6 + ", save JVD with newer JavaView version.");
                        pvDisplayOptionArray[i].setLightingModel(1);
                    } else {
                        PsDebug.warning("unknown lighting model = " + string6);
                    }
                } else {
                    pvDisplayOptionArray[i].setLightingModel(0);
                }
                object9 = ((PsXmlNode)object11).getAttribute("select");
                if (object9 != null) {
                    pvDisplayOptionArray[i].setSelectedLight(Integer.parseInt((String)object9));
                }
                if ((object8 = PsXmlSrc.getRsrcNodes((PsXmlNode)object11, "light")) != null) {
                    pvDisplayOptionArray[i].setNumLights(((PsXmlNode[])object8).length);
                    for (n = 0; n < ((Object)object8).length; ++n) {
                        double d;
                        Serializable serializable;
                        String string7;
                        object7 = ((PsXmlNode)object8[n]).getAttribute("name");
                        if (object7 != null) {
                            pvDisplayOptionArray[i].setLightName(n, (String)object7);
                        }
                        if ((object6 = ((PsXmlNode)object8[n]).getAttribute("type")) != null) {
                            if (((String)object6).equalsIgnoreCase("ambient")) {
                                pvDisplayOptionArray[i].setLightType(n, 0);
                            } else if (((String)object6).equalsIgnoreCase("direction")) {
                                pvDisplayOptionArray[i].setLightType(n, 1);
                            } else if (((String)object6).equalsIgnoreCase("point")) {
                                pvDisplayOptionArray[i].setLightType(n, 2);
                            } else if (((String)object6).equalsIgnoreCase("spot")) {
                                pvDisplayOptionArray[i].setLightType(n, 3);
                            } else if (((String)object6).equalsIgnoreCase("shadow")) {
                                pvDisplayOptionArray[i].setLightType(n, 4);
                            } else if (((String)object6).equalsIgnoreCase("head")) {
                                pvDisplayOptionArray[i].setLightType(n, 5);
                            } else if (((String)object6).equalsIgnoreCase("sky")) {
                                pvDisplayOptionArray[i].setLightType(n, 6);
                            } else {
                                PsDebug.warning("unknown light type = " + (String)object6);
                                pvDisplayOptionArray[i].setLightType(n, 1);
                            }
                        } else {
                            pvDisplayOptionArray[i].setLightType(n, 1);
                        }
                        object5 = ((PsXmlNode)object8[n]).getAttribute("highlight");
                        if (object5 != null) {
                            pvDisplayOptionArray[i].setLightHighlight(n, ((String)object5).equalsIgnoreCase("on"));
                        }
                        if ((string7 = ((PsXmlNode)object8[n]).getAttribute("reference")) != null) {
                            if (string7.equalsIgnoreCase("camera")) {
                                pvDisplayOptionArray[i].setLightReference(n, 1);
                            } else if (string7.equalsIgnoreCase("scene")) {
                                pvDisplayOptionArray[i].setLightReference(n, 0);
                            } else {
                                PsDebug.warning("unknown light reference = " + string7);
                                pvDisplayOptionArray[i].setLightReference(n, 0);
                            }
                        }
                        if ((object4 = ((PsXmlNode)object8[n]).getAttribute("shading")) != null) {
                            if (((String)object4).equalsIgnoreCase("symmetric")) {
                                pvDisplayOptionArray[i].setLightShading(n, 0);
                            } else if (((String)object4).equalsIgnoreCase("halfSphere")) {
                                pvDisplayOptionArray[i].setLightShading(n, 1);
                            } else if (((String)object4).equalsIgnoreCase("fullSphere")) {
                                pvDisplayOptionArray[i].setLightShading(n, 2);
                            } else {
                                PsDebug.warning("unknown light shading = " + (String)object4);
                                pvDisplayOptionArray[i].setLightReference(n, 0);
                            }
                        }
                        object3 = ((PsXmlNode)object8[n]).getAttribute("switch");
                        pvDisplayOptionArray[i].setLightSwitchedOn(n, object3 == null || ((String)object3).equalsIgnoreCase("on"));
                        String string8 = ((PsXmlNode)object8[n]).getAttribute("visible");
                        pvDisplayOptionArray[i].setLightVisible(n, string8 != null && string8.equalsIgnoreCase("show"));
                        if (object6 != null && ((String)object6).equalsIgnoreCase("head") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[i].setLightReference(n, 1);
                            pvDisplayOptionArray[i].setLightShading(n, 0);
                            pvDisplayOptionArray[i].setLightPosition(n, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[i].setLightInterest(n, new PdVector(0.0, 0.0, 0.0));
                        } else if (object6 != null && ((String)object6).equalsIgnoreCase("sky") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[i].setLightReference(n, 0);
                            pvDisplayOptionArray[i].setLightShading(n, 0);
                            pvDisplayOptionArray[i].setLightPosition(n, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[i].setLightInterest(n, new PdVector(0.0, 0.0, 0.0));
                        } else {
                            serializable = PsXmlLoader.parsePdVector((PsXmlNode)object8[n], "position", stringArray2);
                            if (serializable != null) {
                                pvDisplayOptionArray[i].setLightPosition(n, (PdVector)serializable);
                            }
                            if ((serializable = PsXmlLoader.parsePdVector((PsXmlNode)object8[n], "interest", stringArray2)) != null) {
                                pvDisplayOptionArray[i].setLightInterest(n, (PdVector)serializable);
                            }
                        }
                        serializable = PsXmlLoader.parseColorRGB((PsXmlNode)object8[n], "color");
                        if (serializable != null) {
                            pvDisplayOptionArray[i].setLightColor(n, (Color)serializable);
                        }
                        double d2 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object8[n], "intensity");
                        pvDisplayOptionArray[i].setLightIntensity(n, d2);
                        if (((PsXmlNode)object8[n]).hasChild("angle")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object8[n], "angle");
                            pvDisplayOptionArray[i].setLightAngle(n, d);
                        }
                        if (((PsXmlNode)object8[n]).hasChild("corona")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object8[n], "corona");
                            pvDisplayOptionArray[i].setLightCorona(n, d);
                        }
                        if (((PsXmlNode)object8[n]).hasChild("exponent")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object8[n], "exponent");
                            pvDisplayOptionArray[i].setLightExponent(n, d);
                        }
                        if (!((PsXmlNode)object8[n]).hasChild("falloff")) continue;
                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object8[n], "falloff");
                        pvDisplayOptionArray[i].setLightFalloff(n, d);
                    }
                }
            }
            if ((object10 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "transform")) != null) {
                object9 = ((PsXmlNode)object10).getAttribute("majorMode");
                if (object9 != null) {
                    if (((String)object9).equalsIgnoreCase("rotate")) {
                        pvDisplayOptionArray[i].setMajorMode(0);
                    } else if (((String)object9).equalsIgnoreCase("rotate-xy")) {
                        pvDisplayOptionArray[i].setMajorMode(17);
                    } else if (((String)object9).equalsIgnoreCase("scale")) {
                        pvDisplayOptionArray[i].setMajorMode(1);
                    } else if (((String)object9).equalsIgnoreCase("translate")) {
                        pvDisplayOptionArray[i].setMajorMode(3);
                    } else if (((String)object9).equalsIgnoreCase("translate-z")) {
                        pvDisplayOptionArray[i].setMajorMode(4);
                    } else if (((String)object9).equalsIgnoreCase("initial")) {
                        pvDisplayOptionArray[i].setMajorMode(6);
                    } else if (((String)object9).equalsIgnoreCase("pick")) {
                        pvDisplayOptionArray[i].setMajorMode(5);
                    } else {
                        PsDebug.warning("unknown major mode = " + (String)object9);
                    }
                }
                if ((object8 = ((PsXmlNode)object10).getAttribute("localTransform")) != null && ((String)object8).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(31, true);
                }
                if ((object7 = ((PsXmlNode)object10).getAttribute("directSelect")) != null && ((String)object7).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[i].setOption(32, true);
                }
                if ((object6 = ((PsXmlNode)object10).getAttribute("mode")) != null) {
                    if (((String)object6).equalsIgnoreCase("camera")) {
                        pvDisplayOptionArray[i].setTransformMode(0);
                    } else if (((String)object6).equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[i].setTransformMode(1);
                    } else if (((String)object6).equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[i].setTransformMode(2);
                    } else {
                        PsDebug.warning("unknown transform mode = " + (String)object6);
                    }
                }
            }
            if ((object9 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "background")) != null) {
                PsXmlNode psXmlNode7;
                object8 = PsXmlLoader.parseColorRGB((PsXmlNode)object9, "color");
                if (object8 != null) {
                    pvDisplayOptionArray[i].setBackgroundColor((Color)object8);
                }
                object7 = ((PsXmlNode)object9).getAttribute("image");
                pvDisplayOptionArray[i].setOption(10, object7 != null && ((String)object7).equalsIgnoreCase("show"));
                object6 = ((PsXmlNode)object9).getAttribute("imageFit");
                if (object6 != null) {
                    if (((String)object6).equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[i].setBackgroundImageFit(0);
                    } else if (((String)object6).equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[i].setBackgroundImageFit(1);
                    } else if (((String)object6).equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[i].setBackgroundImageFit(2);
                    } else if (((String)object6).equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[i].setBackgroundImageFit(3);
                    }
                }
                if ((object5 = PsXmlSrc.getRsrcNode((PsXmlNode)object9, "image")) != null && (psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object5, "url")) != null) {
                    pvDisplayOptionArray[i].setBackgroundImageFile(psXmlNode7.getContent());
                }
            }
            if ((object8 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "foreground")) != null) {
                PsXmlNode psXmlNode8;
                object7 = PsXmlLoader.parseColorRGB((PsXmlNode)object8, "color");
                if (object7 != null) {
                    pvDisplayOptionArray[i].setForegroundColor((Color)object7);
                }
                object6 = ((PsXmlNode)object8).getAttribute("image");
                pvDisplayOptionArray[i].setOption(19, object6 != null && ((String)object6).equalsIgnoreCase("show"));
                object5 = ((PsXmlNode)object8).getAttribute("imageFit");
                if (object5 != null) {
                    if (((String)object5).equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[i].setForegroundImageFit(0);
                    } else if (((String)object5).equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[i].setForegroundImageFit(1);
                    } else if (((String)object5).equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[i].setForegroundImageFit(2);
                    } else if (((String)object5).equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[i].setForegroundImageFit(3);
                    }
                }
                if ((psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)object8, "image")) != null && (object4 = PsXmlSrc.getRsrcNode(psXmlNode8, "url")) != null) {
                    pvDisplayOptionArray[i].setForegroundImageFile(((PsXmlNode)object4).getContent());
                }
            }
            if ((object7 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[i], "window")) == null) continue;
            object6 = PsXmlSrc.getRsrcNode((PsXmlNode)object7, "x");
            if (object6 != null) {
                int n9 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7, "x");
                n2 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7, "y");
                pvDisplayOptionArray[i].setWindowPosition(new Point(n9, n2));
            }
            int n10 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7, "width");
            n2 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7, "height");
            pvDisplayOptionArray[i].setWindowSize(new Dimension(n10, n2));
        }
        return pvDisplayOptionArray;
    }

    private static boolean hasAttribute(PsXmlNode psXmlNode, String string, String string2) {
        return PvDisplayLoader.hasAttribute(psXmlNode.getAttribute(string), string2);
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    private static void parseOption(PvDisplayOption pvDisplayOption, int n, String string) {
        if (string == null) {
            return;
        }
        pvDisplayOption.setOption(n, string.equalsIgnoreCase("show"));
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PvDisplayOption[] pvDisplayOptionArray) {
        PsXmlNode psXmlNode;
        Object object;
        Object object2;
        Serializable serializable;
        PsXmlNode psXmlNode2;
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jv-disp");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        psXmlSrc.setDocName("jv-disp");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-disp.dtd");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
        }
        if (bl) {
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("generator", PsConfig.getProgramAndVersion());
            serializable = psXmlNode2.addChild("meta");
            object2 = PsConfig.getVersion(12);
            object = String.valueOf(object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf(object2[1]);
            if (object2[2] != 0) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf(object2[2]);
            }
            ((PsXmlNode)serializable).addAttribute("dtd", (String)object);
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("date", new Date().toString());
            psXmlNode = psXmlNode2.addChild("version", pvDisplayOptionArray[0].getVersion());
            psXmlNode.addAttribute("type", pvDisplayOptionArray[0].getVersionType());
            if (pvDisplayOptionArray[0].getTitle() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getTitle());
            } else if (pvDisplayOptionArray[0].getName() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getName());
            }
        }
        if (bl2 && (serializable = pvDisplayOptionArray[0].getAuthorInfo()) != null && ((PsAuthorInfo)serializable).getNumAuthors() > 0 && (object2 = (Object)((PsAuthorInfo)serializable).getXmlNode()) != null) {
            psXmlNode2.addChild((PsXmlNode)object2);
        }
        if (bl3 && pvDisplayOptionArray[0].getAbstract() != null) {
            serializable = psXmlNode2.addChild("description");
            ((PsXmlNode)serializable).addChild("abstract", pvDisplayOptionArray[0].getAbstract());
        }
        serializable = psXmlNode2.addChild("displays");
        for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
            Dimension dimension;
            Serializable serializable2;
            int n;
            String string;
            PsXmlNode psXmlNode3;
            PsXmlNode psXmlNode4;
            int n2;
            PsXmlNode psXmlNode5;
            int n3;
            int n4;
            Object[] objectArray;
            object = ((PsXmlNode)serializable).addChild("display");
            ((PsXmlNode)object).addAttribute("name", pvDisplayOptionArray[i].getName());
            if (pvDisplayOptionArray[i].getOption(1)) {
                ((PsXmlNode)object).addAttribute("antiAlias", "show");
            }
            if (pvDisplayOptionArray[i].getOption(4)) {
                ((PsXmlNode)object).addAttribute("autoRotate", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(11)) {
                ((PsXmlNode)object).addAttribute("border", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(13)) {
                ((PsXmlNode)object).addAttribute("center", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(44)) {
                ((PsXmlNode)object).addAttribute("clearScreen", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(34)) {
                ((PsXmlNode)object).addAttribute("copyright", "show");
            }
            if (pvDisplayOptionArray[i].getOption(14)) {
                ((PsXmlNode)object).addAttribute("cross", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(15)) {
                ((PsXmlNode)object).addAttribute("depthcue", "hide");
            }
            if (!pvDisplayOptionArray[i].getOption(16)) {
                ((PsXmlNode)object).addAttribute("doubleBuffer", "hide");
            }
            if (!pvDisplayOptionArray[i].getOption(17)) {
                ((PsXmlNode)object).addAttribute("drawing", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(18)) {
                ((PsXmlNode)object).addAttribute("edgeAura", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(40)) {
                ((PsXmlNode)object).addAttribute("edgesOnce", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(46)) {
                ((PsXmlNode)object).addAttribute("fillDisplay", "show");
            }
            if (pvDisplayOptionArray[i].getOption(20)) {
                ((PsXmlNode)object).addAttribute("frame", "show");
            }
            if (pvDisplayOptionArray[i].getOption(21)) {
                ((PsXmlNode)object).addAttribute("info", "show");
            }
            if (pvDisplayOptionArray[i].getOption(39)) {
                ((PsXmlNode)object).addAttribute("integerPick", "show");
            }
            if (pvDisplayOptionArray[i].getOption(23)) {
                ((PsXmlNode)object).addAttribute("magnet", "show");
            }
            if (pvDisplayOptionArray[i].getOption(47)) {
                ((PsXmlNode)object).addAttribute("scenegraph", "show");
            }
            if (pvDisplayOptionArray[i].getOption(24)) {
                ((PsXmlNode)object).addAttribute("single", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(25)) {
                ((PsXmlNode)object).addAttribute("sorting", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(37)) {
                ((PsXmlNode)object).addAttribute("thickLook", "show");
            }
            if (pvDisplayOptionArray[i].getOption(33)) {
                ((PsXmlNode)object).addAttribute("title", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(26)) {
                ((PsXmlNode)object).addAttribute("visible", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(27)) {
                ((PsXmlNode)object).addAttribute("xyGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(28)) {
                ((PsXmlNode)object).addAttribute("xzGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(29)) {
                ((PsXmlNode)object).addAttribute("yzGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(30)) {
                ((PsXmlNode)object).addAttribute("zBuffer", "show");
            }
            if (pvDisplayOptionArray[i].getOption(38)) {
                ((PsXmlNode)object).addAttribute("adaptiveSize", "show");
            }
            if (pvDisplayOptionArray[i].getAxes() != null) {
                psXmlNode = ((PsXmlNode)object).addChild("axes");
                psXmlNode.addAttribute("name", pvDisplayOptionArray[i].getAxes().getName());
                objectArray = pvDisplayOptionArray[i].getAxesHash();
                if (objectArray != null) {
                    char[] cArray = new char[6];
                    for (n4 = 0; n4 < 6; ++n4) {
                        cArray[n4] = objectArray[n4] ? 116 : 102;
                    }
                    psXmlNode.addAttribute("longHash", String.valueOf(cArray));
                }
                if (!pvDisplayOptionArray[i].getOption(42)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (!pvDisplayOptionArray[i].getOption(41)) {
                    psXmlNode.addAttribute("autoHashing", "hide");
                }
                if (!pvDisplayOptionArray[i].getOption(43)) {
                    psXmlNode.addAttribute("autoLayout", "hide");
                }
                switch (pvDisplayOptionArray[i].getAxesCoordSystem()) {
                    default: {
                        psXmlNode.addAttribute("coordSystem", "adjust");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("coordSystem", "scene");
                        break;
                    }
                    case 2: {
                        psXmlNode.addAttribute("coordSystem", "model");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("coordSystem", "ambient");
                    }
                }
                psXmlNode.addAttribute("dim", String.valueOf(pvDisplayOptionArray[i].getDimAxes()));
                if (pvDisplayOptionArray[i].getOption(5)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                switch (pvDisplayOptionArray[i].getAxesType()) {
                    case 2: {
                        psXmlNode.addAttribute("type", "bndbox");
                        break;
                    }
                    case 0: {
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 4: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 5: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 6: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 7: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 8: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "corner");
                    }
                }
                n3 = pvDisplayOptionArray[i].getNumRulers();
                for (n4 = 0; n4 < n3; ++n4) {
                    psXmlNode5 = psXmlNode.addChild("ruler");
                    psXmlNode5.addAttribute("name", pvDisplayOptionArray[i].getRulerName(n4));
                    if (pvDisplayOptionArray[i].getRulerMode(n4) == 1) {
                        psXmlNode5.addAttribute("mode", "partitioned");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerArrow(n4)) {
                        psXmlNode5.addAttribute("arrow", "show");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerName(n4)) {
                        psXmlNode5.addAttribute("label", "show");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerNumbers(n4)) {
                        psXmlNode5.addAttribute("numbers", "hide");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerHashingsNormal(n4)) {
                        psXmlNode5.addAttribute("hashsNormal", "show");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerHashingsUp(n4)) {
                        psXmlNode5.addAttribute("hashsUp", "show");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerTicksMajor(n4)) {
                        psXmlNode5.addAttribute("ticksMajor", "hide");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerTicksMinor(n4)) {
                        psXmlNode5.addAttribute("ticksMinor", "hide");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRuler(n4)) {
                        psXmlNode5.addAttribute("visible", "hide");
                    }
                    psXmlNode5.addChild("minValue", pvDisplayOptionArray[i].getRulerMinValue(n4));
                    psXmlNode5.addChild("maxValue", pvDisplayOptionArray[i].getRulerMaxValue(n4));
                    psXmlNode5.addChild("minorUnit", pvDisplayOptionArray[i].getRulerMinorHashUnit(n4));
                    psXmlNode5.addChild("majorUnit", pvDisplayOptionArray[i].getRulerMajorHashUnit(n4));
                    psXmlNode5.addChild("minorHashings", pvDisplayOptionArray[i].getRulerNumMinorHashings(n4));
                    psXmlNode5.addChild("majorHashings", pvDisplayOptionArray[i].getRulerNumMajorHashings(n4));
                    PsXmlLoader.addColor(psXmlNode5, "color", pvDisplayOptionArray[i].getRulerColor(n4));
                    if (pvDisplayOptionArray[i].getRulerSize(n4) == 0.0) continue;
                    psXmlNode5.addChild("thickness", pvDisplayOptionArray[i].getRulerSize(n4));
                }
            }
            if (pvDisplayOptionArray[i].getBndBoxColor() != null || pvDisplayOptionArray[i].getBndBoxSize() != 0.0 || pvDisplayOptionArray[i].getOption(12)) {
                psXmlNode = ((PsXmlNode)object).addChild("bndbox");
                if (pvDisplayOptionArray[i].getOption(12)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                PsXmlLoader.addColor(psXmlNode, "color", pvDisplayOptionArray[i].getBndBoxColor());
                if (pvDisplayOptionArray[i].getBndBoxSize() != 0.0) {
                    psXmlNode.addChild("thickness", pvDisplayOptionArray[i].getBndBoxSize());
                }
            }
            if (pvDisplayOptionArray[i].getBoxRatio() != null || pvDisplayOptionArray[i].getOption(35)) {
                psXmlNode = PsXmlLoader.addVector((PsXmlNode)object, "boxRatio", pvDisplayOptionArray[i].getBoxRatio(), false);
                if (pvDisplayOptionArray[i].getOption(35)) {
                    psXmlNode.addAttribute("visible", "show");
                }
            }
            if (pvDisplayOptionArray[i].getOption(36) || !pvDisplayOptionArray[i].getOption(45)) {
                psXmlNode = ((PsXmlNode)object).addChild("clipRange");
                objectArray = new String[]{"X", "Y", "Z"};
                if (!pvDisplayOptionArray[i].getOption(45)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (pvDisplayOptionArray[i].getClipBoundsType() != -1) {
                    psXmlNode.addAttribute("select", (String)objectArray[pvDisplayOptionArray[i].getClipBoundsType()]);
                }
                if (pvDisplayOptionArray[i].getOption(36)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    double[] dArray = pvDisplayOptionArray[i].getClipBounds(n3);
                    if (dArray == null || dArray[0] == Double.NEGATIVE_INFINITY && dArray[1] == Double.MAX_VALUE) continue;
                    psXmlNode5 = PsXmlLoader.addVector(psXmlNode, "range", new PdVector(dArray), false);
                    psXmlNode5.addAttribute("type", (String)objectArray[n3]);
                }
            }
            psXmlNode = ((PsXmlNode)object).addChild("cameras");
            int n5 = pvDisplayOptionArray[i].getCurrentCamera();
            if (n5 < 0 || n5 >= PvCameraIf.CAMERA_NAME.length) {
                PsDebug.warning("unknown camera type = " + n5);
            } else {
                psXmlNode.addAttribute("select", PvCameraIf.CAMERA_NAME[n5]);
            }
            n3 = pvDisplayOptionArray[i].getNumCameras();
            for (n4 = 0; n4 < n3; ++n4) {
                psXmlNode5 = psXmlNode.addChild("camera");
                psXmlNode5.addAttribute("name", pvDisplayOptionArray[i].getCameraName(n4));
                if (pvDisplayOptionArray[i].isEnabledCameraSceneRatio(n4)) {
                    psXmlNode5.addAttribute("sceneRatio", "show");
                }
                if ((n2 = pvDisplayOptionArray[i].getCameraProjection(n4)) < 0 || n2 >= PvCameraIf.CAMERA_NAME.length) {
                    PsDebug.warning("unknown camera type = " + n2);
                } else {
                    psXmlNode5.addAttribute("projection", PvCameraIf.CAMERA_NAME[n2]);
                }
                PsXmlLoader.addVector(psXmlNode5, "position", pvDisplayOptionArray[i].getCameraPosition(n4), true);
                PsXmlLoader.addVector(psXmlNode5, "interest", pvDisplayOptionArray[i].getCameraInterest(n4), true);
                psXmlNode5.addChild("fieldOfView", pvDisplayOptionArray[i].getCameraAngle(n4));
                psXmlNode5.addChild("roll", pvDisplayOptionArray[i].getCameraRoll(n4));
                psXmlNode4 = psXmlNode5.addChild("clipping");
                if (pvDisplayOptionArray[i].isEnabledCameraClip(n4)) {
                    psXmlNode4.addAttribute("enable", "show");
                } else {
                    psXmlNode4.addAttribute("enable", "hide");
                }
                psXmlNode4.addChild("near", pvDisplayOptionArray[i].getCameraNearClip(n4));
                psXmlNode4.addChild("far", pvDisplayOptionArray[i].getCameraFarClip(n4));
            }
            PsXmlNode psXmlNode6 = ((PsXmlNode)object).addChild("lights");
            int n6 = pvDisplayOptionArray[i].getLightingModel();
            switch (n6) {
                case 0: {
                    psXmlNode6.addAttribute("lightingModel", "Material");
                    break;
                }
                case 1: {
                    psXmlNode6.addAttribute("lightingModel", "Light");
                    break;
                }
                default: {
                    PsDebug.warning("unknown lighting model = " + n6);
                }
            }
            n2 = pvDisplayOptionArray[i].getNumLights();
            if (n2 > 0) {
                psXmlNode6.addAttribute("select", String.valueOf(pvDisplayOptionArray[i].getSelectedLight()));
            }
            for (int j = 0; j < n2; ++j) {
                psXmlNode3 = psXmlNode6.addChild("light");
                string = pvDisplayOptionArray[i].getLightName(j);
                if (string != null && !string.equalsIgnoreCase("")) {
                    psXmlNode3.addAttribute("name", string);
                }
                int n7 = pvDisplayOptionArray[i].getLightType(j);
                switch (n7) {
                    case 0: {
                        psXmlNode3.addAttribute("type", "ambient");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("type", "direction");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("type", "point");
                        break;
                    }
                    case 3: {
                        psXmlNode3.addAttribute("type", "spot");
                        break;
                    }
                    case 4: {
                        psXmlNode3.addAttribute("type", "shadow");
                        break;
                    }
                    case 5: {
                        psXmlNode3.addAttribute("type", "head");
                        break;
                    }
                    case 6: {
                        psXmlNode3.addAttribute("type", "sky");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light type = " + n7);
                    }
                }
                if (pvDisplayOptionArray[i].isLightHighlight(j)) {
                    psXmlNode3.addAttribute("highlight", "on");
                } else {
                    psXmlNode3.addAttribute("highlight", "off");
                }
                n = pvDisplayOptionArray[i].getLightReference(j);
                switch (n) {
                    case 1: {
                        psXmlNode3.addAttribute("reference", "camera");
                        break;
                    }
                    case 0: {
                        psXmlNode3.addAttribute("reference", "scene");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light reference = " + n);
                    }
                }
                int n8 = pvDisplayOptionArray[i].getLightShading(j);
                switch (n8) {
                    case 0: {
                        psXmlNode3.addAttribute("shading", "symmetric");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("shading", "halfSphere");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("shading", "fullSphere");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light shading = " + n8);
                    }
                }
                if (pvDisplayOptionArray[i].isLightSwitchedOn(j)) {
                    psXmlNode3.addAttribute("switch", "on");
                } else {
                    psXmlNode3.addAttribute("switch", "off");
                }
                if (pvDisplayOptionArray[i].isLightVisible(j)) {
                    psXmlNode3.addAttribute("visible", "show");
                } else {
                    psXmlNode3.addAttribute("visible", "hide");
                }
                PsXmlLoader.addVector(psXmlNode3, "position", pvDisplayOptionArray[i].getLightPosition(j), true);
                PsXmlLoader.addVector(psXmlNode3, "interest", pvDisplayOptionArray[i].getLightInterest(j), true);
                PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[i].getLightColor(j));
                psXmlNode3.addChild("intensity", pvDisplayOptionArray[i].getLightIntensity(j));
                psXmlNode3.addChild("exponent", pvDisplayOptionArray[i].getLightExponent(j));
                psXmlNode3.addChild("angle", pvDisplayOptionArray[i].getLightAngle(j));
                psXmlNode3.addChild("corona", pvDisplayOptionArray[i].getLightCorona(j));
                psXmlNode3.addChild("falloff", pvDisplayOptionArray[i].getLightFalloff(j));
            }
            psXmlNode4 = ((PsXmlNode)object).addChild("transform");
            int n9 = pvDisplayOptionArray[i].getMajorMode();
            string = "rotate";
            switch (n9) {
                case 0: {
                    string = "rotate";
                    break;
                }
                case 17: {
                    string = "rotate-xy";
                    break;
                }
                case 1: {
                    string = "scale";
                    break;
                }
                case 3: {
                    string = "translate";
                    break;
                }
                case 4: {
                    string = "translate-z";
                    break;
                }
                case 6: {
                    string = "initial";
                    break;
                }
                case 5: {
                    string = "pick";
                    break;
                }
                default: {
                    PsDebug.warning("unknown major mode = " + n9);
                }
            }
            psXmlNode4.addAttribute("majorMode", string);
            if (pvDisplayOptionArray[i].getOption(31)) {
                psXmlNode4.addAttribute("localTransform", "show");
            }
            if (pvDisplayOptionArray[i].getOption(32)) {
                psXmlNode4.addAttribute("directSelect", "show");
            }
            switch (pvDisplayOptionArray[i].getTransformMode()) {
                case 0: {
                    psXmlNode4.addAttribute("mode", "camera");
                    break;
                }
                case 1: {
                    psXmlNode4.addAttribute("mode", "model");
                    break;
                }
                case 2: {
                    psXmlNode4.addAttribute("mode", "ambient");
                    break;
                }
                default: {
                    PsDebug.warning("unknown transformation mode = " + pvDisplayOptionArray[i].getTransformMode());
                }
            }
            psXmlNode3 = ((PsXmlNode)object).addChild("background");
            PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[i].getBackgroundColor());
            boolean bl4 = pvDisplayOptionArray[i].getOption(10);
            String string2 = pvDisplayOptionArray[i].getBackgroundImageFile();
            if (bl4 && string2 != null) {
                if (bl4) {
                    psXmlNode3.addAttribute("image", "show");
                }
                if ((n = pvDisplayOptionArray[i].getBackgroundImageFit()) == 0) {
                    psXmlNode3.addAttribute("imageFit", "center");
                } else if (n == 1) {
                    psXmlNode3.addAttribute("imageFit", "fit");
                } else if (n == 2) {
                    psXmlNode3.addAttribute("imageFit", "resize");
                } else if (n == 3) {
                    psXmlNode3.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown background imageFit type = " + n);
                }
                PsXmlNode psXmlNode7 = psXmlNode3.addChild("image");
                psXmlNode7.addChild("url", string2);
            }
            PsXmlNode psXmlNode8 = ((PsXmlNode)object).addChild("foreground");
            PsXmlLoader.addColor(psXmlNode8, "color", pvDisplayOptionArray[i].getForegroundColor());
            bl4 = pvDisplayOptionArray[i].getOption(19);
            string2 = pvDisplayOptionArray[i].getForegroundImageFile();
            if (bl4 && string2 != null) {
                int n10;
                if (bl4) {
                    psXmlNode8.addAttribute("image", "show");
                }
                if ((n10 = pvDisplayOptionArray[i].getForegroundImageFit()) == 0) {
                    psXmlNode8.addAttribute("imageFit", "center");
                } else if (n10 == 1) {
                    psXmlNode8.addAttribute("imageFit", "fit");
                } else if (n10 == 2) {
                    psXmlNode8.addAttribute("imageFit", "resize");
                } else if (n10 == 3) {
                    psXmlNode8.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown foreground imageFit type = " + n10);
                }
                serializable2 = psXmlNode8.addChild("image");
                ((PsXmlNode)serializable2).addChild("url", string2);
            }
            PsXmlNode psXmlNode9 = ((PsXmlNode)object).addChild("window");
            serializable2 = pvDisplayOptionArray[i].getWindowPosition();
            if (serializable2 != null) {
                psXmlNode9.addChild("x", ((Point)serializable2).x);
                psXmlNode9.addChild("y", ((Point)serializable2).y);
            }
            if ((dimension = pvDisplayOptionArray[i].getWindowSize()) == null) continue;
            psXmlNode9.addChild("width", dimension.width);
            psXmlNode9.addChild("height", dimension.height);
        }
        return psXmlSrc;
    }
}

