/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PsXmlLoader {
    public static PsXmlSrc read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (psXmlSrc == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        psXmlSrc.setRsrcFile(string);
        return psXmlSrc;
    }

    public static PsXmlSrc read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        try {
            boolean bl = PsXmlLoader.parse(bufferedReader, psXmlSrc);
            if (!bl) {
                PsDebug.warning("failed reading stream = " + bufferedReader);
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed reading stream = " + bufferedReader);
            iOException.printStackTrace();
            return null;
        }
        return psXmlSrc;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean parse(BufferedReader var0, PsXmlSrc var1_1) throws IOException {
        if (var0 == null || var1_1 == null) {
            PsDebug.warning("missing reader or XML source");
            return false;
        }
        do {
            var0.mark(200);
        } while ((var2_2 = var0.read()) == 32 || var2_2 == 9 || var2_2 == 10 || var2_2 == 13);
        if (var2_2 == -1) {
            PsDebug.warning("empty file.");
            return false;
        }
        var3_3 = new char[5];
        var3_3[0] = (char)var2_2;
        for (var4_4 = 1; var4_4 < 5; ++var4_4) {
            var2_2 = (char)var0.read();
            if (var2_2 == -1) {
                PsDebug.warning("invalid file, could not find xml-tag, eof reached.");
                return false;
            }
            var3_3[var4_4] = (char)var2_2;
        }
        var4_5 = String.valueOf(var3_3);
        var0.reset();
        if (!var4_5.startsWith("<?xml")) {
            var5_6 = var4_5.indexOf("<?xml");
            if (var5_6 == -1) {
                if (!"<javaview-models>".startsWith(var4_5)) {
                    PsDebug.warning("invalid XML file, first line starts with = " + var4_5);
                    return false;
                }
            } else if (var5_6 > 0) {
                var4_5 = var4_5.substring(var5_6);
                var0.read(new char[var5_6], 0, var5_6);
            }
        }
        var5_7 = new StreamTokenizer(var0);
        var5_7.eolIsSignificant(true);
        var5_7.ordinaryChars(48, 48);
        var5_7.ordinaryChars(49, 57);
        var5_7.ordinaryChar(124);
        var5_7.ordinaryChar(60);
        var5_7.ordinaryChar(62);
        var5_7.ordinaryChar(47);
        var5_7.ordinaryChar(33);
        var5_7.ordinaryChar(63);
        var5_7.ordinaryChar(91);
        var5_7.ordinaryChar(93);
        var5_7.ordinaryChar(123);
        var5_7.ordinaryChar(125);
        var5_7.ordinaryChar(45);
        var5_7.ordinaryChar(43);
        var5_7.ordinaryChar(46);
        var5_7.ordinaryChar(39);
        var5_7.ordinaryChar(92);
        var5_7.ordinaryChar(96);
        var5_7.ordinaryChar(180);
        var5_7.ordinaryChar(176);
        var5_7.wordChars(124, 124);
        var5_7.wordChars(39, 39);
        var5_7.wordChars(92, 92);
        var5_7.wordChars(96, 96);
        var5_7.wordChars(180, 180);
        var5_7.wordChars(176, 176);
        var5_7.wordChars(35, 35);
        var5_7.wordChars(94, 94);
        var5_7.wordChars(38, 38);
        var5_7.wordChars(36, 36);
        var5_7.wordChars(40, 40);
        var5_7.wordChars(41, 41);
        var5_7.wordChars(123, 123);
        var5_7.wordChars(125, 125);
        var5_7.wordChars(126, 126);
        var5_7.wordChars(64, 64);
        var5_7.wordChars(45, 45);
        var5_7.wordChars(43, 43);
        var5_7.wordChars(42, 42);
        var5_7.wordChars(48, 48);
        var5_7.wordChars(49, 57);
        var5_7.wordChars(46, 46);
        var5_7.wordChars(44, 44);
        var5_7.wordChars(59, 59);
        var5_7.wordChars(95, 95);
        var5_7.wordChars(58, 58);
        var5_7.whitespaceChars(61, 61);
        var6_8 = 0;
        var7_9 = null;
        var8_10 = null;
        var9_11 = false;
        var10_12 = false;
        var11_13 = false;
        var12_14 = false;
        var13_15 = false;
        var14_16 = false;
        var15_17 = true;
        block30: while (true) {
            while (true) {
                if (var10_12) {
                    if (var6_8 > 0) {
                        PsDebug.warning("missing closing element");
                        if (var7_9 != null) {
                            PsDebug.warning("current element = " + var7_9.getType());
                        }
                        return false;
                    }
                    if (var6_8 < 0) {
                        PsDebug.warning("too many closing element");
                        if (var7_9 != null) {
                            PsDebug.warning("current element = " + var7_9.getType());
                        }
                        return false;
                    }
                    if (var8_10 != var7_9) {
                        PsDebug.warning("mismatch between opening and closing elements.");
                    }
                    var1_1.setRootNode(var8_10);
                    return true;
                }
                switch (var5_7.nextToken()) {
                    default: {
                        if (var14_16) {
                            if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                                var7_9.setMixedMode(true);
                                var7_9.addMixedContent(var7_9.getChild());
                            }
                            var7_9.appendContent(String.valueOf((char)var5_7.ttype));
                            break;
                        }
                        PsDebug.warning("parsing broke abnormally\n\t in line=" + var5_7.lineno() + " reading st.sval=" + var5_7.sval + ", st.ttype=" + var5_7.ttype);
                        return false;
                    }
                    case 10: {
                        if (!var12_14 || var7_9 == null || !var7_9.hasContent()) continue block30;
                        var7_9.appendContent("\n");
                        break;
                    }
                    case -1: {
                        var10_12 = true;
                        break;
                    }
                    case 60: {
                        var5_7.whitespaceChars(32, 32);
                        var5_7.ordinaryChar(47);
                        var5_7.ordinaryChar(34);
                        var5_7.quoteChar(34);
                        if (var12_14 && var7_9 != null && var7_9.hasContent() && var7_9.contentEndsWith('\n')) {
                            var16_19 = var7_9.getContent();
                            var16_19 = var16_19.substring(0, var16_19.length() - 1);
                            var7_9.setContent(var16_19);
                        }
                        var12_14 = false;
                        var16_18 = var5_7.nextToken();
                        if (var16_18 == 33 || var16_18 == 63) {
                            var5_7.nextToken();
                            if (var5_7.sval.equals("xml")) {
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            if (var5_7.sval.equals("DOCTYPE")) {
                                var5_7.nextToken();
                                if (var5_7.sval != null) {
                                    var1_1.setDocName(var5_7.sval);
                                } else {
                                    PsDebug.warning("missing DTD doc name.");
                                }
                                var17_21 = var5_7.nextToken();
                                if (var5_7.sval != null && var5_7.sval.equals("SYSTEM")) {
                                    var5_7.nextToken();
                                    if (var5_7.sval != null) {
                                        var1_1.setDocType(var5_7.sval);
                                    } else {
                                        PsDebug.warning("missing DTD doc type.");
                                    }
                                } else if (var5_7.sval != null && var5_7.sval.equals("PUBLIC")) {
                                    var5_7.nextToken();
                                    var5_7.nextToken();
                                    if (var5_7.sval != null) {
                                        var1_1.setDocType(var5_7.sval);
                                    } else {
                                        var5_7.pushBack();
                                    }
                                } else if (var17_21 == 91) {
                                    var13_15 = true;
                                } else {
                                    PsDebug.warning("error while parsing doctype.\n\t in line=" + var5_7.lineno() + " reading st.sval=" + var5_7.sval + ", st.ttype=" + var5_7.ttype);
                                }
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            if (var5_7.sval.equals("ENTITY")) {
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            if (var5_7.sval.equals("ELEMENT")) {
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            if (var5_7.sval.equals("ATTLIST")) {
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            if (var5_7.sval.equals("--")) {
                                do {
                                    if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                                } while (var16_18 != -1);
                                break;
                            }
                            PsDebug.warning("unknown command.\n\t in line=" + var5_7.lineno() + " reading st.sval=" + var5_7.sval + ", st.ttype=" + var5_7.ttype);
                            do {
                                if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                            } while (var16_18 != -1);
                            break;
                        }
                        if (var5_7.sval != null && var5_7.sval.equals("!--")) {
                            do {
                                if ((var16_18 = var5_7.nextToken()) == 62) continue block30;
                            } while (var16_18 != -1);
                            break;
                        }
                        if (var5_7.sval != null && var5_7.sval.equals("![CDATA[")) {
                            var5_7.ordinaryChar(93);
                            var5_7.wordChars(32, 32);
                            var5_7.wordChars(61, 61);
                            var5_7.ordinaryChar(34);
                            var5_7.wordChars(34, 34);
                            var5_7.wordChars(47, 47);
                            var17_22 = new StringBuffer();
                            if (var7_9.hasContent()) {
                                var7_9.appendContent("\n");
                            }
                            var7_9.appendContent("<" + var5_7.sval);
                            var18_24 = true;
                            block40: while (var18_24) {
                                var19_27 = var5_7.nextToken();
                                switch (var19_27) {
                                    default: {
                                        if (var5_7.sval != null) {
                                            var17_22.append(var5_7.sval);
                                            continue block40;
                                        }
                                        var20_29 = (char)var5_7.ttype;
                                        var17_22.append(var20_29);
                                        continue block40;
                                    }
                                    case 93: {
                                        var17_22.append("]");
                                        if (var5_7.nextToken() != 93) continue block40;
                                        var17_22.append("]");
                                        if (var5_7.nextToken() != 62) continue block40;
                                        var17_22.append(">");
                                        if (!var7_9.hasContent()) {
                                            var7_9.setContent(var17_22.toString());
                                        } else {
                                            var7_9.appendContent(var17_22.toString());
                                        }
                                        var18_24 = false;
                                        continue block40;
                                    }
                                    case 10: {
                                        var17_22.append("\n");
                                        continue block40;
                                    }
                                    case -1: 
                                }
                                PsDebug.warning("premature end of a CDATA block, missed ']]>' closing");
                                return false;
                            }
                            var5_7.wordChars(93, 93);
                            var5_7.whitespaceChars(32, 32);
                            var5_7.whitespaceChars(61, 61);
                            var5_7.ordinaryChar(34);
                            var5_7.quoteChar(34);
                            var5_7.ordinaryChar(47);
                            break;
                        }
                        if (var16_18 == 47) {
                            --var6_8;
                            var5_7.nextToken();
                            if (!(var5_7.sval.equals(var7_9.getType()) && var7_9.isExpanded() || (var7_9 = var7_9.getFather()).getType().equals(var5_7.sval))) {
                                PsDebug.warning("closing element <" + var5_7.sval + "> does not match open element <" + var7_9.getType() + "> " + "in line=" + var5_7.lineno());
                            }
                            if (var7_9.isMixedMode() && var7_9.hasContent()) {
                                var7_9.addMixedContent(var7_9.getContent());
                                var7_9.setContent(null);
                            }
                            var7_9.setExpanded(false);
                            if (var7_9 != var8_10) continue block30;
                            var9_11 = true;
                            break;
                        }
                        if (var15_17) {
                            var15_17 = false;
                            var5_7.wordChars(33, 33);
                            var5_7.wordChars(63, 63);
                            var5_7.wordChars(91, 91);
                            var5_7.wordChars(93, 93);
                        }
                        var14_16 = false;
                        ++var6_8;
                        var17_23 = new PsXmlNode(var5_7.sval);
                        if (var7_9 == null) {
                            var8_10 = var17_23;
                        } else if (var7_9.isExpanded()) {
                            var7_9.addChild(var17_23);
                            var18_25 = var7_9.isMixedMode();
                            if (!var18_25 && var7_9.hasContent()) {
                                var7_9.setMixedMode(true);
                                var18_25 = true;
                            }
                            if (var18_25) {
                                if (var7_9.hasContent()) {
                                    var7_9.addMixedContent(var7_9.getContent());
                                    var7_9.setContent(null);
                                }
                                var7_9.addMixedContent(var17_23);
                            }
                        } else {
                            var7_9.setSibling(var17_23);
                        }
                        var7_9 = var17_23;
                        var7_9.setExpanded(true);
                        var11_13 = true;
                        var5_7.whitespaceChars(61, 61);
                        break;
                    }
                    case 62: {
                        var11_13 = false;
                        var5_7.ordinaryChar(61);
                        var5_7.wordChars(61, 61);
                        var14_16 = true;
                        var5_7.ordinaryChar(34);
                        var5_7.wordChars(34, 34);
                        var5_7.wordChars(47, 47);
                        if (var9_11) {
                            var10_12 = true;
                            break;
                        }
                        if (var7_9 == null || var7_9.isExpanded() || var7_9.getFather() == null || !var7_9.getFather().isMixedMode()) continue block30;
                        var7_9 = var7_9.getFather();
                        break;
                    }
                    case 93: {
                        if (var13_15) {
                            var13_15 = false;
                            break;
                        }
                        if (!var14_16) continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("]");
                        break;
                    }
                    case 47: {
                        if (var11_13) {
                            if (var5_7.nextToken() == 62) {
                                var11_13 = false;
                                --var6_8;
                                var7_9.setExpanded(false);
                                break;
                            }
                            PsDebug.error("found '/' in attribute mode, error in line=" + var5_7.lineno());
                            return false;
                        }
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("/");
                        var12_14 = true;
                        break;
                    }
                    case 91: {
                        if (!var14_16) continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent(" [");
                        break;
                    }
                    case 34: {
                        if (!var14_16) continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("\"");
                        break;
                    }
                    case 33: {
                        if (!var14_16) continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("!");
                        break;
                    }
                    case 63: {
                        if (!var14_16) continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("?");
                        break;
                    }
                    case 61: {
                        if (var14_16) ** break;
                        continue block30;
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        var7_9.appendContent("=");
                        break;
                    }
                    case -3: {
                        if (var11_13) {
                            var18_26 = var5_7.sval;
                            var5_7.ordinaryChar(34);
                            if (var5_7.nextToken() == 34) {
                                var19_28 = null;
                                var5_7.ordinaryChar(32);
                                var5_7.wordChars(32, 32);
                                var5_7.ordinaryChar(61);
                                var5_7.wordChars(61, 61);
                                var20_29 = '\u0001';
                                block41: while (var20_29 != '\u0000') {
                                    switch (var5_7.nextToken()) {
                                        case -1: {
                                            PsDebug.warning("premature end of attribute = " + var18_26 + ", missed '\"' closing");
                                            return false;
                                        }
                                        case 34: {
                                            if (var19_28 == null) {
                                                var19_28 = "";
                                            }
                                            var7_9.addAttribute(var18_26, var19_28);
                                            var20_29 = '\u0000';
                                            continue block41;
                                        }
                                        case 10: {
                                            if (var19_28 == null) {
                                                var19_28 = "\n";
                                                continue block41;
                                            }
                                            var19_28 = var19_28 + "\n";
                                            continue block41;
                                        }
                                        case -3: {
                                            if (var19_28 == null) {
                                                var19_28 = var5_7.sval;
                                                continue block41;
                                            }
                                            var19_28 = var19_28 + var5_7.sval;
                                            continue block41;
                                        }
                                    }
                                    var21_30 = String.valueOf((char)var5_7.ttype);
                                    if (var19_28 == null) {
                                        var19_28 = var21_30;
                                        continue;
                                    }
                                    var19_28 = var19_28 + var21_30;
                                }
                                var5_7.whitespaceChars(32, 32);
                                var5_7.whitespaceChars(61, 61);
                            } else {
                                PsDebug.warning("attribute value not enclosed with quotes \"att-value\".");
                                var7_9.addAttribute(var18_26, var5_7.sval);
                            }
                            var5_7.quoteChar(34);
                            break;
                        }
                        if (!var7_9.isExpanded()) {
                            var7_9 = var7_9.getFather();
                        }
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                            var7_9.addMixedContent(var7_9.getChild());
                        }
                        if (!var7_9.hasContent()) {
                            var7_9.setContent(var5_7.sval);
                        } else if (var7_9.contentEndsWith('\n') || var7_9.contentEndsWith('/')) {
                            var7_9.appendContent(var5_7.sval);
                        } else {
                            var7_9.appendContent(" " + var5_7.sval);
                        }
                        var12_14 = true;
                        break;
                    }
                    case -2: {
                        if (!var7_9.isMixedMode() && var7_9.getChild() != null) {
                            var7_9.setMixedMode(true);
                        }
                        if (!var7_9.hasContent()) {
                            var7_9.setContent(String.valueOf(var5_7.nval));
                        } else {
                            var7_9.appendContent(" " + String.valueOf(var5_7.nval));
                        }
                        var12_14 = true;
                    }
                }
            }
            break;
        }
        catch (Exception var16_20) {
            PsDebug.warning("Exception thrown in line=" + var5_7.lineno() + ", Exception = " + var16_20);
            return false;
        }
    }

    public static PdVector[] parseDoubleList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            pdVectorArray[i] = PsXmlLoader.parsePdVector(psXmlNodeArray[i], stringArray);
            if (pdVectorArray[i] != null) continue;
            PsDebug.warning("failed to parse vector at index = " + i);
            return null;
        }
        return pdVectorArray;
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(psXmlNode2, stringArray);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PdVector pdVector = PsXmlLoader.parsePdVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(pdVector, psXmlNode, stringArray);
        }
        return pdVector;
    }

    public static void parseVectorAttr(P_Vector p_Vector, PsXmlNode psXmlNode, String[] stringArray) {
        if (p_Vector == null || psXmlNode == null || stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = psXmlNode.getAttribute(stringArray[i]);
            if (string == null) continue;
            if (string.equalsIgnoreCase("mark")) {
                p_Vector.setTag(1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("name")) {
                p_Vector.setName(string);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("detail")) {
                string = PuString.replace(string, "\\n", "\n");
                p_Vector.setDetail(string);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("url")) {
                p_Vector.setURL(string);
                continue;
            }
            PsDebug.warning("unknown attribute = " + stringArray[i]);
            stringArray = null;
            break;
        }
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            return new PdVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PdVector();
        }
        PdVector pdVector = new PdVector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            pdVector.setEntry(i, PuDouble.parseDouble(stringArray[i]));
        }
        return pdVector;
    }

    public static PdMatrix parsePdMatrix(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing parent node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            PsDebug.warning("missing matrix node.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "row");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            PsDebug.warning("missing rows in matrix");
            return null;
        }
        String[] stringArray = PuString.splitString(psXmlNodeArray[0].getContent(), ' ');
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing entries in row = 0");
            return null;
        }
        int n = psXmlNodeArray.length;
        int n2 = stringArray.length;
        PdMatrix pdMatrix = new PdMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            stringArray = PuString.splitString(psXmlNodeArray[i].getContent(), ' ');
            if (stringArray == null || stringArray.length != n2) {
                PsDebug.warning("invalid number of entries in row = " + i);
                return null;
            }
            for (int j = 0; j < n2; ++j) {
                pdMatrix.setEntry(i, j, PuDouble.parseDouble(stringArray[j]));
            }
        }
        return pdMatrix;
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            return new PiVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PiVector();
        }
        PiVector piVector = new PiVector(stringArray.length);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                piVector.setEntry(i, Integer.parseInt(stringArray[i]));
            }
            return piVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector[] parseIntegerList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            piVectorArray[i] = PsXmlLoader.parsePiVector(psXmlNodeArray[i], stringArray);
            if (piVectorArray[i] != null) continue;
            PsDebug.warning("failed to parse vector at index = " + i);
            return null;
        }
        return piVectorArray;
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(psXmlNode2, stringArray);
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PiVector piVector = PsXmlLoader.parsePiVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(piVector, psXmlNode, stringArray);
        }
        return piVector;
    }

    public static Color[] parseColorList(PsXmlNode psXmlNode, String string) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        Color[] colorArray = new Color[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            colorArray[i] = PsXmlLoader.parseColorContent(psXmlNodeArray[i]);
            if (colorArray[i] != null) continue;
            PsDebug.warning("failed to parse color at index = " + i);
            return null;
        }
        return colorArray;
    }

    public static Color parseColorRGB(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(psXmlNode2);
    }

    public static Color parseColorContent(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        String string = psXmlNode.getContent();
        return PdColor.parseColor(string);
    }

    public static PsXmlNode addMatrix(PsXmlNode psXmlNode, String string, PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        int n = pdMatrix.getNumRows();
        for (int i = 0; i < n; ++i) {
            psXmlNode2.addChild("row", PuString.toString(pdMatrix.m_data[i], false));
        }
        return psXmlNode2;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector pdVector, int n) {
        if (pdVector == null || pdVector.getSize() < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            psXmlNode.addChild(string, PuString.toString(pdVector.getEntry(i)));
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        boolean bl = "p".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            PsXmlLoader.addVector(psXmlNode, string, pdVectorArray[i], bl);
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length < n) {
            return;
        }
        boolean bl = "e".equals(string) || "f".equals(string) || "l".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            PsXmlLoader.addVector(psXmlNode, string, piVectorArray[i], bl);
        }
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PdVector pdVector, boolean bl) {
        if (pdVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(pdVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, pdVector, bl);
        return psXmlNode2;
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PiVector piVector, boolean bl) {
        if (piVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(piVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, piVector, bl);
        return psXmlNode2;
    }

    private static PsXmlNode addVectorAttr(PsXmlNode psXmlNode, P_Vector p_Vector, boolean bl) {
        if (bl) {
            String string = p_Vector.getName();
            if (string != null) {
                psXmlNode.addAttribute("name", string);
            }
            if ((string = p_Vector.getURL()) != null) {
                psXmlNode.addAttribute("url", string);
            }
            if ((string = p_Vector.getDetail()) != null) {
                string = PuString.replace(string, "\n", "\\n");
                psXmlNode.addAttribute("detail", string);
            }
        }
        if (p_Vector.hasTag(1)) {
            psXmlNode.addAttribute("tag", "mark");
        }
        return psXmlNode;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[][] pdVectorArray, int n) {
        int n2;
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (pdVectorArray[n2] != null) continue;
            return;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < pdVectorArray[i].length; ++j) {
                psXmlNode.addChild(string, PuString.toString(pdVectorArray[i][j].m_data));
            }
            n2 += pdVectorArray[i].length;
        }
        psXmlNode.addAttribute("num", String.valueOf(n2));
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, Color[] colorArray, int n) {
        if (colorArray == null || colorArray.length < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            String string2 = String.valueOf(colorArray[i].getRed()) + " " + String.valueOf(colorArray[i].getGreen()) + " " + String.valueOf(colorArray[i].getBlue());
            psXmlNode.addChild(string, string2);
        }
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, String string2, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        if (PsXmlLoader.addColor(psXmlNode2, string2, color) == null) {
            return null;
        }
        return psXmlNode2;
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        psXmlNode2.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        psXmlNode2.addAttribute("type", "rgb");
        return psXmlNode2;
    }
}

