/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgStlLoader
extends PgAbstractLoader {
    protected int m_numVertices = 0;
    protected int m_numElements = 0;
    protected int m_numElementNormals = 0;
    protected Vector m_vVertex;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementNormal;
    protected String m_name;

    public PgStlLoader() {
        this.m_bIsEnabledOptimization = true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        P_Vector[] p_VectorArray;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setEnabledInstanceSharing(true);
        if (!PuString.isEmpty(this.m_name)) {
            pgJvxSrc.setName(this.m_name);
        }
        pgJvxSrc.setType(33);
        if (this.m_numVertices > 0) {
            p_VectorArray = (PiVector[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(p_VectorArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            Object[] objectArray = new PdVector[this.m_numVertices];
            this.m_vVertex.copyInto(objectArray);
            pgJvxSrc.setVertices((PdVector[])objectArray);
            this.m_vVertex = null;
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            p_VectorArray = new PiVector[this.m_numElements];
            this.m_vElement.copyInto(p_VectorArray);
            pgJvxSrc.setElements((PiVector[])p_VectorArray);
            this.m_vElement = null;
        }
        if (this.m_numElements > 0 && this.m_numElementNormals == this.m_numElements) {
            p_VectorArray = new PdVector[this.m_numElements];
            this.m_vElementNormal.copyInto(p_VectorArray);
            pgJvxSrc.setElementNormals((PdVector[])p_VectorArray);
            this.m_vElementNormal = null;
        }
        pgJvxSrc.showEdges(true);
        pgJvxSrc.showElements(true);
        pgJvxSrc.setEnabledInstanceSharing(false);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parse(BufferedReader bufferedReader) {
        int n = 200;
        int[] nArray = new int[n];
        this.m_vVertex = new Vector();
        this.m_vElement = new Vector();
        this.m_vElementNormal = new Vector();
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.ordinaryChars(95, 95);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.commentChar(35);
        this.m_numVertices = 0;
        this.m_numElementNormals = 0;
        this.m_numElements = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        try {
            block7: while (true) {
                int n3;
                int n4;
                switch (streamTokenizer.nextToken()) {
                    default: {
                        throw new IOException("unknown token type = " + streamTokenizer.ttype);
                    }
                    case -1: {
                        return true;
                    }
                    case 10: {
                        continue block7;
                    }
                    case -3: 
                }
                if (bl2 && "vertex".equals(streamTokenizer.sval)) {
                    PdVector pdVector = new PdVector(3);
                    for (n4 = 0; n4 < 3; ++n4) {
                        streamTokenizer.nextToken();
                        pdVector.m_data[n4] = PuDouble.parseDouble(streamTokenizer.sval);
                    }
                    this.m_vVertex.addElement(pdVector);
                    nArray[n2++] = this.m_numVertices++;
                    continue;
                }
                if (bl && "normal".equals(streamTokenizer.sval)) {
                    PdVector pdVector = new PdVector(3);
                    for (n4 = 0; n4 < 3; ++n4) {
                        streamTokenizer.nextToken();
                        pdVector.m_data[n4] = PuDouble.parseDouble(streamTokenizer.sval);
                    }
                    pdVector.normalize();
                    this.m_vElementNormal.addElement(pdVector);
                    ++this.m_numElementNormals;
                    continue;
                }
                if (!bl && "facet".equals(streamTokenizer.sval)) {
                    bl = true;
                    continue;
                }
                if (bl && "endfacet".equals(streamTokenizer.sval)) {
                    bl = false;
                    if (n2 <= 0) throw new IOException("face with no vertex");
                    ++this.m_numElements;
                    PiVector piVector = new PiVector(n2);
                    piVector.copy(nArray, n2);
                    n2 = 0;
                    this.m_vElement.addElement(piVector);
                    continue;
                }
                if (bl && "outer".equals(streamTokenizer.sval)) {
                    bl2 = true;
                    continue;
                }
                if (bl && "loop".equals(streamTokenizer.sval)) {
                    bl2 = true;
                    continue;
                }
                if (bl && "endloop".equals(streamTokenizer.sval)) {
                    bl2 = false;
                    continue;
                }
                if ("solid".equals(streamTokenizer.sval)) {
                    this.m_name = "";
                    n3 = streamTokenizer.nextToken();
                    if (n3 == 10) continue;
                } else {
                    if ("endsolid".equals(streamTokenizer.sval)) {
                        int n5 = streamTokenizer.nextToken();
                        while (true) {
                            if (n5 == 10 || n5 == -1) continue block7;
                            n5 = streamTokenizer.nextToken();
                        }
                    }
                    if (!"end".equals(streamTokenizer.sval)) throw new IOException("Unknown token = " + streamTokenizer.sval);
                    PsDebug.warning("Found stl file with trailing 'end solid', still continue parsing.");
                    int n6 = streamTokenizer.nextToken();
                    while (true) {
                        if (n6 == 10 || n6 == -1) continue block7;
                        n6 = streamTokenizer.nextToken();
                    }
                }
                streamTokenizer.ordinaryChar(32);
                streamTokenizer.wordChars(32, 32);
                do {
                    if (streamTokenizer.sval != null) {
                        this.m_name = this.m_name + streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.ttype != 92) continue;
                    this.m_name = this.m_name + "\\";
                } while ((n3 = streamTokenizer.nextToken()) != 10 && n3 != -1);
                streamTokenizer.whitespaceChars(32, 32);
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype);
            return false;
        }
    }

    public static boolean isAscii(BufferedReader bufferedReader) throws IOException {
        char[] cArray = new char[5];
        bufferedReader.mark(5);
        bufferedReader.read(cArray);
        bufferedReader.reset();
        String string = new String(cArray);
        return string.equalsIgnoreCase("solid");
    }

    public PgJvxSrc[] read(DataInputStream dataInputStream) {
        PgJvxSrc[] pgJvxSrcArray = null;
        try {
            int n;
            Object object;
            DataInputStream dataInputStream2 = dataInputStream;
            byte[] byArray = new byte[80];
            dataInputStream2.read(byArray);
            pgJvxSrcArray = new PgJvxSrc[]{new PgJvxSrc()};
            PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
            pgJvxSrc.setType(33);
            boolean bl = true;
            bl &= byArray[0] == 67;
            bl &= byArray[1] == 79;
            bl &= byArray[2] == 76;
            bl &= byArray[3] == 79;
            bl &= byArray[4] == 82;
            if (bl &= byArray[5] == 61) {
                object = new Color((byArray[6] + 256) % 256, (byArray[7] + 256) % 256, (byArray[8] + 256) % 256);
                pgJvxSrc.setGlobalElementColor((Color)object);
            }
            object = new int[4];
            for (n = 0; n < 4; ++n) {
                object[3 - n] = dataInputStream2.read();
            }
            n = (object[0] << 24) + (object[1] << 16) + (object[2] << 8) + object[3];
            byArray = new byte[50];
            pgJvxSrc.setNumVertices(n * 3);
            pgJvxSrc.setNumElements(n);
            pgJvxSrc.assureElementNormals();
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                dataInputStream2.read(byArray);
                for (n3 = 0; n3 < 3; ++n3) {
                    pdVectorArray2[i].m_data[n3] = PgStlLoader.arr2float(byArray, n3 * 4);
                }
                piVectorArray[i] = new PiVector(3);
                for (n3 = 0; n3 < 3; ++n3) {
                    for (int j = 0; j < 3; ++j) {
                        pdVectorArray[n2].m_data[j] = PgStlLoader.arr2float(byArray, (n3 + 1) * 12 + j * 4);
                    }
                    piVectorArray[i].m_data[n3] = n2++;
                }
            }
            if (n > 0) {
                pgJvxSrc.setDimOfVertices(pgJvxSrc.getVertex(0).getSize());
            } else {
                pgJvxSrc.setDimOfVertices(3);
            }
            pgJvxSrc.setVisible(true);
            pgJvxSrc.setElementNormals(pdVectorArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PsDebug.warning("Error while reading file.");
        }
        return pgJvxSrcArray;
    }

    private static float arr2float(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 32; i += 8) {
            n3 = (int)((long)n3 | (long)(byArray[n + n2] & 0xFF) << i);
            ++n2;
        }
        return Float.intBitsToFloat(n3);
    }

    private static void float2arr(float f, byte[] byArray, int n) {
        if (byArray.length <= n + 3) {
            return;
        }
        int n2 = Float.floatToIntBits(f);
        for (int i = 0; i < 4; ++i) {
            byArray[n + i] = new Integer(n2 % 256).byteValue();
            n2 >>= 8;
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        int n = 0;
        PgJvxSrc pgJvxSrc = null;
        while ((pgJvxSrc = pgJvxSrcArray[n]).getType() != 33 || pgJvxSrc.getDimOfVertices() != 3) {
            if (++n != pgJvxSrcArray.length) continue;
            PsDebug.warning("geometry array did not contain a 3D element set, STL export failed.");
            return false;
        }
        writer.write("solid " + pgJvxSrc.getName() + "\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
        String string = "\t";
        String string2 = "\t\t";
        String string3 = "\t\t\t";
        int n2 = pgJvxSrc.getNumElements();
        for (int i = 0; i < n2; ++i) {
            writer.write(string + "facet");
            if (pdVectorArray2 != null && pdVectorArray2[i] != null) {
                String string4 = PuString.toString(pdVectorArray2[i].m_data, true, false);
                writer.write(" normal " + string4);
            }
            writer.write("\n");
            writer.write(string2 + "outer loop\n");
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                String string5 = PuString.toString(pdVectorArray[piVectorArray[i].m_data[j]].m_data, true, false);
                writer.write(string3 + "vertex " + string5 + "\n");
            }
            writer.write(string2 + "endloop\n");
            writer.write(string + "endfacet\n");
        }
        writer.write("endsolid " + pgJvxSrc.getName());
        return true;
    }
}

