/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgMathLoader
extends PgAbstractLoader {
    protected int m_dim = 0;
    protected boolean m_bIsKeyAnimation = false;
    protected Vector m_graphicsVector;
    protected int m_numGraphics = 0;
    protected Vector m_displayOptionVector;
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected PdVector m_viewVertical;
    protected Vector m_viewVerticalVector;
    protected Color m_defaultColor;
    protected Vector m_defaultColorVector;
    protected Color m_bndBoxColor;
    protected Vector m_bndBoxColorVector;
    protected PdVector m_boxRatio;
    protected Vector m_boxRatioVector;
    protected Vector m_graphicsArrayPosition;
    private int m_arrayCount0 = 0;
    private int m_arrayCount1 = 0;
    private boolean m_bGrayLevel = false;
    private Vector m_bGrayLevelVector;
    private boolean m_bBlackWhite = false;
    private Vector m_bBlackWhiteVector;
    private boolean m_isGraphicsArray = false;
    private static final int COLOR_FACE_FRONT = 0;
    private static final int COLOR_FACE_BACK = 1;
    private static final int COLOR_FACE_FRONT_REFL = 2;
    private static final int COLOR_FACE_BACK_REFL = 3;
    private static final int COLOR_FACE_FRONT_NOLIGHTS = 4;
    private static final int COLOR_FACE_BACK_NOLIGHTS = 5;
    private static final int COLOR_ELEMENT_EDGE = 6;
    private static final int COLOR_POINT = 7;
    private static final int COLOR_POLYGON = 8;
    private static final int COLOR_DISK = 9;
    private static final int COLOR_CIRCLE = 10;
    private static final int COLOR_TEXT = 11;
    private static final int COLOR_FUNCTION_GRAY = 0;
    private static final int COLOR_FUNCTION_HUE = 1;
    private int m_colorFunction = 0;
    private boolean m_bColorFunctionScaling = true;
    private double m_aspectRatio = 0.6180339887;
    private static boolean m_bVersion_6_0 = true;
    private Color[] m_tmpColor;

    public boolean isEnabledOptimization() {
        return true;
    }

    public void setMathematicaVersion(double d) {
        m_bVersion_6_0 = !(d < 6.0);
    }

    public boolean isKeyAnimation() {
        return this.m_bIsKeyAnimation;
    }

    public void setKeyAnimation(boolean bl) {
        this.m_bIsKeyAnimation = bl;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        int n2;
        int n3;
        int n4;
        this.m_aspectRatio = m_bVersion_6_0 ? 0.0 : 0.6180339887;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.m_graphicsVector = new Vector();
        this.m_displayOptionVector = new Vector();
        this.m_viewVerticalVector = new Vector();
        this.m_defaultColorVector = new Vector();
        this.m_bndBoxColorVector = new Vector();
        this.m_boxRatioVector = new Vector();
        this.m_bGrayLevelVector = new Vector();
        this.m_bBlackWhiteVector = new Vector();
        this.m_graphicsArrayPosition = new Vector();
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        if (this.m_numGraphics == 0) {
            PsDebug.warning("missing graphics");
            return null;
        }
        this.evaluateOptions();
        int n5 = 0;
        for (int i = 0; i < this.m_numGraphics; ++i) {
            n5 += this.m_animArr[i].length;
        }
        if (this.m_isGraphicsArray) {
            PiVector[] piVectorArray = new PiVector[this.m_numGraphics];
            n4 = 1;
            for (n3 = 0; n3 < this.m_numGraphics; ++n3) {
                piVectorArray[n3] = (PiVector)this.m_graphicsArrayPosition.elementAt(n3);
                if (piVectorArray[n3].getSize() != 2) continue;
                n4 = 2;
            }
            n3 = 0;
            n2 = 0;
            for (n = 0; n < this.m_numGraphics; ++n) {
                if (n4 == 1) {
                    if (n2 >= piVectorArray[n].m_data[0]) continue;
                    n2 = piVectorArray[n].m_data[0];
                    continue;
                }
                if (n3 < piVectorArray[n].m_data[0]) {
                    n3 = piVectorArray[n].m_data[0];
                }
                if (n2 >= piVectorArray[n].m_data[1]) continue;
                n2 = piVectorArray[n].m_data[1];
            }
            ++n3;
            ++n2;
            for (n = 0; n < this.m_numGraphics; ++n) {
                if (n4 == 1) {
                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArrayPosition(piVectorArray[n].m_data[0]);
                } else {
                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArrayPosition(piVectorArray[n].m_data[0] * n2 + piVectorArray[n].m_data[1]);
                }
                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArraySize(new Dimension(n2, n3));
            }
        } else {
            ((PvDisplayOption)this.m_displayOptionVector.elementAt(0)).setArrayPosition(0);
            ((PvDisplayOption)this.m_displayOptionVector.elementAt(0)).setArraySize(new Dimension(1, 1));
        }
        if (!this.isAnimation() && !this.isKeyAnimation() && this.m_animArr.length > 1) {
            PgJvxSrc[][] pgJvxSrcArrayArray = new PgJvxSrc[][]{new PgJvxSrc[n5]};
            n4 = 0;
            for (n3 = 0; n3 < this.m_numGraphics; ++n3) {
                n2 = this.m_animArr[n3].length;
                for (n = 0; n < n2; ++n) {
                    pgJvxSrcArrayArray[0][n4] = this.m_animArr[n3][n];
                    ++n4;
                }
            }
            this.m_animArr = pgJvxSrcArrayArray;
        }
        if (this.m_animArr == null || this.m_animArr.length == 0) {
            return null;
        }
        return this.m_animArr[0];
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                break;
            }
            case 33: {
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalElementBackColor(Color.white);
                pgJvxSrc.setGlobalElementColor(Color.white);
                pgJvxSrc.showElements(true);
                if (pgJvxSrc.getElementNormals() != null || pgJvxSrc.getDimOfVertices() != 3) break;
                pgJvxSrc.makeElementNormals();
                break;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                break;
            }
            case 36: {
                pgJvxSrc.showVertices(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(BufferedReader bufferedReader) {
        try {
            this.m_displayOption = new PvDisplayOption();
            this.setDisplayDefault();
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(123);
            streamTokenizer.ordinaryChar(125);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.ordinaryChar(35);
            streamTokenizer.ordinaryChar(38);
            streamTokenizer.ordinaryChar(36);
            streamTokenizer.ordinaryChar(40);
            streamTokenizer.ordinaryChar(41);
            streamTokenizer.parseNumbers();
            streamTokenizer.ordinaryChar(45);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            int n = 0;
            int n2 = 0;
            block12: while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally reading st.sval = " + streamTokenizer.sval + ", st.ttype = " + streamTokenizer.ttype + "  in line: " + streamTokenizer.lineno());
                        continue block12;
                    }
                    case -1: {
                        if (n != 0) {
                            PsDebug.warning("'}' missing");
                            return false;
                        }
                        if (n2 == 0) return true;
                        PsDebug.warning("']' missing");
                        return false;
                    }
                    case -3: {
                        if ("InputForm".equals(streamTokenizer.sval)) continue block12;
                        if ("Graphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readGraphics(streamTokenizer, true)) {
                                PsDebug.warning("failed reading Graphics");
                                return false;
                            }
                            this.nextGraphics(n);
                            continue block12;
                        }
                        if ("Graphics3D".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readGraphics(streamTokenizer, true)) {
                                PsDebug.warning("failed reading Graphics3D");
                                return false;
                            }
                            this.nextGraphics(n);
                            continue block12;
                        }
                        if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                return false;
                            }
                            this.nextGraphics(n);
                            continue block12;
                        }
                        if ("DensityGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                return false;
                            }
                            this.nextGraphics(n);
                            continue block12;
                        }
                        if (!("KeyAnimation".equals(streamTokenizer.sval) || "Animation".equals(streamTokenizer.sval) || "ShowAnimation".equals(streamTokenizer.sval) || "GraphicsArray".equals(streamTokenizer.sval))) {
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        if ("KeyAnimation".equals(streamTokenizer.sval)) {
                            this.m_bIsKeyAnimation = true;
                        } else if ("Animation".equals(streamTokenizer.sval)) {
                            this.m_bIsAnimation = true;
                        } else if ("ShowAnimation".equals(streamTokenizer.sval)) {
                            this.m_bIsKeyAnimation = true;
                        } else if ("GraphicsArray".equals(streamTokenizer.sval)) {
                            this.m_isGraphicsArray = true;
                        }
                        streamTokenizer.nextToken();
                        int n3 = n++;
                        int n4 = n2++;
                        if (streamTokenizer.ttype != 123 && streamTokenizer.ttype != 91) {
                            PsDebug.warning("Expected '{' or '['  Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        while (true) {
                            if (n == n3 && n2 == n4) continue block12;
                            streamTokenizer.nextToken();
                            if ("Graphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readGraphics(streamTokenizer, true)) {
                                    PsDebug.warning("failed reading Graphics");
                                    continue;
                                }
                                this.nextGraphics(n);
                                continue;
                            }
                            if ("Graphics3D".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readGraphics(streamTokenizer, true)) {
                                    PsDebug.warning("failed reading Graphics3D");
                                    continue;
                                }
                                this.nextGraphics(n);
                                continue;
                            }
                            if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                    continue;
                                }
                                this.nextGraphics(n);
                                continue;
                            }
                            if ("DensityGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                    return false;
                                }
                                this.nextGraphics(n);
                                continue;
                            }
                            if (streamTokenizer.ttype == 123) {
                                ++n;
                                continue;
                            }
                            if (streamTokenizer.ttype == 125) {
                                if (--n != 1) continue;
                                this.m_arrayCount1 = 0;
                                ++this.m_arrayCount0;
                                continue;
                            }
                            if (streamTokenizer.ttype == 91) {
                                ++n2;
                                continue;
                            }
                            if (streamTokenizer.ttype == 93) {
                                --n2;
                                continue;
                            }
                            if (streamTokenizer.ttype == 44) continue;
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if (!this.readOptions(streamTokenizer, true)) continue;
                            streamTokenizer.ordinaryChar(45);
                        }
                    }
                    case 40: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 42) {
                            streamTokenizer.pushBack();
                            continue block12;
                        }
                        int n3 = 1;
                        while (true) {
                            if (n3 == 0) continue block12;
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 42) continue;
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 41) {
                                n3 = 0;
                                continue;
                            }
                            streamTokenizer.pushBack();
                        }
                    }
                    case 44: {
                        continue block12;
                    }
                    case 123: {
                        ++n;
                        continue block12;
                    }
                    case 125: {
                        if (--n == 1) {
                            this.m_arrayCount1 = 0;
                            ++this.m_arrayCount0;
                        }
                        if (n >= 0) continue block12;
                        PsDebug.warning("More '}' than '{' Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    case 91: {
                        ++n2;
                        continue block12;
                    }
                    case 93: 
                }
                if (--n2 < 0) break;
            }
            PsDebug.warning("More ']' than '[' Line: " + streamTokenizer.lineno());
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return false;
        }
    }

    private void nextGraphics(int n) {
        int n2;
        this.m_displayOption.setNumRulers(this.m_dim);
        if (this.m_bndBoxColor != null) {
            this.m_displayOption.setBndBoxColor(this.m_bndBoxColor);
        } else if (this.m_defaultColor != null) {
            this.m_displayOption.setBndBoxColor(this.m_defaultColor);
        } else {
            Color color = this.m_displayOption.getBackgroundColor();
            if (color != null) {
                n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (color.getRed() < 127) {
                    n4 = 255;
                }
                if (color.getBlue() < 127) {
                    n2 = 255;
                }
                if (color.getGreen() < 127) {
                    n3 = 255;
                }
                this.m_displayOption.setBndBoxColor(new Color(n4, n3, n2));
            } else {
                this.m_displayOption.setBndBoxColor(Color.black);
            }
        }
        for (int i = 0; i < this.m_dim; ++i) {
            Color color = this.m_displayOption.getRulerColor(i);
            if (color != null) continue;
            if (this.m_defaultColor != null) {
                color = this.m_defaultColor;
            } else {
                Color color2 = this.m_displayOption.getBackgroundColor();
                if (color2 != null) {
                    int n5 = 0;
                    int n6 = 0;
                    n2 = 0;
                    if (color2.getRed() < 127) {
                        n2 = 255;
                    }
                    if (color2.getBlue() < 127) {
                        n5 = 255;
                    }
                    if (color2.getGreen() < 127) {
                        n6 = 255;
                    }
                    color = new Color(n2, n6, n5);
                } else {
                    color = Color.black;
                }
            }
            this.m_displayOption.setRulerColor(i, color);
        }
        this.m_displayOptionVector.addElement(this.m_displayOption);
        PiVector piVector = new PiVector(n);
        if (n == 1) {
            piVector.m_data[0] = this.m_arrayCount0++;
        } else if (n > 1) {
            piVector.setSize(2);
            piVector.m_data[0] = this.m_arrayCount0;
            piVector.m_data[1] = this.m_arrayCount1++;
        }
        this.m_graphicsArrayPosition.addElement(piVector);
        this.m_viewVerticalVector.addElement(PdVector.copyNew(this.m_viewVertical));
        this.m_defaultColorVector.addElement(this.m_defaultColor);
        this.m_bndBoxColorVector.addElement(this.m_bndBoxColor);
        if (this.m_boxRatio != null) {
            this.m_boxRatioVector.addElement(PdVector.copyNew(this.m_boxRatio));
        } else {
            this.m_boxRatioVector.addElement(null);
        }
        this.m_bGrayLevelVector.addElement(new Boolean(this.m_bGrayLevel));
        this.m_bBlackWhiteVector.addElement(new Boolean(this.m_bBlackWhite));
        this.m_displayOption = new PvDisplayOption();
        this.setDisplayDefault();
        ++this.m_numGraphics;
    }

    private boolean readGraphics(StreamTokenizer streamTokenizer, boolean bl) {
        return this.readGraphics(streamTokenizer, bl, false);
    }

    private boolean readGraphics(StreamTokenizer streamTokenizer, boolean bl, boolean bl2) {
        try {
            int n;
            Color color;
            int n2;
            int n3;
            streamTokenizer.parseNumbers();
            this.m_defaultColor = null;
            Vector[] vectorArray = new Vector[7];
            Vector<Color> vector = new Vector<Color>();
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2) {
                for (n3 = 0; n3 <= 5; ++n3) {
                    vectorArray[n3] = new Vector();
                    vectorArray[n3].addElement(this.m_tmpColor[n3]);
                    if (this.m_tmpColor[n3] == null) continue;
                    bl3 = true;
                }
                vector.addElement(this.m_tmpColor[7]);
            } else {
                vector.addElement(null);
                for (n3 = 0; n3 <= 5; ++n3) {
                    vectorArray[n3] = new Vector();
                    vectorArray[n3].addElement(null);
                }
            }
            PiVector piVector = new PiVector(1);
            piVector.m_data[0] = 1;
            PiVector piVector2 = new PiVector(1);
            piVector2.m_data[0] = 1;
            vectorArray[6] = new Vector();
            vectorArray[6].addElement(null);
            Vector[] vectorArray2 = new Vector[12];
            for (int i = 0; i <= 11; ++i) {
                vectorArray2[i] = new Vector();
            }
            Vector<PdVector> vector2 = new Vector<PdVector>();
            Vector vector3 = new Vector();
            Vector<PiVector> vector4 = new Vector<PiVector>();
            Vector vector5 = new Vector();
            Vector<PdVector[]> vector6 = new Vector<PdVector[]>();
            Vector vector7 = new Vector();
            Vector<PiVector> vector8 = new Vector<PiVector>();
            Vector<PdVector> vector9 = new Vector<PdVector>();
            Vector<PdVector> vector10 = new Vector<PdVector>();
            Vector vector11 = new Vector();
            Vector<PdVector> vector12 = new Vector<PdVector>();
            Vector<Double> vector13 = new Vector<Double>();
            PdVector pdVector = new PdVector(1);
            pdVector.m_data[0] = this.m_dim == 3 ? 0.01 : 0.008;
            pdVector.m_data[0] = pdVector.m_data[0] * 200.0;
            boolean bl5 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            boolean bl6 = true;
            if (this.m_dim == 2) {
                bl6 = false;
            }
            double d = 1.0;
            double d2 = 1.0;
            int n14 = 0;
            int n15 = 0;
            if (bl) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'['Expected Line: " + streamTokenizer.lineno());
                    return false;
                }
            }
            if (bl2) {
                n13 = PgMathLoader.parsePointOrList(streamTokenizer, vector3, this.m_dim);
                streamTokenizer.nextToken();
            }
            boolean bl7 = false;
            String string = "";
            boolean bl8 = false;
            int n16 = -1;
            while (n16 != 0) {
                if (n16 == -1) {
                    n16 = 0;
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 45 && !bl) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                }
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 123 || streamTokenizer.ttype == 91) {
                    int n17;
                    int n18 = vector.size();
                    if (++n16 + 1 > n18) {
                        vector.addElement((Color)vector.elementAt(n18 - 1));
                        for (n17 = 0; n17 <= 6; ++n17) {
                            vectorArray[n17].addElement(vectorArray[n17].elementAt(n18 - 1));
                        }
                        piVector.setSize(n16 + 1);
                        piVector2.setSize(n16 + 1);
                        pdVector.setSize(n16 + 1);
                    } else {
                        vector.setElementAt((Color)vector.elementAt(n16 - 1), n16);
                        for (n17 = 0; n17 <= 6; ++n17) {
                            vectorArray[n17].setElementAt(vectorArray[n17].elementAt(n16 - 1), n16);
                        }
                    }
                    piVector.m_data[n16] = piVector.m_data[n16 - 1];
                    piVector2.m_data[n16] = piVector2.m_data[n16 - 1];
                    pdVector.m_data[n16] = pdVector.m_data[n16 - 1];
                    continue;
                }
                if (streamTokenizer.ttype == 125 || streamTokenizer.ttype == 93) {
                    --n16;
                    continue;
                }
                if (streamTokenizer.ttype == 44) continue;
                if (streamTokenizer.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifier expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                if ("GraphicsGroup".equals(streamTokenizer.sval)) continue;
                if ("GraphicsComplex".equals(streamTokenizer.sval)) {
                    this.m_tmpColor = new Color[8];
                    for (int i = 0; i <= 6; ++i) {
                        this.m_tmpColor[i] = (Color)vectorArray[i].elementAt(n16);
                    }
                    this.m_tmpColor[7] = (Color)vector.elementAt(n16);
                    bl7 = this.readGraphics(streamTokenizer, bl, true);
                    streamTokenizer.parseNumbers();
                    continue;
                }
                if ("Polygon".equals(streamTokenizer.sval)) {
                    int n19;
                    streamTokenizer.nextToken();
                    if (bl2) {
                        int n20 = PgMathLoader.parseIntPolygonOrList(streamTokenizer, vector4);
                        n6 += n20;
                        for (n19 = 0; n19 < n20; ++n19) {
                            for (int i = 0; i <= 6; ++i) {
                                vectorArray2[i].addElement(vectorArray[i].elementAt(n16));
                            }
                        }
                    } else {
                        PiVector piVector3 = PgMathLoader.parsePolygonOrList(streamTokenizer, vector2, this.m_dim);
                        n19 = piVector3.getSize();
                        for (int i = 0; i < n19; ++i) {
                            int n21;
                            PiVector piVector4 = new PiVector(piVector3.m_data[i]);
                            for (n21 = 0; n21 < piVector3.m_data[i]; ++n21) {
                                piVector4.m_data[n21] = n14 + n21;
                            }
                            n4 += piVector3.m_data[i];
                            n14 += piVector3.m_data[i];
                            vector4.addElement(piVector4);
                            ++n6;
                            for (n21 = 0; n21 <= 6; ++n21) {
                                vectorArray2[n21].addElement(vectorArray[n21].elementAt(n16));
                            }
                        }
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 44) continue;
                    int n22 = 1;
                    while (n22 > 0) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 91) {
                            ++n22;
                            continue;
                        }
                        if (streamTokenizer.ttype != 93) continue;
                        --n22;
                    }
                    continue;
                }
                if ("Point".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    if (!bl2) {
                        int n23 = PgMathLoader.parsePointOrList(streamTokenizer, vector5, this.m_dim);
                        for (int i = 0; i < n23; ++i) {
                            vector13.addElement(new Double(pdVector.m_data[n16]));
                            vectorArray2[7].addElement(vector.elementAt(n16));
                        }
                        n7 += n23;
                    }
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("Line".equals(streamTokenizer.sval)) {
                    int n24;
                    streamTokenizer.nextToken();
                    if (bl2) {
                        int n25 = PgMathLoader.parseIntPolygonOrList(streamTokenizer, vector8);
                        n9 += n25;
                        for (n24 = 0; n24 < n25; ++n24) {
                            vectorArray2[8].addElement(vector.elementAt(n16));
                        }
                    } else {
                        PiVector piVector5 = PgMathLoader.parsePolygonOrList(streamTokenizer, vector7, this.m_dim);
                        n24 = piVector5.getSize();
                        for (int i = 0; i < n24; ++i) {
                            PiVector piVector6 = new PiVector(piVector5.m_data[i]);
                            for (int j = 0; j < piVector5.m_data[i]; ++j) {
                                piVector6.m_data[j] = n15 + j;
                            }
                            n5 += piVector5.m_data[i];
                            n15 += piVector5.m_data[i];
                            vector8.addElement(piVector6);
                            ++n9;
                            vectorArray2[8].addElement(vector.elementAt(n16));
                        }
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 44) continue;
                    int n26 = 1;
                    while (n26 > 0) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 91) {
                            ++n26;
                            continue;
                        }
                        if (streamTokenizer.ttype != 93) continue;
                        --n26;
                    }
                    continue;
                }
                if ("Arrow".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    PdVector[] pdVectorArray = new PdVector[2];
                    pdVectorArray[0] = new PdVector(this.m_dim);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVectorArray[0], this.m_dim)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    pdVectorArray[1] = new PdVector(this.m_dim);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVectorArray[1], this.m_dim)) {
                        return false;
                    }
                    vector6.addElement(pdVectorArray);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                    }
                    ++n8;
                    continue;
                }
                if ("Circle".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector2 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector2, 2)) {
                        return false;
                    }
                    pdVector2.setSize(4);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        pdVector2.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        pdVector2.m_data[3] = pdVector2.m_data[2];
                    } else {
                        pdVector2.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector2.m_data[3] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        pdVector2.setSize(6);
                        streamTokenizer.nextToken();
                        pdVector2.m_data[4] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector2.m_data[5] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    }
                    ++n10;
                    vector9.addElement(pdVector2);
                    vectorArray2[10].addElement(vector.elementAt(n16));
                    continue;
                }
                if ("Disk".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector3 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector3, 2)) {
                        return false;
                    }
                    pdVector3.setSize(4);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        pdVector3.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        pdVector3.m_data[3] = pdVector3.m_data[2];
                    } else {
                        pdVector3.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector3.m_data[3] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        pdVector3.setSize(6);
                        streamTokenizer.nextToken();
                        pdVector3.m_data[4] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector3.m_data[5] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    }
                    ++n11;
                    vector10.addElement(pdVector3);
                    vectorArray2[9].addElement(vectorArray[0].elementAt(n16));
                    continue;
                }
                if ("Rectangle".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector4 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector4, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector5 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector5, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        int n27;
                        if (this.m_dim != 2) {
                            PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        PiVector piVector7 = new PiVector(4);
                        for (int i = 0; i < 4; ++i) {
                            piVector7.m_data[i] = n14 + i;
                        }
                        vector4.addElement(piVector7);
                        ++n6;
                        PdVector[] pdVectorArray = new PdVector[]{pdVector4, new PdVector(pdVector5.m_data[0], pdVector4.m_data[1]), pdVector5, new PdVector(pdVector4.m_data[0], pdVector5.m_data[1])};
                        for (n27 = 0; n27 < 4; ++n27) {
                            vector2.addElement(pdVectorArray[n27]);
                        }
                        n4 += 4;
                        n14 += 4;
                        for (n27 = 0; n27 <= 6; ++n27) {
                            vectorArray2[n27].addElement(vectorArray[n27].elementAt(n16));
                        }
                        continue;
                    }
                    if (bl8) {
                        string = string + "Rectangle[{" + pdVector4.m_data[0] + "," + pdVector4.m_data[1] + "},{" + pdVector5.m_data[0] + "," + pdVector5.m_data[1] + "}" + streamTokenizer.sval;
                    }
                    int n28 = 1;
                    while (n28 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            --n28;
                            if (bl8) {
                                string = string + "]";
                            }
                        }
                        if (streamTokenizer.ttype == 91) {
                            ++n28;
                            if (bl8) {
                                string = string + "[";
                            }
                        }
                        if (!bl8) continue;
                        if (streamTokenizer.ttype == -3) {
                            string = string + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            streamTokenizer.pushBack();
                            string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            string = string + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            string = string + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            string = string + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            string = string + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype != 94) continue;
                        string = string + "^";
                    }
                    continue;
                }
                if ("Raster".equals(streamTokenizer.sval) || "RasterArray".equals(streamTokenizer.sval)) {
                    int n29;
                    int n30;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    int n31;
                    Vector<Serializable> vector14;
                    boolean bl9 = false;
                    if ("Raster".equals(streamTokenizer.sval)) {
                        bl9 = true;
                    }
                    streamTokenizer.nextToken();
                    int n32 = -1;
                    int n33 = 0;
                    streamTokenizer.nextToken();
                    if (bl9) {
                        vector14 = new Vector<Serializable>();
                        n31 = 0;
                        while (streamTokenizer.ttype != 125) {
                            int n34 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 125) {
                                if (streamTokenizer.ttype == -1) {
                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                    return false;
                                }
                                vector14.addElement(new Double(PgMathLoader.readNumber(streamTokenizer)));
                                streamTokenizer.nextToken();
                                ++n34;
                            }
                            if (n32 == -1) {
                                n32 = n34;
                            }
                            if (n34 != n32) {
                                PsDebug.warning("Different length of lines in Raster");
                                return false;
                            }
                            ++n33;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d7 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d6 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 44) {
                                streamTokenizer.nextToken();
                                double d8 = PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                double d9 = PgMathLoader.readNumber(streamTokenizer);
                                d9 -= d8;
                                streamTokenizer.nextToken();
                                for (int i = 0; i < n33; ++i) {
                                    for (int j = 0; j < n32; ++j) {
                                        d3 = ((Double)vector14.elementAt(i * n32 + j) - d8) / d9;
                                        if (d3 > 1.0) {
                                            d3 = 1.0;
                                        }
                                        if (d3 < 0.0) {
                                            d3 = 0.0;
                                        }
                                        Color color2 = new Color((float)d3, (float)d3, (float)d3);
                                        for (int k = 0; k <= 5; ++k) {
                                            vectorArray2[k].addElement(color2);
                                        }
                                        vectorArray2[6].addElement(vectorArray[6].elementAt(n16));
                                    }
                                }
                                n31 = 1;
                                streamTokenizer.nextToken();
                            }
                        } else {
                            d7 = 0.0;
                            d6 = 0.0;
                            d5 = n32;
                            d4 = n33;
                        }
                        if (n31 == 0) {
                            for (int i = 0; i < n33; ++i) {
                                for (n30 = 0; n30 < n32; ++n30) {
                                    d3 = (Double)vector14.elementAt(i * n32 + n30);
                                    if (d3 > 1.0) {
                                        d3 = 1.0;
                                    }
                                    if (d3 < 0.0) {
                                        d3 = 0.0;
                                    }
                                    Color color3 = new Color((float)d3, (float)d3, (float)d3);
                                    for (int j = 0; j <= 5; ++j) {
                                        vectorArray2[j].addElement(color3);
                                    }
                                    vectorArray2[6].addElement(vectorArray[6].elementAt(n16));
                                }
                            }
                        }
                    } else {
                        vector14 = new Vector();
                        while (streamTokenizer.ttype != 125) {
                            int n35 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 125) {
                                if (streamTokenizer.ttype == -1) {
                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                    return false;
                                }
                                streamTokenizer.nextToken();
                                vector14.addElement(PgMathLoader.readColor(streamTokenizer));
                                streamTokenizer.nextToken();
                                ++n35;
                            }
                            if (n32 == -1) {
                                n32 = n35;
                            }
                            if (n35 != n32) {
                                PsDebug.warning("Different length of lines in Raster");
                                return false;
                            }
                            ++n33;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d7 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d6 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } else {
                            d7 = 0.0;
                            d6 = 0.0;
                            d5 = n32;
                            d4 = n33;
                        }
                        for (n31 = 0; n31 < n33; ++n31) {
                            for (int i = 0; i < n32; ++i) {
                                Color color4 = (Color)vector14.elementAt(n31 * n32 + i);
                                for (int j = 0; j <= 5; ++j) {
                                    vectorArray2[j].addElement(color4);
                                }
                                vectorArray2[6].addElement(vectorArray[6].elementAt(n16));
                            }
                        }
                    }
                    double d10 = (d5 - d7) / (double)n32;
                    d3 = (d4 - d6) / (double)n33;
                    for (n29 = 0; n29 <= n33; ++n29) {
                        for (n30 = 0; n30 <= n32; ++n30) {
                            vector2.addElement(new PdVector(d7 + (double)n30 * d10, d6 + (double)n29 * d3));
                        }
                    }
                    n4 += (n32 + 1) * (n33 + 1);
                    for (n29 = 0; n29 < n33; ++n29) {
                        for (n30 = 0; n30 < n32; ++n30) {
                            PiVector piVector8 = new PiVector(4);
                            piVector8.m_data[0] = n14 + n29 * (n32 + 1) + n30;
                            piVector8.m_data[1] = n14 + (n29 + 1) * (n32 + 1) + n30;
                            piVector8.m_data[2] = n14 + (n29 + 1) * (n32 + 1) + n30 + 1;
                            piVector8.m_data[3] = n14 + n29 * (n32 + 1) + n30 + 1;
                            vector4.addElement(piVector8);
                        }
                    }
                    n6 += n32 * n33;
                    n14 += (n32 + 1) * (n33 + 1);
                    bl3 = true;
                    continue;
                }
                if ("Cuboid".equals(streamTokenizer.sval)) {
                    int n36;
                    if (this.m_dim != 3) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector6 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector6, 3)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector7 = new PdVector();
                    if (streamTokenizer.ttype == 44) {
                        if (!PgMathLoader.parseVector(streamTokenizer, pdVector7, 3)) {
                            return false;
                        }
                        streamTokenizer.nextToken();
                    } else {
                        pdVector7 = PdVector.copyNew(pdVector6);
                        pdVector7.add(1.0);
                    }
                    PiVector[] piVectorArray = new PiVector[]{new PiVector(n14 + 0, n14 + 4, n14 + 5, n14 + 1), new PiVector(n14 + 3, n14 + 2, n14 + 6, n14 + 7), new PiVector(n14 + 0, n14 + 1, n14 + 2, n14 + 3), new PiVector(n14 + 4, n14 + 7, n14 + 6, n14 + 5), new PiVector(n14 + 1, n14 + 5, n14 + 6, n14 + 2), new PiVector(n14 + 0, n14 + 3, n14 + 7, n14 + 4)};
                    for (int i = 0; i < 6; ++i) {
                        vector4.addElement(piVectorArray[i]);
                    }
                    n6 += 6;
                    n14 += 8;
                    PdVector[] pdVectorArray = new PdVector[]{pdVector6, new PdVector(pdVector7.m_data[0], pdVector6.m_data[1], pdVector6.m_data[2]), new PdVector(pdVector7.m_data[0], pdVector6.m_data[1], pdVector7.m_data[2]), new PdVector(pdVector6.m_data[0], pdVector6.m_data[1], pdVector7.m_data[2]), new PdVector(pdVector6.m_data[0], pdVector7.m_data[1], pdVector6.m_data[2]), new PdVector(pdVector7.m_data[0], pdVector7.m_data[1], pdVector6.m_data[2]), pdVector7, new PdVector(pdVector6.m_data[0], pdVector7.m_data[1], pdVector7.m_data[2])};
                    for (n36 = 0; n36 < 8; ++n36) {
                        vector2.addElement(pdVectorArray[n36]);
                    }
                    n4 += 8;
                    for (n36 = 0; n36 < 6; ++n36) {
                        for (n2 = 0; n2 <= 6; ++n2) {
                            vectorArray2[n2].addElement(vectorArray[n2].elementAt(n16));
                        }
                    }
                    continue;
                }
                if ("Text".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    String string2 = PgMathLoader.readString2(streamTokenizer);
                    streamTokenizer.nextToken();
                    PdVector pdVector8 = new PdVector();
                    PgMathLoader.parseVector(streamTokenizer, pdVector8, this.m_dim);
                    streamTokenizer.nextToken();
                    PdVector pdVector9 = new PdVector(0.0, 0.0);
                    if (streamTokenizer.ttype == 44) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 123) {
                            streamTokenizer.pushBack();
                            PgMathLoader.parseVector(streamTokenizer, pdVector9, 2);
                        } else {
                            streamTokenizer.pushBack();
                        }
                    } else {
                        streamTokenizer.pushBack();
                    }
                    vector12.addElement(pdVector9);
                    int n37 = 1;
                    while (n37 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 91) {
                            ++n37;
                        }
                        if (streamTokenizer.ttype != 93) continue;
                        --n37;
                    }
                    Vector<Object> vector15 = new Vector<Object>();
                    vector15.addElement(string2);
                    vector15.addElement(pdVector8);
                    vector11.addElement(vector15);
                    ++n12;
                    continue;
                }
                if ("PointSize".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    bl5 = true;
                    pdVector.m_data[n16] = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("AbsolutePointSize".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    bl5 = true;
                    pdVector.m_data[n16] = PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("RGBColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                    int n38;
                    bl3 = true;
                    Color color5 = PgMathLoader.readColor(streamTokenizer);
                    vector.setElementAt(color5, n16);
                    for (n38 = 4; n38 <= 5; ++n38) {
                        vectorArray[n38].setElementAt(color5, n16);
                    }
                    if (this.m_dim == 3 && !m_bVersion_6_0) continue;
                    for (n38 = 0; n38 <= 3; ++n38) {
                        vectorArray[n38].setElementAt(color5, n16);
                    }
                    piVector.m_data[n16] = 1;
                    piVector2.m_data[n16] = 1;
                    continue;
                }
                if ("SurfaceColor".equals(streamTokenizer.sval)) {
                    int n39;
                    bl3 = true;
                    Color[] colorArray = new Color[2];
                    piVector.m_data[n16] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                    Color color6 = colorArray[0];
                    Color color7 = colorArray[1];
                    piVector2.m_data[n16] = piVector.m_data[n16];
                    for (n39 = 0; n39 <= 1; ++n39) {
                        vectorArray[n39].setElementAt(color6, n16);
                    }
                    for (n39 = 2; n39 <= 3; ++n39) {
                        vectorArray[n39].setElementAt(color7, n16);
                    }
                    continue;
                }
                if ("EdgeForm".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        bl6 = false;
                    }
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype == -3) {
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl3 = true;
                                bl4 = true;
                                Color color8 = PgMathLoader.readColor(streamTokenizer);
                                vectorArray[6].setElementAt(color8, 0);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if ("Thickness".equals(streamTokenizer.sval)) {
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            continue;
                        }
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                    }
                    continue;
                }
                if ("Thickness".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    d2 = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("AbsoluteThickness".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    d2 = PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("FaceForm".equals(streamTokenizer.sval)) {
                    Color[] colorArray;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    bl3 = true;
                    boolean bl10 = true;
                    if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        colorArray = new Color[2];
                        piVector.m_data[n16] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                        Color color9 = colorArray[0];
                        Color color10 = colorArray[1];
                        vectorArray[0].setElementAt(color9, n16);
                        vectorArray[2].setElementAt(color10, n16);
                    } else {
                        bl10 = false;
                        colorArray = PgMathLoader.readColor(streamTokenizer);
                        vectorArray[4].setElementAt(colorArray, n16);
                        if (this.m_dim != 3 || m_bVersion_6_0) {
                            vectorArray[0].setElementAt(colorArray, n16);
                            vectorArray[2].setElementAt(colorArray, n16);
                            piVector.m_data[n16] = 1;
                        }
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        streamTokenizer.nextToken();
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray = new Color[2];
                            piVector2.m_data[n16] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                            Color color11 = colorArray[0];
                            Color color12 = colorArray[1];
                            vectorArray[1].setElementAt(color11, n16);
                            vectorArray[3].setElementAt(color12, n16);
                        } else {
                            colorArray = PgMathLoader.readColor(streamTokenizer);
                            vectorArray[5].setElementAt(colorArray, n16);
                            if (this.m_dim != 3 || m_bVersion_6_0) {
                                vectorArray[1].setElementAt(colorArray, n16);
                                vectorArray[3].setElementAt(colorArray, n16);
                                piVector2.m_data[n16] = 1;
                            }
                        }
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl10) {
                        vectorArray[1].setElementAt(vectorArray[0].elementAt(n16), n16);
                        vectorArray[3].setElementAt(vectorArray[2].elementAt(n16), n16);
                        piVector2.m_data[n16] = piVector.m_data[n16];
                        continue;
                    }
                    vectorArray[5].setElementAt(vectorArray[4].elementAt(n16), n16);
                    if (this.m_dim == 3 && !m_bVersion_6_0) continue;
                    vectorArray[1].setElementAt(vectorArray[0].elementAt(n16), n16);
                    vectorArray[3].setElementAt(vectorArray[2].elementAt(n16), n16);
                    piVector2.m_data[n16] = 1;
                    continue;
                }
                PsDebug.warning("skipping " + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                if (bl8) {
                    string = string + streamTokenizer.sval;
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'[' expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                int n40 = 1;
                if (bl8) {
                    string = string + "[";
                }
                while (n40 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        --n40;
                        if (bl8) {
                            string = string + "]";
                        }
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n40;
                        if (bl8) {
                            string = string + "[";
                        }
                    }
                    if (!bl8) continue;
                    if (streamTokenizer.ttype == -3) {
                        string = string + streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                        continue;
                    }
                    if (streamTokenizer.ttype == 123) {
                        string = string + "{";
                        continue;
                    }
                    if (streamTokenizer.ttype == 125) {
                        string = string + "}";
                        continue;
                    }
                    if (streamTokenizer.ttype == 44) {
                        string = string + ",";
                        continue;
                    }
                    if (streamTokenizer.ttype == 42) {
                        string = string + "*";
                        continue;
                    }
                    if (streamTokenizer.ttype != 94) continue;
                    string = string + "^";
                }
            }
            boolean bl11 = true;
            boolean bl12 = true;
            if (bl) {
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
                int n41 = 1;
                while (n41 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    if (streamTokenizer.ttype == 93) {
                        --n41;
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n41;
                    }
                    if (streamTokenizer.ttype == -3) {
                        if (this.readOptions(streamTokenizer)) {
                            streamTokenizer.ordinaryChar(45);
                        } else if ("Prolog".equals(streamTokenizer.sval) || "Epilog".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            int n42 = this.m_dim;
                            this.m_dim = 2;
                            if (this.readGraphics(streamTokenizer, false)) {
                                ++this.m_numGraphics;
                            }
                            this.m_dim = n42;
                        } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            bl12 = "True".equals(streamTokenizer.sval);
                        } else if ("Shading".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            if ("True".equals(streamTokenizer.sval)) {
                                bl11 = true;
                            } else {
                                bl11 = false;
                                this.m_displayOption.setLightingModel(0);
                            }
                        }
                    }
                    streamTokenizer.nextToken();
                }
                streamTokenizer.pushBack();
            }
            if (this.m_displayOption.getBackgroundColor() == null) {
                this.m_displayOption.setBackgroundColor(Color.white);
            }
            if (this.m_defaultColor == null && (color = this.m_displayOption.getBackgroundColor()) != null) {
                n2 = 0;
                int n43 = 0;
                int n44 = 0;
                if (color.getRed() < 127) {
                    n44 = 255;
                }
                if (color.getBlue() < 127) {
                    n2 = 255;
                }
                if (color.getGreen() < 127) {
                    n43 = 255;
                }
                this.m_defaultColor = new Color(n44, n43, n2);
            }
            if (this.m_dim < 3 && bl) {
                this.m_displayOption.clearTag(22);
                this.m_displayOption.setLightingModel(0);
            }
            int n45 = 0;
            if (this.m_geomArr != null) {
                n45 += this.m_geomArr.length;
            }
            int n46 = n45;
            if (n6 != 0 || n11 != 0) {
                ++n45;
            }
            if (n7 != 0) {
                ++n45;
            }
            if (n8 != 0) {
                ++n45;
            }
            if (n9 != 0 || n10 != 0) {
                ++n45;
            }
            PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[n45 += n12];
            for (n2 = 0; n2 < n46; ++n2) {
                pgJvxSrcArray[n2] = this.m_geomArr[n2];
            }
            this.m_geomArr = pgJvxSrcArray;
            if (n6 != 0 || n11 != 0) {
                int n47;
                int n48;
                int n49;
                n2 = 72;
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                if (bl2) {
                    pgJvxSrc.setNumVertices(n13 + n11 * n2);
                    for (n49 = 0; n49 < n13; ++n49) {
                        pgJvxSrc.setVertex(n49, (PdVector)vector3.elementAt(n49));
                    }
                } else {
                    pgJvxSrc.setNumVertices(n4 + n11 * n2);
                    for (n49 = 0; n49 < n4; ++n49) {
                        pgJvxSrc.setVertex(n49, (PdVector)vector2.elementAt(n49));
                    }
                }
                for (n49 = 0; n49 < n11; ++n49) {
                    PdVector pdVector10 = (PdVector)vector10.elementAt(n49);
                    if (pdVector10.getSize() == 4) {
                        for (n48 = 0; n48 < n2; ++n48) {
                            pgJvxSrc.setVertex(n4 + n49 * n2 + n48, new PdVector(pdVector10.m_data[0] + Math.cos((double)n48 * 2.0 * Math.PI / (double)n2) * pdVector10.m_data[2], pdVector10.m_data[1] + Math.sin((double)n48 * 2.0 * Math.PI / (double)n2) * pdVector10.m_data[3]));
                        }
                        continue;
                    }
                    pgJvxSrc.setVertex(n4 + n49 * n2, new PdVector(pdVector10.m_data[0], pdVector10.m_data[1]));
                    for (n48 = 0; n48 < n2 - 1; ++n48) {
                        pgJvxSrc.setVertex(n4 + n49 * n2 + n48 + 1, new PdVector(pdVector10.m_data[0] + Math.cos(pdVector10.m_data[4] + (pdVector10.m_data[5] - pdVector10.m_data[4]) * (double)n48 / (double)(n2 - 2)) * pdVector10.m_data[2], pdVector10.m_data[1] + Math.sin(pdVector10.m_data[4] + (pdVector10.m_data[5] - pdVector10.m_data[4]) * (double)n48 / (double)(n2 - 2)) * pdVector10.m_data[3]));
                    }
                }
                pgJvxSrc.setDimOfElements(-1);
                pgJvxSrc.setNumElements(n6 + n11);
                for (n49 = 0; n49 < n6; ++n49) {
                    pgJvxSrc.setElement(n49, (PiVector)vector4.elementAt(n49));
                    if (!bl2) continue;
                    pgJvxSrc.getElement(n49).add(-1);
                }
                for (n49 = 0; n49 < n11; ++n49) {
                    PiVector piVector9 = new PiVector(n2);
                    for (n48 = 0; n48 < n2; ++n48) {
                        piVector9.m_data[n48] = n4 + n49 * n2 + n48;
                    }
                    pgJvxSrc.setElement(n6 + n49, piVector9);
                }
                PgMathLoader.geomInitType(pgJvxSrc);
                if (bl6) {
                    pgJvxSrc.showEdges(true);
                } else {
                    pgJvxSrc.showEdges(false);
                }
                pgJvxSrc.setGlobalEdgeSize(d);
                pgJvxSrc.showElementColors(bl11);
                pgJvxSrc.showElementBackColors(bl11);
                pgJvxSrc.showElements(bl12);
                Color[][] colorArrayArray = new Color[4][];
                Color color13 = Color.white;
                Color color14 = Color.black;
                if (this.m_defaultColor != null) {
                    if (!this.m_displayOption.hasTag(22)) {
                        color13 = this.m_defaultColor;
                    }
                    color14 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalElementColor(color13);
                pgJvxSrc.setGlobalElementBackColor(color13);
                pgJvxSrc.setGlobalEdgeColor(color14);
                for (n47 = 0; n47 <= 3; ++n47) {
                    colorArrayArray[n47] = new Color[n6 + n11];
                }
                if (bl3) {
                    if (!m_bVersion_6_0 && this.m_displayOption.hasTag(22) && bl) {
                        for (n47 = 0; n47 < n6; ++n47) {
                            for (n = 0; n <= 3; ++n) {
                                colorArrayArray[n][n47] = (Color)vectorArray2[n].elementAt(n47);
                                if (colorArrayArray[n][n47] != null) continue;
                                colorArrayArray[n][n47] = Color.white;
                            }
                        }
                    } else {
                        if (m_bVersion_6_0) {
                            for (n47 = 0; n47 < n6; ++n47) {
                                for (n = 0; n <= 3; ++n) {
                                    colorArrayArray[n][n47] = (Color)vectorArray2[n].elementAt(n47);
                                    if (colorArrayArray[n][n47] != null) continue;
                                    colorArrayArray[n][n47] = Color.white;
                                }
                            }
                        } else {
                            for (n47 = 0; n47 < n6; ++n47) {
                                for (n = 0; n <= 1; ++n) {
                                    colorArrayArray[n][n47] = (Color)vectorArray2[n + 4].elementAt(n47);
                                    if (colorArrayArray[n][n47] != null) continue;
                                    colorArrayArray[n][n47] = color13;
                                }
                            }
                        }
                        for (n47 = 0; n47 < n11; ++n47) {
                            for (n = 0; n <= 1; ++n) {
                                colorArrayArray[n][n47 + n6] = (Color)vectorArray2[9].elementAt(n47);
                                if (colorArrayArray[n][n47 + n6] != null) continue;
                                colorArrayArray[n][n47 + n6] = color13;
                            }
                        }
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    if (bl4) {
                        Color[] colorArray = new Color[n6];
                        for (n = 0; n < n6; ++n) {
                            colorArray[n] = (Color)vectorArray2[6].elementAt(n);
                        }
                        if (vectorArray[6].elementAt(0) != null) {
                            pgJvxSrc.setGlobalEdgeColor((Color)vectorArray[6].elementAt(0));
                        }
                    }
                } else {
                    pgJvxSrc.setGlobalElementColor(color13);
                    pgJvxSrc.setGlobalElementBackColor(color13);
                    pgJvxSrc.showElementColors(false);
                    pgJvxSrc.showElementBackColors(false);
                }
                this.m_geomArr[n46] = pgJvxSrc;
                this.m_geomArr[n46].setName("ElementSet from Mathematica");
                ++n46;
            }
            if (n7 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(30);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n7);
                for (int i = 0; i < n7; ++i) {
                    pgJvxSrc.setVertex(i, (PdVector)vector5.elementAt(i));
                }
                if (bl5) {
                    PdVector pdVector11 = new PdVector(n7);
                    for (int i = 0; i < n7; ++i) {
                        pdVector11.m_data[i] = (Double)vector13.elementAt(i);
                        if (!(pdVector11.m_data[i] < 1.0)) continue;
                        pdVector11.m_data[i] = 1.0;
                    }
                    pgJvxSrc.setGlobalVertexSize(1.0);
                    pgJvxSrc.setVertexSizes(pdVector11);
                    pgJvxSrc.showVertexSizes(true);
                }
                Color color15 = Color.black;
                if (this.m_defaultColor != null) {
                    color15 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalVertexColor(color15);
                if (bl3) {
                    Color[] colorArray = new Color[n7];
                    for (int i = 0; i < n7; ++i) {
                        colorArray[i] = (Color)vectorArray2[7].elementAt(i);
                        if (colorArray[i] != null) continue;
                        colorArray[i] = color15;
                    }
                    pgJvxSrc.setVertexColors(colorArray);
                    pgJvxSrc.showVertexColors(true);
                }
                pgJvxSrc.showVertexOutline(false);
                this.m_geomArr[n46] = pgJvxSrc;
                this.m_geomArr[n46].setName("PointSet from Mathematica");
                ++n46;
            }
            if (n12 != 0) {
                for (int i = 0; i < n12; ++i) {
                    PgJvxSrc pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setType(30);
                    PgMathLoader.geomInitType(pgJvxSrc);
                    pgJvxSrc.setDimOfVertices(this.m_dim);
                    pgJvxSrc.setNumVertices(1);
                    pgJvxSrc.setVertex(0, (PdVector)((Vector)vector11.elementAt(i)).elementAt(1));
                    pgJvxSrc.getVertex(0).setName((String)((Vector)vector11.elementAt(i)).elementAt(0));
                    PdVector pdVector12 = (PdVector)vector12.elementAt(i);
                    int n50 = pdVector12.m_data[0] > 0.5 ? 2 : (pdVector12.m_data[0] < -0.5 ? 0 : 1);
                    int n51 = pdVector12.m_data[1] > 0.5 ? 2 : (pdVector12.m_data[1] < -0.5 ? 0 : 1);
                    pgJvxSrc.setLabelAttribute(0, 0, 0, n50, n51, 0);
                    pgJvxSrc.showVertices(true);
                    pgJvxSrc.setGlobalVertexSize(0.0);
                    pgJvxSrc.showVertexLabels(true);
                    this.m_geomArr[n46] = pgJvxSrc;
                    this.m_geomArr[n46].setName("Text from Mathematica " + i);
                    ++n46;
                }
            }
            if (n8 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(36);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n8);
                pgJvxSrc.setNumVectorFields(1);
                pgJvxSrc.setNumVectors(0, n8, this.m_dim);
                PdVector[] pdVectorArray = new PdVector[n8];
                PdVector[] pdVectorArray2 = new PdVector[n8];
                for (int i = 0; i < n8; ++i) {
                    pdVectorArray[i] = ((PdVector[])vector6.elementAt(i))[0];
                    pdVectorArray2[i] = PdVector.subNew(((PdVector[])vector6.elementAt(i))[1], pdVectorArray[i]);
                }
                pgJvxSrc.setVertices(pdVectorArray);
                pgJvxSrc.setVectors(0, pdVectorArray2);
                pgJvxSrc.showVectorArrows(0, true);
                pgJvxSrc.setGlobalVectorColor(0, Color.black);
                this.m_geomArr[n46] = pgJvxSrc;
                this.m_geomArr[n46].setName("VectorField from Mathematica");
                ++n46;
            }
            if (n9 != 0 || n10 != 0) {
                int n52;
                int n53;
                int n54 = 72;
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(32);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.showVertices(false);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                if (bl2) {
                    pgJvxSrc.setNumVertices(n13 + n10 * n54);
                    for (n53 = 0; n53 < n13; ++n53) {
                        pgJvxSrc.setVertex(n53, (PdVector)vector3.elementAt(n53));
                    }
                } else {
                    pgJvxSrc.setNumVertices(n5 + n10 * n54);
                    for (n53 = 0; n53 < n5; ++n53) {
                        pgJvxSrc.setVertex(n53, (PdVector)vector7.elementAt(n53));
                    }
                }
                boolean[] blArray = new boolean[n10];
                for (int i = 0; i < n10; ++i) {
                    int n55;
                    PdVector pdVector13 = (PdVector)vector9.elementAt(i);
                    if (pdVector13.getSize() == 4) {
                        blArray[i] = true;
                        for (n55 = 0; n55 < n54; ++n55) {
                            pgJvxSrc.setVertex(n5 + i * n54 + n55, new PdVector(pdVector13.m_data[0] + Math.cos((double)n55 * 2.0 * Math.PI / (double)n54) * pdVector13.m_data[2], pdVector13.m_data[1] + Math.sin((double)n55 * 2.0 * Math.PI / (double)n54) * pdVector13.m_data[3]));
                        }
                        continue;
                    }
                    blArray[i] = false;
                    for (n55 = 0; n55 < n54; ++n55) {
                        pgJvxSrc.setVertex(n5 + i * n54 + n55, new PdVector(pdVector13.m_data[0] + Math.cos(pdVector13.m_data[4] + (pdVector13.m_data[5] - pdVector13.m_data[4]) * (double)n55 / (double)(n54 - 1)) * pdVector13.m_data[2], pdVector13.m_data[1] + Math.sin(pdVector13.m_data[4] + (pdVector13.m_data[5] - pdVector13.m_data[4]) * (double)n55 / (double)(n54 - 1)) * pdVector13.m_data[3]));
                    }
                }
                pgJvxSrc.setDimOfPolygons(-1);
                pgJvxSrc.setNumPolygons(n9 + n10);
                PiVector[] piVectorArray = pgJvxSrc.getPolygons();
                for (n52 = 0; n52 < n9; ++n52) {
                    pgJvxSrc.setPolygon(n52, (PiVector)vector8.elementAt(n52));
                    if (!bl2) continue;
                    pgJvxSrc.getPolygon(n52).add(-1);
                }
                for (n52 = 0; n52 < n10; ++n52) {
                    int n56;
                    if (blArray[n52]) {
                        piVectorArray[n9 + n52].setSize(n54 + 1);
                        for (n56 = 0; n56 < n54 + 1; ++n56) {
                            piVectorArray[n9 + n52].m_data[n56] = n5 + n52 * n54 + n56 % n54;
                        }
                        continue;
                    }
                    piVectorArray[n9 + n52].setSize(n54);
                    for (n56 = 0; n56 < n54; ++n56) {
                        piVectorArray[n9 + n52].m_data[n56] = n5 + n52 * n54 + n56;
                    }
                }
                Color color16 = Color.black;
                if (this.m_defaultColor != null) {
                    color16 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalPolygonColor(color16);
                if (bl3) {
                    Color[] colorArray = new Color[n9 + n10];
                    for (n = 0; n < n9; ++n) {
                        colorArray[n] = (Color)vectorArray2[8].elementAt(n);
                        if (colorArray[n] != null) continue;
                        colorArray[n] = color16;
                    }
                    for (n = 0; n < n10; ++n) {
                        colorArray[n9 + n] = (Color)vectorArray2[10].elementAt(n);
                        if (colorArray[n9 + n] != null) continue;
                        colorArray[n9 + n] = color16;
                    }
                    pgJvxSrc.setPolygonColors(colorArray);
                    pgJvxSrc.showPolygonColors(true);
                }
                pgJvxSrc.setGlobalPolygonSize(d2);
                this.m_geomArr[n46] = pgJvxSrc;
                this.m_geomArr[n46].setName("PgPolygonSet from Mathematica");
                ++n46;
            }
            streamTokenizer.ordinaryChar(45);
            if (n45 > 0) {
                if (this.m_numGraphics + 1 > this.m_graphicsVector.size()) {
                    this.m_graphicsVector.addElement(this.m_geomArr);
                } else {
                    this.m_graphicsVector.setElementAt(this.m_geomArr, this.m_numGraphics);
                }
            } else if (!bl7) {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private boolean readParametricSurface(StreamTokenizer streamTokenizer) {
        try {
            int n;
            int n2;
            this.m_colorFunction = 0;
            this.m_bColorFunctionScaling = true;
            streamTokenizer.parseNumbers();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            Vector<PdVector> vector = new Vector<PdVector>();
            Vector[] vectorArray = new Vector[4];
            for (int i = 0; i <= 3; ++i) {
                vectorArray[i] = new Vector();
            }
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            Color color = null;
            double d = 1.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            int n3 = 0;
            int n4 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                ++n4;
                int n5 = n3;
                n3 = 0;
                while (streamTokenizer.ttype != 125) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    ++n3;
                    if (this.m_dim == 3) {
                        PdVector pdVector = new PdVector(3);
                        pdVector.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        vector.addElement(pdVector);
                    } else if (this.m_dim == 2) {
                        double d6 = PgMathLoader.readNumber(streamTokenizer);
                        bl = true;
                        for (n2 = 0; n2 <= 3; ++n2) {
                            vectorArray[n2].addElement(new PdVector(d6));
                        }
                    }
                    streamTokenizer.nextToken();
                }
                if (n4 > 1 && n5 != n3) {
                    PsDebug.warning("Number of U-Lines not constant - V-Line: " + n4 + " Line: " + streamTokenizer.lineno());
                    return false;
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.nextToken();
            int n6 = 1;
            d2 = 1.0;
            d4 = 1.0;
            d3 = n3;
            d5 = n4;
            while (n6 != 0) {
                streamTokenizer.ordinaryChar(45);
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("PgMathLoader.readElementSet: ']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n6;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n6;
                }
                if (streamTokenizer.ttype == -3) {
                    if (this.readOptions(streamTokenizer)) {
                        streamTokenizer.ordinaryChar(45);
                    } else if ("Mesh".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl3 = "True".equals(streamTokenizer.sval);
                    } else if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                        streamTokenizer.parseNumbers();
                        bl = true;
                        Color color2 = PgMathLoader.readColor(streamTokenizer);
                        for (n2 = 0; n2 <= 3; ++n2) {
                            vectorArray[n2].addElement(color2);
                        }
                        piVector.addEntry(1);
                        piVector2.addEntry(1);
                    } else if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        int n7;
                        streamTokenizer.parseNumbers();
                        bl = true;
                        Color[] colorArray = new Color[2];
                        n2 = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                        piVector.addEntry(n2);
                        piVector2.addEntry(n2);
                        for (n7 = 0; n7 <= 1; ++n7) {
                            vectorArray[n7].addElement(colorArray[0]);
                        }
                        for (n7 = 2; n7 <= 3; ++n7) {
                            vectorArray[n7].addElement(colorArray[1]);
                        }
                    } else if ("FaceForm".equals(streamTokenizer.sval)) {
                        Color[] colorArray;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                        }
                        streamTokenizer.parseNumbers();
                        bl = true;
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray = new Color[2];
                            piVector.addEntry(PgMathLoader.readSurfaceColor(streamTokenizer, colorArray));
                            vectorArray[0].addElement(colorArray[0]);
                            vectorArray[2].addElement(colorArray[1]);
                        } else {
                            colorArray = PgMathLoader.readColor(streamTokenizer);
                            vectorArray[0].addElement(colorArray);
                            vectorArray[2].addElement(colorArray);
                            piVector.addEntry(1);
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                                PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                            }
                            if ("SurfaceColor".equals(streamTokenizer.sval)) {
                                colorArray = new Color[2];
                                piVector2.addEntry(PgMathLoader.readSurfaceColor(streamTokenizer, colorArray));
                                vectorArray[1].addElement(colorArray[0]);
                                vectorArray[3].addElement(colorArray[1]);
                            } else {
                                colorArray = PgMathLoader.readColor(streamTokenizer);
                                vectorArray[1].addElement(colorArray);
                                vectorArray[3].addElement(colorArray);
                                piVector2.addEntry(1);
                            }
                            streamTokenizer.nextToken();
                        } else {
                            int n8 = vectorArray[0].size() - 1;
                            vectorArray[1].addElement(vectorArray[0].elementAt(n8));
                            vectorArray[3].addElement(vectorArray[2].elementAt(n8));
                            piVector2.addEntry(piVector.m_data[n8]);
                        }
                    } else if ("MeshStyle".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        int n9 = -1;
                        while (n9 != 0) {
                            if (n9 == -1) {
                                n9 = 0;
                            }
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            streamTokenizer.nextToken();
                            streamTokenizer.parseNumbers();
                            if (streamTokenizer.ttype == 123) {
                                ++n9;
                                continue;
                            }
                            if (streamTokenizer.ttype == 125) {
                                --n9;
                                continue;
                            }
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                color = PgMathLoader.readColor(streamTokenizer);
                                continue;
                            }
                            if ("Thickness".equals(streamTokenizer.sval)) {
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if ("EdgeForm".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            bl3 = false;
                        }
                        while (streamTokenizer.ttype != 93) {
                            if (streamTokenizer.ttype == -3) {
                                if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                    bl2 = true;
                                    streamTokenizer.parseNumbers();
                                    color = PgMathLoader.readColor(streamTokenizer);
                                }
                                if (!"Thickness".equals(streamTokenizer.sval)) continue;
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            streamTokenizer.nextToken();
                        }
                    } else if ("MeshRange".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                            streamTokenizer.parseNumbers();
                            streamTokenizer.nextToken();
                            d2 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d3 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.ordinaryChar(45);
                        }
                    } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl4 = "True".equals(streamTokenizer.sval);
                    } else if ("Shading".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl5 = "True".equals(streamTokenizer.sval);
                    } else if ("Prolog".equals(streamTokenizer.sval) || "Epilog".equals(streamTokenizer.sval)) {
                        int n10 = this.m_dim;
                        this.m_dim = 2;
                        if (this.readGraphics(streamTokenizer, false)) {
                            ++this.m_numGraphics;
                        }
                        this.m_dim = n10;
                    }
                }
                streamTokenizer.nextToken();
            }
            if (this.m_dim == 2) {
                ++n3;
                ++n4;
                for (int i = 0; i < n3 * n4; ++i) {
                    vector.addElement(new PdVector(2));
                }
            }
            double d7 = (d3 - d2) / (double)(n3 - 1);
            double d8 = (d5 - d4) / (double)(n4 - 1);
            int n11 = 0;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            pgJvxSrc.setDimOfVertices(this.m_dim);
            pgJvxSrc.setNumVertices(n3 * n4);
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    pdVectorArray[i * n3 + j].copy((PdVector)vector.elementAt(n11));
                    pdVectorArray[i * n3 + j].m_data[0] = d2 + (double)j * d7;
                    pdVectorArray[i * n3 + j].m_data[1] = d4 + (double)i * d8;
                    ++n11;
                }
            }
            pgJvxSrc.setDimOfElements(4);
            pgJvxSrc.setNumElements((n3 - 1) * (n4 - 1));
            pgJvxSrc.assureNeighbours();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
            int n12 = 0;
            for (n = 0; n < n4 - 1; ++n) {
                for (int i = 0; i < n3 - 1; ++i) {
                    piVectorArray[n12].m_data[0] = n * n3 + i;
                    piVectorArray[n12].m_data[1] = (n + 1) * n3 + i;
                    piVectorArray[n12].m_data[2] = (n + 1) * n3 + i + 1;
                    piVectorArray[n12].m_data[3] = n * n3 + i + 1;
                    if (n < n4 - 2) {
                        piVectorArray2[n12].m_data[0] = n12 + n3 - 1;
                    }
                    if (i < n3 - 2) {
                        piVectorArray2[n12].m_data[1] = n12 + 1;
                    }
                    if (n > 0) {
                        piVectorArray2[n12].m_data[2] = n12 - n3 + 1;
                    }
                    if (i > 0) {
                        piVectorArray2[n12].m_data[3] = n12 - 1;
                    }
                    ++n12;
                }
            }
            PgMathLoader.geomInitType(pgJvxSrc);
            pgJvxSrc.showEdges(bl3);
            if (this.m_dim == 3) {
                int n13;
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n = (n3 - 1) * (n4 - 1);
                Color[][] colorArrayArray = new Color[4][];
                for (n13 = 0; n13 <= 3; ++n13) {
                    colorArrayArray[n13] = new Color[n];
                }
                if (bl) {
                    if (vectorArray[0].size() == n) {
                        for (n13 = 0; n13 < n; ++n13) {
                            for (int i = 0; i <= 3; ++i) {
                                colorArrayArray[i][n13] = (Color)vectorArray[i].elementAt(n13);
                            }
                        }
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    } else {
                        for (n13 = 0; n13 <= 3; ++n13) {
                            Color color3 = (Color)vectorArray[n13].elementAt(0);
                            for (int i = 0; i < n; ++i) {
                                colorArrayArray[n13][i] = color3;
                            }
                        }
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    }
                } else {
                    for (n13 = 0; n13 < n; ++n13) {
                        for (int i = 0; i <= 3; ++i) {
                            colorArrayArray[i][n13] = Color.white;
                        }
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                } else if (this.m_defaultColor != null) {
                    pgJvxSrc.setGlobalEdgeColor(this.m_defaultColor);
                }
            } else if (this.m_dim == 2) {
                pgJvxSrc.setDimOfVertices(2);
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n = (n3 - 1) * (n4 - 1);
                Color[] colorArray = new Color[n];
                if (bl) {
                    if (vectorArray[0].size() == n) {
                        double d9;
                        int n14;
                        double d10 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        double d11 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        for (n14 = 0; n14 < n; ++n14) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n14)).m_data[0];
                            if (d9 > d11) {
                                d11 = d9;
                            }
                            if (!(d9 < d10)) continue;
                            d10 = d9;
                        }
                        if (d10 == d11) {
                            d11 += 1.0;
                        }
                        for (n14 = 0; n14 < n; ++n14) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n14)).m_data[0];
                            if (this.m_bColorFunctionScaling) {
                                d9 = (d9 - d10) / (d11 - d10);
                            }
                            colorArray[n14] = this.m_colorFunction == 0 ? new Color((float)d9, (float)d9, (float)d9) : new Color(Color.HSBtoRGB((float)d9, 1.0f, 1.0f));
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    } else {
                        for (int i = 0; i < n; ++i) {
                            colorArray[i] = Color.gray;
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        colorArray[i] = Color.gray;
                    }
                    pgJvxSrc.setElementColors(colorArray);
                    pgJvxSrc.setElementBackColors(colorArray);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                }
            }
            if (!this.m_displayOption.hasTag(22) && this.m_dim == 3) {
                n = pgJvxSrc.getNumElements();
                Color[] colorArray = new Color[n];
                Color[] colorArray2 = new Color[n];
                double d12 = pdVectorArray[0].m_data[2];
                double d13 = pdVectorArray[0].m_data[2];
                for (int i = 0; i < n3 * n4; ++i) {
                    if (pdVectorArray[i].m_data[2] > d13) {
                        d13 = pdVectorArray[i].m_data[2];
                    }
                    if (!(pdVectorArray[i].m_data[2] < d12)) continue;
                    d12 = pdVectorArray[i].m_data[2];
                }
                double d14 = d13 - d12;
                PiVector[] piVectorArray3 = pgJvxSrc.getElements();
                PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
                for (int i = 0; i < n; ++i) {
                    PiVector piVector3 = piVectorArray3[i];
                    int n15 = piVector3.getSize();
                    double d15 = 0.0;
                    for (int j = 0; j < n15; ++j) {
                        d15 += pdVectorArray2[piVector3.m_data[j]].m_data[2];
                    }
                    double d16 = this.m_bColorFunctionScaling ? (d15 - d12) / d14 : (d15 /= (double)n15);
                    colorArray[i] = this.m_colorFunction == 0 ? new Color((float)d16, (float)d16, (float)d16) : new Color(Color.HSBtoRGB((float)d16, 1.0f, 1.0f));
                    colorArray2[i] = colorArray[i];
                }
                pgJvxSrc.setElementColors(colorArray);
                pgJvxSrc.setElementBackColors(colorArray2);
            }
            pgJvxSrc.setGlobalEdgeSize(d);
            this.m_geomArr = new PgJvxSrc[1];
            this.m_geomArr[0] = pgJvxSrc;
            this.m_graphicsVector.addElement(this.m_geomArr);
            streamTokenizer.ordinaryChar(45);
            streamTokenizer.pushBack();
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private static double readNumber(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
            }
            double d = streamTokenizer.nval;
            streamTokenizer.ordinaryChar(69);
            streamTokenizer.ordinaryChar(101);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 42) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 94) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        streamTokenizer.wordChars(69, 69);
                        streamTokenizer.wordChars(101, 101);
                        return d;
                    }
                    d *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else if (streamTokenizer.ttype == 69 || streamTokenizer.ttype == 101) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                    streamTokenizer.wordChars(69, 69);
                    streamTokenizer.wordChars(101, 101);
                    return d;
                }
                d *= Math.pow(10.0, streamTokenizer.nval);
            } else {
                streamTokenizer.pushBack();
            }
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return d;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return 0.0;
        }
    }

    public boolean write(DataOutputStream dataOutputStream, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        return false;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        String string;
        int n;
        int n2;
        int n3;
        PiVector[] piVectorArray;
        int n4;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        int n5 = pgJvxSrc.getDimOfVertices();
        if (n5 != 2 && n5 != 3) {
            PsDebug.warning("wrong dimension of vertices, dim = " + n5);
            return false;
        }
        writer.write("(* Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("   JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("   by " + PsConfig.getAuthors() + "\n");
        writer.write("     File Format = Mathematica Graphics MGS\n");
        writer.write("     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("     Date        = " + new Date().toString() + "\n//\n");
        int n6 = pgJvxSrc.getNumVertices();
        writer.write("     Number of Vertices = " + n6 + "\n");
        int n7 = pgJvxSrc.getNumElements();
        if (n7 > 0) {
            writer.write("     Number of Elements = " + n7 + "\n");
        }
        if ((n4 = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("     Number of Polygons = " + n4 + "\n");
        }
        writer.write("\n End of Header *)\n");
        if (n5 == 3) {
            writer.write("Graphics3D[{");
        } else if (n5 == 2) {
            writer.write("Graphics[{");
        }
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        String string2 = null;
        Color[] colorArray = null;
        boolean bl = false;
        if (n4 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingPolygonColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                writer.write(string2 + ",");
            } else {
                colorArray = pgJvxSrc.getPolygonColors();
            }
            piVectorArray = pgJvxSrc.getPolygons();
            for (n3 = 0; n3 < n4; ++n3) {
                if (colorArray != null && colorArray.length > n3 && pgJvxSrc.isShowingPolygonColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{" + string2 + ",");
                }
                writer.write("Line[{");
                n2 = piVectorArray[n3].getSize();
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingPolygonColors()) {
                    writer.write("}");
                }
                if (n3 < n4 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
            }
        } else if (n7 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingEdges()) {
                writer.write("EdgeForm[],");
            }
            if (!pgJvxSrc.isShowingElementColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                writer.write("SurfaceColor[" + string2 + "],");
            } else {
                colorArray = pgJvxSrc.getElementColors();
            }
            piVectorArray = pgJvxSrc.getElements();
            for (n3 = 0; n3 < n7; ++n3) {
                if (colorArray != null && colorArray.length > n3 && pgJvxSrc.isShowingElementColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{SurfaceColor[" + string2 + "],");
                }
                writer.write("Polygon[{");
                n2 = piVectorArray[n3].getSize();
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingElementColors()) {
                    writer.write("}");
                }
                if (n3 < n7 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
            }
        }
        if (n6 > 0 && pgJvxSrc.isShowingVertices()) {
            if (bl) {
                writer.write(",\n");
            }
            for (int i = 0; i < n6; ++i) {
                writer.write("Point[");
                String string3 = PgMathLoader.writeVertex(pdVectorArray[i]);
                writer.write(string3);
                writer.write("]");
                if (i < n6 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
            }
        }
        writer.write("}]\n");
        return true;
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing color");
            return null;
        }
        String string = "RGBColor[" + PdColor.toStringAsFloat(color, ", ") + "]";
        return string;
    }

    private static String writeVertex(PdVector pdVector) {
        int n;
        if (pdVector == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int n2 = pdVector.getSize();
        if (n2 < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n2 > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n2 = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("{" + String.valueOf((float)pdVector.m_data[0]));
        for (n = 1; n < n2; ++n) {
            stringBuffer.append(", ");
            if (Math.abs(pdVector.m_data[n]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n]);
                continue;
            }
            stringBuffer.append("0.");
        }
        stringBuffer.append("}");
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (stringBuffer.charAt(n) != 'E' && stringBuffer.charAt(n) != 'e') continue;
            stringBuffer.setCharAt(n, '*');
            stringBuffer.insert(n + 1, '^');
        }
        return stringBuffer.toString();
    }

    private static String readString2(StreamTokenizer streamTokenizer) {
        try {
            boolean bl = false;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3 && "StyleForm".equals(streamTokenizer.sval)) {
                bl = true;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
            }
            String string = new String("");
            string = streamTokenizer.ttype == 34 ? PgMathLoader.readString(streamTokenizer) : (streamTokenizer.ttype == -3 ? string + streamTokenizer.sval : (streamTokenizer.ttype == -2 ? string + NumberFormat.getInstance().format(streamTokenizer.nval) : null));
            if (bl) {
                int n = 1;
                while (n != 0) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return null;
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.ttype != 93) continue;
                    --n;
                }
            }
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    private static String readString(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.ordinaryChar(92);
            streamTokenizer.ordinaryChar(32);
            streamTokenizer.nextToken();
            String string = new String("");
            while (streamTokenizer.ttype != 34) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                    return null;
                }
                if (streamTokenizer.ttype == -3) {
                    string = string + streamTokenizer.sval;
                } else if (streamTokenizer.ttype == -2) {
                    streamTokenizer.pushBack();
                    string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                } else if (streamTokenizer.ttype == 32) {
                    string = string + " ";
                } else if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                } else if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                } else if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                } else if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                } else if (streamTokenizer.ttype == 94) {
                    string = string + "^";
                } else if (streamTokenizer.ttype == 123) {
                    string = string + "{";
                } else if (streamTokenizer.ttype == 125) {
                    string = string + "}";
                } else if (streamTokenizer.ttype == 40) {
                    string = string + "(";
                } else if (streamTokenizer.ttype == 41) {
                    string = string + ")";
                } else if (streamTokenizer.ttype == 45) {
                    string = string + "-";
                } else if (streamTokenizer.ttype == 62) {
                    string = string + ">";
                } else if (streamTokenizer.ttype == 47) {
                    string = string + "/";
                } else if (streamTokenizer.ttype == 92) {
                    string = string + "\\";
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(92, 92);
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    private static Color readColor(StreamTokenizer streamTokenizer) {
        if (streamTokenizer.ttype != -3 || !"CMYKColor".equals(streamTokenizer.sval) && !"GrayLevel".equals(streamTokenizer.sval) && !"Hue".equals(streamTokenizer.sval) && !"RGBColor".equals(streamTokenizer.sval)) {
            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue' or 'RGBColor' expected in line " + streamTokenizer.lineno());
        }
        if ("RGBColor".equals(streamTokenizer.sval)) {
            return PgMathLoader.readRGBColor(streamTokenizer);
        }
        if ("GrayLevel".equals(streamTokenizer.sval)) {
            return PgMathLoader.readGrayLevel(streamTokenizer);
        }
        if ("Hue".equals(streamTokenizer.sval)) {
            return PgMathLoader.readHueColor(streamTokenizer);
        }
        if ("CMYKColor".equals(streamTokenizer.sval)) {
            return PgMathLoader.readCMYKColor(streamTokenizer);
        }
        return Color.white;
    }

    private static Color readRGBColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
            return new Color((float)pdVector.m_data[0], (float)pdVector.m_data[1], (float)pdVector.m_data[2]);
        }
        PsDebug.warning("Reading of RGBColor failed.");
        return Color.red;
    }

    private static Color readGrayLevel(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            double d = PgMathLoader.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            return new Color((float)d, (float)d, (float)d);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return Color.gray;
        }
    }

    private static Color readHueColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            float f = (float)PgMathLoader.readNumber(streamTokenizer);
            float f2 = 1.0f;
            float f3 = 1.0f;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                f2 = (float)PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                f3 = (float)PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
            }
            return new Color(Color.HSBtoRGB(f, f2, f3));
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return Color.red;
        }
    }

    private static Color readCMYKColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (PgMathLoader.parseVector(streamTokenizer, pdVector, 4)) {
            return new Color((float)(1.0 - (pdVector.m_data[0] + pdVector.m_data[3])), (float)(1.0 - (pdVector.m_data[1] + pdVector.m_data[3])), (float)(1.0 - (pdVector.m_data[2] + pdVector.m_data[3])));
        }
        PsDebug.warning("Reading of CMYKColor failed.");
        return Color.red;
    }

    private static int readSurfaceColor(StreamTokenizer streamTokenizer, Color[] colorArray) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            int n = 1;
            colorArray[0] = PgMathLoader.readColor(streamTokenizer);
            colorArray[1] = colorArray[0];
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                streamTokenizer.nextToken();
                colorArray[1] = PgMathLoader.readColor(streamTokenizer);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 44) {
                    n = (int)PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                }
            }
            return n;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 1;
        }
    }

    private void setDisplayDefault() {
        this.m_defaultColor = null;
        this.m_bndBoxColor = null;
        this.m_bGrayLevel = false;
        this.m_bBlackWhite = false;
        this.m_boxRatio = null;
        this.m_displayOption.setBackgroundColor(Color.white);
        this.m_displayOption.clearTag(5);
        this.m_displayOption.setTag(6);
        this.m_displayOption.clearTag(9);
        this.m_displayOption.clearTag(11);
        this.m_displayOption.setTag(12);
        this.m_displayOption.clearTag(15);
        this.m_displayOption.setTag(22);
        this.m_displayOption.setNumLights(4);
        this.m_displayOption.setLightType(0, 0);
        this.m_displayOption.setLightIntensity(0, 0.0);
        this.m_displayOption.setLightName(0, "Ambient");
        this.m_displayOption.setAmbientLight(Color.white);
        this.m_displayOption.setAmbientLight(new Color(199, 120, 255));
        this.m_displayOption.setLightColor(1, Color.red);
        this.m_displayOption.setLightReference(1, 1);
        this.m_displayOption.setLightName(1, "Red");
        this.m_displayOption.setLightPosition(1, new PdVector(1.0, 0.0, 1.0));
        this.m_displayOption.setLightType(1, 1);
        this.m_displayOption.setLightIntensity(1, 0.8);
        this.m_displayOption.setLightColor(2, Color.green);
        this.m_displayOption.setLightReference(2, 1);
        this.m_displayOption.setLightName(2, "Green");
        this.m_displayOption.setLightPosition(2, new PdVector(1.0, 1.0, 1.0));
        this.m_displayOption.setLightType(2, 1);
        this.m_displayOption.setLightIntensity(2, 0.8);
        this.m_displayOption.setLightColor(3, Color.blue);
        this.m_displayOption.setLightReference(3, 1);
        this.m_displayOption.setLightName(3, "Blue");
        this.m_displayOption.setLightPosition(3, new PdVector(0.0, 1.0, 1.0));
        this.m_displayOption.setLightType(3, 1);
        this.m_displayOption.setLightIntensity(3, 0.8);
        this.m_displayOption.setLightingModel(1);
        this.m_displayOption.setNumCameras(1);
        this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
        this.m_displayOption.setCameraProjection(0, 0);
        this.m_displayOption.setCameraInterest(0, new PdVector(0.5, 0.5, 0.5));
        this.m_displayOption.setEnabledCameraClip(0, false);
        this.m_displayOption.setCameraFieldOfView(0, 0.5);
        this.m_displayOption.setCameraRoll(0, 0.0);
        this.m_displayOption.setCurrentCamera(0);
        this.m_displayOption.setCameraNearClip(0, 0.0);
        this.m_displayOption.setCameraFarClip(0, 0.0);
        this.m_viewVertical = new PdVector(0.0, 0.0, 1.0);
        PiVector piVector = new PiVector(6);
        piVector.setConstant(0);
        this.m_displayOption.setAxesEdge(piVector);
    }

    public PvDisplayOption[] getDisplayOptions() {
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[this.m_numGraphics];
        for (int i = 0; i < this.m_numGraphics; ++i) {
            pvDisplayOptionArray[i] = (PvDisplayOption)this.m_displayOptionVector.elementAt(i);
        }
        return pvDisplayOptionArray;
    }

    private boolean readOptions(StreamTokenizer streamTokenizer) {
        return this.readOptions(streamTokenizer, false);
    }

    private boolean readOptions(StreamTokenizer streamTokenizer, boolean bl) {
        try {
            block182: {
                block185: {
                    block183: {
                        block186: {
                            block184: {
                                if ("Boxed".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if ("True".equals(streamTokenizer.sval)) {
                                        this.m_displayOption.setTag(12);
                                        if (bl) {
                                            for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTag(12);
                                            }
                                        }
                                    } else {
                                        this.m_displayOption.clearTag(12);
                                        if (bl) {
                                            for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).clearTag(12);
                                            }
                                        }
                                    }
                                    return true;
                                }
                                if ("AspectRatio".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    this.m_aspectRatio = streamTokenizer.ttype == -2 ? streamTokenizer.nval : 0.0;
                                    return true;
                                }
                                if ("AxesLabel".equals(streamTokenizer.sval)) {
                                    this.readAxesLabel(streamTokenizer, this.m_dim);
                                    if (bl) {
                                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setAxesLabel(this.m_displayOption.getAxesLabel());
                                        }
                                    }
                                    return true;
                                }
                                if ("ColorOutput".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if ("GrayLevel".equals(streamTokenizer.sval)) {
                                        this.m_bGrayLevel = true;
                                        this.m_bBlackWhite = false;
                                        return true;
                                    }
                                    if ("None".equals(streamTokenizer.sval)) {
                                        this.m_bGrayLevel = true;
                                        this.m_bBlackWhite = true;
                                        return true;
                                    }
                                    this.m_bGrayLevel = false;
                                    this.m_bBlackWhite = false;
                                    streamTokenizer.pushBack();
                                    return true;
                                }
                                if ("ColorFunction".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.ttype == -3) {
                                        this.m_colorFunction = "Hue".equals(streamTokenizer.sval) ? 1 : 0;
                                        return true;
                                    }
                                    if (streamTokenizer.ttype == 40 || streamTokenizer.ttype == 91 || streamTokenizer.ttype == 123) {
                                        int n = 1;
                                        while (n != 0) {
                                            streamTokenizer.nextToken();
                                            if (streamTokenizer.ttype == 40 || streamTokenizer.ttype == 91 || streamTokenizer.ttype == 123) {
                                                ++n;
                                                continue;
                                            }
                                            if (streamTokenizer.ttype != 41 && streamTokenizer.ttype != 93 && streamTokenizer.ttype != 125) continue;
                                            --n;
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                if ("ColorFunctionScaling".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    this.m_bColorFunctionScaling = "True".equals(streamTokenizer.sval);
                                    return true;
                                }
                                if ("AxesStyle".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.parseNumbers();
                                    if (streamTokenizer.ttype == -3) {
                                        if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                            Color color = PgMathLoader.readColor(streamTokenizer);
                                            for (int i = 0; i < this.m_dim; ++i) {
                                                this.m_displayOption.setRulerColor(i, color);
                                                if (!bl) continue;
                                                for (int j = 0; j < this.m_numGraphics - 1; ++j) {
                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(j)).setRulerColor(i, color);
                                                }
                                            }
                                        } else if ("Thickness".equals(streamTokenizer.sval)) {
                                            streamTokenizer.nextToken();
                                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                            for (int i = 0; i < this.m_dim; ++i) {
                                                this.m_displayOption.setRulerSize(i, d);
                                                if (!bl) continue;
                                                for (int j = 0; j < this.m_numGraphics - 1; ++j) {
                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(j)).setRulerSize(i, d);
                                                }
                                            }
                                            streamTokenizer.nextToken();
                                        } else if ("AbsoluteThickness".equals(streamTokenizer.sval)) {
                                            streamTokenizer.nextToken();
                                            double d = PgMathLoader.readNumber(streamTokenizer);
                                            for (int i = 0; i < this.m_dim; ++i) {
                                                this.m_displayOption.setRulerSize(i, d);
                                                if (!bl) continue;
                                                for (int j = 0; j < this.m_numGraphics - 1; ++j) {
                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(j)).setRulerSize(i, d);
                                                }
                                            }
                                            streamTokenizer.nextToken();
                                        }
                                    } else {
                                        streamTokenizer.nextToken();
                                        if (streamTokenizer.ttype == -3) {
                                            int n = 1;
                                            streamTokenizer.pushBack();
                                            while (n > 0) {
                                                streamTokenizer.nextToken();
                                                if (streamTokenizer.ttype == -1) {
                                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                                    return false;
                                                }
                                                if (streamTokenizer.ttype == -3) {
                                                    int n2;
                                                    int n3;
                                                    if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                                        Color color = PgMathLoader.readColor(streamTokenizer);
                                                        for (int i = 0; i < this.m_dim; ++i) {
                                                            this.m_displayOption.setRulerColor(i, color);
                                                            if (!bl) continue;
                                                            for (n3 = 0; n3 < this.m_numGraphics - 1; ++n3) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n3)).setRulerColor(i, color);
                                                            }
                                                        }
                                                        continue;
                                                    }
                                                    if ("Thickness".equals(streamTokenizer.sval)) {
                                                        streamTokenizer.nextToken();
                                                        double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                                        for (n3 = 0; n3 < this.m_dim; ++n3) {
                                                            this.m_displayOption.setRulerSize(n3, d);
                                                            if (!bl) continue;
                                                            for (n2 = 0; n2 < this.m_numGraphics - 1; ++n2) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n2)).setRulerSize(n3, d);
                                                            }
                                                        }
                                                        streamTokenizer.nextToken();
                                                        continue;
                                                    }
                                                    if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                                    streamTokenizer.nextToken();
                                                    double d = PgMathLoader.readNumber(streamTokenizer);
                                                    for (n3 = 0; n3 < this.m_dim; ++n3) {
                                                        this.m_displayOption.setRulerSize(n3, d);
                                                        if (!bl) continue;
                                                        for (n2 = 0; n2 < this.m_numGraphics - 1; ++n2) {
                                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n2)).setRulerSize(n3, d);
                                                        }
                                                    }
                                                    streamTokenizer.nextToken();
                                                    continue;
                                                }
                                                if (streamTokenizer.ttype == 123) {
                                                    ++n;
                                                    continue;
                                                }
                                                if (streamTokenizer.ttype != 125) continue;
                                                --n;
                                            }
                                        } else if (streamTokenizer.ttype == 125) {
                                            streamTokenizer.nextToken();
                                        } else {
                                            streamTokenizer.pushBack();
                                            for (int i = 0; i < this.m_dim; ++i) {
                                                streamTokenizer.nextToken();
                                                int n = 1;
                                                while (n > 0) {
                                                    streamTokenizer.nextToken();
                                                    if (streamTokenizer.ttype == -1) {
                                                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                                        return false;
                                                    }
                                                    if (streamTokenizer.ttype == -3) {
                                                        int n4;
                                                        if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                                            Color color = PgMathLoader.readColor(streamTokenizer);
                                                            this.m_displayOption.setRulerColor(i, color);
                                                            if (!bl) continue;
                                                            for (int j = 0; j < this.m_numGraphics - 1; ++j) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(j)).setRulerColor(i, color);
                                                            }
                                                            continue;
                                                        }
                                                        if ("Thickness".equals(streamTokenizer.sval)) {
                                                            streamTokenizer.nextToken();
                                                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                                            this.m_displayOption.setRulerSize(i, d);
                                                            if (bl) {
                                                                for (n4 = 0; n4 < this.m_numGraphics - 1; ++n4) {
                                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n4)).setRulerSize(i, d);
                                                                }
                                                            }
                                                            streamTokenizer.nextToken();
                                                            continue;
                                                        }
                                                        if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                                        streamTokenizer.nextToken();
                                                        double d = PgMathLoader.readNumber(streamTokenizer);
                                                        if (bl) {
                                                            for (n4 = 0; n4 < this.m_numGraphics - 1; ++n4) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n4)).setRulerSize(i, d);
                                                            }
                                                        }
                                                        streamTokenizer.nextToken();
                                                        continue;
                                                    }
                                                    if (streamTokenizer.ttype == 123) {
                                                        ++n;
                                                        continue;
                                                    }
                                                    if (streamTokenizer.ttype != 125) continue;
                                                    --n;
                                                }
                                                streamTokenizer.nextToken();
                                            }
                                        }
                                    }
                                    return true;
                                }
                                if ("PlotLabel".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                                        return true;
                                    }
                                    streamTokenizer.pushBack();
                                    this.m_displayOption.setTag(33);
                                    String string = PgMathLoader.readString2(streamTokenizer);
                                    this.m_displayOption.setName(string);
                                    if (bl) {
                                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTag(33);
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTitle(string);
                                        }
                                    }
                                    return true;
                                }
                                if ("PlotRange".equals(streamTokenizer.sval)) {
                                    int n;
                                    int n5;
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.parseNumbers();
                                    streamTokenizer.nextToken();
                                    double[][] dArrayArray = new double[this.m_dim][];
                                    for (n5 = 0; n5 < this.m_dim; n5 += 1) {
                                        dArrayArray[n5] = new double[]{Double.NEGATIVE_INFINITY, Double.MAX_VALUE};
                                    }
                                    n5 = 0;
                                    if (streamTokenizer.ttype != -3 || !"All".equals(streamTokenizer.sval) && !"Automatic".equals(streamTokenizer.sval)) {
                                        n5 = 1;
                                        streamTokenizer.nextToken();
                                        if (streamTokenizer.ttype == -2) {
                                            streamTokenizer.pushBack();
                                            double[] dArray = new double[2];
                                            dArray[0] = PgMathLoader.readNumber(streamTokenizer);
                                            streamTokenizer.nextToken();
                                            dArray[1] = PgMathLoader.readNumber(streamTokenizer);
                                            streamTokenizer.nextToken();
                                            if (dArray[0] <= dArray[1]) {
                                                dArrayArray[this.m_dim - 1] = dArray;
                                            }
                                        } else {
                                            streamTokenizer.pushBack();
                                            for (int i = 0; i < this.m_dim; ++i) {
                                                streamTokenizer.nextToken();
                                                if (streamTokenizer.ttype != -3 || !"All".equals(streamTokenizer.sval) && !"Automatic".equals(streamTokenizer.sval)) {
                                                    double[] dArray = new double[2];
                                                    dArray[0] = PgMathLoader.readNumber(streamTokenizer);
                                                    streamTokenizer.nextToken();
                                                    dArray[1] = PgMathLoader.readNumber(streamTokenizer);
                                                    streamTokenizer.nextToken();
                                                    if (dArray[0] <= dArray[1]) {
                                                        dArrayArray[i] = dArray;
                                                    }
                                                }
                                                streamTokenizer.nextToken();
                                            }
                                        }
                                    }
                                    for (n = 0; n < this.m_dim; ++n) {
                                        this.m_displayOption.setClipBounds(n, dArrayArray[n]);
                                        if (!bl) continue;
                                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setClipBounds(n, (double[])dArrayArray[n].clone());
                                        }
                                    }
                                    this.m_displayOption.setOption(36, n5 != 0);
                                    if (bl) {
                                        for (n = 0; n < this.m_numGraphics - 1; ++n) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setOption(36, true);
                                        }
                                    }
                                    return true;
                                }
                                if (!"BoxStyle".equals(streamTokenizer.sval)) break block182;
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                if (streamTokenizer.ttype != -3) break block183;
                                if (!"RGBColor".equals(streamTokenizer.sval) && !"Hue".equals(streamTokenizer.sval) && !"GrayLevel".equals(streamTokenizer.sval) && !"CMYKColor".equals(streamTokenizer.sval)) break block184;
                                this.m_bndBoxColor = PgMathLoader.readColor(streamTokenizer);
                                break block185;
                            }
                            if (!"Thickness".equals(streamTokenizer.sval)) break block186;
                            streamTokenizer.nextToken();
                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                            this.m_displayOption.setBndBoxSize(d);
                            if (bl) {
                                for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setBndBoxSize(d);
                                }
                            }
                            streamTokenizer.nextToken();
                            break block185;
                        }
                        if (!"AbsoluteThickness".equals(streamTokenizer.sval)) break block185;
                        streamTokenizer.nextToken();
                        double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                        this.m_displayOption.setBndBoxSize(d);
                        if (bl) {
                            for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setBndBoxSize(d);
                            }
                        }
                        streamTokenizer.nextToken();
                        break block185;
                    }
                    if (streamTokenizer.ttype == 123) {
                        int n = 1;
                        while (n > 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if (streamTokenizer.ttype == -3) {
                                int n6;
                                double d;
                                if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                    this.m_bndBoxColor = PgMathLoader.readColor(streamTokenizer);
                                    continue;
                                }
                                if ("Thickness".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                    this.m_displayOption.setBndBoxSize(d);
                                    if (bl) {
                                        for (n6 = 0; n6 < this.m_numGraphics - 1; ++n6) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n6)).setBndBoxSize(d);
                                        }
                                    }
                                    streamTokenizer.nextToken();
                                    continue;
                                }
                                if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                this.m_displayOption.setBndBoxSize(d);
                                if (bl) {
                                    for (n6 = 0; n6 < this.m_numGraphics - 1; ++n6) {
                                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n6)).setBndBoxSize(d);
                                    }
                                }
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (streamTokenizer.ttype == 123) {
                                ++n;
                                continue;
                            }
                            if (streamTokenizer.ttype != 125) continue;
                            --n;
                        }
                    }
                }
                return true;
            }
            if ("DefaultColor".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("Automatic".equals(streamTokenizer.sval)) {
                    Color color = this.m_displayOption.getBackgroundColor();
                    if (color != null) {
                        int n = 0;
                        int n7 = 0;
                        int n8 = 0;
                        if (color.getRed() < 127) {
                            n8 = 255;
                        }
                        if (color.getBlue() < 127) {
                            n = 255;
                        }
                        if (color.getGreen() < 127) {
                            n7 = 255;
                        }
                        this.m_defaultColor = new Color(n8, n7, n);
                    }
                } else {
                    this.m_defaultColor = PgMathLoader.readColor(streamTokenizer);
                }
                return true;
            }
            if ("ImageSize".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    if (streamTokenizer.ttype == -2) {
                        int n = (int)streamTokenizer.nval;
                        int n9 = 3 * n / 4;
                        this.m_displayOption.setWindowSize(n, n9);
                        if (bl) {
                            for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setWindowSize(n, n9);
                            }
                        }
                    } else {
                        int n = -1;
                        int n10 = -1;
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -2) {
                            n = (int)streamTokenizer.nval;
                        }
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -2) {
                            n10 = (int)streamTokenizer.nval;
                        }
                        streamTokenizer.nextToken();
                        if (n != -1 || n10 != -1) {
                            if (n == -1) {
                                n = 4 * n10 / 3;
                            }
                            if (n10 == -1) {
                                n10 = 3 * n / 4;
                            }
                            this.m_displayOption.setWindowSize(n, n10);
                            if (bl) {
                                for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setWindowSize(n, n10);
                                }
                            }
                        }
                    }
                }
                return true;
            }
            if ("Axes".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval) || "Automatic".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(5);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTag(5);
                        }
                    }
                } else {
                    this.m_displayOption.clearTag(5);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).clearTag(5);
                        }
                    }
                }
                return true;
            }
            if ("Lighting".equals(streamTokenizer.sval)) {
                return this.parseLighting(streamTokenizer, this.m_displayOption, bl);
            }
            if ("LightSources".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 125) {
                    this.m_displayOption.setNumLights(1);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setNumLights(1);
                        }
                    }
                } else {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        PdVector[] pdVectorArray = new PdVector[1];
                        Color[] colorArray = new Color[1];
                        pdVectorArray[0] = new PdVector(3);
                        for (int i = 0; i < 3; ++i) {
                            streamTokenizer.pushBack();
                            pdVectorArray[0].m_data[i] = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        colorArray[0] = PgMathLoader.readColor(streamTokenizer);
                        streamTokenizer.nextToken();
                    } else {
                        int n;
                        Vector<PdVector> vector = new Vector<PdVector>();
                        Vector<Color> vector2 = new Vector<Color>();
                        while (streamTokenizer.ttype != 125) {
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            PdVector pdVector = new PdVector(3);
                            for (n = 0; n < 3; ++n) {
                                pdVector.m_data[n] = PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                            }
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            Color color = PgMathLoader.readColor(streamTokenizer);
                            streamTokenizer.nextToken();
                            vector.addElement(pdVector);
                            vector2.addElement(color);
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 44) continue;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        }
                        PdVector[] pdVectorArray = new PdVector[vector.size()];
                        Color[] colorArray = new Color[vector2.size()];
                        int n11 = vector.size();
                        this.m_displayOption.setNumLights(n11 + 1);
                        if (bl) {
                            for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setNumLights(n11 + 1);
                            }
                        }
                        for (int i = 0; i < n11; ++i) {
                            pdVectorArray[i] = (PdVector)vector.elementAt(i);
                            colorArray[i] = (Color)vector2.elementAt(i);
                            this.m_displayOption.setLightColor(i + 1, (Color)vector2.elementAt(i));
                            this.m_displayOption.setLightPosition(i + 1, (PdVector)vector.elementAt(i));
                            this.m_displayOption.setLightType(i + 1, 1);
                            this.m_displayOption.setLightIntensity(i + 1, 1.0);
                            if (!bl) continue;
                            for (n = 0; n < this.m_numGraphics - 1; ++n) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightColor(i + 1, (Color)vector2.elementAt(i));
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightPosition(i + 1, (PdVector)((PdVector)vector.elementAt(i)).clone());
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightType(i + 1, 1);
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightIntensity(i + 1, 1.0);
                            }
                        }
                    }
                }
                return true;
            }
            if ("ViewPoint".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                PdVector pdVector = new PdVector();
                if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                    return false;
                }
                this.m_displayOption.setCameraPosition(0, pdVector);
                if (bl) {
                    for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setCameraPosition(0, (PdVector)pdVector.clone());
                    }
                }
                return true;
            }
            if ("ViewCenter".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.pushBack();
                    PdVector pdVector = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    this.m_displayOption.setCameraInterest(0, pdVector);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setCameraInterest(0, (PdVector)pdVector.clone());
                        }
                    }
                }
                return true;
            }
            if ("AxesEdge".equals(streamTokenizer.sval)) {
                int n;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PiVector piVector = new PiVector(6);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    for (n = 0; n < 6; ++n) {
                        piVector.m_data[n] = -1;
                    }
                } else {
                    for (n = 0; n < 3; ++n) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3) {
                            if ("Automatic".equals(streamTokenizer.sval)) {
                                piVector.m_data[n * 2] = -1;
                                piVector.m_data[n * 2 + 1] = -1;
                            } else {
                                piVector.m_data[n * 2] = 0;
                                piVector.m_data[n * 2 + 1] = 0;
                            }
                        } else {
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2 + 1] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                    }
                }
                this.m_displayOption.setAxesEdge(piVector);
                if (bl) {
                    for (n = 0; n < this.m_numGraphics - 1; ++n) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setAxesEdge((PiVector)piVector.clone());
                    }
                }
                return true;
            }
            if ("AmbientLight".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                Color color = "None".equals(streamTokenizer.sval) ? new Color(0, 0, 0) : PgMathLoader.readColor(streamTokenizer);
                this.m_displayOption.setAmbientLight(color);
                this.m_displayOption.setLightIntensity(0, 1.0);
                if (bl) {
                    for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setAmbientLight(color);
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightIntensity(0, 1.0);
                    }
                }
                return true;
            }
            if ("BoxRatios".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                this.m_boxRatio = null;
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.pushBack();
                    PdVector pdVector = new PdVector(3);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    this.m_boxRatio = pdVector;
                }
                return true;
            }
            if ("Background".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval))) {
                    Color color;
                    Color color2 = PgMathLoader.readColor(streamTokenizer);
                    this.m_displayOption.setBackgroundColor(color2);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setBackgroundColor(color2);
                        }
                    }
                    if (this.m_defaultColor == null && (color = this.m_displayOption.getBackgroundColor()) != null) {
                        int n = 0;
                        int n12 = 0;
                        int n13 = 0;
                        if (color.getRed() < 127) {
                            n13 = 255;
                        }
                        if (color.getBlue() < 127) {
                            n = 255;
                        }
                        if (color.getGreen() < 127) {
                            n12 = 255;
                        }
                        this.m_defaultColor = new Color(n13, n12, n);
                    }
                }
                return true;
            }
            if ("PolygonIntersections".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("False".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(30);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTag(30);
                        }
                    }
                } else {
                    this.m_displayOption.clearTag(30);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).clearTag(30);
                        }
                    }
                }
                return true;
            }
            if ("ViewVertical".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    return true;
                }
                streamTokenizer.pushBack();
                streamTokenizer.parseNumbers();
                return PgMathLoader.parseVector(streamTokenizer, this.m_viewVertical, 3);
            }
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private boolean parseLighting(StreamTokenizer streamTokenizer, PvDisplayOption pvDisplayOption, boolean bl) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3) {
                if ("True".equals(streamTokenizer.sval) || "Automatic".equals(streamTokenizer.sval)) {
                    pvDisplayOption.setTag(22);
                    pvDisplayOption.setLightingModel(1);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setTag(22);
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightingModel(1);
                        }
                    }
                } else if ("False".equals(streamTokenizer.sval) || "None".equals(streamTokenizer.sval)) {
                    pvDisplayOption.clearTag(22);
                    pvDisplayOption.setLightingModel(0);
                    if (bl) {
                        for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).clearTag(22);
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightingModel(0);
                        }
                    }
                }
            } else if (streamTokenizer.ttype == 34) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                int n = pvDisplayOption.getNumLights();
                for (int i = 0; i < n; ++i) {
                    pvDisplayOption.setLightColor(i, Color.white);
                    if (!bl) continue;
                    for (int j = 0; j < this.m_numGraphics - 1; ++j) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(j)).setLightColor(i, Color.white);
                    }
                }
            } else {
                int n;
                int n2 = 1;
                streamTokenizer.nextToken();
                pvDisplayOption.setNumLights(1);
                pvDisplayOption.setLightIntensity(0, 0.0);
                if (bl) {
                    for (n = 0; n < this.m_numGraphics - 1; ++n) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setNumLights(1);
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightIntensity(0, 0.0);
                    }
                }
                n = 0;
                while (n2 != 0) {
                    if (streamTokenizer.ttype == 123) {
                        int n3;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if ("Ambient".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            Color color = PgMathLoader.readColor(streamTokenizer);
                            pvDisplayOption.setAmbientLight(color);
                            this.m_displayOption.setLightIntensity(0, 1.0);
                            if (bl) {
                                for (n3 = 0; n3 < this.m_numGraphics - 1; ++n3) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n3)).setAmbientLight(color);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n3)).setLightIntensity(0, 1.0);
                                }
                            }
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } else if ("Directional".equals(streamTokenizer.sval)) {
                            ++n;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            Color color = PgMathLoader.readColor(streamTokenizer);
                            n3 = 0;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            boolean bl2 = true;
                            PdVector pdVector = new PdVector(3);
                            PdVector pdVector2 = new PdVector(3);
                            boolean bl3 = false;
                            if (streamTokenizer.ttype == 123) {
                                streamTokenizer.nextToken();
                                if (streamTokenizer.ttype == -2) {
                                    bl2 = false;
                                    streamTokenizer.pushBack();
                                    PgMathLoader.parseVectorNB(streamTokenizer, pdVector, 3);
                                    bl3 = true;
                                }
                            } else if (streamTokenizer.ttype == -3 && ("Scaled".equals(streamTokenizer.sval) || "ImageScaled".equals(streamTokenizer.sval))) {
                                bl2 = false;
                            }
                            boolean bl4 = false;
                            if (!bl3) {
                                if (streamTokenizer.ttype == -3) {
                                    if ("ImageScaled".equals(streamTokenizer.sval)) {
                                        n3 = 1;
                                    }
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    bl4 = true;
                                }
                                PgMathLoader.parseVectorNB(streamTokenizer, pdVector, 3);
                                if (bl4) {
                                    streamTokenizer.nextToken();
                                }
                            }
                            bl4 = false;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == -3) {
                                if ("ImageScaled".equals(streamTokenizer.sval)) {
                                    n3 = 1;
                                }
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                bl4 = true;
                            }
                            PgMathLoader.parseVectorNB(streamTokenizer, pdVector2, 3);
                            if (bl4) {
                                streamTokenizer.nextToken();
                            }
                            if (bl2) {
                                streamTokenizer.nextToken();
                            }
                            streamTokenizer.nextToken();
                            pvDisplayOption.setNumLights(n + 1);
                            pvDisplayOption.setLightType(n, 1);
                            pvDisplayOption.setLightIntensity(n, 1.0);
                            pvDisplayOption.setLightColor(n, color);
                            pvDisplayOption.setLightReference(n, n3);
                            pvDisplayOption.setLightPosition(n, pdVector);
                            pvDisplayOption.setLightInterest(n, pdVector2);
                            if (bl) {
                                for (int i = 0; i < this.m_numGraphics - 1; ++i) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setNumLights(n + 1);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightType(n, 1);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightIntensity(n, 1.0);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightColor(n, color);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightReference(n, n3);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightPosition(n, pdVector);
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(i)).setLightInterest(n, pdVector2);
                                }
                            }
                            streamTokenizer.nextToken();
                        } else {
                            PsDebug.message("Skipping Light " + streamTokenizer.sval);
                            int n4 = 1;
                            while (n4 != 0) {
                                if (streamTokenizer.ttype == 123) {
                                    ++n4;
                                }
                                if (streamTokenizer.ttype == 125) {
                                    --n4;
                                }
                                streamTokenizer.nextToken();
                            }
                        }
                    }
                    if (streamTokenizer.ttype == 125) {
                        --n2;
                        continue;
                    }
                    streamTokenizer.nextToken();
                }
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
        return true;
    }

    private void readAxesLabel(StreamTokenizer streamTokenizer, int n) {
        try {
            int n2;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            String[] stringArray = new String[n];
            if (streamTokenizer.ttype == -3) {
                if ("None".equals(streamTokenizer.sval)) {
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = "";
                    }
                    this.m_displayOption.setAxesLabel(stringArray);
                    this.m_displayOption.clearTag(9);
                    return;
                }
                streamTokenizer.pushBack();
            }
            if (streamTokenizer.ttype == 123) {
                this.m_displayOption.setTag(9);
                for (n2 = 0; n2 < n; ++n2) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                        stringArray[n2] = "";
                    } else {
                        streamTokenizer.pushBack();
                        stringArray[n2] = PgMathLoader.readString2(streamTokenizer);
                    }
                    streamTokenizer.ordinaryChar(92);
                    int n3 = 1;
                    while (n3 != 0) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44 && n3 == 1 || streamTokenizer.ttype == 125 || streamTokenizer.ttype == 93) {
                            --n3;
                        } else if (streamTokenizer.ttype == 123 || streamTokenizer.ttype == 91) {
                            ++n3;
                        }
                        if (n3 <= 0) continue;
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            continue;
                        }
                        if (streamTokenizer.ttype == -3) {
                            int n4 = n2;
                            stringArray[n4] = stringArray[n4] + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            streamTokenizer.pushBack();
                            int n5 = n2;
                            stringArray[n5] = stringArray[n5] + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 91) {
                            int n6 = n2;
                            stringArray[n6] = stringArray[n6] + "[";
                            continue;
                        }
                        if (streamTokenizer.ttype == 93) {
                            int n7 = n2;
                            stringArray[n7] = stringArray[n7] + "]";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            int n8 = n2;
                            stringArray[n8] = stringArray[n8] + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            int n9 = n2;
                            stringArray[n9] = stringArray[n9] + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype == 94) {
                            int n10 = n2;
                            stringArray[n10] = stringArray[n10] + "^";
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            int n11 = n2;
                            stringArray[n11] = stringArray[n11] + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            int n12 = n2;
                            stringArray[n12] = stringArray[n12] + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 40) {
                            int n13 = n2;
                            stringArray[n13] = stringArray[n13] + "(";
                            continue;
                        }
                        if (streamTokenizer.ttype == 41) {
                            int n14 = n2;
                            stringArray[n14] = stringArray[n14] + ")";
                            continue;
                        }
                        if (streamTokenizer.ttype == 45) {
                            int n15 = n2;
                            stringArray[n15] = stringArray[n15] + "-";
                            continue;
                        }
                        if (streamTokenizer.ttype == 62) {
                            int n16 = n2;
                            stringArray[n16] = stringArray[n16] + ">";
                            continue;
                        }
                        if (streamTokenizer.ttype == 47) {
                            int n17 = n2;
                            stringArray[n17] = stringArray[n17] + "/";
                            continue;
                        }
                        if (streamTokenizer.ttype != 92) continue;
                        int n18 = n2;
                        stringArray[n18] = stringArray[n18] + "\\";
                    }
                    streamTokenizer.whitespaceChars(92, 92);
                }
            } else {
                this.m_displayOption.setTag(9);
                for (n2 = 0; n2 < n - 1; ++n2) {
                    stringArray[n2] = "";
                }
                stringArray[n - 1] = PgMathLoader.readString2(streamTokenizer);
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (stringArray[n2] == null || !"".equals(stringArray[n2])) continue;
                stringArray[n2] = null;
            }
            this.m_displayOption.setAxesLabel(stringArray);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
        }
    }

    private static boolean parseVector(StreamTokenizer streamTokenizer, PdVector pdVector, int n) {
        pdVector.setSize(n);
        try {
            streamTokenizer.nextToken();
            boolean bl = false;
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("Offset")) {
                bl = true;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
            }
            for (int i = 0; i < n; ++i) {
                pdVector.m_data[i] = PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
            }
            if (bl) {
                streamTokenizer.nextToken();
            }
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("parseVector throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private static boolean parseVectorNB(StreamTokenizer streamTokenizer, PdVector pdVector, int n) {
        pdVector.setSize(n);
        try {
            boolean bl = false;
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("Offset")) {
                bl = true;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
            }
            for (int i = 0; i < n; ++i) {
                pdVector.m_data[i] = PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
            }
            if (bl) {
                streamTokenizer.nextToken();
            }
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("parseVector throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private static int parsePointOrList(StreamTokenizer streamTokenizer, Vector vector, int n) {
        int n2 = 0;
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 123) {
                streamTokenizer.pushBack();
                while (streamTokenizer.ttype != 125) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return 0;
                    }
                    PdVector pdVector = new PdVector(n);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector, n)) {
                        return 0;
                    }
                    vector.addElement(pdVector);
                    ++n2;
                    streamTokenizer.nextToken();
                }
            } else {
                streamTokenizer.pushBack();
                PdVector pdVector = new PdVector(n);
                if (!PgMathLoader.parseVectorNB(streamTokenizer, pdVector, n)) {
                    return 0;
                }
                vector.addElement(pdVector);
                n2 = 1;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("parsePointOrList throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 0;
        }
        return n2;
    }

    private static PiVector parsePolygonOrList(StreamTokenizer streamTokenizer, Vector vector, int n) {
        PiVector piVector = new PiVector(1);
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 123) {
                int n2 = 0;
                boolean bl = true;
                while (streamTokenizer.ttype != 125) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return null;
                    }
                    PdVector pdVector = new PdVector(n);
                    if (bl) {
                        bl = false;
                        if (!PgMathLoader.parseVectorNB(streamTokenizer, pdVector, n)) {
                            return null;
                        }
                    } else if (!PgMathLoader.parseVector(streamTokenizer, pdVector, n)) {
                        return null;
                    }
                    vector.addElement(pdVector);
                    ++n2;
                    streamTokenizer.nextToken();
                }
                piVector.m_data[0] = n2;
            } else {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 123) {
                    int n3 = 0;
                    boolean bl = true;
                    streamTokenizer.pushBack();
                    while (streamTokenizer.ttype != 125) {
                        int n4 = 0;
                        if (bl) {
                            bl = false;
                        } else {
                            streamTokenizer.nextToken();
                        }
                        while (streamTokenizer.ttype != 125) {
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return null;
                            }
                            PdVector pdVector = new PdVector(n);
                            if (!PgMathLoader.parseVector(streamTokenizer, pdVector, n)) {
                                return null;
                            }
                            vector.addElement(pdVector);
                            ++n4;
                            streamTokenizer.nextToken();
                        }
                        piVector.setSize(++n3);
                        piVector.m_data[n3 - 1] = n4;
                        streamTokenizer.nextToken();
                    }
                } else {
                    int n5 = 0;
                    boolean bl = true;
                    streamTokenizer.pushBack();
                    while (streamTokenizer.ttype != 125) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return null;
                        }
                        PdVector pdVector = new PdVector(n);
                        if (bl) {
                            bl = false;
                            if (!PgMathLoader.parseVectorNB(streamTokenizer, pdVector, n)) {
                                return null;
                            }
                        } else if (!PgMathLoader.parseVector(streamTokenizer, pdVector, n)) {
                            return null;
                        }
                        vector.addElement(pdVector);
                        ++n5;
                        streamTokenizer.nextToken();
                    }
                    piVector.m_data[0] = n5;
                }
            }
        }
        catch (Exception exception) {
            PsDebug.warning("parsePolygonOrList throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return null;
        }
        return piVector;
    }

    private static PiVector parseIntVector(StreamTokenizer streamTokenizer) {
        PiVector piVector = new PiVector();
        try {
            int n = 0;
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                piVector.setSize(++n);
                piVector.setEntry(n - 1, (int)streamTokenizer.nval);
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            PsDebug.warning("parseIntVectorNB throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return null;
        }
        return piVector;
    }

    private static PiVector parseIntVectorNB(StreamTokenizer streamTokenizer) {
        PiVector piVector = new PiVector();
        try {
            int n = 0;
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                piVector.setSize(++n);
                piVector.setEntry(n - 1, (int)streamTokenizer.nval);
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            PsDebug.warning("parseIntVectorNB throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return null;
        }
        return piVector;
    }

    private static int parseIntPolygonOrList(StreamTokenizer streamTokenizer, Vector vector) {
        int n = 0;
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                streamTokenizer.pushBack();
                vector.addElement(PgMathLoader.parseIntVectorNB(streamTokenizer));
                n = 1;
            } else {
                streamTokenizer.pushBack();
                while (streamTokenizer.ttype != 125) {
                    vector.addElement(PgMathLoader.parseIntVector(streamTokenizer));
                    ++n;
                    streamTokenizer.nextToken();
                }
            }
        }
        catch (Exception exception) {
            PsDebug.warning("parseIntPolygonOrList throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 0;
        }
        return n;
    }

    private void adjustViewer() {
        PdVector pdVector = this.m_displayOption.getCameraInterest(0);
        PdVector pdVector2 = this.m_displayOption.getCameraPosition(0);
        PdVector pdVector3 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
        this.m_boxRatio = this.m_displayOption.getBoxRatio();
        if (this.m_boxRatio != null) {
            int n;
            double d = this.m_boxRatio.m_data[0] + this.m_boxRatio.m_data[1] + this.m_boxRatio.m_data[2];
            for (n = 0; n < 3; ++n) {
                if (this.m_boxRatio.m_data[n] == 0.0 || !(this.m_boxRatio.m_data[n] < d)) continue;
                d = this.m_boxRatio.m_data[n];
            }
            for (n = 0; n < 3; ++n) {
                if (this.m_boxRatio.m_data[n] == 0.0) continue;
                int n2 = n;
                pdVector2.m_data[n2] = pdVector2.m_data[n2] / (this.m_boxRatio.m_data[n] / d);
            }
        }
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.m_viewVertical.m_data[n] = this.m_viewVertical.m_data[n] * pdVector3.m_data[i];
            double d = pdVector.m_data[i];
            pdVector.m_data[i] = (1.0 - d) * this.m_boundingBoxMin.m_data[i] + d * this.m_boundingBoxMax.m_data[i];
            int n3 = i;
            pdVector3.m_data[n3] = pdVector3.m_data[n3] * (1.0 + 2.0 * Math.abs(0.5 - d));
            if (pdVector3.m_data[i] != 0.0) continue;
            pdVector3.m_data[i] = 1.0;
        }
        double d = 0.5;
        double d2 = pdVector2.length() - d;
        double d3 = d2 < 1.0E-10 ? 0.5 : 1.0 / d2;
        this.m_displayOption.setCameraFieldOfView(0, d3);
        pdVector2.normalize();
        pdVector2.multScalar(pdVector3.length());
        pdVector2.add(pdVector);
        PdVector pdVector4 = PdVector.subNew(pdVector2, pdVector);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
        if (!pdVector6.normalize()) {
            pdVector5.m_data[1] = pdVector5.m_data[1] + 1.0;
            pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
            if (!pdVector6.normalize()) {
                pdVector5.m_data[2] = pdVector5.m_data[2] + 1.0;
                pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
                if (!pdVector6.normalize()) {
                    pdVector5.m_data[2] = pdVector5.m_data[2] + 1.0;
                    pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
                }
            }
        }
        PdVector pdVector7 = PdVector.crossNew(pdVector4, pdVector6);
        double d4 = -PdVector.angleWithOrientation(PdVector.crossNew(pdVector4, this.m_viewVertical), pdVector7, pdVector4) * 180.0 / Math.PI;
        this.m_displayOption.setCameraRoll(0, d4);
        int n = this.m_displayOption.getNumLights();
        for (int i = 0; i < n; ++i) {
            if (this.m_displayOption.getLightType(i) != 1) continue;
            this.m_displayOption.setLightReference(i, 1);
            this.m_displayOption.setLightShading(i, 1);
        }
    }

    private void evaluateOptions() {
        block27: {
            block26: {
                int n;
                int n2;
                if (this.m_isGraphicsArray || this.m_bIsAnimation || this.m_bIsKeyAnimation) break block26;
                this.m_displayOption = (PvDisplayOption)this.m_displayOptionVector.elementAt(0);
                this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(0);
                this.m_defaultColor = (Color)this.m_defaultColorVector.elementAt(0);
                this.m_bndBoxColor = (Color)this.m_bndBoxColorVector.elementAt(0);
                this.m_boxRatio = (PdVector)this.m_boxRatioVector.elementAt(0);
                this.m_bGrayLevel = (Boolean)this.m_bGrayLevelVector.elementAt(0);
                this.m_bBlackWhite = (Boolean)this.m_bBlackWhiteVector.elementAt(0);
                this.m_dim = 0;
                int n3 = 0;
                this.m_animArr = new PgJvxSrc[this.m_numGraphics][];
                for (int i = 0; i < this.m_numGraphics; ++i) {
                    this.m_animArr[i] = (PgJvxSrc[])this.m_graphicsVector.elementAt(i);
                    int n4 = this.m_animArr[i].length;
                    n3 += n4;
                    for (n2 = 0; n2 < n4; ++n2) {
                        n = this.m_animArr[i][n2].getDimOfVertices();
                        if (n <= this.m_dim) continue;
                        this.m_dim = n;
                    }
                }
                this.m_boundingBoxMin = new PdVector(3);
                this.m_boundingBoxMax = new PdVector(3);
                PdVector[] pdVectorArray = new PdVector[n3];
                PdVector[] pdVectorArray2 = new PdVector[n3];
                n2 = 0;
                for (n = 0; n < this.m_numGraphics; ++n) {
                    int n5 = this.m_animArr[n].length;
                    for (int i = 0; i < n5; ++i) {
                        PdVector[] pdVectorArray3 = this.m_animArr[n][i].getBounds();
                        if (pdVectorArray3 == null) continue;
                        pdVectorArray[n2] = pdVectorArray3[0];
                        pdVectorArray2[n2] = pdVectorArray3[1];
                        ++n2;
                    }
                }
                if (n2 != 0) {
                    PdVector.min(this.m_boundingBoxMin, pdVectorArray, n2);
                    PdVector.max(this.m_boundingBoxMax, pdVectorArray2, n2);
                } else {
                    this.m_boundingBoxMin.setConstant(-10.0);
                    this.m_boundingBoxMax.setConstant(10.0);
                }
                if (this.m_bGrayLevel) {
                    for (n = 0; n < this.m_displayOption.getNumLights(); ++n) {
                        this.m_displayOption.setLightColor(n, Color.white);
                        if (this.m_displayOption.getLightType(n) == 0) {
                            this.m_displayOption.setLightIntensity(n, 0.0);
                            continue;
                        }
                        this.m_displayOption.setLightIntensity(n, 0.33);
                    }
                }
                int n6 = n = this.m_boxRatio != null ? 1 : 0;
                if (n != 0) {
                    PdVector pdVector = new PdVector(3);
                    double d = this.m_boundingBoxMax.m_data[0] - this.m_boundingBoxMin.m_data[0];
                    pdVector.setEntry(0, this.m_boxRatio.m_data[0]);
                    pdVector.setEntry(1, this.m_boxRatio.m_data[1] * d / (this.m_boundingBoxMax.m_data[1] - this.m_boundingBoxMin.m_data[1]));
                    pdVector.setEntry(2, this.m_boxRatio.m_data[2] * d / (this.m_boundingBoxMax.m_data[2] - this.m_boundingBoxMin.m_data[2]));
                    this.m_displayOption.setBoxRatio(pdVector);
                } else {
                    this.m_displayOption.setBoxRatio(null);
                }
                this.m_displayOption.setOption(35, n != 0);
                if (this.m_dim == 3) {
                    this.adjustViewer();
                    this.m_displayOption.setAxesType(2);
                    this.m_displayOption.setOption(3, false);
                    this.m_displayOption.setOption(2, false);
                } else {
                    if (this.m_aspectRatio != 0.0) {
                        PdVector pdVector = new PdVector(3);
                        double d = this.m_boundingBoxMax.m_data[0] - this.m_boundingBoxMin.m_data[0];
                        pdVector.setEntry(0, 1.0);
                        pdVector.setEntry(1, this.m_aspectRatio * d / (this.m_boundingBoxMax.m_data[1] - this.m_boundingBoxMin.m_data[1]));
                        pdVector.setEntry(2, 1.0);
                        this.m_displayOption.setBoxRatio(pdVector);
                        this.m_displayOption.setOption(35, true);
                    }
                    this.m_displayOption.setCameraProjection(0, 1);
                    PdVector pdVector = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
                    this.m_displayOption.setCameraInterest(0, pdVector);
                    PdVector pdVector2 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
                    double d = pdVector2.max();
                    pdVector = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, d);
                    this.m_displayOption.setCameraPosition(0, pdVector);
                    this.m_displayOption.setCameraRoll(0, 0.0);
                    this.m_displayOption.setCurrentCamera(1);
                    this.m_displayOption.setCameraFieldOfView(0, 0.0);
                    this.m_displayOption.clearTag(12);
                    this.m_displayOption.setAxesType(3);
                    this.m_displayOption.setOption(3, true);
                    this.m_displayOption.setOption(2, true);
                }
                if (this.m_displayOption.getAxesType() == -1) break block27;
                this.m_displayOption.setNumRulers(this.m_dim);
                String[] stringArray = this.m_displayOption.getAxesLabel();
                for (int i = 0; i < this.m_dim; ++i) {
                    if (stringArray != null && stringArray.length > i) {
                        this.m_displayOption.setRulerName(i, stringArray[i]);
                    }
                    this.m_displayOption.setRulerMode(i, 0);
                    this.m_displayOption.showRuler(i, true);
                    if (this.m_displayOption.getRulerName(i) == null) {
                        this.m_displayOption.showRulerName(i, false);
                    }
                    this.m_displayOption.showRulerNumbers(i, true);
                    this.m_displayOption.showRulerHashingsNormal(i, false);
                    this.m_displayOption.showRulerHashingsUp(i, false);
                    this.m_displayOption.showRulerTicksMajor(i, true);
                    this.m_displayOption.showRulerTicksMinor(i, true);
                }
                break block27;
            }
            int n = 0;
            this.m_animArr = new PgJvxSrc[this.m_numGraphics][];
            for (int i = 0; i < this.m_numGraphics; ++i) {
                Object object;
                this.m_displayOption = (PvDisplayOption)this.m_displayOptionVector.elementAt(i);
                this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(i);
                this.m_defaultColor = (Color)this.m_defaultColorVector.elementAt(i);
                this.m_bndBoxColor = (Color)this.m_bndBoxColorVector.elementAt(i);
                this.m_boxRatio = (PdVector)this.m_boxRatioVector.elementAt(i);
                this.m_bGrayLevel = (Boolean)this.m_bGrayLevelVector.elementAt(i);
                this.m_bBlackWhite = (Boolean)this.m_bBlackWhiteVector.elementAt(i);
                this.m_animArr[i] = (PgJvxSrc[])this.m_graphicsVector.elementAt(i);
                int n7 = this.m_animArr[i].length;
                n += n7;
                this.m_dim = 0;
                for (int j = 0; j < n7; ++j) {
                    int n8 = this.m_animArr[i][j].getDimOfVertices();
                    if (n8 <= this.m_dim) continue;
                    this.m_dim = n8;
                }
                this.m_boundingBoxMin = new PdVector(3);
                this.m_boundingBoxMax = new PdVector(3);
                PdVector[] pdVectorArray = new PdVector[n7];
                PdVector[] pdVectorArray4 = new PdVector[n7];
                int n9 = 0;
                for (int j = 0; j < n7; ++j) {
                    object = this.m_animArr[i][j].getBounds();
                    if (object == null) continue;
                    pdVectorArray[n9] = object[0];
                    pdVectorArray4[n9] = object[1];
                    ++n9;
                }
                if (n9 != 0) {
                    PdVector.min(this.m_boundingBoxMin, pdVectorArray, n9);
                    PdVector.max(this.m_boundingBoxMax, pdVectorArray4, n9);
                } else {
                    this.m_boundingBoxMin.setConstant(-10.0);
                    this.m_boundingBoxMax.setConstant(10.0);
                }
                if (this.m_dim == 3) {
                    this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(i);
                    this.adjustViewer();
                    this.m_displayOption.setAxesType(2);
                } else {
                    this.m_displayOption.setCameraProjection(0, 1);
                    PdVector pdVector = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
                    this.m_displayOption.setCameraInterest(0, pdVector);
                    object = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
                    double d = ((PdVector)object).max();
                    pdVector = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, d);
                    this.m_displayOption.setCameraPosition(0, pdVector);
                    this.m_displayOption.setCameraRoll(0, 0.0);
                    this.m_displayOption.setCurrentCamera(1);
                    this.m_displayOption.setCameraFieldOfView(0, 0.0);
                    this.m_displayOption.clearTag(12);
                    this.m_displayOption.setAxesType(3);
                }
                this.m_displayOption.setOption(3, false);
                this.m_displayOption.setOption(2, false);
                if (this.m_displayOption.getAxesType() == -1) continue;
                this.m_displayOption.setNumRulers(this.m_dim);
                for (int j = 0; j < this.m_dim; ++j) {
                    if (this.m_displayOption.getAxesLabel() != null && this.m_displayOption.m_axesLabel.length > j && this.m_displayOption.getAxesLabel()[j] != null) {
                        this.m_displayOption.setRulerName(j, this.m_displayOption.getAxesLabel()[j]);
                    }
                    this.m_displayOption.setRulerMode(j, 0);
                    this.m_displayOption.showRuler(j, true);
                    this.m_displayOption.showRulerNumbers(j, true);
                    this.m_displayOption.showRulerHashingsNormal(j, false);
                    this.m_displayOption.showRulerHashingsUp(j, false);
                    this.m_displayOption.showRulerTicksMajor(j, true);
                    this.m_displayOption.showRulerTicksMinor(j, true);
                }
            }
        }
    }
}

