/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import jv.geom.PgPointSet_IP;
import jv.geom.PgPolygonSet;
import jv.number.PiArray_IP;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PgPolygonSet_IP
extends PgPointSet_IP {
    protected PgPolygonSet m_polygonSet;
    protected TextField m_tNumPolygons;
    protected Label m_tDimPolygons;
    protected PiArray_IP m_polygonPanel;
    protected int m_maxVisibleVectors = 5;
    protected int m_maxVisibleDim = 7;
    private static String[] m_psHeader = new String[]{"0", "1", "2", "3", "4", "5", "6"};
    static /* synthetic */ Class class$jv$geom$PgPolygonSet_IP;

    public PgPolygonSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPolygonSet_IP == null ? (class$jv$geom$PgPolygonSet_IP = PgPolygonSet_IP.class$("jv.geom.PgPolygonSet_IP")) : class$jv$geom$PgPolygonSet_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addLine(1);
        Panel panel = new Panel(new GridLayout(2, 2));
        this.add(panel);
        Label label = new Label(PsConfig.getMessage(24081));
        panel.add(label);
        this.m_tNumPolygons = new TextField("0", 7);
        this.m_tNumPolygons.addActionListener(this);
        panel.add(this.m_tNumPolygons);
        Label label2 = new Label(PsConfig.getMessage(24082));
        panel.add(label2);
        this.m_tDimPolygons = new Label("");
        panel.add(this.m_tDimPolygons);
        this.m_polygonPanel = new PiArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_polygonPanel.setParent(this);
        this.add(this.m_polygonPanel);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_polygonSet = (PgPolygonSet)psUpdateIf;
    }

    public boolean update(Object object) {
        if (this.m_polygonSet == null) {
            PsDebug.warning("missing polygonSet");
            return true;
        }
        if (object == this.m_polygonSet) {
            PsPanel.setText(this.m_tNumPolygons, String.valueOf(this.m_polygonSet.getNumPolygons()));
            int n = this.m_polygonSet.m_dimOfPolygons;
            if (n == -1) {
                PsPanel.setText(this.m_tDimPolygons, PsConfig.getMessage(28001));
            } else {
                PsPanel.setText(this.m_tDimPolygons, String.valueOf(n));
            }
            this.m_polygonPanel.setBounds(0, this.m_polygonSet.getNumVertices() - 1);
            int n2 = Math.min(this.m_polygonSet.getMaxDimOfPolygons(), this.m_maxVisibleDim);
            this.m_polygonPanel.setVector(this.m_polygonSet.getPolygons(), m_psHeader, this.m_polygonSet.getNumPolygons(), n2);
            return super.update(object);
        }
        if (object == this.m_polygonPanel) {
            this.m_polygonSet.update(this);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tNumPolygons) {
            String string = this.m_tNumPolygons.getText();
            if (PuString.isEmpty(string)) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n == this.m_polygonSet.getNumPolygons()) {
                    return;
                }
                if (n < 0) {
                    PsDebug.warning("no negative numbers = " + string, this);
                    return;
                }
                this.m_polygonSet.setNumPolygons(n);
                this.m_polygonSet.update(this.m_polygonSet);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string);
                return;
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

