package vgp.tutor.sizeVertex;

import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel allows to control the dynamic change of vertex thickness.
 * 
 * @author		Konrad Polthier
 * @version		04.11.06, 2.00 revised (kp) Moved to vgp.tutor.<br>
 *					07.02.04, 1.00 created (kp) 
 */
public class PjSizeVertex_IP extends PjProject_IP implements ActionListener { 
	/** Parent project. */
	protected	PjSizeVertex			m_pjSizeVertex;
	/** Reset the project and participating geometries. */
	protected	Button					m_bReset;
	/** Run and stop the animation. */
	protected	Button					m_bRun;
	/** Panel contains all sliders of the project. */
	protected	PsPanel					m_pSlider;
	/** Save background color of button m_bRun as long as minimization is running. */
	private		Color						m_bRunColor;

	public PjSizeVertex_IP() {
		super();
		if (getClass() == PjSizeVertex_IP.class) {
			init();
		}
	}
	public void init() {
		super.init();
		addTitle("");

		m_pSlider = new PsPanel(new GridLayout(2, 1));
		add(m_pSlider);

		// buttons at bottom
		Panel pBottomButtons = new Panel(new FlowLayout(FlowLayout.CENTER));
		add(pBottomButtons);
		m_bRun	= new Button("Run");
		m_bRun.addActionListener(this);
		pBottomButtons.add(m_bRun);
		m_bReset	= new Button("Reset");
		m_bReset.addActionListener(this);
		pBottomButtons.add(m_bReset);
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjSizeVertex = (PjSizeVertex)parent;

		m_pSlider.add(m_pjSizeVertex.m_speed.getInfoPanel());
		m_pSlider.add(m_pjSizeVertex.m_discr.getInfoPanel());
			
		validate();
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (m_pjSizeVertex == event) {
			setTitle(m_pjSizeVertex.getName());
			return true;			
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjSizeVertex==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			m_pjSizeVertex.init();			
			m_pjSizeVertex.start();
			m_pjSizeVertex.update(m_pjSizeVertex);
		} else if (source == m_bRun) {
			if (m_bRun.getLabel().equals("Run")) {
				m_bRunColor = m_bRun.getBackground();
				m_bRun.setBackground(Color.red);
				m_bRun.setLabel("Stop");
				m_pjSizeVertex.startAnim();
			} else {
				if (m_bRunColor != null)
					m_bRun.setBackground(m_bRunColor);
				m_bRun.setLabel("Run");
				m_pjSizeVertex.stopAnim();
			}
		}
	}
}
