package vgp.tutor.rivara;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel for pick demo.
 * 
 * @author		Axel Friedrich
 *	@version		30.09.99, 1.00 created (af)
 */
public class PjRivara_IP extends PjProject_IP implements ActionListener {
	protected	PjRivara				m_pjRefine;
	protected	Button				m_bReset;

	public PjRivara_IP() {
		super();
		if (getClass() == PjRivara_IP.class) {
			init();
		}
	}
	public void init() {
		super.init();
		addTitle("Rivara Refinement");
		
		// buttons at bottom
		Panel pBottomButtons = new Panel(new FlowLayout(FlowLayout.CENTER));
		m_bReset = new Button ("Reset");
		m_bReset.addActionListener(this);
		pBottomButtons.add(m_bReset);
		add(pBottomButtons);
	}
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjRefine = (PjRivara)parent;
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object anObject) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjRivara_IP.update: isShowing = "+isShowing());
		if (anObject == m_project) {
			return true;
		}
		return super.update(anObject);
	}

	public void actionPerformed(ActionEvent event) {
		if (m_pjRefine==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			if (PsDebug.NOTIFY) PsDebug.notify("PjRivara_IP.actionPerformed: reset");
			m_pjRefine.init();
			m_pjRefine.m_torus.update(m_pjRefine.m_torus);
		}
	}
}

