package vgp.tutor.parm;

import java.applet.Applet;
import java.awt.*;

import jv.object.*;
import jv.objectGui.PsSlotLayout;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

/**
 * Applet for Parametrized Surfaces.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		27.08.98, 1.50 revised (kp) PgParmSurface converted from Project to Geometry.<br>
 *					06.10.98, 1.01 revised (kp) Modified according to new vgp structure.<br>
 *					06.10.98, 1.00 created (kp)<br>
 */
public class PaParmSurface extends Applet {
	/** frame if run standalone, null if run as applet. */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet. */
	protected	PvViewer			m_viewer;

	/** Interface of applet to inform about author, version, and copyright. */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Konrad Polthier" + "\r\n" +
				 "Version: "	+ "1.50" + "\r\n" +
				 "Applet displays parametrized surfaces in JavaView" + "\r\n";
	}

	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects must be selected here.
	 */
	public void init() {
		// Create viewer for viewing 3d geometries
		m_viewer = new PvViewer(this, m_frame);

		// Create and load a project
		PjParmSurface prj = new PjParmSurface();
		m_viewer.addProject(prj);
		m_viewer.selectProject(prj);

		// Get 3d display from viewer and add it to applet
		PvDisplayIf disp = m_viewer.getDisplay();

		if ("show".equalsIgnoreCase(m_viewer.getParameter("ProjectPanel"))) {
			setLayout(new PsSlotLayout(9));
			add("5", (Component)disp);
			add("4", m_viewer.getPanel(PsViewerIf.PROJECT));
			// Choose initial panel in control window (must press F1 inside the applet)
			m_viewer.showPanel(PsViewerIf.MATERIAL);
		} else {
			setLayout(new BorderLayout());
			add((Component)disp, BorderLayout.CENTER);
		}
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaParmSurface va	= new PaParmSurface();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		frame.setBounds(new Rectangle(420, 5, 640, 550));
		va.m_frame = frame;
		va.init();
		va.start();
		frame.setVisible(true);
	}

	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString(PsConfig.getProgramAndVersion(), 20, 40);
		g.drawString("Loading Projects .....", 20, 60);
	}

	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()	{ m_viewer.destroy(); }

	/** Start viewer, e.g. start animation if requested */
	public void start()		{ m_viewer.start(); }

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()		{ m_viewer.stop(); }
}
