package vgp.tutor.height;

import java.applet.Applet;
import java.awt.*;

import jv.object.*;
import jv.viewer.PvViewer;

/**
 * Applet demonstrates the display of a scalar field on a surface.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		30.01.99, 1.00 revised (kp)<br>
 *					30.01.99, 1.00 created (kp)
 */
public class PaHeight extends Applet implements Runnable {
	/** frame if run standalone, null if run as applet */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet */
	protected	PvViewer			m_viewer;

	/** Default scalar field used if no html parameter or application argument found. */
	private static String		m_defaultScalar	= "z-Height";

	/** Message string drawn in applet while loading. Modify string with drawMessage(). */
	private		String			m_drawString	= "Initializing ...";

	/** Applet parameters: {"Name", "Typ", "Default value", "Description"} */
	protected	String [][]	m_parm = {
		{"Scalar",	"String", m_defaultScalar,	"Name of Scalar Function"},
		{"Console",	"String", "Hide",		"Show/Hide VGP-console for debugging"},
		{"Control",	"String", "Hide",		"Show/Hide control panel"},
		{"Frame",	"String", "Hide",		"Show/Hide frame around applet"},
		{"Panel",	"String", "Project",	"Name of initial panel if control panel is showing"}
	};
	/**
	 * Interface used by design tools to show properties of applet.
	 * This method returns a list of string arrays, each of length 4 rather than 3
	 * as suggest by Java. The additional string at third position contains
	 * the value of the parameter.
	 * @see			jv.viewer.PvViewer#getParameter(String)
	 */
	public String[][] getParameterInfo() { return m_parm; }

	/** Interface of applet to inform about author, version, and copyright */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Konrad Polthier" + "\r\n" +
				 "Version: "	+ "1.00" + "\r\n" +
				 "Applet shows visualization of scalar height fields" + "\r\n";
	}

	/**
	 * Create thread that configures and initializes the viewer, loads system and user projects.
	 */
	public void init() {
		Thread thread = new Thread(this, "JavaView: inititialize applet");
		thread.setPriority(Thread.NORM_PRIORITY);
		thread.start();
	}
	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects may be selected here.
	 */
	public void run() {
		drawMessage("Loading viewer ...");
		m_viewer = new PvViewer(this, m_frame);			// at first initalize the viewer

		drawMessage("Loading geometry ...");
		// Get parameter values from HTML page, or take default value
		String scalar = m_viewer.getParameter("Scalar");
		if (scalar == null)
			scalar = m_defaultScalar;

		// Create and load a project
		// PjHeight prj = new PjHeight(PsConfig.getCodeBase()+scalar);
		PjHeight prj = new PjHeight();
		prj.setScalarName(scalar);
		m_viewer.addProject(prj);
		m_viewer.selectProject(prj);

		// Get 3d display from viewer and add it to applet
		setLayout(new BorderLayout());
		add(m_viewer.getDisplay().getCanvas(), BorderLayout.CENTER);
		add(m_viewer.getPanel(PsViewerIf.PROJECT), BorderLayout.SOUTH);
		validate();

		// Choose initial panel in control window (must press F1 inside the applet)
		m_viewer.showPanel(PsViewerIf.MATERIAL);

		// Explicitly start the applet
		startFromThread();
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaHeight va	= new PaHeight();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		va.m_frame = frame;
		va.init();
		frame.setBounds(new Rectangle(420, 5, 640, 550));
		frame.setVisible(true);
	}

	/** Set message string to be drawn in apllet while loading. */
	private void drawMessage(String message) {
		m_drawString = message;
		repaint();
	}
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString(PsConfig.getProgramAndVersion(), 20, 40);
		g.drawString(m_drawString, 20, 60);
	}
	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()	{ if (m_viewer != null) m_viewer.destroy(); }

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()		{ if (m_viewer != null) m_viewer.stop(); }
	/**
	 * Start viewer, e.g. start animation if requested.
	 * Necessary, if initialization is done in a separate thread. In this case the original
	 * applet.start() has no effect.
	 */
	public void startFromThread()	{ if (m_viewer!=null) m_viewer.start(); }
}
