/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.PsScanline;
import jv.project.PgGeometry;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.project.PjWorkshop;

public class PwRotDiv
extends PjWorkshop {
    protected PgElementSet m_elemset = null;
    protected PuInteger m_vecindex = new PuInteger(PsConfig.getMessage((int)54312), (PsUpdateIf)this);
    protected PdColor m_neg;
    protected PdColor m_zer;
    protected PdColor m_pos;
    protected PuDouble m_middle;
    protected PuDouble m_extension;
    protected PdVector[] m_scalarField;
    protected int m_fieldType;
    protected boolean m_bUseExistentTexture = false;
    public static final int VERTEX_ROTATION = 0;
    public static final int VERTEX_ROTATION_AREA = 1;
    public static final int EDGE_ROTATION = 2;
    public static final int EDGE_ROTATION_AREA = 3;
    public static final int VERTEX_DIVERGENCE = 4;
    public static final int VERTEX_DIVERGENCE_AREA = 5;
    public static final int EDGE_DIVERGENCE = 6;
    public static final int EDGE_DIVERGENCE_AREA = 7;
    public static final int VERTEX_ROTATION_NOGAUSS = 8;
    public static final int VERTEX_DIVERGENCE_NOGAUSS = 9;
    static /* synthetic */ Class class$jvx$vector$PwRotDiv;

    public PwRotDiv() {
        super(PsConfig.getMessage((int)48022));
        this.m_vecindex.setDefBounds(0, 0, 0, 0);
        this.m_vecindex.setDefValue(0);
        this.m_vecindex.init();
        this.m_neg = new PdColor(PsConfig.getMessage((int)54313), null);
        this.m_neg.setColor(Color.red);
        this.m_zer = new PdColor(PsConfig.getMessage((int)54314), null);
        this.m_zer.setColor(Color.white);
        this.m_pos = new PdColor(PsConfig.getMessage((int)54315), null);
        this.m_pos.setColor(Color.green);
        this.m_middle = new PuDouble(PsConfig.getMessage((int)54316), null);
        this.m_middle.setDefBounds(-10.0, 10.0, 0.1, 0.5);
        this.m_middle.setDefValue(0.0);
        this.m_extension = new PuDouble(PsConfig.getMessage((int)54317), null);
        this.m_extension.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_extension.setDefValue(3.0);
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwRotDiv == null ? (class$jvx$vector$PwRotDiv = PwRotDiv.class$("jvx.vector.PwRotDiv")) : class$jvx$vector$PwRotDiv)) {
            this.init();
        }
    }

    public void init() {
        this.m_middle.init();
        this.m_extension.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        int n;
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"argument 'geom' is no element set");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        int n2 = pgElementSet.getNumVectorFields();
        if (n2 <= 0) {
            PsDebug.warning((String)"argument 'geom' has no vector field");
            return;
        }
        for (n = 0; n < n2 && pgElementSet.getVectorField(n).getBasedOn() != 1; ++n) {
        }
        if (n >= n2) {
            PsDebug.warning((String)"argument 'geom' has no element based vector field");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_elemset = pgElementSet;
        if (this.m_elemset.hasElementTextures()) {
            this.m_bUseExistentTexture = true;
        }
        this.updateFromElementSet();
        this.m_vecindex.setDefValue(n + 1);
        this.m_vecindex.setValue(n + 1);
        this.setFieldType(0);
    }

    protected void updateFromElementSet() {
        this.m_vecindex.setDefBounds(1, this.m_elemset.getNumVectorFields(), 1, 2);
        this.m_vecindex.setDefValue(1);
        this.m_vecindex.init();
    }

    public void setFieldType(int n) {
        switch (n) {
            case 0: {
                PdVector pdVector = PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            case 1: {
                PdVector pdVector = PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            case 2: {
                this.m_scalarField = PwRotDiv.getEdgeRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                break;
            }
            case 3: {
                this.m_scalarField = PwRotDiv.getEdgeRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                break;
            }
            case 4: {
                PdVector pdVector = PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            case 6: {
                this.m_scalarField = PwRotDiv.getEdgeDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                break;
            }
            case 5: {
                PdVector pdVector = PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            case 7: {
                this.m_scalarField = PwRotDiv.getEdgeDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                break;
            }
            case 8: {
                PdVector pdVector = PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, false, true);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            case 9: {
                PdVector pdVector = PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, false, true);
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, pdVector);
                break;
            }
            default: {
                PsDebug.warning((String)("wrong 'fieldType'=" + n + ", use constants from PwRotDiv."));
                return;
            }
        }
        this.m_fieldType = n;
        this.update((Object)this);
    }

    public int getFieldType() {
        return this.m_fieldType;
    }

    public double getMaximumValue() {
        if (this.m_scalarField == null) {
            return 0.0;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_scalarField.length; ++i) {
            double d2 = this.m_scalarField[i].max();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinimumValue() {
        if (this.m_scalarField == null) {
            return 0.0;
        }
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_scalarField.length; ++i) {
            double d2 = this.m_scalarField[i].min();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public void makeTexture() {
        if (this.m_scalarField == null) {
            return;
        }
        switch (this.m_fieldType) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.m_bUseExistentTexture) {
                    PwRotDiv.colorTextureFromScalarField(this.m_elemset, this.m_neg.getColor(), this.m_zer.getColor(), this.m_pos.getColor(), this.m_middle.getValue(), this.m_extension.getValue(), this.m_scalarField);
                    break;
                }
                PwRotDiv.makeTextureFromScalarField(this.m_elemset, this.m_neg.getColor(), this.m_zer.getColor(), this.m_pos.getColor(), this.m_middle.getValue(), this.m_extension.getValue(), this.m_scalarField);
                break;
            }
            default: {
                PsDebug.warning((String)("wrong 'fieldType'=" + this.m_fieldType + ", use constants from PwRotDiv."));
            }
        }
    }

    public void setColorExistentTexture(boolean bl) {
        this.m_bUseExistentTexture = bl;
    }

    public boolean getColorExistentTexture() {
        return this.m_bUseExistentTexture;
    }

    protected void makeEverythingVisible() {
        this.m_elemset.showElements(true);
        this.m_elemset.showElementTexture(true);
        this.m_elemset.update(null);
    }

    protected static void makeVertexColorFromRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3) {
        PdVector pdVector = PwRotDiv.getVertexRotation(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        double d = Math.abs(pdVector.max());
        double d2 = Math.abs(pdVector.min());
        if (d2 > d) {
            d = d2;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color3.getRed();
        int n9 = color3.getGreen();
        int n10 = color3.getBlue();
        pgElementSet.showVertexColors(true);
        int n11 = pdVector.getSize();
        for (int i = 0; i < n11; ++i) {
            double d3 = pdVector.getEntry(i);
            double d4 = Math.abs(d3) / d;
            double d5 = 1.0 - d4;
            if (d3 < 0.0) {
                pgElementSet.setVertexColor(i, new Color((int)((double)n2 * d4 + (double)n5 * d5), (int)((double)n3 * d4 + (double)n6 * d5), (int)((double)n4 * d4 + (double)n7 * d5)));
                continue;
            }
            pgElementSet.setVertexColor(i, new Color((int)((double)n8 * d4 + (double)n5 * d5), (int)((double)n9 * d4 + (double)n6 * d5), (int)((double)n10 * d4 + (double)n7 * d5)));
        }
    }

    protected static void makeTextureFromVertexRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector pdVector = PwRotDiv.getVertexRotation(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.scalarFromVertexToElementBased(pgElementSet, pdVector);
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    private static PdVector[] scalarFromVertexToElementBased(PgElementSet pgElementSet, PdVector pdVector) {
        if (pdVector == null) {
            return null;
        }
        int n = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = new PdVector[n];
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i] = new PdVector(3);
            for (int j = 0; j < 3; ++j) {
                pdVectorArray[i].setEntry(j, pdVector.getEntry(piVectorArray[i].getEntry(j)));
            }
        }
        return pdVectorArray;
    }

    protected static void makeTextureFromEdgeRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.getEdgeRotation(pgElementSet, n, null);
        if (pdVectorArray == null) {
            return;
        }
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    protected static void makeTextureFromVertexDivergence(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector pdVector = PwRotDiv.getVertexDivergence(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.scalarFromVertexToElementBased(pgElementSet, pdVector);
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    private static void makeTextureFromScalarField(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d, double d2, PdVector[] pdVectorArray) {
        int n;
        int n2 = pgElementSet.getNumElements();
        PgTexture pgTexture = new PgTexture();
        int[] nArray = new int[1022];
        double d3 = color.getRed();
        double d4 = color.getGreen();
        double d5 = color.getBlue();
        double d6 = ((double)color2.getRed() - d3) / 255.0;
        double d7 = ((double)color2.getGreen() - d4) / 255.0;
        double d8 = ((double)color2.getBlue() - d5) / 255.0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            nArray[n3] = -16777216 + ((int)d3 << 16) + ((int)d4 << 8) + (int)d5;
            nArray[++n3] = nArray[n3 - 1];
            ++n3;
            d3 += d6;
            d4 += d7;
            d5 += d8;
        }
        d6 = ((double)color3.getRed() - d3) / 255.0;
        d7 = ((double)color3.getGreen() - d4) / 255.0;
        d8 = ((double)color3.getBlue() - d5) / 255.0;
        for (n = 1; n < 256; ++n) {
            nArray[n3] = -16777216 + ((int)(d3 += d6) << 16) + ((int)(d4 += d7) << 8) + (int)(d5 += d8);
            nArray[++n3] = nArray[n3 - 1];
            ++n3;
        }
        pgTexture.setImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(2, 511, nArray, 0, 2)));
        PdVector[][] pdVectorArray2 = new PdVector[n2][3];
        for (int i = 0; i < n2; ++i) {
            double d9 = 0.0;
            for (n3 = 0; n3 < 3; ++n3) {
                double d10 = 1.0 - ((pdVectorArray[i].getEntry(n3) - d) * 0.5 / d2 + 0.5);
                pdVectorArray2[i][n3] = new PdVector(d9, Math.max(0.0, Math.min(1.0, d10)));
                d9 += 0.5;
            }
        }
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        pgElementSet.setElementTextures(pdVectorArray2);
        pgElementSet.setTexture(pgTexture);
    }

    public static void colorTextureFromScalarField(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d, double d2, PdVector[] pdVectorArray) {
        String string = "Could not fetch texture image";
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            PsDebug.warning((String)string);
            return;
        }
        Image image = pgTexture.getImage();
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            PsDebug.warning((String)(string + ": " + interruptedException));
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            PsDebug.warning((String)(string + ": " + interruptedException));
            return;
        }
        float[][] fArray = new float[3][3];
        int n3 = pgElementSet.getNumElements();
        PsScanline psScanline = new PsScanline();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 3; ++n5) {
                double d3 = pdVectorArray[i].getEntry(n5);
                double d4 = Math.min(Math.abs(d3 - d) / d2, 1.0);
                double d5 = 1.0 - d4;
                if (d > d3) {
                    fArray[n5][0] = (float)Math.min((d4 * (double)color.getRed() + d5 * (double)color2.getRed()) / 255.0, 1.0);
                    fArray[n5][1] = (float)Math.min((d4 * (double)color.getGreen() + d5 * (double)color2.getGreen()) / 255.0, 1.0);
                    fArray[n5][2] = (float)Math.min((d4 * (double)color.getBlue() + d5 * (double)color2.getBlue()) / 255.0, 1.0);
                    continue;
                }
                fArray[n5][0] = (float)Math.min((d4 * (double)color3.getRed() + d5 * (double)color2.getRed()) / 255.0, 1.0);
                fArray[n5][1] = (float)Math.min((d4 * (double)color3.getGreen() + d5 * (double)color2.getGreen()) / 255.0, 1.0);
                fArray[n5][2] = (float)Math.min((d4 * (double)color3.getBlue() + d5 * (double)color2.getBlue()) / 255.0, 1.0);
            }
            PdVector[] pdVectorArray2 = pgElementSet.getElementTexture(i);
            psScanline.makeScanlines((int)(pdVectorArray2[0].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[0].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray2[1].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[1].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray2[2].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[2].m_data[1]) * (double)(n2 - 1)));
            int n6 = psScanline.m_ymin;
            for (n5 = 0; n5 < psScanline.m_length; ++n5) {
                int n7;
                int n8 = n6 * n + psScanline.m_xa[n5];
                for (n7 = 0; n7 < 3; ++n7) {
                    dArray[n7] = psScanline.m_aAnteile[n7][n5];
                    dArray2[n7] = (double)psScanline.m_eAnteile[n7][n5] - dArray[n7];
                    if (psScanline.m_xe[n5] <= psScanline.m_xa[n5]) continue;
                    int n9 = n7;
                    dArray2[n9] = dArray2[n9] / (double)(psScanline.m_xe[n5] - psScanline.m_xa[n5]);
                }
                for (n4 = psScanline.m_xa[n5]; n4 <= psScanline.m_xe[n5]; ++n4) {
                    double d6 = Math.max(Math.max((nArray[n8] & 0xFF0000) >> 16, (nArray[n8] & 0xFF00) >> 8), nArray[n8] & 0xFF);
                    double d7 = Math.min(((double)fArray[0][0] * dArray[0] + (double)fArray[1][0] * dArray[1] + (double)fArray[2][0] * dArray[2]) * 255.0, 255.0);
                    double d8 = Math.min(((double)fArray[0][1] * dArray[0] + (double)fArray[1][1] * dArray[1] + (double)fArray[2][1] * dArray[2]) * 255.0, 255.0);
                    double d9 = Math.min(((double)fArray[0][2] * dArray[0] + (double)fArray[1][2] * dArray[1] + (double)fArray[2][2] * dArray[2]) * 255.0, 255.0);
                    nArray[n8] = (nArray[n8] & 0xFF000000) + ((int)((d6 /= Math.max(d7, Math.max(d8, d9))) * d7) << 16) + ((int)(d6 * d8) << 8) + (int)(d6 * d9);
                    ++n8;
                    for (n7 = 0; n7 < 3; ++n7) {
                        int n10 = n7;
                        dArray[n10] = dArray[n10] + dArray2[n7];
                    }
                }
                n8 = n6 * n;
                for (n7 = 1; n7 <= 2; ++n7) {
                    if (psScanline.m_xa[n5] - n7 >= 0) {
                        nArray[n8 + psScanline.m_xa[n5] - n7] = nArray[n8 + psScanline.m_xa[n5]];
                    }
                    if (psScanline.m_xe[n5] + n7 >= n) continue;
                    nArray[n8 + psScanline.m_xe[n5] + n7] = nArray[n8 + psScanline.m_xe[n5]];
                }
                ++n6;
            }
            if (psScanline.m_length < 1) continue;
            n6 = psScanline.m_ymin + psScanline.m_length;
            if (n6 < n2) {
                for (n4 = psScanline.m_xa[psScanline.m_length - 1] - 2; n4 <= psScanline.m_xe[psScanline.m_length - 1] + 2; ++n4) {
                    if (n4 < 0 || n4 >= n) continue;
                    nArray[n6 * n + n4] = nArray[(n6 - 1) * n + n4];
                }
            }
            if ((n6 = psScanline.m_ymin - 1) < 0) continue;
            for (n4 = psScanline.m_xa[psScanline.m_length - 1] - 2; n4 <= psScanline.m_xe[psScanline.m_length - 1] + 2; ++n4) {
                if (n4 < 0 || n4 >= n) continue;
                nArray[n6 * n + n4] = nArray[(n6 + 1) * n + n4];
            }
        }
        pgTexture.setImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
        pgElementSet.setTexture(pgTexture);
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PiVector piVector, PdVector pdVector) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        if (piVector == null) {
            PsDebug.warning((String)"missing vertex indices");
            return null;
        }
        int n2 = piVector.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfVertices());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            double d = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, piVector.getEntry(i), -1);
            PiVector piVector2 = pgVertexStar.getElement();
            PiVector piVector3 = pgVertexStar.getVertexLocInd();
            int n5 = piVector2.getSize();
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = piVector3.getEntry(n4);
                int n6 = piVector2.getEntry(n4);
                pdVector2.sub(pdVectorArray[piVectorArray[n6].getEntry((n3 + 2) % 3)], pdVectorArray[piVectorArray[n6].getEntry((n3 + 1) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n6));
            }
            if (!pgVertexStar.isClosed()) {
                n4 = piVector3.getEntry(0);
                n3 = piVector2.getEntry(0);
                pdVector2.sub(pdVectorArray[piVectorArray[n3].getEntry((n4 + 1) % 3)], pdVectorArray[piVector.getEntry(i)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n3));
                n4 = piVector3.getLastEntry();
                n3 = piVector2.getLastEntry();
                pdVector2.sub(pdVectorArray[piVector.getEntry(i)], pdVectorArray[piVectorArray[n3].getEntry((n4 + 2) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n3));
            }
            pdVector.setEntry(i, d);
        }
        return pdVector;
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PdVector pdVector) {
        return PwRotDiv.getVertexRotation(pgElementSet, n, pdVector, false, false);
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PdVector pdVector, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfVertices());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            double d = 0.0;
            double d2 = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, i, -1);
            PiVector piVector = pgVertexStar.getElement();
            PiVector piVector2 = pgVertexStar.getVertexLocInd();
            int n5 = piVector.getSize();
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = piVector2.getEntry(n4);
                int n6 = piVector.getEntry(n4);
                if (bl) {
                    d2 += pgElementSet.getAreaOfElement(n6);
                }
                pdVector2.sub(pdVectorArray[piVectorArray[n6].getEntry((n3 + 2) % 3)], pdVectorArray[piVectorArray[n6].getEntry((n3 + 1) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n6));
            }
            if (!pgVertexStar.isClosed() && !bl2) {
                n4 = piVector2.getEntry(0);
                n3 = piVector.getEntry(0);
                pdVector2.sub(pdVectorArray[piVectorArray[n3].getEntry((n4 + 1) % 3)], pdVectorArray[i]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n3));
                n4 = piVector2.getLastEntry();
                n3 = piVector.getLastEntry();
                pdVector2.sub(pdVectorArray[i], pdVectorArray[piVectorArray[n3].getEntry((n4 + 2) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n3));
            }
            if (bl) {
                pdVector.setEntry(i, d / d2);
                continue;
            }
            pdVector.setEntry(i, d);
        }
        return pdVector;
    }

    public static PdVector[] getEdgeRotation(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray) {
        return PwRotDiv.getEdgeRotation(pgElementSet, n, pdVectorArray, false, false);
    }

    public static PdVector[] getEdgeRotation(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray, boolean bl, boolean bl2) {
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n3 = pgElementSet.getNumElements();
        if (pdVectorArray == null || pdVectorArray.length != n3) {
            pdVectorArray = new PdVector[n3];
        }
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        for (n2 = 0; n2 < pgEdgeStarArray.length; ++n2) {
            int n4;
            int n5 = pgEdgeStarArray[n2].getValence();
            double d = 0.0;
            double d2 = 0.0;
            if (n5 != 1 || bl2) {
                for (n4 = 0; n4 < 2 && n4 < n5; ++n4) {
                    nArray[n4] = pgEdgeStarArray[n2].getElementInd(n4);
                    nArray2[n4] = pgEdgeStarArray[n2].getNeighbourLocInd(n4);
                    if (bl) {
                        d2 += pgElementSet.getAreaOfElement(nArray[n4]);
                    }
                    pdVector.sub(pdVectorArray2[piVectorArray[nArray[n4]].getEntry((nArray2[n4] + 2) % 3)], pdVectorArray2[piVectorArray[nArray[n4]].getEntry((nArray2[n4] + 1) % 3)]);
                    d -= PdVector.dot((PdVector)pdVector, (PdVector)pgVectorField.getVector(nArray[n4]));
                }
            }
            for (n4 = 0; n4 < 2 && n4 < n5; ++n4) {
                if (pdVectorArray[nArray[n4]] == null) {
                    pdVectorArray[nArray[n4]] = new PdVector(3);
                }
                if (bl) {
                    pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d / d2);
                    continue;
                }
                pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = pdVectorArray[n2].getEntry(0);
            double d3 = pdVectorArray[n2].getEntry(1);
            double d4 = pdVectorArray[n2].getEntry(2);
            pdVectorArray[n2].setEntry(0, d3 + d4 - d);
            pdVectorArray[n2].setEntry(1, d + d4 - d3);
            pdVectorArray[n2].setEntry(2, d + d3 - d4);
        }
        return pdVectorArray;
    }

    public static PdVector getVertexDivergence(PgElementSet pgElementSet, int n, PdVector pdVector) {
        return PwRotDiv.getVertexDivergence(pgElementSet, n, pdVector, false, false);
    }

    public static PdVector getVertexDivergence(PgElementSet pgElementSet, int n, PdVector pdVector, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        int n3 = pgElementSet.getDimOfVertices();
        PdVector pdVector2 = new PdVector(n3);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        boolean bl3 = true;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            double d = 0.0;
            double d2 = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, i, -1);
            PiVector piVector = pgVertexStar.getElement();
            PiVector piVector2 = pgVertexStar.getVertexLocInd();
            int n6 = piVector.getSize();
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = piVector2.getEntry(n5);
                int n7 = piVector.getEntry(n5);
                pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[n4]);
                PwBary.rotateInElement(pgElementSet, n7, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                bl3 = false;
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n7].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n7].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n7].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n7));
                d2 += pgElementSet.getAreaOfElement(n7);
            }
            if (!pgVertexStar.isClosed() && !bl2) {
                n5 = piVector2.getEntry(0);
                n4 = piVector.getEntry(0);
                pdBaryDir.m_data[n5] = -1.0;
                pdBaryDir.m_data[(n5 + 2) % 3] = 0.0;
                pdBaryDir.m_data[(n5 + 1) % 3] = 1.0;
                PwBary.rotateInElement(pgElementSet, n4, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n4].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n4].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n4].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
                n5 = piVector2.getLastEntry();
                n4 = piVector.getLastEntry();
                pdBaryDir.m_data[n5] = 1.0;
                pdBaryDir.m_data[(n5 + 2) % 3] = -1.0;
                pdBaryDir.m_data[(n5 + 1) % 3] = 0.0;
                PwBary.rotateInElement(pgElementSet, n4, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n4].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n4].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n4].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
            }
            if (bl) {
                pdVector.setEntry(i, d / d2);
                continue;
            }
            pdVector.setEntry(i, d);
        }
        return pdVector;
    }

    public static PdVector[] getEdgeDivergence(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray) {
        return PwRotDiv.getEdgeDivergence(pgElementSet, n, pdVectorArray, false, false);
    }

    public static PdVector[] getEdgeDivergence(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray, boolean bl, boolean bl2) {
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n3 = pgElementSet.getNumElements();
        if (pdVectorArray == null || pdVectorArray.length != n3) {
            pdVectorArray = new PdVector[n3];
        }
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        PdBaryDir pdBaryDir = null;
        boolean bl3 = true;
        for (n2 = 0; n2 < pgEdgeStarArray.length; ++n2) {
            int n4;
            int n5 = pgEdgeStarArray[n2].getValence();
            double d = 0.0;
            double d2 = 0.0;
            for (n4 = 0; n4 < 2 && n4 < n5; ++n4) {
                nArray[n4] = pgEdgeStarArray[n2].getElementInd(n4);
                nArray2[n4] = pgEdgeStarArray[n2].getNeighbourLocInd(n4);
                if (bl) {
                    d2 += pgElementSet.getAreaOfElement(nArray[n4]);
                }
                if (n5 <= 1 && !bl2) continue;
                if (pdBaryDir == null) {
                    pdBaryDir = new PdBaryDir(3);
                }
                pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[nArray2[n4]]);
                PwBary.rotateInElement(pgElementSet, nArray[n4], pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                bl3 = false;
                PdBaryDir.getVector((PdVector)pdVector, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray2[piVectorArray[nArray[n4]].getEntry(0)], (PdVector)pdVectorArray2[piVectorArray[nArray[n4]].getEntry(1)], (PdVector)pdVectorArray2[piVectorArray[nArray[n4]].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector, (PdVector)pgVectorField.getVector(nArray[n4]));
            }
            for (n4 = 0; n4 < 2 && n4 < n5; ++n4) {
                if (pdVectorArray[nArray[n4]] == null) {
                    pdVectorArray[nArray[n4]] = new PdVector(3);
                }
                if (bl) {
                    pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d / d2);
                    continue;
                }
                pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = pdVectorArray[n2].getEntry(0);
            double d3 = pdVectorArray[n2].getEntry(1);
            double d4 = pdVectorArray[n2].getEntry(2);
            pdVectorArray[n2].setEntry(0, d3 + d4 - d);
            pdVectorArray[n2].setEntry(1, d + d4 - d3);
            pdVectorArray[n2].setEntry(2, d + d3 - d4);
        }
        return pdVectorArray;
    }

    protected static PgPointSet createPointSetFromZMaxMinCrit(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d) {
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        int n = pgElementSet.getDimOfVertices() - 1;
        PgPointSet pgPointSet = new PgPointSet(pgElementSet.getDimOfVertices());
        pgPointSet.setModelMatrix(pgElementSet.getModelMatrix());
        pgPointSet.assureVertexColors();
        pgPointSet.showVertexColors(true);
        pgPointSet.setName(PsConfig.getMessage((int)45058) + pgElementSet.getName());
        int n2 = pgElementSet.getNumVertices();
        pgElementSet.assureVertexColors();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = 0;
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (i == 97) {
                System.err.println("");
            }
            pgVertexStar.makeVertexStar(pgElementSet, i, -1);
            PiVector piVector = pgVertexStar.getLink();
            if (!pgVertexStar.isClosed()) continue;
            double d2 = pdVectorArray[i].getEntry(n);
            double d3 = d2 - d;
            double d4 = d2 + d;
            int n5 = piVector.getSize();
            boolean bl = true;
            boolean bl2 = true;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                double d5 = pdVectorArray[piVector.getEntry(n4)].getEntry(n);
                if (d5 > d3) {
                    bl2 = false;
                }
                if (d5 < d4) {
                    bl = false;
                }
                if (d5 > d4 && n7 < 0) {
                    ++n6;
                    n7 = 1;
                    continue;
                }
                if (d5 < d3 && n7 > 0) {
                    ++n6;
                    n7 = -1;
                    continue;
                }
                if (n7 != 0) continue;
                if (d5 > d4) {
                    n7 = 1;
                } else if (d5 < d3) {
                    n7 = -1;
                }
                n8 = n7;
            }
            n4 = 3;
            if (n8 != n7) {
                ++n6;
            }
            if (bl2 || bl || n6 >= n4) {
                pdVector.copy(pdVectorArray[i]);
                if (bl2) {
                    pdVector.setName(" +");
                } else if (bl) {
                    pdVector.setName(" -");
                } else {
                    pdVector.setName(" " + n6);
                }
                pgPointSet.addVertex(pdVector);
                ++n3;
            }
            if (bl2) {
                pgPointSet.setVertexColor(n3 - 1, color3);
                continue;
            }
            if (bl) {
                pgPointSet.setVertexColor(n3 - 1, color);
                continue;
            }
            if (n6 < n4) continue;
            pgPointSet.setVertexColor(n3 - 1, color2);
            pgPointSet.setVertex(n3 - 1, pdVector);
        }
        return pgPointSet;
    }

    public boolean update(Object object) {
        if (object == this.m_vecindex) {
            this.setFieldType(this.getFieldType());
            return super.update(null);
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

