/*
 * Decompiled with CFR 0.152.
 */
package jvx.project;

import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PjWorkshopIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsJavaView;

public abstract class PjWorkshop
extends PsObject
implements PjWorkshopIf {
    protected int m_mode;
    protected boolean m_bModal;
    protected boolean m_bUpdateSender;
    protected boolean m_bStandalone;
    protected PgGeometry m_geom;
    protected PgGeometry m_geomSave;
    protected PvDisplayIf m_display;
    protected Vector m_displayList;
    protected PvViewerIf m_viewer;

    public PjWorkshop(String string) {
        this.setTag(4);
        this.setName(string);
        this.m_bUpdateSender = false;
        this.m_bStandalone = true;
        this.m_mode = 0;
        this.m_bModal = true;
    }

    public void init() {
        super.init();
    }

    public boolean update(Object object) {
        if ((object == this || object == null) && this.m_geom != null && this.isStandalone()) {
            if (this.isUpdateSender()) {
                return true;
            }
            this.setUpdateSender(true);
            this.m_geom.update((Object)this.m_geom);
            this.setUpdateSender(false);
        }
        return super.update(object);
    }

    public PgGeometry getSavedGeometry() {
        return this.m_geomSave;
    }

    public PgGeometry getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (pgGeometry == null) {
            PsDebug.warning((String)"missing geometry");
            return;
        }
        this.m_geom = pgGeometry;
        if (PsJavaView.isEnabledWorkshopBackup()) {
            this.m_geomSave = (PgGeometry)this.m_geom.clone();
        }
    }

    public void removeGeometry() {
        if (this.m_geom == null) {
            return;
        }
        this.m_geomSave = null;
        this.m_geom = null;
    }

    public PvViewerIf getViewer() {
        return this.m_viewer;
    }

    public void setViewer(PvViewerIf pvViewerIf) {
        this.m_viewer = pvViewerIf;
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
    }

    public Vector getDisplays() {
        return this.m_displayList;
    }

    public void setDisplays(Vector vector) {
        this.m_displayList = vector;
    }

    protected boolean isUpdateSender() {
        return this.m_bUpdateSender;
    }

    protected void setUpdateSender(boolean bl) {
        this.m_bUpdateSender = bl;
    }

    public boolean isStandalone() {
        return this.m_bStandalone;
    }

    public void setStandalone(boolean bl) {
        this.m_bStandalone = bl;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public boolean isModal() {
        return this.m_bModal;
    }

    public void setModal(boolean bl) {
        this.m_bModal = bl;
    }

    public void reset() {
        this.init();
    }

    public void ok() {
        this.close();
    }

    public void close() {
        this.removeGeometry();
    }

    public void cancel() {
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.m_geom.update((Object)this.m_geom);
        }
        this.close();
    }
}

