/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdMatrixIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PnSparseMatrix
extends PsObject
implements PdMatrixIf {
    public static final boolean USE_LARGER_BUFFER = true;
    protected int m_iSize;
    protected int m_jSize;
    protected PiVector m_snoe;
    protected PiVector[] m_sindx;
    protected PdVector[] m_stiff;

    public PnSparseMatrix() {
        this.setSize(0);
    }

    public PnSparseMatrix(int n, int n2) {
        this.setSize(n, n2);
    }

    public PnSparseMatrix(int n, int n2, int n3) {
        this.setSize(n, n2, n3);
    }

    public PnSparseMatrix(PdMatrix pdMatrix) {
        this();
        if (pdMatrix == null) {
            PsDebug.warning((String)"Dense matrix is null.");
            return;
        }
        int n = pdMatrix.getJSize();
        this.setSize(pdMatrix.getISize(), n);
        this.m_snoe.setConstant(0);
        int[] nArray = new int[pdMatrix.getJSize()];
        double[] dArray = new double[pdMatrix.getJSize()];
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(Math.abs(pdMatrix.getEntry(i, j)) > 1.0E-10)) continue;
                nArray[this.m_snoe.m_data[i]] = j;
                dArray[this.m_snoe.m_data[i]] = pdMatrix.getEntry(i, j);
                int n2 = i;
                this.m_snoe.m_data[n2] = this.m_snoe.m_data[n2] + 1;
            }
            this.m_sindx[i] = new PiVector(this.m_snoe.m_data[i]);
            this.m_stiff[i] = new PdVector(this.m_snoe.m_data[i]);
            System.arraycopy(nArray, 0, this.m_sindx[i].m_data, 0, this.m_snoe.m_data[i]);
            System.arraycopy(dArray, 0, this.m_stiff[i].m_data, 0, this.m_snoe.m_data[i]);
        }
    }

    public int getNumRows() {
        return this.m_iSize;
    }

    public int getNumCols() {
        return this.m_jSize == -1 ? this.m_iSize : this.m_jSize;
    }

    public void setSize(int n, int n2) {
        this.setSize(n, n2, 0);
    }

    public void setSize(int n, int n2, int n3) {
        this.m_iSize = n;
        this.m_jSize = n2;
        if (this.m_snoe == null) {
            this.m_snoe = new PiVector(this.m_iSize);
        } else {
            this.m_snoe.setSize(this.m_iSize);
        }
        this.m_sindx = PiVector.realloc((PiVector[])this.m_sindx, (int)this.m_iSize);
        this.m_stiff = PdVector.realloc((PdVector[])this.m_stiff, (int)this.m_iSize);
        if (n3 > 0) {
            for (int i = 0; i < n; ++i) {
                this.assureBufferSize(i, n3);
            }
        }
    }

    public void setSize(int n) {
        this.setSize(n, n);
    }

    public void setNumEntries(int n, int n2) {
        this.m_snoe.m_data[n] = n2;
        this.assureBufferSize(n, n2);
    }

    private void assureBufferSize(int n, int n2) {
        if (n2 > this.m_sindx[n].getSize()) {
            int n3 = n2;
            n3 = Math.max(n2, (int)((double)this.m_sindx[n].getSize() * 1.3) + 1);
            this.m_sindx[n].setSize(n3);
            this.m_stiff[n].setSize(n3);
        }
    }

    public PdVector[] getEntries() {
        return this.m_stiff;
    }

    public PdVector getEntries(int n) {
        return this.m_stiff[n];
    }

    public double getEntrySparse(int n, int n2) {
        return this.m_stiff[n].m_data[n2];
    }

    public double getEntry(int n, int n2) {
        if (n >= this.m_iSize || n2 >= this.m_jSize || n < 0 || n2 < 0) {
            PsDebug.warning((String)"index out of range.");
            return 0.0;
        }
        for (int i = 0; i < this.m_snoe.m_data[n]; ++i) {
            if (this.m_sindx[n].m_data[i] != n2) continue;
            return this.m_stiff[n].m_data[i];
        }
        return 0.0;
    }

    public PiVector getNumEntries() {
        return this.m_snoe;
    }

    public int getNumEntries(int n) {
        return this.m_snoe.m_data[n];
    }

    public PiVector[] getColIndices() {
        return this.m_sindx;
    }

    public PiVector getColIndices(int n) {
        return this.m_sindx[n];
    }

    public int getColIndex(int n, int n2) {
        return this.m_sindx[n].m_data[n2];
    }

    public void setRow(int n, int n2, PiVector piVector, PdVector pdVector) {
        this.m_snoe.m_data[n] = n2;
        this.m_sindx[n] = piVector;
        this.m_stiff[n] = pdVector;
    }

    public boolean isSquare() {
        return this.m_jSize == -1 || this.m_jSize == this.m_iSize;
    }

    public void setEntry(int n, int n2, double d) {
        int n3 = this.getIndex(n, n2);
        this.m_stiff[n].m_data[n3] = d;
    }

    public void setEntrySparse(int n, int n2, double d) {
        this.m_stiff[n].m_data[n2] = d;
    }

    public void addEntry(int n, int n2, double d) {
        int n3;
        if (n < 0 || n >= this.m_iSize || n2 < 0 || n2 >= this.m_jSize) {
            PsDebug.warning((String)("i or j out of bounds, i = " + n + ", j = " + n2));
            return;
        }
        int n4 = n3 = this.getIndex(n, n2);
        this.m_stiff[n].m_data[n4] = this.m_stiff[n].m_data[n4] + d;
    }

    public void copy(PnSparseMatrix pnSparseMatrix) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Sparse matrix is null.");
            return;
        }
        this.m_iSize = pnSparseMatrix.m_iSize;
        this.m_jSize = pnSparseMatrix.m_jSize;
        this.m_snoe = PiVector.copyNew((PiVector)pnSparseMatrix.m_snoe);
        this.m_sindx = PiVector.copyNew((PiVector[])pnSparseMatrix.m_sindx);
        this.m_stiff = PdVector.copyNew((PdVector[])pnSparseMatrix.m_stiff);
    }

    public static PnSparseMatrix copyNew(PnSparseMatrix pnSparseMatrix) {
        PnSparseMatrix pnSparseMatrix2 = new PnSparseMatrix(pnSparseMatrix.getNumRows(), pnSparseMatrix.getNumCols());
        pnSparseMatrix2.copy(pnSparseMatrix);
        return pnSparseMatrix2;
    }

    public static PnSparseMatrix addNew(PnSparseMatrix pnSparseMatrix, PnSparseMatrix pnSparseMatrix2) {
        PnSparseMatrix pnSparseMatrix3 = PnSparseMatrix.copyNew(pnSparseMatrix);
        pnSparseMatrix3.add(pnSparseMatrix2);
        return pnSparseMatrix3;
    }

    public static PnSparseMatrix subNew(PnSparseMatrix pnSparseMatrix, PnSparseMatrix pnSparseMatrix2) {
        PnSparseMatrix pnSparseMatrix3 = PnSparseMatrix.copyNew(pnSparseMatrix);
        pnSparseMatrix3.sub(pnSparseMatrix2);
        return pnSparseMatrix3;
    }

    public void compress() {
        PiVector piVector = new PiVector(this.m_iSize);
        PiVector[] piVectorArray = new PiVector[this.m_iSize];
        PdVector[] pdVectorArray = new PdVector[this.m_iSize];
        for (int i = 0; i < this.m_iSize; ++i) {
            int n;
            piVector.m_data[i] = 0;
            for (n = 0; n < this.m_snoe.m_data[i]; ++n) {
                if (!(Math.abs(this.m_stiff[i].m_data[n]) > 1.0E-10)) continue;
                int n2 = i;
                piVector.m_data[n2] = piVector.m_data[n2] + 1;
            }
            piVectorArray[i] = new PiVector(piVector.m_data[i]);
            pdVectorArray[i] = new PdVector(piVector.m_data[i]);
            n = 0;
            for (int j = 0; j < this.m_snoe.m_data[i]; ++j) {
                if (!(Math.abs(this.m_stiff[i].m_data[j]) > 1.0E-10)) continue;
                piVectorArray[i].m_data[n] = this.m_sindx[i].m_data[j];
                pdVectorArray[i].m_data[n] = this.m_stiff[i].m_data[j];
                ++n;
            }
        }
        this.m_snoe = piVector;
        this.m_stiff = pdVectorArray;
        this.m_sindx = piVectorArray;
    }

    public PdMatrix toPdMatrix() {
        PdMatrix pdMatrix = this.m_jSize == -1 ? new PdMatrix(this.m_iSize) : new PdMatrix(this.m_iSize, this.m_jSize);
        pdMatrix.setConstant(0.0);
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_snoe.m_data[i]; ++j) {
                int n = this.m_sindx[i].m_data[j];
                pdMatrix.m_data[i][n] = this.m_stiff[i].m_data[j];
            }
        }
        return pdMatrix;
    }

    public int getIndex(int n, int n2) {
        int n3;
        if (n >= this.m_iSize) {
            PsDebug.warning((String)("aLine out of bounds, aLine = " + n));
            return 0;
        }
        for (n3 = 0; n3 < this.m_snoe.m_data[n] && this.m_sindx[n].m_data[n3] != -1 && this.m_sindx[n].m_data[n3] != n2; ++n3) {
        }
        if (n3 >= this.m_snoe.m_data[n]) {
            this.appendEntry(n, n2, 0.0);
        } else if (this.m_sindx[n].m_data[n3] == -1) {
            this.m_sindx[n].m_data[n3] = n2;
            this.m_stiff[n].m_data[n3] = 0.0;
        }
        return n3;
    }

    public void appendEntry(int n, int n2, double d) {
        if (this.m_snoe.m_data[n] < this.m_sindx[n].m_data.length) {
            this.m_sindx[n].m_data[this.m_snoe.m_data[n]] = n2;
            this.m_stiff[n].m_data[this.m_snoe.m_data[n]] = d;
        } else {
            this.m_sindx[n].addEntry(n2);
            this.m_stiff[n].addEntry(d);
        }
        int n3 = n;
        this.m_snoe.m_data[n3] = this.m_snoe.m_data[n3] + 1;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ").append(PsConfig.getMessage((int)63028)).append("= \n");
        for (n = 0; n < this.m_iSize; ++n) {
            stringBuffer.append("\t [").append(PuString.intToString((int)n, (int)3)).append("] (len = ").append(PuString.intToString((int)this.m_snoe.m_data[n], (int)3)).append(") = ");
            stringBuffer.append(this.m_sindx[n].toShortString());
        }
        PdMatrix pdMatrix = this.toPdMatrix();
        pdMatrix.setConstant(0.0);
        for (n = 0; n < this.m_iSize; ++n) {
            for (int i = 0; i < this.m_snoe.m_data[n]; ++i) {
                int n2 = this.m_sindx[n].m_data[i];
                pdMatrix.m_data[n][n2] = this.m_stiff[n].m_data[i];
            }
        }
        stringBuffer.append(PsConfig.getMessage((int)63029)).append("\n").append(pdMatrix.toShortString());
        return stringBuffer.toString();
    }

    public String toShortString() {
        PdMatrix pdMatrix = this.toPdMatrix();
        pdMatrix.setConstant(0.0);
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_snoe.m_data[i]; ++j) {
                int n = this.m_sindx[i].m_data[j];
                pdMatrix.m_data[i][n] = this.m_stiff[i].m_data[j];
            }
        }
        return pdMatrix.toShortString();
    }

    public PdVector rightMultVector(PdVector pdVector, PdVector pdVector2, int n) {
        return PnSparseMatrix.rightMultVector(this, pdVector, pdVector2, n);
    }

    public PdVector rightMultVector(PdVector pdVector, PdVector pdVector2) {
        return this.leftMultMatrix(pdVector2, pdVector);
    }

    public PdVector leftMultMatrix(PdVector pdVector, PdVector pdVector2) {
        return this.rightMultVector(pdVector2, pdVector, 1);
    }

    public static PdVector rightMultVector(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2, int n) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, sparse matrix is null.");
            return null;
        }
        int n2 = pnSparseMatrix.getNumRows() * n;
        int n3 = pnSparseMatrix.getNumCols();
        int n4 = n3 * n;
        if (pdVector.getSize() < n4) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, input array has wrong size.");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(n2);
        } else {
            if (pdVector2.getSize() < n2) {
                pdVector2.setSize(n2);
            }
            pdVector2.setConstant(0.0);
        }
        for (int i = 0; i < pnSparseMatrix.m_iSize; ++i) {
            for (int j = 0; j < pnSparseMatrix.m_snoe.m_data[i]; ++j) {
                int n5 = n * pnSparseMatrix.m_sindx[i].m_data[j];
                if (n5 < 0) continue;
                for (int k = 0; k < n; ++k) {
                    int n6 = n * i + k;
                    pdVector2.m_data[n6] = pdVector2.m_data[n6] + pnSparseMatrix.m_stiff[i].m_data[j] * pdVector.m_data[n5 + k];
                }
            }
        }
        return pdVector2;
    }

    public static PdVector rightMultVector(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, sparse matrix is null.");
            return null;
        }
        return PnSparseMatrix.rightMultVector(pnSparseMatrix, pdVector, pdVector2, 1);
    }

    public static PdVector leftMultVector(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2, int n) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, sparse matrix is null.");
            return null;
        }
        int n2 = pnSparseMatrix.m_iSize * n;
        int n3 = pnSparseMatrix.getNumCols();
        int n4 = n3 * n;
        if (pdVector.getSize() < n2) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, input array has wrong size.");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(n4);
        } else {
            if (pdVector2.getSize() < n4) {
                pdVector2.setSize(n4);
            }
            pdVector2.setConstant(0.0);
        }
        for (int i = 0; i < pnSparseMatrix.m_iSize; ++i) {
            for (int j = 0; j < pnSparseMatrix.m_snoe.m_data[i]; ++j) {
                int n5 = n * pnSparseMatrix.m_sindx[i].m_data[j];
                if (n5 < 0) continue;
                for (int k = 0; k < n; ++k) {
                    int n6 = n5 + k;
                    pdVector2.m_data[n6] = pdVector2.m_data[n6] + pnSparseMatrix.m_stiff[i].m_data[j] * pdVector.m_data[n * i + k];
                }
            }
        }
        return pdVector2;
    }

    public PdVector leftMultVector(PdVector pdVector, PdVector pdVector2, int n) {
        return PnSparseMatrix.leftMultVector(this, pdVector, pdVector2, n);
    }

    public PdVector leftMultVector(PdVector pdVector, PdVector pdVector2) {
        return this.rightMultMatrix(pdVector2, pdVector);
    }

    public PdVector rightMultMatrix(PdVector pdVector, PdVector pdVector2) {
        return this.leftMultVector(pdVector2, pdVector, 1);
    }

    public static PdVector leftMultVector(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        return PnSparseMatrix.leftMultVector(pnSparseMatrix, pdVector, pdVector2, 1);
    }

    public int getDiagIndex(int n) {
        return this.getIndex(n, n);
    }

    public PnSparseMatrix transposeNew() {
        return this.transposeThis(new PnSparseMatrix());
    }

    public void transpose(PnSparseMatrix pnSparseMatrix) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot transpose matrix. Given matrix is null.");
            return;
        }
        if (pnSparseMatrix == this) {
            this.transpose();
        } else {
            pnSparseMatrix.transposeThis(this);
        }
    }

    public void transpose() {
        this.copy(this.transposeNew());
    }

    public static PnSparseMatrix multMatrices(PnSparseMatrix pnSparseMatrix, PnSparseMatrix pnSparseMatrix2, PnSparseMatrix pnSparseMatrix3) {
        int n;
        if (pnSparseMatrix.getNumCols() != pnSparseMatrix2.getNumRows()) {
            PsDebug.warning((String)"Dimension of matrices do not match.");
            return null;
        }
        if (pnSparseMatrix3 == null) {
            pnSparseMatrix3 = new PnSparseMatrix();
        }
        int n2 = pnSparseMatrix.m_iSize;
        int n3 = pnSparseMatrix2.getNumCols();
        pnSparseMatrix3.setSize(n2, n3);
        pnSparseMatrix3.m_snoe.setConstant(0);
        for (n = 0; n < n2; ++n) {
            pnSparseMatrix3.m_sindx[n].setConstant(-1);
            pnSparseMatrix3.m_stiff[n].setConstant(0.0);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < pnSparseMatrix.m_snoe.m_data[i]; ++j) {
                n = pnSparseMatrix.m_sindx[i].m_data[j];
                double d = pnSparseMatrix.m_stiff[i].m_data[j];
                for (int k = 0; k < pnSparseMatrix2.m_snoe.m_data[n]; ++k) {
                    int n4 = pnSparseMatrix2.m_sindx[n].m_data[k];
                    double d2 = pnSparseMatrix2.m_stiff[n].m_data[k];
                    pnSparseMatrix3.addEntry(i, n4, d * d2);
                }
            }
        }
        return pnSparseMatrix3;
    }

    private PnSparseMatrix transposeThis(PnSparseMatrix pnSparseMatrix) {
        int n;
        int n2;
        if (pnSparseMatrix == this) {
            PsDebug.warning((String)"Cannot transpose matrix. Argument must differ from 'this'.");
        }
        int n3 = this.m_iSize;
        int n4 = this.getNumCols();
        if (pnSparseMatrix == null) {
            pnSparseMatrix = new PnSparseMatrix();
        }
        pnSparseMatrix.setSize(n4, n3);
        pnSparseMatrix.m_snoe.setConstant(0);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < this.m_snoe.m_data[n2]; ++n) {
                int n5 = this.m_sindx[n2].m_data[n];
                pnSparseMatrix.m_snoe.m_data[n5] = pnSparseMatrix.m_snoe.m_data[n5] + 1;
            }
        }
        for (n = 0; n < n4; ++n) {
            n2 = pnSparseMatrix.m_snoe.m_data[n];
            if (pnSparseMatrix.m_sindx[n] == null) {
                pnSparseMatrix.m_sindx[n] = new PiVector(n2);
            } else if (pnSparseMatrix.m_sindx[n].m_data.length != n2) {
                pnSparseMatrix.m_sindx[n].setSize(n2);
            }
            if (pnSparseMatrix.m_stiff[n] == null) {
                pnSparseMatrix.m_stiff[n] = new PdVector(n2);
                continue;
            }
            if (pnSparseMatrix.m_stiff[n].m_data.length == n2) continue;
            pnSparseMatrix.m_stiff[n].setSize(n2);
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.m_snoe.m_data[i]; ++j) {
                n2 = this.m_sindx[i].m_data[j];
                pnSparseMatrix.m_stiff[n2].m_data[nArray[n2]] = this.m_stiff[i].m_data[j];
                pnSparseMatrix.m_sindx[n2].m_data[nArray[n2]] = i;
                int n6 = n2;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        return pnSparseMatrix;
    }

    public void validate() {
        for (int i = 0; i < this.m_iSize; ++i) {
            int n;
            this.sortMatrixRow(i);
            for (n = 0; n < this.m_snoe.m_data[i] && this.m_sindx[i].m_data[n] < 0; ++n) {
            }
            if (n > 0) {
                System.arraycopy(this.m_sindx[i].m_data, n, this.m_sindx[i].m_data, 0, this.m_snoe.m_data[i] - n);
                System.arraycopy(this.m_stiff[i].m_data, n, this.m_stiff[i].m_data, 0, this.m_snoe.m_data[i] - n);
                int n2 = i;
                this.m_snoe.m_data[n2] = this.m_snoe.m_data[n2] - n;
            }
            while (this.m_snoe.m_data[i] > 0 && this.m_sindx[i].m_data[this.m_snoe.m_data[i] - 1] >= this.m_jSize) {
                int n3 = i;
                this.m_snoe.m_data[n3] = this.m_snoe.m_data[n3] - 1;
            }
        }
    }

    public void removeZeros(double d) {
        for (int i = 0; i < this.m_iSize; ++i) {
            int n = 0;
            int n2 = this.m_snoe.m_data[i];
            for (int j = 0; j < n2; ++j) {
                if (!(Math.abs(this.m_stiff[i].m_data[j]) > d)) continue;
                ++n;
            }
            if (n2 == n) continue;
            PiVector piVector = new PiVector(n);
            PdVector pdVector = new PdVector(n);
            n = 0;
            for (int j = 0; j < n2; ++j) {
                if (!(Math.abs(this.m_stiff[i].m_data[j]) > d)) continue;
                piVector.m_data[n] = this.m_sindx[i].m_data[j];
                pdVector.m_data[n] = this.m_stiff[i].m_data[j];
                ++n;
            }
            this.setRow(i, n, piVector, pdVector);
        }
    }

    private void sortMatrixRow(int n) {
        int n2 = this.m_snoe.m_data[n];
        if (n2 == 0) {
            return;
        }
        PiVector piVector = new PiVector(n2);
        PuMath.heapsort((int)n2, (int[])this.m_sindx[n].m_data, (int[])piVector.m_data);
        int n3 = 1;
        for (int i = 0; i < n2 - 1; ++i) {
            if (this.m_sindx[n].m_data[piVector.m_data[i]] == this.m_sindx[n].m_data[piVector.m_data[i + 1]]) continue;
            ++n3;
        }
        PdVector pdVector = new PdVector(n3);
        PiVector piVector2 = new PiVector(n3);
        int n4 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            int n5 = n4;
            pdVector.m_data[n5] = pdVector.m_data[n5] + this.m_stiff[n].m_data[piVector.m_data[i]];
            piVector2.m_data[n4] = this.m_sindx[n].m_data[piVector.m_data[i]];
            if (this.m_sindx[n].m_data[piVector.m_data[i + 1]] == piVector2.m_data[n4]) continue;
            ++n4;
        }
        int n6 = n4;
        pdVector.m_data[n6] = pdVector.m_data[n6] + this.m_stiff[n].m_data[piVector.m_data[n2 - 1]];
        piVector2.m_data[n4] = this.m_sindx[n].m_data[piVector.m_data[n2 - 1]];
        this.m_snoe.m_data[n] = n3;
        this.m_sindx[n] = piVector2;
        this.m_stiff[n] = pdVector;
    }

    public static PnSparseMatrix transposeNew(PnSparseMatrix pnSparseMatrix) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot transpose, sparse matrix is null.");
            return null;
        }
        return pnSparseMatrix.transposeNew();
    }

    public void add(PnSparseMatrix pnSparseMatrix) {
        this.add(pnSparseMatrix, 1);
    }

    public void sub(PnSparseMatrix pnSparseMatrix) {
        this.add(pnSparseMatrix, -1);
    }

    private void add(PnSparseMatrix pnSparseMatrix, int n) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"m is null");
            return;
        }
        int n2 = this.getNumRows();
        if (pnSparseMatrix.getNumRows() != n2 || pnSparseMatrix.getNumCols() != this.getNumCols()) {
            PsDebug.warning((String)"Dimensions do not match");
            return;
        }
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                int n7;
                n3 = n5 < this.m_snoe.m_data[i] ? this.m_sindx[i].m_data[n5] : Integer.MAX_VALUE;
                int n8 = n7 = n6 < pnSparseMatrix.m_snoe.m_data[i] ? pnSparseMatrix.m_sindx[i].m_data[n6] : Integer.MAX_VALUE;
                if (n3 == Integer.MAX_VALUE && n7 == Integer.MAX_VALUE) break;
                if (n3 <= n7) {
                    ++n5;
                }
                if (n7 <= n3) {
                    ++n6;
                }
                ++n4;
            }
            if (n4 == this.m_snoe.m_data[i] && n4 == pnSparseMatrix.m_snoe.m_data[i]) {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n9 = n3;
                    this.m_stiff[i].m_data[n9] = this.m_stiff[i].m_data[n9] + (double)n * pnSparseMatrix.m_stiff[i].m_data[n3];
                }
                continue;
            }
            PiVector piVector = new PiVector(n4);
            PdVector pdVector = new PdVector(n4);
            n6 = 0;
            n5 = 0;
            for (int j = 0; j < n4; ++j) {
                int n10;
                int n11 = n5 < this.m_snoe.m_data[i] ? this.m_sindx[i].m_data[n5] : Integer.MAX_VALUE;
                int n12 = n10 = n6 < pnSparseMatrix.m_snoe.m_data[i] ? pnSparseMatrix.m_sindx[i].m_data[n6] : Integer.MAX_VALUE;
                if (n11 == Integer.MAX_VALUE && n10 == Integer.MAX_VALUE) break;
                if (n11 <= n10) {
                    piVector.m_data[j] = n11;
                    int n13 = j;
                    pdVector.m_data[n13] = pdVector.m_data[n13] + this.m_stiff[i].m_data[n5];
                    ++n5;
                }
                if (n10 > n11) continue;
                piVector.m_data[j] = n10;
                int n14 = j;
                pdVector.m_data[n14] = pdVector.m_data[n14] + (double)n * pnSparseMatrix.m_stiff[i].m_data[n6];
                ++n6;
            }
            this.m_sindx[i] = piVector;
            this.m_stiff[i] = pdVector;
            this.m_snoe.m_data[i] = n4;
        }
    }

    public void add(PnSparseMatrix pnSparseMatrix, PnSparseMatrix pnSparseMatrix2) {
        this.clear();
        this.add(pnSparseMatrix);
        this.add(pnSparseMatrix2);
    }

    public void addDiagonal(double d) {
        if (!this.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            this.addEntry(i, i, d);
        }
    }

    public void addDiagonal(PdVector pdVector) {
        if (!this.isSquare() || this.m_iSize != pdVector.getSize()) {
            PsDebug.warning((String)"Matrix is not square or dimensions do not match.");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            this.addEntry(i, i, pdVector.m_data[i]);
        }
    }

    public void multScalar(double d) {
        for (int i = 0; i < this.m_iSize; ++i) {
            int n = 0;
            while (n < this.m_snoe.m_data[i]) {
                int n2 = n++;
                this.m_stiff[i].m_data[n2] = this.m_stiff[i].m_data[n2] * d;
            }
        }
    }

    public void clear() {
        this.m_snoe.setConstant(0);
    }

    public void concatMatrices(PnSparseMatrix pnSparseMatrix, PnSparseMatrix pnSparseMatrix2, PnSparseMatrix pnSparseMatrix3, PnSparseMatrix pnSparseMatrix4) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = pnSparseMatrix == null ? 0 : pnSparseMatrix.getNumRows();
        int n6 = pnSparseMatrix == null ? 0 : pnSparseMatrix.getNumCols();
        int n7 = pnSparseMatrix2 == null ? 0 : pnSparseMatrix2.getNumRows();
        int n8 = pnSparseMatrix2 == null ? 0 : pnSparseMatrix2.getNumCols();
        int n9 = pnSparseMatrix3 == null ? 0 : pnSparseMatrix3.getNumRows();
        int n10 = pnSparseMatrix3 == null ? 0 : pnSparseMatrix3.getNumCols();
        int n11 = pnSparseMatrix4 == null ? 0 : pnSparseMatrix4.getNumRows();
        int n12 = n4 = pnSparseMatrix4 == null ? 0 : pnSparseMatrix4.getNumCols();
        if (!((n5 == n7 && n9 == n11 || pnSparseMatrix2 == null && pnSparseMatrix4 == null) && (n6 == n10 && n8 == n4 || pnSparseMatrix3 == null && pnSparseMatrix4 == null))) {
            PsDebug.warning((String)"Dimensions of matrices do not match.");
            return;
        }
        int n13 = n5 + n9;
        int n14 = n6 + n8;
        this.setSize(n13, n14);
        for (n3 = 0; n3 < n5; ++n3) {
            this.m_snoe.m_data[n3] = n2 = pnSparseMatrix.m_snoe.m_data[n3] + (pnSparseMatrix2 == null ? 0 : pnSparseMatrix2.m_snoe.m_data[n3]);
            if (this.m_stiff[n3].getSize() != n2) {
                this.m_sindx[n3] = new PiVector(n2);
                this.m_stiff[n3] = new PdVector(n2);
            }
            System.arraycopy(pnSparseMatrix.m_sindx[n3].m_data, 0, this.m_sindx[n3].m_data, 0, pnSparseMatrix.m_snoe.m_data[n3]);
            System.arraycopy(pnSparseMatrix.m_stiff[n3].m_data, 0, this.m_stiff[n3].m_data, 0, pnSparseMatrix.m_snoe.m_data[n3]);
            if (pnSparseMatrix2 == null) continue;
            for (n = 0; n < pnSparseMatrix2.m_snoe.m_data[n3]; ++n) {
                this.m_sindx[n3].m_data[pnSparseMatrix.m_snoe.m_data[n3] + n] = pnSparseMatrix2.m_sindx[n3].m_data[n] + n6;
            }
            System.arraycopy(pnSparseMatrix2.m_stiff[n3].m_data, 0, this.m_stiff[n3].m_data, pnSparseMatrix.m_snoe.m_data[n3], pnSparseMatrix2.m_snoe.m_data[n3]);
        }
        for (n3 = 0; n3 < n9; ++n3) {
            this.m_snoe.m_data[n5 + n3] = n2 = pnSparseMatrix3.m_snoe.m_data[n3] + (pnSparseMatrix4 == null ? 0 : pnSparseMatrix4.m_snoe.m_data[n3]);
            if (this.m_stiff[n5 + n3].getSize() != n2) {
                this.m_sindx[n5 + n3] = new PiVector(n2);
                this.m_stiff[n5 + n3] = new PdVector(n2);
            }
            System.arraycopy(pnSparseMatrix3.m_sindx[n3].m_data, 0, this.m_sindx[n5 + n3].m_data, 0, pnSparseMatrix3.m_snoe.m_data[n3]);
            System.arraycopy(pnSparseMatrix3.m_stiff[n3].m_data, 0, this.m_stiff[n5 + n3].m_data, 0, pnSparseMatrix3.m_snoe.m_data[n3]);
            if (pnSparseMatrix4 == null) continue;
            for (n = 0; n < pnSparseMatrix4.m_snoe.m_data[n3]; ++n) {
                this.m_sindx[n5 + n3].m_data[pnSparseMatrix3.m_snoe.m_data[n3] + n] = pnSparseMatrix4.m_sindx[n3].m_data[n] + n10;
            }
            System.arraycopy(pnSparseMatrix4.m_stiff[n3].m_data, 0, this.m_stiff[n5 + n3].m_data, pnSparseMatrix3.m_snoe.m_data[n3], pnSparseMatrix4.m_snoe.m_data[n3]);
        }
    }

    public void deleteRow(int n) {
        if (n < 0 || n >= this.getNumRows()) {
            PsDebug.warning((String)"Row index out of range.");
            return;
        }
        PiVector piVector = new PiVector(this.getNumRows() - 1);
        PdVector[] pdVectorArray = new PdVector[this.getNumRows() - 1];
        PiVector[] piVectorArray = new PiVector[this.getNumRows() - 1];
        if (n > 0) {
            System.arraycopy(this.m_snoe.m_data, 0, piVector.m_data, 0, n - 1);
            System.arraycopy(this.m_stiff, 0, pdVectorArray, 0, n - 1);
            System.arraycopy(this.m_sindx, 0, piVectorArray, 0, n - 1);
        }
        if (n < this.getNumRows() - 1) {
            System.arraycopy(this.m_snoe.m_data, n + 1, piVector.m_data, n, this.getNumRows() - n - 1);
            System.arraycopy(this.m_stiff, n + 1, pdVectorArray, n, this.getNumRows() - n - 1);
            System.arraycopy(this.m_sindx, n + 1, piVectorArray, n, this.getNumRows() - n - 1);
        }
        this.m_snoe = piVector;
        this.m_stiff = pdVectorArray;
        this.m_sindx = piVectorArray;
        if (this.m_jSize == -1) {
            this.m_jSize = this.m_iSize;
        }
        --this.m_iSize;
    }

    public void deleteColumn(int n) {
        if (n < 0 || n >= this.getNumCols()) {
            PsDebug.warning((String)"Col index out of range.");
            return;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            int n2 = this.m_snoe.m_data[i];
            for (int j = 0; j < n2; ++j) {
                int n3 = this.m_sindx[i].m_data[j];
                if (n3 == n) {
                    this.deleteEntry(i, j);
                    --n2;
                    --j;
                    continue;
                }
                if (n3 <= n) continue;
                int n4 = j;
                this.m_sindx[i].m_data[n4] = this.m_sindx[i].m_data[n4] - 1;
            }
        }
        --this.m_jSize;
    }

    private void deleteEntry(int n, int n2) {
        int n3 = this.m_snoe.m_data[n];
        if (n3 - 1 - n2 > 0) {
            System.arraycopy(this.m_sindx[n].m_data, n2 + 1, this.m_sindx[n].m_data, n2, n3 - 1 - n2);
            System.arraycopy(this.m_stiff[n].m_data, n2 + 1, this.m_stiff[n].m_data, n2, n3 - 1 - n2);
        }
        this.m_sindx[n].setSize(n3 - 1);
        this.m_stiff[n].setSize(n3 - 1);
        int n4 = n;
        this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] - 1;
    }

    public double multQuadratic(PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        for (int i = 0; i < this.m_iSize; ++i) {
            int n = this.m_snoe.m_data[i];
            if (n < 1) continue;
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = this.m_sindx[i].m_data[j];
                d2 += this.m_stiff[i].m_data[j] * pdVector2.m_data[n2];
            }
            d += pdVector.m_data[i] * d2;
        }
        return d;
    }

    public static PnSparseMatrix multScalar(PnSparseMatrix pnSparseMatrix, double d) {
        int n = pnSparseMatrix.m_iSize;
        for (int i = 0; i < n; ++i) {
            pnSparseMatrix.m_stiff[i].multScalar(d);
        }
        return pnSparseMatrix;
    }

    public void sortEntries() {
        int n = this.m_snoe.m_data[0];
        for (int i = 1; i < this.m_iSize; ++i) {
            if (this.m_snoe.m_data[i] <= n) continue;
            n = this.m_snoe.m_data[i];
        }
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < this.m_iSize; ++i) {
            int n2;
            int n3 = this.m_snoe.m_data[i];
            PuMath.heapsort((int)n3, (int[])this.m_sindx[i].m_data, (int[])nArray);
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = this.m_sindx[i].m_data[nArray[n2]];
                dArray[n2] = this.m_stiff[i].m_data[nArray[n2]];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_sindx[i].m_data[n2] = nArray2[n2];
                this.m_stiff[i].m_data[n2] = dArray[n2];
            }
        }
    }

    public void clearRow(int n) {
        this.m_snoe.m_data[n] = 0;
        this.m_sindx[n].setSize(0);
        this.m_stiff[n].setSize(0);
    }
}

