/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jvx.numeric.PnAlignmentEnergy;
import jvx.numeric.PnAreaEnergy;
import jvx.numeric.PnAreaVolEnergy;
import jvx.numeric.PnConfEnergy;
import jvx.numeric.PnDiriEnergy;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnGaussEnergy;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnSpringEnergy;
import jvx.numeric.PnVolumeEnergy;
import jvx.thirdParty.acmeGui.BusyBox;
import jvx.thirdParty.acmeGui.NoticeBox;

public class PnEnergyMinimizer_IP
extends PsPanel
implements Runnable,
ActionListener,
ItemListener {
    protected PnEnergyMinimizer m_energyMinimizer;
    protected PsPanel m_energyPanel;
    protected PsPanel m_spectrumPanel;
    protected Choice m_cEnergy;
    protected Panel m_pDiri;
    protected TextField m_tNumLoops;
    protected TextField m_tCurrLoop;
    protected TextField m_tCGEps;
    protected TextField m_tInitialEnergy;
    protected TextField m_tFinalEnergy;
    protected TextField m_tGradientLength;
    protected TextField m_tNumIterations;
    protected Checkbox m_cLogEnergy;
    protected Checkbox m_cReduceRedraw;
    protected Checkbox m_cShowGrad;
    protected Checkbox m_cTangential;
    protected Checkbox m_cNormal;
    protected Checkbox m_cUpdateNormals;
    protected Checkbox m_cUpdateDomain;
    protected CheckboxGroup m_gHessian;
    protected Checkbox m_cHessian;
    protected Checkbox m_cIndex;
    protected CheckboxGroup m_gBoundary;
    protected Checkbox m_cFixedBnd;
    protected Checkbox m_cNeumannBnd;
    protected Checkbox m_cFixMarked;
    protected Choice m_cSolver;
    protected Panel m_pSolverIP;
    protected Choice m_cShowEV;
    protected Choice m_cPrint;
    protected String[] m_printChoice = new String[]{PsConfig.getMessage((int)54246), PsConfig.getMessage((int)54247), PsConfig.getMessage((int)54248), PsConfig.getMessage((int)54249), PsConfig.getMessage((int)54250), PsConfig.getMessage((int)54251), PsConfig.getMessage((int)54252)};
    public static final String SOLVER_SETTINGS = "solver_settings";
    protected Button m_bStep;
    protected Button m_bMinimize;
    private Color m_minimizeColor;
    protected Button m_bSuspend;
    protected PsPanel m_pSlider;
    protected PsTabPanel m_tabPanel;
    int m_numInst = 0;
    BusyBox b = null;
    int m_printType;
    int m_showType;
    static /* synthetic */ Class class$jvx$numeric$PnEnergyMinimizer_IP;
    static /* synthetic */ Class class$jvx$numeric$PnDiriEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnAreaEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnConfEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnSpringEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnAlignmentEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnVolumeEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnAreaVolEnergy;
    static /* synthetic */ Class class$jvx$numeric$PnGaussEnergy;

    public PnEnergyMinimizer_IP() {
        if (this.getClass() == (class$jvx$numeric$PnEnergyMinimizer_IP == null ? (class$jvx$numeric$PnEnergyMinimizer_IP = PnEnergyMinimizer_IP.class$("jvx.numeric.PnEnergyMinimizer_IP")) : class$jvx$numeric$PnEnergyMinimizer_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle(PsConfig.getMessage((int)54253));
        this.m_tabPanel = new PsTabPanel();
        ((Container)((Object)this)).add((Component)this.m_tabPanel);
        this.m_energyPanel = new PsPanel();
        this.m_tabPanel.addPanel(PsConfig.getMessage((boolean)true, (int)54000, (String)"Energy"), this.m_energyPanel);
        this.m_spectrumPanel = new PsPanel();
        this.m_tabPanel.addPanel(PsConfig.getMessage((boolean)true, (int)54000, (String)"Spectrum"), this.m_spectrumPanel);
        this.m_cEnergy = new Choice();
        this.m_cEnergy.addItemListener(this);
        this.m_cEnergy.add(PsConfig.getMessage((int)54254));
        this.m_cEnergy.add(PsConfig.getMessage((int)54255));
        this.m_cEnergy.add(PsConfig.getMessage((int)54256));
        this.m_cEnergy.add(PsConfig.getMessage((int)54257));
        this.m_cEnergy.add(PsConfig.getMessage((int)54258));
        this.m_cEnergy.add(PsConfig.getMessage((int)54259));
        this.m_cEnergy.add(PsConfig.getMessage((int)54260));
        this.m_cEnergy.add(PsConfig.getMessage((boolean)true, (int)54000, (String)"Gauss Curvature"));
        this.m_cEnergy.select(1);
        this.m_energyPanel.addLabelComponent(PsConfig.getMessage((int)54261), (Component)this.m_cEnergy);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        this.m_tInitialEnergy = new TextField(8);
        this.m_tInitialEnergy.setEditable(false);
        panel.add(this.m_tInitialEnergy);
        this.m_tFinalEnergy = new TextField(8);
        this.m_tFinalEnergy.setEditable(false);
        panel.add(this.m_tFinalEnergy);
        this.m_energyPanel.addLabelComponent(PsConfig.getMessage((int)54262), (Component)panel);
        this.m_tGradientLength = this.m_energyPanel.addTextField(PsConfig.getMessage((int)54263), 8);
        this.m_tGradientLength.setEditable(false);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        this.m_tCurrLoop = new TextField(8);
        this.m_tCurrLoop.setEditable(false);
        this.m_tNumLoops = new TextField(8);
        this.m_tNumLoops.addActionListener(this);
        panel.add(this.m_tCurrLoop);
        panel.add(this.m_tNumLoops);
        this.m_energyPanel.addLabelComponent(PsConfig.getMessage((int)54264), (Component)panel);
        this.m_tNumIterations = this.m_energyPanel.addTextField(PsConfig.getMessage((int)54265), 8);
        this.m_tNumIterations.setEditable(false);
        this.m_tCGEps = this.m_energyPanel.addTextField(PsConfig.getMessage((int)54266), 8);
        this.m_tCGEps.addActionListener(this);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.m_cLogEnergy = new Checkbox(PsConfig.getMessage((int)54267));
        this.m_cLogEnergy.addItemListener(this);
        panel.add(this.m_cLogEnergy);
        this.m_cReduceRedraw = new Checkbox(PsConfig.getMessage((int)54268));
        this.m_cReduceRedraw.addItemListener(this);
        panel.add(this.m_cReduceRedraw);
        this.m_cShowGrad = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Show Gradient"));
        this.m_cShowGrad.addItemListener(this);
        panel.add(this.m_cShowGrad);
        this.m_energyPanel.add(panel);
        this.m_energyPanel.addSubTitle(PsConfig.getMessage((int)54269));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 2));
        this.m_cTangential = new Checkbox(PsConfig.getMessage((int)54130));
        this.m_cTangential.addItemListener(this);
        panel2.add(this.m_cTangential);
        this.m_cNormal = new Checkbox(PsConfig.getMessage((int)54129));
        this.m_cNormal.addItemListener(this);
        panel2.add(this.m_cNormal);
        this.m_cUpdateNormals = new Checkbox(PsConfig.getMessage((int)54270));
        this.m_cUpdateNormals.addItemListener(this);
        panel2.add(this.m_cUpdateNormals);
        this.m_cUpdateDomain = new Checkbox(PsConfig.getMessage((int)54271));
        this.m_cUpdateDomain.addItemListener(this);
        panel2.add(this.m_cUpdateDomain);
        this.m_energyPanel.add(panel2);
        Panel panel3 = new Panel(new FlowLayout(1));
        this.m_bStep = new Button(PsConfig.getMessage((int)54033));
        this.m_bStep.addActionListener(this);
        panel3.add(this.m_bStep);
        this.m_bMinimize = new Button(PsConfig.getMessage((int)54278));
        this.m_bMinimize.addActionListener(this);
        panel3.add(this.m_bMinimize);
        this.m_bSuspend = new Button(PsConfig.getMessage((int)54035));
        this.m_bSuspend.addActionListener(this);
        this.m_bSuspend.setEnabled(false);
        panel3.add(this.m_bSuspend);
        this.m_energyPanel.add(panel3);
        this.m_pSlider = new PsPanel();
        this.m_energyPanel.add((Component)this.m_pSlider);
        PsPanel psPanel = new PsPanel();
        PsPanel psPanel2 = new PsPanel();
        psPanel2.addTitle(PsConfig.getMessage((int)54250));
        Panel panel4 = new Panel(new GridLayout(2, 2));
        psPanel2.add(panel4);
        this.m_gHessian = new CheckboxGroup();
        this.m_cHessian = new Checkbox(PsConfig.getMessage((int)54250), this.m_gHessian, true);
        this.m_cHessian.addItemListener(this);
        panel4.add(this.m_cHessian);
        this.m_cIndex = new Checkbox(PsConfig.getMessage((int)54273), this.m_gHessian, false);
        this.m_cIndex.addItemListener(this);
        panel4.add(this.m_cIndex);
        this.m_gBoundary = new CheckboxGroup();
        this.m_cFixedBnd = new Checkbox(PsConfig.getMessage((int)54274), this.m_gBoundary, true);
        this.m_cFixedBnd.addItemListener(this);
        panel4.add(this.m_cFixedBnd);
        this.m_cNeumannBnd = new Checkbox(PsConfig.getMessage((int)54275), this.m_gBoundary, false);
        this.m_cNeumannBnd.setEnabled(false);
        this.m_cNeumannBnd.addItemListener(this);
        panel4.add(this.m_cNeumannBnd);
        this.m_cFixMarked = new Checkbox(PsConfig.getMessage((int)54340));
        this.m_cFixMarked.addItemListener(this);
        psPanel2.add(this.m_cFixMarked);
        psPanel.add((Component)psPanel2);
        panel4 = new PsPanel();
        panel4.addTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Solver"));
        this.m_cSolver = new Choice();
        this.m_cSolver.addItemListener(this);
        panel4.addLabelComponent(PsConfig.getMessage((boolean)true, (int)54000, (String)"Solver"), this.m_cSolver);
        this.m_pSolverIP = new Panel(new BorderLayout());
        panel4.add(this.m_pSolverIP);
        psPanel.add(panel4);
        PsPanel psPanel3 = new PsPanel();
        psPanel3.addTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Output"));
        this.m_cShowEV = new Choice();
        this.m_cShowEV.addItemListener(this);
        psPanel3.addLabelComponent(PsConfig.getMessage((int)54276), (Component)this.m_cShowEV);
        this.m_cPrint = new Choice();
        this.m_cPrint.addItemListener(this);
        for (int i = 0; i < this.m_printChoice.length; ++i) {
            this.m_cPrint.add(this.m_printChoice[i]);
        }
        this.m_cPrint.select(0);
        psPanel3.addLabelComponent(PsConfig.getMessage((int)54277), (Component)this.m_cPrint);
        psPanel.add((Component)psPanel3);
        this.m_spectrumPanel.add((Component)psPanel);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_energyMinimizer = (PnEnergyMinimizer)psUpdateIf;
        this.m_pSlider.removeAll();
        String[] stringArray = this.m_energyMinimizer.getEigenSolver();
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_cSolver.add(stringArray[i]);
        }
        this.m_cSolver.select(0);
        PsPanel psPanel = this.m_energyMinimizer.getEigenSolverPanel(0);
        this.m_pSolverIP.add((Component)psPanel);
        ((Container)((Object)this)).validate();
    }

    public boolean update(Object object) {
        if (this.m_energyMinimizer == null) {
            return true;
        }
        if (this.m_energyMinimizer == object) {
            Object object2;
            PsPanel.setState((Checkbox)this.m_cUpdateNormals, (boolean)this.m_energyMinimizer.m_bUpdateNormals);
            PsPanel.setState((Checkbox)this.m_cUpdateDomain, (boolean)this.m_energyMinimizer.m_bUpdateDomain);
            PsPanel.setState((Checkbox)this.m_cLogEnergy, (boolean)this.m_energyMinimizer.m_bLogEnergy);
            PsPanel.setState((Checkbox)this.m_cReduceRedraw, (boolean)this.m_energyMinimizer.m_bReduceRedraw);
            PsPanel.setState((Checkbox)this.m_cFixMarked, (boolean)this.m_energyMinimizer.m_bFixMarkedVertices);
            PsPanel.setText((TextComponent)this.m_tCurrLoop, (String)String.valueOf(this.m_energyMinimizer.m_currLoop));
            PsPanel.setText((TextComponent)this.m_tNumLoops, (String)String.valueOf(this.m_energyMinimizer.m_numLoops));
            if (this.m_tCGEps != null) {
                PsPanel.setText((TextComponent)this.m_tCGEps, (String)String.valueOf(this.m_energyMinimizer.m_cgEps));
            }
            if (!this.m_energyMinimizer.isRunning()) {
                PsPanel.setText((TextComponent)this.m_tInitialEnergy, (String)PuString.toString((double)this.m_energyMinimizer.m_initialEnergy));
            }
            PsPanel.setText((TextComponent)this.m_tFinalEnergy, (String)PuString.toString((double)this.m_energyMinimizer.m_finalEnergy));
            PsPanel.setText((TextComponent)this.m_tNumIterations, (String)String.valueOf(this.m_energyMinimizer.m_numIterations));
            if (this.m_energyMinimizer.m_energy != null) {
                int n;
                PsPanel.setState((Checkbox)this.m_cTangential, (boolean)this.m_energyMinimizer.m_energy.m_bTangential);
                PsPanel.setState((Checkbox)this.m_cNormal, (boolean)this.m_energyMinimizer.m_energy.m_bNormal);
                object2 = "";
                boolean bl = false;
                Class<?> clazz = ((Object)((Object)this.m_energyMinimizer.m_energy)).getClass();
                if (clazz == (class$jvx$numeric$PnDiriEnergy == null ? (class$jvx$numeric$PnDiriEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnDiriEnergy")) : class$jvx$numeric$PnDiriEnergy)) {
                    object2 = PsConfig.getMessage((int)54254);
                } else if (clazz == (class$jvx$numeric$PnAreaEnergy == null ? (class$jvx$numeric$PnAreaEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnAreaEnergy")) : class$jvx$numeric$PnAreaEnergy)) {
                    object2 = PsConfig.getMessage((int)54255);
                    bl = true;
                } else if (clazz == (class$jvx$numeric$PnConfEnergy == null ? (class$jvx$numeric$PnConfEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnConfEnergy")) : class$jvx$numeric$PnConfEnergy)) {
                    object2 = PsConfig.getMessage((int)54256);
                } else if (clazz == (class$jvx$numeric$PnSpringEnergy == null ? (class$jvx$numeric$PnSpringEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnSpringEnergy")) : class$jvx$numeric$PnSpringEnergy)) {
                    object2 = PsConfig.getMessage((int)54257);
                } else if (clazz == (class$jvx$numeric$PnAlignmentEnergy == null ? (class$jvx$numeric$PnAlignmentEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnAlignmentEnergy")) : class$jvx$numeric$PnAlignmentEnergy)) {
                    object2 = PsConfig.getMessage((int)54258);
                } else if (clazz == (class$jvx$numeric$PnVolumeEnergy == null ? (class$jvx$numeric$PnVolumeEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnVolumeEnergy")) : class$jvx$numeric$PnVolumeEnergy)) {
                    object2 = PsConfig.getMessage((int)54259);
                } else if (clazz == (class$jvx$numeric$PnAreaVolEnergy == null ? (class$jvx$numeric$PnAreaVolEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnAreaVolEnergy")) : class$jvx$numeric$PnAreaVolEnergy)) {
                    object2 = PsConfig.getMessage((int)54260);
                } else if (clazz == (class$jvx$numeric$PnGaussEnergy == null ? (class$jvx$numeric$PnGaussEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnGaussEnergy")) : class$jvx$numeric$PnGaussEnergy)) {
                    object2 = PsConfig.getMessage((boolean)true, (int)54000, (String)"Gauss Curvature");
                }
                if (!object2.equals(this.m_cEnergy.getSelectedItem())) {
                    this.m_cEnergy.select((String)object2);
                    this.m_pSlider.removeAll();
                    if (clazz == (class$jvx$numeric$PnAreaVolEnergy == null ? (class$jvx$numeric$PnAreaVolEnergy = PnEnergyMinimizer_IP.class$("jvx.numeric.PnAreaVolEnergy")) : class$jvx$numeric$PnAreaVolEnergy)) {
                        this.m_pSlider.add((Component)((PnAreaVolEnergy)this.m_energyMinimizer.m_energy).m_meanCurvature.getInfoPanel());
                    }
                    ((Container)((Object)this)).validate();
                }
                this.m_tabPanel.setEnableTab(PsConfig.getMessage((boolean)true, (int)54000, (String)"Spectrum"), bl);
                int n2 = n = this.m_energyMinimizer.m_eValue != null ? this.m_energyMinimizer.m_eValue.getSize() : 0;
                if (n != this.m_cShowEV.getItemCount() - 1) {
                    this.m_cShowEV.setEnabled(false);
                    this.m_cShowEV.setVisible(false);
                    if (this.m_cShowEV.getItemCount() > 0) {
                        this.m_cShowEV.removeAll();
                    }
                    this.m_cShowEV.add(PsConfig.getMessage((int)54246));
                    for (int i = 0; i < n; ++i) {
                        this.m_cShowEV.add(PsConfig.getMessage((int)54279) + " " + i);
                    }
                    this.m_cShowEV.setVisible(true);
                    this.m_cShowEV.setEnabled(true);
                }
                if (this.m_energyMinimizer.m_vf == null) {
                    this.m_cShowEV.select(0);
                }
            }
            if (this.m_energyMinimizer.m_energy != null) {
                object2 = this.m_energyMinimizer.m_energy.evalGradient(this.m_energyMinimizer.m_coord, null);
                if (object2 != null) {
                    PsPanel.setText((TextComponent)this.m_tGradientLength, (String)PuString.toString((double)object2.length()));
                    if (this.m_cShowGrad.getState()) {
                        this.m_energyMinimizer.showGradient();
                    }
                } else {
                    PsPanel.setText((TextComponent)this.m_tGradientLength, (String)PsConfig.getMessage((int)54280));
                }
            }
            if (this.m_gHessian.getSelectedCheckbox() == this.m_cHessian && this.m_energyMinimizer.m_bHessianIsL2Normalized) {
                this.m_gHessian.setSelectedCheckbox(this.m_cIndex);
            }
            if (this.m_gBoundary.getSelectedCheckbox() == this.m_cFixedBnd && this.m_energyMinimizer.m_energy != null && this.m_energyMinimizer.m_energy.m_bUseConstrainMatrix) {
                this.m_gBoundary.setSelectedCheckbox(this.m_cNeumannBnd);
            }
            if (!this.m_energyMinimizer.isRunning() && !this.m_bSuspend.getLabel().equals(PsConfig.getMessage((int)54036))) {
                if (this.m_minimizeColor != null) {
                    this.m_bStep.setBackground(this.m_minimizeColor);
                    this.m_bMinimize.setBackground(this.m_minimizeColor);
                }
                PsPanel.setLabel((Button)this.m_bStep, (String)PsConfig.getMessage((int)54033));
                PsPanel.setLabel((Button)this.m_bMinimize, (String)PsConfig.getMessage((int)54278));
                PsPanel.setLabel((Button)this.m_bSuspend, (String)PsConfig.getMessage((int)54035));
                PsPanel.setEnabled((Component)this.m_bSuspend, (boolean)false);
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_energyMinimizer == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tNumLoops) {
            try {
                this.m_energyMinimizer.m_numLoops = Integer.parseInt(this.m_tNumLoops.getText());
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tNumLoops.getText()), (Object)this);
            }
        } else if (this.m_tCGEps != null && object == this.m_tCGEps) {
            try {
                this.m_energyMinimizer.m_cgEps = new Double(this.m_tCGEps.getText());
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tCGEps.getText()), (Object)this);
            }
        } else if (object == this.m_bStep) {
            if (this.m_bStep.getLabel().equals(PsConfig.getMessage((int)54033))) {
                this.m_minimizeColor = this.m_bStep.getBackground();
                this.m_bStep.setBackground(Color.red);
                this.m_bStep.setLabel(PsConfig.getMessage((int)54018));
                this.m_energyMinimizer.step(this.m_energyMinimizer.m_numLoops);
            } else {
                if (this.m_minimizeColor != null) {
                    this.m_bStep.setBackground(this.m_minimizeColor);
                }
                this.m_bStep.setLabel(PsConfig.getMessage((int)54033));
                this.m_energyMinimizer.stop();
            }
        } else if (object == this.m_bMinimize) {
            if (this.m_bMinimize.getLabel().equals(PsConfig.getMessage((int)54278))) {
                this.m_minimizeColor = this.m_bMinimize.getBackground();
                this.m_bMinimize.setBackground(Color.red);
                this.m_bMinimize.setLabel(PsConfig.getMessage((int)54018));
                this.m_bSuspend.setEnabled(true);
                this.m_energyMinimizer.minimize();
            } else {
                if (this.m_minimizeColor != null) {
                    this.m_bMinimize.setBackground(this.m_minimizeColor);
                }
                this.m_bMinimize.setLabel(PsConfig.getMessage((int)54278));
                this.m_bSuspend.setEnabled(false);
                this.m_bSuspend.setLabel(PsConfig.getMessage((int)54035));
                this.m_energyMinimizer.stop();
            }
        } else if (object == this.m_bSuspend) {
            if (this.m_bSuspend.getLabel().equals(PsConfig.getMessage((int)54035))) {
                this.m_bSuspend.setLabel(PsConfig.getMessage((int)54036));
                this.m_energyMinimizer.stop();
            } else {
                this.m_bSuspend.setLabel(PsConfig.getMessage((int)54035));
                this.m_energyMinimizer.start();
            }
        } else if (object == this.b) {
            PnJacobi.setInterrupted(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_energyMinimizer == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.m_cEnergy) {
            int n = this.m_cEnergy.getSelectedIndex();
            if (n == 0) {
                this.m_energyMinimizer.setEnergy(new PnDiriEnergy());
            } else if (n == 1) {
                this.m_energyMinimizer.setEnergy(new PnAreaEnergy());
            } else if (n == 2) {
                this.m_energyMinimizer.setEnergy(new PnConfEnergy());
            } else if (n == 3) {
                this.m_energyMinimizer.setEnergy(new PnSpringEnergy());
            } else if (n == 4) {
                this.m_energyMinimizer.setEnergy(new PnAlignmentEnergy());
            } else if (n == 5) {
                this.m_energyMinimizer.setEnergy(new PnVolumeEnergy());
            } else if (n == 6) {
                this.m_energyMinimizer.setEnergy(new PnAreaVolEnergy());
            } else if (n == 7) {
                this.m_energyMinimizer.setEnergy(new PnGaussEnergy());
            } else {
                return;
            }
            this.m_pSlider.removeAll();
            if (n == 6) {
                this.m_pSlider.add((Component)((PnAreaVolEnergy)this.m_energyMinimizer.m_energy).m_meanCurvature.getInfoPanel());
            }
            ((Container)((Object)this)).validate();
            this.m_energyMinimizer.update(this.m_energyMinimizer);
        } else if (object == this.m_cUpdateNormals) {
            this.m_energyMinimizer.m_bUpdateNormals = this.m_cUpdateNormals.getState();
            if (this.m_energyMinimizer.m_bUpdateNormals) {
                this.m_energyMinimizer.m_surface.makeVertexNormals();
                this.m_energyMinimizer.m_surface.update(null);
            }
        } else if (object == this.m_cUpdateDomain) {
            this.m_energyMinimizer.setUpdateDomain(this.m_cUpdateDomain.getState());
            this.m_energyMinimizer.m_domain.update(null);
        } else if (object == this.m_cTangential) {
            if (this.m_energyMinimizer.m_energy != null) {
                this.m_energyMinimizer.m_energy.m_bTangential = this.m_cTangential.getState();
                this.m_energyMinimizer.showNone();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
            }
        } else if (object == this.m_cNormal) {
            if (this.m_energyMinimizer.m_energy != null) {
                this.m_energyMinimizer.m_energy.m_bNormal = this.m_cNormal.getState();
                this.m_energyMinimizer.showNone();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
            }
        } else if (object == this.m_cLogEnergy) {
            this.m_energyMinimizer.m_bLogEnergy = this.m_cLogEnergy.getState();
            if (this.m_energyMinimizer.m_bLogEnergy) {
                PsDebug.message((String)("\n" + PsConfig.getMessage((int)63022) + " ..."));
            } else {
                PsDebug.message((String)("\n\t... " + PsConfig.getMessage((int)63023) + "\n"));
            }
        } else if (object == this.m_cReduceRedraw) {
            this.m_energyMinimizer.m_bReduceRedraw = this.m_cReduceRedraw.getState();
        } else if (object == this.m_cShowGrad) {
            if (this.m_cShowGrad.getState()) {
                this.m_cShowEV.select(0);
                this.m_energyMinimizer.showGradient();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
            } else {
                this.m_energyMinimizer.showNone();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
            }
        } else if (object == this.m_cFixMarked) {
            this.m_energyMinimizer.setEnabledFixVertices(this.m_cFixMarked.getState());
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        } else if (object == this.m_cShowEV) {
            int n = this.m_cShowEV.getSelectedIndex();
            if (n > 0) {
                this.m_cShowGrad.setState(false);
                if (this.m_energyMinimizer.m_eVector == null) {
                    this.m_showType = n;
                    this.m_printType = -1;
                    new Thread((Runnable)this, "Show_" + n + "_" + this.m_numInst++).start();
                } else {
                    this.m_energyMinimizer.showEigenvector(n - 1);
                    this.m_energyMinimizer.m_surface.update(null);
                }
            } else {
                this.m_energyMinimizer.showNone();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
            }
        } else if (object == this.m_cPrint) {
            int n;
            this.m_printType = n = this.m_cPrint.getSelectedIndex();
            switch (n) {
                case 1: {
                    new Thread((Runnable)this, "Print_" + n + "_" + this.m_numInst++).start();
                    break;
                }
                case 2: {
                    new Thread((Runnable)this, "Print_" + n + "_" + this.m_numInst++).start();
                    break;
                }
                case 3: {
                    this.m_energyMinimizer.printGradient();
                    break;
                }
                case 4: {
                    this.m_energyMinimizer.printHessian();
                    break;
                }
                case 5: {
                    this.m_energyMinimizer.getEnergy().testEigenvalues();
                    break;
                }
                case 6: {
                    this.m_energyMinimizer.saveEigenvectors();
                }
            }
        } else if (object == this.m_cHessian) {
            this.m_energyMinimizer.m_bHessianIsL2Normalized = false;
            this.m_cNeumannBnd.setEnabled(true);
            this.m_energyMinimizer.showNone();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        } else if (object == this.m_cIndex) {
            this.m_energyMinimizer.m_bHessianIsL2Normalized = true;
            this.m_cNeumannBnd.setEnabled(false);
            this.m_energyMinimizer.setEnabledConstrainMatrix(false);
            this.m_gBoundary.setSelectedCheckbox(this.m_cFixedBnd);
            this.m_energyMinimizer.showNone();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        } else if (object == this.m_cFixedBnd) {
            this.m_energyMinimizer.setEnabledConstrainMatrix(false);
            this.m_energyMinimizer.showNone();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        } else if (object == this.m_cNeumannBnd) {
            if (this.m_energyMinimizer.m_energy != null && !this.m_cHessian.getState()) {
                PsDebug.message((String)PsConfig.getMessage((int)63024));
                this.m_gHessian.setSelectedCheckbox(this.m_cHessian);
            }
            this.m_energyMinimizer.m_bHessianIsL2Normalized = false;
            this.m_energyMinimizer.setEnabledConstrainMatrix(true);
            this.m_energyMinimizer.showNone();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        } else if (object == this.m_cSolver) {
            this.m_energyMinimizer.setEigenSolver(this.m_cSolver.getSelectedIndex());
            PsPanel psPanel = this.m_energyMinimizer.getEigenSolverPanel(this.m_cSolver.getSelectedIndex());
            if (psPanel != null) {
                this.m_pSolverIP.removeAll();
                this.m_pSolverIP.add((Component)psPanel);
                this.m_energyMinimizer.showNone();
                this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
                ((Container)((Object)this)).validate();
            }
        }
    }

    public void run() {
        if (this.b != null) {
            return;
        }
        if (!(this.m_energyMinimizer.m_energy instanceof PnAreaEnergy)) {
            PsDebug.warning((String)"Eigenvectors available only for energy = area.");
            NoticeBox noticeBox = new NoticeBox(PsConfig.getFrame(), PsConfig.getMessage((int)58052));
            ((Component)noticeBox).setLocation(150, 500);
            ((Component)noticeBox).setSize(250, 150);
            ((Component)noticeBox).setVisible(true);
            return;
        }
        this.b = new BusyBox(PsConfig.getFrame(), PsConfig.getMessage((int)58053));
        this.b.addActionListener(this);
        ((Component)this.b).setLocation(150, 500);
        ((Component)this.b).setSize(250, 150);
        this.b.start();
        PnJacobi.setInterrupted(false);
        if (this.m_printType > 0) {
            switch (this.m_printType) {
                case 1: {
                    this.m_energyMinimizer.printEigenvectors();
                    break;
                }
                case 2: {
                    this.m_energyMinimizer.printEigenvalues();
                }
            }
            this.b.done();
        } else {
            int n = this.m_showType;
            if (n > 1) {
                this.m_energyMinimizer.showEigenvector(n - 2);
            }
            this.b.done();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        }
        this.b = null;
    }

    public PsTabPanel getTabPanel() {
        return this.m_tabPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

