/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.numeric.PnBandEigenSolver;

public class PnBandEigenSolver_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PnBandEigenSolver m_solver;
    protected TextField m_tShift;
    protected CheckboxGroup m_gShift;
    protected Checkbox m_cAscending;
    protected Checkbox m_cDescending;
    protected TextField m_tNumEV;
    protected TextField m_tStepSize;
    protected Checkbox m_checkquali;
    static /* synthetic */ Class class$jvx$numeric$PnBandEigenSolver_IP;

    public PnBandEigenSolver_IP() {
        if (this.getClass() == (class$jvx$numeric$PnBandEigenSolver_IP == null ? (class$jvx$numeric$PnBandEigenSolver_IP = PnBandEigenSolver_IP.class$("jvx.numeric.PnBandEigenSolver_IP")) : class$jvx$numeric$PnBandEigenSolver_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PsPanel psPanel = new PsPanel();
        this.m_tShift = new TextField(8);
        this.m_tShift.addActionListener(this);
        psPanel.addLabelComponent(PsConfig.getMessage((boolean)true, (int)54000, (String)"Shift"), (Component)this.m_tShift);
        Panel panel = new Panel(new GridLayout(1, 2));
        psPanel.add(panel);
        this.m_gShift = new CheckboxGroup();
        this.m_cAscending = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Ascending"), this.m_gShift, true);
        this.m_cAscending.addItemListener(this);
        panel.add(this.m_cAscending);
        this.m_cDescending = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Descending"), this.m_gShift, false);
        this.m_cDescending.addItemListener(this);
        panel.add(this.m_cDescending);
        this.m_tNumEV = new TextField(8);
        this.m_tNumEV.addActionListener(this);
        psPanel.addLabelComponent(PsConfig.getMessage((boolean)true, (int)54000, (String)"Count"), (Component)this.m_tNumEV);
        this.m_tStepSize = new TextField(8);
        this.m_tStepSize.addActionListener(this);
        psPanel.addLabelComponent(PsConfig.getMessage((boolean)true, (int)54000, (String)"Stepsize"), (Component)this.m_tStepSize);
        this.m_checkquali = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Check Quality of Results"));
        this.m_checkquali.addItemListener(this);
        psPanel.add(this.m_checkquali);
        ((Container)((Object)this)).add((Component)psPanel);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_solver = (PnBandEigenSolver)psUpdateIf;
        this.m_checkquali.setState(this.m_solver.isCheckResults());
        ((Container)((Object)this)).validate();
    }

    public boolean update(Object object) {
        if (object != null && object == this.m_solver) {
            PsPanel.setText((TextComponent)this.m_tShift, (String)String.valueOf(this.m_solver.getShift()));
            PsPanel.setText((TextComponent)this.m_tNumEV, (String)String.valueOf(this.m_solver.getCount()));
            PsPanel.setText((TextComponent)this.m_tStepSize, (String)String.valueOf(this.m_solver.getStepsize()));
            PsPanel.setState((Checkbox)this.m_cAscending, (boolean)this.m_solver.isAscending());
            PsPanel.setState((Checkbox)this.m_cDescending, (!this.m_solver.isAscending() ? 1 : 0) != 0);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_solver == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tShift) {
            try {
                double d = new Double(this.m_tShift.getText());
                this.m_solver.setShift(d);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tShift.getText()), (Object)this);
            }
        } else if (object == this.m_tNumEV) {
            try {
                this.m_solver.setCount(Integer.parseInt(this.m_tNumEV.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tNumEV.getText()), (Object)this);
            }
        } else if (object == this.m_tStepSize) {
            try {
                this.m_solver.setStepsize(Integer.parseInt(this.m_tStepSize.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tStepSize.getText()), (Object)this);
            }
        }
        this.m_parent.update((Object)this.m_parent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_solver == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.m_cAscending || object == this.m_cDescending) {
            this.m_solver.setAscending(this.m_cAscending.getState());
            this.m_parent.update((Object)this.m_parent);
        } else if (object == this.m_checkquali) {
            this.m_solver.setCheckResults(this.m_checkquali.getState());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

