/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.geom.PwGeodesic;
import jvx.project.PjWorkshop;
import jvx.vector.PwIsoline;

public class PwReeb
extends PjWorkshop {
    protected PgElementSet m_geom;
    protected PdVector m_scalar;
    protected PuFunction m_function = new PuFunction(3, 1);
    protected String m_defFunc = "u";
    protected PuDouble m_val;
    protected PuDouble m_discr;
    protected int m_showCurves = 0;
    protected double[] intervalPartition;
    protected PiVector[] elemToReeb;
    protected PiVector reebPoints;
    protected PiVector[][] reebParents;
    protected PiVector[][] reebChildren;
    protected PgPointSet m_irrVert;
    protected PgPointSet m_vertWithValue;
    protected PgPolygonSet m_graph;
    protected PgPolygonSet m_isoCurves;
    protected PgPolygonSet m_irrIsocurves;
    protected PdVector m_irrIsocurveValue;
    static /* synthetic */ Class class$jvx$geom$PwReeb;

    public PwReeb() {
        super(PsConfig.getMessage((int)48010));
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)45038));
        this.m_val = new PuDouble(PsConfig.getMessage((int)54456), (PsUpdateIf)this);
        this.m_discr = new PuDouble(PsConfig.getMessage((int)54097), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwReeb == null ? (class$jvx$geom$PwReeb = PwReeb.class$("jvx.geom.PwReeb")) : class$jvx$geom$PwReeb)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_function.setExpression(this.m_defFunc);
        this.m_val.init();
        this.m_discr.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_discr.setDefValue(0.5);
        this.m_discr.init();
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        if (!pgElementSet.checkNeighbour(true)) {
            PsDebug.warning((String)("Workshop surface smoothing can process geometry " + pgElementSet.getName() + ". " + "The neighbour infomation is incorrect." + " " + "Call makeNeighbour to creat new neighbour information."));
            return;
        }
        this.m_geom = pgElementSet;
        if (this.m_geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
        }
        this.m_geom.setTransparency(0.8);
        this.m_geom.showTransparency(true);
        this.m_isoCurves = new PgPolygonSet(this.m_geom.getDimOfVertices());
        this.m_isoCurves.setName(PsConfig.getMessage((int)45039) + " " + this.m_geom.getName());
        this.m_irrIsocurves = new PgPolygonSet(this.m_geom.getDimOfVertices());
        this.m_irrIsocurves.setName(PsConfig.getMessage((int)45040));
        this.m_irrIsocurves.setGlobalPolygonColor(Color.red);
        this.m_irrIsocurves.showVertices(false);
        this.m_irrIsocurveValue = new PdVector(0);
        this.m_irrVert = new PgPointSet(this.m_geom.getDimOfVertices());
        this.m_irrVert.setName("Irregular Vertices of " + this.m_geom.getName());
    }

    public void cancel() {
        PgElementSet pgElementSet;
        if (this.m_display != null) {
            if (this.m_graph != null && this.m_display.containsGeometry((PgGeometryIf)this.m_graph)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_graph);
            }
            if (this.m_isoCurves != null && this.m_display.containsGeometry((PgGeometryIf)this.m_isoCurves)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_isoCurves);
            }
            if (this.m_irrIsocurves != null && this.m_display.containsGeometry((PgGeometryIf)this.m_irrIsocurves)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_irrIsocurves);
            }
            if (this.m_irrVert != null && this.m_display.containsGeometry((PgGeometryIf)this.m_irrVert)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_irrVert);
            }
            this.m_display.update((Object)this.m_display);
        }
        if ((pgElementSet = (PgElementSet)this.m_geomSave) != null) {
            this.m_geom.showTransparency(pgElementSet.isShowingTransparency());
            this.m_geom.setTransparency(pgElementSet.getTransparency());
            this.m_geom.update((Object)this.m_geom);
        }
        super.cancel();
    }

    public boolean update(Object object) {
        if (object == this.m_function) {
            this.setPuFunction();
            return true;
        }
        if (object == this.m_scalar) {
            double d;
            double d2 = d = this.m_scalar.m_data[0];
            int n = this.m_scalar.getSize();
            for (int i = 1; i < n; ++i) {
                if (this.m_scalar.m_data[i] > d2) {
                    d2 = this.m_scalar.m_data[i];
                }
                if (!(this.m_scalar.m_data[i] < d)) continue;
                d = this.m_scalar.m_data[i];
            }
            this.m_val.setBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 25.0);
            this.m_discr.setBounds(0.0, d2 / 2.0, d2 / 100.0, d2 / 25.0);
            this.makeReebGraph();
            this.m_val.update((Object)this.m_val);
            this.m_discr.update((Object)this.m_discr);
            return true;
        }
        if (object == this.m_val || object == this.m_discr) {
            PdVector pdVector = null;
            switch (this.m_showCurves) {
                case 1: {
                    double d = this.m_val.getMin();
                    double d3 = this.m_discr.getValue();
                    int n = (int)Math.ceil((this.m_val.getValue() - d) / d3) + 1;
                    if (n <= 0) break;
                    pdVector = new PdVector(n);
                    double d4 = d;
                    for (int i = 0; i < n - 1; ++i) {
                        pdVector.m_data[i] = d4;
                        d4 += d3;
                    }
                    pdVector.m_data[n - 1] = this.m_val.getValue();
                    break;
                }
                case 2: {
                    double d = this.m_val.getMin();
                    double d5 = this.m_val.getMax();
                    double d6 = this.m_discr.getValue();
                    int n = (int)Math.ceil((this.m_val.getValue() - d) / d6);
                    double d7 = d + (double)n * d6;
                    n = (int)Math.ceil((d5 - d7) / d6) + 1;
                    if (n <= 0) break;
                    pdVector = new PdVector(n);
                    double d8 = d7;
                    for (int i = 1; i < n; ++i) {
                        pdVector.m_data[i] = d8;
                        d8 += d6;
                    }
                    pdVector.m_data[0] = this.m_val.getValue();
                    break;
                }
                case 3: {
                    double d = this.m_val.getMin();
                    double d9 = this.m_discr.getValue();
                    int n = (int)Math.ceil((this.m_val.getMax() - d) / d9) + 1;
                    if (n <= 0) break;
                    pdVector = new PdVector(n);
                    double d10 = d;
                    for (int i = 0; i < n - 1; ++i) {
                        pdVector.m_data[i] = d10;
                        d10 += d9;
                    }
                    pdVector.m_data[n - 1] = this.m_val.getMax();
                    break;
                }
                default: {
                    pdVector = new PdVector(1);
                    pdVector.m_data[0] = this.m_val.getValue();
                }
            }
            if (pdVector == null) {
                return true;
            }
            this.makeIsocurves(pdVector, this.m_isoCurves);
            if (!this.m_isoCurves.isVisible()) {
                this.m_isoCurves.setVisible(true);
                this.m_isoCurves.update((Object)this.m_isoCurves);
            }
            return true;
        }
        return super.update(object);
    }

    public static int getVertexIndicesOfMorseFunction(PgElementSet pgElementSet, PiVector piVector, PiVector piVector2) {
        PdVector pdVector = new PdVector(piVector.getSize());
        pdVector.set(piVector.m_data, 0, piVector.getSize());
        return PwReeb.getVertexIndicesOfMorseFunction(pgElementSet, pdVector, piVector2);
    }

    public static int getVertexIndicesOfMorseFunction(PgElementSet pgElementSet, PdVector pdVector, PiVector piVector) {
        int n;
        int n2;
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface must be a triangulation.");
            return -1;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n3 = 0;
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getNumVertices();
        if (piVector.getSize() < n5) {
            piVector.setSize(n5);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            pdVectorArray[n2].clearTag(0);
        }
        for (n = 0; n < n4; ++n) {
            PiVector piVector2 = piVectorArray[n];
            for (int i = 0; i < 3; ++i) {
                int n6;
                if (pdVectorArray[piVector2.m_data[i]].hasTag(0)) continue;
                pdVectorArray[piVector2.m_data[i]].setTag(0);
                int n7 = piVector2.m_data[i];
                pgVertexStar.makeVertexStar(pgElementSet, n7, n);
                PiVector piVector3 = pgVertexStar.getLink();
                int n8 = piVector3.getSize();
                int n9 = piVector3.getFirstEntry();
                int n10 = piVector3.getLastEntry();
                int n11 = 0;
                n2 = pdVector.m_data[n10] > pdVector.m_data[n7] || pdVector.m_data[n10] == pdVector.m_data[n7] && n10 > n7 ? 1 : 0;
                for (int j = 0; j < n8; ++j) {
                    int n12 = piVector3.m_data[j];
                    int n13 = n6 = pdVector.m_data[n12] > pdVector.m_data[n7] || pdVector.m_data[n12] == pdVector.m_data[n7] && n12 > n7 ? 1 : 0;
                    if (n2 != n6) {
                        ++n11;
                    }
                    n2 = n6;
                }
                if (!pgVertexStar.isClosed()) {
                    n2 = pdVector.m_data[n10] > pdVector.m_data[n7] || pdVector.m_data[n10] == pdVector.m_data[n7] && n10 > n7 ? 1 : 0;
                    int n14 = n6 = pdVector.m_data[n9] > pdVector.m_data[n7] || pdVector.m_data[n9] == pdVector.m_data[n7] && n9 > n7 ? 1 : 0;
                    if (n2 != n6) {
                        --n11;
                    }
                    n11 *= 2;
                }
                piVector.m_data[n7] = 1 - n11 / 2;
                if (piVector.m_data[n7] == 0) continue;
                ++n3;
            }
        }
        for (n = 0; n < n5; ++n) {
            pdVectorArray[n].clearTag(0);
        }
        return n3;
    }

    public static PiVector getIrregularVerticesOfMorseFunction(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface must be a triangulation.");
            return null;
        }
        int n2 = pgElementSet.getNumVertices();
        PiVector piVector = new PiVector(n2);
        int n3 = PwReeb.getVertexIndicesOfMorseFunction(pgElementSet, pdVector, piVector);
        if (n3 == -1) {
            return null;
        }
        PiVector piVector2 = new PiVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (piVector.m_data[i] == 0) continue;
            piVector2.m_data[n4] = i;
            pdVector2.m_data[n4] = pdVector.m_data[i];
            ++n4;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = piVector2.m_data[n];
        }
        PuMath.heapsort((int)n3, (double[])pdVector2.m_data, (int[])nArray);
        for (n = 0; n < n3; ++n) {
            piVector2.m_data[n] = nArray2[nArray[n]];
        }
        return piVector2;
    }

    protected void showIrrVertices() {
        PiVector piVector = new PiVector(this.m_geom.getNumVertices());
        PwReeb.getVertexIndicesOfMorseFunction(this.m_geom, this.m_scalar, piVector);
        int n = 0;
        PiVector piVector2 = PwReeb.getIrregularVerticesOfMorseFunction(this.m_geom, this.m_scalar);
        int n2 = piVector2.getSize();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        this.m_irrVert.setNumVertices(n2);
        for (int i = 0; i < n2; ++i) {
            this.m_irrVert.setVertex(i, pdVectorArray[piVector2.m_data[i]]);
            this.m_irrVert.getVertex(i).setName(Integer.toString(piVector.m_data[piVector2.m_data[i]]));
            n += piVector.m_data[piVector2.m_data[i]];
        }
        this.m_irrVert.showVertexLabels(true);
        this.m_irrVert.showVertices(true);
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_irrVert);
        }
        this.m_irrVert.update((Object)this.m_irrVert);
        if (this.m_display != null) {
            this.m_display.update((Object)this.m_display);
        }
        PsDebug.message((String)("The sum of the indices of all irrgular vertices of the current function on " + this.m_geom.getName() + " is: " + n));
    }

    protected void showVerticesWithValue(double d) {
        this.m_vertWithValue = new PgPointSet(3);
        int n = this.m_geom.getNumVertices();
        this.m_vertWithValue.setNumVertices(n);
        this.m_vertWithValue.setNumVertices(0);
        for (int i = 0; i < n; ++i) {
        }
    }

    private void setPuFunction() {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_scalar == null || this.m_scalar.m_data.length != n) {
            this.m_scalar = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_scalar.m_data[i] = this.m_function.eval(0, pdVectorArray[i].m_data);
        }
        this.update(this.m_scalar);
    }

    public void setHeightFunction() {
        this.setHeightFunction(new PdVector(0.0, 0.0, 1.0));
    }

    public void setHeightFunction(PdVector pdVector) {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_scalar == null || this.m_scalar.getSize() < n) {
            this.m_scalar = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_scalar.m_data[i] = PdVector.dot((PdVector)pdVectorArray[i], (PdVector)pdVector);
        }
        this.update(this.m_scalar);
    }

    public void setDijkstraDistanceFunction(PiVector piVector) {
        PiVector piVector2 = PwGeodesic.getDijkstraDistance(this.m_geom, piVector);
        int n = this.m_geom.getNumVertices();
        if (this.m_scalar == null || this.m_scalar.getSize() < n) {
            this.m_scalar = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_scalar.m_data[i] = piVector2.m_data[i];
        }
        this.update(this.m_scalar);
    }

    public void setFunction(PdVector pdVector) {
        if (pdVector == null || this.m_geom != null && pdVector.getSize() < this.m_geom.getNumVertices()) {
            PsDebug.warning((String)"Cannot set function. Given PdVector either is null or does not contain enough elements.");
            return;
        }
        int n = this.m_geom.getNumVertices();
        if (this.m_scalar == null || this.m_scalar.getSize() < n) {
            this.m_scalar = new PdVector(n);
        }
        this.m_scalar.copyArray(pdVector);
        this.update(this.m_scalar);
    }

    public PdVector getFunction(PdVector pdVector) {
        return this.m_scalar;
    }

    protected void makeReebGraph() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        PiVector piVector;
        int n6;
        PiVector[] piVectorArray = this.m_geom.getElements();
        int n7 = this.m_geom.getNumElements();
        PiVector piVector2 = PwReeb.getIrregularVerticesOfMorseFunction(this.m_geom, this.m_scalar);
        double d = Double.NEGATIVE_INFINITY;
        int n8 = 0;
        int n9 = piVector2.getSize();
        for (n6 = 0; n6 < n9; ++n6) {
            if (this.m_scalar.m_data[piVector2.m_data[n6]] != d) {
                ++n8;
            }
            d = this.m_scalar.m_data[piVector2.m_data[n6]];
        }
        this.intervalPartition = new double[n8];
        n8 = 0;
        d = Double.NEGATIVE_INFINITY;
        for (n6 = 0; n6 < n9; ++n6) {
            if (this.m_scalar.m_data[piVector2.m_data[n6]] != d) {
                this.intervalPartition[n8] = this.m_scalar.m_data[piVector2.m_data[n6]];
                ++n8;
            }
            d = this.m_scalar.m_data[piVector2.m_data[n6]];
        }
        this.elemToReeb = new PiVector[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            double d2;
            piVector = piVectorArray[n6];
            double d3 = d2 = this.m_scalar.m_data[piVector.m_data[0]];
            for (n5 = 1; n5 < 3; ++n5) {
                if (this.m_scalar.m_data[piVector.m_data[n5]] < d2) {
                    d2 = this.m_scalar.m_data[piVector.m_data[n5]];
                }
                if (!(this.m_scalar.m_data[piVector.m_data[n5]] > d3)) continue;
                d3 = this.m_scalar.m_data[piVector.m_data[n5]];
            }
            n5 = 0;
            while (d2 > this.intervalPartition[n5]) {
                ++n5;
            }
            int n10 = d2 == this.intervalPartition[n5] ? 2 * n5 : 2 * n5 - 1;
            n5 = this.intervalPartition.length - 1;
            while (d3 < this.intervalPartition[n5]) {
                --n5;
            }
            n4 = d3 == this.intervalPartition[n5] ? 2 * n5 : 2 * n5 + 1;
            this.elemToReeb[n6] = new PiVector(n4 - n10 + 3);
            this.elemToReeb[n6].m_data[0] = n10;
            this.elemToReeb[n6].m_data[1] = n4;
            for (n5 = 2; n5 < this.elemToReeb[n6].m_data.length; ++n5) {
                this.elemToReeb[n6].m_data[n5] = -1;
            }
        }
        this.reebPoints = new PiVector(this.intervalPartition.length * 2 - 1);
        piVector = new PiVector(Math.max(n7 / 32, 20));
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        n4 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            PiVector piVector3 = piVectorArray[n6];
            for (n5 = 2; n5 < this.elemToReeb[n6].m_data.length; ++n5) {
                int n11;
                int n12;
                if (this.elemToReeb[n6].m_data[n5] != -1) continue;
                int n13 = this.elemToReeb[n6].m_data[0] + n5 - 2;
                double d4 = this.intervalPartition[n13 / 2];
                double d5 = n13 % 2 == 0 ? d4 : this.intervalPartition[n13 / 2 + 1];
                this.elemToReeb[n6].m_data[n5] = n12 = this.reebPoints.m_data[n13];
                int n14 = n13;
                this.reebPoints.m_data[n14] = this.reebPoints.m_data[n14] + 1;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (piVectorArray2[n6].m_data[n3] == -1) continue;
                    n2 = piVector3.m_data[(n3 + 1) % 3];
                    n = piVector3.m_data[(n3 + 2) % 3];
                    if (this.m_scalar.m_data[n2] > this.m_scalar.m_data[n]) {
                        n = n2;
                        n2 = piVector3.m_data[(n3 + 2) % 3];
                    }
                    if (!(n13 % 2 == 1 && (this.m_scalar.m_data[n2] < d4 && this.m_scalar.m_data[n] > d4 || this.m_scalar.m_data[n2] < d5 && this.m_scalar.m_data[n] > d5 || this.m_scalar.m_data[n2] > d4 && this.m_scalar.m_data[n2] < d5 || this.m_scalar.m_data[n] > d4 && this.m_scalar.m_data[n] < d5 || !(this.m_scalar.m_data[n2] != d4 && this.m_scalar.m_data[n2] != d5 || this.m_scalar.m_data[n] != d4 && this.m_scalar.m_data[n] != d5) && this.m_scalar.m_data[n2] != this.m_scalar.m_data[n])) && (n13 % 2 != 0 || !(d4 >= this.m_scalar.m_data[n2]) || !(d4 <= this.m_scalar.m_data[n])) || this.elemToReeb[piVectorArray2[n6].m_data[n3]].m_data[n11 = n13 + 2 - this.elemToReeb[piVectorArray2[n6].m_data[n3]].m_data[0]] != -1) continue;
                    this.elemToReeb[piVectorArray2[n6].m_data[n3]].m_data[n11] = n12;
                    if (piVector.getSize() <= n4 + 1) {
                        piVector.setSize(n4 * 2);
                    }
                    piVector.setEntry(n4, piVectorArray2[n6].m_data[n3]);
                    piVector.setEntry(++n4, this.m_geom.getOppVertexLocInd(n6, n3));
                    ++n4;
                }
                while (n4 > 1) {
                    int n15 = piVector.m_data[--n4];
                    int n16 = piVector.m_data[--n4];
                    n3 = (n15 + 1) % 3;
                    while (n3 != n15) {
                        if (piVectorArray2[n16].m_data[n3] != -1) {
                            n2 = piVectorArray[n16].m_data[(n3 + 1) % 3];
                            n = piVectorArray[n16].m_data[(n3 + 2) % 3];
                            if (this.m_scalar.m_data[n2] > this.m_scalar.m_data[n]) {
                                n = n2;
                                n2 = piVectorArray[n16].m_data[(n3 + 2) % 3];
                            }
                            if ((n13 % 2 == 1 && (this.m_scalar.m_data[n2] < d4 && this.m_scalar.m_data[n] > d4 || this.m_scalar.m_data[n2] < d5 && this.m_scalar.m_data[n] > d5 || this.m_scalar.m_data[n2] > d4 && this.m_scalar.m_data[n2] < d5 || this.m_scalar.m_data[n] > d4 && this.m_scalar.m_data[n] < d5 || (this.m_scalar.m_data[n2] == d4 || this.m_scalar.m_data[n2] == d5) && (this.m_scalar.m_data[n] == d4 || this.m_scalar.m_data[n] == d5) && this.m_scalar.m_data[n2] != this.m_scalar.m_data[n]) || n13 % 2 == 0 && d4 >= this.m_scalar.m_data[n2] && d4 <= this.m_scalar.m_data[n]) && this.elemToReeb[piVectorArray2[n16].m_data[n3]].m_data[n11 = n13 + 2 - this.elemToReeb[piVectorArray2[n16].m_data[n3]].m_data[0]] == -1) {
                                this.elemToReeb[piVectorArray2[n16].m_data[n3]].m_data[n11] = n12;
                                if (piVector.getSize() <= n4 + 1) {
                                    piVector.setSize(n4 * 2);
                                }
                                piVector.setEntry(n4, piVectorArray2[n16].m_data[n3]);
                                piVector.setEntry(++n4, this.m_geom.getOppVertexLocInd(n16, n3));
                                ++n4;
                            }
                        }
                        n3 = (n3 + 1) % 3;
                    }
                }
            }
        }
        n9 = this.reebPoints.getSize();
        this.reebParents = new PiVector[n9][];
        this.reebChildren = new PiVector[n9][];
        for (n6 = 0; n6 < n9; ++n6) {
            this.reebParents[n6] = new PiVector[this.reebPoints.m_data[n6] + 1];
            this.reebChildren[n6] = new PiVector[this.reebPoints.m_data[n6] + 1];
            for (n5 = 0; n5 < this.reebPoints.m_data[n6] + 1; ++n5) {
                this.reebChildren[n6][n5] = new PiVector(0);
                this.reebParents[n6][n5] = new PiVector(0);
            }
        }
        boolean bl = false;
        for (n6 = 0; n6 < n7; ++n6) {
            n9 = this.elemToReeb[n6].getSize();
            for (n5 = 2; n5 < n9 - 1; ++n5) {
                n2 = this.elemToReeb[n6].m_data[n5];
                n = this.elemToReeb[n6].m_data[n5 + 1];
                int n17 = n5 - 2 + this.elemToReeb[n6].m_data[0];
                int n18 = this.reebParents[n17][n2].getSize();
                for (n3 = 0; n3 < n18; ++n3) {
                    if (this.reebParents[n17][n2].m_data[n3] != n) continue;
                    bl = true;
                }
                if (!bl) {
                    this.reebParents[n17][n2].addEntry(n);
                }
                bl = false;
                int n19 = this.reebChildren[++n17][n].getSize();
                for (n3 = 0; n3 < n19; ++n3) {
                    if (this.reebChildren[n17][n].m_data[n3] != n2) continue;
                    bl = true;
                }
                if (!bl) {
                    this.reebChildren[n17][n].addEntry(n2);
                }
                bl = false;
            }
        }
    }

    public PgPolygonSet computeReebGraph() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Cannot compute Reeb graph. No geom set. Use method setGeometry(PgElementSet) for this.");
            return null;
        }
        if (this.m_scalar == null) {
            PsDebug.warning((String)"Cannot compute Reeb graph. No function set. Use setHeightFunction, set DijstraFunction or setFunction/getFunction for this.");
            return null;
        }
        this.makeReebGraph();
        this.showReebGraph();
        return this.m_graph;
    }

    protected void showReebGraph() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.reebPoints.getSize();
        int[] nArray = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            nArray[n3] = n4;
            n4 += this.reebPoints.m_data[n3];
        }
        if (this.m_graph == null) {
            this.m_graph = new PgPolygonSet(this.m_geom.getDimOfVertices());
            this.m_graph.setName(PsConfig.getMessage((int)45041) + " " + this.m_geom.getName());
            this.m_graph.setGlobalPolygonColor(Color.green);
        }
        this.m_graph.setNumVertices(n4);
        PdVector[] pdVectorArray = this.m_graph.getVertices();
        for (n3 = 0; n3 < n4; ++n3) {
            pdVectorArray[n3].setConstant(0.0);
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        int n7 = this.m_geom.getNumElements();
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < n7; ++n3) {
            PiVector piVector = piVectorArray[n3];
            n6 = this.elemToReeb[n3].getSize();
            for (n2 = 2; n2 < n6; ++n2) {
                n5 = n2 - 2 + this.elemToReeb[n3].m_data[0];
                n = nArray[n5] + this.elemToReeb[n3].m_data[n2];
                pdVectorArray[n].add(pdVectorArray2[piVector.m_data[0]]);
                int n8 = n;
                nArray2[n8] = nArray2[n8] + 1;
                pdVectorArray[n].add(pdVectorArray2[piVector.m_data[1]]);
                int n9 = n;
                nArray2[n9] = nArray2[n9] + 1;
                pdVectorArray[n].add(pdVectorArray2[piVector.m_data[2]]);
                int n10 = n;
                nArray2[n10] = nArray2[n10] + 1;
            }
        }
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            pdVectorArray[n3].multScalar(1.0 / (double)nArray2[n3]);
        }
        this.m_graph.setNumPolygons(2 * n4);
        this.m_graph.setNumPolygons(0);
        for (n3 = 0; n3 < this.reebParents.length - 1; ++n3) {
            for (n2 = 0; n2 < this.reebParents[n3].length; ++n2) {
                n5 = nArray[n3] + n2;
                n6 = this.reebParents[n3][n2].getSize();
                for (int i = 0; i < n6; ++i) {
                    n = nArray[n3 + 1] + this.reebParents[n3][n2].m_data[i];
                    this.m_graph.addPolygon(new PiVector(n5, n));
                }
            }
        }
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_graph);
        }
        this.m_graph.update((Object)this.m_graph);
        if (this.m_display != null) {
            this.m_display.update((Object)this.m_display);
        }
    }

    protected void makeIsocurves(PdVector pdVector, PgPolygonSet pgPolygonSet) {
        PwIsoline.makeIsolines(this.m_geom, pdVector, pgPolygonSet, this.m_scalar);
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)pgPolygonSet);
        }
        pgPolygonSet.update((Object)pgPolygonSet);
    }

    public static PgPolygonSet makeIsocurves(PgElementSet pgElementSet, PdVector pdVector, PgPolygonSet pgPolygonSet, PdVector pdVector2) {
        PwIsoline.makeIsolines(pgElementSet, pdVector, pgPolygonSet, pdVector2);
        return pgPolygonSet;
    }

    protected void showFunctionAsVertexLabels(boolean bl) {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Double.toString(this.m_scalar.getEntry(i)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Integer.toString(i));
            }
        }
        this.m_geom.showVertices(bl);
        this.m_geom.showVertexLabels(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

