/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.objectGui.PsImage;
import jv.objectGui.PsToolbarItem;

public final class PsToolbar
extends PsPanel {
    public static final int TOOLBAR_ITEMSPERLINE = 13;
    protected static final String[] TOOLBAR_CHOICE = new String[]{"New Geometry", "Open Geometry", "Select Directory", "Save Scene", "Reload Geometry from File", "Burn Material and Lighting as Texture", "Print", "Console", "Help", "Project Panel", "Config Panel", "Info Panel", "Material Panel", "Label Panel", "Texture Panel", "Vector Panel", "Axis Panel", "X-Ruler Panel", "Y-Ruler Panel", "Z-Ruler Panel", "Light Panel", "Camera Panel", "Display Panel", "Rotate", "Scale", "Scale Rectangle", "Translate", "Translate Z-Direction", "Pick Vertex", "Initial Pick", "Add Vertex", "Add Element", "Show Grid", "Camera Distance", "Camera Roll", "Perspectivity", "Camera1", "Camera2", "Animation Panel", "Delete Geometry", "Duplicate Geometry", "Extract", "Mark", "Configure", "Preferences ...", "Help ...", "Item1", "Item2", "Item3", "License ...", "Warning", "Error", "Beginning", "Previous Key", "Fast Rewind", "Rewind", "Stop", "Play", "Fast Play", "Next Key", "End", "Add Key", "Remove Key", "Item5", "Item6", "Item7"};
    public static final int MAX_NUM_ITEMS = 67;
    public static final int TOOLBAR_NEW_GEOMETRY = 0;
    public static final int TOOLBAR_OPEN_GEOMETRY = 1;
    public static final int TOOLBAR_SELECT_DIRECTORY = 2;
    public static final int TOOLBAR_SAVE_SCENE = 3;
    public static final int TOOLBAR_RELOAD_GEOMETRY = 4;
    public static final int TOOLBAR_BURN_TEXTURE = 5;
    public static final int TOOLBAR_PRINT = 6;
    public static final int TOOLBAR_PANEL_CONSOLE = 7;
    public static final int TOOLBAR_PANEL_HELP = 8;
    public static final int TOOLBAR_PANEL_PROJECT = 9;
    public static final int TOOLBAR_PANEL_CONFIG = 10;
    public static final int TOOLBAR_PANEL_INFO = 11;
    public static final int TOOLBAR_PANEL_MATERIAL = 12;
    public static final int TOOLBAR_PANEL_LABEL = 13;
    public static final int TOOLBAR_PANEL_TEXTURE = 14;
    public static final int TOOLBAR_PANEL_VECTOR = 15;
    public static final int TOOLBAR_PANEL_AXIS = 16;
    public static final int TOOLBAR_PANEL_AXIS_X = 17;
    public static final int TOOLBAR_PANEL_AXIS_Y = 18;
    public static final int TOOLBAR_PANEL_AXIS_Z = 19;
    public static final int TOOLBAR_PANEL_LIGHT = 20;
    public static final int TOOLBAR_PANEL_CAMERA = 21;
    public static final int TOOLBAR_PANEL_DISPLAY = 22;
    public static final int TOOLBAR_MODE_ORBIT = 23;
    public static final int TOOLBAR_MODE_SCALE = 24;
    public static final int TOOLBAR_MODE_SCALERECT = 25;
    public static final int TOOLBAR_MODE_TRANS = 26;
    public static final int TOOLBAR_MODE_TRANSZ = 27;
    public static final int TOOLBAR_MODE_PICK = 28;
    public static final int TOOLBAR_MODE_INITIALPICK = 29;
    public static final int TOOLBAR_MODE_ADDVERTEX = 30;
    public static final int TOOLBAR_MODE_ADDELEMENT = 31;
    public static final int TOOLBAR_SHOW_GRID = 32;
    public static final int TOOLBAR_CAMERA_DISTANCE = 33;
    public static final int TOOLBAR_CAMERA_ROLL = 34;
    public static final int TOOLBAR_CAMERA_PERSPECTIVE = 35;
    public static final int TOOLBAR_CAMERA1 = 36;
    public static final int TOOLBAR_CAMERA2 = 37;
    public static final int TOOLBAR_PANEL_ANIMATION = 38;
    public static final int TOOLBAR_DELETE = 39;
    public static final int TOOLBAR_DUPLICATE = 40;
    public static final int TOOLBAR_EXTRACT = 41;
    public static final int TOOLBAR_MARK = 42;
    public static final int TOOLBAR_CONFIGURE = 43;
    public static final int TOOLBAR_PREFERENCES = 44;
    public static final int TOOLBAR_HELP = 45;
    public static final int TOOLBAR_ITEM1 = 46;
    public static final int TOOLBAR_ITEM2 = 47;
    public static final int TOOLBAR_ITEM3 = 48;
    public static final int TOOLBAR_LICENSE = 49;
    public static final int TOOLBAR_WARNING = 50;
    public static final int TOOLBAR_ERROR = 51;
    public static final int TOOLBAR_ANIM_START = 52;
    public static final int TOOLBAR_ANIM_PREVKEY = 53;
    public static final int TOOLBAR_ANIM_FASTREWIND = 54;
    public static final int TOOLBAR_ANIM_REWIND = 55;
    public static final int TOOLBAR_ANIM_STOP = 56;
    public static final int TOOLBAR_ANIM_PLAY = 57;
    public static final int TOOLBAR_ANIM_FASTPLAY = 58;
    public static final int TOOLBAR_ANIM_NEXTKEY = 59;
    public static final int TOOLBAR_ANIM_END = 60;
    public static final int TOOLBAR_ANIM_ADDKEY = 61;
    public static final int TOOLBAR_ANIM_REMOVEKEY = 62;
    public static final int TOOLBAR_ITEM5 = 63;
    public static final int TOOLBAR_ITEM6 = 64;
    public static final int TOOLBAR_ITEM7 = 65;
    public static final int TOOLBAR_PANEL_CONTROL = 66;
    protected static final int[] IMAGE_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66};
    protected static Image m_imgToolbar;
    protected static int m_iconSize;
    protected static int m_iconIncr;
    private static boolean m_bHasBeenTested;

    public PsToolbar() {
        m_imgToolbar = null;
        this.init();
    }

    public void init() {
        int n = 0;
        int n2 = 3;
        this.setBackground(new Color(227, 227, 227));
        this.setInsetSize(n2);
        this.setBorderType(4);
        PsStackLayout psStackLayout = new PsStackLayout(n);
        psStackLayout.setType(false);
        this.setLayout(psStackLayout);
    }

    public void addItem(int n, ActionListener actionListener) {
        PsToolbarItem psToolbarItem = new PsToolbarItem(n);
        psToolbarItem.addActionListener(actionListener);
        psToolbarItem.setChoice(TOOLBAR_CHOICE[n]);
        this.add(psToolbarItem);
    }

    public void addGuide() {
        this.addLine(1, 2);
    }

    public void addSeparator() {
        this.addLine(1, 1);
    }

    public static boolean loadDefaultImage() {
        if (!m_bHasBeenTested) {
            int n = 16;
            int n2 = n >> 4;
            PsToolbar.loadImage(PsConfig.getImageToolbar(), n, n2);
        }
        return m_imgToolbar != null;
    }

    public static void loadImage(String string, int n, int n2) {
        if (string == null) {
            PsDebug.warning("missing image file");
            return;
        }
        if (m_imgToolbar != null || m_bHasBeenTested) {
            return;
        }
        m_bHasBeenTested = true;
        m_iconSize = n;
        m_iconIncr = n2;
        m_imgToolbar = PsImage.getImageResource(string);
        if (m_imgToolbar == null) {
            PsDebug.warning("failed loading image = " + string);
            try {
                m_imgToolbar = PsImage.getImage(PsConfig.getCodeBase() + string);
                PsImage.loadImage(PsConfig.getApplet(), m_imgToolbar);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Image getImage(Component component, int n) {
        if (!m_bHasBeenTested) {
            PsToolbar.loadDefaultImage();
        }
        if (m_imgToolbar == null) {
            return null;
        }
        if (n < 0 || IMAGE_INDEX.length <= n) {
            PsDebug.warning("index of image icon out of bounds, imgId = " + String.valueOf(n));
            return null;
        }
        int n2 = IMAGE_INDEX[n];
        int n3 = n2 % 13;
        int n4 = n2 / 13;
        int[] nArray = PsImage.getPixels(m_imgToolbar, n3 * (m_iconSize + m_iconIncr), n4 * (m_iconSize + m_iconIncr), m_iconSize, m_iconSize, null, 0, m_iconSize);
        Image image = PsImage.createImageFromPixels(component, nArray, m_iconSize, m_iconSize, 0, m_iconSize);
        return image;
    }

    static {
        m_bHasBeenTested = false;
    }
}

