/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public abstract class PsMethodMenu
extends Vector
implements ActionListener,
ItemListener,
PsUpdateIf {
    protected String m_name;
    private transient PsObject m_parent;
    protected int m_panelVersion;
    protected String m_language;
    Vector m_subMenu = new Vector();

    public PsMethodMenu() {
        this.m_panelVersion = PsConfig.getPanelVersion();
        this.m_language = PsConfig.getLanguage();
    }

    public void init(PsObject psObject) {
        this.m_parent = psObject;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = (PsObject)psUpdateIf;
    }

    public void setName(String string) {
        if (string == null) {
            PsDebug.warning("missing name");
            return;
        }
        this.m_name = string;
    }

    public String getName() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public boolean update(Object object) {
        return object != null && object == this.m_parent;
    }

    public Object clone() {
        PsMethodMenu psMethodMenu = (PsMethodMenu)super.clone();
        if (psMethodMenu == null) {
            return null;
        }
        psMethodMenu.m_parent = null;
        psMethodMenu.removeAllElements();
        return psMethodMenu;
    }

    public int getPanelVersion() {
        return this.m_panelVersion;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_parent == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        this.applyMethod(string);
        this.m_parent.update(this.m_parent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_parent == null) {
            return;
        }
        String string = (String)itemEvent.getItem();
        this.applyMethod(string);
        this.m_parent.update(this.m_parent);
    }

    public boolean applyMethod(String string) {
        return false;
    }

    public Menu getMenu(String string) {
        Menu menu;
        int n;
        if (string == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            menu = (Menu)this.elementAt(n);
            if (!string.equals(menu.getLabel())) continue;
            return menu;
        }
        n2 = this.m_subMenu.size();
        for (n = 0; n < n2; ++n) {
            menu = (Menu)this.m_subMenu.elementAt(n);
            if (!string.equals(menu.getLabel())) continue;
            return menu;
        }
        return null;
    }

    public boolean hasMenu(String string) {
        return this.getMenu(string) != null;
    }

    public Menu addMenu(String string) {
        if (string == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        Menu menu = this.getMenu(string);
        if (menu != null) {
            return menu;
        }
        menu = new Menu(string);
        this.addElement(menu);
        return menu;
    }

    public Menu addMenu(String string, String string2) {
        Menu menu = this.getMenu(string);
        if (menu == null) {
            PsDebug.warning("parent menu does not exist, name = " + string);
            return null;
        }
        if (string2 == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        Menu menu2 = this.getMenu(string2);
        if (menu2 != null) {
            return menu2;
        }
        menu2 = new Menu(string2);
        menu.add(menu2);
        this.m_subMenu.addElement(menu2);
        return menu2;
    }

    public void removeMenu(String string) {
        if (string == null) {
            PsDebug.warning("missing argument");
            return;
        }
        Menu menu = this.getMenu(string);
        this.removeElement(menu);
    }

    protected static int getIndexOfMethod(String[] stringArray, String string) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public MenuItem getMenuItem(String string, String string2) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Menu menu = this.getMenu(string);
        if (menu == null) {
            return null;
        }
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = menu.getItem(i);
            if (!string2.equals(menuItem.getLabel())) continue;
            return menuItem;
        }
        return null;
    }

    public boolean hasMenuItem(String string, String string2) {
        return this.getMenuItem(string, string2) != null;
    }

    public MenuItem addMenuItem(String string, String string2, MenuShortcut menuShortcut) {
        return this.insertMenuItem(-1, string, string2, menuShortcut);
    }

    protected MenuItem insertMenuItem(int n, String string, String string2, MenuShortcut menuShortcut) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        MenuItem menuItem = this.getMenuItem(string, string2);
        if (menuItem != null) {
            return menuItem;
        }
        Menu menu = this.getMenu(string);
        if (menu == null) {
            PsDebug.warning("missing menu = " + string);
            return null;
        }
        menuItem = menuShortcut == null ? new MenuItem(string2) : new MenuItem(string2, menuShortcut);
        menuItem.addActionListener(this);
        menuItem.setActionCommand(string2);
        if (n < 0) {
            menu.add(menuItem);
        } else {
            menu.insert(menuItem, n);
        }
        return menuItem;
    }

    public MenuItem addMenuItem(String string, String string2) {
        return this.addMenuItem(string, string2, null);
    }

    public CheckboxMenuItem addMenuItem(String string, String string2, boolean bl) {
        return this.insertMenuItem(-1, string, string2, bl);
    }

    protected CheckboxMenuItem insertMenuItem(int n, String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, string2);
        if (checkboxMenuItem != null) {
            checkboxMenuItem.setState(bl);
            return checkboxMenuItem;
        }
        checkboxMenuItem = new CheckboxMenuItem(string2, bl);
        checkboxMenuItem.addItemListener(this);
        Menu menu = this.getMenu(string);
        if (menu == null) {
            PsDebug.warning("missing menu = " + string);
            return null;
        }
        if (n < 0) {
            menu.add(checkboxMenuItem);
        } else {
            menu.insert(checkboxMenuItem, n);
        }
        return checkboxMenuItem;
    }

    public void removeMenuItem(String string, String string2) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (!this.hasMenuItem(string, string2)) {
            return;
        }
        Menu menu = this.getMenu(string);
        MenuItem menuItem = this.getMenuItem(string, string2);
        menuItem.removeActionListener(this);
        menu.remove(menuItem);
    }
}

