/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class PsStackLayout
implements LayoutManager,
Serializable {
    public static final boolean VERTICAL = true;
    public static final boolean HORIZONTAL = false;
    private int m_gap;
    protected boolean m_bVertical;

    public PsStackLayout(int n) {
        this.m_gap = n;
        this.m_bVertical = true;
    }

    public void setType(boolean bl) {
        this.m_bVertical = bl;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private Dimension computeLayoutSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        if (this.m_bVertical) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
                if (i == 0) continue;
                n3 += this.m_gap;
            }
            Insets insets = container.getInsets();
            return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            n4 = Math.max(n4, dimension.height);
            n5 += dimension.width;
            if (i == 0) continue;
            n5 += this.m_gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n5, insets.top + insets.bottom + n4);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, true);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        if (this.m_bVertical) {
            int n2 = container.getSize().width - (insets.left + insets.right);
            int n3 = insets.top;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                component.setBounds(insets.left, n3, n2, dimension.height);
                n3 += dimension.height + this.m_gap;
            }
        } else {
            int n4;
            Dimension dimension;
            Component component;
            int n5 = container.getSize().height - (insets.top + insets.bottom);
            int n6 = container.getSize().width - (insets.left + insets.right);
            int n7 = insets.left;
            for (int i = 0; i < n - 1; ++i) {
                component = container.getComponent(i);
                dimension = component.getPreferredSize();
                n4 = insets.top + (n5 - dimension.height >> 1);
                component.setBounds(n7, n4, dimension.width, dimension.height);
                n7 += dimension.width + this.m_gap;
            }
            component = container.getComponent(n - 1);
            dimension = component.getPreferredSize();
            n4 = insets.top + (n5 - dimension.height >> 1);
            component.setBounds(n7, n4, n6 - n7, dimension.height);
        }
    }

    public void removeLayoutComponent(Component component) {
    }
}

