/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.List;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.loader.PgAbstractLoader;
import jv.loader.PgExport_Dialog;
import jv.loader.PgHtmlLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PgMathLoader;
import jv.loader.PgStlLoader;
import jv.loader.PsImageCoderIf;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.acmeEncoders.GifEncoder;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.PpmEncoder;

public final class PgLoader {
    protected PvDisplayOption[] m_displayOption;
    protected BitSet m_geometryOption;
    protected boolean m_bIsAnimated;
    protected boolean m_bShowAnimationPanel;
    protected boolean m_bIsEnabledOptimization;
    public static final int NUM_GEOMETRY_TAGS = 10;
    static /* synthetic */ Class class$jv$geom$PgPolygon;
    static /* synthetic */ Class class$jv$geom$PgPolygonSet;
    static /* synthetic */ Class class$jv$geom$PgElementSet;
    static /* synthetic */ Class class$jv$geom$PgPointSet;

    public PgLoader() {
        this.init();
    }

    public void init() {
        this.m_displayOption = null;
        this.m_bIsAnimated = false;
        this.m_bShowAnimationPanel = true;
        this.m_bIsEnabledOptimization = true;
    }

    public boolean getTag(int n) {
        if (this.m_geometryOption == null) {
            return false;
        }
        return this.m_geometryOption.get(n);
    }

    public void setTag(int n, boolean bl) {
        if (bl) {
            if (this.m_geometryOption == null) {
                this.m_geometryOption = new BitSet(10);
            }
            this.m_geometryOption.set(n);
        } else {
            if (this.m_geometryOption == null) {
                return;
            }
            this.m_geometryOption.clear(n);
        }
    }

    public boolean isEnabledOptimization() {
        return this.m_bIsEnabledOptimization;
    }

    public void setEnabledOptimization(boolean bl) {
        this.m_bIsEnabledOptimization = bl;
    }

    public boolean isAnimated() {
        return this.m_bIsAnimated;
    }

    public void setAnimated(boolean bl) {
        this.m_bIsAnimated = bl;
    }

    public PvDisplayOption getDisplayOption() {
        if (this.m_displayOption == null || this.m_displayOption.length <= 0) {
            return null;
        }
        return this.m_displayOption[0];
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.setDisplayOptions(new PvDisplayOption[]{pvDisplayOption});
    }

    public PvDisplayOption[] getDisplayOptions() {
        return this.m_displayOption;
    }

    public void setDisplayOptions(PvDisplayOption[] pvDisplayOptionArray) {
        this.m_displayOption = pvDisplayOptionArray;
    }

    public PgGeometry[] loadGeometry(String string, String string2) {
        return this.loadGeometry(null, string, string2);
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing argument: data");
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        pgGeometryArray = this.loadGeometry(pgGeometryArray, bufferedReader, string2);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pgGeometryArray;
    }

    public PgGeometry[] loadGeometry(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        return this.loadGeometry((PgGeometry[])null, string);
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, String string) {
        int n;
        String[] stringArray;
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file=" + string);
            return null;
        }
        string2 = string2.toLowerCase();
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        boolean bl = false;
        if (string2.indexOf("stl") != -1) {
            try {
                boolean bl2 = bl = !PgStlLoader.isAscii(bufferedReader);
                if (bl) {
                    bufferedReader.reset();
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("Failed reading first five characters.");
            }
        }
        if (!bl) {
            pgGeometryArray = this.loadGeometry(pgGeometryArray, bufferedReader, string2);
        } else {
            PgJvxSrc[] pgJvxSrcArray = null;
            try {
                DataInputStream dataInputStream = PsUtil.open_as_DataInputStream(string);
                stringArray = (PgAbstractLoader)PgLoader.getLoader(string2);
                pgJvxSrcArray = stringArray.read(dataInputStream);
                dataInputStream.close();
            }
            catch (Exception exception) {
                PsDebug.warning("Exception thrown in PgLoader read binary.");
            }
            if (pgJvxSrcArray == null) {
                PsDebug.warning("error when reading file = " + string);
                return null;
            }
            pgGeometryArray = new PgGeometry[pgJvxSrcArray.length];
            for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                pgGeometryArray[i] = PgLoader.assureType(pgGeometryArray[i], pgJvxSrcArray[i].getType(), pgJvxSrcArray[i].getDimOfVertices());
                pgGeometryArray[i].setJvx(pgJvxSrcArray[i]);
                if (!this.isEnabledOptimization()) continue;
                PuCleanMesh.identifyVertices(pgGeometryArray[i]);
            }
        }
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pgGeometryArray == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        for (n = 0; n < pgGeometryArray.length; ++n) {
            String string3;
            if (pgGeometryArray[n] == null || (string3 = pgGeometryArray[n].getName()) != null && !string3.toLowerCase().startsWith("object_")) continue;
            stringArray = PsUtil.getFileBaseName(string);
            if (n == 0) {
                pgGeometryArray[n].setName((String)stringArray);
                continue;
            }
            pgGeometryArray[n].setName((String)stringArray + "[" + n + "]");
        }
        if (string2.indexOf("jvx") != -1 || string2.indexOf("obj") != -1 || string2.indexOf("wrl") != -1 || string2.indexOf("vrml") != -1) {
            for (n = 0; n < pgGeometryArray.length; ++n) {
                String string4 = pgGeometryArray[n].getTextureImageName();
                if (string4 == null) continue;
                stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getCodeBase()};
                Image image = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    image = this.loadImageFromPath(stringArray[i], string4);
                    if (image == null) continue;
                    pgGeometryArray[n].setTextureImage(image);
                    pgGeometryArray[n].setTextureImageName(stringArray[i] + string4);
                    break;
                }
                if (image != null) continue;
                PsDebug.warning("failed loading texture image = " + string4 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
            }
        }
        return pgGeometryArray;
    }

    private Image loadImageFromPath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Image image = PsImage.getImage(string + string2);
        if (image != null && !PsImage.loadImage(PsConfig.getFrame(), image)) {
            return null;
        }
        return image;
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        string = string.toLowerCase();
        this.setDisplayOptions(null);
        try {
            if (string.indexOf("mgs") != -1 || string.equalsIgnoreCase("m")) {
                PgMathLoader pgMathLoader = new PgMathLoader();
                if (this.isAnimated()) {
                    pgMathLoader.setKeyAnimation(true);
                }
                if (!pgMathLoader.load(bufferedReader)) {
                    PsDebug.warning("loading failed");
                    return null;
                }
                this.setDisplayOption(pgMathLoader.getDisplayOption());
                PgJvxSrc[][] pgJvxSrcArray = pgMathLoader.getAnimations();
                if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null || pgJvxSrcArray[0].length == 0) {
                    PsDebug.warning("missing animations");
                    return null;
                }
                if (pgMathLoader.isAnimation() || pgMathLoader.isKeyAnimation()) {
                    pgGeometryArray = this.readAnimation(pgJvxSrcArray, this.m_bShowAnimationPanel);
                } else {
                    PgJvxSrc[] pgJvxSrcArray2 = pgJvxSrcArray[0];
                    pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray2.length);
                    for (int i = 0; i < pgJvxSrcArray2.length; ++i) {
                        pgGeometryArray[i] = PgLoader.assureType(pgGeometryArray[i], pgJvxSrcArray2[i].getType(), pgJvxSrcArray2[i].getDimOfVertices());
                        pgGeometryArray[i].setJvx(pgJvxSrcArray2[i]);
                        if (!this.isEnabledOptimization() || !pgMathLoader.isEnabledOptimization()) continue;
                        PuCleanMesh.identifyVertices(pgGeometryArray[i]);
                    }
                }
            } else {
                if (string.indexOf("jvd") != -1) {
                    this.loadDisplay(bufferedReader, "jvd");
                    return null;
                }
                PgLoaderIf pgLoaderIf = PgLoader.getLoader(string);
                if (pgLoaderIf == null) {
                    PsDebug.warning("unknown file extension = \"" + string + "\", no loader found");
                    return null;
                }
                if (this.isAnimated()) {
                    pgLoaderIf.setAnimation(true);
                }
                if (!pgLoaderIf.load(bufferedReader)) {
                    PsDebug.warning("loading failed");
                    return null;
                }
                this.setDisplayOption(pgLoaderIf.getDisplayOption());
                if (pgLoaderIf.isAnimation()) {
                    PgJvxSrc[][] pgJvxSrcArray = pgLoaderIf.getAnimations();
                    if (pgJvxSrcArray == null) {
                        PgJvxSrc[] pgJvxSrcArray3 = pgLoaderIf.getGeometries();
                        if (pgJvxSrcArray3 == null || pgJvxSrcArray3.length == 0) {
                            PsDebug.warning("missing geometries");
                            return null;
                        }
                        pgGeometryArray = this.readAnimation(pgJvxSrcArray3, this.m_bShowAnimationPanel);
                    } else {
                        if (pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null || pgJvxSrcArray[0].length == 0) {
                            PsDebug.warning("incomplete animation array");
                            return null;
                        }
                        pgGeometryArray = this.readAnimation(pgJvxSrcArray, this.m_bShowAnimationPanel);
                    }
                } else {
                    PgGeometryIf[] pgGeometryIfArray = pgLoaderIf.getSpecializedGeometries();
                    if (pgGeometryIfArray != null) {
                        pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgGeometryIfArray.length);
                        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                            pgGeometryArray[i] = (PgGeometry)pgGeometryIfArray[i];
                        }
                    } else {
                        PgJvxSrc[] pgJvxSrcArray = pgLoaderIf.getGeometries();
                        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                            PsDebug.warning("missing geometries");
                            return null;
                        }
                        pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
                        boolean bl = pgLoaderIf.isEnabledOptimization();
                        pgLoaderIf = null;
                        if (PsConfig.isApplication()) {
                            PsConfig.runGC();
                        }
                        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                            pgGeometryArray[i] = PgLoader.assureType(pgGeometryArray[i], pgJvxSrcArray[i].getType(), pgJvxSrcArray[i].getDimOfVertices());
                            pgGeometryArray[i].setEnabledInstanceSharing(true);
                            pgGeometryArray[i].setJvx(pgJvxSrcArray[i]);
                            pgGeometryArray[i].setEnabledInstanceSharing(false);
                            pgJvxSrcArray[i] = null;
                            if (!this.isEnabledOptimization() || !bl || !PsJavaView.m_bAutoIdentify) continue;
                            PuCleanMesh.identifyVertices(pgGeometryArray[i]);
                        }
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PsDebug.outOfMemory(outOfMemoryError);
        }
        if (PsConfig.isApplication()) {
            PsConfig.runGC();
        }
        return pgGeometryArray;
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string, String string2) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, string, string2);
    }

    public static PgGeometry[] load(String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry((PgGeometry[])null, string);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, string);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, BufferedReader bufferedReader, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, bufferedReader, string);
    }

    public static PvDisplayOption[] load(BufferedReader bufferedReader, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadDisplay(bufferedReader, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PvDisplayOption[] loadDisplay(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null || !string2.equalsIgnoreCase("jvd")) {
            PsDebug.warning("missing or wrong extension in file=" + string);
            return null;
        }
        string2 = string2.toLowerCase();
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = null;
        try {
            pvDisplayOptionArray = this.loadDisplay(bufferedReader, string2);
        }
        catch (Exception exception) {
            PsDebug.warning("exception when reading file = " + string, exception);
            PvDisplayOption[] pvDisplayOptionArray2 = null;
            return pvDisplayOptionArray2;
        }
        finally {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {}
        }
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
            int n;
            Image image;
            String[] stringArray;
            if (pvDisplayOptionArray[i] == null) continue;
            String string3 = pvDisplayOptionArray[i].getBackgroundImageFile();
            if (string3 != null) {
                stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getInstBase(), PsConfig.getCodeBase()};
                if (pvDisplayOptionArray[i].getOption(10)) {
                    image = null;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n] == null || (image = this.loadImageFromPath(stringArray[n], string3)) == null) continue;
                        pvDisplayOptionArray[i].setBackgroundImage(image);
                        pvDisplayOptionArray[i].setBackgroundImageFile(stringArray[n] + string3);
                        break;
                    }
                    if (image == null) {
                        PsDebug.warning("failed loading background image = " + string3 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
                    }
                } else {
                    pvDisplayOptionArray[i].setBackgroundImageFile(stringArray[0] + string3);
                }
            } else {
                pvDisplayOptionArray[i].setBackgroundImage(null);
                pvDisplayOptionArray[i].setBackgroundImageFile(null);
            }
            string3 = pvDisplayOptionArray[i].getForegroundImageFile();
            if (string3 != null) {
                stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getInstBase(), PsConfig.getCodeBase()};
                if (pvDisplayOptionArray[i].getOption(19)) {
                    image = null;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n] == null || (image = this.loadImageFromPath(stringArray[n], string3)) == null) continue;
                        pvDisplayOptionArray[i].setForegroundImage(image);
                        pvDisplayOptionArray[i].setForegroundImageFile(stringArray[n] + string3);
                        break;
                    }
                    if (image != null) continue;
                    PsDebug.warning("failed loading foreground image = " + string3 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
                    continue;
                }
                pvDisplayOptionArray[i].setForegroundImageFile(stringArray[0] + string3);
                continue;
            }
            pvDisplayOptionArray[i].setForegroundImage(null);
            pvDisplayOptionArray[i].setForegroundImageFile(null);
        }
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] loadDisplay(BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        if ((string = string.toLowerCase()).indexOf("jvd") == -1) {
            PsDebug.warning("wrong format for display options, ext = " + string);
            return null;
        }
        try {
            if (!bufferedReader.ready()) {
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("exception = " + iOException.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        PvDisplayOption[] pvDisplayOptionArray = pvDisplayLoader.read(bufferedReader);
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("reading of display from reader");
            return null;
        }
        this.setDisplayOption(pvDisplayOptionArray[0]);
        return pvDisplayOptionArray;
    }

    private static PgGeometry[] assureLength(PgGeometry[] pgGeometryArray, int n) {
        if (pgGeometryArray == null) {
            return new PgGeometry[n];
        }
        if (n == pgGeometryArray.length) {
            return pgGeometryArray;
        }
        PgGeometry[] pgGeometryArray2 = new PgGeometry[n];
        for (int i = 0; i < Math.min(n, pgGeometryArray.length); ++i) {
            pgGeometryArray2[i] = pgGeometryArray[i];
        }
        return pgGeometryArray2;
    }

    private static PgGeometry assureType(PgGeometry pgGeometry, int n, int n2) {
        if (pgGeometry != null && pgGeometry.getDimOfVertices() != n2) {
            pgGeometry = null;
        }
        switch (n) {
            case 31: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPolygon == null ? (class$jv$geom$PgPolygon = PgLoader.class$("jv.geom.PgPolygon")) : class$jv$geom$PgPolygon)) break;
                pgGeometry = new PgPolygon(n2);
                break;
            }
            case 32: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPolygonSet == null ? (class$jv$geom$PgPolygonSet = PgLoader.class$("jv.geom.PgPolygonSet")) : class$jv$geom$PgPolygonSet)) break;
                pgGeometry = new PgPolygonSet(n2);
                break;
            }
            case 33: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgElementSet == null ? (class$jv$geom$PgElementSet = PgLoader.class$("jv.geom.PgElementSet")) : class$jv$geom$PgElementSet)) break;
                pgGeometry = new PgElementSet(n2);
                break;
            }
            case 34: {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("dev.volume.PgTetraSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (pgGeometry != null && pgGeometry.getClass() == clazz || clazz == null) break;
                pgGeometry = (PgGeometry)PsUtil.newInstance("dev.volume.PgTetraSet");
                pgGeometry.setDimOfVertices(n2);
                ((PgPointSet)pgGeometry).setDimOfTextures(3);
                break;
            }
            default: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPointSet == null ? (class$jv$geom$PgPointSet = PgLoader.class$("jv.geom.PgPointSet")) : class$jv$geom$PgPointSet)) break;
                pgGeometry = new PgPointSet(n2);
            }
        }
        return pgGeometry;
    }

    public String saveGeometryToString(PgGeometry[] pgGeometryArray, String string) {
        PgLoaderIf pgLoaderIf;
        if (pgGeometryArray == null || pgGeometryArray.length == 0) {
            PsDebug.warning("missing geometry to save.");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing file name extension.");
            return null;
        }
        if ((string = string.toLowerCase()).equalsIgnoreCase("byu") || string.equalsIgnoreCase("dxf") || string.equalsIgnoreCase("fe") || string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("mpl") || string.equalsIgnoreCase("obj") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("stl")) {
            if (pgGeometryArray.length > 1) {
                PsDebug.warning("only the active geometry of the scene is saved\n\tbecause restriction of the file format resp. export module\n\tUse JVX format to save more geometries in a single file.");
            }
            if ((string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("stl")) && !(pgGeometryArray[0] instanceof PgJvxSrc) && !(pgGeometryArray[0] instanceof PgElementSet)) {
                PsDebug.warning("format does not save other geometries besides surfaces, ext = " + string);
                return null;
            }
        }
        if ((pgLoaderIf = PgLoader.getLoader(string)) == null) {
            PsDebug.warning("unknown file extension, no loader found");
            return null;
        }
        if (this.getDisplayOption() != null) {
            pgLoaderIf.setDisplayOption(this.getDisplayOption());
        }
        PgGeometryIf[] pgGeometryIfArray = (PgGeometry[])pgGeometryArray.clone();
        if (!string.equalsIgnoreCase("jvx")) {
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                if (pgGeometryIfArray[i] == null || pgGeometryIfArray[i] instanceof PgJvxSrc || ((PgGeometry)pgGeometryIfArray[i]).getAmbientProjection() != 0) continue;
                ((PgGeometry)pgGeometryIfArray[i]).projectFromAmbientSpace();
            }
        }
        PgJvxSrc[] pgJvxSrcArray = PgLoader.assureJvx(pgGeometryIfArray);
        StringWriter stringWriter = new StringWriter();
        try {
            if (!pgLoaderIf.write(stringWriter, pgJvxSrcArray)) {
                PsDebug.warning("error during export.");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed writing to writer,", iOException);
        }
        return stringWriter.toString();
    }

    public static String saveToString(PgGeometryIf[] pgGeometryIfArray, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveGeometryToString((PgGeometry[])pgGeometryIfArray, string);
    }

    private static PgLoaderIf getLoader(String string) {
        if (string.endsWith(".gz") || string.endsWith(".zip")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if (PuString.isEmpty(string)) {
            PsDebug.warning("extension must have the form *.ext or *.ext.gz or *.ext.zip\n\twhere 'ext' is one of the supported geometry file formats.");
            return null;
        }
        String string2 = string.equalsIgnoreCase("mpl") ? "Maple" : (string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("m") ? "Math" : (string.equalsIgnoreCase("wrl") || string.equalsIgnoreCase("vrml") ? "Wrl" : (string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("geom") ? "Byu" : String.valueOf(string.charAt(0)).toUpperCase() + string.substring(1, string.length()))));
        String string3 = "Pg" + string2 + "Loader";
        Object object = PsUtil.newInstance("jv.loader." + string3);
        if (object == null && PsConfig.hasArchive(1)) {
            object = PsUtil.newInstance("jvx.loader." + string3);
        }
        if (object == null && PsConfig.hasArchive(2)) {
            object = PsUtil.newInstance("vgp.tutor.loader." + string3);
        }
        if (object == null && PsConfig.hasArchive(3)) {
            object = PsUtil.newInstance("dev.loader." + string3);
        }
        if (object == null && !PuString.isEmpty(PsJavaView.getDirectory(9))) {
            object = PsUtil.newInstance(PsJavaView.getDirectory(9) + "." + string3);
        }
        if (object != null && !(object instanceof PgLoaderIf)) {
            PsDebug.warning("loader does not support interface jv.loader.PgLoaderIf, loader = " + string3);
            return null;
        }
        return (PgLoaderIf)object;
    }

    private static PgJvxSrc[] assureJvx(PgGeometryIf[] pgGeometryIfArray) {
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[pgGeometryIfArray.length];
        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
            if (pgGeometryIfArray[i] == null) {
                PsDebug.warning("missing geometry at index i = " + i);
                continue;
            }
            if (pgGeometryIfArray[i] instanceof PgJvxSrc) {
                pgJvxSrcArray[i] = (PgJvxSrc)pgGeometryIfArray[i];
                continue;
            }
            ((PgGeometry)pgGeometryIfArray[i]).setEnabledInstanceSharing(true);
            pgJvxSrcArray[i] = pgGeometryIfArray[i].getJvx();
            ((PgGeometry)pgGeometryIfArray[i]).setEnabledInstanceSharing(false);
            if (pgJvxSrcArray[i] != null) continue;
            PsDebug.warning("failed to create jvx source of geom = " + pgGeometryIfArray[i].getName());
        }
        return pgJvxSrcArray;
    }

    public boolean saveGeometry(PgGeometry[] pgGeometryArray, String string) {
        if (pgGeometryArray == null) {
            PsDebug.warning("missing geometries");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        string2 = string2.toLowerCase();
        PgGeometryIf[] pgGeometryIfArray = (PgGeometry[])pgGeometryArray.clone();
        if (!string2.equalsIgnoreCase("jvx")) {
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                if (pgGeometryIfArray[i] == null || pgGeometryIfArray[i] instanceof PgJvxSrc) continue;
                if (pgGeometryIfArray[i].getAmbientProjection() != 0) {
                    pgGeometryIfArray[i].projectFromAmbientSpace();
                    continue;
                }
                pgGeometryIfArray[i].setDimOfVertices(Math.min(pgGeometryIfArray[i].getDimOfVertices(), 3));
            }
        }
        String[] stringArray = new String[pgGeometryIfArray.length];
        if (PsConfig.isApplication()) {
            Object object;
            Closeable closeable;
            Object object2;
            Object object3;
            boolean bl = true;
            if (this.m_geometryOption != null) {
                bl = this.m_geometryOption.get(5);
            }
            String string3 = PsUtil.getFilePath(string);
            String string4 = PsUtil.getFileBaseName(string);
            if (string3 == null || string4 == null) {
                PsDebug.warning("unable to extract path or base name of file name = " + string);
                bl = false;
            }
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = PsConfig.hasArchive(3);
                String string5 = bl3 ? ".jpg" : ".gif";
                for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                    object3 = pgGeometryIfArray[i].getTextureImage();
                    if (object3 == null) continue;
                    if (!(string2.equalsIgnoreCase("jvx") || string2.equalsIgnoreCase("jvf") || string2.equalsIgnoreCase("jvz") || string2.equalsIgnoreCase("wrl"))) {
                        if (string2.equalsIgnoreCase("obj")) {
                            PsDebug.warning("Texture coordinates and image saved,\n but OBJ file will only know the texture coordinates\n and not the name of the image file.");
                        } else {
                            PsDebug.warning("geometry format does not know about texture. Texture image saved anyway.");
                        }
                    }
                    object2 = pgGeometryIfArray[i].getTextureImageName();
                    stringArray[i] = object2;
                    if (object2 == null) {
                        object2 = ((PsObject)((Object)pgGeometryIfArray[i])).getName() + string5;
                        if (string5.equals(".gif")) {
                            bl2 = true;
                        }
                    } else {
                        object2 = PsUtil.getFileName((String)object2);
                        if (!bl3 && !((String)object2).endsWith(".gif")) {
                            object2 = (String)object2 + ".gif";
                            bl2 = true;
                        } else if (bl3 && !((String)object2).endsWith(".jpg") && !((String)object2).endsWith(".gif")) {
                            object2 = (String)object2 + ".jpg";
                            bl2 = true;
                        }
                    }
                    if (!((String)object2).startsWith(string4)) {
                        object2 = string4 + "_" + (String)object2;
                    }
                    ((PgGeometry)pgGeometryIfArray[i]).setTextureImageName((String)object2);
                    String string6 = string3 + (String)object2;
                    this.saveImage((Image)object3, string6);
                    if (!bl2) continue;
                    PsDebug.warning("currently, texture is always saved in GIF format.");
                    String string7 = string6.substring(0, string6.lastIndexOf(46)) + ".ppm";
                    this.saveImage((Image)object3, string7);
                }
            }
            boolean bl4 = false;
            if (string2.equalsIgnoreCase("u3d") || string2.equalsIgnoreCase("pdf")) {
                closeable = null;
                try {
                    object = new FileOutputStream(string);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                    closeable = new DataOutputStream(bufferedOutputStream);
                    object3 = PgLoader.getLoader(string2);
                    if (object3 == null) {
                        PsDebug.warning("unknown file extension, no loader found");
                        ((FilterOutputStream)closeable).close();
                        return false;
                    }
                    if (this.m_geometryOption != null) {
                        object3.setGeometryOption(this.m_geometryOption);
                    }
                    if (this.getDisplayOption() != null) {
                        object3.setDisplayOption(this.getDisplayOption());
                    }
                    object2 = PgLoader.assureJvx(pgGeometryIfArray);
                    bl4 = object3.write((DataOutputStream)closeable, (PgJvxSrc[])object2);
                    ((FilterOutputStream)closeable).close();
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed writing to outWriter,", iOException);
                }
                closeable = null;
            } else {
                closeable = PsUtil.writeFile(string);
                if (closeable == null) {
                    PsDebug.warning("could not open file = " + string);
                    return false;
                }
                try {
                    Object object4;
                    if (string2.equalsIgnoreCase("html")) {
                        object = string.substring(0, string.lastIndexOf(".html"));
                        this.saveGeometry((PgGeometry[])pgGeometryIfArray, (String)object + ".jvx");
                        object4 = new Dimension(400, 300);
                        object3 = this.getDisplayOption();
                        if (object3 != null) {
                            this.saveDisplay(this.m_displayOption, (String)object + ".jvd");
                            object4 = ((PvDisplayOption)object3).getWindowSize();
                        }
                        object = PsUtil.getFileName((String)object);
                        bl4 = PgHtmlLoader.write((Writer)closeable, (String)object + ".jvx", (String)object + ".jvd", object4.width, object4.height);
                    } else {
                        object = PgLoader.getLoader(string2);
                        if (object == null) {
                            PsDebug.warning("unknown file extension, no loader found");
                            ((PrintWriter)closeable).close();
                            return false;
                        }
                        if (this.m_geometryOption != null) {
                            object.setGeometryOption(this.m_geometryOption);
                        }
                        if (this.getDisplayOption() != null) {
                            object.setDisplayOption(this.getDisplayOption());
                        }
                        object4 = PgLoader.assureJvx(pgGeometryIfArray);
                        bl4 = object.write((Writer)closeable, (PgJvxSrc[])object4);
                    }
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed writing to writer,", iOException);
                }
                ((PrintWriter)closeable).close();
                closeable = null;
            }
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                object = pgGeometryIfArray[i].getTextureImage();
                if (object == null || stringArray[i] == null || stringArray[i] == "") continue;
                ((PgGeometry)pgGeometryIfArray[i]).setTextureImageName(stringArray[i]);
            }
            PsConfig.runGC();
            if (!bl4) {
                PsDebug.warning("error during export.");
            }
            return bl4;
        }
        String string8 = this.saveGeometryToString((PgGeometry[])pgGeometryIfArray, string2);
        if (string8 == null) {
            PsDebug.warning("error during export.");
            return false;
        }
        return this.saveString(string8, string);
    }

    public boolean saveGeometry(PgGeometryIf[] pgGeometryIfArray, String string) {
        if (pgGeometryIfArray == null) {
            PsDebug.warning("missing geometry to save.");
            return false;
        }
        PgGeometry[] pgGeometryArray = new PgGeometry[pgGeometryIfArray.length];
        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
            pgGeometryArray[i] = (PgGeometry)pgGeometryIfArray[i];
        }
        return this.saveGeometry(pgGeometryArray, string);
    }

    public static boolean save(PgGeometryIf[] pgGeometryIfArray, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveGeometry(pgGeometryIfArray, string);
    }

    public static boolean save(String string, String string2) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveString(string, string2);
    }

    public boolean saveString(String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing data to save.");
            return false;
        }
        if (string2 == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        if (PsConfig.isApplication()) {
            PrintWriter printWriter = PsUtil.writeFile(string2);
            if (printWriter == null) {
                PsDebug.warning("could not open file = " + string2);
                return false;
            }
            printWriter.println(string);
            printWriter.close();
        } else {
            PgExport_Dialog pgExport_Dialog = new PgExport_Dialog(PsConfig.getFrame(), PsConfig.getProgram() + " " + PsConfig.getMessage(24108), false);
            String string3 = PsUtil.getFileExtension(string2);
            if (string3 != null) {
                pgExport_Dialog.setFilenameExtension(string3);
            }
            pgExport_Dialog.setText(string);
            ((Component)pgExport_Dialog).setVisible(true);
        }
        return true;
    }

    public static boolean save(PvDisplayOption[] pvDisplayOptionArray, String string) {
        PsDebug.warning("usage of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveDisplay(pvDisplayOptionArray, string);
    }

    public boolean saveDisplay(PvDisplayOption[] pvDisplayOptionArray, String string) {
        Object object;
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("missing option to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!(string2 = string2.toLowerCase()).equalsIgnoreCase("jvd")) {
            PsDebug.warning("unknown option file ext = " + string2);
            return false;
        }
        boolean bl = PsConfig.hasArchive(3);
        String string3 = bl ? ".jpg" : ".gif";
        for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
            File file;
            String string4;
            File file2;
            boolean bl2;
            String string5;
            object = pvDisplayOptionArray[i].getBackgroundImage();
            boolean bl3 = pvDisplayOptionArray[i].getOption(10);
            Image image = pvDisplayOptionArray[i].getForegroundImage();
            boolean bl4 = pvDisplayOptionArray[i].getOption(10);
            if (!(object != null && bl3 || image != null && bl4)) continue;
            String string6 = null;
            String string7 = null;
            string6 = PsUtil.getFilePath(string);
            string7 = PsUtil.getFileBaseName(string);
            if (string6 == null || string7 == null) {
                PsDebug.warning("unable to extract path or base name of file name = " + string);
                break;
            }
            if (bl3 && object != null) {
                string5 = pvDisplayOptionArray[i].getBackgroundImageFile();
                bl2 = false;
                if (string5 != null) {
                    file2 = new File(string6 + string5);
                    bl2 = file2.exists();
                }
                if (!bl2) {
                    boolean bl5 = false;
                    if (string5 == null) {
                        string5 = string7 + "_" + pvDisplayOptionArray[i].getName() + string3;
                        if (string3.equals(".gif")) {
                            bl5 = true;
                        }
                    } else {
                        string5 = PsUtil.getFileName(string5);
                        if (!bl && !string5.endsWith(".gif")) {
                            string5 = string5 + ".gif";
                            bl5 = true;
                        } else if (bl && !string5.endsWith(".jpg") && !string5.endsWith(".gif")) {
                            string5 = string5 + ".jpg";
                            bl5 = true;
                        }
                    }
                    pvDisplayOptionArray[i].setBackgroundImageFile(string5);
                    string4 = string6 + string5;
                    file = new File(string4);
                    if (!file.exists()) {
                        if (bl5) {
                            PsDebug.warning("currently, background image is always saved in GIF format.");
                        }
                        this.saveImage((Image)object, string4);
                    }
                }
            }
            if (!bl4 || image == null) continue;
            string5 = pvDisplayOptionArray[i].getForegroundImageFile();
            bl2 = false;
            if (string5 != null) {
                file2 = new File(string6 + string5);
                bl2 = file2.exists();
            }
            if (bl2) continue;
            boolean bl6 = false;
            if (string5 == null) {
                string5 = string7 + "_" + pvDisplayOptionArray[i].getName() + string3;
                if (string3.equals(".gif")) {
                    bl6 = true;
                }
            } else {
                string5 = PsUtil.getFileName(string5);
                if (!bl && !string5.endsWith(".gif")) {
                    string5 = string5 + ".gif";
                    bl6 = true;
                } else if (bl && !string5.endsWith(".jpg") && !string5.endsWith(".gif")) {
                    string5 = string5 + ".jpg";
                    bl6 = true;
                }
            }
            pvDisplayOptionArray[i].setForegroundImageFile(string5);
            string4 = string6 + string5;
            file = new File(string4);
            if (file.exists()) continue;
            if (bl6) {
                PsDebug.warning("currently, foreground image is always saved in GIF format.");
            }
            this.saveImage(image, string4);
        }
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        if (this.m_geometryOption != null) {
            pvDisplayLoader.setGeometryOption(this.m_geometryOption);
        }
        object = pvDisplayLoader.write(pvDisplayOptionArray);
        return this.saveString((String)object, string);
    }

    public static boolean save(Image image, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveImage(image, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveImage(Image image, String string) {
        PsImageCoderIf psImageCoderIf;
        FileOutputStream fileOutputStream;
        if (image == null) {
            PsDebug.warning("missing image to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!((string2 = string2.toLowerCase()).equalsIgnoreCase("gif") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("ppm"))) {
            PsDebug.warning("unknown image file ext = " + string2);
            return false;
        }
        if (string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("ppm")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileOutputStream fileOutputStream2 = null;
            try {
                ImageEncoder imageEncoder = null;
                if (string2.equalsIgnoreCase("gif")) {
                    imageEncoder = new GifEncoder(image, (OutputStream)byteArrayOutputStream);
                } else if (string2.equalsIgnoreCase("ppm")) {
                    imageEncoder = new PpmEncoder(image, (OutputStream)byteArrayOutputStream);
                }
                if (imageEncoder == null) {
                    PsDebug.warning("Failed to create an encoder, ext = " + string2 + "\n\t file = " + string);
                    boolean bl = false;
                    return bl;
                }
                imageEncoder.encode();
                if (byteArrayOutputStream.size() == 0) {
                    PsDebug.warning("image data has size 0");
                    boolean bl = false;
                    return bl;
                }
                try {
                    fileOutputStream2 = new FileOutputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    PsDebug.warning("could not open file = " + string);
                    boolean bl = false;
                    try {
                        ((OutputStream)byteArrayOutputStream).close();
                        byteArrayOutputStream = null;
                        if (fileOutputStream2 != null) {
                            fileOutputStream2.close();
                        }
                        fileOutputStream2 = null;
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
                byteArrayOutputStream.writeTo(fileOutputStream2);
                fileOutputStream2.flush();
                return true;
            }
            catch (IOException iOException) {
                PsDebug.error("Failed to save image: Exception = " + iOException.toString() + "\n\t file = " + string);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    ((OutputStream)byteArrayOutputStream).close();
                    byteArrayOutputStream = null;
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    fileOutputStream2 = null;
                }
                catch (IOException iOException) {}
            }
        }
        if (string2.equalsIgnoreCase("jpg")) {
            if (PsConfig.hasArchive(1)) {
                fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    psImageCoderIf = (PsImageCoderIf)PsUtil.newInstance("jvx.thirdParty.jpegEncode.JpegEncoder");
                    if (psImageCoderIf == null) {
                        PsDebug.error("Failed to created JpegEncoder when trying to save image\n\t file = " + string);
                        boolean bl = false;
                        return bl;
                    }
                    psImageCoderIf.setImage(image);
                    psImageCoderIf.setOutputStream(fileOutputStream);
                    psImageCoderIf.encode();
                }
                catch (IOException iOException) {
                    PsDebug.error("Failed to save image: Exception = " + iOException.toString() + "\n\t file = " + string);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            PsDebug.error("missing JPEG encoder, not included in current distribution.");
        }
        if (!string2.equalsIgnoreCase("png")) return true;
        if (!PsConfig.hasArchive(3)) {
            PsDebug.error("missing PNG encoder, not included in current distribution.");
            return true;
        }
        fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            psImageCoderIf = (PsImageCoderIf)PsUtil.newInstance("dev6.thirdParty.pngj.PngEncoder");
            if (psImageCoderIf == null) {
                PsDebug.error("Failed to created PngEncoder when trying to save image\n\t file = " + string);
                boolean bl = false;
                return bl;
            }
            psImageCoderIf.setImage(image);
            psImageCoderIf.setOutputStream(fileOutputStream);
            psImageCoderIf.encode();
            return true;
        }
        catch (IOException iOException) {
            PsDebug.error("Failed to save image: Exception = " + iOException.toString() + "\n\t file = " + string);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream = null;
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean parseEndOfLine(StreamTokenizer streamTokenizer) throws IOException {
        do {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -1) continue;
            return false;
        } while (streamTokenizer.ttype != 10);
        return true;
    }

    public static double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        return PuDouble.parseDouble(streamTokenizer);
    }

    public static double parseDouble(String string) {
        return PuDouble.parseDouble(string);
    }

    public static boolean readAll(List list, String string) {
        PsXmlNode psXmlNode;
        Object object;
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string, list);
            return false;
        }
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node when reading list from file = " + string, list);
            return false;
        }
        list.removeAll();
        PsXmlNode psXmlNode3 = psXmlNode2.getChild("directories");
        if (psXmlNode3 == null) {
            PsDebug.warning("root node contains no directories element, file = " + string);
            return false;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode3.getChildren("directory");
        if (psXmlNodeArray != null) {
            PsDebug.message("directory contains no subdirectories, dir = " + string, false);
            for (int i = 0; i < psXmlNodeArray.length; ++i) {
                object = psXmlNodeArray[i].getChild("name");
                if (object == null) {
                    PsDebug.warning("directory has no name, dir = " + string);
                    continue;
                }
                list.add(((PsXmlNode)object).getContent());
            }
        }
        if ((psXmlNode = psXmlNode2.getChild("models")) == null) {
            PsDebug.warning("root node contains no models element, file = " + string);
            return false;
        }
        object = psXmlNode.getChildren("model");
        if (object == null) {
            PsDebug.warning("models node contains no models entries, file = " + string);
            return false;
        }
        for (int i = 0; i < ((PsXmlNode[])object).length; ++i) {
            list.add(object[i].getContent());
        }
        return true;
    }

    public static boolean readDirs(List list, String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        list.removeAll();
        list.add("..");
        String[] stringArray = PgLoader.readDirs(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(stringArray[i]);
            }
        }
        return true;
    }

    public static String[] readDirs(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node in file = " + string);
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild("directories");
        if (psXmlNode2 == null) {
            PsDebug.warning("root node contains no directories element, file = " + string);
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode2.getChildren("directory");
        if (psXmlNodeArray == null) {
            return null;
        }
        String[] stringArray = new String[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            PsXmlNode psXmlNode3 = psXmlNodeArray[i].getChild("directoryname");
            if (psXmlNode3 == null) {
                PsDebug.warning("directory " + String.valueOf(i) + " has no name and skipped, file = " + string);
                continue;
            }
            stringArray[i] = psXmlNode3.getContent();
        }
        return stringArray;
    }

    public PgGeometry[] readAnimation(PgJvxSrc[] pgJvxSrcArray, boolean bl) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n = pgJvxSrcArray.length;
        PgJvxSrc[][] pgJvxSrcArray2 = new PgJvxSrc[n][1];
        for (int i = 0; i < n; ++i) {
            pgJvxSrcArray2[i][0] = pgJvxSrcArray[i];
        }
        return this.readAnimation(pgJvxSrcArray2, bl);
    }

    public static PgGeometry[] read(PgJvxSrc[] pgJvxSrcArray, boolean bl) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(pgJvxSrcArray, bl);
    }

    public static PsKeyframe[] readAnimation(PsKeyframe[] psKeyframeArray, int n, int n2, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(psKeyframeArray, n, n2, string, 0);
    }

    public PsKeyframe[] readAnimation(PsKeyframe[] psKeyframeArray, int n, int n2, String string, int n3) {
        if (string == null) {
            PsDebug.warning("missing fileName to load");
            return null;
        }
        int n4 = n2 - n + 1;
        int n5 = -1;
        psKeyframeArray = null;
        double d = 0.0;
        double d2 = 100.0;
        double d3 = d;
        double d4 = (d2 - d) / ((double)n4 - 1.0);
        String[] stringArray = PuString.splitString(string, '*');
        if (stringArray == null || stringArray.length != 2) {
            PsDebug.warning("wrong syntax, fileName = " + string);
            return null;
        }
        for (int i = 0; i < n4; ++i) {
            int n6;
            String string2;
            PgGeometry[] pgGeometryArray;
            String string3 = String.valueOf(i + n);
            if (n3 > 1) {
                for (int j = string3.length(); j < n3; ++j) {
                    string3 = "0" + string3;
                }
            }
            if ((pgGeometryArray = this.loadGeometry((PgGeometry[])null, string2 = stringArray[0] + string3 + stringArray[1])) == null || pgGeometryArray.length == 0) {
                PsDebug.warning("failed loading file = " + string2);
                return null;
            }
            if (i == 0) {
                n5 = pgGeometryArray.length;
                psKeyframeArray = new PsKeyframe[n5];
                for (n6 = 0; n6 < n5; ++n6) {
                    psKeyframeArray[n6] = new PsKeyframe();
                }
            } else if (n5 != pgGeometryArray.length) {
                PsDebug.warning("different number of geometries in file = " + string2);
                return null;
            }
            for (n6 = 0; n6 < n5; ++n6) {
                int n7 = psKeyframeArray[n6].addKey(pgGeometryArray[n6], d3);
                if (n7 != -1) continue;
                PsDebug.warning("geometry of different type: key=" + (i + n) + ", geom=" + n6);
                return null;
            }
            d3 += d4;
        }
        String string4 = PsUtil.getFileName(string);
        for (int i = 0; i < n5; ++i) {
            psKeyframeArray[i].setTime(d);
            if (n5 == 1) {
                psKeyframeArray[i].setName(string4);
                continue;
            }
            psKeyframeArray[i].setName(string4 + "[" + i + "]");
        }
        return psKeyframeArray;
    }

    public PgGeometry[] readAnimation(PgJvxSrc[][] pgJvxSrcArray, boolean bl) {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n2 = pgJvxSrcArray.length;
        int n3 = pgJvxSrcArray[0].length;
        PgGeometry[] pgGeometryArray = new PgGeometry[n3];
        PsKeyframe[] psKeyframeArray = new PsKeyframe[n3];
        for (int i = 0; i < n3; ++i) {
            Object object;
            n = pgJvxSrcArray[0][i].getType();
            int n4 = pgJvxSrcArray[0][i].getDimOfVertices();
            psKeyframeArray[i] = new PsKeyframe();
            for (int j = 0; j < n2; ++j) {
                if (n != pgJvxSrcArray[j][i].getType()) {
                    PsDebug.warning("geometry type changes among key frames");
                    return null;
                }
                if (n4 != pgJvxSrcArray[j][i].getDimOfVertices()) {
                    PsDebug.warning("dimension of vertices changes among key frames");
                    return null;
                }
                switch (n) {
                    case 33: {
                        object = new PgElementSet(n4);
                        break;
                    }
                    case 30: {
                        object = new PgPointSet(n4);
                        break;
                    }
                    case 31: {
                        object = new PgPolygon(n4);
                        break;
                    }
                    case 32: {
                        object = new PgPolygonSet(n4);
                        break;
                    }
                    default: {
                        object = pgJvxSrcArray[j][i];
                    }
                }
                ((PgGeometry)object).setJvx(pgJvxSrcArray[j][i]);
                double d = n2 == 1 ? 0.0 : 100.0 * (double)j / ((double)n2 - 1.0);
                psKeyframeArray[i].addKey((PgGeometry)object, d);
            }
            psKeyframeArray[i].setTime(0.0);
            pgGeometryArray[i] = psKeyframeArray[i].getDynamic();
            String string = PsConfig.getMessage(15012);
            object = PsConfig.getMessage(13000);
            if (pgGeometryArray[i] == null) continue;
            String string2 = string;
            if (n3 > 1) {
                string2 = string2 + "[" + i + "]";
            }
            pgGeometryArray[i].setName(string2 + " " + (String)object + " " + pgJvxSrcArray[0][i].getName());
        }
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName(PsConfig.getMessage(15013));
        for (n = 0; n < n3; ++n) {
            psAnimation.addTimeListener(psKeyframeArray[n]);
        }
        psAnimation.enableKeys(true);
        if (bl) {
            ((Component)psAnimation.getAnimationPanel()).setVisible(true);
        }
        psAnimation.setTimeInterval(0.0, 100.0, 10.0 / ((double)n2 - 1.0), 50.0 / ((double)n2 - 1.0));
        return pgGeometryArray;
    }

    public static PgGeometry[] read(PgJvxSrc[][] pgJvxSrcArray, boolean bl) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(pgJvxSrcArray, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

