/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.key;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;
import vgp.tutor.key.PjKeyframe;

public class PaKeyframe
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.10" + "\r\n" + "Demo applet showing a keyframe animation." + "\r\n";
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        String string = this.m_viewer.getParameter("Model");
        if (string != null) {
            string = PsConfig.getCodeBase() + string;
        }
        String string2 = this.m_viewer.getParameter("Number");
        int n = 0;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("error parsing number of keys = " + string2));
                return;
            }
        }
        PjKeyframe pjKeyframe = new PjKeyframe();
        pjKeyframe.setFileName(string, n);
        this.m_viewer.addProject((PjProject)pjKeyframe);
        this.m_viewer.selectProject((PjProject)pjKeyframe);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_viewer.getDisplay().getCanvas(), "Center");
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public static void main(String[] stringArray) {
        PaKeyframe paKeyframe = new PaKeyframe();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paKeyframe, stringArray);
        psMainFrame.pack();
        paKeyframe.m_frame = psMainFrame;
        paKeyframe.init();
        paKeyframe.start();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgramAndVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }
}

