/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.height;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCurvature;

public class PjHeight
extends PjProject {
    protected int HEIGHT = 10;
    protected int GAUSS = 11;
    protected int MATH = 12;
    protected int MAPLE = 13;
    protected PgElementSet m_geom;
    protected boolean m_bSender;
    protected String[] m_scalarFields = new String[]{"Gauss Curvature", "x-Height", "y-Height", "z-Height", "Math", "Maple"};
    protected String m_defScalarName;
    protected String m_scalarName = this.m_defScalarName = this.m_scalarFields[0];
    static /* synthetic */ Class class$vgp$tutor$height$PjHeight;

    public PjHeight() {
        super("Scalar Field");
        this.m_geom = new PgElementSet(3);
        this.m_geom.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$height$PjHeight == null ? (class$vgp$tutor$height$PjHeight = PjHeight.class$("vgp.tutor.height.PjHeight")) : class$vgp$tutor$height$PjHeight)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.setName("Colored Surface");
        int n = 20;
        this.m_geom.computeTorus(n, n, 2.0, 1.0);
        this.m_geom.makeQuadrBnd(n, n);
        this.m_geom.close();
        this.m_geom.assureElementColors();
        this.m_geom.showElementColors(true);
        this.m_geom.assureVertexColors();
        this.m_geom.showVertexColors(true);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
    }

    public void start() {
        this.computeColor((PgGeometryIf)this.m_geom);
        super.start();
    }

    public boolean addGeometry(PgGeometryIf pgGeometryIf) {
        if (!super.addGeometry(pgGeometryIf)) {
            return false;
        }
        if (pgGeometryIf instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
            pgElementSet.assureElementColors();
            pgElementSet.showElementColors(true);
            pgElementSet.assureVertexColors();
            pgElementSet.showVertexColors(true);
        }
        return true;
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.m_bSender) {
                return true;
            }
            this.computeColor((PgGeometryIf)this.m_geom);
            return true;
        }
        return super.update(object);
    }

    public String getScalarName() {
        return this.m_scalarName;
    }

    public void setScalarName(String string) {
        this.m_scalarName = string.trim();
        if (this.getGeometry() != null) {
            this.computeColor(this.getGeometry());
        }
    }

    public boolean computeColor(PgGeometryIf pgGeometryIf) {
        if (this.m_scalarName == null) {
            PsDebug.warning((String)"missing scalarName");
            return false;
        }
        if (!(pgGeometryIf instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry has wrong class.");
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
        int n = 0;
        PdVector pdVector = null;
        int n2 = this.HEIGHT;
        String string = this.m_scalarName.toLowerCase();
        if (string.startsWith("gauss")) {
            n2 = this.GAUSS;
        } else if (string.startsWith("x")) {
            n = 0;
            pdVector = new PdVector(1.0, 0.0, 0.0);
        } else if (string.startsWith("y")) {
            n = 1;
            pdVector = new PdVector(0.0, 1.0, 0.0);
        } else if (string.startsWith("z")) {
            n = 2;
            pdVector = new PdVector(0.0, 0.0, 1.0);
        } else if (string.startsWith("math")) {
            n2 = this.MATH;
        } else if (string.startsWith("maple")) {
            n2 = this.MAPLE;
        } else {
            PsDebug.warning((String)("unknown scalar field = " + this.m_scalarName));
            return false;
        }
        if (n2 == this.HEIGHT) {
            double d;
            int n3;
            PdVector[] pdVectorArray = pgElementSet.getBounds();
            if (pdVectorArray == null) {
                PsDebug.warning((String)"missing bounding box");
                return false;
            }
            double d2 = pdVectorArray[0].m_data[n];
            double d3 = pdVectorArray[1].m_data[n];
            for (n3 = pgElementSet.getNumElements() - 1; n3 >= 0; --n3) {
                PiVector piVector = pgElementSet.getElement(n3);
                d = 0.0;
                int n4 = piVector.getSize();
                for (int i = 0; i < n4; ++i) {
                    d += PdVector.dot((PdVector)pdVector, (PdVector)pgElementSet.getVertex(piVector.getEntry(i)));
                }
                pgElementSet.setElementColor(n3, PdColor.hsv2rgb((int)((int)(((d /= (double)n4) - d2) * 255.0 / (d3 - d2))), (int)255, (int)255));
            }
            for (n3 = pgElementSet.getNumVertices() - 1; n3 >= 0; --n3) {
                d = PdVector.dot((PdVector)pdVector, (PdVector)pgElementSet.getVertex(n3));
                pgElementSet.setVertexColor(n3, PdColor.hsv2rgb((int)((int)((d - d2) * 255.0 / (d3 - d2))), (int)255, (int)255));
            }
        } else if (n2 == this.GAUSS) {
            int n5;
            PdVector pdVector2 = new PdVector(pgElementSet.getNumVertices());
            PwCurvature.getGaussCurvature((PgElementSet)pgElementSet, (PdVector)pdVector2);
            double d = pdVector2.min();
            double d4 = pdVector2.max();
            for (n5 = pgElementSet.getNumElements() - 1; n5 >= 0; --n5) {
                PiVector piVector = pgElementSet.getElement(n5);
                double d5 = 0.0;
                for (int i = 0; i < piVector.getSize(); ++i) {
                    d5 += pdVector2.getEntry(piVector.m_data[i]);
                }
                pgElementSet.setElementColor(n5, PdColor.hsv2rgb((int)((int)(((d5 /= (double)piVector.getSize()) - d) * 255.0 / (d4 - d))), (int)255, (int)255));
            }
            for (n5 = pgElementSet.getNumVertices() - 1; n5 >= 0; --n5) {
                pgElementSet.setVertexColor(n5, PdColor.hsv2rgb((int)((int)((pdVector2.getEntry(n5) - d) * 255.0 / (d4 - d))), (int)255, (int)255));
            }
        } else if (n2 == this.MATH) {
            if (!pgElementSet.hasElementNormals()) {
                pgElementSet.makeElementNormals();
            }
            PdVector[] pdVectorArray = pgElementSet.getElementNormals();
            for (int i = pgElementSet.getNumElements() - 1; i >= 0; --i) {
                double[] dArray = pdVectorArray[i].m_data;
                Color color = dArray[1] > 0.0 ? PdColor.hsv2rgb((int)((int)(127.0 * Math.acos(dArray[0]) / Math.PI)), (int)((int)(255.0 * (1.0 - Math.abs(dArray[2])))), (int)255) : PdColor.hsv2rgb((int)((int)(127.0 + 128.0 * Math.acos(-dArray[0]) / Math.PI)), (int)((int)(255.0 * (1.0 - Math.abs(dArray[2])))), (int)255);
                pgElementSet.setElementColor(i, color);
            }
        } else if (n2 == this.MAPLE) {
            if (!pgElementSet.hasElementNormals()) {
                pgElementSet.makeElementNormals();
            }
            PdVector[] pdVectorArray = pgElementSet.getElementNormals();
            for (int i = pgElementSet.getNumElements() - 1; i >= 0; --i) {
                double[] dArray = pdVectorArray[i].m_data;
                Color color = new Color((float)Math.abs(dArray[0]), (float)Math.abs(dArray[1]), (float)Math.abs(dArray[2]));
                pgElementSet.setElementColor(i, color);
            }
        }
        this.m_bSender = true;
        pgElementSet.update((Object)pgElementSet);
        this.m_bSender = false;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

