/*
 * Decompiled with CFR 0.152.
 */
package vgp.object;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;

public abstract class PsApplet
extends Applet
implements Runnable {
    protected Frame m_frame;
    protected PvViewer m_viewer;
    private String m_drawString;
    protected String m_preferredPanelPosition = "East";

    public abstract String getAppletInfo();

    public abstract PjProject getProject();

    public abstract Rectangle getSizeOfFrame();

    public void init() {
        this.drawMessage("Loading viewer ...");
        if (this.m_viewer == null) {
            this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        }
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }

    public void run() {
        this.drawMessage("Loading project ...");
        PjProject pjProject = this.getProject();
        this.m_viewer.addProject(pjProject);
        this.m_viewer.selectProject(pjProject);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_viewer.getDisplay().getCanvas(), "Center");
        if (!"Hide".equalsIgnoreCase(this.m_viewer.getParameter("ProjectPanel"))) {
            this.add((Component)this.m_viewer.getPanel(10), this.m_preferredPanelPosition);
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public static void main(PsApplet psApplet, String[] stringArray) {
        PsMainFrame psMainFrame = new PsMainFrame((Component)psApplet, stringArray);
        psMainFrame.pack();
        psMainFrame.setBounds(psApplet.getSizeOfFrame());
        psApplet.m_frame = psMainFrame;
        psApplet.init();
        psMainFrame.setVisible(true);
    }

    public void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgramAndVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }
}

