/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass
extends PgElementSet {
    protected static final int VERTEX_DIM = 3;
    protected PgWeierstrassDescr m_descr;
    protected String m_surfaceName;
    private PgWeierstrass[] m_part;
    protected PgPointSet m_reSet;
    protected PgPointSet m_imSet;
    protected PiVector m_indexNumber;
    protected PiVector m_startInd;
    protected int m_numParts;
    protected int m_numBnd;
    private PiVector[][] m_bndIsConnectedTo;
    private boolean[][] m_pointIsCopy;
    private PiVector[] m_partIsReflection;
    protected PiVector m_bndReflectType;
    protected PiVector m_bndBelongsToPart;
    protected PiVector m_partBndNr;
    private boolean m_bGenerateConnectivity = false;
    protected boolean m_bGenerateTexture = true;
    protected boolean m_bInvertCopiedTexture = true;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass;

    public PgWeierstrass() {
        super(3);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass == null ? (class$vgp$minimal$weier$PgWeierstrass = PgWeierstrass.class$("vgp.minimal.weier.PgWeierstrass")) : class$vgp$minimal$weier$PgWeierstrass)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showElementBackColor(true);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_descr) {
            this.generateConnectivity(this.m_descr);
            this.computeSurface(this.m_descr);
            this.markBnd(-1);
            return super.update((Object)this);
        }
        if (object == this.m_descr.m_intDiscr) {
            if (this.m_bGenerateConnectivity) {
                this.generateConnectivity(this.m_descr);
            }
            this.computeSurface(this.m_descr);
            return super.update((Object)this);
        }
        if (object == this.m_descr.m_conjugation) {
            if (this.m_bGenerateConnectivity) {
                this.generateConnectivity(this.m_descr);
                this.computeSurface(this.m_descr);
            } else {
                this.computeVertices(this.m_descr);
            }
            return super.update((Object)this);
        }
        if (object == this) {
            // empty if block
        }
        return super.update(object);
    }

    public boolean setSurfaceName(String string, String string2) {
        String string3 = string2 + string;
        PgWeierstrassDescr pgWeierstrassDescr = (PgWeierstrassDescr)((Object)PsUtil.newInstance((String)string3));
        if (pgWeierstrassDescr == null) {
            PsDebug.warning((String)("could not find class = " + string3));
            return false;
        }
        this.setDescr(pgWeierstrassDescr);
        this.m_surfaceName = string;
        this.setName(this.m_surfaceName);
        return true;
    }

    public PgWeierstrassDescr getDescr() {
        return this.m_descr;
    }

    public void setDescr(PgWeierstrassDescr pgWeierstrassDescr) {
        this.m_descr = pgWeierstrassDescr;
        if (this.m_descr != null) {
            this.m_descr.setParent((PsUpdateIf)this);
        }
        this.m_descr.setMarkedBndNr(-1);
    }

    public void generateConnectivity(PgWeierstrassDescr pgWeierstrassDescr) {
        this.generateConnectivity(pgWeierstrassDescr, null);
        this.m_bGenerateConnectivity = false;
    }

    public void generateConnectivity(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.m_numParts = pgWeierstrassDescr.getNumParts(piVector);
        this.m_partIsReflection = pgWeierstrassDescr.getReflections(piVector, this.m_numParts);
        this.m_part = new PgWeierstrass[this.m_numParts];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            this.m_part[n7] = new PgWeierstrass();
            if (this.m_partIsReflection[n7].m_data[0] == -1) {
                this.m_part[n7].generateConnectivity(pgWeierstrassDescr, piVector, n7);
            } else {
                this.generatePartReflection(n7);
            }
            n9 += this.m_part[n7].getNumElements();
            n8 += this.m_part[n7].getNumVertices();
        }
        this.m_bndIsConnectedTo = new PiVector[this.m_numParts][];
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            this.m_bndIsConnectedTo[n7] = PiVector.realloc((PiVector[])this.m_bndIsConnectedTo[n7], (int)this.m_part[n7].m_numBnd, (int)2);
            for (n6 = 0; n6 < this.m_part[n7].m_numBnd; ++n6) {
                this.m_bndIsConnectedTo[n7][n6].m_data[0] = -1;
            }
        }
        pgWeierstrassDescr.setReflection(this.m_partIsReflection);
        pgWeierstrassDescr.getConnections(piVector, this.m_bndIsConnectedTo, this.m_numParts);
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            if (this.m_partIsReflection[n7].m_data[0] == -1 || !pgWeierstrassDescr.connectReflection(piVector, n7)) continue;
            n6 = this.m_partIsReflection[n7].m_data[0];
            n5 = this.m_partIsReflection[n7].m_data[1];
            this.m_bndIsConnectedTo[n7][n5].m_data[0] = n6;
            this.m_bndIsConnectedTo[n6][n5].m_data[0] = n7;
            this.m_bndIsConnectedTo[n7][n5].m_data[1] = n5;
            this.m_bndIsConnectedTo[n6][n5].m_data[1] = n5;
        }
        this.m_numBnd = 0;
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            for (n6 = 0; n6 < this.m_part[n7].m_numBnd; ++n6) {
                if (this.m_bndIsConnectedTo[n7][n6].m_data[0] != -1) continue;
                ++this.m_numBnd;
            }
        }
        this.m_indexNumber = new PiVector();
        this.m_indexNumber.setSize(n8);
        this.m_startInd = new PiVector();
        this.m_startInd.setSize(this.m_numParts);
        this.assureBoundary(this.m_numBnd);
        this.m_bndReflectType = new PiVector(this.m_numBnd);
        this.m_bndBelongsToPart = new PiVector(this.m_numBnd);
        this.m_partBndNr = new PiVector(this.m_numBnd);
        this.m_pointIsCopy = new boolean[this.m_numParts][];
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            n6 = this.m_part[n7].getNumVertices();
            this.m_pointIsCopy[n7] = new boolean[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                this.m_pointIsCopy[n7][n5] = false;
            }
        }
        for (n7 = 0; n7 < this.m_numParts; ++n7) {
            for (n6 = 0; n6 < this.m_part[n7].m_numBnd; ++n6) {
                n5 = this.m_bndIsConnectedTo[n7][n6].m_data[0];
                if (n5 < 0 || n5 >= n7 && (n5 != n7 || this.m_bndIsConnectedTo[n7][n6].m_data[1] >= n6)) continue;
                n4 = this.m_part[n7].m_bndList[n6].getVertexInd().getSize();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.m_pointIsCopy[n7][this.m_part[n7].m_bndList[n6].getVertexInd().m_data[n3]] = true;
                }
            }
        }
        n7 = 0;
        for (n6 = 0; n6 < this.m_numParts; ++n6) {
            this.m_startInd.m_data[n6] = n7;
            n5 = this.m_part[n6].getNumVertices();
            for (n4 = 0; n4 < n5; ++n4) {
                if (this.m_pointIsCopy[n6][n4]) continue;
                this.m_indexNumber.m_data[this.m_startInd.m_data[n6] + n4] = n10++;
            }
            n7 += n5;
        }
        this.setNumVertices(n10);
        this.setNumElements(n9);
        this.m_reSet = new PgPointSet(3);
        this.m_imSet = new PgPointSet(3);
        this.m_reSet.setNumVertices(n10);
        this.m_imSet.setNumVertices(n10);
        for (n6 = 0; n6 < this.m_numParts; ++n6) {
            for (n5 = 0; n5 < this.m_part[n6].m_numBnd; ++n5) {
                n4 = this.m_bndIsConnectedTo[n6][n5].m_data[0];
                if (n4 < 0 || n4 >= n6 && (n4 != n6 || this.m_bndIsConnectedTo[n6][n5].m_data[1] >= n5)) continue;
                n3 = this.m_bndIsConnectedTo[n6][n5].m_data[1];
                int n11 = this.m_part[n6].m_bndList[n5].getVertexInd().getSize();
                for (int i = 0; i < n11; ++i) {
                    this.m_indexNumber.m_data[this.m_startInd.m_data[n6] + this.m_part[n6].m_bndList[n5].getVertexInd().m_data[i]] = this.m_indexNumber.m_data[this.m_startInd.m_data[n4] + this.m_part[n4].m_bndList[n3].getVertexInd().m_data[n11 - i - 1]];
                }
            }
        }
        n6 = 0;
        for (n5 = 0; n5 < this.m_numParts; ++n5) {
            for (n4 = 0; n4 < this.m_part[n5].m_numBnd; ++n4) {
                if (this.m_bndIsConnectedTo[n5][n4].m_data[0] != -1) continue;
                n3 = this.m_part[n5].m_bndList[n4].getVertexInd().getSize();
                PiVector piVector2 = this.m_bndList[n6].getVertexInd();
                PiVector piVector3 = this.m_part[n5].m_bndList[n4].getVertexInd();
                n2 = this.m_startInd.m_data[n5];
                this.m_bndList[n6].setNumVertices(n3);
                piVector2.setSize(n3);
                this.m_bndList[n6].getElementInd().setSize(n3 - 1);
                for (n = 0; n < n3; ++n) {
                    piVector2.m_data[n] = this.m_indexNumber.m_data[n2 + piVector3.m_data[n]];
                }
                this.m_bndReflectType.m_data[n6] = this.m_part[n5].m_bndReflectType.m_data[n4];
                this.m_bndBelongsToPart.m_data[n6] = n5;
                this.m_partBndNr.m_data[n6] = n4;
                ++n6;
            }
        }
        this.setDimOfElements(pgWeierstrassDescr.getDimOfElements());
        n5 = 0;
        if (this.m_bGenerateTexture) {
            this.assureElementTextures();
        }
        for (n4 = 0; n4 < this.m_numParts; ++n4) {
            n3 = this.m_part[n4].getNumElements();
            int n12 = this.m_startInd.m_data[n4];
            for (int i = 0; i < n3; ++i) {
                if (this.m_dimOfElements == -1) {
                    this.m_element[n5].setSize(this.m_part[n4].getElement(i).getSize());
                }
                n2 = this.m_part[n4].getElement(i).getSize();
                for (n = 0; n < n2; ++n) {
                    this.m_element[n5].m_data[n] = this.m_indexNumber.m_data[n12 + this.m_part[n4].m_element[i].m_data[n]];
                }
                if (this.m_bGenerateTexture) {
                    for (n = 0; n < n2; ++n) {
                        this.m_elementTexture[n5][n] = PdVector.copyNew((PdVector)this.m_part[n4].m_elementTexture[i][n]);
                    }
                }
                ++n5;
            }
        }
        if (piVector == null) {
            this.makeNeighbour();
        }
        for (n4 = 0; n4 < this.m_numBnd; ++n4) {
            this.m_bndList[n4].makeElementInd();
        }
    }

    public void generateConnectivity(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector, int n) {
        if (pgWeierstrassDescr.partIsSubdivided(piVector, n)) {
            PiVector piVector2;
            if (piVector == null) {
                piVector2 = new PiVector(1);
                piVector2.setEntry(0, n);
            } else {
                int n2 = piVector.getSize();
                piVector2 = new PiVector(n2 + 1);
                for (int i = 0; i < n2; ++i) {
                    piVector2.setEntry(i, piVector.getEntry(i));
                }
                piVector2.setEntry(n2, n);
            }
            this.generateConnectivity(pgWeierstrassDescr, piVector2);
        } else {
            int n3 = pgWeierstrassDescr.getNumULines(n);
            int n4 = pgWeierstrassDescr.getNumVLines(n);
            this.setDimOfElements(pgWeierstrassDescr.getDimOfElements());
            this.setNumVertices(n3 * n4);
            this.makeQuadrConn(n3, n4);
            this.makeQuadrBnd(n3, n4);
            this.m_reSet = new PgPointSet(3);
            this.m_imSet = new PgPointSet(3);
            this.m_reSet.setNumVertices(n3 * n4);
            this.m_imSet.setNumVertices(n3 * n4);
            this.m_numBnd = 4;
            this.m_bndReflectType = new PiVector(4);
            this.m_bndReflectType.setConstant(-1);
            pgWeierstrassDescr.getBndReflectType(piVector, n, this.m_bndReflectType);
            if (this.m_bGenerateTexture) {
                this.assureElementTextures();
                int n5 = this.getNumElements();
                int n6 = this.m_dimOfElements;
                for (int i = 0; i < n5; ++i) {
                    if (this.m_dimOfElements == -1) {
                        n6 = this.getElement(i).getSize();
                    }
                    for (int j = 0; j < n6; ++j) {
                        this.getElementTexture((int)i)[j] = new PdVector((double)(this.m_element[i].m_data[j] / n4) * 1.0 / ((double)n3 - 1.0), (double)this.m_element[i].m_data[j] * 1.0 % (double)n4 * 1.0 / ((double)n4 - 1.0));
                    }
                }
            }
        }
    }

    public void generatePartReflection(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.m_partIsReflection[n].m_data[0];
        this.m_part[n].copy((PsObject)this.m_part[n5]);
        if (this.m_bGenerateTexture && this.m_bInvertCopiedTexture) {
            n4 = this.m_part[n].getNumElements();
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n3 = this.m_part[n].getElement(n2).getSize();
                for (int i = 0; i < n3; ++i) {
                    this.m_part[n].getElementTexture((int)n2)[i].m_data[0] = 1.0 - this.m_part[n].getElementTexture((int)n2)[i].m_data[0];
                }
            }
        }
        this.m_part[n].m_reSet = new PgPointSet(3);
        this.m_part[n].m_imSet = new PgPointSet(3);
        this.m_part[n].m_reSet.setNumVertices(this.m_part[n5].m_reSet.getNumVertices());
        this.m_part[n].m_imSet.setNumVertices(this.m_part[n5].m_imSet.getNumVertices());
        this.m_part[n].m_numBnd = this.m_part[n5].m_numBnd;
        this.m_part[n].flipOrientation();
        this.m_part[n].m_bndReflectType = (PiVector)this.m_part[n5].m_bndReflectType.clone();
        for (n4 = 0; n4 < this.m_part[n].m_numBnd; ++n4) {
            n3 = this.m_part[n5].m_bndList[n4].getVertexInd().getSize();
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_part[n].m_bndList[n4].getVertexInd().m_data[n2] = this.m_part[n5].m_bndList[n4].getVertexInd().m_data[n3 - n2 - 1];
            }
        }
    }

    public void computeSurface(PgWeierstrassDescr pgWeierstrassDescr) {
        this.computeSurface(pgWeierstrassDescr, null);
    }

    public void computeSurface(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector) {
        pgWeierstrassDescr.setVertDim(3);
        pgWeierstrassDescr.setConnections(this.m_bndIsConnectedTo);
        PuComplex[] puComplexArray = new PuComplex[3];
        for (int i = 0; i < this.m_numParts; ++i) {
            int n;
            if (this.m_partIsReflection[i].m_data[0] == -1) {
                if (pgWeierstrassDescr.getStartU(piVector, i) == 0 && pgWeierstrassDescr.getStartV(piVector, i) == 0) {
                    puComplexArray = pgWeierstrassDescr.getFStart(piVector, i);
                } else {
                    n = this.m_indexNumber.m_data[this.m_startInd.m_data[i]];
                    PdVector pdVector = this.m_reSet.getVertex(n);
                    PdVector pdVector2 = this.m_imSet.getVertex(n);
                    for (int j = 0; j < 3; ++j) {
                        puComplexArray[j] = new PuComplex(pdVector.m_data[j], pdVector2.m_data[j]);
                    }
                }
                this.m_part[i].computePart(pgWeierstrassDescr, piVector, i, puComplexArray);
            } else {
                this.computePartReflection(i);
            }
            n = this.m_part[i].getNumVertices();
            for (int j = 0; j < n; ++j) {
                if (this.m_pointIsCopy[i][j]) continue;
                this.m_reSet.setVertex(this.m_indexNumber.m_data[this.m_startInd.m_data[i] + j], this.m_part[i].m_reSet.getVertex(j));
                this.m_imSet.setVertex(this.m_indexNumber.m_data[this.m_startInd.m_data[i] + j], this.m_part[i].m_imSet.getVertex(j));
            }
        }
        if (piVector == null) {
            PdVector pdVector = this.m_reSet.getCenterOfGravity();
            pdVector.multScalar(-1.0);
            this.m_reSet.translate(pdVector);
            pdVector.setConstant(0.0);
            this.m_reSet.setCenter(pdVector);
            pdVector = this.m_imSet.getCenterOfGravity();
            pdVector.multScalar(-1.0);
            this.m_imSet.translate(pdVector);
            pdVector.setConstant(0.0);
            this.m_imSet.setCenter(pdVector);
            this.computeVertices(pgWeierstrassDescr);
        }
    }

    public void computeVertices(PgWeierstrassDescr pgWeierstrassDescr) {
        double d = this.m_descr.getConjugationAngle();
        double d2 = Math.sin(d);
        d = Math.cos(d);
        PdVector pdVector = new PdVector();
        pdVector.setSize(3);
        int n = this.getNumVertices();
        if (n != this.m_reSet.getNumVertices() || n != this.m_imSet.getNumVertices()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            pdVector.blend(d, this.m_reSet.getVertex(i), d2, this.m_imSet.getVertex(i));
            this.setVertex(i, pdVector);
        }
        this.makeVertexNormals();
        this.makeElementNormals();
        this.showMarkedBnd();
    }

    public void computePart(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector, int n, PuComplex[] puComplexArray) {
        if (pgWeierstrassDescr.partIsSubdivided(piVector, n)) {
            PiVector piVector2;
            if (piVector == null) {
                piVector2 = new PiVector(1);
                piVector2.setEntry(0, n);
            } else {
                int n2 = piVector.getSize();
                piVector2 = new PiVector(n2 + 1);
                for (int i = 0; i < n2; ++i) {
                    piVector2.setEntry(i, piVector.getEntry(i));
                }
                piVector2.setEntry(n2, n);
            }
            this.computeSurface(pgWeierstrassDescr, piVector2);
        } else {
            int n3;
            int n4;
            this.m_descr = pgWeierstrassDescr;
            int n5 = pgWeierstrassDescr.getNumULines(n);
            int n6 = pgWeierstrassDescr.getNumVLines(n);
            double d = (pgWeierstrassDescr.getUMax(n) - pgWeierstrassDescr.getUMin(n)) / (double)(n5 - 1);
            double d2 = (pgWeierstrassDescr.getVMax(n) - pgWeierstrassDescr.getVMin(n)) / (double)(n6 - 1);
            PuComplex[] puComplexArray2 = new PuComplex[3];
            PuComplex[] puComplexArray3 = new PuComplex[3];
            PuComplex puComplex = new PuComplex(pgWeierstrassDescr.getUMin(n), pgWeierstrassDescr.getVMin(n));
            PuComplex puComplex2 = new PuComplex();
            PuComplex puComplex3 = new PuComplex(puComplex);
            PuComplex puComplex4 = new PuComplex();
            int n7 = this.m_descr.m_intDiscr.getValue();
            if (n7 < 1) {
                n7 = 1;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.m_reSet.getVertex((int)0).m_data[n4] = puComplexArray[n4].re();
                this.m_imSet.getVertex((int)0).m_data[n4] = puComplexArray[n4].im();
                puComplexArray2[n4] = new PuComplex(puComplexArray[n4]);
            }
            puComplex2 = new PuComplex(pgWeierstrassDescr.transform(n, puComplex));
            for (n4 = 1; n4 < n6; ++n4) {
                puComplex3.add(PuComplex.mult((PuComplex)PuComplex.I, (double)d2));
                puComplex4 = new PuComplex(pgWeierstrassDescr.transform(n, puComplex3));
                puComplexArray3 = this.cIntegrate(n, puComplex2, puComplex4, puComplexArray2, n7);
                for (n3 = 0; n3 < 3; ++n3) {
                    this.m_reSet.getVertex((int)n4).m_data[n3] = puComplexArray3[n3].re();
                    this.m_imSet.getVertex((int)n4).m_data[n3] = puComplexArray3[n3].im();
                    puComplexArray2[n3] = new PuComplex(puComplexArray3[n3]);
                }
                puComplex2 = new PuComplex(puComplex4);
            }
            PuComplex[] puComplexArray4 = new PuComplex[3];
            for (n3 = 0; n3 < 3; ++n3) {
                puComplexArray4[n3] = new PuComplex(puComplexArray[n3]);
            }
            PuComplex puComplex5 = new PuComplex(pgWeierstrassDescr.getUMin(n), pgWeierstrassDescr.getVMin(n));
            puComplexArray3 = this.cIntegrate(n, puComplex2, puComplex4, puComplexArray2, n7);
            PuComplex puComplex6 = new PuComplex(puComplex5);
            for (int i = 1; i < n5; ++i) {
                int n8;
                puComplex6.add(d);
                puComplex2 = new PuComplex(pgWeierstrassDescr.transform(n, puComplex5));
                puComplex4 = new PuComplex(pgWeierstrassDescr.transform(n, puComplex6));
                puComplexArray2 = this.cIntegrate(n, puComplex2, puComplex4, puComplexArray4, n7);
                puComplex = new PuComplex(puComplex6);
                puComplex3 = new PuComplex(puComplex);
                puComplex2 = new PuComplex(puComplex4);
                for (n8 = 0; n8 < 3; ++n8) {
                    puComplexArray4[n8] = new PuComplex(puComplexArray2[n8]);
                    this.m_reSet.getVertex((int)(i * n6)).m_data[n8] = puComplexArray2[n8].re();
                    this.m_imSet.getVertex((int)(i * n6)).m_data[n8] = puComplexArray2[n8].im();
                }
                puComplex5 = new PuComplex(puComplex6);
                for (n8 = 1; n8 < n6; ++n8) {
                    PuComplex puComplex7 = new PuComplex(0.0, d2);
                    puComplex3.add(puComplex7);
                    puComplex4 = new PuComplex(pgWeierstrassDescr.transform(n, puComplex3));
                    puComplexArray3 = this.cIntegrate(n, puComplex2, puComplex4, puComplexArray2, n7);
                    for (int j = 0; j < 3; ++j) {
                        this.m_reSet.getVertex((int)(n8 + n6 * i)).m_data[j] = puComplexArray3[j].re();
                        this.m_imSet.getVertex((int)(n8 + n6 * i)).m_data[j] = puComplexArray3[j].im();
                        puComplexArray2[j] = new PuComplex(puComplexArray3[j]);
                    }
                    puComplex2 = new PuComplex(puComplex4);
                }
            }
        }
    }

    public PuComplex[] cIntegrate(int n, PuComplex puComplex, PuComplex puComplex2, PuComplex[] puComplexArray, int n2) {
        int n3;
        PuComplex[] puComplexArray2 = new PuComplex[3];
        PuComplex[] puComplexArray3 = new PuComplex[3];
        PuComplex puComplex3 = new PuComplex(puComplex);
        PuComplex puComplex4 = PuComplex.div((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)puComplex), (double)n2);
        puComplexArray2 = this.m_descr.fun(puComplex);
        puComplexArray3 = this.m_descr.fun(puComplex2);
        for (n3 = 0; n3 < 3; ++n3) {
            puComplexArray2[n3].add(puComplexArray3[n3]);
            puComplexArray2[n3].div(2.0);
            puComplexArray2[n3].mult(puComplex4);
        }
        for (n3 = 1; n3 < n2; ++n3) {
            puComplex3.add(puComplex4);
            puComplexArray3 = this.m_descr.fun(puComplex3);
            for (int i = 0; i < 3; ++i) {
                puComplexArray2[i].add(PuComplex.mult((PuComplex)puComplexArray3[i], (PuComplex)puComplex4));
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            puComplexArray2[n3].add(puComplexArray[n3]);
        }
        if (this.m_descr.isShowingDomain()) {
            puComplexArray2[0] = new PuComplex(puComplex2.re);
            puComplexArray2[1] = new PuComplex(puComplex2.im);
            puComplexArray2[2] = new PuComplex(0.0);
        }
        return puComplexArray2;
    }

    public void computePartReflection(int n) {
        int n2 = this.m_partIsReflection[n].m_data[0];
        int n3 = this.m_partIsReflection[n].m_data[1];
        int n4 = this.m_part[n2].m_bndReflectType.m_data[n3];
        PdMatrix pdMatrix = new PdMatrix();
        PdMatrix pdMatrix2 = new PdMatrix();
        PdVector pdVector = new PdVector(3);
        int n5 = this.m_part[n2].m_bndList[n3].getVertexInd().getSize();
        int n6 = this.m_part[n2].m_bndList[n3].getVertexInd().m_data[0];
        int n7 = this.m_part[n2].m_bndList[n3].getVertexInd().m_data[n5 - 1];
        if (n4 == 0) {
            pdVector.sub(this.m_part[n2].m_imSet.getVertex(n7), this.m_part[n2].m_imSet.getVertex(n6));
            pdVector.normalize();
            pdMatrix = PuReflect.rotateLine((PdVector)this.m_part[n2].m_imSet.getVertex(n6), (PdVector)pdVector);
            pdMatrix2 = PuReflect.planeReflect((PdVector)this.m_part[n2].m_reSet.getVertex(n6), (PdVector)pdVector);
        } else {
            pdVector.sub(this.m_part[n2].m_reSet.getVertex(n7), this.m_part[n2].m_reSet.getVertex(n6));
            pdVector.normalize();
            pdMatrix = PuReflect.planeReflect((PdVector)this.m_part[n2].m_imSet.getVertex(n6), (PdVector)pdVector);
            pdMatrix2 = PuReflect.rotateLine((PdVector)this.m_part[n2].m_reSet.getVertex(n6), (PdVector)pdVector);
        }
        PdVector pdVector2 = new PdVector(4);
        PdVector pdVector3 = new PdVector(4);
        pdVector2.m_data[3] = 1.0;
        pdVector3.m_data[3] = 1.0;
        int n8 = this.m_part[n].getNumVertices();
        for (int i = 0; i < n8; ++i) {
            int n9;
            for (n9 = 0; n9 < 3; ++n9) {
                pdVector3.m_data[n9] = this.m_part[n2].m_reSet.getVertex((int)i).m_data[n9];
                pdVector2.m_data[n9] = this.m_part[n2].m_imSet.getVertex((int)i).m_data[n9];
            }
            pdVector2.leftMultMatrix(pdMatrix);
            pdVector3.leftMultMatrix(pdMatrix2);
            for (n9 = 0; n9 < 3; ++n9) {
                this.m_part[n].m_imSet.getVertex((int)i).m_data[n9] = pdVector2.m_data[n9];
                this.m_part[n].m_reSet.getVertex((int)i).m_data[n9] = pdVector3.m_data[n9];
            }
        }
    }

    public boolean showMarkedBnd() {
        int n;
        int n2;
        PiVector piVector;
        int n3;
        for (n3 = 0; n3 < this.m_numBnd; ++n3) {
            piVector = this.m_bndList[n3].getVertexInd();
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                this.clearTagVertex(piVector.m_data[n], 1);
            }
        }
        n3 = this.m_descr.getMarkedBndNr();
        if (n3 > -1 && n3 < this.m_numBnd) {
            piVector = this.m_bndList[n3].getVertexInd();
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                this.setTagVertex(piVector.m_data[n], 1);
            }
        }
        return this.update(null);
    }

    public void markBnd(int n) {
        this.m_descr.setMarkedBndNr(-1);
        for (int i = 0; i < this.m_numBnd; ++i) {
            int n2 = this.m_bndList[i].getElementInd().getSize();
            for (int j = 0; j < n2; ++j) {
                if (n != this.m_bndList[i].getElementInd().m_data[j] || this.m_bndReflectType.m_data[i] == -1) continue;
                this.m_descr.setMarkedBndNr(i);
                this.m_descr.setReflectPartNr(this.m_bndBelongsToPart.m_data[i]);
                this.m_descr.setPartBndNr(this.m_partBndNr.m_data[i]);
            }
        }
        this.showMarkedBnd();
    }

    public boolean close() {
        this.m_bGenerateConnectivity = true;
        return super.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

