/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsImage;
import jv.objectGui.PsScanline;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;
import jv.viewer.PvLight;

public final class PvScene
extends PsObject {
    private PvGeometry[] m_allGeometry;
    private int m_numAllGeometries;
    protected int m_maxNumGeometries;
    protected int m_numGeometries = 0;
    protected PvGeometry[] m_geometry;
    protected Vector m_special;
    protected PvGeometry m_currentGeom;
    protected int m_numItems;
    protected int[][] m_itemInd;
    protected double[] m_itemHeight;
    protected int[] m_itemSort;
    protected int m_dim;
    protected PdVector[] m_bndBox;
    protected PdVector m_center;
    protected int m_pickedVertex;
    protected int m_pickedGeometry;
    private int m_geomInd;
    private PiVector[] m_faceDestBnd;
    private int[][] m_colDestBnd;
    private int[][] m_lightDestBnd;
    protected PiVector m_bndIdentifier = null;
    protected int m_dimWithZBuffer = 4;
    protected int m_zMin;
    protected int m_zMax;
    protected PdVector m_cameraPos = new PdVector(3);
    protected PdVector m_cameraDir = new PdVector(3);
    protected boolean m_bIsBurning = true;
    protected int[][] m_tpBuffer = null;
    protected int[][] m_colBuffer = null;
    protected static boolean m_bTiming = false;
    protected static long m_timeTexBnd = 0L;
    protected static long m_timeTexScan = 0L;
    protected static long m_timePaint = 0L;
    private transient Image m_destImage;
    private int m_imgWidth;
    private int m_imgHeight;
    private transient MemoryImageSource m_mis;
    protected PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    private boolean m_bBackImage = false;
    private int m_backColor = -1;
    private boolean m_bTransparency = false;

    public PvScene() {
        this.assureIndexList();
        this.m_allGeometry = new PvGeometry[0];
        this.m_special = new Vector();
        this.m_bIsBurning = false;
        this.init();
    }

    public void init() {
        super.init();
        this.m_name = null;
        this.m_dim = 3;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-10.0);
        this.m_bndBox[1].setConstant(10.0);
        this.m_center = new PdVector(this.m_dim);
        this.m_center.setConstant(0.0);
    }

    public void addGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (pvGeometry.isSpecial() || pvGeometry.getDrawingOrder() != 0) {
            this.m_special.addElement(pvGeometry);
            this.collectAllGeometries();
        } else {
            for (int i = 0; i < this.m_numGeometries; ++i) {
                if (this.m_geometry[i] != pvGeometry) continue;
                this.update(pvGeometry);
                return;
            }
            if (this.m_numGeometries == this.m_maxNumGeometries) {
                int[][] nArray = this.m_itemInd;
                PvGeometry[] pvGeometryArray = new PvGeometry[2 * this.m_maxNumGeometries];
                this.m_itemInd = new int[2 * this.m_maxNumGeometries][3];
                for (int i = 0; i < this.m_maxNumGeometries; ++i) {
                    pvGeometryArray[i] = this.m_geometry[i];
                    for (int j = 0; j < 3; ++j) {
                        this.m_itemInd[i][j] = nArray[i][j];
                    }
                }
                this.m_geometry = pvGeometryArray;
                this.m_maxNumGeometries = 2 * this.m_maxNumGeometries;
            }
            this.m_geometry[this.m_numGeometries++] = pvGeometry;
            this.collectAllGeometries();
            if (this.m_numGeometries == 1) {
                this.selectGeometry(pvGeometry);
            }
        }
        this.update(pvGeometry);
    }

    public PvGeometry removeGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return null;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_special.removeElement(pvGeometry);
            this.collectAllGeometries();
            if (pvGeometry == this.m_currentGeom) {
                if (this.m_numGeometries > 0) {
                    int n = 0;
                    for (int i = 0; i < this.m_numGeometries; ++i) {
                        if (!this.m_geometry[i].isVisible()) continue;
                        n = i;
                        break;
                    }
                    this.selectGeometry(this.m_geometry[n]);
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
            }
            return this.m_currentGeom;
        }
        for (int i = 0; i < this.m_numGeometries; ++i) {
            if (this.m_geometry[i] != pvGeometry) continue;
            --this.m_numGeometries;
            if (i < this.m_numGeometries) {
                this.m_geometry[i] = this.m_geometry[this.m_numGeometries];
                this.m_itemInd[i][2] = this.m_itemInd[this.m_numGeometries][2];
            }
            this.m_geometry[this.m_numGeometries] = null;
            this.collectAllGeometries();
            this.assureIndexList();
            if (this.m_numGeometries > 0) {
                if (pvGeometry == this.m_currentGeom) {
                    int n = 0;
                    for (int j = 0; j < this.m_numGeometries; ++j) {
                        if (!this.m_geometry[j].isVisible()) continue;
                        n = j;
                        break;
                    }
                    this.selectGeometry(this.m_geometry[n]);
                }
            } else {
                this.m_currentGeom = null;
            }
            this.m_itemInd[this.m_numGeometries][2] = 0;
            return this.m_currentGeom;
        }
        return this.m_currentGeom;
    }

    public void selectGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        for (int i = 0; i < this.m_numAllGeometries; ++i) {
            if (this.m_allGeometry[i] != pvGeometry) continue;
            this.m_currentGeom = pvGeometry;
            return;
        }
        PsDebug.warning("geometry not found, name = " + pvGeometry.getGeometry().getName());
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return false;
        }
        return this.getGeometryContainer(pgGeometryIf) != null;
    }

    protected PvGeometry getGeometryContainer(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return null;
        }
        for (int i = 0; i < this.m_numAllGeometries; ++i) {
            if (this.m_allGeometry[i].getGeometry() != pgGeometryIf) continue;
            return this.m_allGeometry[i];
        }
        return null;
    }

    private int getNumAllGeometryContainers() {
        return this.m_numGeometries + this.m_special.size();
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_allGeometry;
    }

    private void collectAllGeometries() {
        this.m_numAllGeometries = this.m_numGeometries + this.m_special.size();
        this.m_allGeometry = new PvGeometry[this.m_numAllGeometries];
        if (this.m_numAllGeometries == 0) {
            return;
        }
        for (int i = 0; i < this.m_numGeometries; ++i) {
            this.m_allGeometry[i] = this.m_geometry[i];
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            this.m_allGeometry[i++] = (PvGeometry)enumeration.nextElement();
        }
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 69: {
                break;
            }
            case 70: {
                break;
            }
            default: {
                PsDebug.warning("invalid key = " + n);
            }
        }
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[this.m_maxNumGeometries];
        PdVector[] pdVectorArray2 = new PdVector[this.m_maxNumGeometries];
        int n = 0;
        for (int i = 0; i < this.m_numGeometries; ++i) {
            PdVector[] pdVectorArray3;
            if (!this.m_geometry[i].isVisible() || this.m_geometry[i].m_geometry instanceof PvLight || (pdVectorArray3 = this.m_geometry[i].getBounds(true)) == null) continue;
            pdVectorArray[n] = pdVectorArray3[0];
            pdVectorArray2[n] = pdVectorArray3[1];
            ++n;
        }
        if (n != 0) {
            PdVector.min(this.m_bndBox[0], pdVectorArray, n);
            PdVector.max(this.m_bndBox[1], pdVectorArray2, n);
        }
        if (n == 0) {
            this.m_bndBox[0].setConstant(0.0);
            this.m_bndBox[1].setConstant(0.0);
            return this.m_bndBox;
        }
        return this.m_bndBox;
    }

    public double getDiameter() {
        if (this.m_numItems == 0) {
            return 0.0;
        }
        PdVector[] pdVectorArray = this.getBounds();
        double d = PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
        return d;
    }

    public boolean update(Object object) {
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            if (object != enumeration.nextElement()) continue;
            return true;
        }
        for (int i = 0; i < this.m_numGeometries; ++i) {
            if (this.m_geometry[i] != object) continue;
            if (this.m_itemInd[i][2] == this.m_geometry[i].getNumItems()) {
                return true;
            }
            this.m_itemInd[i][2] = this.m_geometry[i].getNumItems();
            this.assureIndexList();
            return super.update(null);
        }
        PsDebug.warning("missing geometry");
        return super.update(object);
    }

    private void assureIndexList() {
        if (this.m_numGeometries == 0) {
            this.m_maxNumGeometries = 20;
            this.m_geometry = new PvGeometry[this.m_maxNumGeometries];
            this.m_itemInd = new int[this.m_maxNumGeometries][3];
            this.m_numItems = 0;
            this.m_itemHeight = null;
            this.m_itemSort = null;
            return;
        }
        this.m_itemInd[0][0] = 0;
        for (int i = 0; i < this.m_numGeometries; ++i) {
            this.m_itemInd[i][1] = this.m_itemInd[i][0] + this.m_itemInd[i][2] - 1;
            if (i + 1 >= this.m_numGeometries) continue;
            this.m_itemInd[i + 1][0] = this.m_itemInd[i][1] + 1;
        }
        this.m_numItems = this.m_itemInd[this.m_numGeometries - 1][1] + 1;
        if (this.m_itemHeight == null || this.m_itemHeight.length != this.m_numItems) {
            this.m_itemHeight = new double[this.m_numItems];
            this.m_itemSort = new int[this.m_numItems];
        }
    }

    private void copyItemHeight() {
        for (int i = 0; i < this.m_numGeometries; ++i) {
            int n;
            int[] nArray;
            double d;
            int[] nArray2;
            int n2;
            int n3;
            int n4 = 0;
            PvGeometry pvGeometry = this.m_geometry[i];
            if (pvGeometry.m_useVertices) {
                n3 = pvGeometry.getNumVertices();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_itemHeight[this.m_itemInd[i][0] + n2] = pvGeometry.m_vertexTrans[n2].m_data[2];
                }
                n4 = n3;
            } else if (pvGeometry.m_useUnusedVertices && (nArray2 = pvGeometry.getUnusedVertices()) != null) {
                int n5 = pvGeometry.getNumUnusedVertices();
                for (n2 = 0; n2 < n5; ++n2) {
                    this.m_itemHeight[this.m_itemInd[i][0] + n2] = pvGeometry.m_vertexTrans[nArray2[n2]].m_data[2];
                }
                n4 = n5;
            }
            if (pvGeometry.m_useElements) {
                n3 = pvGeometry.getNumElements();
                PiVector[] piVectorArray = pvGeometry.getElements();
                for (n2 = 0; n2 < n3; ++n2) {
                    d = 0.0;
                    nArray = piVectorArray[n2].m_data;
                    if (nArray != null && nArray.length > 0) {
                        for (n = 0; n < nArray.length; ++n) {
                            d += (double)pvGeometry.m_vertexTrans[nArray[n]].m_data[2];
                        }
                        d /= (double)nArray.length;
                    }
                    this.m_itemHeight[this.m_itemInd[i][0] + n4 + n2] = d;
                }
                n4 += n3;
            }
            if (!pvGeometry.m_usePolygons) continue;
            n3 = pvGeometry.getNumPolygons();
            PiVector[] piVectorArray = pvGeometry.getPolygons();
            for (n2 = 0; n2 < n3; ++n2) {
                d = 0.0;
                nArray = piVectorArray[n2].m_data;
                if (nArray == null || nArray.length <= 1) continue;
                for (n = 0; n < nArray.length - 1; ++n) {
                    d = (double)(pvGeometry.m_vertexTrans[nArray[n]].m_data[2] + pvGeometry.m_vertexTrans[nArray[n + 1]].m_data[2]) / 2.0;
                    this.m_itemHeight[this.m_itemInd[i][0] + n4++] = d;
                }
            }
        }
    }

    public void paint(Graphics graphics, PvDisplayIf pvDisplayIf) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        PgGeometryIf[] pgGeometryIfArray;
        double d;
        int n6;
        if (m_bTiming) {
            PsDebug.initTime();
            m_timeTexBnd = 0L;
            m_timeTexScan = 0L;
        }
        if ((n6 = this.getNumAllGeometryContainers()) == 0 || n6 == this.m_numGeometries && this.m_numItems == 0) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = pvDisplayIf.isShowingDepthcue();
        PdMatrix pdMatrix = pvDisplayIf.getTransMatrix(4);
        PdMatrix pdMatrix2 = pvDisplayIf.getTransMatrix(128);
        PdMatrix pdMatrix3 = pvDisplayIf.getTransMatrix(2);
        PdMatrix pdMatrix4 = pvDisplayIf.getTransMatrix(1);
        PdMatrix pdMatrix5 = pvDisplayIf.getTransMatrix(2002);
        PdMatrix pdMatrix6 = pvDisplayIf.getTransMatrix(2001);
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        boolean bl2 = pdMatrix3.m_data[3][2] != 0.0;
        double d5 = pdMatrix3.m_data[3][2];
        if (bl2) {
            this.m_cameraDir.sub(pvCameraIf.getPosition(), pvCameraIf.getInterest());
            d = -1.0 / (PvCamera.SIZE * d5);
            this.m_cameraPos.blendBase(pvCameraIf.getInterest(), d, this.m_cameraDir);
        } else {
            this.m_cameraDir.sub(pvCameraIf.getPosition(), pvCameraIf.getInterest());
            d5 = -0.001;
            d = -1.0 / (PvCamera.SIZE * d5);
            this.m_cameraPos.blendBase(pvCameraIf.getInterest(), d, this.m_cameraDir);
        }
        boolean bl3 = pvDisplayIf.getLightingModel() == 1;
        boolean bl4 = true;
        PvLight[] pvLightArray = null;
        if (bl3) {
            pgGeometryIfArray = pvDisplayIf.getLights();
            pvLightArray = new PvLight[pgGeometryIfArray.length];
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                PvGeometry pvGeometry;
                pvLightArray[i] = (PvLight)pgGeometryIfArray[i];
                if (pvLightArray[i].getShading() != 0) {
                    bl4 = false;
                }
                if (pvLightArray[i].getReference() == 1) {
                    pvLightArray[i].m_directionView.leftMultAffin(pdMatrix2, pvLightArray[i].m_direction, false);
                    pvLightArray[i].m_directionView.normalize();
                    pvGeometry = this.getGeometryContainer(pvLightArray[i]);
                    pvLightArray[i].m_positionView.leftMultAffin(pdMatrix2, pvLightArray[i].m_position, true);
                    pvGeometry.setVertex(0, pvLightArray[i].m_positionView);
                    pvLightArray[i].m_interestView.leftMultAffin(pdMatrix2, pvLightArray[i].m_interest, true);
                    pvGeometry.setVertex(1, pvLightArray[i].m_interestView);
                    if (!pvGeometry.hasModelMatrix()) continue;
                    pvGeometry.getModelMatrix().setIdentity();
                    continue;
                }
                pvLightArray[i].m_positionView.copyArray(pvLightArray[i].m_position);
                pvLightArray[i].m_interestView.copyArray(pvLightArray[i].m_interest);
                pvLightArray[i].m_directionView.copyArray(pvLightArray[i].m_direction);
                pvGeometry = this.getGeometryContainer(pvLightArray[i]);
                pvGeometry.setVertices(pvLightArray[i].getVertices());
            }
        }
        pgGeometryIfArray = this.getAllGeometryContainers();
        Dimension dimension = new Dimension(((PvDisplay)pvDisplayIf).m_widthOff, ((PvDisplay)pvDisplayIf).m_heightOff);
        this.m_zMin = Integer.MAX_VALUE;
        this.m_zMax = Integer.MIN_VALUE;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        for (n5 = 0; n5 < n6; ++n5) {
            if (!((PgGeometry)pgGeometryIfArray[n5]).isVisible()) continue;
            ((PvGeometry)pgGeometryIfArray[n5]).m_dispSize = dimension;
            ((PvGeometry)pgGeometryIfArray[n5]).m_dispSizePS_ZOOM = new Dimension(dimension.width * PvGeometry.PS_ZOOM, dimension.height * PvGeometry.PS_ZOOM);
            ((PvGeometry)pgGeometryIfArray[n5]).m_bPerspectivity = bl2;
            ((PvGeometry)pgGeometryIfArray[n5]).m_bLightsSymmetric = bl4;
            ((PvGeometry)pgGeometryIfArray[n5]).m_cameraPos.copyArray(this.m_cameraPos);
            ((PvGeometry)pgGeometryIfArray[n5]).m_cameraDir.copyArray(this.m_cameraDir);
            if (bl2) {
                ((PvGeometry)pgGeometryIfArray[n5]).m_bAutoClip = pgGeometryIfArray[n5] != this.getGeometryContainer(((PvDisplay)pvDisplayIf).m_coordFrame);
                ((PvGeometry)pgGeometryIfArray[n5]).m_autoClip = 0x7FFFFFF;
            } else {
                ((PvGeometry)pgGeometryIfArray[n5]).m_bAutoClip = false;
            }
            if (!bl5 && ((PgJvxSrc)pgGeometryIfArray[n5]).isShowingVertices() && (((PgJvxSrc)pgGeometryIfArray[n5]).isShowingIndices() || ((PgJvxSrc)pgGeometryIfArray[n5]).isShowingVertexLabels())) {
                bl5 = true;
            }
            if (((PvGeometry)pgGeometryIfArray[n5]).m_bShowTexture) {
                bl6 = true;
            }
            ((PvGeometry)pgGeometryIfArray[n5]).assureTexture(((PvGeometry)pgGeometryIfArray[n5]).m_bShowTexture);
            if (((PvGeometry)pgGeometryIfArray[n5]).m_bShowLocTransparencyOrig || ((PvGeometry)pgGeometryIfArray[n5]).m_bShowTexture && ((PgJvxSrc)pgGeometryIfArray[n5]).getBlendingMode() != 1) {
                bl7 = true;
            }
            if (((PvGeometry)pgGeometryIfArray[n5]).getState(100)) {
                bl8 = true;
            }
            if (((PvGeometry)pgGeometryIfArray[n5]).getState(103)) {
                bl9 = true;
            }
            if (((PvGeometry)pgGeometryIfArray[n5]).getState(151)) {
                ((PvGeometry)pgGeometryIfArray[n5]).setEnabledLighting(false);
                ((PvGeometry)pgGeometryIfArray[n5]).setLights(null);
            } else {
                ((PvGeometry)pgGeometryIfArray[n5]).setEnabledLighting(bl3);
                ((PvGeometry)pgGeometryIfArray[n5]).setLights(pvLightArray);
            }
            ((PvGeometry)pgGeometryIfArray[n5]).setEnabledClipCamera(pvDisplayIf.isEnabledClip());
            ((PvGeometry)pgGeometryIfArray[n5]).m_clipFar = (double)(PvGeometry.PS_ZOOM * PvCamera.Z_STRETCH) * pvDisplayIf.getFarClip();
            ((PvGeometry)pgGeometryIfArray[n5]).m_clipNear = (double)(PvGeometry.PS_ZOOM * PvCamera.Z_STRETCH) * pvDisplayIf.getNearClip();
            ((PvGeometry)pgGeometryIfArray[n5]).setEnabledClipBounds(pvDisplayIf.isEnabledClipBounds());
            if (pvDisplayIf.isEnabledClipBounds()) {
                for (int i = 0; i < 3; ++i) {
                    ((PvGeometry)pgGeometryIfArray[n5]).m_clipBounds[0].setEntry(i, ((PvDisplay)pvDisplayIf).m_clipBoundMin[i].getValue());
                    ((PvGeometry)pgGeometryIfArray[n5]).m_clipBounds[1].setEntry(i, ((PvDisplay)pvDisplayIf).m_clipBoundMax[i].getValue());
                }
            }
            ((PvGeometry)pgGeometryIfArray[n5]).setOffFac(((PvDisplay)pvDisplayIf).m_offFac);
        }
        n5 = ((PvDisplay)pvDisplayIf).isEnabledZBuffer() ? 1 : 0;
        if (bl7 && dimension.width > 0 && dimension.height > 0) {
            if (this.m_tpBuffer == null || this.m_tpBuffer.length != dimension.height || this.m_tpBuffer[0].length != dimension.width) {
                this.m_tpBuffer = new int[dimension.height][dimension.width];
                this.m_colBuffer = new int[dimension.height][dimension.width];
            }
        } else {
            this.m_tpBuffer = null;
            this.m_colBuffer = null;
        }
        long l = 0L;
        if (m_bTiming) {
            l = PsDebug.getTimeIncr();
        }
        for (int i = 0; i < n6; ++i) {
            if (!((PgGeometry)pgGeometryIfArray[i]).isVisible()) continue;
            ((PvGeometry)pgGeometryIfArray[i]).m_camera = pvCameraIf;
            ((PvGeometry)pgGeometryIfArray[i]).m_zBuffer = ((PvDisplay)pvDisplayIf).getZBuffer();
            ((PvGeometry)pgGeometryIfArray[i]).m_colBuffer = this.m_colBuffer;
            ((PvGeometry)pgGeometryIfArray[i]).m_tpBuffer = this.m_tpBuffer;
            if (bl7) {
                if (!((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparencyOrig) {
                    ((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparency = true;
                    ((PvGeometry)pgGeometryIfArray[i]).m_iTransparency = 0;
                }
            } else if (!((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparencyOrig && ((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparency) {
                ((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparency = ((PvGeometry)pgGeometryIfArray[i]).m_bShowLocTransparencyOrig;
                ((PvGeometry)pgGeometryIfArray[i]).m_iTransparency = ((PvGeometry)pgGeometryIfArray[i]).m_locTransparencyOrig;
            }
            ((PvGeometry)pgGeometryIfArray[i]).m_backColor = pvDisplayIf.getBackgroundColor();
            ((PvGeometry)pgGeometryIfArray[i]).m_bShowEdgeAura = pvDisplayIf.isShowingEdgeAura();
            ((PgGeometry)pgGeometryIfArray[i]).showBndBox(pvDisplayIf.isShowingBndBox());
            ((PvGeometry)pgGeometryIfArray[i]).m_bShowEdgeOnce = pvDisplayIf.isShowingEdgesOnce();
            ((PvGeometry)pgGeometryIfArray[i]).m_bShowDepthcue = !((PvGeometry)pgGeometryIfArray[i]).getState(150) && bl;
            ((PvGeometry)pgGeometryIfArray[i]).m_scene = this;
            ((PvGeometry)pgGeometryIfArray[i]).m_bEnableZBuffer = n5;
            PdMatrix pdMatrix7 = null;
            if (((PgGeometry)pgGeometryIfArray[i]).hasModelMatrix()) {
                pdMatrix7 = ((PgGeometry)pgGeometryIfArray[i]).getModelMatrix();
            }
            if (pgGeometryIfArray[i] == this.getGeometryContainer(((PvDisplay)pvDisplayIf).m_coordFrame)) {
                ((PvGeometry)pgGeometryIfArray[i]).projectItems(pdMatrix6, pdMatrix5, pdMatrix, pdMatrix7);
            } else {
                ((PvGeometry)pgGeometryIfArray[i]).projectItems(pdMatrix4, pdMatrix3, pdMatrix, pdMatrix7);
            }
            ((PvGeometry)pgGeometryIfArray[i]).m_bAdaptiveSize = pvDisplayIf.isEnabledAdaptiveSize();
            ((PvGeometry)pgGeometryIfArray[i]).m_bEnable3DLook = pvDisplayIf.isEnabled3DLook();
            if (!this.m_special.contains(pgGeometryIfArray[i])) {
                this.m_zMin = Math.min(this.m_zMin, ((PvGeometry)pgGeometryIfArray[i]).getZMin());
                this.m_zMax = Math.max(this.m_zMax, ((PvGeometry)pgGeometryIfArray[i]).getZMax());
            }
            if (!((PvGeometry)pgGeometryIfArray[i]).m_bEnable3DLook) continue;
            ((PvGeometry)pgGeometryIfArray[i]).m_camPos3D = pvCameraIf.getPosition();
            ((PvGeometry)pgGeometryIfArray[i]).m_camView3D = pvCameraIf.getViewDir();
            ((PvGeometry)pgGeometryIfArray[i]).m_camUp3D = pvCameraIf.getUpVector();
            ((PvGeometry)pgGeometryIfArray[i]).m_camHor3D.cross(((PvGeometry)pgGeometryIfArray[i]).m_camView3D, ((PvGeometry)pgGeometryIfArray[i]).m_camUp3D);
            int n7 = (int)((double)PvCamera.Z_STRETCH * PvCamera.SIZE / (double)Math.min(((PvDisplay)pvDisplayIf).m_nWidth, ((PvDisplay)pvDisplayIf).m_nHeight));
            ((PvGeometry)pgGeometryIfArray[i]).m_z3DLookFac = n7 / ((PvDisplay)pvDisplayIf).m_offFac;
        }
        long l2 = 0L;
        if (m_bTiming) {
            l2 = PsDebug.getTimeIncr();
        }
        if (pvDisplayIf.isEnabledAdaptiveSize() || pvDisplayIf.isEnabled3DLook()) {
            Enumeration enumeration = this.m_special.elements();
            while (enumeration.hasMoreElements()) {
                PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
                pvGeometry.m_bAdaptiveSize = false;
                pvGeometry.m_bEnable3DLook = false;
            }
        }
        if (this.m_bIsBurning) {
            for (int i = 0; i < n6; ++i) {
                if (!((PgGeometry)pgGeometryIfArray[i]).isVisible()) continue;
                PvScene.burnGeometry((PvGeometry)pgGeometryIfArray[i], pvDisplayIf);
            }
            return;
        }
        if (bl6 || n5 != 0 || bl9 || bl8) {
            n4 = (dimension.height + dimension.width) * 2;
            this.m_faceDestBnd = PiVector.realloc(this.m_faceDestBnd, n4, this.m_dimWithZBuffer);
            if (this.m_bndIdentifier == null) {
                this.m_bndIdentifier = new PiVector();
            }
            this.m_bndIdentifier.setSize(2 * n4);
            if (this.m_colDestBnd == null || this.m_colDestBnd.length != n4) {
                this.m_colDestBnd = new int[n4][3];
            }
            if (this.m_lightDestBnd == null || this.m_lightDestBnd.length != n4) {
                this.m_lightDestBnd = new int[n4][6];
            }
            for (int i = 0; i < n6; ++i) {
                ((PvGeometry)pgGeometryIfArray[i]).m_dispSize = dimension;
                if (this.m_imgWidth < 0) {
                    return;
                }
                ((PvGeometry)pgGeometryIfArray[i]).setMIS(this.m_imgWidth, this.m_imgHeight, this.m_pix.m_data);
                ((PvGeometry)pgGeometryIfArray[i]).m_faceDestBnd = this.m_faceDestBnd;
                ((PvGeometry)pgGeometryIfArray[i]).m_colDestBnd = this.m_colDestBnd;
                ((PvGeometry)pgGeometryIfArray[i]).m_lightDestBnd = this.m_lightDestBnd;
                ((PvGeometry)pgGeometryIfArray[i]).m_bndIdentifier = this.m_bndIdentifier;
                ((PvGeometry)pgGeometryIfArray[i]).m_sceneZFac = this.m_zMax - this.m_zMin;
            }
        } else {
            this.m_faceDestBnd = null;
            this.m_bndIdentifier = null;
            this.m_colDestBnd = null;
            this.m_lightDestBnd = null;
            for (n4 = 0; n4 < n6; ++n4) {
                ((PvGeometry)pgGeometryIfArray[n4]).clearMIS();
                ((PvGeometry)pgGeometryIfArray[n4]).m_faceDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n4]).m_colDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n4]).m_lightDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n4]).m_bndIdentifier = null;
            }
        }
        n4 = PvDisplay.isEnabledFastZBuffer() ? 1 : 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (n4 != 0 && n5 != 0) {
                boolean bl10;
                boolean bl11 = ((PvGeometry)pgGeometryIfArray[n3]).m_bShowLocTransparency;
                boolean bl12 = ((PvGeometry)pgGeometryIfArray[n3]).m_bShowTexture;
                boolean bl13 = ((PvGeometry)pgGeometryIfArray[n3]).getState(103);
                boolean bl14 = ((PvGeometry)pgGeometryIfArray[n3]).getState(100);
                ((PvGeometry)pgGeometryIfArray[n3]).m_bFastScanline = bl10 = !bl && !bl11 && !bl12 && !bl13 && !bl14;
            } else {
                ((PvGeometry)pgGeometryIfArray[n3]).m_bFastScanline = false;
            }
            ((PvGeometry)pgGeometryIfArray[n3]).m_bFastClipping = PvDisplay.isEnabledFastClipping();
        }
        if (m_bTiming) {
            l += PsDebug.getTimeIncr();
        }
        this.copyItemHeight();
        if ((n4 == 0 || n5 == 0) && pvDisplayIf.isEnabledPainters() && this.m_numItems > 0) {
            PuMath.heapsort(this.m_numItems, this.m_itemHeight, this.m_itemSort);
            d2 = this.m_itemHeight[this.m_itemSort[0]];
            d3 = this.m_itemHeight[this.m_itemSort[this.m_numItems - 1]];
        } else {
            d3 = Double.NEGATIVE_INFINITY;
            d2 = Double.MAX_VALUE;
            for (n3 = 0; n3 < this.m_numItems; ++n3) {
                if (this.m_itemHeight[n3] > d3) {
                    d3 = this.m_itemHeight[n3];
                } else if (this.m_itemHeight[n3] < d2) {
                    d2 = this.m_itemHeight[n3];
                }
                this.m_itemSort[n3] = n3;
            }
        }
        long l3 = 0L;
        long l4 = 0L;
        if (m_bTiming) {
            l3 = PsDebug.getTimeIncr();
            l4 = l + l2 + l3;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
            if ((pvGeometry.getDrawingOrder() & 2) == 0 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            pvGeometry.showBackface(true);
            int n8 = pvGeometry.getNumItems();
            for (n2 = 0; n2 < n8; ++n2) {
                pvGeometry.drawItem(graphics, n2, d4, 0.0);
            }
            pvGeometry.showBackface(false);
        }
        boolean bl15 = false;
        double d6 = d3 - d2;
        if (d6 < 1.0E-10) {
            bl15 = true;
            d4 = 1.0;
        }
        if (this.m_numGeometries == 1) {
            this.m_geomInd = 0;
            if (this.m_geometry[this.m_geomInd].isVisible()) {
                for (n2 = 0; n2 < this.m_numItems; ++n2) {
                    n = !bl5 && n5 != 0 && !bl7 && !bl6 ? this.m_numItems - this.m_itemSort[n2] - 1 : this.m_itemSort[n2];
                    if (bl && !bl15) {
                        d4 = (this.m_itemHeight[n] - d2) / d6;
                        if (d4 > 1.0) {
                            d4 = 1.0;
                        } else if (d4 < 0.0) {
                            d4 = 0.0;
                        }
                    }
                    this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d4, this.m_itemHeight[n]);
                }
            }
        } else {
            for (n2 = 0; n2 < this.m_numItems; ++n2) {
                n = !bl5 && n5 != 0 && !bl7 && !bl6 ? this.m_numItems - this.m_itemSort[n2] - 1 : this.m_itemSort[n2];
                this.m_geomInd = this.getGeometryIndOfItem(n);
                if (!this.m_geometry[this.m_geomInd].isVisible()) continue;
                if (bl && !bl15) {
                    d4 = (this.m_itemHeight[n] - d2) / d6;
                    if (d4 > 1.0) {
                        d4 = 1.0;
                    } else if (d4 < 0.0) {
                        d4 = 0.0;
                    }
                }
                this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d4, this.m_itemHeight[n]);
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (!((PgGeometry)pgGeometryIfArray[n2]).isVisible() || !((PgGeometry)pgGeometryIfArray[n2]).isShowingName() && !((PgGeometry)pgGeometryIfArray[n2]).isShowingTitle()) continue;
            ((PvGeometry)pgGeometryIfArray[n2]).drawTitle(graphics);
        }
        Enumeration enumeration2 = this.m_special.elements();
        while (enumeration2.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration2.nextElement();
            if ((pvGeometry.getDrawingOrder() & 1) == 0 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            int n9 = pvGeometry.getNumItems();
            for (int i = 0; i < n9; ++i) {
                pvGeometry.drawItem(graphics, i, d4, 0.0);
            }
        }
        if (m_bTiming) {
            long l5 = PsDebug.getTimeIncr();
            l4 = l5 + l3 + l2;
            long l6 = PsDebug.getTimeUsed();
            pvDisplayIf.setName("Time: all = " + l6 + ", setup = " + l4 + ", paint = " + l5 + ", height = " + l3 + ", proj = " + l2 + "\n texBnd = " + m_timeTexBnd + ", texScan = " + m_timeTexScan);
        }
    }

    protected void resetMIS() {
        this.m_bBackImage = false;
        this.m_backColor = -1;
        this.m_bTransparency = false;
        this.m_imgWidth = -1;
        this.m_imgHeight = -1;
        this.m_pix.setSize(0);
        this.m_pixZero.setSize(0);
        this.m_mis = null;
        this.m_destImage = null;
    }

    protected void assureMIS_new(int n, int n2, PvDisplayIf pvDisplayIf, boolean bl) {
        if (this.m_mis == null || this.m_imgHeight != n2 || this.m_imgWidth != n || this.m_bTransparency != bl || this.m_bBackImage != pvDisplayIf.isShowingBackgroundImage() || this.m_backColor != pvDisplayIf.getBackgroundColor().getRGB()) {
            this.m_imgWidth = n;
            this.m_imgHeight = n2;
            if (this.m_pix == null) {
                this.m_pix = new PiVector();
                this.m_pixZero = new PiVector();
            }
            this.m_pix.setSize(this.m_imgWidth * this.m_imgHeight);
            this.m_pixZero.setSize(this.m_imgWidth);
            this.m_bBackImage = pvDisplayIf.isShowingBackgroundImage();
            this.m_backColor = pvDisplayIf.getBackgroundColor().getRGB();
            if (this.m_bBackImage) {
                Image image = ((PvDisplay)pvDisplayIf).m_imageOff;
                this.m_pix.copy(PsImage.getPixels(image), this.m_imgWidth * this.m_imgHeight);
            } else if (bl) {
                this.m_pixZero.setConstant(this.m_backColor & 0xFFFFFF);
            } else if (this.m_bTransparency != bl) {
                this.m_pixZero.setConstant(this.m_backColor);
            } else {
                this.m_pixZero.setConstant(this.m_backColor & 0xFFFFFF);
            }
            if (!this.m_bBackImage) {
                int n3 = 0;
                for (int i = 0; i < this.m_imgHeight; ++i) {
                    System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, n3, this.m_imgWidth);
                    n3 += this.m_imgWidth;
                }
            }
            this.m_bTransparency = bl;
            this.m_mis = new MemoryImageSource(this.m_imgWidth, this.m_imgHeight, this.m_pix.m_data, 0, this.m_imgWidth);
            this.m_mis.setAnimated(true);
            this.m_destImage = ((Component)((Object)pvDisplayIf)).createImage(this.m_mis);
        } else if (!this.m_bBackImage) {
            int n4 = 0;
            for (int i = 0; i < this.m_imgHeight; ++i) {
                System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, n4, this.m_imgWidth);
                n4 += this.m_imgWidth;
            }
        } else {
            Image image = ((PvDisplay)pvDisplayIf).m_imageOff;
            this.m_pix.copy(PsImage.getPixels(image), this.m_imgWidth * this.m_imgHeight);
        }
    }

    protected void drawMIS_new(Graphics graphics, PvDisplayIf pvDisplayIf) {
        if (this.m_mis == null) {
            return;
        }
        this.m_mis.newPixels();
        if (this.m_destImage != null) {
            graphics.drawImage(this.m_destImage, 0, 0, null);
        }
    }

    protected double getHeightOfElementInCurrentGeometry(int n) {
        if (n > this.m_itemInd[this.m_geomInd][2]) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = n + this.m_itemInd[this.m_geomInd][0];
        return this.m_itemHeight[n2];
    }

    private int getGeometryIndOfItem(int n) {
        for (int i = 0; i < this.m_numGeometries; ++i) {
            if (this.m_itemInd[i][0] > n || n > this.m_itemInd[i][1]) continue;
            return i;
        }
        PsDebug.warning("missing geometry of item = " + n);
        return -1;
    }

    protected static void burnGeometry(PvGeometry pvGeometry, PvDisplayIf pvDisplayIf) {
        PdVector[][] pdVectorArray = pvGeometry.getElementTextures();
        if (pdVectorArray == null) {
            PsDebug.warning("missing element texture coordinates, create element textures before calling burn.");
            return;
        }
        int n = pvGeometry.m_textureWidth;
        int n2 = pvGeometry.m_textureHeight;
        if (n < 1 || n2 < 1) {
            PsDebug.warning("missing texture width and height, create texture before calling burn.");
            return;
        }
        int[] nArray = new int[n * n2];
        PsScanline psScanline = new PsScanline();
        boolean bl = false;
        int n3 = pvGeometry.getNumElements();
        for (int i = 0; i < n3; ++i) {
            psScanline.makeScanlines((int)(pdVectorArray[i][0].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[i][0].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray[i][1].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[i][1].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray[i][2].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[i][2].m_data[1]) * (double)(n2 - 1)));
            pvGeometry.burnElement(i, nArray, n, n2, psScanline, bl);
        }
        pvGeometry.setTexture(nArray, n, n2, 0, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        Image image = ((Component)((Object)pvDisplayIf)).createImage(memoryImageSource);
        pvGeometry.getGeometry().setTextureImage(image);
    }
}

