/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;

final class PvModelCamera
extends PsObject {
    protected PdMatrix m_ambient = new PdMatrix();
    protected PdMatrix m_ambientInv = new PdMatrix();
    protected PdMatrix m_incrAmbient = new PdMatrix();
    protected PdMatrix m_incrAmbientInv = new PdMatrix();
    protected PdMatrix m_model = new PdMatrix(4);
    protected PdMatrix m_modelInv = new PdMatrix(4);
    protected PdMatrix m_incrModel = new PdMatrix(4);
    protected PdMatrix m_incrModelInv = new PdMatrix(4);
    protected PdMatrix m_rotMat = new PdMatrix(4);
    protected PdMatrix m_viewCamera = new PdMatrix(4);
    protected PdMatrix m_viewInvCamera = new PdMatrix(4);
    protected int m_mode;
    protected int m_projMode;
    protected int m_transformationMode;
    protected double m_heightOff;
    protected double m_widthOff;
    protected int m_heightPick;
    protected int m_widthPick;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected double[] m_prevNormLoc = new double[2];
    protected double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;
    protected boolean m_bGeometryTrans = true;
    protected int m_xGeomCenter;
    protected int m_yGeomCenter;
    protected PdVector m_geomCenter = new PdVector(3);
    protected PdVector m_geomCenterMod = new PdVector(3);
    protected PdVector m_geomCenterTmp = new PdVector(3);

    public PvModelCamera(PvDisplay pvDisplay) {
        this.m_display = pvDisplay;
        this.m_projMode = 0;
        this.init();
    }

    public void init() {
        super.init();
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_ambient.setIdentity();
        this.m_ambientInv.setIdentity();
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
        this.m_model.setIdentity();
        this.m_modelInv.setIdentity();
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public int getTransformationMode() {
        return this.m_transformationMode;
    }

    public void setTransformationMode(int n) {
        this.m_transformationMode = n;
    }

    public int getProjectionMode() {
        return this.m_projMode;
    }

    public void setProjectionMode(int n) {
        this.m_projMode = n;
    }

    public PdMatrix getAmbientMatrix() {
        return this.m_ambient;
    }

    public PdMatrix getAmbientInvMatrix() {
        return this.m_ambientInv;
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (pdMatrix != null) {
            this.m_ambient.setSize(pdMatrix.getISize(), pdMatrix.getJSize());
            this.m_ambient.copy(pdMatrix);
            this.m_incrAmbient.setSize(pdMatrix.getISize(), pdMatrix.getJSize());
        } else {
            this.m_ambient.setIdentity();
        }
        if (pdMatrix2 != null) {
            this.m_ambientInv.setSize(pdMatrix2.getISize(), pdMatrix2.getJSize());
            this.m_ambientInv.copy(pdMatrix2);
            this.m_incrAmbientInv.setSize(pdMatrix2.getISize(), pdMatrix2.getJSize());
        } else {
            this.m_ambientInv.setIdentity();
        }
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
    }

    public PdMatrix getModelMatrix() {
        return this.m_model;
    }

    public PdMatrix getModelInvMatrix() {
        return this.m_modelInv;
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (pdMatrix != null) {
            this.m_model.copy(pdMatrix);
        } else {
            this.m_model.setIdentity();
        }
        this.m_modelInv.invert34(this.m_model);
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    public void setCurrentView(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        this.m_viewCamera.copy(pdMatrix);
        this.m_viewInvCamera.copy(pdMatrix2);
    }

    protected void resizeImage(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            if (this.m_heightOff > 0.0) {
                PsDebug.warning("target image has a dimension==0");
            }
            return;
        }
        this.m_widthOff = d;
        this.m_heightOff = d2;
    }

    protected void resizeImagePick(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            if (this.m_heightPick > 0) {
                PsDebug.warning("picking device has a dimension==0");
            }
            return;
        }
        this.m_widthPick = n;
        this.m_heightPick = n2;
    }

    protected void mousePressed(int n, int n2) {
        if (!this.m_bGeometryTrans) {
            PvDisplay.normalizedCoords(this.m_prevNormLoc, n, n2, this.m_widthPick, this.m_heightPick);
        } else {
            PvDisplay.normalizedCoords(this.m_prevNormLoc, n - this.m_xGeomCenter + (int)((double)(this.m_widthPick / 2) + 0.5), n2 - this.m_yGeomCenter + (int)((double)(this.m_heightPick / 2) + 0.5), this.m_widthPick, this.m_heightPick);
        }
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * PvCamera.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * PvCamera.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
        switch (this.m_transformationMode) {
            case 0: {
                return;
            }
            case 1: {
                if (this.m_mode != 1 && this.m_mode != 4 && this.m_mode != 3 && this.m_projMode == 0) {
                    if (this.m_mode == 0 && this.m_projMode == 0) {
                        this.m_geomCenterTmp.leftMultAffin(this.m_model, this.m_geomCenter, true);
                        this.m_geomCenterMod.leftMultAffin(this.m_viewCamera, this.m_geomCenterTmp, true);
                    } else if (this.m_mode != 17 || this.m_projMode != 0) {
                        return;
                    }
                }
                if (this.m_display.isEnabledLocalTransform() || this.m_mode != 17 || this.m_projMode == 0) break;
                break;
            }
        }
    }

    protected void mouseDragged(int n, int n2, boolean bl, int n3) {
        if (!this.m_bGeometryTrans) {
            PvDisplay.normalizedCoords(this.m_currNormLoc, n, n2, this.m_widthPick, this.m_heightPick);
        } else {
            PvDisplay.normalizedCoords(this.m_currNormLoc, n - this.m_xGeomCenter + (int)((double)(this.m_widthPick / 2) + 0.5), n2 - this.m_yGeomCenter + (int)((double)(this.m_heightPick / 2) + 0.5), this.m_widthPick, this.m_heightPick);
        }
        if (this.m_currNormLoc[0] == this.m_prevNormLoc[0] && this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
            return;
        }
        double d = this.m_currNormLoc[0] * PvCamera.SIZE / 2.0;
        double d2 = this.m_currNormLoc[1] * PvCamera.SIZE / 2.0;
        double d3 = d + d2;
        double d4 = d - this.m_xTransValue;
        double d5 = d2 - this.m_yTransValue;
        double d6 = d3 - this.m_zTransValue;
        this.m_xTransValue = d;
        this.m_yTransValue = d2;
        this.m_zTransValue = d3;
        switch (this.m_transformationMode) {
            case 0: {
                return;
            }
            case 1: {
                this.m_incrModel.setIdentity();
                this.m_incrModelInv.setIdentity();
                if (this.m_mode == 1) {
                    int n4;
                    double d7 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double d8 = d7 / this.m_scaleValue;
                    double d9 = 1.0 / d8;
                    this.m_scaleTotal *= d8;
                    this.m_scaleValue = d7;
                    for (n4 = 0; n4 < 3; ++n4) {
                        this.m_incrModel.m_data[n4][n4] = d8;
                        this.m_incrModelInv.m_data[n4][n4] = d9;
                    }
                    for (n4 = 0; n4 < 3; ++n4) {
                        double[] dArray = this.m_incrModel.m_data[n4];
                        dArray[3] = dArray[3] + (1.0 - d8) * this.m_geomCenter.m_data[n4];
                        double[] dArray2 = this.m_incrModelInv.m_data[n4];
                        dArray2[3] = dArray2[3] + (1.0 - d9) * this.m_geomCenter.m_data[n4];
                    }
                    this.m_model.rightMult(this.m_incrModel);
                    this.m_modelInv.leftMult(this.m_incrModelInv);
                    return;
                }
                if (this.m_mode == 4) {
                    double[] dArray = this.m_incrModel.m_data[2];
                    dArray[3] = dArray[3] + d6;
                    double[] dArray3 = this.m_incrModelInv.m_data[2];
                    dArray3[3] = dArray3[3] + -d6;
                } else if (this.m_mode == 3 || this.m_projMode != 0) {
                    double[] dArray = this.m_incrModel.m_data[0];
                    dArray[3] = dArray[3] + d4;
                    double[] dArray4 = this.m_incrModel.m_data[1];
                    dArray4[3] = dArray4[3] + d5;
                    double[] dArray5 = this.m_incrModelInv.m_data[0];
                    dArray5[3] = dArray5[3] + -d4;
                    double[] dArray6 = this.m_incrModelInv.m_data[1];
                    dArray6[3] = dArray6[3] + -d5;
                } else if (this.m_mode == 0 && this.m_projMode == 0) {
                    int n5;
                    double d10;
                    this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                    if (bl) {
                        int n6 = 0;
                        if (n3 == 2) {
                            n6 = 1;
                        }
                        if (this.m_vecAlt.getEntry(n6) != 0.0) {
                            this.m_vecAlt.setEntry(n6, 0.0);
                            this.m_vecAlt.normalize();
                        }
                        this.m_vec.setEntry(n6, 0.0);
                        this.m_vec.normalize();
                    }
                    if ((d10 = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d10 > 1.0) {
                        return;
                    }
                    double d11 = 1.5 * Math.acos(d10);
                    if (d11 < 1.0E-10) {
                        return;
                    }
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    this.m_vecAlt.copy(this.m_vec);
                    if (this.m_rotAxis.length() < 1.0E-10) {
                        return;
                    }
                    this.m_rotMat.setIdentity();
                    if (!PuReflect.makeRotation(this.m_rotMat, this.m_rotAxis, d11)) {
                        return;
                    }
                    for (n5 = 0; n5 < 3; ++n5) {
                        double[] dArray = this.m_incrModel.m_data[n5];
                        dArray[3] = dArray[3] + -this.m_geomCenterMod.getEntry(n5);
                    }
                    this.m_incrModel.leftMult(this.m_rotMat);
                    for (n5 = 0; n5 < 3; ++n5) {
                        double[] dArray = this.m_incrModel.m_data[n5];
                        dArray[3] = dArray[3] + this.m_geomCenterMod.getEntry(n5);
                    }
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    for (n5 = 0; n5 < 3; ++n5) {
                        this.m_incrModelInv.m_data[n5][3] = this.m_incrModelInv.m_data[3][n5];
                        this.m_incrModelInv.m_data[3][n5] = 0.0;
                    }
                } else if (this.m_mode == 17 && this.m_projMode == 0) {
                    int n7;
                    double d12;
                    this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                    int n8 = -1;
                    int n9 = -1;
                    if (n3 == 1) {
                        n8 = 0;
                        n9 = 0;
                    } else if (n3 == 2) {
                        n8 = 2;
                        n9 = 1;
                    } else {
                        return;
                    }
                    this.m_vec.setEntry(n9, 0.0);
                    if (!this.m_vec.normalize()) {
                        return;
                    }
                    if (this.m_vecAlt.getEntry(n9) != 0.0) {
                        this.m_vecAlt.setEntry(n9, 0.0);
                        if (!this.m_vecAlt.normalize()) {
                            this.m_vecAlt.copy(this.m_vec);
                            return;
                        }
                    }
                    if ((d12 = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d12 > 1.0) {
                        return;
                    }
                    double d13 = 1.5 * Math.acos(d12);
                    if (d13 < 1.0E-10) {
                        this.m_vecAlt.copy(this.m_vec);
                        return;
                    }
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    if (this.m_rotAxis.getEntry(n9) < 0.0) {
                        this.m_rotAxis.setEntry(n8, -1.0);
                    } else {
                        this.m_rotAxis.setEntry(n8, 1.0);
                    }
                    this.m_rotAxis.setEntry((n8 + 1) % 3, 0.0);
                    this.m_rotAxis.setEntry((n8 + 2) % 3, 0.0);
                    this.m_vecAlt.copy(this.m_vec);
                    this.m_rotMat.setIdentity();
                    if (!PuReflect.makeRotation(this.m_rotMat, this.m_rotAxis, d13)) {
                        return;
                    }
                    for (n7 = 0; n7 < 3; ++n7) {
                        double[] dArray = this.m_incrModel.m_data[n7];
                        dArray[3] = dArray[3] + -this.m_geomCenter.getEntry(n7);
                    }
                    this.m_incrModel.leftMult(this.m_rotMat);
                    for (n7 = 0; n7 < 3; ++n7) {
                        double[] dArray = this.m_incrModel.m_data[n7];
                        dArray[3] = dArray[3] + this.m_geomCenter.getEntry(n7);
                    }
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    for (n7 = 0; n7 < 3; ++n7) {
                        this.m_incrModelInv.m_data[n7][3] = this.m_incrModelInv.m_data[3][n7];
                        this.m_incrModelInv.m_data[3][n7] = 0.0;
                    }
                } else {
                    return;
                }
                if (!(this.m_display.isEnabledLocalTransform() || this.m_mode == 17 && this.m_projMode == 0)) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    if (this.m_bGeometryTrans && this.m_mode == 0 && this.m_projMode == 0) {
                        this.m_model.leftMult(this.m_incrModel, 4);
                        this.m_modelInv.rightMult(this.m_incrModelInv, 4);
                    } else {
                        this.m_model.leftMult(this.m_incrModel);
                        this.m_modelInv.rightMult(this.m_incrModelInv);
                    }
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    break;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                break;
            }
            case 2: {
                double d14;
                d4 /= PvCamera.SIZE;
                d5 /= PvCamera.SIZE;
                d6 /= PvCamera.SIZE;
                int n10 = this.m_incrAmbient.getSize() - 1;
                this.m_incrAmbient.setIdentity();
                this.m_incrAmbientInv.setIdentity();
                int n11 = this.m_display.getAmbientSpace();
                if (this.m_mode == 1) {
                    double d15 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double d16 = d15 / this.m_scaleValue;
                    for (int i = 0; i < n10; ++i) {
                        this.m_incrAmbient.m_data[i][i] = d16;
                        this.m_incrAmbientInv.m_data[i][i] = 1.0 / d16;
                    }
                    this.m_scaleTotal *= d16;
                    this.m_scaleValue = d15;
                    break;
                }
                if (this.m_mode == 4) {
                    if (n11 == 1 || n11 == 2 || n11 == 4 || n11 == 5) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, d6 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 == 3) {
                        this.m_incrAmbient.m_data[2][n10] = d6;
                        this.m_incrAmbientInv.m_data[2][n10] = -d6;
                        break;
                    }
                    if (n11 == 6 || n11 == 9) {
                        this.m_incrAmbient.m_data[2][n10] = d4;
                        this.m_incrAmbientInv.m_data[2][n10] = -d4;
                        this.m_incrAmbient.m_data[3][n10] = d5;
                        this.m_incrAmbientInv.m_data[3][n10] = -d5;
                        break;
                    }
                    if (n11 == 7) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 2, n10 - 1, d6 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 == 10) {
                        PdMatrix pdMatrix = new PdMatrix(n10 + 1);
                        PvModelCamera.translateSpherical(pdMatrix, 2, n10 - 1, d4 *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 3, n10 - 1, d5 *= -Math.PI);
                        this.m_incrAmbient.rightMult(pdMatrix);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 == 8) {
                        PvModelCamera.translateHyperbolic(this.m_incrAmbient, 2, n10 - 1, d6);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 != 11) break;
                    PdMatrix pdMatrix = new PdMatrix(n10 + 1);
                    PvModelCamera.translateHyperbolic(pdMatrix, 2, n10 - 1, d6);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 3, n10 - 1, d6);
                    this.m_incrAmbient.rightMult(pdMatrix);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode == 3 || this.m_projMode != 0) {
                    if (n11 == 0) {
                        this.m_incrAmbient.m_data[0][n10] = d4;
                        this.m_incrAmbientInv.m_data[0][n10] = -d4;
                        break;
                    }
                    if (n11 == 1 || n11 == 3 || n11 == 6 || n11 == 9) {
                        this.m_incrAmbient.m_data[0][n10] = d4;
                        this.m_incrAmbient.m_data[1][n10] = d5;
                        this.m_incrAmbientInv.m_data[0][n10] = -d4;
                        this.m_incrAmbientInv.m_data[1][n10] = -d5;
                        break;
                    }
                    if (n11 == 2) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, n10 - 1, d4 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 == 4 || n11 == 7 || n11 == 10) {
                        PdMatrix pdMatrix = new PdMatrix(n10 + 1);
                        PvModelCamera.translateSpherical(pdMatrix, 0, n10 - 1, d4 *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 1, n10 - 1, d5 *= -Math.PI);
                        this.m_incrAmbient.rightMult(pdMatrix);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n11 != 5 && n11 != 8 && n11 != 11) break;
                    PdMatrix pdMatrix = new PdMatrix(n10 + 1);
                    PvModelCamera.translateHyperbolic(pdMatrix, 0, n10 - 1, d4);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 1, n10 - 1, d5);
                    this.m_incrAmbient.rightMult(pdMatrix);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode == 0 && this.m_projMode == 0) {
                    double d17;
                    if (n11 == 0) {
                        return;
                    }
                    this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                    if (bl) {
                        int n12 = 0;
                        if (n3 == 2) {
                            n12 = 1;
                        }
                        if (this.m_vecAlt.getEntry(n12) != 0.0) {
                            this.m_vecAlt.setEntry(n12, 0.0);
                            this.m_vecAlt.normalize();
                        }
                        this.m_vec.setEntry(n12, 0.0);
                        this.m_vec.normalize();
                    }
                    if ((d17 = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d17 > 1.0) {
                        return;
                    }
                    double d18 = 1.5 * Math.acos(d17);
                    if (d18 < 1.0E-10) {
                        return;
                    }
                    if (n11 == 1 || n11 == 5 || n11 == 2) {
                        if (this.m_vec.getEntry(0) < this.m_vecAlt.getEntry(0)) {
                            d18 = -d18;
                        }
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, d18);
                    } else {
                        this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                        if (this.m_rotAxis.length() < 1.0E-10) {
                            return;
                        }
                        if (!PuReflect.makeRotation(this.m_incrAmbient, this.m_rotAxis, d18)) {
                            return;
                        }
                    }
                    this.m_vecAlt.copy(this.m_vec);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode != 17 || this.m_projMode != 0) break;
                if (n11 == 0) {
                    return;
                }
                this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                int n13 = -1;
                int n14 = -1;
                if (n3 == 1) {
                    n13 = 0;
                    n14 = 0;
                } else if (n3 == 2) {
                    n13 = 2;
                    n14 = 1;
                } else {
                    return;
                }
                this.m_vec.setEntry(n14, 0.0);
                if (!this.m_vec.normalize()) {
                    return;
                }
                if (this.m_vecAlt.getEntry(n14) != 0.0) {
                    this.m_vecAlt.setEntry(n14, 0.0);
                    if (!this.m_vecAlt.normalize()) {
                        this.m_vecAlt.copy(this.m_vec);
                        return;
                    }
                }
                if ((d14 = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d14 > 1.0) {
                    return;
                }
                double d19 = 1.5 * Math.acos(d14);
                if (d19 < 1.0E-10) {
                    this.m_vecAlt.copy(this.m_vec);
                    return;
                }
                this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                if (this.m_rotAxis.getEntry(n14) < 0.0) {
                    this.m_rotAxis.setEntry(n13, -1.0);
                } else {
                    this.m_rotAxis.setEntry(n13, 1.0);
                }
                this.m_rotAxis.setEntry((n13 + 1) % 3, 0.0);
                this.m_rotAxis.setEntry((n13 + 2) % 3, 0.0);
                this.m_vecAlt.copy(this.m_vec);
                if (!PuReflect.makeRotation(this.m_incrAmbient, this.m_rotAxis, d19)) {
                    return;
                }
                this.m_incrAmbientInv.transpose(this.m_incrAmbient);
            }
        }
        this.m_ambient.rightMult(this.m_incrAmbient);
        this.m_ambientInv.leftMult(this.m_incrAmbientInv);
    }

    protected void mouseAnimate() {
        switch (this.getTransformationMode()) {
            default: {
                PsDebug.warning("neither in model nor ambient transformation mode.");
                break;
            }
            case 1: {
                if (!this.m_display.isEnabledLocalTransform()) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    if (this.m_bGeometryTrans && this.m_mode == 0) {
                        this.m_model.leftMult(this.m_incrModel, 3);
                        this.m_modelInv.rightMult(this.m_incrModelInv, 3);
                    } else {
                        this.m_model.leftMult(this.m_incrModel);
                        this.m_modelInv.rightMult(this.m_incrModelInv);
                    }
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    break;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                break;
            }
            case 2: {
                this.m_ambient.rightMult(this.m_incrAmbient);
                this.m_ambientInv.leftMult(this.m_incrAmbientInv);
            }
        }
    }

    private static void translateSpherical(PdMatrix pdMatrix, int n, int n2, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[n][n] = Math.cos(d);
        pdMatrix.m_data[n][n2] = -Math.sin(d);
        pdMatrix.m_data[n2][n] = Math.sin(d);
        pdMatrix.m_data[n2][n2] = Math.cos(d);
    }

    private static void translateHyperbolic(PdMatrix pdMatrix, int n, int n2, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[n][n] = PuMath.cosh(d);
        pdMatrix.m_data[n][n2] = PuMath.sinh(d);
        pdMatrix.m_data[n2][n] = PuMath.sinh(d);
        pdMatrix.m_data[n2][n2] = PuMath.cosh(d);
    }
}

