/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryListenerIf;
import jv.project.PvLightIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsJavaView;
import jv.thirdParty.ruler.PgAxes;
import jv.thirdParty.ruler.PgRuler;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplayCanvasIf;
import jv.viewer.PvDisplay_IP;
import jv.viewer.PvGeometry;
import jv.viewer.PvGrid;
import jv.viewer.PvLight;
import jv.viewer.PvLight_IP;
import jv.viewer.PvModelCamera;
import jv.viewer.PvScene;
import jv.viewer.PvScenegraph;
import jv.viewer.PvViewer;

public final class PvDisplay
extends Canvas
implements PvDisplayIf,
Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
ActionListener,
Serializable {
    public static final int RENDER_AWT = 0;
    public static final int RENDER_PS = 1;
    public static final int RENDER_GL = 2;
    public static final int RENDER_LWJGL = 3;
    protected static final boolean RENDER_COMPATIBLE = true;
    public static int m_renderType = 0;
    protected Canvas m_renderCanvas;
    protected static boolean m_bLicenseChecked = false;
    protected static String m_license = null;
    protected static final int MOUSE_PICKED = 101;
    private static final int MOUSE_DRAGGED = 102;
    private static final int MOUSE_RELEASED = 103;
    protected String[] m_searchPath;
    public String m_defBackgroundImageFile = "images/jvBackground.jpg";
    public String m_backgroundImageFile;
    public String m_defForegroundImageFile = "images/jvFrameDefault_sgl.gif";
    public String m_foregroundImageFile;
    protected static final long PAINT_3DLOOK = 0x2000000000L;
    protected static final long PAINT_ADAPTIVE_SIZE = 0x4000000000L;
    protected static final long PAINT_ALL = 1L;
    protected static final long PAINT_ALL_VIEWS = 0x8000000L;
    protected static final long PAINT_ANTIALIAS = 64L;
    protected static final long PAINT_ANIMATION = 262144L;
    protected static final long PAINT_FOCUS_ENABLED = 0x10000000L;
    protected static final long PAINT_FOCUS = 0x20000000L;
    protected static final long PAINT_INTEGER_PICK = 0x40000000L;
    protected static final long PAINT_AXES = 1024L;
    protected static final long PAINT_BACKGROUND = 2L;
    protected static final long PAINT_BACKGROUND_IMAGE = 32L;
    protected static final long PAINT_FOREGROUND_IMAGE = 0x4000000L;
    protected static final long PAINT_BNDBOX = 128L;
    protected static final long PAINT_BORDER = 4L;
    protected static final long PAINT_CENTER = 16384L;
    protected static final long PAINT_CLEAR_SCREEN = 8192L;
    protected static final long PAINT_COPYRIGHT = 524288L;
    protected static final long PAINT_CROSS = 16L;
    protected static final long PAINT_DEPTHCUE = 0x400000L;
    protected static final long PAINT_DETAIL = 0x8000000000L;
    protected static final long PAINT_DOUBLE_BUFFER = 0x1000000L;
    protected static final long PAINT_EDGE_AURA = 0x200000L;
    protected static final long PAINT_EDGES_ONCE = 0x100000L;
    protected static final long PAINT_FILL_DISPLAY = 0x40000000000L;
    protected static final long PAINT_FRAME = 512L;
    protected static final long PAINT_GRID = 32768L;
    protected static final long PAINT_CAMERA = 0x800000000L;
    protected static final long PAINT_INTEREST = 0x1000000000L;
    protected static final long PAINT_INFO = 256L;
    protected static final long PAINT_LIGHT = 0x800000L;
    protected static final long PAINT_MAGNET = 4096L;
    protected static final long PAINT_SCENEGRAPH = 0x80000000000L;
    protected static final long PAINT_PAINTERS = 65536L;
    protected static final long PAINT_CLIP = 0x400000000L;
    protected static final long PAINT_CLIP_AUTO_BOUNDS = 0x20000000000L;
    protected static final long PAINT_CLIP_BOUNDS = 0x100000000L;
    protected static final long PAINT_BOX_RATIO = 0x200000000L;
    protected static final long PAINT_EXT_RENDER = 0x2000000L;
    protected static final long PAINT_SINGLE = 2048L;
    protected static final long PAINT_TITLE = 0x80000000L;
    protected static final long PAINT_URL = 0x10000000000L;
    protected static final long PAINT_ZBUFFER = 131072L;
    protected static final long PAINT_ZOOM = 8L;
    protected static final int ACTION_RESET = 0;
    protected static final int ACTION_CENTER = 1;
    protected static final int ACTION_FOCUS = 2;
    protected static final int ACTION_START = 3;
    protected static final int ACTION_STOP = 4;
    protected int m_pickType;
    protected boolean m_bDirectSelect = false;
    protected boolean m_bMouseInside = false;
    protected boolean m_bMouseDown = false;
    protected String m_name;
    private int m_nameLength;
    private Font m_nameFont;
    protected boolean m_bIsEnabledRepaint;
    protected boolean m_bIsEnabledUpdate;
    protected boolean m_bIsEnabledInspection;
    private transient Applet m_applet;
    protected transient Frame m_frame;
    protected transient PsUpdateIf m_parent;
    protected transient PvViewerIf m_viewer;
    protected boolean m_bSavedDepthcue;
    protected PvGrid[] m_gridArr;
    protected int m_gridOrient = 0;
    protected int m_lightingModel = 0;
    protected Hashtable m_light;
    protected PvLight m_currentLight;
    protected transient PsPanel m_lightPanel = null;
    protected transient PsPanel m_axesPanel = null;
    protected Hashtable m_camera;
    protected PvCamera m_currentCamera;
    protected transient PsPanel m_cameraPanel = null;
    protected transient PsPanel m_infoPanel = null;
    protected PvScene m_scene;
    protected PvGeometry m_currentGeom;
    private String m_currentFrameName;
    protected PgGeometryIf m_geomIf;
    protected boolean m_bCentered;
    protected static final String GEOM_AXES = "axes frame";
    protected static final String GEOM_AXES_0 = "x-axis";
    protected static final String GEOM_AXES_1 = "y-axis";
    protected static final String GEOM_AXES_2 = "z-axis";
    protected static final String GEOM_AXES_3 = "w-axis";
    protected static final String GEOM_BNDBOX = "bndbox";
    protected static final String GEOM_FRAME = "frame";
    protected static final String GEOM_XY_GRID = "xy-grid";
    protected static final String GEOM_CAMERA = "camera position";
    protected static final String GEOM_INTEREST = "camera interes";
    protected Hashtable m_specialGeom;
    protected PgJvxSrc m_coordFrame;
    protected String[] m_coordFrameLabels = new String[]{"X", "Y", "Z", "T", "U", "V", "W"};
    protected int m_mode;
    protected int m_modeMajor;
    protected int m_defModeMajor;
    protected boolean m_bLocalTransform;
    protected PvModelCamera m_modelCamera;
    protected int m_transformationMode;
    protected int m_ambientDim;
    protected int m_ambientSpace = 3;
    protected int m_ambientProj = 0;
    protected transient Vector m_cameraListener;
    protected transient Vector m_geometryListener;
    protected transient Vector m_pickListener;
    protected transient PvPickListenerIf m_pickFocus;
    protected int m_pickedVertex;
    protected PiVector m_pick;
    protected PiVector m_markBox;
    protected Point m_mousePos;
    protected double[] m_mouseNormPos;
    protected int m_backgroundImageFit;
    protected transient Image m_backgroundImage;
    protected int m_foregroundImageFit;
    protected transient Image m_foregroundImage;
    protected transient Image m_imageOff;
    private transient int[][] m_zBuffer;
    protected int m_nHeight = -1;
    protected int m_nWidth = -1;
    protected static Dimension m_defSize = new Dimension(300, 50);
    protected static Dimension m_preferredSize;
    protected boolean m_bAspect;
    protected double m_aspectRatio;
    protected PuInteger m_height;
    protected PuInteger m_width;
    protected int m_heightOff = -1;
    protected int m_widthOff = -1;
    protected int m_heightPick;
    protected int m_widthPick;
    protected long m_sceneFlags;
    protected long m_sceneDefaults;
    protected long m_sceneInitials;
    protected int m_cameraDefault;
    protected static float PS_ZOOM;
    protected PdColor m_foregroundColor;
    protected PdColor m_backgroundColor;
    protected Color m_foregroundColorDefault;
    protected Color m_backgroundColorDefault;
    protected boolean m_bShowBackface;
    protected boolean m_bEnableTag;
    private boolean m_bSaveEnableZBuffer;
    protected boolean m_bRequiresZBuffer;
    protected boolean m_bIsEnabledFastAA = true;
    protected boolean m_bSaveEnableAntiAlias;
    private boolean m_bShowTransparency = false;
    private boolean m_bZBufferWasRequired = false;
    protected static boolean m_bEnableFastZBuffer;
    protected static boolean m_bEnableFastClipping;
    protected transient Thread m_thread;
    protected boolean m_bDrawing = false;
    protected static final int MOUSE_X_CONSTRAINT = 1;
    protected static final int MOUSE_Y_CONSTRAINT = 2;
    private int m_mouseShiftConstraint;
    protected boolean m_bMouseShiftConstraint = false;
    private int xUp;
    private int yUp;
    private int xDown;
    private int yDown;
    private boolean bDrag = false;
    protected PuInteger m_sleep;
    protected boolean m_bFpsEnabled = false;
    private long m_period = 2L;
    private int m_pCount;
    protected transient PopupMenu m_popup;
    private int m_prevKeyPress = -1;
    private int m_prevKeyRelease = -1;
    private String m_copyright;
    private int m_copyrightLength;
    private Font m_copyrightFont;
    private Font m_infoFont;
    private transient PiVector m_pixAA;
    private transient MemoryImageSource m_misAA;
    private transient int m_misAAChunkSize = -1;
    private transient Image m_image;
    protected int m_offFac = 1;
    private transient Graphics m_gOff;
    protected PiVector m_axesEdge;
    protected Color[] m_axesColor;
    protected PdVector m_axesSize;
    protected Color m_bndBoxColor;
    protected double m_bndBoxSize;
    protected PdVector m_defBoxRatio;
    protected PdVector m_boxRatio;
    protected int m_defClipBoundsType = 0;
    protected int m_clipBoundsType;
    protected PuDouble[] m_clipBoundMin;
    protected PuDouble[] m_clipBoundMax;
    protected PvScenegraph m_scenegraph;
    private static int m_numDisplays;
    protected final Object m_so = new Object();
    public boolean m_bInsecureKeyRelease = true;
    protected KeyEvent m_storedKeyEvent;
    private Runnable m_timer2 = new Runnable(){
        private Thread mi_thread = new Thread((Runnable)this, "Timer thread");
        {
            this.mi_thread.setPriority(5);
            this.mi_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = PvDisplay.this.m_so;
                        synchronized (object) {
                            PvDisplay.this.m_so.wait();
                        }
                        Thread.sleep(1L);
                        PvDisplay.this.timer(PvDisplay.this.m_storedKeyEvent);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception in wait() in PuTimer.run");
                    continue;
                }
                break;
            }
        }
    };
    private PdVector[] m_fullBox;
    private PiVector[] m_fullBoxTrans;
    private PiVector[] m_boxTrans;
    PgJvxSrc m_cam;
    PgJvxSrc m_int;
    PdVector vTmp = new PdVector(3);
    protected PgAxes m_axes;
    protected transient PvDisplay m_allParentDisp;
    protected transient PvDisplay[] m_allDisp;
    protected transient Rectangle m_origBnd;
    private boolean m_bNewGraphics = false;
    private String m_dirTitleStatus = "-1";
    private String m_dirGeometriesStatus = "1";
    private String m_dirSpecialsStatus = "0";
    private PgJvxSrc m_strokeSet = null;
    private Vector m_drawnStroke = null;
    private boolean m_bHandDrawing = false;
    private int m_prevMouseX = -1;
    private int m_prevMouseY = -1;
    private int m_currMouseX = -1;
    private int m_currMouseY = -1;
    private int[] m_xCorner = new int[4];
    private int[] m_yCorner = new int[4];
    private int m_strokeSize = 10;
    private int m_novStroke = 0;
    private PvPickEvent m_currentPick;
    private int m_currentElemInd;
    private boolean m_bIsMousePressed = false;
    private boolean m_bIsMouseDragged = false;
    private boolean m_bIsScenegraphPicked = false;
    private boolean m_bFirstAfterPick = true;
    private PdVector m_prevSteer = new PdVector(3);
    private boolean m_bHasDonePaint = true;
    private int m_pickedElement = -1;
    private boolean m_bIsShowingMagnetTmp = false;
    private boolean m_bSaveShowingVertices = false;
    private boolean m_bIsGlowingVertices = false;
    private boolean m_bSaveShowingBndbox = false;
    private boolean m_bIsGlowingBndbox = false;
    private int m_currentCursorTmp = -1;
    private int m_currentCursor = -1;
    private PiVector m_newElement;
    private transient Vector m_popupMenuID = null;
    private transient MenuItem m_menuHelp = null;
    private transient MenuItem m_menuAbout = null;
    private transient MenuItem m_menuClose = null;
    private transient MenuItem m_menuExit = null;
    private transient PgGeometryIf m_popupGeometry = null;
    private transient MenuItem m_menuDelete = null;
    private transient MenuItem m_menuDeleteOther = null;
    private transient MenuItem m_menuDuplicate = null;
    private transient MenuItem m_menuMerge = null;
    private double speed = 0.01;
    private double fps = 0.0;
    protected static String[] m_majorModeMessage;
    protected static String[] m_minorModeMessage;

    public PvDisplay() {
        this(null, null);
        PvDisplay.initModeMessages();
    }

    public PvDisplay(PvViewerIf pvViewerIf) {
        this(pvViewerIf.getApplet(), pvViewerIf.getFrame());
        this.m_viewer = pvViewerIf;
    }

    public PvDisplay(Applet applet, Frame frame) {
        Object object;
        ++m_numDisplays;
        this.m_name = "";
        if (!m_bLicenseChecked && PsConfig.isApplication()) {
            m_license = "license not checked by viewer";
            m_bLicenseChecked = true;
        }
        switch (m_renderType) {
            case 0: 
            case 1: {
                if (m_renderType == 2) break;
                this.m_renderCanvas = this;
                this.enableEvents(48L);
                break;
            }
            case 2: {
                this.m_renderCanvas = (Canvas)PsUtil.newInstance("devGL.viewer.PvGLCanvas");
                ((PvDisplayCanvasIf)((Object)this.m_renderCanvas)).setDisplay(this);
                break;
            }
            case 3: {
                this.m_renderCanvas = (Canvas)PsUtil.newInstance("devLWJGL.viewer.PvLWJGLCanvas");
                ((PvDisplayCanvasIf)((Object)this.m_renderCanvas)).setDisplay(this);
            }
        }
        this.m_renderCanvas.addKeyListener(this);
        this.m_renderCanvas.addMouseListener(this);
        this.m_renderCanvas.addMouseMotionListener(this);
        Class[] classArray = new Class[]{Boolean.TYPE};
        Object[] objectArray = new Object[]{new Boolean(false)};
        try {
            object = this.getClass().getMethod("setFocusTraversalKeysEnabled", classArray);
            ((Method)object).invoke((Object)this, objectArray);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.m_bAspect = false;
        this.m_aspectRatio = 1.25;
        this.m_bIsEnabledRepaint = true;
        this.m_bIsEnabledUpdate = true;
        this.m_defBoxRatio = new PdVector(1.0, 1.0, 1.0);
        this.setBoxRatio(new PdVector(1.0, 1.0, 1.0));
        this.m_frame = frame;
        this.m_applet = applet;
        this.m_specialGeom = new Hashtable(3);
        this.m_camera = new Hashtable(4);
        this.addCamera("Perspective", new PvCamera(this, 0));
        this.m_foregroundColor = new PdColor(PsConfig.getMessage(24252), this);
        this.m_backgroundColor = new PdColor(PsConfig.getMessage(24253), this);
        this.m_pickType = 5;
        this.m_pick = new PiVector(3);
        this.m_pickedVertex = -1;
        this.m_markBox = new PiVector(4);
        this.m_mousePos = new Point();
        this.m_mouseNormPos = new double[2];
        this.m_bndBoxColor = Color.blue;
        this.m_bndBoxSize = 1.0;
        this.m_axesEdge = null;
        this.m_axesSize = new PdVector(3);
        this.m_axesSize.setConstant(1.0);
        this.m_defClipBoundsType = 0;
        this.m_clipBoundsType = 0;
        this.m_clipBoundMin = null;
        this.m_clipBoundMax = null;
        this.m_gridArr = new PvGrid[3];
        this.m_copyright = PsConfig.getCopyright() + ", " + PsConfig.getProgram();
        this.m_copyright = this.m_copyright + " v." + PsConfig.getVersion();
        this.m_copyrightFont = PsConfig.getFont(0);
        object = this.m_renderCanvas.getFontMetrics(this.m_copyrightFont);
        this.m_copyrightLength = ((FontMetrics)object).stringWidth(this.m_copyright);
        this.m_infoFont = PsConfig.getFont(1);
        this.m_scene = new PvScene();
        this.m_sleep = new PuInteger(PsConfig.getMessage(24254), this);
        this.m_height = new PuInteger(PsConfig.getMessage(24255), this);
        this.m_height.setDefBounds(0, 1024, 1, 10);
        this.m_height.setDefValue(PvDisplay.m_defSize.height);
        this.m_height.init();
        this.m_width = new PuInteger(PsConfig.getMessage(24256), this);
        this.m_width.setDefBounds(0, 1280, 1, 10);
        this.m_width.setDefValue(PvDisplay.m_defSize.width);
        this.m_width.init();
        this.setAmbientSpace(this.m_ambientSpace);
        this.setForegroundColor(Color.black);
        if (!PsConfig.isApplication() && this.m_applet != null && this.m_applet.getBackground() != null) {
            this.setBackgroundColor(this.m_applet.getBackground());
        } else {
            this.setBackgroundColor(new Color(225, 225, 225));
        }
        this.selectCamera(0);
        this.m_sceneFlags = 0L;
        this.m_sceneDefaults = 0L;
        this.setPaintTag(285220871L, true);
        this.setEnabledZBuffer(true);
        this.m_bRequiresZBuffer = false;
        this.setEnabledInspection(true);
        this.setEnabledAnimation(false);
        this.showBackgroundImage(false);
        this.showForegroundImage(false);
        this.setBackgroundImageFit(2);
        this.setForegroundImageFit(2);
        this.showBndBox(false);
        this.showCopyright(true);
        this.showTitle(false);
        this.showDepthcue(true);
        this.showEdgeAura(false);
        this.showEdgesOnce(true);
        this.showFrame(false);
        this.showAxes(false);
        this.showGrid(false);
        this.setEnabledFillDisplay(false);
        this.setEnabledAntiAlias(false);
        this.setEnabled3DLook(false);
        this.setEnabledAdaptiveSize(false);
        this.setPaintTag(0x2000000L, false);
        this.setEnabledPainters(true);
        this.setEnabledClip(false);
        this.setEnabledClipAutoBounds(true);
        this.setEnabledClipBounds(false);
        this.setEnabledBoxRatio(false);
        this.m_bSavedDepthcue = this.isShowingDepthcue();
        this.showDepthcue(false);
        this.setLightingModel(1);
        this.createDefaultLights();
        this.showScenegraph(true);
        if (m_renderType == 2) {
            this.setEnabledDoubleBuffer(false);
        }
        this.m_sceneInitials = -1L;
        this.init();
    }

    public void init() {
        if (this.m_name == null || this.m_name.length() == 0) {
            this.m_name = PsConfig.getMessage(24320) + " " + m_numDisplays;
        }
        if (this.m_cameraListener != null) {
            this.m_cameraListener.removeAllElements();
        }
        if (this.m_geometryListener != null) {
            this.m_geometryListener.removeAllElements();
        }
        this.m_sleep.setDefBounds(0, 100, 1, 5);
        this.m_sleep.setDefValue(30);
        this.m_sleep.setEnabled(false);
        this.m_sleep.init();
        this.setEnabledUpdate(true);
        this.m_cameraDefault = 0;
        this.m_bLocalTransform = false;
        this.m_bMouseShiftConstraint = false;
        this.m_mode = -1;
        if (this.m_sceneInitials == -1L) {
            this.m_sceneInitials = this.m_sceneFlags;
            this.setMajorMode(0);
        } else {
            this.removeGeometries();
            this.m_defModeMajor = 0;
            this.init(this.m_sceneInitials);
        }
        this.setTransformationMode(0);
        this.createDefaultPopupItems();
    }

    protected void init(long l) {
        this.stop();
        this.setForegroundColor(this.m_foregroundColorDefault);
        this.setBackgroundColor(this.m_backgroundColorDefault);
        this.m_clipBoundsType = this.m_defClipBoundsType;
        this.setEnabledClip((l & 0x400000000L) != 0L);
        this.setEnabledClipBounds((l & 0x100000000L) != 0L);
        this.selectCamera(this.m_cameraDefault);
        this.m_pickedVertex = -1;
        this.m_pick.setConstant(0);
        this.setPaintTag(1L, (l & 1L) != 0L);
        this.setPaintTag(2L, (l & 2L) != 0L);
        this.setPaintTag(4L, (l & 4L) != 0L);
        this.setPaintTag(8192L, (l & 0x2000L) != 0L);
        this.setPaintTag(16L, (l & 0x10L) != 0L);
        this.setPaintTag(256L, (l & 0x100L) != 0L);
        this.setPaintTag(0x40000000L, (l & 0x40000000L) != 0L);
        this.setPaintTag(2048L, (l & 0x800L) != 0L);
        this.setEnabled3DLook((l & 0x2000000000L) != 0L);
        this.setEnabledAdaptiveSize((l & 0x4000000000L) != 0L);
        this.setEnabledAnimation((l & 0x40000L) != 0L);
        this.setEnabledAntiAlias((l & 0x40L) != 0L);
        this.showAxes((l & 0x400L) != 0L);
        if ((l & 0x400L) == 0L) {
            this.setAxes(null);
        }
        this.showBndBox((l & 0x80L) != 0L);
        this.setEnabledBoxRatio((l & 0x200000000L) != 0L);
        if (this.isEnabledBoxRatio()) {
            this.setBoxRatio(this.m_defBoxRatio);
        }
        this.showBackgroundImage((l & 0x20L) != 0L);
        this.showForegroundImage((l & 0x4000000L) != 0L);
        this.showCamera((l & 0x800000000L) != 0L);
        this.showCopyright((l & 0x80000L) != 0L);
        this.showDepthcue((l & 0x400000L) != 0L);
        this.setEnabledDoubleBuffer((l & 0x1000000L) != 0L);
        this.showEdgeAura((l & 0x200000L) != 0L);
        this.showEdgesOnce((l & 0x100000L) != 0L);
        this.setEnabledFillDisplay((l & 0x40000000000L) != 0L);
        this.showFrame((l & 0x200L) != 0L);
        this.showGrid((l & 0x8000L) != 0L);
        this.showInterest((l & 0x1000000000L) != 0L);
        this.showMagnet((l & 0x1000L) != 0L);
        this.setEnabledMagnetTmp(false);
        this.setEnabledPainters((l & 0x10000L) != 0L);
        this.showTitle((l & 0x80000000L) != 0L);
        this.setEnabledZBuffer((l & 0x20000L) != 0L);
        this.setCurrentMajorMode(this.m_defModeMajor);
        this.showAllViews((l & 0x8000000L) != 0L);
        this.m_currentCamera.reset();
        this.recomputeBndBox();
        this.m_currentCamera.update(this.m_currentCamera);
    }

    public void reset() {
        this.init(this.m_sceneDefaults);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
        if (this.m_name != null) {
            this.m_nameFont = PsConfig.getFont(0);
            FontMetrics fontMetrics = this.m_renderCanvas.getFontMetrics(this.m_nameFont);
            this.m_nameLength = fontMetrics.stringWidth(this.m_name);
        } else {
            this.showTitle(false);
        }
    }

    public String getSceneTitle() {
        return this.m_scene.getName();
    }

    public void setSceneTitle(String string) {
        this.m_scene.setName(string);
    }

    public Canvas getCanvas() {
        return this.m_renderCanvas;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public PvViewerIf getViewer() {
        return this.m_viewer;
    }

    public void setViewer(PvViewerIf pvViewerIf) {
        this.m_viewer = pvViewerIf;
    }

    public boolean isShowingScenegraph() {
        return this.hasPaintTag(0x80000000000L);
    }

    public void showScenegraph(boolean bl) {
        this.setPaintTag(0x80000000000L, bl);
        if (bl) {
            this.m_scenegraph = new PvScenegraph();
            this.m_scenegraph.setPanelMode(1);
            this.parseNodeIcons(this.m_scenegraph);
            this.updateOverlay();
        } else {
            this.m_scenegraph = null;
        }
    }

    private void parseNodeIcons(PvScenegraph pvScenegraph) {
        String string = PsConfig.getImageScenegraph();
        Image image = PsImage.getImageResource(string);
        if (image == null) {
            PsDebug.error("missing scenegraph icon file = " + string);
            return;
        }
        int n = 10;
        int n2 = 14;
        Image[] imageArray = new Image[n];
        for (int i = 0; i < n; ++i) {
            imageArray[i] = this.createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(0, i * n2, n2, n2)));
            PsImage.loadImage(this, imageArray[i]);
        }
        pvScenegraph.setNodeIcons(imageArray, n);
    }

    public void addKeyListener(KeyListener keyListener) {
        if (m_renderType != 2) {
            super.addKeyListener(keyListener);
        } else {
            this.m_renderCanvas.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (m_renderType != 2) {
            super.removeKeyListener(keyListener);
        } else {
            this.m_renderCanvas.removeKeyListener(keyListener);
        }
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            this.m_pickListener = new Vector();
        } else if (this.hasPickListener(pvPickListenerIf)) {
            PsDebug.warning("listener = " + pvPickListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_pickListener.addElement(pvPickListenerIf);
    }

    public boolean hasPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.contains(pvPickListenerIf);
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.removeElement(pvPickListenerIf);
    }

    public void addGeometryListener(PvGeometryListenerIf pvGeometryListenerIf) {
        if (this.m_geometryListener == null) {
            this.m_geometryListener = new Vector();
        } else if (this.hasGeometryListener(pvGeometryListenerIf)) {
            PsDebug.warning("listener = " + pvGeometryListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_geometryListener.addElement(pvGeometryListenerIf);
    }

    public boolean hasGeometryListener(PvGeometryListenerIf pvGeometryListenerIf) {
        if (this.m_geometryListener == null) {
            return false;
        }
        return this.m_geometryListener.contains(pvGeometryListenerIf);
    }

    public boolean removeGeometryListener(PvGeometryListenerIf pvGeometryListenerIf) {
        if (this.m_geometryListener == null) {
            return false;
        }
        return this.m_geometryListener.removeElement(pvGeometryListenerIf);
    }

    public void addCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            this.m_cameraListener = new Vector();
        } else if (this.hasCameraListener(pvCameraListenerIf)) {
            PsDebug.warning("listener = " + pvCameraListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_cameraListener.addElement(pvCameraListenerIf);
    }

    public boolean hasCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.contains(pvCameraListenerIf);
    }

    public boolean removeCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.removeElement(pvCameraListenerIf);
    }

    public void requestPickFocus(PvPickListenerIf pvPickListenerIf) {
        this.m_pickFocus = pvPickListenerIf;
    }

    public void releasePickFocus() {
        this.m_pickFocus = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGeometry(PgGeometryIf pgGeometryIf) {
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            try {
                if (this.isShowingAllViews()) {
                    for (int i = 0; i < 4; ++i) {
                        if (this.m_allDisp[i] == this) continue;
                        this.m_allDisp[i].addGeometry(pgGeometryIf, 0, false);
                        this.m_allDisp[i].update(this.m_allDisp[i]);
                    }
                }
                return this.addGeometry(pgGeometryIf, 0, false);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                PsDebug.outOfMemory(outOfMemoryError);
                return false;
            }
        }
    }

    private boolean addGeometry(PgGeometryIf pgGeometryIf, int n, boolean bl) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry.");
            return false;
        }
        if (this.containsGeometry(pgGeometryIf)) {
            return true;
        }
        pgGeometryIf.addDisplay(this);
        PvGeometry pvGeometry = new PvGeometry(pgGeometryIf.getDimOfVertices());
        pvGeometry.setDrawingOrder(n);
        pvGeometry.setDisplay(this);
        pvGeometry.setGeometry(pgGeometryIf);
        pvGeometry.setSpecial(bl);
        this.m_scene.addGeometry(pvGeometry);
        if (this.m_scene.m_numGeometries != 0 || bl) {
            // empty if block
        }
        if (this.m_scene.m_numGeometries == 1 && !bl) {
            this.selectGeometry(pgGeometryIf);
            if (!this.m_bCentered && this.fit()) {
                this.m_bCentered = true;
                this.saveCameraDefaults();
            }
        }
        if (this.m_scenegraph != null) {
            this.updateOverlay();
        }
        if (this.m_geometryListener != null && !this.m_specialGeom.contains(pgGeometryIf)) {
            Enumeration enumeration = this.m_geometryListener.elements();
            while (enumeration.hasMoreElements()) {
                ((PvGeometryListenerIf)enumeration.nextElement()).addGeometry(pgGeometryIf);
            }
        }
        if (!bl) {
            this.checkIfZBufferIsRequired();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeometries() {
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            if (this.isShowingAllViews()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.m_allDisp[i] == this) continue;
                    this.m_allDisp[i].removeGeometriesDoIt();
                    this.m_allDisp[i].update(this.m_allDisp[i]);
                }
            }
            this.removeGeometriesDoIt();
        }
        if (this.m_scenegraph != null) {
            this.updateOverlay();
        }
    }

    protected void removeGeometriesDoIt() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null) {
            return;
        }
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            PgGeometryIf pgGeometryIf = pvGeometryArray[i].getGeometry();
            pgGeometryIf.removeDisplay(this);
            this.m_scene.removeGeometry(pvGeometryArray[i]);
            if (this.m_geometryListener == null || this.m_specialGeom.contains(pgGeometryIf)) continue;
            Enumeration enumeration = this.m_geometryListener.elements();
            while (enumeration.hasMoreElements()) {
                ((PvGeometryListenerIf)enumeration.nextElement()).removeGeometry(pgGeometryIf);
            }
        }
        this.setCurrentGeometry(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGeometry(PgGeometryIf pgGeometryIf) {
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            if (this.isShowingAllViews()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.m_allDisp[i] == this || !this.m_allDisp[i].containsGeometry(pgGeometryIf)) continue;
                    this.m_allDisp[i].removeGeometryDoIt(pgGeometryIf);
                    this.m_allDisp[i].update(this.m_allDisp[i]);
                }
            }
            return this.removeGeometryDoIt(pgGeometryIf);
        }
    }

    private boolean removeGeometryDoIt(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return true;
        }
        if (!this.containsGeometry(pgGeometryIf)) {
            PsDebug.message("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            return false;
        }
        pgGeometryIf.removeDisplay(this);
        PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgGeometryIf);
        PvGeometry pvGeometry2 = this.m_scene.removeGeometry(pvGeometry);
        if (this.m_geometryListener != null && !this.m_specialGeom.contains(pgGeometryIf)) {
            Enumeration enumeration = this.m_geometryListener.elements();
            while (enumeration.hasMoreElements()) {
                ((PvGeometryListenerIf)enumeration.nextElement()).removeGeometry(pgGeometryIf);
            }
        }
        if (this.m_currentGeom != pvGeometry2) {
            if (pvGeometry2 != null && pvGeometry2.getGeometry() != null && !this.m_specialGeom.contains(pvGeometry2)) {
                this.selectGeometry(pvGeometry2.getGeometry());
            } else {
                this.selectGeometry(null);
            }
        }
        this.checkIfZBufferIsRequired();
        if (this.m_scenegraph != null) {
            this.updateOverlay();
        }
        return true;
    }

    protected boolean removeGeometryInsideDisplay(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return true;
        }
        if (this.m_specialGeom.get(GEOM_XY_GRID) == pgGeometryIf) {
            this.showGrid(false);
        } else if (this.m_specialGeom.get(GEOM_AXES) == pgGeometryIf) {
            this.showAxes(false);
        } else if (this.m_specialGeom.get(GEOM_BNDBOX) == pgGeometryIf) {
            this.showBndBox(false);
        } else if (this.m_specialGeom.get(GEOM_FRAME) == pgGeometryIf) {
            this.showFrame(false);
        } else {
            int n = this.getNumLights();
            boolean bl = false;
            if (n > 0) {
                PvLightIf[] pvLightIfArray = this.getLights();
                for (int i = 0; i < n; ++i) {
                    if (pvLightIfArray[i] != pgGeometryIf) continue;
                    bl = true;
                    this.removeLight(pvLightIfArray[i]);
                    break;
                }
                if (bl && n == 1) {
                    this.setLightingModel(0);
                    if (this.m_bSavedDepthcue) {
                        this.showDepthcue(this.m_bSavedDepthcue);
                    }
                }
            }
            if (bl) {
                return true;
            }
            return this.removeGeometry(pgGeometryIf);
        }
        return true;
    }

    public boolean selectGeometry(PgGeometryIf pgGeometryIf) {
        Enumeration enumeration;
        if (pgGeometryIf != null && !this.containsGeometry(pgGeometryIf)) {
            return false;
        }
        if (pgGeometryIf == this.getSelectedGeometry()) {
            return true;
        }
        this.setCurrentGeometry(this.m_scene.getGeometryContainer(pgGeometryIf));
        if (this.m_currentGeom != null) {
            if (this.getTransformationMode() == 1) {
                this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
                this.updateTransMatrix(true);
            } else if (this.getTransformationMode() == 2) {
                if (this.m_currentGeom.hasAmbientMatrix()) {
                    this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
                } else {
                    this.setTransformationMode(0);
                }
                this.updateTransMatrix(true);
            }
            if (this.getAmbientSpace() != this.m_currentGeom.getAmbientSpace()) {
                this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
            }
            if (this.getAmbientProjection() != this.m_currentGeom.getAmbientProjection()) {
                this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
            }
            if (this.isShowingFrame() && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
                this.recomputeFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.update(this.m_coordFrame);
            }
        } else if (this.m_modelCamera != null) {
            this.setTransformationMode(0);
            this.m_modelCamera = null;
        }
        if (this.isEnabledInspection() && this.m_viewer != null) {
            this.m_viewer.setGeometry(pgGeometryIf);
        }
        this.m_scene.selectGeometry(this.m_currentGeom);
        if (this.m_geometryListener != null && pgGeometryIf != null && !this.m_specialGeom.contains(pgGeometryIf)) {
            enumeration = this.m_geometryListener.elements();
            while (enumeration.hasMoreElements()) {
                ((PvGeometryListenerIf)enumeration.nextElement()).selectGeometry(pgGeometryIf);
            }
        }
        if (this.m_pickListener != null && pgGeometryIf != null && !this.m_specialGeom.contains(pgGeometryIf)) {
            enumeration = this.m_pickListener.elements();
            while (enumeration.hasMoreElements()) {
                ((PvPickListenerIf)enumeration.nextElement()).selectGeometry(pgGeometryIf);
            }
        }
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        return true;
    }

    protected boolean duplicateGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        if (this.m_specialGeom.contains(pgGeometryIf)) {
            PsDebug.warning("not allowed to duplicate special geometry");
            return false;
        }
        PgGeometryIf pgGeometryIf2 = (PgGeometryIf)pgGeometryIf.clone();
        pgGeometryIf2.setName(PsConfig.getMessage(15007) + PsObject.getNumObjects() + "-" + pgGeometryIf.getName());
        this.addGeometry(pgGeometryIf2);
        this.selectGeometry(pgGeometryIf2);
        return true;
    }

    protected boolean mergeVisible() {
        PgGeometryIf pgGeometryIf = null;
        if (this.m_currentGeom != null) {
            pgGeometryIf = this.m_currentGeom.getGeometry();
        }
        return this.mergeVisible(pgGeometryIf);
    }

    protected boolean mergeVisible(PgGeometryIf pgGeometryIf) {
        PgGeometryIf[] pgGeometryIfArray = this.getVisibleGeometries();
        if (pgGeometryIfArray == null || pgGeometryIfArray.length < 1) {
            PsDebug.warning("missing visible geometries.");
            return false;
        }
        if (pgGeometryIf != null && (!pgGeometryIf.isVisible() || this.m_specialGeom.contains(pgGeometryIf))) {
            pgGeometryIf = pgGeometryIfArray[0];
        }
        if (pgGeometryIf == null) {
            PsDebug.warning("missing visible geometry.");
            return false;
        }
        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
            if (pgGeometryIfArray[i] == pgGeometryIf) continue;
            pgGeometryIf.merge(pgGeometryIfArray[i]);
            this.removeGeometry(pgGeometryIfArray[i]);
        }
        pgGeometryIf.update(pgGeometryIf);
        this.selectGeometry(pgGeometryIf);
        return true;
    }

    protected boolean removeOtherGeometries(PgGeometryIf pgGeometryIf) {
        PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
        if (pgGeometryIfArray == null || pgGeometryIfArray.length < 1) {
            PsDebug.warning("missing geometries.");
            return false;
        }
        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
            if (pgGeometryIfArray[i] == pgGeometryIf) continue;
            this.removeGeometry(pgGeometryIfArray[i]);
        }
        this.selectGeometry(pgGeometryIf);
        return true;
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.m_scene.containsGeometry(pgGeometryIf);
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_scene.getAllGeometryContainers();
    }

    protected PvGeometry[] getGeometryContainers() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            if (this.m_specialGeom.contains(pvGeometryArray[i].getGeometry())) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        PvGeometry[] pvGeometryArray2 = new PvGeometry[n];
        int n2 = 0;
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            if (this.m_specialGeom.contains(pvGeometryArray[i].getGeometry())) continue;
            pvGeometryArray2[n2++] = pvGeometryArray[i];
        }
        return pvGeometryArray2;
    }

    protected PgGeometryIf[] getAllGeometries() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            pgGeometryIfArray[i] = pvGeometryArray[i].getGeometry();
        }
        return pgGeometryIfArray;
    }

    public int getNumGeometries() {
        PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
        if (pgGeometryIfArray == null) {
            return 0;
        }
        return pgGeometryIfArray.length;
    }

    public PgGeometryIf[] getGeometries() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null || pvGeometryArray.length == 0) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        if (pgGeometryIfArray.length == 0) {
            return null;
        }
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            pgGeometryIfArray[i] = pvGeometryArray[i].getGeometry();
        }
        return pgGeometryIfArray;
    }

    public PgGeometryIf[] getVisibleGeometries() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null || pvGeometryArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            if (!pvGeometryArray[i].isVisible()) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[n];
        int n2 = 0;
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            if (!pvGeometryArray[i].isVisible()) continue;
            pgGeometryIfArray[n2++] = pvGeometryArray[i].getGeometry();
        }
        return pgGeometryIfArray;
    }

    public PgGeometryIf getSelectedGeometry() {
        if (this.m_currentGeom == null) {
            return null;
        }
        return this.m_currentGeom.getGeometry();
    }

    private synchronized void setCurrentGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            this.m_currentGeom = null;
            this.m_geomIf = null;
        } else {
            PgGeometryIf pgGeometryIf;
            if (this.hasPaintTag(2048L) && this.m_currentGeom != null && this.m_currentGeom != pvGeometry && !this.m_specialGeom.contains(pgGeometryIf = this.m_currentGeom.getGeometry())) {
                if (pgGeometryIf.isVisible()) {
                    pgGeometryIf.setVisible(false);
                }
                if (this.m_currentGeom.isVisible()) {
                    this.m_currentGeom.setVisible(false);
                }
            }
            this.m_currentGeom = pvGeometry;
            if (this.hasPaintTag(2048L) && !this.m_currentGeom.isVisible() && !this.m_currentGeom.isSpecial()) {
                this.m_currentGeom.setVisible(true);
            }
            this.m_geomIf = pvGeometry.getGeometry();
        }
        if (this.m_currentGeom != null && this.isShowingAxes()) {
            this.recomputeAxes();
        }
        if (this.m_currentGeom != null && this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        if (pvGeometry == null) {
            this.setFrameTitle(null);
        } else {
            this.setFrameTitle(this.m_geomIf.getName());
        }
    }

    private void setFrameTitle(String string) {
        if (string != null && this.m_currentFrameName != null && this.m_currentFrameName.equals(string)) {
            return;
        }
        this.m_currentFrameName = string;
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        if (this.m_currentFrameName != null) {
            frame.setTitle(this.m_currentFrameName + " - " + PsConfig.getProgramAndVersion());
        } else {
            frame.setTitle(PsConfig.getProgramAndVersion() + ": ");
        }
    }

    public void center() {
        if (this.m_scene == null) {
            return;
        }
        PdVector[] pdVectorArray = this.getFullBounds();
        if (pdVectorArray == null) {
            return;
        }
        PdVector pdVector = PdVector.blendNew(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        this.m_currentCamera.setInterest(pdVector);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    private PdVector[] getFullBounds() {
        PdVector[] pdVectorArray = this.m_scene.getBounds();
        if (pdVectorArray == null) {
            return null;
        }
        if (this.hasAxes() && this.isShowingAxes() && this.m_axes.isEnabledAutoBounds()) {
            PdVector[] pdVectorArray2 = this.m_axes.getBounds();
            for (int i = 0; i < 3; ++i) {
                if (pdVectorArray2[0].getEntry(i) < pdVectorArray[0].getEntry(i)) {
                    pdVectorArray[0].setEntry(i, pdVectorArray2[0].getEntry(i));
                }
                if (!(pdVectorArray2[1].getEntry(i) > pdVectorArray[1].getEntry(i))) continue;
                pdVectorArray[1].setEntry(i, pdVectorArray2[1].getEntry(i));
            }
        }
        if (this.isEnabledClipBounds()) {
            for (int i = 0; i < 3; ++i) {
                if (pdVectorArray[0].getEntry(i) < this.m_clipBoundMin[i].getValue()) {
                    pdVectorArray[0].setEntry(i, this.m_clipBoundMin[i].getValue());
                }
                if (!(pdVectorArray[1].getEntry(i) > this.m_clipBoundMax[i].getValue())) continue;
                pdVectorArray[1].setEntry(i, this.m_clipBoundMax[i].getValue());
            }
        }
        return pdVectorArray;
    }

    public void saveCameraDefaults() {
        if (this.m_currentCamera == null) {
            return;
        }
        this.m_currentCamera.saveAsDefault();
    }

    public boolean fit() {
        return this.fit(this.m_currentCamera);
    }

    public boolean fit(PvCamera pvCamera) {
        if (this.m_scene == null) {
            return false;
        }
        if (this.m_heightOff <= 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getFullBounds();
        if (pdVectorArray == null) {
            return false;
        }
        PdVector pdVector = PdVector.blendNew(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        pvCamera.setInterest(pdVector);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(pvCamera.m_view, pvCamera.m_viewInv);
        }
        if (this.isEnabledBoxRatio()) {
            if (PdVector.sqrDist(pdVectorArray[0], pdVectorArray[1]) > 1.0E-10) {
                double d = pvCamera.getFieldOfView();
                if (d != 0.0) {
                    pvCamera.setFieldOfView(0.0);
                }
                this.m_boxTrans = this.projectBndBox(this.m_fullBoxTrans, pdVectorArray);
                double d2 = this.m_boxTrans[1].getEntry(0) - this.m_boxTrans[0].getEntry(0);
                double d3 = this.m_boxTrans[1].getEntry(1) - this.m_boxTrans[0].getEntry(1);
                double d4 = d2 / d3;
                double d5 = this.m_widthOff;
                double d6 = this.m_heightOff;
                double d7 = d5 / d6;
                double d8 = pvCamera.getDist();
                double d9 = d4 > d7 ? d5 / d2 : d6 / d3;
                if (d9 < 1.0E-10) {
                    return false;
                }
                double d10 = 1.2;
                if (this.isShowingCopyright() || this.isShowingTitle()) {
                    d10 += 0.1;
                }
                if (Math.abs(d10 / d9 - 1.0) > 0.01) {
                    pvCamera.setDist(d10 * d8 / d9);
                }
                if (d != 0.0) {
                    pvCamera.setFieldOfView(d);
                }
            } else {
                pvCamera.setDist(10.0);
            }
        } else {
            double d = PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
            if (d < 1.0E-10) {
                this.center();
                return false;
            }
            pvCamera.fit(d);
        }
        pvCamera.updatePanels(pvCamera);
        this.updateCameraListener(101);
        return true;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor.getColor();
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColorDefault = color;
        this.m_backgroundColor.setColor(color);
        if (m_renderType != 2) {
            super.setBackground(color);
        } else {
            this.m_renderCanvas.setBackground(color);
        }
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor.getColor();
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColorDefault = color;
        this.m_foregroundColor.setColor(color);
        if (this.m_coordFrame != null) {
            this.m_coordFrame.setGlobalPolygonColor(this.getForegroundColor());
            this.m_coordFrame.setLabelColor(0, this.getForegroundColor());
        }
        if (m_renderType != 2) {
            super.setForeground(color);
        } else {
            this.m_renderCanvas.setForeground(color);
        }
    }

    public boolean isEnabledInspection() {
        return this.m_bIsEnabledInspection;
    }

    public void setEnabledInspection(boolean bl) {
        this.m_bIsEnabledInspection = bl;
    }

    public boolean isEnabledAnimation() {
        return this.hasPaintTag(262144L);
    }

    public void setEnabledAnimation(boolean bl) {
        this.setPaintTag(262144L, bl);
        if (bl) {
            this.start();
        } else {
            this.stop();
        }
    }

    protected int getAmbientDim() {
        return this.m_ambientDim;
    }

    public int getAmbientSpace() {
        if (this.m_currentGeom != null && this.m_ambientSpace != this.m_currentGeom.getAmbientSpace()) {
            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
        }
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        if (this.m_currentGeom != null && this.m_currentGeom.getAmbientSpace() != n) {
            this.m_currentGeom.setAmbientSpace(n);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientSpace(n);
            }
        }
        switch (n) {
            default: {
                this.m_ambientDim = 3;
                break;
            }
            case 0: {
                this.m_ambientDim = 1;
                break;
            }
            case 1: 
            case 2: {
                this.m_ambientDim = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_ambientDim = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.m_ambientDim = 5;
            }
        }
        this.m_ambientSpace = n;
    }

    public int getAmbientProjection() {
        if (this.m_currentGeom != null) {
            this.m_ambientProj = this.m_currentGeom.getAmbientProjection();
        }
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        if (this.m_currentGeom != null) {
            this.m_currentGeom.setAmbientProjection(n);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientProjection(n);
            }
        }
        this.m_ambientProj = n;
    }

    public boolean isEnabledLocalTransform() {
        return this.m_bLocalTransform;
    }

    public void setEnabledLocalTransform(boolean bl) {
        this.m_bLocalTransform = bl;
    }

    public int getTransformationMode() {
        return this.m_transformationMode;
    }

    public void setTransformationMode(int n) {
        this.m_transformationMode = n;
        if (this.m_transformationMode == 0) {
            this.m_modelCamera = null;
        } else {
            if (this.m_modelCamera == null) {
                this.m_modelCamera = new PvModelCamera(this);
            }
            this.m_modelCamera.setProjectionMode(this.m_currentCamera.getProjectionMode());
            this.m_modelCamera.setMode(this.m_mode);
            this.m_modelCamera.setTransformationMode(this.m_transformationMode);
            this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
            this.m_modelCamera.resizeImagePick(this.m_widthPick, this.m_heightPick);
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            if (this.m_currentGeom == null) {
                return;
            }
            if (this.m_transformationMode != 0) {
                this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
            }
            if (this.m_transformationMode == 2) {
                this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
            }
        }
        if (this.isShowingAxes()) {
            this.recomputeAxes();
        }
        if (this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        if (this.isShowingFrame() && this.m_coordFrame == null && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
            this.recomputeFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
            this.update(this.m_coordFrame);
        }
    }

    public void resetTransformModel() {
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix.setIdentity();
        if (this.m_modelCamera != null) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            this.m_modelCamera.setModelMatrix(pdMatrix);
            this.m_modelCamera.getAmbientMatrix().setIdentity();
            this.m_modelCamera.getAmbientInvMatrix().setIdentity();
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasModelMatrix()) {
            this.m_currentGeom.setModelMatrix(pdMatrix);
            this.m_currentGeom.getGeometry().update(null);
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasAmbientMatrix()) {
            this.m_currentGeom.getAmbientMatrix().setIdentity();
            this.m_currentGeom.getAmbientInvMatrix().setIdentity();
        }
        this.setEnabledLocalTransform(false);
    }

    public String[] getSearchPaths() {
        return this.m_searchPath;
    }

    public void setSearchPaths(String[] stringArray) {
        this.m_searchPath = stringArray;
    }

    public boolean isEnabledFillDisplay() {
        return this.hasPaintTag(0x40000000000L);
    }

    public void setEnabledFillDisplay(boolean bl) {
        if (bl == this.isEnabledFillDisplay()) {
            return;
        }
        this.setPaintTag(0x40000000000L, bl);
        Enumeration enumeration = this.m_camera.elements();
        while (enumeration.hasMoreElements()) {
            PvCamera pvCamera = (PvCamera)enumeration.nextElement();
            pvCamera.setEnabledFillDisplay(bl);
        }
    }

    public int getImageFitMode() {
        return this.getBackgroundImageFit();
    }

    public void setImageFitMode(int n) {
        this.setBackgroundImageFit(n);
    }

    public int getBackgroundImageFit() {
        return this.m_backgroundImageFit;
    }

    public void setBackgroundImageFit(int n) {
        this.m_backgroundImageFit = n;
    }

    public int getForegroundImageFit() {
        return this.m_foregroundImageFit;
    }

    public void setForegroundImageFit(int n) {
        this.m_foregroundImageFit = n;
    }

    public boolean isShowingBackImage() {
        return this.isShowingBackgroundImage();
    }

    public boolean isShowingBackgroundImage() {
        return this.hasPaintTag(32L);
    }

    public void showBackImage(boolean bl) {
        this.showBackgroundImage(bl);
    }

    public void showBackgroundImage(boolean bl) {
        if (bl == this.isShowingBackgroundImage()) {
            return;
        }
        this.setPaintTag(32L, bl);
        if (bl) {
            if (this.m_backgroundImage != null) {
                return;
            }
            if (this.m_backgroundImageFile == null) {
                this.setBackgroundImageFile(this.m_defBackgroundImageFile);
            } else {
                Image image = this.loadImage(this.m_renderCanvas, this.m_backgroundImageFile);
                if (image == null) {
                    return;
                }
                this.setBackgroundImage(image);
            }
        }
    }

    public boolean isShowingForegroundImage() {
        return this.hasPaintTag(0x4000000L);
    }

    public void showForegroundImage(boolean bl) {
        if (bl == this.isShowingForegroundImage()) {
            return;
        }
        this.setPaintTag(0x4000000L, bl);
        if (bl) {
            if (this.m_foregroundImage != null) {
                return;
            }
            if (this.m_foregroundImageFile == null) {
                this.setForegroundImageFile(this.m_defForegroundImageFile);
            } else {
                Image image = this.loadImage(this.m_renderCanvas, this.m_foregroundImageFile);
                if (image == null) {
                    return;
                }
                this.setForegroundImage(image);
            }
        }
    }

    public boolean isShowingCopyright() {
        return this.hasPaintTag(524288L);
    }

    public void showCopyright(boolean bl) {
        this.setPaintTag(524288L, bl);
    }

    public boolean isShowingTitle() {
        return this.hasPaintTag(0x80000000L);
    }

    public void showTitle(boolean bl) {
        this.setPaintTag(0x80000000L, bl);
    }

    public boolean isShowingDepthcue() {
        if (this.m_currentCamera.getProjectionMode() != 0) {
            return false;
        }
        return this.hasPaintTag(0x400000L);
    }

    public void showDepthcue(boolean bl) {
        this.setPaintTag(0x400000L, bl);
    }

    public int getLightingModel() {
        return this.m_lightingModel;
    }

    public void setLightingModel(int n) {
        this.m_lightingModel = n;
        if (this.m_light == null || this.m_light.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_light.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PvLightIf pvLightIf = (PvLightIf)this.m_light.get(string);
            if (this.m_lightingModel == 1) {
                if (!this.m_specialGeom.containsKey(string)) {
                    this.m_specialGeom.put(string, pvLightIf);
                }
                if (this.containsGeometry(pvLightIf)) continue;
                this.addGeometry(pvLightIf, 1, true);
                continue;
            }
            if (this.m_specialGeom.containsKey(string)) {
                this.m_specialGeom.remove(string);
            }
            if (!this.containsGeometry(pvLightIf)) continue;
            this.removeGeometry(pvLightIf);
        }
    }

    public boolean isShowingEdgesOnce() {
        return this.hasPaintTag(0x100000L);
    }

    public void showEdgesOnce(boolean bl) {
        this.setPaintTag(0x100000L, bl);
    }

    public boolean isShowingEdgeAura() {
        return this.hasPaintTag(0x200000L);
    }

    public void showEdgeAura(boolean bl) {
        this.setPaintTag(0x200000L, bl);
    }

    public void setDrawingOrder(int n, PgGeometryIf pgGeometryIf) {
        if (!this.containsGeometry(pgGeometryIf)) {
            if (pgGeometryIf != null) {
                PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            }
            return;
        }
        PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgGeometryIf);
        this.m_scene.removeGeometry(pvGeometry);
        pvGeometry.setDrawingOrder(n);
        this.m_scene.addGeometry(pvGeometry);
    }

    public boolean isShowingGrid() {
        return this.hasPaintTag(32768L);
    }

    public void showGrid(boolean bl) {
        if (bl == this.isShowingGrid()) {
            return;
        }
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
                PvGrid pvGrid;
                this.m_gridArr[0] = pvGrid = new PvGrid(3);
                pvGrid.compute();
                pvGrid.setName(PsConfig.getMessage(15021));
                this.m_specialGeom.put(GEOM_XY_GRID, pvGrid);
                this.addGeometry(pvGrid, 2, true);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_XY_GRID));
            this.m_specialGeom.remove(GEOM_XY_GRID);
        }
        this.setPaintTag(32768L, bl);
        this.update(this);
    }

    public PdVector getGridIncrements(int n) {
        if (n < 0 || n > 2) {
            PsDebug.warning("grid orientation out of bounds, gridOrient = " + n);
            return null;
        }
        if (this.m_gridArr == null || this.m_gridArr[n] == null) {
            return null;
        }
        return this.m_gridArr[n].getGridIncrements();
    }

    public void setGridIncrements(int n, PdVector pdVector) {
        if (n < 0 || n > 2) {
            PsDebug.warning("grid orientation out of bounds, gridOrient = " + n);
            return;
        }
        if (this.m_gridArr == null || this.m_gridArr[n] == null) {
            return;
        }
        this.m_gridArr[n].setGridIncrements(pdVector);
        this.m_gridArr[n].compute();
        this.m_gridArr[n].update(null);
    }

    public int getGridOrientation() {
        return this.m_gridOrient;
    }

    public void setGridOrientation(int n) {
        if (n < 0 || n > 2) {
            PsDebug.warning("grid orientation out of bounds, gridOrient = " + n);
            return;
        }
        if (this.m_gridArr == null || this.m_gridArr[n] == null) {
            return;
        }
        this.m_gridOrient = n;
        this.m_gridArr[n].compute();
        this.m_gridArr[n].update(null);
    }

    public String getFrameLabel(int n) {
        if (n < 0 || n >= this.m_coordFrameLabels.length) {
            PsDebug.warning("wrong index=" + n);
            return null;
        }
        return this.m_coordFrameLabels[n];
    }

    public void setFrameLabel(int n, String string) {
        if (n < 0 || n >= this.m_coordFrameLabels.length) {
            PsDebug.warning("wrong index=" + n);
            return;
        }
        if (string == null) {
            PsDebug.warning("label==null, ignoring");
            return;
        }
        this.m_coordFrameLabels[n] = string;
        if (this.m_coordFrame != null) {
            this.recomputeFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
            this.m_coordFrame.update(null);
        }
    }

    public boolean isShowingFrame() {
        return this.hasPaintTag(512L);
    }

    public void showFrame(boolean bl) {
        if (bl == this.isShowingFrame()) {
            return;
        }
        this.setPaintTag(512L, bl);
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_FRAME)) {
                this.m_coordFrame = new PgJvxSrc();
                this.m_coordFrame.setName(PsConfig.getMessage(15022));
                this.m_coordFrame.setState(151, true);
                this.m_coordFrame.showVertices(true);
                this.m_coordFrame.showPolygons(true);
                this.m_coordFrame.showPolygonEndArrow(true);
                this.m_coordFrame.setEnabledIndexLabels(false);
                this.m_coordFrame.showIndices(true);
                this.m_coordFrame.setGlobalVertexSize(0.0);
                this.m_coordFrame.setGlobalPolygonSize(1.0);
                this.m_coordFrame.setGlobalPolygonColor(this.getForegroundColor());
                this.m_coordFrame.setLabelColor(0, this.getForegroundColor());
                this.recomputeFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.m_specialGeom.put(GEOM_FRAME, this.m_coordFrame);
                this.addGeometry(this.m_coordFrame, 1, true);
                PvGeometry pvGeometry = this.m_scene.getGeometryContainer(this.m_coordFrame);
                pvGeometry.m_bIsClippable = false;
                pvGeometry.setPosition(100, 100);
                this.updateTransMatrix(true);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_FRAME)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME));
            this.m_specialGeom.remove(GEOM_FRAME);
            this.m_coordFrame = null;
        }
        this.update(this);
    }

    private void recomputeFrame(int n, int n2, int n3) {
        if (this.m_coordFrame == null) {
            PsDebug.warning("missing coordinate frame, must call showFrame(true) before.");
            return;
        }
        this.m_coordFrame.setAmbientSpace(n2);
        this.m_coordFrame.setAmbientProjection(n3);
        if (this.m_coordFrame.getDimOfVertices() == n && this.m_coordFrame.getNumPolygons() == n) {
            return;
        }
        this.m_coordFrame.setDimOfVertices(n);
        this.m_coordFrame.setNumVertices(n + 1);
        this.m_coordFrame.setDimOfPolygons(2);
        this.m_coordFrame.setNumPolygons(n);
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = this.m_coordFrame.getVertex(i + 1);
            pdVector.setEntry(i, PvCamera.SIZE / 10.0);
            pdVector.setName(this.m_coordFrameLabels[i]);
            this.m_coordFrame.getPolygon(i).set(0, i + 1);
        }
    }

    public boolean isShowingBndBox() {
        return this.hasPaintTag(128L);
    }

    public void showBndBox(boolean bl) {
        if (bl == this.isShowingBndBox()) {
            return;
        }
        this.setPaintTag(128L, bl);
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setName(PsConfig.getMessage(15023));
                pgJvxSrc.setState(151, true);
                pgJvxSrc.showElements(false);
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalEdgeSize(this.m_bndBoxSize);
                pgJvxSrc.setGlobalEdgeColor(this.m_bndBoxColor);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(8);
                pgJvxSrc.setDimOfElements(3);
                pgJvxSrc.setNumElements(6);
                pgJvxSrc.getElement(0).set(0, 3, 2, 1);
                pgJvxSrc.getElement(1).set(0, 1, 5, 4);
                pgJvxSrc.getElement(2).set(1, 2, 6, 5);
                pgJvxSrc.getElement(3).set(2, 3, 7, 6);
                pgJvxSrc.getElement(4).set(3, 0, 4, 7);
                pgJvxSrc.getElement(5).set(4, 5, 6, 7);
                this.m_specialGeom.put(GEOM_BNDBOX, pgJvxSrc);
                this.addGeometry(pgJvxSrc, 3, true);
            }
            this.recomputeBndBox();
            this.updateTransMatrix(true);
        } else if (this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX));
            this.m_specialGeom.remove(GEOM_BNDBOX);
        }
        this.update(this);
    }

    protected void recomputeBndBox() {
        PvGeometry pvGeometry;
        PgJvxSrc pgJvxSrc = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (pgJvxSrc == null) {
            return;
        }
        if (this.m_currentGeom == null || this.m_currentGeom.getGeometry() == pgJvxSrc) {
            return;
        }
        PdVector[] pdVectorArray = this.getTransformationMode() == 0 ? (this.hasAxes() && !this.m_axes.isEnabledAutoBounds() ? this.m_axes.getBounds() : this.m_scene.getBounds()) : this.m_currentGeom.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        if (this.isEnabledClipBounds()) {
            for (int i = 0; i < 3; ++i) {
                if (pdVectorArray[0].getEntry(i) < this.m_clipBoundMin[i].getValue()) {
                    pdVectorArray[0].setEntry(i, this.m_clipBoundMin[i].getValue());
                }
                if (!(pdVectorArray[1].getEntry(i) > this.m_clipBoundMax[i].getValue())) continue;
                pdVectorArray[1].setEntry(i, this.m_clipBoundMax[i].getValue());
            }
        }
        if (this.m_currentCamera.isEnabledSceneRatio()) {
            this.m_currentCamera.setSceneRatio(1.0);
            PdVector[] pdVectorArray2 = this.getFullBounds();
            double d = pdVectorArray2[1].getEntry(0) - pdVectorArray2[0].getEntry(0);
            double d2 = pdVectorArray2[1].getEntry(1) - pdVectorArray2[0].getEntry(1);
            if (this.isEnabledBoxRatio()) {
                d *= this.m_boxRatio.getEntry(0);
                d2 *= this.m_boxRatio.getEntry(1);
            }
            double d3 = d / d2;
            this.m_currentCamera.setSceneRatio(d3);
        }
        if (pgJvxSrc.isShowingBackface()) {
            pgJvxSrc.showBackface(false);
        }
        pgJvxSrc.setVertex(0, pdVectorArray[0]);
        pgJvxSrc.getVertex(1).set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]);
        pgJvxSrc.getVertex(2).set(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        pgJvxSrc.getVertex(3).set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        pgJvxSrc.getVertex(4).set(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        pgJvxSrc.getVertex(5).set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        pgJvxSrc.setVertex(6, pdVectorArray[1]);
        pgJvxSrc.getVertex(7).set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]);
        pgJvxSrc.makeElementNormals();
        if (this.m_scene != null && (pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc)) != null) {
            pvGeometry.update(pgJvxSrc);
        }
    }

    private PiVector[] projectBndBox(PiVector[] piVectorArray, PdVector[] pdVectorArray) {
        if (this.m_fullBox == null) {
            this.m_fullBox = PdVector.realloc(null, 8, 3);
            this.m_fullBoxTrans = PiVector.realloc(null, 8, 3);
            this.m_boxTrans = PiVector.realloc(null, 2, 3);
        }
        this.m_fullBox[0].copy(pdVectorArray[0]);
        this.m_fullBox[1].set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_fullBox[2].set(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_fullBox[3].set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_fullBox[4].set(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        this.m_fullBox[5].set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        this.m_fullBox[6].copy(pdVectorArray[1]);
        this.m_fullBox[7].set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]);
        PdMatrix pdMatrix = this.getTransMatrix(1);
        for (int i = 0; i < 8; ++i) {
            PvDisplay.projectBndBox(this.m_fullBoxTrans[i], this.m_fullBox[i], pdMatrix);
        }
        PiVector.min(this.m_boxTrans[0], this.m_fullBoxTrans, 8);
        PiVector.max(this.m_boxTrans[1], this.m_fullBoxTrans, 8);
        return this.m_boxTrans;
    }

    private static void projectBndBox(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix) {
        boolean bl;
        boolean bl2 = bl = pdMatrix.m_data[3][2] != 0.0;
        if (bl) {
            int n;
            double d = pdMatrix.m_data[3][3];
            for (n = 0; n < 3; ++n) {
                d += pdMatrix.m_data[3][n] * pdVector.m_data[n];
            }
            n = Math.abs(d) > 1.0E-8 ? 1 : 0;
            for (int i = 0; i < 3; ++i) {
                double d2 = pdMatrix.m_data[i][3];
                for (int j = 0; j < 3; ++j) {
                    d2 += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                }
                piVector.m_data[i] = i < 2 && n != 0 ? (int)(d2 / d + 0.3) : (int)(d2 + 0.3);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                double d = pdMatrix.m_data[i][3];
                for (int j = 0; j < 3; ++j) {
                    d += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                }
                piVector.m_data[i] = (int)(d + 0.5);
            }
        }
    }

    public Color getBndBoxColor() {
        return this.m_bndBoxColor;
    }

    public void setBndBoxColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing bounding box color");
            return;
        }
        this.m_bndBoxColor = color;
        PgJvxSrc pgJvxSrc = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (pgJvxSrc != null) {
            pgJvxSrc.setGlobalEdgeColor(color);
        }
        if (pgJvxSrc != null && this.m_scene != null) {
            PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc);
            pvGeometry.setGlobalEdgeColor(color);
        }
    }

    public double getBndBoxSize() {
        return this.m_bndBoxSize;
    }

    public void setBndBoxSize(double d) {
        this.m_bndBoxSize = d;
        PgJvxSrc pgJvxSrc = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (pgJvxSrc != null) {
            pgJvxSrc.setGlobalEdgeSize(d);
        }
    }

    public boolean isShowingInterest() {
        return this.hasPaintTag(0x1000000000L);
    }

    public void showInterest(boolean bl) {
        if (bl == this.isShowingInterest()) {
            return;
        }
        this.setPaintTag(0x1000000000L, bl);
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_INTEREST)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setName(PsConfig.getMessage(15026));
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.setGlobalPolygonSize(this.m_bndBoxSize);
                pgJvxSrc.setGlobalPolygonColor(Color.red.darker());
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(7);
                pgJvxSrc.setDimOfPolygons(3);
                pgJvxSrc.setNumPolygons(3);
                pgJvxSrc.getPolygon(0).set(1, 0, 2);
                pgJvxSrc.getPolygon(1).set(3, 0, 4);
                pgJvxSrc.getPolygon(2).set(5, 0, 6);
                this.m_int = pgJvxSrc;
                this.m_specialGeom.put(GEOM_INTEREST, pgJvxSrc);
                this.addGeometry(pgJvxSrc, 0, true);
                PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc);
                pvGeometry.m_bIsClippable = false;
            }
            this.recomputeInterest();
            this.updateTransMatrix(true);
        } else {
            if (this.m_specialGeom.containsKey(GEOM_INTEREST)) {
                this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_INTEREST));
                this.m_specialGeom.remove(GEOM_INTEREST);
            }
            if (this.m_int != null) {
                this.removeGeometry(this.m_int);
                this.m_int = null;
            }
        }
        this.update(this);
    }

    protected void recomputeInterest() {
        PvGeometry pvGeometry;
        if (this.m_currentCamera == null) {
            return;
        }
        PgJvxSrc pgJvxSrc = this.m_int;
        if (pgJvxSrc == null) {
            return;
        }
        double d = 0.5 * PvCamera.SIZE / 10.0;
        PdVector pdVector = this.m_currentCamera.getInterest();
        pgJvxSrc.setVertex(0, pdVector);
        pgJvxSrc.getVertex(1).add(pdVector, new PdVector(-d, 0.0, 0.0));
        pgJvxSrc.getVertex(2).add(pdVector, new PdVector(d, 0.0, 0.0));
        pgJvxSrc.getVertex(3).add(pdVector, new PdVector(0.0, -d, 0.0));
        pgJvxSrc.getVertex(4).add(pdVector, new PdVector(0.0, d, 0.0));
        pgJvxSrc.getVertex(5).add(pdVector, new PdVector(0.0, 0.0, -d));
        pgJvxSrc.getVertex(6).add(pdVector, new PdVector(0.0, 0.0, d));
        if (this.m_scene != null && (pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc)) != null) {
            if (!this.isShowingAllViews()) {
                pvGeometry.update(pgJvxSrc);
            } else {
                pgJvxSrc.update(pgJvxSrc);
            }
        }
    }

    public boolean isShowingCamera() {
        return this.hasPaintTag(0x800000000L);
    }

    public void showCamera(boolean bl) {
        if (bl == this.isShowingCamera()) {
            return;
        }
        this.setPaintTag(0x800000000L, bl);
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_CAMERA)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(32);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setName(PsConfig.getMessage(15027));
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.setGlobalPolygonSize(this.m_bndBoxSize);
                pgJvxSrc.setGlobalPolygonColor(Color.green.darker());
                pgJvxSrc.showElements(false);
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalEdgeSize(this.m_bndBoxSize);
                pgJvxSrc.setGlobalEdgeColor(this.m_bndBoxColor);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(11);
                pgJvxSrc.setDimOfPolygons(2);
                pgJvxSrc.setNumPolygons(2);
                pgJvxSrc.getPolygon(0).set(8, 9);
                pgJvxSrc.getPolygon(1).set(8, 10);
                pgJvxSrc.setDimOfElements(4);
                pgJvxSrc.setNumElements(5);
                pgJvxSrc.getElement(0).set(0, 1, 2, 3);
                pgJvxSrc.getElement(1).set(1, 0, 4, 5);
                pgJvxSrc.getElement(2).set(2, 1, 5, 6);
                pgJvxSrc.getElement(3).set(3, 2, 6, 7);
                pgJvxSrc.getElement(4).set(0, 3, 7, 4);
                this.m_cam = pgJvxSrc;
                this.m_specialGeom.put(GEOM_CAMERA, pgJvxSrc);
                this.addGeometry(pgJvxSrc, 1, true);
                PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc);
                pvGeometry.m_bIsClippable = false;
            }
            this.recomputeCamera();
            this.updateTransMatrix(true);
        } else {
            if (this.m_specialGeom.containsKey(GEOM_CAMERA)) {
                this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_CAMERA));
                this.m_specialGeom.remove(GEOM_CAMERA);
            }
            if (this.m_cam != null) {
                this.removeGeometry(this.m_cam);
                this.m_cam = null;
            }
        }
        this.update(this);
    }

    protected void recomputeCamera() {
        PvGeometry pvGeometry;
        double d;
        if (this.m_currentCamera == null) {
            return;
        }
        PgJvxSrc pgJvxSrc = this.m_cam;
        if (pgJvxSrc == null) {
            return;
        }
        double d2 = d = this.m_currentCamera.getScale();
        double d3 = d2 * 0.5 * PvCamera.SIZE / 10.0;
        double d4 = d2 * 2.0 * PvCamera.SIZE / 10.0;
        double d5 = PvCamera.SIZE;
        pgJvxSrc.getVertex(0).set(-d3, -d3, d5 + d4);
        pgJvxSrc.getVertex(1).set(d3, -d3, d5 + d4);
        pgJvxSrc.getVertex(2).set(d3, d3, d5 + d4);
        pgJvxSrc.getVertex(3).set(-d3, d3, d5 + d4);
        pgJvxSrc.getVertex(4).set(-d3, -d3, d5 + 0.0);
        pgJvxSrc.getVertex(5).set(d3, -d3, d5 + 0.0);
        pgJvxSrc.getVertex(6).set(d3, d3, d5 + 0.0);
        pgJvxSrc.getVertex(7).set(-d3, d3, d5 + 0.0);
        pgJvxSrc.getVertex(8).set(0.0, 0.0, d5 + 0.0);
        pgJvxSrc.getVertex(9).set(0.0, 2.0 * d3, d5 + 0.0);
        pgJvxSrc.getVertex(10).set(0.0, 0.0, d5 - d4);
        PdMatrix pdMatrix = this.m_currentCamera.m_viewInv;
        for (int i = 0; i < 11; ++i) {
            PdVector pdVector = pgJvxSrc.getVertex(i);
            this.vTmp.copyArray(pdVector);
            pdVector.leftMultAffin(pdMatrix, this.vTmp, true);
        }
        if (this.m_scene != null && (pvGeometry = this.m_scene.getGeometryContainer(pgJvxSrc)) != null) {
            if (!this.isShowingAllViews()) {
                pvGeometry.update(pgJvxSrc);
            } else {
                pgJvxSrc.update(pgJvxSrc);
            }
        }
    }

    public boolean isEnabledClearScreen() {
        return this.hasPaintTag(8192L);
    }

    public void setEnabledClearScreen(boolean bl) {
        this.setPaintTag(8192L, bl);
    }

    public boolean addLight(PvLightIf pvLightIf) {
        if (pvLightIf == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.hasLight(pvLightIf) || this.m_light != null && this.m_light.get(pvLightIf.getName()) != null) {
            PsDebug.warning("light already registered in scene");
            return false;
        }
        if (this.m_light == null) {
            this.m_light = new Hashtable(2);
        }
        Random random = new Random();
        long l = System.currentTimeMillis() >>> 16 << 16;
        String string = "light" + String.valueOf(l) + String.valueOf(random.nextInt());
        this.m_light.put(string, pvLightIf);
        if (this.m_currentLight == null) {
            this.selectLight(pvLightIf);
        }
        this.m_specialGeom.put(string, pvLightIf);
        this.addGeometry(pvLightIf, 1, true);
        PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pvLightIf);
        pvGeometry.setSpecial(true);
        pvGeometry.m_bIsClippable = false;
        pvGeometry.m_bShowDepthcue = false;
        return true;
    }

    public int getNumLights() {
        if (this.m_light == null) {
            return 0;
        }
        return this.m_light.size();
    }

    public PvLightIf getLight() {
        return this.m_currentLight;
    }

    public PvLightIf[] getLights() {
        if (this.m_light == null) {
            return null;
        }
        PvLightIf[] pvLightIfArray = new PvLightIf[this.m_light.size()];
        int n = 0;
        Enumeration enumeration = this.m_light.elements();
        while (enumeration.hasMoreElements()) {
            pvLightIfArray[n] = (PvLightIf)enumeration.nextElement();
            ((PvLight)pvLightIfArray[n]).project();
            ++n;
        }
        return pvLightIfArray;
    }

    private String getRegisteredNameOfLight(PvLightIf pvLightIf) {
        if (this.m_light == null) {
            return null;
        }
        Enumeration enumeration = this.m_light.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (pvLightIf != this.m_light.get(string)) continue;
            return string;
        }
        return null;
    }

    public boolean hasLight(PvLightIf pvLightIf) {
        if (this.m_light == null || pvLightIf == null) {
            return false;
        }
        return this.m_light.contains(pvLightIf);
    }

    public void removeLights() {
        if (this.m_light == null || this.m_light.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_light.elements();
        while (enumeration.hasMoreElements()) {
            PvLightIf pvLightIf = (PvLightIf)enumeration.nextElement();
            this.removeLight(pvLightIf);
        }
    }

    public boolean removeLight(PvLightIf pvLightIf) {
        if (this.m_light == null || !this.hasLight(pvLightIf)) {
            return false;
        }
        String string = this.getRegisteredNameOfLight(pvLightIf);
        if (string != null) {
            this.m_light.remove(string);
            if (this.containsGeometry(pvLightIf)) {
                this.removeGeometry(pvLightIf);
            }
            if (this.m_specialGeom.containsKey(string)) {
                this.m_specialGeom.remove(string);
            }
        }
        if (this.m_currentLight == pvLightIf) {
            PvLight pvLight = null;
            if (this.m_light.size() > 0) {
                pvLight = (PvLight)this.m_light.elements().nextElement();
            }
            this.selectLight(pvLight);
        }
        return true;
    }

    public PvLightIf getSelectedLight() {
        return this.m_currentLight;
    }

    public boolean hasAxes() {
        return this.m_axes != null;
    }

    public void recomputeAxes() {
        if (this.m_axes == null) {
            return;
        }
        if (this.m_currentGeom == null) {
            return;
        }
        int n = this.m_axes.getCoordSystem();
        PdVector[] pdVectorArray = (n == 0 || n == 1) && this.getTransformationMode() == 0 ? this.m_scene.getBounds() : this.m_currentGeom.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        if (this.isEnabledClipBounds()) {
            for (int i = 0; i < 3; ++i) {
                if (pdVectorArray[0].getEntry(i) < this.m_clipBoundMin[i].getValue()) {
                    pdVectorArray[0].setEntry(i, this.m_clipBoundMin[i].getValue());
                }
                if (!(pdVectorArray[1].getEntry(i) > this.m_clipBoundMax[i].getValue())) continue;
                pdVectorArray[1].setEntry(i, this.m_clipBoundMax[i].getValue());
            }
        }
        PdVector pdVector = null;
        if (this.m_currentCamera != null) {
            pdVector = this.m_currentCamera.getViewDir();
        }
        this.m_axes.configure(pdVectorArray, pdVector);
        this.m_axes.update(this.m_axes);
    }

    private void createAxes() {
        if (this.m_axes != null) {
            return;
        }
        this.m_axes = new PgAxes(3);
        this.m_axes.showNames(true);
        this.m_axes.setName(PsConfig.getMessage(15019));
        this.m_axes.setDisplay(this);
        if (this.m_axesPanel != null) {
            this.m_axes.addInspector("Config", this.m_axesPanel);
        }
        this.recomputeAxes();
    }

    private void registerAxes() {
        if (this.m_currentCamera != null) {
            this.m_axes.setCameraType(this.m_currentCamera.getProjectionMode());
        }
        PgRuler[] pgRulerArray = this.m_axes.getAxes();
        int n = this.m_axes.getMode();
        for (int i = 0; i < pgRulerArray.length; ++i) {
            switch (i) {
                case 0: {
                    this.m_specialGeom.put(GEOM_AXES_0, pgRulerArray[i]);
                    break;
                }
                case 1: {
                    this.m_specialGeom.put(GEOM_AXES_1, pgRulerArray[i]);
                    break;
                }
                case 2: {
                    this.m_specialGeom.put(GEOM_AXES_2, pgRulerArray[i]);
                    break;
                }
                case 3: {
                    this.m_specialGeom.put(GEOM_AXES_3, pgRulerArray[i]);
                }
            }
            if (n == 1) {
                this.addGeometry(pgRulerArray[i], 2, true);
            } else {
                this.addGeometry(pgRulerArray[i], 1, true);
            }
            PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgRulerArray[i]);
            pvGeometry.m_bIsClippable = false;
        }
        this.m_specialGeom.put(GEOM_AXES, this.m_axes);
        this.addGeometry(this.m_axes, 1, true);
        PvGeometry pvGeometry = this.m_scene.getGeometryContainer(this.m_axes);
        pvGeometry.m_bIsClippable = false;
        if (!this.hasCameraListener(this.m_axes)) {
            this.addCameraListener(this.m_axes);
        }
        this.updateCameraListener(102);
    }

    private void unregisterAxes() {
        if (!this.m_specialGeom.containsKey(GEOM_AXES)) {
            return;
        }
        PgRuler[] pgRulerArray = this.m_axes.getAxes();
        if (pgRulerArray != null) {
            for (int i = 0; i < pgRulerArray.length; ++i) {
                String string = "axes frame_" + String.valueOf(i);
                this.removeGeometry(pgRulerArray[i]);
                this.m_specialGeom.remove(string);
            }
        }
        this.removeCameraListener(this.m_axes);
        this.removeGeometry(this.m_axes);
        this.m_specialGeom.remove(GEOM_AXES);
        this.m_axes.updatePanels(this.m_axes);
    }

    public PgAxes getAxes() {
        return this.m_axes;
    }

    public void setAxes(PgAxes pgAxes) {
        if (this.m_axes == pgAxes) {
            return;
        }
        if (this.m_axes != null) {
            this.unregisterAxes();
            this.m_axes = null;
        }
        if (pgAxes == null) {
            this.showAxes(false);
            if (this.m_axes != null) {
                this.m_axes.setDisplay(null);
                this.m_axes = null;
            }
        } else {
            this.m_axes = pgAxes;
            pgAxes.setDisplay(this);
            this.registerAxes();
            this.recomputeAxes();
        }
    }

    public boolean isShowingAxes() {
        return this.hasPaintTag(1024L);
    }

    public void showAxes(boolean bl) {
        if (bl == this.isShowingAxes()) {
            return;
        }
        this.setPaintTag(1024L, bl);
        if (bl) {
            if (!this.hasAxes()) {
                this.createAxes();
            }
            this.registerAxes();
        } else {
            this.unregisterAxes();
        }
        this.update(this);
    }

    public int getPickType() {
        return this.m_pickType;
    }

    public void setPickType(int n) {
        this.m_pickType = n;
    }

    public boolean isEnabledIntegerPick() {
        return this.hasPaintTag(0x40000000L);
    }

    public void setEnabledIntegerPick(boolean bl) {
        this.setPaintTag(0x40000000L, bl);
    }

    public boolean isShowingMagnet() {
        return this.hasPaintTag(4096L);
    }

    public void showMagnet(boolean bl) {
        if (bl == this.isShowingMagnet()) {
            return;
        }
        if (!bl && this.m_pickedVertex != -1 && this.m_currentGeom != null) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex, 12);
            this.m_currentGeom.releaseVertex(this.m_pickedVertex, 11);
            this.m_pickedVertex = -1;
        }
        this.setPaintTag(4096L, bl);
    }

    public boolean isEnabledDirectSelect() {
        return this.m_bDirectSelect;
    }

    public void setEnabledDirectSelect(boolean bl) {
        this.m_bDirectSelect = bl;
        if (this.m_bDirectSelect) {
            this.setTransformationMode(1);
        } else {
            this.setTransformationMode(0);
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.update(this.m_currentCamera);
        }
    }

    protected int[][] getZBuffer() {
        return this.m_zBuffer;
    }

    public static boolean isEnabledFastClipping() {
        return m_bEnableFastClipping;
    }

    public static void setEnabledFastClipping(boolean bl) {
        m_bEnableFastClipping = bl;
    }

    public static boolean isEnabledFastZBuffer() {
        return m_bEnableFastZBuffer;
    }

    public static void setEnabledFastZBuffer(boolean bl) {
        m_bEnableFastZBuffer = bl;
    }

    public boolean isEnabledZBuffer() {
        return this.hasPaintTag(131072L);
    }

    public void setEnabledZBuffer(boolean bl) {
        if (this.isEnabledZBuffer() == bl) {
            return;
        }
        this.setPaintTag(131072L, bl);
        this.m_bSaveEnableZBuffer = bl;
        if (bl) {
            this.assureZBuffer(this.m_widthOff, this.m_heightOff);
        } else {
            this.m_zBuffer = null;
            if (this.m_scene != null) {
                this.m_scene.resetMIS();
            }
        }
    }

    protected void resetZBuffer() {
        this.assureZBuffer(this.m_widthOff, this.m_heightOff);
        for (int i = 0; i < this.m_heightOff; ++i) {
            System.arraycopy(this.m_zBuffer[this.m_heightOff], 0, this.m_zBuffer[i], 0, this.m_widthOff);
        }
    }

    private void assureZBuffer(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.m_zBuffer != null && this.m_zBuffer.length == n2 + 1 && this.m_zBuffer[0].length == n) {
            return;
        }
        this.m_zBuffer = new int[n2 + 1][n];
        for (int i = 0; i < n; ++i) {
            this.m_zBuffer[n2][i] = Integer.MIN_VALUE;
        }
    }

    public boolean isEnabledTags() {
        return this.m_bEnableTag;
    }

    public void setEnabledTags(boolean bl) {
        this.m_bEnableTag = bl;
    }

    public boolean isEnabledPainters() {
        return this.hasPaintTag(65536L);
    }

    public void setEnabledPainters(boolean bl) {
        this.setPaintTag(65536L, bl);
    }

    public boolean isEnabledClip() {
        return this.m_currentCamera.m_bEnableClip;
    }

    public void setEnabledClip(boolean bl) {
        this.setPaintTag(0x400000000L, bl);
        this.m_currentCamera.m_bEnableClip = bl;
    }

    public boolean isEnabledClipAutoBounds() {
        return this.hasPaintTag(0x20000000000L);
    }

    public void setEnabledClipAutoBounds(boolean bl) {
        this.setPaintTag(0x20000000000L, bl);
    }

    public boolean isEnabledClipBounds() {
        return this.hasPaintTag(0x100000000L);
    }

    public void setEnabledClipBounds(boolean bl) {
        this.setPaintTag(0x100000000L, bl);
        if (!bl) {
            return;
        }
        this.assureClipBounds();
    }

    public boolean isEnabledBoxRatio() {
        return this.hasPaintTag(0x200000000L);
    }

    public void setEnabledBoxRatio(boolean bl) {
        this.setPaintTag(0x200000000L, bl);
        if (bl && this.m_boxRatio == null) {
            this.m_boxRatio = (PdVector)this.m_defBoxRatio.clone();
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setBoxRatio(this.m_boxRatio);
            this.m_currentCamera.setEnabledBoxRatio(bl);
        }
        if (this.m_axes != null) {
            this.m_axes.setEnabledBoxRatio(bl);
            this.m_axes.setBoxRatio(this.m_boxRatio);
        }
    }

    public PdVector getBoxRatio() {
        return this.m_boxRatio;
    }

    public void setBoxRatio(PdVector pdVector) {
        this.setBoxRatioFromPanel(pdVector);
        if (this.m_boxRatio != null) {
            this.m_defBoxRatio.copyArray(this.m_boxRatio);
        } else {
            this.m_defBoxRatio.setConstant(1.0);
        }
    }

    protected void setBoxRatioFromPanel(PdVector pdVector) {
        if (pdVector == null) {
            this.m_boxRatio = null;
        } else if (this.m_boxRatio == null) {
            this.m_boxRatio = (PdVector)pdVector.clone();
        } else {
            this.m_boxRatio.copyArray(pdVector);
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setBoxRatio(this.m_boxRatio);
        }
        if (this.m_axes != null) {
            this.m_axes.setBoxRatio(this.m_boxRatio);
        }
    }

    public boolean isClip() {
        return this.isEnabledClip();
    }

    public void enableClip(boolean bl) {
        this.setEnabledClip(bl);
    }

    public double getNearClip() {
        return this.m_currentCamera.m_nearClip.getValue();
    }

    public void setNearClip(double d) {
        this.m_currentCamera.m_nearClip.setValue(d);
    }

    public double getFarClip() {
        return this.m_currentCamera.m_farClip.getValue();
    }

    public void setFarClip(double d) {
        this.m_currentCamera.m_farClip.setValue(d);
    }

    public int getClipBoundsType() {
        return this.m_clipBoundsType;
    }

    public void setClipBoundsType(int n) {
        this.m_defClipBoundsType = n;
        this.m_clipBoundsType = n;
    }

    public double[] getClipBounds(int n) {
        if (n < 0 || 2 < n) {
            PsDebug.warning("index out of range [0,2], index = " + n);
            return null;
        }
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.MAX_VALUE;
        if (this.m_clipBoundMin != null && this.m_clipBoundMin[n] != null && this.m_clipBoundMin[n].isEnabled()) {
            d = this.m_clipBoundMin[n].getValue();
        }
        if (this.m_clipBoundMax != null && this.m_clipBoundMax[n] != null && this.m_clipBoundMax[n].isEnabled()) {
            d2 = this.m_clipBoundMax[n].getValue();
        }
        return new double[]{d, d2};
    }

    public void setClipBounds(int n, double[] dArray) {
        if (n < 0 || 2 < n) {
            PsDebug.warning("index out of range [0,2], index = " + n);
            return;
        }
        if (dArray == null) {
            if (this.m_clipBoundMin != null && this.m_clipBoundMin[n] != null) {
                this.m_clipBoundMin[n].setEnabled(false);
            }
            if (this.m_clipBoundMax != null && this.m_clipBoundMax[n] != null) {
                this.m_clipBoundMax[n].setEnabled(false);
            }
            return;
        }
        if (dArray.length < 2) {
            PsDebug.warning("range array too small");
            return;
        }
        this.assureClipBounds();
        if (!this.m_clipBoundMin[n].isEnabled()) {
            this.m_clipBoundMin[n].setEnabled(true);
        }
        this.m_clipBoundMin[n].setValue(dArray[0]);
        if (!this.m_clipBoundMax[n].isEnabled()) {
            this.m_clipBoundMax[n].setEnabled(true);
        }
        this.m_clipBoundMax[n].setValue(dArray[1]);
    }

    private void assureClipBounds() {
        int n;
        if (this.m_clipBoundMin == null) {
            this.m_clipBoundMin = new PuDouble[3];
            this.m_clipBoundMin[0] = new PuDouble(PsConfig.getMessage(24355), this);
            this.m_clipBoundMin[1] = new PuDouble(PsConfig.getMessage(24356), this);
            this.m_clipBoundMin[2] = new PuDouble(PsConfig.getMessage(24357), this);
            for (n = 0; n < 3; ++n) {
                this.m_clipBoundMin[n].setEnabled(false);
            }
        }
        if (this.m_clipBoundMax == null) {
            this.m_clipBoundMax = new PuDouble[3];
            this.m_clipBoundMax[0] = new PuDouble(PsConfig.getMessage(24358), this);
            this.m_clipBoundMax[1] = new PuDouble(PsConfig.getMessage(24359), this);
            this.m_clipBoundMax[2] = new PuDouble(PsConfig.getMessage(24360), this);
            for (n = 0; n < 3; ++n) {
                this.m_clipBoundMax[n].setEnabled(false);
            }
        }
    }

    public boolean isEnabled3DLook() {
        return this.hasPaintTag(0x2000000000L);
    }

    public void setEnabled3DLook(boolean bl) {
        this.setPaintTag(0x2000000000L, bl);
    }

    public boolean isEnabledAdaptiveSize() {
        return this.hasPaintTag(0x4000000000L);
    }

    public void setEnabledAdaptiveSize(boolean bl) {
        this.setPaintTag(0x4000000000L, bl);
    }

    private void setEnabledModelOfSpecial(PgGeometryIf pgGeometryIf, boolean bl) {
        PdMatrix pdMatrix;
        if (pgGeometryIf == null) {
            return;
        }
        PvGeometry pvGeometry = this.m_scene.getGeometryContainer(pgGeometryIf);
        if (pvGeometry == null) {
            return;
        }
        if (!bl) {
            pvGeometry.setModelMatrix(null);
            pvGeometry.setAmbientMatrix(null, null);
            PgGeometryIf pgGeometryIf2 = pvGeometry.getGeometry();
            if (pgGeometryIf2 == null) {
                return;
            }
            pgGeometryIf2.setModelMatrix(null);
            pgGeometryIf2.setAmbientMatrix(null, null);
            return;
        }
        PdMatrix pdMatrix2 = null;
        PdMatrix pdMatrix3 = null;
        if (this.m_currentGeom != null) {
            if (this.getTransformationMode() == 2) {
                pdMatrix2 = this.m_currentGeom.getAmbientMatrix();
                pdMatrix3 = this.m_currentGeom.getAmbientInvMatrix();
            }
            pdMatrix = this.m_currentGeom.getModelMatrix();
        } else if (this.m_modelCamera != null) {
            if (this.getTransformationMode() == 2) {
                pdMatrix2 = this.m_modelCamera.getAmbientMatrix();
                pdMatrix3 = this.m_modelCamera.getAmbientInvMatrix();
            }
            pdMatrix = this.m_modelCamera.getModelMatrix();
        } else {
            return;
        }
        pvGeometry.setModelMatrix(pdMatrix);
        if (this.getTransformationMode() == 2) {
            pvGeometry.setAmbientMatrix(pdMatrix2, pdMatrix3);
            pvGeometry.setAmbientProjection(this.m_ambientProj);
        } else {
            pvGeometry.setAmbientMatrix(null, null);
        }
        PgGeometryIf pgGeometryIf3 = pvGeometry.getGeometry();
        if (pgGeometryIf3 == null) {
            return;
        }
        pgGeometryIf3.setModelMatrix(pdMatrix);
        if (this.getTransformationMode() == 2) {
            pgGeometryIf3.setAmbientMatrix(pdMatrix2, pdMatrix3);
            pgGeometryIf3.setAmbientProjection(this.m_ambientProj);
        } else {
            pgGeometryIf3.setAmbientMatrix(null, null);
        }
    }

    private void updateTransMatrix(boolean bl) {
        int n;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = this.getTransformationMode() == 0;
        if (!bl3 && !bl && this.m_currentGeom != null) {
            this.m_currentGeom.setModelMatrix(this.m_modelCamera.getModelMatrix());
            if (this.getTransformationMode() == 2) {
                this.m_currentGeom.setAmbientMatrix(this.m_modelCamera.getAmbientMatrix(), this.m_modelCamera.getAmbientInvMatrix());
                this.m_currentGeom.setAmbientProjection(this.m_ambientProj);
            }
            bl2 = this.isEnabledUpdate();
            this.setEnabledUpdate(false);
            this.m_currentGeom.getGeometry().update(this.m_currentGeom.getGeometry());
            this.setEnabledUpdate(bl2);
        }
        boolean bl5 = bl2 = !bl3;
        if (this.isShowingFrame()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME), bl2);
        }
        if (this.isShowingBndBox()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX), bl2);
        }
        if (this.isShowingAxes() && this.m_axes != null && ((n = this.m_axes.getCoordSystem()) == 0 || n == 2)) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES), bl2);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get("axes frame_0"), bl2);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get("axes frame_1"), bl2);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get("axes frame_2"), bl2);
        }
    }

    public PdMatrix getTransMatrix(int n) {
        switch (n) {
            case 2000: {
                return this.m_currentCamera.m_transNon;
            }
            case 2003: {
                return this.m_currentCamera.m_transNonInv;
            }
            case 2001: {
                return this.m_currentCamera.m_transNon;
            }
            case 2004: {
                return this.m_currentCamera.m_transNonInv;
            }
            case 2002: {
                return this.m_currentCamera.m_projNon;
            }
            case 2005: {
                return this.m_currentCamera.m_projNonInv;
            }
            case 0: {
                return this.m_currentCamera.m_trans;
            }
            case 16: {
                return this.m_currentCamera.m_transInv;
            }
            case 1: {
                return this.m_currentCamera.m_trans;
            }
            case 32: {
                return this.m_currentCamera.m_transInv;
            }
            case 2: {
                return this.m_currentCamera.m_proj;
            }
            case 64: {
                return this.m_currentCamera.m_projInv;
            }
            case 4: {
                return this.m_currentCamera.m_view;
            }
            case 128: {
                return this.m_currentCamera.m_viewInv;
            }
            case 8: {
                if (this.m_modelCamera == null) {
                    return null;
                }
                return this.m_modelCamera.getModelMatrix();
            }
            case 256: {
                if (this.m_modelCamera == null) {
                    return null;
                }
                return this.m_modelCamera.getModelInvMatrix();
            }
            case 512: {
                if (this.m_modelCamera == null) {
                    return null;
                }
                return this.m_modelCamera.getAmbientMatrix();
            }
            case 1024: {
                if (this.m_modelCamera == null) {
                    return null;
                }
                return this.m_modelCamera.getAmbientInvMatrix();
            }
        }
        PsDebug.warning("unknown matrix type.");
        return null;
    }

    public void setTransMatrix(int n, PdMatrix pdMatrix) {
        if (this.m_currentCamera == null) {
            return;
        }
        this.m_currentCamera.setTransMatrix(n, pdMatrix);
        this.updateCameraListener(101);
    }

    public boolean isShowingAllViews() {
        return this.hasPaintTag(0x8000000L);
    }

    public int addCamera(String string, PvCamera pvCamera) {
        if (string == null || pvCamera == null) {
            PsDebug.warning("missing arguments");
            return -1;
        }
        int n = -1;
        for (int i = 0; i < PvCameraIf.CAMERA_NAME.length; ++i) {
            if (!PvCameraIf.CAMERA_NAME[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return -1;
        }
        this.m_camera.put(string, pvCamera);
        pvCamera.setParent(this);
        pvCamera.setName(string);
        return n;
    }

    public PvCameraIf getCamera() {
        return this.m_currentCamera;
    }

    public PvCameraIf[] getCameras() {
        PvCameraIf[] pvCameraIfArray = new PvCameraIf[this.m_camera.size()];
        int n = 0;
        Enumeration enumeration = this.m_camera.elements();
        while (enumeration.hasMoreElements()) {
            pvCameraIfArray[n++] = (PvCameraIf)enumeration.nextElement();
        }
        return pvCameraIfArray;
    }

    protected int getCurrentCameraType() {
        if (this.m_currentCamera == null) {
            PsDebug.warning("current camera missing.");
            return 0;
        }
        return this.m_currentCamera.getProjectionMode();
    }

    public PvCameraIf getCamera(int n) {
        if (n < 0 || PvCameraIf.CAMERA_NAME.length <= n) {
            PsDebug.warning("camera type out of range = " + n);
            return this.m_currentCamera;
        }
        return (PvCamera)this.m_camera.get(PvCameraIf.CAMERA_NAME[n]);
    }

    public boolean hasCamera(int n) {
        if (n < 0 || PvCameraIf.CAMERA_NAME.length <= n) {
            PsDebug.warning("camera type out of range = " + n);
            return false;
        }
        return this.m_camera.get(PvCameraIf.CAMERA_NAME[n]) != null;
    }

    public boolean removeCamera(int n) {
        if (n < 0 || PvCameraIf.CAMERA_NAME.length <= n) {
            return false;
        }
        return this.m_camera.remove(PvCameraIf.CAMERA_NAME[n]) != null;
    }

    public Point getPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return null;
        }
        return frame.getLocation();
    }

    public void setPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        ((Component)frame).setLocation(n, n2);
    }

    public Dimension getSize() {
        Dimension dimension = m_renderType != 2 ? super.getSize() : this.m_renderCanvas.getSize();
        return dimension;
    }

    public void setSizeWithinFrame(int n, int n2) {
        int n3;
        int n4;
        if (n2 < 0 || n < 0) {
            PsDebug.warning("value <= 0");
            return;
        }
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            frame.validate();
        }
        Dimension dimension = frame.getSize();
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            n4 = dimension.width - n;
            n3 = dimension.height - n2;
        } else {
            n4 = dimension.width - this.m_nWidth;
            n3 = dimension.height - this.m_nHeight;
        }
        ((Component)frame).setSize(n4 + n, n3 + n2);
        this.resizeImage();
        frame.validate();
    }

    public static void setDefaultSize(Dimension dimension) {
        PvDisplay.m_defSize.height = dimension.height;
        PvDisplay.m_defSize.width = dimension.width;
    }

    public void setPreferredSize(Dimension dimension) {
        m_preferredSize = dimension == null ? null : new Dimension(dimension);
    }

    public void setExternalRenderSize(int n, int n2) {
        if (n2 < 0 || n < 0) {
            PsDebug.warning("value <= 0");
            return;
        }
        this.m_nWidth = n;
        this.m_nHeight = n2;
        this.resizeImageOff();
        this.resizeImageAA();
    }

    public boolean isEnabledExternalRendering() {
        return this.hasPaintTag(0x2000000L);
    }

    public void setEnabledExternalRendering(boolean bl) {
        this.setPaintTag(0x2000000L, bl);
        if (bl) {
            this.resizeFonts(this.m_offFac);
        } else {
            this.resizeFonts(1);
        }
        if (!bl) {
            this.m_nWidth = this.m_width.getValue();
            this.m_nHeight = this.m_height.getValue();
            this.resizeImageOff();
            this.resizeImageAA();
            return;
        }
    }

    protected Frame hasParentFrame() {
        for (Container container = this.m_renderCanvas.getParent(); container != null; container = container.getParent()) {
            if (container instanceof PsMainFrame) {
                return (Frame)container;
            }
            if (!(container instanceof Frame)) continue;
            return null;
        }
        return null;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public boolean isEnabledRepaint() {
        return this.m_bIsEnabledRepaint;
    }

    public void setEnabledRepaint(boolean bl) {
        this.m_bIsEnabledRepaint = bl;
    }

    public boolean isEnabledUpdate() {
        return this.m_bIsEnabledUpdate;
    }

    public void setEnabledUpdate(boolean bl) {
        this.m_bIsEnabledUpdate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Object object) {
        int n;
        if (!this.isEnabledUpdate()) {
            return true;
        }
        if (object == this.m_sleep) {
            return true;
        }
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray != null && pvGeometryArray.length > 0) {
            for (n = 0; n < pvGeometryArray.length; ++n) {
                if (pvGeometryArray[n].getGeometry() != object) continue;
                PvScene pvScene = this.m_scene;
                synchronized (pvScene) {
                    pvGeometryArray[n].update(object);
                    if (this.m_currentGeom == pvGeometryArray[n]) {
                        if (this.m_geomIf == null) {
                            this.setFrameTitle(null);
                        } else {
                            this.setFrameTitle(this.m_geomIf.getName());
                        }
                        if (this.m_currentGeom.getAmbientSpace() != this.m_ambientSpace) {
                            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
                            if (this.isShowingFrame()) {
                                this.recomputeFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                                this.m_coordFrame.update(null);
                            }
                        }
                        if (this.m_currentGeom.getAmbientProjection() != this.m_ambientProj) {
                            this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
                        }
                        if (this.getTransformationMode() == 1) {
                            if (this.m_currentGeom.hasModelMatrix()) {
                                this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
                            } else {
                                this.setTransformationMode(0);
                            }
                            this.updateTransMatrix(true);
                        }
                        if (this.getTransformationMode() == 2) {
                            if (this.m_currentGeom.hasAmbientMatrix()) {
                                this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
                            } else {
                                this.setTransformationMode(0);
                            }
                            this.updateTransMatrix(true);
                        }
                        this.m_currentCamera.updatePanels(this.m_currentCamera);
                        if (this.isShowingAxes() && !this.m_specialGeom.contains(object)) {
                            this.recomputeAxes();
                        }
                        if (this.isShowingBndBox() && !this.m_specialGeom.contains(object)) {
                            this.recomputeBndBox();
                        }
                    }
                    this.m_scene.update(pvGeometryArray[n]);
                }
                if (this.m_infoPanel == null) break;
                if (this.m_infoPanel.isShowing()) {
                    this.m_infoPanel.update(this);
                    break;
                }
                this.m_infoPanel.setOutOfDate(true);
                break;
            }
        }
        if (this.m_axes != null && object == this.m_axes && this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        if ((n = this.checkIfZBufferIsRequired()) != 0 && this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
            this.m_infoPanel.update(this);
        }
        if (object == this) {
            if (n == 0 && this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                this.m_infoPanel.update(this);
            } else if (this.m_currentLight != null) {
                this.m_currentLight.updatePanels(this.m_currentLight);
            } else if (this.m_axes != null) {
                this.m_axes.updatePanels(this.m_axes);
            }
        } else if (object != this.m_infoPanel) {
            if (object == this.m_currentCamera) {
                this.updateCameraListener(102);
            } else if (object != this.m_currentLight && object != this.m_backgroundColor) {
                if (object == this.m_foregroundColor) {
                    if (this.m_coordFrame != null) {
                        this.m_coordFrame.setGlobalPolygonColor(this.getForegroundColor());
                        this.m_coordFrame.setLabelColor(0, this.getForegroundColor());
                        this.m_coordFrame.update(null);
                    }
                } else if (object == this.m_height || object == this.m_width) {
                    int n2 = this.m_width.getValue();
                    int n3 = this.m_height.getValue();
                    if (this.m_bAspect) {
                        if (object == this.m_width) {
                            n3 = (int)((double)n2 / this.m_aspectRatio);
                        } else {
                            n2 = (int)((double)n3 * this.m_aspectRatio);
                        }
                    }
                    this.setSizeWithinFrame(n2, n3);
                } else if (this.m_clipBoundMin != null) {
                    boolean bl = false;
                    for (int i = 0; i < 3; ++i) {
                        if (object == this.m_clipBoundMin[i]) {
                            bl = true;
                            if (!(this.m_clipBoundMin[i].getValue() > this.m_clipBoundMax[i].getValue())) break;
                            this.m_clipBoundMax[i].setValue(this.m_clipBoundMin[i].getValue());
                            break;
                        }
                        if (object != this.m_clipBoundMax[i]) continue;
                        bl = true;
                        if (!(this.m_clipBoundMax[i].getValue() < this.m_clipBoundMin[i].getValue())) break;
                        this.m_clipBoundMin[i].setValue(this.m_clipBoundMax[i].getValue());
                        break;
                    }
                    if (bl) {
                        if (this.isShowingAxes()) {
                            this.recomputeAxes();
                        }
                        if (this.isShowingBndBox()) {
                            this.recomputeBndBox();
                        }
                    }
                }
            }
        }
        if (this.m_scenegraph != null) {
            this.updateOverlay();
        }
        if (this.isEnabledRepaint()) {
            this.repaint();
        }
        return true;
    }

    private boolean checkIfZBufferIsRequired() {
        this.m_bShowTransparency = false;
        this.m_bRequiresZBuffer = false;
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        for (int i = 0; i < pvGeometryArray.length; ++i) {
            if (pvGeometryArray[i].m_bShowLocTransparencyOrig) {
                this.m_bShowTransparency = true;
                this.m_bRequiresZBuffer = true;
                break;
            }
            if (pvGeometryArray[i].getState(103)) {
                this.m_bRequiresZBuffer = true;
                break;
            }
            if (pvGeometryArray[i].getState(100)) {
                this.m_bRequiresZBuffer = true;
                break;
            }
            if (!pvGeometryArray[i].isShowingVertexTexture() && !pvGeometryArray[i].isShowingElementTexture()) continue;
            this.m_bRequiresZBuffer = true;
        }
        if (this.isEnabled3DLook()) {
            this.m_bRequiresZBuffer = true;
        }
        if (this.m_bRequiresZBuffer && !this.isEnabledZBuffer()) {
            this.setEnabledZBuffer(true);
            this.m_bZBufferWasRequired = true;
        } else if (!this.m_bRequiresZBuffer && this.m_bZBufferWasRequired) {
            this.setEnabledZBuffer(false);
            this.m_bZBufferWasRequired = false;
        } else {
            return false;
        }
        return true;
    }

    public boolean hasPaintTag(long l) {
        return (this.m_sceneFlags & l) != 0L;
    }

    public void setPaintTag(long l, boolean bl) {
        if (bl) {
            this.m_sceneDefaults |= l;
            this.m_sceneFlags |= l;
            if ((l & 8L) != 0L) {
                PvGeometry.PS_ZOOM = (int)PS_ZOOM;
            } else if ((l & 1L) == 0L && (l & 0x800L) != 0L) {
                PvGeometry[] pvGeometryArray = this.getGeometryContainers();
                if (pvGeometryArray == null) {
                    return;
                }
                for (int i = 0; i < pvGeometryArray.length; ++i) {
                    if (!pvGeometryArray[i].isVisible()) continue;
                    PgGeometryIf pgGeometryIf = pvGeometryArray[i].getGeometry();
                    if (pvGeometryArray[i] == this.m_currentGeom || this.m_specialGeom.contains(pgGeometryIf)) continue;
                    pvGeometryArray[i].setVisible(false);
                    pgGeometryIf.setVisible(false);
                }
            }
        } else {
            if (this.hasPaintTag(8L) && (l & 8L) != 0L) {
                PvGeometry.PS_ZOOM = 1;
            }
            this.m_sceneDefaults &= l ^ 0xFFFFFFFFFFFFFFFFL;
            this.m_sceneFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    private static void drawCross(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(n2 - n, n3, n2 + n, n3);
        graphics.drawLine(n2, n3 - n, n2, n3 + n);
    }

    private static void drawPickBox(Graphics graphics, Rectangle rectangle) {
        if (rectangle == null) {
            PsDebug.warning("missing mark box.");
            return;
        }
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        graphics.drawLine(rectangle.x, rectangle.y, n, rectangle.y);
        graphics.drawLine(n, rectangle.y, n, n2);
        graphics.drawLine(n, n2, rectangle.x, n2);
        graphics.drawLine(rectangle.x, n2, rectangle.x, rectangle.y);
    }

    private void resizeFonts(int n) {
        Font font = PsConfig.getFont(0);
        this.m_copyrightFont = new Font(font.getName(), font.getStyle(), font.getSize() * n);
        FontMetrics fontMetrics = this.m_renderCanvas.getFontMetrics(this.m_copyrightFont);
        this.m_copyrightLength = fontMetrics.stringWidth(this.m_copyright);
        if (this.m_name != null) {
            font = PsConfig.getFont(4);
            this.m_nameFont = new Font(font.getName(), font.getStyle(), font.getSize() * n);
            fontMetrics = this.m_renderCanvas.getFontMetrics(this.m_nameFont);
            this.m_nameLength = fontMetrics.stringWidth(this.m_name);
        }
        font = PsConfig.getFont(1);
        this.m_infoFont = new Font(font.getName(), font.getStyle(), font.getSize() * n);
    }

    public boolean isEnabledAntiAlias() {
        return this.hasPaintTag(64L);
    }

    public void setEnabledAntiAlias(boolean bl) {
        this.setPaintTag(64L, bl);
        this.m_bSaveEnableAntiAlias = bl;
        if (bl) {
            this.m_offFac = 2;
        } else {
            this.m_offFac = 1;
            this.m_pixAA = null;
            this.m_misAA = null;
            this.m_misAAChunkSize = -1;
        }
        this.resizeImageOff();
        this.resizeImageAA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintGeom(Graphics graphics) {
        if (m_renderType == 2) {
            this.m_renderCanvas.paint(graphics);
            this.m_bHasDonePaint = true;
            return;
        }
        if (!this.hasPaintTag(1L)) {
            return;
        }
        boolean bl = this.hasPaintTag(8L);
        if (this.hasPaintTag(8192L) || this.m_bNewGraphics) {
            this.m_bNewGraphics = false;
            if (this.hasPaintTag(2L) && !bl) {
                graphics.setColor(this.m_backgroundColor.getColor());
                graphics.fillRect(0, 0, this.m_widthOff, this.m_heightOff);
                graphics.setColor(this.m_foregroundColor.getColor());
            }
            if (this.isShowingBackgroundImage() && this.m_backgroundImage != null) {
                PvDisplay.drawImage(graphics, this.m_backgroundImage, this.m_backgroundImageFit, this.m_nWidth, this.m_nHeight, this.m_offFac);
            }
        }
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            if (this.isEnabledZBuffer() || m_bEnableFastZBuffer && this.m_bSaveEnableZBuffer) {
                this.resetZBuffer();
                this.m_scene.assureMIS_new(this.m_widthOff, this.m_heightOff, this, this.m_bShowTransparency);
            }
            if (this.m_scene != null && (this.m_currentGeom != null || this.m_specialGeom.size() > 0)) {
                this.m_scene.paint(graphics, this);
            }
            ++this.m_pCount;
            if (this.isEnabledAntiAlias() && this.isEnabledExternalRendering()) {
                this.drawOverlayText(graphics, this.m_widthOff, this.m_heightOff, this.m_offFac);
            }
            if (this.isEnabledZBuffer() || m_bEnableFastZBuffer && this.m_bSaveEnableZBuffer) {
                this.m_scene.drawMIS_new(graphics, this);
            }
            if (!this.isEnabledAntiAlias()) {
                this.drawOverlayText(graphics, this.m_widthOff, this.m_heightOff, this.m_offFac);
            }
        }
        this.m_bHasDonePaint = true;
    }

    private void updateOverlay() {
        PgGeometryIf[] pgGeometryIfArray = this.getAllGeometries();
        if (pgGeometryIfArray == null || pgGeometryIfArray.length == 0) {
            this.m_scenegraph.setNodeParms(110, null, 0);
            return;
        }
        int n = pgGeometryIfArray.length;
        int n2 = 3 + n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        String string = "Root";
        String string2 = "Visible and Active Geometries";
        String string3 = "Geometries";
        String string4 = "Specials";
        stringArray[n3++] = new String(string + "|" + string2 + "|" + string2 + "|0|http|target|help|target|0|-1|-1|" + this.m_dirTitleStatus + "|0");
        stringArray[n3++] = new String(string + "|" + string3 + "|" + string3 + "|1|http|target|help|target|1|-1|4|" + this.m_dirGeometriesStatus + "|0");
        stringArray[n3++] = new String(string + "|" + string4 + "|" + string4 + "|1|http|target|help|target|1|-1|4|" + this.m_dirSpecialsStatus + "|0");
        PgGeometryIf pgGeometryIf = null;
        if (this.m_currentGeom != null) {
            pgGeometryIf = this.m_currentGeom.getGeometry();
        }
        for (int i = 0; i < n; ++i) {
            String string5 = String.valueOf(i);
            String string6 = pgGeometryIfArray[i].getName();
            String string7 = "7";
            String string8 = "-1";
            String string9 = "8";
            String string10 = pgGeometryIf == pgGeometryIfArray[i] ? "1" : "0";
            String string11 = pgGeometryIfArray[i].isVisible() ? "1" : "0";
            stringArray[n3++] = !this.m_specialGeom.contains(pgGeometryIfArray[i]) ? new String(string3 + "|" + string5 + "|" + string6 + "|2|http|target|help|target|" + string7 + "|" + string8 + "|" + string9 + "|" + string11 + "|" + string10) : new String(string4 + "|" + string5 + "|" + string6 + "|2|http|target|help|target|" + string7 + "|" + string8 + "|" + string9 + "|" + string11 + "|" + string10);
        }
        this.m_scenegraph.setNodeParms(110, stringArray, n2);
    }

    protected void drawOverlayText(Graphics graphics, int n, int n2, int n3) {
        Rectangle rectangle;
        boolean bl = this.hasPaintTag(8L);
        int n4 = 1;
        if (bl) {
            n4 = (int)PS_ZOOM;
        }
        if (this.hasPaintTag(256L) && !bl) {
            this.drawInfo(graphics, this.m_mousePos.x, this.m_mousePos.y, n3);
        }
        if ((this.hasPaintTag(0x8000000000L) || this.hasPaintTag(0x10000000000L)) && !bl) {
            this.drawDetail(graphics, this.m_mousePos.x, this.m_mousePos.y, n3);
        }
        graphics.setColor(this.m_foregroundColor.getColor());
        if ((this.m_mode == 9 || this.m_mode == 12 || this.m_mode == 10 || this.m_mode == 11 || this.m_mode == 2) && this.m_bMouseDown) {
            PvDisplay.drawPickBox(graphics, this.markBox2Offscreen(this.m_markBox.m_data));
        }
        if (this.hasPaintTag(16L) && !bl) {
            PvDisplay.drawCross(graphics, 2 * n3, this.m_mousePos.x * n3, this.m_mousePos.y * n3);
        }
        if (this.isShowingForegroundImage() && this.m_foregroundImage != null) {
            PvDisplay.drawImage(graphics, this.m_foregroundImage, this.m_foregroundImageFit, this.m_nWidth, this.m_nHeight, n3);
        }
        if (this.isShowingScenegraph()) {
            this.m_scenegraph.paintOverlay(graphics, 20, 30, n, n2);
        }
        if (this.m_bIsGlowingBndbox) {
            this.glowBndbox(false);
        }
        if (this.isShowingTitle()) {
            graphics.setColor(PdColor.getXORColor(this.m_backgroundColor.getColor(), Color.black, Color.white, 90));
            graphics.setFont(this.m_copyrightFont);
            graphics.drawString(this.getName(), n4 * (n - this.m_nameLength) / 2, n4 * (15 * n3));
        }
        if (this.isShowingCopyright()) {
            graphics.setColor(PdColor.getXORColor(this.m_backgroundColor.getColor(), Color.black, Color.white, 90));
            graphics.setFont(this.m_copyrightFont);
            graphics.drawString(this.m_copyright, n4 * (n - this.m_copyrightLength) / 2, n4 * (n2 - 10 * n3));
        }
        if (m_license != null) {
            graphics.setColor(PdColor.getXORColor(this.m_backgroundColor.getColor(), Color.red, Color.white, 90));
            graphics.setFont(this.m_copyrightFont);
            graphics.drawString(m_license, n4 * (15 * n3), n4 * (n2 - 25 * n3));
            graphics.drawString("register at www.javaview.de", n4 * (15 * n3), n4 * (n2 - 10 * n3));
        }
        if (this.hasPaintTag(4L) && !bl) {
            rectangle = new Rectangle(0, 0, n, n2);
            PsPanel.drawBorder(graphics, 2, rectangle);
        }
        if (this.hasPaintTag(0x20000000L) && !bl) {
            rectangle = new Rectangle(0, 0, n, n2);
            PsPanel.drawBorder(graphics, 1, rectangle, Color.red);
        }
        if (this.m_bFpsEnabled) {
            graphics.setColor(PdColor.getXORColor(this.m_backgroundColor.getColor(), Color.black, Color.white, 90));
            graphics.setFont(this.m_infoFont);
            graphics.drawString("fps = " + String.valueOf((double)((int)(this.fps * 100.0)) / 100.0), n4 * (15 * n3), n4 * (15 * n3));
        }
    }

    private static void drawImage(Graphics graphics, Image image, int n, int n2, int n3, double d) {
        int n4 = (int)(d * (double)n2 + 0.5);
        int n5 = (int)(d * (double)n3 + 0.5);
        int n6 = (int)(d * (double)image.getWidth(null) + 0.5);
        int n7 = (int)(d * (double)image.getHeight(null) + 0.5);
        switch (n) {
            case 0: {
                graphics.drawImage(image, n4 - n6 >> 1, n5 - n7 >> 1, n6, n7, null);
                break;
            }
            case 1: {
                double d2 = Math.min((double)n6 / (double)n4, (double)n7 / (double)n5);
                if (d2 != 1.0) {
                    n6 = (int)((double)n6 / d2);
                    n7 = (int)((double)n7 / d2);
                }
                graphics.drawImage(image, n4 - n6 >> 1, n5 - n7 >> 1, n6, n7, null);
                break;
            }
            case 2: {
                graphics.drawImage(image, 0, 0, n4, n5, null);
                break;
            }
            case 3: {
                int n8 = 1 + n4 / n6;
                int n9 = 1 + n5 / n7;
                for (int i = 0; i < n9; ++i) {
                    for (int j = 0; j < n8; ++j) {
                        graphics.drawImage(image, j * n6, i * n7, n6, n7, null);
                    }
                }
                break;
            }
        }
    }

    public boolean isEnabledDoubleBuffer() {
        return this.hasPaintTag(0x1000000L);
    }

    public void setEnabledDoubleBuffer(boolean bl) {
        this.setPaintTag(0x1000000L, bl);
        if (this.isEnabledAntiAlias()) {
            return;
        }
    }

    public void paint(Graphics graphics) {
        if (!this.hasPaintTag(1L)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.m_bHandDrawing && this.m_currMouseX != -1) {
            graphics.setColor(this.getForegroundColor());
            if (this.m_prevMouseX != -1 && (this.m_prevMouseX != this.m_currMouseX || this.m_prevMouseY != this.m_currMouseY)) {
                PvGeometry.drawLineThick(graphics, this.m_strokeSize, this.m_xCorner, this.m_yCorner, this.m_prevMouseX, this.m_prevMouseY, this.m_currMouseX, this.m_currMouseY, true);
                this.m_drawnStroke.addElement(new Point(this.m_currMouseX, this.m_currMouseY));
                this.m_prevMouseX = this.m_currMouseX;
                this.m_prevMouseY = this.m_currMouseY;
            }
            this.m_bDrawing = false;
            return;
        }
        if (this.resizeImage()) {
            boolean bl = this.isEnabledAntiAlias();
            if ((this.isEnabledDoubleBuffer() || bl) && this.m_image != null) {
                graphics.drawImage(this.m_image, 0, 0, null);
                if (bl) {
                    this.drawOverlayText(graphics, this.m_nWidth, this.m_nHeight, 1);
                }
            } else {
                this.paintGeom(graphics);
            }
        }
        this.m_bDrawing = false;
    }

    public void update(Graphics graphics) {
        if (graphics == null) {
            PsDebug.error("Casting required in PvDisplay.update((Object)null) when calling with null argument.");
            return;
        }
        if (this.m_bHandDrawing) {
            this.paint(graphics);
            return;
        }
        if (!this.hasPaintTag(1L)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage()) {
            boolean bl = this.isEnabledAntiAlias();
            if (this.isEnabledDoubleBuffer() || bl) {
                this.paintGeom(this.m_gOff);
                if (bl && !this.hasPaintTag(8L)) {
                    this.updateMIS_aa();
                }
                if (this.m_image != null && !this.isEnabledExternalRendering()) {
                    graphics.drawImage(this.m_image, 0, 0, null);
                }
                if (bl && !this.isEnabledExternalRendering()) {
                    this.drawOverlayText(graphics, this.m_nWidth, this.m_nHeight, 1);
                }
                if (bl && !this.hasPaintTag(8L) && this.hasPaintTag(4L)) {
                    PsPanel.drawBorder(graphics, 2, new Rectangle(0, 0, this.m_widthOff, this.m_heightOff));
                }
            } else {
                this.paintGeom(graphics);
            }
        }
        this.m_bDrawing = false;
    }

    public void repaint() {
        if (m_renderType != 2) {
            super.repaint();
        } else {
            this.resizeImage();
            this.m_bHasDonePaint = true;
            this.m_renderCanvas.repaint();
        }
    }

    public void render() {
        this.update(this.m_renderCanvas.getGraphics());
    }

    public boolean resizeImage() {
        if (this.isEnabledExternalRendering()) {
            return true;
        }
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.m_imageOff != null && dimension.width == this.m_nWidth && dimension.height == this.m_nHeight) {
            return true;
        }
        if (this.m_nHeight == -1) {
            m_defSize = dimension;
        }
        this.m_nHeight = dimension.height;
        this.m_nWidth = dimension.width;
        this.m_height.setValue(dimension.height);
        this.m_width.setValue(dimension.width);
        boolean bl = this.hasParentFrame() != null;
        this.m_height.setEnabled(bl);
        this.m_width.setEnabled(bl);
        this.resizeImagePick();
        this.resizeImageOff();
        this.resizeImageAA();
        return true;
    }

    private void resizeImagePick() {
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            return;
        }
        if (this.m_widthPick == this.m_nWidth && this.m_heightPick == this.m_nHeight) {
            return;
        }
        this.m_widthPick = this.m_nWidth;
        this.m_heightPick = this.m_nHeight;
        this.m_currentCamera.resizeImagePick(this.m_widthPick, this.m_heightPick);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.resizeImagePick(this.m_widthPick, this.m_heightPick);
        }
    }

    private void resizeImageAA() {
        if (this.isEnabledAntiAlias() && !this.hasPaintTag(8L)) {
            if (this.m_nWidth <= 0 || this.m_nHeight <= 0) {
                return;
            }
            if (this.m_pixAA != null && this.m_pixAA.getSize() == this.m_nWidth * this.m_nHeight && this.m_misAAChunkSize == this.m_nWidth) {
                return;
            }
            this.m_pixAA = new PiVector(this.m_nWidth * this.m_nHeight);
            this.m_misAAChunkSize = this.m_nWidth;
            this.m_misAA = new MemoryImageSource(this.m_nWidth, this.m_nHeight, this.m_pixAA.m_data, 0, this.m_nWidth);
            this.m_misAA.setAnimated(true);
            this.m_image = this.m_renderCanvas.createImage(this.m_misAA);
            if (this.isEnabledAntiAlias() && !this.hasPaintTag(8L)) {
                this.updateMIS_aa();
            }
        } else if (this.m_image != this.m_imageOff) {
            this.m_image = this.m_imageOff;
        }
    }

    private boolean resizeImageOff() {
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            return true;
        }
        if (this.m_widthOff == this.m_offFac * this.m_nWidth && this.m_heightOff == this.m_offFac * this.m_nHeight && this.m_imageOff != null) {
            return true;
        }
        this.m_widthOff = this.m_offFac * this.m_nWidth;
        this.m_heightOff = this.m_offFac * this.m_nHeight;
        if (this.m_nWidth == 0 || this.m_nHeight == 0) {
            this.m_imageOff = null;
            return false;
        }
        this.m_currentCamera.resizeImage(this.m_widthOff, this.m_heightOff);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.resizeImage(this.m_widthOff, this.m_heightOff);
        }
        if (this.isEnabledZBuffer()) {
            this.assureZBuffer(this.m_widthOff, this.m_heightOff);
        }
        if (this.m_currentGeom != null) {
            this.setFrameTitle(this.m_currentGeom.getGeometry().getName());
            if (!this.m_bCentered) {
                this.m_bCentered = true;
                this.fit();
                this.fit();
                this.center();
                this.saveCameraDefaults();
            }
        }
        if (this.isEnabledDoubleBuffer() || this.isEnabledAntiAlias()) {
            this.m_imageOff = this.m_renderCanvas.createImage(this.m_widthOff, this.m_heightOff);
            if (this.m_imageOff == null) {
                return false;
            }
            this.m_gOff = this.m_imageOff.getGraphics();
            this.m_bNewGraphics = true;
            this.m_bDrawing = true;
            this.paintGeom(this.m_gOff);
            this.m_bDrawing = false;
        }
        return true;
    }

    protected void updateMIS_aa() {
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            return;
        }
        if (this.m_pixAA == null || this.m_pixAA.getSize() != this.m_nWidth * this.m_nHeight) {
            return;
        }
        int[] nArray = PsImage.getPixels(this.m_imageOff);
        if (nArray == null || nArray.length != this.m_widthOff * this.m_heightOff) {
            return;
        }
        int[] nArray2 = this.m_pixAA.m_data;
        int n = 0;
        boolean bl = false;
        if (bl) {
            int n2 = 0;
            for (int i = 0; i < this.m_heightOff; i += this.m_offFac) {
                for (int j = 0; j < this.m_widthOff; j += this.m_offFac) {
                    int n3 = nArray[n2 + j];
                    int n4 = n3 >> 16 & 0xFF;
                    int n5 = n3 >> 8 & 0xFF;
                    int n6 = n3 & 0xFF;
                    n3 = nArray[n2 + j + 1];
                    n4 += n3 >> 16 & 0xFF;
                    n5 += n3 >> 8 & 0xFF;
                    n6 += n3 & 0xFF;
                    n3 = nArray[n2 + this.m_widthOff + j];
                    n4 += n3 >> 16 & 0xFF;
                    n5 += n3 >> 8 & 0xFF;
                    n6 += n3 & 0xFF;
                    n3 = nArray[n2 + this.m_widthOff + j + 1];
                    n4 += n3 >> 16 & 0xFF;
                    n5 += n3 >> 8 & 0xFF;
                    n6 += n3 & 0xFF;
                    n4 = n4 >> 2 & 0xFF;
                    n5 = n5 >> 2 & 0xFF;
                    nArray2[n] = -16777216 + (n4 << 16) + (n5 << 8) + (n6 >>= 2);
                    ++n;
                }
                n2 += 2 * this.m_widthOff;
            }
        } else {
            int n7;
            int n8 = 0;
            int n9 = 2 * this.m_widthOff;
            for (n7 = 0; n7 < this.m_heightOff - 2; n7 += this.m_offFac) {
                for (int i = 0; i < this.m_widthOff - 2; i += this.m_offFac) {
                    int n10 = nArray[n8 + i];
                    int n11 = n10 >> 16 & 0xFF;
                    int n12 = n10 >> 8 & 0xFF;
                    int n13 = n10 & 0xFF;
                    n10 = nArray[n8 + i + 2];
                    n11 += n10 >> 16 & 0xFF;
                    n12 += n10 >> 8 & 0xFF;
                    n13 += n10 & 0xFF;
                    n10 = nArray[n8 + n9 + i];
                    n11 += n10 >> 16 & 0xFF;
                    n12 += n10 >> 8 & 0xFF;
                    n13 += n10 & 0xFF;
                    n10 = nArray[n8 + n9 + i + 2];
                    n11 += n10 >> 16 & 0xFF;
                    n12 += n10 >> 8 & 0xFF;
                    n13 += n10 & 0xFF;
                    n10 = nArray[n8 + i + 1];
                    int n14 = n10 >> 16 & 0xFF;
                    int n15 = n10 >> 8 & 0xFF;
                    int n16 = n10 & 0xFF;
                    n10 = nArray[n8 + this.m_widthOff + i];
                    n14 += n10 >> 16 & 0xFF;
                    n15 += n10 >> 8 & 0xFF;
                    n16 += n10 & 0xFF;
                    n10 = nArray[n8 + this.m_widthOff + i + 2];
                    n14 += n10 >> 16 & 0xFF;
                    n15 += n10 >> 8 & 0xFF;
                    n16 += n10 & 0xFF;
                    n10 = nArray[n8 + n9 + i + 1];
                    n11 += (n14 += n10 >> 16 & 0xFF) << 1;
                    n12 += (n15 += n10 >> 8 & 0xFF) << 1;
                    n13 += (n16 += n10 & 0xFF) << 1;
                    n10 = nArray[n8 + this.m_widthOff + i + 1];
                    n11 += (n10 >> 16 & 0xFF) << 2;
                    n12 += (n10 >> 8 & 0xFF) << 2;
                    n13 += (n10 & 0xFF) << 2;
                    n11 = n11 >> 4 & 0xFF;
                    n12 = n12 >> 4 & 0xFF;
                    nArray2[n] = -16777216 + (n11 << 16) + (n12 << 8) + (n13 >>= 4);
                    ++n;
                }
                nArray2[n] = nArray[n8 + n9 - 1];
                ++n;
                n8 += n9;
            }
            n8 += this.m_widthOff;
            for (n7 = 1; n7 < this.m_widthOff; n7 += this.m_offFac) {
                nArray2[n] = nArray[n8 + n7];
                ++n;
            }
        }
        this.m_misAA.newPixels();
    }

    public void setAutoCenter(boolean bl) {
        this.m_bCentered = !bl;
    }

    public Image getImage() {
        return this.m_image;
    }

    public Image getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.m_backgroundImage = image;
    }

    public String getBackgroundImageFile() {
        return this.m_backgroundImageFile;
    }

    public void setBackgroundImageFile(String string) {
        if (this.m_backgroundImageFile == null && string == null || this.m_backgroundImageFile != null && string != null && this.m_backgroundImageFile.equals(string)) {
            return;
        }
        if (string == null) {
            this.setBackgroundImage((Image)null);
        } else {
            Image image = null;
            if (this.isShowingBackgroundImage() && (image = this.loadImage(this.m_renderCanvas, string)) == null) {
                return;
            }
            this.setBackgroundImage(image);
        }
        this.m_backgroundImageFile = string;
    }

    public void setBackgroundImage(String string) {
        this.setBackgroundImageFile(string);
    }

    protected Image loadImage(Component component, String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        Image image = PsImage.getImageResource(string);
        boolean bl2 = bl = image != null;
        if (!bl && this.m_searchPath != null) {
            for (int i = 0; i < this.m_searchPath.length && !(bl = PsImage.loadImage(component, image = PsImage.getImage(this.m_searchPath[i] + string))); ++i) {
            }
        }
        if (!bl) {
            PsDebug.warning("failed loading image = " + string);
            return null;
        }
        return image;
    }

    public Image getForegroundImage() {
        return this.m_foregroundImage;
    }

    public void setForegroundImage(Image image) {
        this.m_foregroundImage = image;
    }

    public String getForegroundImageFile() {
        return this.m_foregroundImageFile;
    }

    public void setForegroundImageFile(String string) {
        if (this.m_foregroundImageFile == null && string == null || this.m_foregroundImageFile != null && string != null && this.m_foregroundImageFile.equals(string)) {
            return;
        }
        if (string == null) {
            this.setForegroundImage(null);
        } else {
            Image image = null;
            if (this.isShowingForegroundImage() && (image = this.loadImage(this.m_renderCanvas, string)) == null) {
                return;
            }
            this.setForegroundImage(image);
        }
        this.m_foregroundImageFile = string;
    }

    protected static void normalizedCoords(double[] dArray, int n, int n2, int n3, int n4) {
        double d = (double)n + 0.5;
        double d2 = (double)n4 - 1.0 - (double)n2 - 0.5;
        double d3 = Math.min(n3, n4);
        if (d3 < 1.0E-10) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        } else {
            dArray[0] = 2.0 / (d3 - 1.0) * d - ((double)n3 - 1.0) / d3;
            dArray[1] = 2.0 / (d3 - 1.0) * d2 - ((double)n4 - 1.0) / d3;
        }
    }

    protected Rectangle markBox2Offscreen(int[] nArray) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = Math.min(nArray[0], nArray[2]) * this.m_offFac;
        rectangle.y = Math.min(nArray[1], nArray[3]) * this.m_offFac;
        rectangle.width = Math.abs(nArray[2] - nArray[0]) * this.m_offFac;
        rectangle.height = Math.abs(nArray[3] - nArray[1]) * this.m_offFac;
        return rectangle;
    }

    private Rectangle pick2Offscreen(int n, int n2) {
        int n3 = 3;
        if (this.m_currentGeom != null) {
            n3 = Math.max(n3, (int)this.m_currentGeom.getGlobalVertexSize());
        }
        int n4 = n3 * this.m_offFac;
        Rectangle rectangle = new Rectangle((n *= this.m_offFac) - n4, (n2 *= this.m_offFac) - n4, 2 * n4, 2 * n4);
        return rectangle;
    }

    protected boolean updatePosition(int n, int n2) {
        if (this.m_widthPick == 0 || this.m_heightPick == 0) {
            return false;
        }
        return this.m_mousePos.x != n || this.m_mousePos.y != n2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        Enumeration enumeration;
        Object object;
        this.m_bIsMousePressed = true;
        this.m_bIsMouseDragged = false;
        this.m_bIsScenegraphPicked = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.m_bMouseInside || this.m_widthPick == 0 || this.m_heightPick == 0 || n < 0 || n2 < 0 || this.m_widthPick <= n || this.m_heightPick <= n2) {
            return;
        }
        if (this.m_bHandDrawing) {
            this.m_prevMouseX = n;
            this.m_prevMouseY = n2;
            this.m_currMouseX = n;
            this.m_currMouseY = n2;
            this.m_drawnStroke.removeAllElements();
            this.m_drawnStroke.addElement(new Point(this.m_currMouseX, this.m_currMouseY));
            return;
        }
        if (this.m_currentGeom != null) {
            if (this.hasPaintTag(0x10000000000L)) {
                String string = null;
                switch (this.m_currentGeom.getType()) {
                    case 33: {
                        if (this.m_pickedVertex > -1 && this.m_currentGeom.getVertex(this.m_pickedVertex).getURL() != null) {
                            string = this.m_currentGeom.getVertex(this.m_pickedVertex).getURL();
                            break;
                        }
                        if (this.m_pickedElement <= -1 || this.m_currentGeom.getElement(this.m_pickedElement).getURL() == null) break;
                        string = this.m_currentGeom.getElement(this.m_pickedElement).getURL();
                        break;
                    }
                    case 31: 
                    case 32: {
                        if (this.m_pickedVertex > -1 && this.m_currentGeom.getVertex(this.m_pickedVertex).getURL() != null) {
                            string = this.m_currentGeom.getVertex(this.m_pickedVertex).getURL();
                            break;
                        }
                        if (this.m_pickedElement <= -1 || this.m_currentGeom.getPolygon(this.m_pickedElement).getURL() == null) break;
                        string = this.m_currentGeom.getPolygon(this.m_pickedElement).getURL();
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown geometry type");
                        return;
                    }
                }
                if (string == null) {
                    return;
                }
                if (!PsConfig.isApplication() && PsConfig.getApplet() != null) {
                    try {
                        object = new URL(string);
                        enumeration = PsConfig.getApplet();
                        ((Applet)((Object)enumeration)).getAppletContext().showDocument((URL)object, "_blank");
                    }
                    catch (MalformedURLException malformedURLException) {
                        return;
                    }
                }
                object = Runtime.getRuntime();
                try {
                    ((Runtime)object).exec("iexplore " + string);
                }
                catch (IOException iOException) {
                    return;
                }
            }
            if ((this.isShowingMagnet() || this.m_bIsShowingMagnetTmp) && this.m_pickedVertex > -1 && this.m_currentGeom.hasTagVertex(this.m_pickedVertex, 12)) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex, 12);
                this.repaint();
            }
        }
        if (this.m_scenegraph != null) {
            this.m_scenegraph.mousePressed(mouseEvent);
            if (mouseEvent.isConsumed()) {
                this.m_bIsScenegraphPicked = true;
                int n3 = mouseEvent.getModifiers();
                if ((n3 & 0x10) == 0) {
                    return;
                }
                int n4 = this.m_scenegraph.getIconInd();
                enumeration = this.m_scenegraph.getNodeID();
                String string = this.m_scenegraph.getNodeStatus();
                if ("Visible and Active Geometries".equals(enumeration)) {
                    this.m_dirTitleStatus = this.m_scenegraph.getNodeStatus();
                } else if ("Geometries".equals(enumeration)) {
                    this.m_dirGeometriesStatus = this.m_scenegraph.getNodeStatus();
                } else if ("Specials".equals(enumeration)) {
                    this.m_dirSpecialsStatus = this.m_scenegraph.getNodeStatus();
                } else {
                    PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
                    int n5 = -1;
                    try {
                        n5 = Integer.parseInt((String)((Object)enumeration));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                    boolean bl2 = "1".equals(string);
                    PvGeometry pvGeometry = pvGeometryArray[n5];
                    PgGeometryIf pgGeometryIf = pvGeometry.getGeometry();
                    if (n4 == 1 && pgGeometryIf.isVisible() != bl2) {
                        boolean bl3 = false;
                        if (this.m_specialGeom.get(GEOM_AXES) == pgGeometryIf) {
                            PgAxes pgAxes = (PgAxes)pgGeometryIf;
                            pgAxes.setEnabledAutoLayout(false);
                            pgAxes.setVisible(bl2);
                            pgAxes.update(pgAxes);
                            bl3 = true;
                        } else if (this.m_specialGeom.get(GEOM_AXES_0) == pgGeometryIf || this.m_specialGeom.get(GEOM_AXES_1) == pgGeometryIf || this.m_specialGeom.get(GEOM_AXES_2) == pgGeometryIf || this.m_specialGeom.get(GEOM_AXES_3) == pgGeometryIf) {
                            PgAxes pgAxes = (PgAxes)((PgRuler)pgGeometryIf).getFather();
                            pgAxes.setEnabledAutoLayout(false);
                            pgAxes.update(pgAxes);
                            bl3 = true;
                        }
                        pvGeometry.setVisible(bl2);
                        pgGeometryIf.setVisible(bl2);
                        if (this.isShowingAxes() || bl3) {
                            this.recomputeAxes();
                        }
                        if (this.isShowingBndBox()) {
                            this.recomputeBndBox();
                        }
                    } else if (n4 == 2 && pvGeometryArray[n5] != this.m_currentGeom) {
                        this.selectGeometry(pgGeometryIf);
                    }
                }
                this.update(this);
                return;
            }
        }
        this.m_currentPick = null;
        this.m_currentElemInd = -1;
        if (this.m_bIsEnabledFastAA && this.isEnabledAntiAlias() && this.isEnabledClearScreen() && (bl = this.isEnabledAntiAlias())) {
            this.setEnabledAntiAlias(false);
            this.m_bSaveEnableAntiAlias = bl;
        }
        this.m_bFirstAfterPick = true;
        this.m_bMouseShiftConstraint = false;
        this.m_pickedVertex = -1;
        this.bDrag = false;
        if (this.isEnabledInspection() && this.m_viewer != null && this.m_viewer.getDisplay() != this) {
            this.m_viewer.selectDisplay(this);
        }
        this.m_mousePos.x = n;
        this.m_mousePos.y = n2;
        this.m_bMouseDown = true;
        this.xDown = n;
        this.yDown = n2;
        this.m_markBox.m_data[0] = n;
        this.m_markBox.m_data[1] = n2;
        this.m_markBox.m_data[2] = n;
        this.m_markBox.m_data[3] = n2;
        if (this.m_thread != null && this.getMajorMode() != 19) {
            this.stop();
        }
        if (mouseEvent.isControlDown() || this.isEnabledDirectSelect() || this.m_mode == 2) {
            PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
            if (pvGeometryArray == null || pvGeometryArray.length == 0) {
                return;
            }
            object = new PdVector(pvGeometryArray.length);
            enumeration = new PdVector(pvGeometryArray.length);
            ((PdVector)object).setConstant(Double.MAX_VALUE);
            ((PdVector)((Object)enumeration)).setConstant(Double.MAX_VALUE);
            int n6 = 0;
            for (int i = 0; i < pvGeometryArray.length; ++i) {
                double d;
                if (!pvGeometryArray[i].isVisible()) continue;
                PdVector[] pdVectorArray = this.getWorldFromPickPos(n, n2, (int)(PvCamera.SIZE * (double)PvCamera.Z_STRETCH));
                pdVectorArray[0].setSize(3);
                pdVectorArray[1].setSize(3);
                PvPickEvent pvPickEvent = null;
                pvPickEvent = pvGeometryArray[i].getType() == 33 ? pvGeometryArray[i].intersectionWithLine(n, n2, pdVectorArray[0], pdVectorArray[1]) : pvGeometryArray[i].getGeometry().intersectionWithLine(pdVectorArray[0], pdVectorArray[1]);
                if (pvPickEvent == null) continue;
                double d2 = pvPickEvent.getDistance();
                double d3 = pvPickEvent.getHorDistance();
                if (d3 < (d = ((PdVector)((Object)enumeration)).min()) - 1.0E-10) {
                    this.m_currentPick = pvPickEvent;
                    n6 = i;
                } else if (d3 < d + 1.0E-10) {
                    for (int j = 0; j < i; ++j) {
                        if (!(((PdVector)((Object)enumeration)).getEntry(j) < d + 1.0E-10) || !(d2 < this.m_currentPick.getDistance())) continue;
                        this.m_currentPick = pvPickEvent;
                        n6 = i;
                    }
                }
                ((PdVector)object).setEntry(i, d2);
                ((PdVector)((Object)enumeration)).setEntry(i, d3);
            }
            if (this.m_mode == 2) {
                return;
            }
            if (!this.isEnabledDirectSelect()) {
                if (((PdVector)object).getEntry(n6) != Double.MAX_VALUE && this.selectGeometry(pvGeometryArray[n6].getGeometry())) {
                    this.update(this);
                }
            } else if (((PdVector)object).getEntry(n6) != Double.MAX_VALUE) {
                if (this.getTransformationMode() != 1) {
                    this.setTransformationMode(1);
                }
                if (this.selectGeometry(pvGeometryArray[n6].getGeometry())) {
                    this.update(this);
                }
            } else if (this.getTransformationMode() != 0) {
                this.setTransformationMode(0);
                this.update(this);
            }
        }
        this.m_currentCamera.mousePressed(n, n2);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.m_geomCenter.copyArray(this.m_currentGeom.getCenter());
            if (this.m_mode == 0) {
                if (this.isEnabledDirectSelect() && this.m_currentGeom != null) {
                    this.m_modelCamera.m_xGeomCenter = this.m_currentGeom.m_centerTrans.m_data[0];
                    this.m_modelCamera.m_yGeomCenter = this.m_currentGeom.m_centerTrans.m_data[1];
                } else {
                    this.m_modelCamera.m_xGeomCenter = (int)((double)(this.m_widthPick / 2) + 0.5);
                    this.m_modelCamera.m_yGeomCenter = (int)((double)(this.m_heightPick / 2) + 0.5);
                }
            }
            this.m_modelCamera.mousePressed(n, n2);
        }
        this.updateCameraListener(101);
        int n7 = mouseEvent.getModifiers();
        if ((n7 & 8) != 0) {
            this.m_currentCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
            if (this.getTransformationMode() != 0) {
                this.m_modelCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
            }
            PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 3));
            return;
        }
        if ((n7 & 4) != 0) {
            this.m_currentCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
            if (this.getTransformationMode() != 0) {
                this.m_modelCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
            }
            PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 1));
            return;
        }
        if (this.m_mode == 13 || this.m_mode == 16) {
            if (this.m_currentGeom == null) {
                return;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(this.pick2Offscreen(n, n2), 1);
            if (this.m_pickedVertex == -1) {
                object = this.getWorldFromPickPos(n, n2, 0);
                this.getModelFromWorld(this.m_currentGeom, object[0], object[1]);
                if (this.m_currentGeom.getDimOfVertices() == 2) {
                    PvDisplay.projectBaseToGeometry((PdVector)object[0], (PdVector)object[1]);
                }
                this.m_pickedVertex = this.m_currentGeom.addGeometryVertex((PdVector)object[0]);
                if (this.m_mode == 16) {
                    this.m_currentGeom.setTagVertex(this.m_pickedVertex, 1);
                }
                PsDebug.showStatus(PsConfig.getMessage(31022) + "[" + this.m_pickedVertex + "] = (" + ((PdVector)object[0]).m_data[0] + "," + ((PdVector)object[0]).m_data[1] + "," + ((PdVector)object[0]).m_data[2] + "," + ((PdVector)object[0]).m_data[3]);
            } else {
                this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
            }
            if (this.m_newElement != null) {
                if (this.m_newElement.contains(this.m_pickedVertex)) {
                    PsDebug.warning("vertex already contained in new element, ind = " + String.valueOf(this.m_pickedVertex));
                    return;
                }
                this.m_newElement.addEntry(this.m_pickedVertex);
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            if (this.isShowingAxes()) {
                this.recomputeAxes();
            }
            this.repaint();
        } else if (this.m_mode == 19) {
            this.m_prevSteer.setConstant(0.0);
            if (this.m_currentCamera == null) {
                return;
            }
        } else if (this.m_mode == 6) {
            if ((this.m_pickListener == null || this.m_pickListener.size() == 0) && this.m_pickFocus == null) {
                return;
            }
            object = this.getPickEvent(n, n2);
            if (object == null) {
                PsDebug.warning("missing pick event");
                return;
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickInitial((PvPickEvent)object);
            } else if (this.m_pickListener != null) {
                enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickInitial((PvPickEvent)object);
                }
            }
        } else if (this.m_mode == 8) {
            if ((this.m_pickListener == null || this.m_pickListener.size() == 0) && this.m_pickFocus == null) {
                return;
            }
            object = this.getPickEvent(n, n2);
            if (object == null) {
                PsDebug.warning("missing pick event");
                return;
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickDisplay((PvPickEvent)object);
            } else if (this.m_pickListener != null) {
                enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickDisplay((PvPickEvent)object);
                }
            }
        } else if (this.m_mode == 10 || this.m_mode == 11) {
            if (this.m_currentGeom == null) {
                return;
            }
            object = this.getPickEvent(n, n2);
            if (object == null) {
                PsDebug.warning("missing pick event");
                return;
            }
            if (this.m_currentGeom.getGeometry() != ((PvPickEvent)object).getGeometry()) {
                return;
            }
            this.m_currentElemInd = ((PvPickEvent)object).getElementInd();
            if (this.m_currentElemInd == -1) {
                return;
            }
            switch (this.m_currentGeom.getType()) {
                case 33: {
                    enumeration = this.m_geomIf.getElement(this.m_currentElemInd);
                    if (enumeration == null) {
                        return;
                    }
                    if (this.m_mode == 11 && ((P_Vector)((Object)enumeration)).hasTag(1) || ((P_Vector)((Object)enumeration)).hasTag(12) || ((P_Vector)((Object)enumeration)).hasTag(11)) {
                        ((P_Vector)((Object)enumeration)).clearTag(1);
                        ((P_Vector)((Object)enumeration)).clearTag(12);
                        ((P_Vector)((Object)enumeration)).clearTag(11);
                        this.m_currentElemInd = -1;
                        break;
                    }
                    if (this.m_mode != 10 || ((P_Vector)((Object)enumeration)).hasTag(1)) break;
                    ((P_Vector)((Object)enumeration)).setTag(1);
                    this.m_currentElemInd = -1;
                    break;
                }
                case 32: {
                    PiVector piVector = this.m_geomIf.getPolygon(this.m_currentElemInd);
                    if (piVector == null) {
                        return;
                    }
                    if (this.m_mode == 11 && piVector.hasTag(1) || piVector.hasTag(12) || piVector.hasTag(11)) {
                        piVector.clearTag(1);
                        piVector.clearTag(12);
                        piVector.clearTag(11);
                        this.m_currentElemInd = -1;
                        break;
                    }
                    if (this.m_mode != 10 || piVector.hasTag(1)) break;
                    piVector.setTag(1);
                    this.m_currentElemInd = -1;
                    break;
                }
                default: {
                    PsDebug.warning("unknown geometry type");
                    return;
                }
            }
            this.m_geomIf.update(this.m_geomIf);
            this.bDrag = false;
            this.repaint();
        } else if (this.m_mode == 5) {
            if (this.m_currentGeom == null) {
                return;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(this.pick2Offscreen(n, n2), 11);
            if (this.m_pickedVertex == -1) {
                return;
            }
            this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
            object = this.m_currentGeom.getVertex(this.m_pickedVertex);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
            } else if (this.m_pickListener != null) {
                enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.repaint();
        } else if (this.m_mode != 9 && this.m_mode != 12 && this.hasPaintTag(16L)) {
            this.repaint();
        }
    }

    protected void updateCameraListener(int n) {
        this.updateTransMatrix(false);
        if (this.isShowingAxes() && n != 101) {
            this.recomputeAxes();
        }
        if (this.isShowingCamera()) {
            this.recomputeCamera();
            this.recomputeInterest();
        }
        if (this.m_currentCamera == null) {
            return;
        }
        if (this.m_cameraListener == null || this.m_cameraListener.size() == 0) {
            return;
        }
        PvCameraEvent pvCameraEvent = new PvCameraEvent(this, 3);
        pvCameraEvent.setCamera(this.m_currentCamera);
        pvCameraEvent.setLocation(this.m_mousePos);
        PdVector[] pdVectorArray = this.getWorldFromPickPos(this.m_mousePos.x, this.m_mousePos.y, (int)(PvCamera.SIZE * (double)PvCamera.Z_STRETCH));
        pdVectorArray[0].setSize(3);
        pvCameraEvent.setVertex(pdVectorArray[0]);
        Enumeration enumeration = this.m_cameraListener.elements();
        while (enumeration.hasMoreElements()) {
            if (n == 101) {
                ((PvCameraListenerIf)enumeration.nextElement()).pickCamera(pvCameraEvent);
                continue;
            }
            if (n == 102) {
                ((PvCameraListenerIf)enumeration.nextElement()).dragCamera(pvCameraEvent);
                continue;
            }
            if (n == 103) {
                return;
            }
            PsDebug.warning("unknown state = " + n);
            return;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_bIsScenegraphPicked) {
            return;
        }
        this.m_bIsMouseDragged = true;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.m_bHandDrawing) {
            this.m_currMouseX = n;
            this.m_currMouseY = n2;
            this.repaint();
            return;
        }
        if (!this.m_bHasDonePaint) {
            this.repaint();
            return;
        }
        this.m_bHasDonePaint = false;
        if (!this.m_bIsMousePressed) {
            return;
        }
        if (this.m_bFirstAfterPick) {
            this.m_bFirstAfterPick = false;
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        int n3 = mouseEvent.getModifiers();
        if ((n3 & 8) != 0) {
            this.setMinorMode(3);
        } else if ((n3 & 4) != 0) {
            this.setMinorMode(1);
        }
        if (!this.updatePosition(n, n2)) {
            return;
        }
        if (mouseEvent.isShiftDown() || this.m_mode == 17) {
            if (!this.m_bMouseShiftConstraint) {
                this.m_mouseShiftConstraint = Math.abs(n - this.xDown) >= Math.abs(n2 - this.yDown) ? 2 : 1;
                this.m_bMouseShiftConstraint = true;
            }
            if (this.m_bMouseShiftConstraint && this.m_mode != 9 && this.m_mode != 12 && this.m_mode != 10 && this.m_mode != 11 && this.m_mode != 2) {
                if (this.m_mouseShiftConstraint == 2) {
                    n2 = this.yDown;
                } else {
                    n = this.xDown;
                }
            }
        }
        if (this.m_mode == 2) {
            int n4;
            double d = (double)this.m_nWidth / (double)this.m_nHeight;
            int n5 = Math.abs(n - this.m_markBox.m_data[0]);
            if ((double)n5 < d * (double)(n4 = Math.abs(n2 - this.m_markBox.m_data[1]))) {
                n = n >= this.m_markBox.m_data[0] ? this.m_markBox.m_data[0] + (int)(d * (double)n4) : this.m_markBox.m_data[0] - (int)(d * (double)n4);
            } else {
                n2 = n2 >= this.m_markBox.m_data[1] ? this.m_markBox.m_data[1] + (int)((double)n5 / d) : this.m_markBox.m_data[1] - (int)((double)n5 / d);
            }
        }
        this.m_markBox.m_data[2] = n;
        this.m_markBox.m_data[3] = n2;
        int n6 = n - this.m_mousePos.x;
        int n7 = n2 - this.m_mousePos.y;
        this.m_mousePos.x = n;
        this.m_mousePos.y = n2;
        PvDisplay.normalizedCoords(this.m_mouseNormPos, n, n2, this.m_widthPick, this.m_heightPick);
        if (this.m_mode == 13 || this.m_mode == 16) {
            PdVector[] pdVectorArray = this.getWorldFromPickPos(n, n2, 0);
            this.getModelFromWorld(this.m_currentGeom, pdVectorArray[0], pdVectorArray[1]);
            this.m_pickedVertex = this.m_currentGeom.addGeometryVertex(pdVectorArray[0]);
            if (this.m_mode == 16) {
                this.m_currentGeom.setTagVertex(this.m_pickedVertex, 1);
            }
            PsDebug.showStatus(PsConfig.getMessage(31022) + "[" + this.m_pickedVertex + "] = (" + pdVectorArray[0].m_data[0] + "," + pdVectorArray[0].m_data[1] + "," + pdVectorArray[0].m_data[2] + "," + pdVectorArray[0].m_data[3]);
            if (this.m_newElement != null) {
                this.m_newElement.addEntry(this.m_pickedVertex);
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            if (this.isShowingAxes()) {
                this.recomputeAxes();
            }
        } else if (this.m_mode == 19) {
            if (this.m_currentCamera == null) {
                return;
            }
            PdVector[] pdVectorArray = this.getWorldFromPickPos((int)(10.0 * (double)n6 + (double)this.m_widthPick / 2.0), (int)(10.0 * (double)n7 + (double)this.m_heightPick / 2.0), 0);
            pdVectorArray[0].setSize(3);
            pdVectorArray[0].blendBase(pdVectorArray[0], 0.5, this.m_prevSteer);
            this.m_prevSteer.sub(pdVectorArray[0], this.m_currentCamera.getInterest());
            pdVectorArray[0].blendBase(this.m_currentCamera.getInterest(), 0.1, this.m_prevSteer);
            PdVector pdVector = PdVector.subNew(pdVectorArray[0], this.m_currentCamera.getPosition());
            if (!pdVector.normalize()) {
                return;
            }
            this.m_currentCamera.setInterest(pdVectorArray[0]);
            PdVector pdVector2 = (PdVector)this.m_currentCamera.getUpVector().clone();
            this.m_currentCamera.setViewDir(pdVector);
            this.m_currentCamera.setUpVector(pdVector2);
            this.m_currentCamera.update(this.m_currentCamera);
            this.updateCameraListener(102);
        } else if (this.m_mode == 6) {
            if (this.m_bDrawing) {
                return;
            }
            if (this.m_pickListener != null && this.m_pickListener.size() > 0 || this.m_pickFocus != null) {
                PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
                if (pvPickEvent == null) {
                    return;
                }
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragInitial(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragInitial(pvPickEvent);
                    }
                }
            }
            if (!this.hasPaintTag(16L) && !this.hasPaintTag(256L)) {
                return;
            }
        } else if (this.m_mode == 8) {
            if (this.m_bDrawing) {
                return;
            }
            if (this.m_pickListener != null && this.m_pickListener.size() > 0 || this.m_pickFocus != null) {
                PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
                if (pvPickEvent == null) {
                    return;
                }
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragDisplay(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragDisplay(pvPickEvent);
                    }
                }
            }
            if (!this.hasPaintTag(16L) && !this.hasPaintTag(256L)) {
                return;
            }
        } else if (this.m_mode == 5) {
            Object object;
            if (this.m_pickedVertex == -1 || this.m_currentGeom == null) {
                return;
            }
            if (!this.m_currentGeom.isVisible()) {
                return;
            }
            PdVector[] pdVectorArray = this.getWorldFromPickPos(n, n2, this.m_pick.getEntry(2));
            this.getModelFromWorld(this.m_currentGeom, pdVectorArray[0], pdVectorArray[1]);
            if (this.m_currentGeom.getDimOfVertices() == 2) {
                PvDisplay.projectBaseToGeometry(pdVectorArray[0], pdVectorArray[1]);
            }
            PiVector piVector = null;
            if (!this.isEnabledTags() || (piVector = this.m_currentGeom.getTaggedVertices()) == null || piVector.getSize() == 0) {
                this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, pdVectorArray[0]);
                this.m_currentGeom.setTagVertex(this.m_pickedVertex, 11);
            } else {
                object = PdVector.copyNew(pdVectorArray[0]);
                ((PdVector)object).setSize(this.m_currentGeom.getDimOfVertices());
                ((PdVector)object).sub(this.m_currentGeom.getVertex(this.m_pickedVertex));
                int n8 = piVector.getSize();
                for (int i = 0; i < n8; ++i) {
                    int n9 = piVector.getEntry(i);
                    PdVector pdVector = this.m_currentGeom.getVertex(n9);
                    pdVector.add((PdVector)object);
                    this.m_currentGeom.setGeometryVertex(n9, pdVector);
                }
                if (this.m_pickedVertex > -1) {
                    this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, pdVectorArray[0]);
                }
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.dragVertex(this.m_geomIf, this.m_pickedVertex, pdVectorArray[0]);
            } else if (this.m_pickListener != null) {
                object = this.m_pickListener.elements();
                while (object.hasMoreElements()) {
                    ((PvPickListenerIf)object.nextElement()).dragVertex(this.m_geomIf, this.m_pickedVertex, pdVectorArray[0]);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            if (this.isShowingAxes()) {
                this.recomputeAxes();
            }
        } else if (this.m_mode != 9 && this.m_mode != 10 && this.m_mode != 2 && this.m_mode != 12 && this.m_mode != 11) {
            if (this.getTransformationMode() == 0) {
                this.m_currentCamera.mouseDragged(n, n2, this.m_bMouseShiftConstraint, this.m_mouseShiftConstraint);
                this.m_currentCamera.updatePanels(this.m_currentCamera);
            } else {
                this.m_modelCamera.mouseDragged(n, n2, this.m_bMouseShiftConstraint, this.m_mouseShiftConstraint);
                this.m_modelCamera.updatePanels(this.m_modelCamera);
            }
            this.updateCameraListener(102);
            this.bDrag = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        boolean bl = this.m_bIsScenegraphPicked;
        this.m_bIsScenegraphPicked = false;
        if (!this.m_bIsMousePressed) {
            return;
        }
        if (this.m_bHandDrawing) {
            this.m_prevMouseX = -1;
            this.m_prevMouseY = -1;
            int n2 = this.m_drawnStroke.size();
            if (n2 == 0) {
                return;
            }
            PiVector piVector = new PiVector(n2);
            for (int i = 0; i < n2; ++i) {
                Point point = (Point)this.m_drawnStroke.elementAt(i);
                PvPickEvent pvPickEvent = this.getPickEvent(point.x, point.y, 4);
                if (pvPickEvent == null) continue;
                this.m_strokeSet.addVertex(pvPickEvent.getVertex());
                piVector.setEntry(i, this.m_novStroke);
                ++this.m_novStroke;
            }
            this.m_strokeSet.addPolygon(piVector);
            return;
        }
        this.m_bIsMousePressed = false;
        this.m_bMouseDown = false;
        if (this.m_bIsEnabledFastAA && this.isEnabledAntiAlias() != this.m_bSaveEnableAntiAlias && this.isEnabledClearScreen()) {
            if (this.m_bSaveEnableAntiAlias) {
                this.setEnabledAntiAlias(true);
            }
            this.repaint();
        }
        if (this.m_scenegraph != null) {
            this.m_scenegraph.mouseReleased(mouseEvent);
            if (mouseEvent.isConsumed() && !this.m_bIsMouseDragged) {
                int n3 = mouseEvent.getModifiers();
                if ((n3 & 4) == 0) {
                    return;
                }
                int n4 = this.m_scenegraph.getIconInd();
                if (n4 != 2) {
                    return;
                }
                String string = this.m_scenegraph.getNodeID();
                if ("Visible and Active Geometries".equals(string)) {
                    this.m_dirTitleStatus = this.m_scenegraph.getNodeStatus();
                } else if ("Geometries".equals(string)) {
                    this.m_dirGeometriesStatus = this.m_scenegraph.getNodeStatus();
                } else if ("Specials".equals(string)) {
                    this.m_dirSpecialsStatus = this.m_scenegraph.getNodeStatus();
                } else {
                    PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
                    int n5 = -1;
                    try {
                        n5 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                    if (n4 == 2) {
                        this.showPopupScene(mouseEvent, pvGeometryArray[n5].getGeometry());
                        return;
                    }
                }
                return;
            }
            if (bl) {
                return;
            }
        }
        if (((n = mouseEvent.getModifiers()) & 4) != 0 && !this.m_bIsMouseDragged) {
            PsDebug.popStatus();
            this.showPopupMenu(mouseEvent);
            return;
        }
        int n6 = mouseEvent.getX();
        int n7 = mouseEvent.getY();
        this.m_markBox.m_data[2] = n6;
        this.m_markBox.m_data[3] = n7;
        this.m_mousePos.x = n6;
        this.m_mousePos.y = n7;
        if (Math.abs(this.xUp - this.xDown) <= 2 || Math.abs(this.yUp - this.yDown) <= 2) {
            this.bDrag = false;
        }
        this.xUp = n6;
        this.yUp = n7;
        if ((n & 8) != 0) {
            PsDebug.popStatus();
            this.setMinorMode(this.m_modeMajor);
            this.m_currentCamera.mouseReleased(this.m_mousePos.x, this.m_mousePos.y);
            return;
        }
        if (this.m_bIsMouseDragged && (n & 4) != 0) {
            PsDebug.popStatus();
            this.setMinorMode(this.m_modeMajor);
            this.m_currentCamera.mouseReleased(this.m_mousePos.x, this.m_mousePos.y);
            return;
        }
        if (this.m_mode == 6) {
            this.bDrag = false;
        } else if (this.m_mode == 8) {
            this.bDrag = false;
        } else if (this.m_mode == 5) {
            if (this.m_currentGeom != null && this.m_pickedVertex > -1) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex, 11);
                if (this.m_geomIf != null) {
                    this.m_geomIf.update(this.m_geomIf);
                }
            }
            this.bDrag = false;
        } else if (this.m_mode == 14) {
            PvPickEvent pvPickEvent = this.getPickEvent(n6, n7, 3);
            if (pvPickEvent == null) {
                return;
            }
            PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
            if (pgGeometryIf == null) {
                return;
            }
            this.removeGeometry(pgGeometryIf);
            if (this.isShowingAxes()) {
                this.recomputeAxes();
            }
            if (this.isShowingBndBox()) {
                this.recomputeBndBox();
            }
            this.update(this);
        } else if (this.m_mode == 9) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    this.m_currentGeom.pickVertex(this.pick2Offscreen(n6, n7), 1);
                } else {
                    this.m_currentGeom.tagVertices(this.markBox2Offscreen(this.m_markBox.m_data), 1);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            this.informMarkListener(true, this.m_geomIf, this.m_markBox);
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 10) {
            if (this.m_currentGeom == null) {
                return;
            }
            if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                if (this.m_currentElemInd == -1) {
                    return;
                }
                switch (this.m_currentGeom.getType()) {
                    case 33: {
                        PiVector piVector = this.m_geomIf.getElement(this.m_currentElemInd);
                        if (piVector == null) {
                            return;
                        }
                        if ((this.m_mode != 10 || !piVector.hasTag(1)) && !piVector.hasTag(12) && !piVector.hasTag(11)) break;
                        piVector.clearTag(1);
                        piVector.clearTag(12);
                        piVector.clearTag(11);
                        break;
                    }
                    case 32: {
                        PiVector piVector = this.m_geomIf.getPolygon(this.m_currentElemInd);
                        if (piVector == null) {
                            return;
                        }
                        if ((this.m_mode != 10 || !piVector.hasTag(1)) && !piVector.hasTag(12) && !piVector.hasTag(11)) break;
                        piVector.clearTag(1);
                        piVector.clearTag(12);
                        piVector.clearTag(11);
                        break;
                    }
                }
            } else {
                switch (this.m_currentGeom.getType()) {
                    case 33: {
                        this.m_currentGeom.tagElements(this.markBox2Offscreen(this.m_markBox.m_data));
                        break;
                    }
                    case 31: 
                    case 32: {
                        this.m_currentGeom.tagPolygons(this.markBox2Offscreen(this.m_markBox.m_data));
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown geometry type");
                        return;
                    }
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            this.informMarkListener(true, this.m_geomIf, this.m_markBox);
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 11) {
            if (this.m_currentGeom != null) {
                switch (this.m_currentGeom.getType()) {
                    case 33: {
                        this.m_currentGeom.untagElements(this.markBox2Offscreen(this.m_markBox.m_data));
                        break;
                    }
                    case 32: {
                        this.m_currentGeom.untagPolygons(this.markBox2Offscreen(this.m_markBox.m_data));
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown geometry type");
                        return;
                    }
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            this.informMarkListener(false, this.m_geomIf, this.m_markBox);
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 2) {
            this.bDrag = false;
            int n8 = Math.abs(this.m_markBox.m_data[2] - this.m_markBox.m_data[0]);
            int n9 = Math.abs(this.m_markBox.m_data[3] - this.m_markBox.m_data[1]);
            PdVector[] pdVectorArray = this.markBox2World(this.m_markBox);
            PdVector pdVector = PdVector.blendNew(0.5, pdVectorArray[0], 0.5, pdVectorArray[2]);
            double d = PdVector.dist(pdVectorArray[0], pdVectorArray[2]);
            if (d < 1.0E-4 || n8 < 3 || n9 < 3) {
                if (this.m_currentPick != null) {
                    pdVector.copy(this.m_currentPick.getVertex());
                }
                double d2 = this.m_currentCamera.getFieldOfView();
                PdVector pdVector2 = this.m_currentCamera.getViewDir();
                PdVector pdVector3 = this.m_currentCamera.getInterest();
                double d3 = d2 * PdVector.dotDir(pdVector2, pdVector3, pdVector);
                double d4 = this.m_currentCamera.getDist();
                d3 = d4 - d3;
                this.m_currentCamera.setInterest(pdVector);
                this.m_currentCamera.setDist(d3);
                this.m_currentCamera.update(this.m_currentCamera);
                this.repaint();
                return;
            }
            this.m_currentCamera.setInterest(pdVectorArray[5]);
            if (this.m_currentCamera.getFieldOfView() != 0.0) {
                this.m_currentCamera.setViewDir(pdVectorArray[4]);
                this.m_currentCamera.fit(1.1 * d * 2.0);
            } else {
                this.m_currentCamera.fit(1.1 * d);
            }
            if (this.getTransformationMode() != 0) {
                this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            }
            this.m_currentCamera.update(this.m_currentCamera);
            this.updateCameraListener(103);
            this.repaint();
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 12) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    int n10 = this.m_currentGeom.pickVertex(this.pick2Offscreen(n6, n7), 1);
                    if (n10 != -1) {
                        this.m_currentGeom.releaseVertex(n10, 1);
                        this.m_currentGeom.releaseVertex(n10, 12);
                        this.m_currentGeom.releaseVertex(n10, 11);
                    }
                } else {
                    this.m_currentGeom.untagVertices(this.markBox2Offscreen(this.m_markBox.m_data));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            this.informMarkListener(false, this.m_geomIf, this.m_markBox);
            this.m_markBox.setConstant(0);
        } else if (this.m_scenegraph != null) {
            this.repaint();
        }
    }

    private void informMarkListener(boolean bl, PgGeometryIf pgGeometryIf, PiVector piVector) {
        PvPickEvent pvPickEvent = new PvPickEvent(3);
        pvPickEvent.setSource(this);
        pvPickEvent.setGeometry(pgGeometryIf);
        pvPickEvent.setMarkBox(piVector);
        pvPickEvent.setMarkBoxWorld(this.markBox2World(piVector));
        if (this.m_pickFocus != null) {
            if (bl) {
                this.m_pickFocus.markVertices(pvPickEvent);
            } else {
                this.m_pickFocus.unmarkVertices(pvPickEvent);
            }
        } else if (this.m_pickListener != null) {
            Enumeration enumeration = this.m_pickListener.elements();
            while (enumeration.hasMoreElements()) {
                PvPickListenerIf pvPickListenerIf = (PvPickListenerIf)enumeration.nextElement();
                if (bl) {
                    pvPickListenerIf.markVertices(pvPickEvent);
                    continue;
                }
                pvPickListenerIf.unmarkVertices(pvPickEvent);
            }
        }
    }

    private PdVector[] getWorldFromPickPos(int n, int n2, int n3) {
        if (this.m_currentCamera == null) {
            PsDebug.warning("missing current camera");
            return null;
        }
        double d = this.m_currentCamera.getFieldOfView() / PvCamera.SIZE;
        double d2 = n3;
        PdVector pdVector = new PdVector(n * this.m_offFac, n2 * this.m_offFac, d2, 1.0);
        PdVector pdVector2 = new PdVector(n * this.m_offFac, n2 * this.m_offFac, d2 - 10.0, 1.0);
        PdVector pdVector3 = new PdVector(n * this.m_offFac, n2 * this.m_offFac, 0.0, 1.0);
        pdVector.leftMultMatrix(this.m_currentCamera.m_transInv);
        pdVector2.leftMultMatrix(this.m_currentCamera.m_transInv);
        pdVector3.leftMultMatrix(this.m_currentCamera.m_transInv);
        if (d != 0.0) {
            int n4 = 0;
            while (n4 < 4) {
                int n5 = n4;
                pdVector.m_data[n5] = pdVector.m_data[n5] / pdVector.m_data[3];
                int n6 = n4;
                pdVector2.m_data[n6] = pdVector2.m_data[n6] / pdVector2.m_data[3];
                int n7 = n4++;
                pdVector3.m_data[n7] = pdVector3.m_data[n7] / pdVector3.m_data[3];
            }
        }
        pdVector2.sub(pdVector);
        return new PdVector[]{pdVector, pdVector2, pdVector3};
    }

    private void getModelFromWorld(PvGeometry pvGeometry, PdVector pdVector, PdVector pdVector2) {
        if (pvGeometry == null) {
            return;
        }
        this.getModelFromWorld(pvGeometry.getGeometry(), pdVector, pdVector2);
    }

    private void getModelFromWorld(PgGeometryIf pgGeometryIf, PdVector pdVector, PdVector pdVector2) {
        if (pgGeometryIf == null) {
            return;
        }
        if (pgGeometryIf.hasModelMatrix()) {
            PdMatrix pdMatrix = new PdMatrix(4);
            pdMatrix.invert34(pgGeometryIf.getModelMatrix());
            if (pdVector != null) {
                pdVector.leftMultMatrix(pdMatrix);
            }
            if (pdVector2 != null) {
                pdVector2.leftMultMatrix(pdMatrix);
            }
        }
        if (pdVector != null && this.hasPaintTag(0x40000000L)) {
            int n = pdVector.getSize();
            for (int i = 0; i < n; ++i) {
                pdVector.setEntry(i, Math.rint(pdVector.getEntry(i)));
            }
        }
    }

    private static void projectBaseToGeometry(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            return;
        }
        if (Math.abs(pdVector2.getEntry(2)) > 1.0E-9) {
            double d = -pdVector.getEntry(2) / pdVector2.getEntry(2);
            pdVector.blendBase(pdVector, d, pdVector2);
        } else {
            PsDebug.warning("horizontal pick direction");
            pdVector.setEntry(2, 0.0);
        }
    }

    private int[] getOffscreenFromWorld(PdVector pdVector) {
        int n;
        PdVector pdVector2 = PdVector.copyNew(pdVector);
        int n2 = pdVector2.getSize();
        if (n2 != 4) {
            pdVector2.setSize(4);
            for (n = n2; n < 4; ++n) {
                pdVector2.setEntry(n, 0.0);
            }
            pdVector2.setEntry(3, 1.0);
        }
        pdVector2.leftMultMatrix(this.m_currentCamera.m_trans);
        if (pdVector2.m_data[3] != 1.0) {
            n = 0;
            while (n < 4) {
                int n3 = n++;
                pdVector2.m_data[n3] = pdVector2.m_data[n3] / pdVector2.m_data[3];
            }
        }
        int[] nArray = new int[]{(int)pdVector2.getEntry(0), (int)pdVector2.getEntry(1), (int)pdVector2.getEntry(2)};
        return nArray;
    }

    public PvPickEvent getPickEvent(int n, int n2) {
        return this.getPickEvent(n, n2, this.getPickType());
    }

    public PvPickEvent getPickEvent(int n, int n2, int n3) {
        PvGeometry[] pvGeometryArray;
        PdVector[] pdVectorArray = this.getWorldFromPickPos(n, n2, (int)(PvCamera.SIZE * (double)PvCamera.Z_STRETCH));
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        pdVector.copyArray(pdVectorArray[0]);
        pdVector2.copyArray(pdVectorArray[1]);
        pdVector2.normalize();
        pdVector3.copyArray(pdVectorArray[2]);
        PvPickEvent pvPickEvent = null;
        if (this.m_currentGeom != null && this.m_currentGeom.isVisible() && (n3 & 1) != 0) {
            pvPickEvent = this.m_currentGeom.getType() == 33 ? this.m_currentGeom.intersectionWithLine(n, n2, pdVector, pdVector2) : this.m_currentGeom.getGeometry().intersectionWithLine(pdVector, pdVector2);
            double d = this.m_currentGeom.getDiameter();
            if (pvPickEvent != null && pvPickEvent.getHorDistance() > d / 20.0) {
                pvPickEvent = null;
            }
        }
        if ((n3 & 2) != 0 && (pvGeometryArray = this.getAllGeometryContainers()) != null) {
            for (int i = 0; i < pvGeometryArray.length; ++i) {
                if (pvGeometryArray[i] == this.m_currentGeom || !pvGeometryArray[i].isVisible()) continue;
                PvPickEvent pvPickEvent2 = null;
                pvPickEvent2 = pvGeometryArray[i].getType() == 33 ? pvGeometryArray[i].intersectionWithLine(n, n2, pdVector, pdVector2) : pvGeometryArray[i].getGeometry().intersectionWithLine(pdVector, pdVector2);
                if (pvPickEvent2 == null) continue;
                double d = pvGeometryArray[i].getDiameter();
                if (pvPickEvent2.getHorDistance() > d / 20.0 || pvPickEvent != null && !(pvPickEvent2.getDistance() < pvPickEvent.getDistance())) continue;
                pvPickEvent = pvPickEvent2;
            }
        }
        if (pvPickEvent == null && (n3 & 4) != 0) {
            pvPickEvent = new PvPickEvent(3);
            PdVector pdVector4 = pvPickEvent.getVertex();
            double d = pdVector2.getEntry(2);
            if (Math.abs(d) > 1.0E-10) {
                pdVector4.blendBase(pdVector, -pdVector.getEntry(2) / d, pdVector2);
            }
            pvPickEvent.setVertex(pdVector4);
            pvPickEvent.setVertex(pdVector3);
            pvPickEvent.setDistance(0.0);
            pvPickEvent.setViewBase(pdVector);
            pvPickEvent.setViewDir(pdVector2);
        }
        if (pvPickEvent != null) {
            pvPickEvent.setLocation(new Point(n, n2));
            pvPickEvent.setSource(this);
        }
        return pvPickEvent;
    }

    private PdVector[] markBox2World(PiVector piVector) {
        PdVector[] pdVectorArray = PdVector.realloc(null, 6, 4);
        PdVector[] pdVectorArray2 = this.getWorldFromPickPos(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0);
        pdVectorArray[0].copy(pdVectorArray2[0]);
        pdVectorArray2 = this.getWorldFromPickPos(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0);
        pdVectorArray[1].copy(pdVectorArray2[0]);
        pdVectorArray2 = this.getWorldFromPickPos(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0);
        pdVectorArray[2].copy(pdVectorArray2[0]);
        pdVectorArray2 = this.getWorldFromPickPos(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0);
        pdVectorArray[3].copy(pdVectorArray2[0]);
        pdVectorArray2 = this.getWorldFromPickPos(piVector.m_data[0] + piVector.m_data[2] >> 1, piVector.m_data[1] + piVector.m_data[3] >> 1, 0);
        pdVectorArray[4].copy(pdVectorArray2[1]);
        pdVectorArray[5].copy(pdVectorArray2[0]);
        for (int i = 0; i < pdVectorArray.length; ++i) {
            pdVectorArray[i].setSize(3);
        }
        return pdVectorArray;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (!this.updatePosition(n2, n = mouseEvent.getY())) {
            return;
        }
        this.m_mousePos.x = n2;
        this.m_mousePos.y = n;
        if (this.bDrag) {
            if ((Math.abs(this.xUp - n2) > 0 || Math.abs(this.yUp - n) > 0) && this.isEnabledAnimation()) {
                this.start();
            }
            this.bDrag = false;
        }
        if (this.m_scenegraph != null) {
            this.m_scenegraph.mouseMoved(mouseEvent);
            if (mouseEvent.isConsumed()) {
                if (this.m_currentCursorTmp == -1) {
                    this.m_currentCursorTmp = this.m_currentCursor;
                }
                this.setCursorType(0);
                this.repaint();
                return;
            }
        }
        if (this.m_currentCursorTmp != -1) {
            this.setCursorType(this.m_currentCursorTmp);
            this.m_currentCursorTmp = -1;
        }
        if (this.hasPaintTag(256L)) {
            this.repaint();
        }
        if (this.m_currentGeom != null && (this.isShowingMagnet() || this.m_bIsShowingMagnetTmp)) {
            int n3 = this.m_currentGeom.pickVertex(this.pick2Offscreen(n2, n), 12);
            if (n3 > -1) {
                // empty if block
            }
            if (n3 != this.m_pickedVertex) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex, 12);
                this.m_pickedVertex = n3;
                this.repaint();
            }
            if (this.hasPaintTag(0x10000000000L)) {
                int n4 = -1;
                PvPickEvent pvPickEvent = this.getPickEvent(n2, n);
                if (pvPickEvent == null) {
                    return;
                }
                if (this.m_currentGeom == null || this.m_currentGeom.getGeometry() != pvPickEvent.getGeometry()) {
                    return;
                }
                n4 = pvPickEvent.getElementInd();
                if (n4 != this.m_pickedElement) {
                    switch (this.m_currentGeom.getType()) {
                        case 33: {
                            this.m_currentGeom.releaseElement(this.m_pickedElement, 12);
                            this.m_currentGeom.pickElement(n4, 12);
                            break;
                        }
                        case 31: 
                        case 32: {
                            this.m_currentGeom.releasePolygon(this.m_pickedElement, 12);
                            this.m_currentGeom.pickPolygon(n4, 12);
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown geometry type");
                            return;
                        }
                    }
                    this.m_pickedElement = n4;
                    this.repaint();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_bMouseInside = true;
        if (this.hasPaintTag(0x10000000L)) {
            // empty if block
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_bMouseInside = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
            return;
        }
    }

    private void setEnabledMagnetTmp(boolean bl) {
        if (this.m_bIsShowingMagnetTmp == bl) {
            return;
        }
        if (PsConfig.getOSId() != 0) {
            return;
        }
        this.m_bIsShowingMagnetTmp = bl;
    }

    private void glowVertices(boolean bl) {
        if (this.m_bIsGlowingVertices == bl) {
            return;
        }
        if (this.m_currentGeom == null) {
            return;
        }
        if (bl) {
            this.m_bSaveShowingVertices = this.m_currentGeom.getState(50);
        }
        this.m_bIsGlowingVertices = bl;
        if (this.m_bSaveShowingVertices) {
            return;
        }
        this.m_currentGeom.setStateFromDisplay(50, bl);
        this.m_geomIf.update(null);
        this.repaint();
    }

    private void glowBndbox(boolean bl) {
        if (this.m_bIsGlowingBndbox == bl) {
            return;
        }
        if (bl) {
            this.m_bSaveShowingBndbox = this.isShowingBndBox();
        }
        this.m_bIsGlowingBndbox = bl;
        if (this.m_bSaveShowingBndbox) {
            return;
        }
        this.showBndBox(bl);
        this.repaint();
    }

    public int getMajorMode() {
        return this.m_mode;
    }

    public void setMajorMode(int n) {
        this.m_defModeMajor = n;
        this.setCurrentMajorMode(this.m_defModeMajor);
    }

    protected void setCurrentMajorMode(int n) {
        this.m_modeMajor = n;
        if (this.m_modeMajor != this.m_mode) {
            this.releaseMinorMode(this.m_mode);
        }
        this.setMinorMode(n);
        PsDebug.showStatus(PvDisplay.getModeMessage(m_majorModeMessage, n));
    }

    private void setMinorMode(int n) {
        if (this.m_mode == n) {
            return;
        }
        this.m_mode = n;
        switch (this.m_mode) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.setCursorType(1);
                break;
            }
            case 1: {
                this.setCursorType(9);
                break;
            }
            case 3: {
                this.setCursorType(13);
                break;
            }
            case 4: {
                this.setCursorType(7);
                break;
            }
            case 0: {
                this.setCursorType(12);
                break;
            }
            case 17: {
                this.setCursorType(12);
                double d = this.m_currentCamera.getRoll();
                if (d != 0.0 && Math.abs(d) <= 90.0) {
                    this.m_currentCamera.setRoll(0.0);
                } else if (d != 180.0 && d > 90.0) {
                    this.m_currentCamera.setRoll(180.0);
                } else {
                    if (d == -180.0 || !(d < -90.0)) break;
                    this.m_currentCamera.setRoll(-180.0);
                }
                this.m_currentCamera.update(this.m_currentCamera);
                break;
            }
            default: {
                this.setCursorType(0);
            }
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        switch (this.m_mode) {
            case 13: 
            case 16: {
                this.glowVertices(true);
            }
            case 5: 
            case 9: {
                this.setEnabledMagnetTmp(true);
                break;
            }
        }
    }

    private void releaseMinorMode(int n) {
        if (this.m_mode != n) {
            PsDebug.warning("current minor mode does not match release minor mode request.");
        }
        switch (this.m_mode) {
            case 13: 
            case 16: {
                this.glowVertices(false);
            }
            case 5: 
            case 9: {
                this.setEnabledMagnetTmp(false);
                break;
            }
        }
    }

    protected void setCursorType(int n) {
        if (n == this.m_currentCursor) {
            return;
        }
        this.m_renderCanvas.setCursor(Cursor.getPredefinedCursor(n));
        this.m_currentCursor = n;
    }

    private static String getModeMessage(String[] stringArray, int n) {
        if (stringArray == null || stringArray.length <= n) {
            return "";
        }
        return stringArray[n];
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void timer(KeyEvent keyEvent) {
        if (!this.m_bInsecureKeyRelease) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(new KeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent keyEvent) {
        if (this.m_bInsecureKeyRelease) {
            this.m_bInsecureKeyRelease = false;
            this.m_storedKeyEvent = keyEvent;
            Object object = this.m_so;
            synchronized (object) {
                this.m_so.notify();
            }
            return;
        }
        this.m_bInsecureKeyRelease = true;
        int n = keyEvent.getKeyCode();
        if (n == 16 || n == 17 || n == 18) {
            this.m_prevKeyPress = -1;
            return;
        }
        if (n == this.m_prevKeyRelease) {
            return;
        }
        this.m_prevKeyRelease = n;
        this.m_prevKeyPress = -1;
        this.releaseMinorMode(this.m_mode);
        this.setMinorMode(this.m_modeMajor);
        this.m_currentCamera.mouseReleased(this.m_mousePos.x, this.m_mousePos.y);
        PsDebug.popStatus();
        this.bDrag = false;
        if (!keyEvent.isAltDown() && !keyEvent.isControlDown()) {
            if (keyEvent.isShiftDown()) {
                switch (n) {
                    case 71: 
                    case 74: {
                        this.setEnabledMagnetTmp(false);
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 69: {
                        if (this.m_currentGeom == null) {
                            PsDebug.warning("missing selected geometry");
                            break;
                        }
                        if (this.m_newElement != null && this.m_newElement.getSize() > 1) {
                            this.m_currentGeom.addGeometryElement(this.m_newElement);
                            this.m_currentGeom.untagAllVertices();
                            this.m_geomIf.update(this.m_geomIf);
                        }
                        this.m_newElement = null;
                        break;
                    }
                    case 71: {
                        this.setPaintTag(0x8000000000L, false);
                        this.setEnabledMagnetTmp(false);
                        break;
                    }
                    case 74: {
                        this.setPaintTag(0x10000000000L, false);
                        this.setEnabledMagnetTmp(false);
                        break;
                    }
                    case 85: 
                    case 88: {
                        this.repaint();
                        break;
                    }
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.m_bInsecureKeyRelease = true;
        int n = keyEvent.getKeyCode();
        if (n == 16 || n == 17 || n == 18) {
            return;
        }
        if (keyEvent.isControlDown()) {
            this.setCursorType(0);
            switch (n) {
                case 9: {
                    PgGeometryIf pgGeometryIf;
                    PgGeometryIf pgGeometryIf2 = this.getSelectedGeometry();
                    PvGeometry[] pvGeometryArray = this.getGeometryContainers();
                    if (pvGeometryArray == null) {
                        return;
                    }
                    int n2 = -1;
                    for (int i = 0; i < pvGeometryArray.length; ++i) {
                        if (pgGeometryIf2 != pvGeometryArray[i].getGeometry()) continue;
                        n2 = i;
                        break;
                    }
                    if (n2 != -1) {
                        PgGeometryIf pgGeometryIf3 = null;
                        int n3 = keyEvent.isShiftDown() ? -1 : 1;
                        for (int i = 0; i < pvGeometryArray.length; ++i) {
                            int n4 = (n2 + n3 * (1 + i) + pvGeometryArray.length) % pvGeometryArray.length;
                            PgGeometryIf pgGeometryIf4 = pvGeometryArray[n4].getGeometry();
                            if (pgGeometryIf4 == pgGeometryIf2 || this.m_specialGeom.contains(pgGeometryIf4)) continue;
                            if (!pgGeometryIf4.isVisible() && !this.hasPaintTag(2048L)) {
                                if (pgGeometryIf3 != null) continue;
                                pgGeometryIf3 = pgGeometryIf4;
                                continue;
                            }
                            this.selectGeometry(pgGeometryIf4);
                            this.update(this);
                            return;
                        }
                    }
                    if (pvGeometryArray.length <= 0 || pvGeometryArray[0] == null || (pgGeometryIf = pvGeometryArray[0].getGeometry()) == pgGeometryIf2) break;
                    this.selectGeometry(pgGeometryIf);
                    this.update(this);
                    return;
                }
                case 87: {
                    boolean bl = true;
                    this.m_sleep.setEnabled(bl);
                    this.m_bFpsEnabled = bl;
                    if (this.m_bFpsEnabled) {
                        this.start();
                        break;
                    }
                    this.stop();
                    break;
                }
                case 89: {
                    if (!keyEvent.isShiftDown()) break;
                    this.init();
                    this.update(this);
                }
            }
            return;
        }
        if (n == this.m_prevKeyPress && n != 89) {
            return;
        }
        this.m_prevKeyPress = n;
        this.m_prevKeyRelease = -1;
        if (keyEvent.isAltDown()) {
            switch (n) {
                case 65: {
                    this.setCurrentMajorMode(13);
                    break;
                }
                case 69: {
                    this.setCurrentMajorMode(16);
                    break;
                }
                case 79: {
                    this.setCurrentMajorMode(0);
                    break;
                }
                case 73: {
                    this.setCurrentMajorMode(6);
                    break;
                }
                case 77: {
                    this.setCurrentMajorMode(9);
                    break;
                }
                case 78: {
                    this.setCurrentMajorMode(10);
                    break;
                }
                case 80: {
                    this.setCurrentMajorMode(5);
                    break;
                }
                case 83: {
                    this.setCurrentMajorMode(1);
                    break;
                }
                case 84: {
                    this.setCurrentMajorMode(3);
                    break;
                }
                case 86: {
                    this.setCurrentMajorMode(17);
                    break;
                }
                case 88: {
                    this.setCurrentMajorMode(2);
                    break;
                }
                case 85: {
                    if (keyEvent.isShiftDown()) {
                        this.setCurrentMajorMode(11);
                        break;
                    }
                    this.setCurrentMajorMode(12);
                    break;
                }
                case 90: {
                    this.setCurrentMajorMode(4);
                    break;
                }
            }
            return;
        }
        this.m_currentCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.mousePressed(this.m_mousePos.x, this.m_mousePos.y);
        }
        long l = this.m_sceneDefaults;
        boolean bl = true;
        int n5 = 1;
        if (keyEvent.isShiftDown()) {
            switch (n) {
                case 65: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    PsDebug.pushStatus("Edge aura" + PvDisplay.isSwitchedOnOff(this.isShowingEdgeAura()), n5);
                    break;
                }
                case 66: {
                    this.showBndBox(!this.isShowingBndBox());
                    PsDebug.pushStatus("Bounding box" + PvDisplay.isSwitchedOnOff(this.isShowingBndBox()), n5);
                    break;
                }
                case 67: {
                    this.setPaintTag(16L, !this.hasPaintTag(16L));
                    PsDebug.pushStatus("Cross" + PvDisplay.isSwitchedOnOff(this.hasPaintTag(16L)), n5);
                    break;
                }
                case 68: {
                    this.showDepthcue(!this.isShowingDepthcue());
                    PsDebug.pushStatus("Depthcue" + PvDisplay.isSwitchedOnOff(this.isShowingDepthcue()), n5);
                    break;
                }
                case 69: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    PsDebug.pushStatus("Edge aura" + PvDisplay.isSwitchedOnOff(this.isShowingEdgeAura()), n5);
                    break;
                }
                case 70: {
                    this.showFrame(!this.isShowingFrame());
                    PsDebug.pushStatus("Frame" + PvDisplay.isSwitchedOnOff(this.isShowingFrame()), n5);
                    break;
                }
                case 71: {
                    this.showGrid(!this.isShowingGrid());
                    PsDebug.pushStatus("Grid" + PvDisplay.isSwitchedOnOff(this.isShowingGrid()), n5);
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256L)) {
                        PsDebug.showStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.getMajorMode()));
                        this.setPaintTag(256L, false);
                        break;
                    }
                    PsDebug.showStatus(PvDisplay.getModeMessage(m_majorModeMessage, 7));
                    this.setPaintTag(256L, true);
                    break;
                }
                case 73: {
                    this.showBackgroundImage(!this.isShowingBackgroundImage());
                    PsDebug.pushStatus("Background image" + PvDisplay.isSwitchedOnOff(this.isShowingBackgroundImage()), n5);
                    break;
                }
                case 74: {
                    boolean bl2;
                    boolean bl3 = bl2 = this.getLightingModel() == 1;
                    if (bl2) {
                        this.setLightingModel(0);
                        if (this.m_bSavedDepthcue) {
                            this.showDepthcue(this.m_bSavedDepthcue);
                        }
                    } else {
                        this.setLightingModel(1);
                        this.m_bSavedDepthcue = this.isShowingDepthcue();
                        this.showDepthcue(false);
                        if (this.m_light == null || this.m_light.size() == 0) {
                            this.createDefaultLights();
                        }
                    }
                    PsDebug.pushStatus("Lighting" + PvDisplay.isSwitchedOnOff(this.getLightingModel() == 1), n5);
                    break;
                }
                case 75: {
                    boolean bl4 = this.m_bHandDrawing = !this.m_bHandDrawing;
                    if (this.m_bHandDrawing) {
                        this.m_drawnStroke = new Vector();
                        this.m_strokeSet = new PgJvxSrc(3);
                        this.m_strokeSet.init();
                        this.m_strokeSet.setName("Stroke_" + PsObject.getNumObjects());
                        this.m_strokeSet.setType(32);
                        this.m_strokeSet.showVertices(false);
                        this.m_strokeSet.showPolygons(true);
                    } else {
                        this.m_strokeSet.setGlobalPolygonColor(this.getForegroundColor());
                        this.m_strokeSet.setGlobalPolygonSize(this.m_strokeSize);
                        this.m_bCentered = true;
                        this.addGeometry(this.m_strokeSet);
                        this.m_drawnStroke = null;
                        this.m_novStroke = 0;
                    }
                    PsDebug.pushStatus("Hand drawing" + PvDisplay.isSwitchedOnOff(this.m_bHandDrawing), n5);
                    break;
                }
                case 76: {
                    this.setPaintTag(4L, !this.hasPaintTag(4L));
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Border") + PvDisplay.isSwitchedOnOff(this.hasPaintTag(4L)), n5);
                    break;
                }
                case 77: {
                    this.showMagnet(!this.isShowingMagnet());
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Magnet") + PvDisplay.isSwitchedOnOff(this.isShowingMagnet()), n5);
                    break;
                }
                case 79: {
                    PvGeometry[] pvGeometryArray;
                    boolean bl5 = !this.isEnabledDirectSelect();
                    this.setEnabledDirectSelect(bl5);
                    if (bl5 && (pvGeometryArray = this.m_scene.getAllGeometryContainers()) != null) {
                        for (int i = 0; i < pvGeometryArray.length; ++i) {
                            pvGeometryArray[i].getGeometry().getModelMatrix();
                        }
                    }
                    PsDebug.showStatus(PsConfig.getMessage(true, 31000, "Direct selection") + PvDisplay.isSwitchedOnOff(this.isEnabledDirectSelect()));
                    break;
                }
                case 80: {
                    this.setEnabledPainters(!this.isEnabledPainters());
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Painters") + PvDisplay.isSwitchedOnOff(this.isEnabledPainters()), n5);
                    break;
                }
                case 81: {
                    this.showTitle(!this.isShowingTitle());
                    PsDebug.pushStatus("Title" + PvDisplay.isSwitchedOnOff(this.isShowingTitle()), n5);
                    break;
                }
                case 82: {
                    this.showCopyright(!this.isShowingCopyright());
                    PsDebug.pushStatus("Copyright" + PvDisplay.isSwitchedOnOff(this.isShowingCopyright()), n5);
                    break;
                }
                case 83: {
                    this.setEnabledAntiAlias(!this.isEnabledAntiAlias());
                    PsDebug.pushStatus("Anti-alias" + PvDisplay.isSwitchedOnOff(this.isEnabledAntiAlias()), n5);
                    break;
                }
                case 84: {
                    this.setEnabledTags(!this.isEnabledTags());
                    PsDebug.pushStatus(PsConfig.getMessage(31024) + " = " + this.isEnabledTags(), n5);
                    return;
                }
                case 85: {
                    this.setMinorMode(11);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 86: {
                    PvDisplay.setEnabledFastClipping(!PvDisplay.isEnabledFastClipping());
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Fast-clipping") + PvDisplay.isSwitchedOnOff(PvDisplay.isEnabledFastClipping()), n5);
                    break;
                }
                case 88: {
                    this.showAxes(!this.isShowingAxes());
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Axis") + PvDisplay.isSwitchedOnOff(this.isShowingAxes()), n5);
                    break;
                }
                case 89: {
                    if (this.m_thread == null) break;
                    this.setMajorMode(0);
                    this.stop();
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 90: {
                    if (this.m_bRequiresZBuffer) {
                        return;
                    }
                    this.setEnabledZBuffer(!this.isEnabledZBuffer());
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Z-Buffer") + PvDisplay.isSwitchedOnOff(this.isEnabledZBuffer()), n5);
                    break;
                }
                default: {
                    return;
                }
            }
            this.update(this);
        } else {
            bl = false;
            switch (n) {
                case 9: {
                    this.showScenegraph(!this.isShowingScenegraph());
                    bl = true;
                    break;
                }
                case 8: 
                case 127: {
                    this.setMinorMode(14);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 14));
                    return;
                }
                case 65: {
                    this.setMinorMode(13);
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 13));
                    break;
                }
                case 66: {
                    this.setMinorMode(22);
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 22));
                    break;
                }
                case 67: {
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_minorModeMessage, 1));
                    this.center();
                    bl = true;
                    break;
                }
                case 68: {
                    Object object;
                    this.setMinorMode(15);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 15));
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    PiVector piVector = this.m_currentGeom.getTaggedVertices();
                    if (piVector == null || piVector.getSize() == 0) {
                        PsDebug.warning("missing selected vertices");
                        break;
                    }
                    int n6 = piVector.getSize();
                    PdVector[] pdVectorArray = new PdVector[n6];
                    for (int i = 0; i < n6; ++i) {
                        pdVectorArray[i] = this.m_currentGeom.getVertex(piVector.getEntry(i));
                    }
                    this.m_currentGeom.untagAllVertices();
                    PdMatrix pdMatrix = null;
                    boolean bl6 = true;
                    switch (n6) {
                        case 1: {
                            pdMatrix = PuReflect.pointReflect(pdVectorArray[0]);
                            bl6 = true;
                            break;
                        }
                        case 2: {
                            object = PdVector.subNew(pdVectorArray[1], pdVectorArray[0]);
                            pdMatrix = PuReflect.rotateLine(pdVectorArray[0], (PdVector)object);
                            bl6 = false;
                            break;
                        }
                        case 3: {
                            pdMatrix = PuReflect.planeReflect(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
                            bl6 = false;
                            break;
                        }
                        default: {
                            PsDebug.warning("too many selected vertices");
                        }
                    }
                    if (pdMatrix != null && (object = this.getGeometryContainers()) != null) {
                        for (int i = 0; i < ((PvGeometry[])object).length; ++i) {
                            if (!object[i].isVisible()) continue;
                            PgGeometryIf pgGeometryIf = object[i].getGeometry();
                            boolean bl7 = pdMatrix.det33() < 0.0;
                            PgGeometry pgGeometry = pgGeometryIf.reflect(pdMatrix, bl6, bl7);
                            this.addGeometry(pgGeometry);
                        }
                        this.update(this);
                    }
                    bl = true;
                    break;
                }
                case 69: {
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    this.setMinorMode(16);
                    this.m_newElement = new PiVector();
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 70: {
                    this.fit();
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_minorModeMessage, 2));
                    break;
                }
                case 71: {
                    boolean bl8 = !this.hasPaintTag(0x8000000000L);
                    this.setPaintTag(0x8000000000L, bl8);
                    this.setEnabledMagnetTmp(bl8);
                    this.setMinorMode(21);
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 21));
                    break;
                }
                case 72: {
                    boolean bl9;
                    boolean bl10 = bl9 = !this.hasPaintTag(256L);
                    if (!bl9) {
                        PsDebug.popStatus();
                    } else {
                        PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, 7));
                    }
                    this.setPaintTag(256L, bl9);
                    bl = true;
                    break;
                }
                case 73: {
                    this.setMinorMode(6);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    return;
                }
                case 74: {
                    boolean bl11 = !this.hasPaintTag(0x10000000000L);
                    this.setPaintTag(0x10000000000L, bl11);
                    this.setEnabledMagnetTmp(bl11);
                    this.setMinorMode(20);
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 75: {
                    this.setMinorMode(8);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    return;
                }
                case 77: {
                    this.setMinorMode(9);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 78: {
                    this.setMinorMode(10);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 79: {
                    this.setMinorMode(0);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 80: {
                    this.setMinorMode(5);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 81: {
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_minorModeMessage, 4), n5);
                    this.setEnabledAnimation(false);
                    this.update(this);
                    break;
                }
                case 82: {
                    this.reset();
                    this.update(this);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_minorModeMessage, 0));
                    break;
                }
                case 83: {
                    this.setMinorMode(1);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 84: {
                    this.setMinorMode(3);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 85: {
                    this.setMinorMode(12);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 86: {
                    this.setMinorMode(17);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 87: {
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_minorModeMessage, 3), n5);
                    this.setEnabledAnimation(true);
                    this.update(this);
                    bl = true;
                    break;
                }
                case 88: {
                    this.setMinorMode(2);
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 89: {
                    this.setMajorMode(19);
                    if (this.m_thread != null) break;
                    this.start();
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode) + " - Stop with <shift-y>!");
                    break;
                }
                case 90: {
                    this.setMinorMode(4);
                    bl = true;
                    PsDebug.pushStatus(PvDisplay.getModeMessage(m_majorModeMessage, this.m_mode));
                    break;
                }
                case 38: {
                    if (this.getMajorMode() != 19) break;
                    this.speed += 0.004;
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Icrement flight speed") + " speed=" + String.valueOf(this.speed), n5);
                    break;
                }
                case 40: {
                    if (this.getMajorMode() != 19) break;
                    this.speed -= 0.004;
                    PsDebug.pushStatus(PsConfig.getMessage(true, 31000, "Decrement flight speed") + " speed=" + String.valueOf(this.speed), n5);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.m_sceneDefaults = l;
        this.bDrag = false;
        if (bl) {
            this.repaint();
        }
    }

    private static final String isSwitchedOnOff(boolean bl) {
        String string = "";
        string = bl ? " " + PsConfig.getMessage(true, 31000, "is switched ON") : " " + PsConfig.getMessage(true, 31000, "is switched OFF");
        return string;
    }

    public void configure(PvDisplayIf pvDisplayIf) {
        Object object;
        PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
        if (pgGeometryIfArray != null) {
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                pvDisplayIf.addGeometry(pgGeometryIfArray[i]);
            }
            object = this.getSelectedGeometry();
            if (object != null && pvDisplayIf.containsGeometry((PgGeometryIf)object)) {
                pvDisplayIf.selectGeometry((PgGeometryIf)object);
            }
        }
        if (this.m_geometryListener != null && this.m_geometryListener.size() > 0) {
            object = this.m_geometryListener.elements();
            while (object.hasMoreElements()) {
                pvDisplayIf.addGeometryListener((PvGeometryListenerIf)object.nextElement());
            }
        }
        if (this.m_cameraListener != null && this.m_cameraListener.size() > 0) {
            object = this.m_cameraListener.elements();
            while (object.hasMoreElements()) {
                pvDisplayIf.addCameraListener((PvCameraListenerIf)object.nextElement());
            }
        }
        if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
            object = this.m_pickListener.elements();
            while (object.hasMoreElements()) {
                pvDisplayIf.addPickListener((PvPickListenerIf)object.nextElement());
            }
        }
        object = new PvDisplayOption();
        ((PvDisplayOption)object).setOptions(this);
        ((PvDisplayOption)object).setWindowPosition(null);
        ((PvDisplayOption)object).setWindowSize(null);
        String string = pvDisplayIf.getName();
        if (string != null) {
            ((P_Vector)object).setName(string);
        }
        ((PvDisplayOption)object).configure(pvDisplayIf);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        int n2 = -1;
        if (this.m_popupMenuID != null) {
            n = this.m_popupMenuID.size();
            for (int i = 0; i < n; ++i) {
                ActionEvent actionEvent2 = (ActionEvent)this.m_popupMenuID.elementAt(i);
                if (actionEvent2.getSource() != object) continue;
                n2 = actionEvent2.getID();
            }
        }
        if (this.m_bIsShowingMagnetTmp) {
            this.setEnabledMagnetTmp(false);
        }
        if (n2 == 20500) {
            this.setCurrentMajorMode(0);
        } else if (n2 == 20501) {
            this.setCurrentMajorMode(17);
        } else if (n2 == 20502) {
            this.setCurrentMajorMode(1);
        } else if (n2 == 20504) {
            this.setCurrentMajorMode(3);
        } else if (n2 == 20506) {
            this.setCurrentMajorMode(5);
            this.setEnabledMagnetTmp(true);
        } else if (n2 == 102) {
            if (this.m_viewer != null) {
                this.m_viewer.newDisplay();
            } else {
                PvDisplay pvDisplay = new PvDisplay(this.m_applet, null);
                PsMainFrame psMainFrame = new PsMainFrame(this.m_renderCanvas, PsConfig.getProgram(), null);
                pvDisplay.setFrame(psMainFrame);
                this.configure(pvDisplay);
                psMainFrame.setInnerBounds(50, 50, 320, 256);
                ((Component)psMainFrame).setVisible(true);
            }
        } else if (n2 == 41) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(35);
            }
        } else if (n2 == 2) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(34);
            }
        } else if (object == this.m_menuDelete) {
            this.removeGeometryInsideDisplay(this.m_popupGeometry);
            this.m_popupGeometry = null;
            this.update(this);
        } else if (object == this.m_menuDeleteOther) {
            this.removeOtherGeometries(this.m_popupGeometry);
            this.m_popupGeometry = null;
            this.update(this);
        } else if (object == this.m_menuDuplicate) {
            this.duplicateGeometry(this.m_popupGeometry);
            this.m_popupGeometry = null;
            this.update(this);
        } else if (object == this.m_menuMerge) {
            this.mergeVisible(this.m_popupGeometry);
            this.m_popupGeometry = null;
            this.update(this);
        } else if (object == this.m_menuHelp) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(36);
            } else if (!PsConfig.isApplication() && this.m_applet != null) {
                URL uRL;
                n = 0;
                try {
                    uRL = new URL(PsConfig.getCodeBase() + PsConfig.HELP_HTML);
                    uRL.openConnection();
                    uRL.openStream();
                    this.m_applet.getAppletContext().showDocument(uRL, PsConfig.getMessage(24257));
                    n = 1;
                }
                catch (MalformedURLException malformedURLException) {
                    PsDebug.warning("MalformedURLException when accessing viewer help");
                }
                catch (IOException iOException) {
                    PsDebug.warning("IOException, could not open connection");
                }
                catch (Exception exception) {
                    PsDebug.warning("file not found = " + PsConfig.HELP_HTML);
                }
                if (n == 0) {
                    try {
                        uRL = new URL(PsConfig.getCodeBase() + "help.html");
                        uRL.openConnection();
                        uRL.openStream();
                        this.m_applet.getAppletContext().showDocument(uRL, PsConfig.getMessage(24257));
                    }
                    catch (MalformedURLException malformedURLException) {
                        PsDebug.warning("MalformedURLException when accessing viewer help");
                    }
                    catch (IOException iOException) {
                        PsDebug.warning("IOException, could not open connection");
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + PsConfig.HELP_HTML);
                    }
                }
            }
        } else if (object == this.m_menuAbout) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(31);
            }
        } else if (object == this.m_menuClose) {
            Frame frame = this.hasParentFrame();
            if (frame != null) {
                if (this.m_viewer != null && this.m_viewer.hasDisplay(this)) {
                    this.m_viewer.removeDisplay(this);
                }
                frame.dispose();
            }
        } else if (object == this.m_menuExit) {
            if (this.m_viewer != null) {
                this.m_viewer.destroy();
            } else {
                System.exit(0);
            }
        }
    }

    private void createDefaultPopupItems() {
        this.clearPopupMenu();
        this.addPopupItem(20500);
        this.addPopupItem(20501);
        this.addPopupItem(20502);
        this.addPopupItem(20504);
        this.addPopupItem(20506);
        this.addPopupItem(0);
        this.addPopupItem(102);
        this.addPopupItem(2);
        this.addPopupItem(0);
    }

    public void clearPopupMenu() {
        if (this.m_popupMenuID == null) {
            return;
        }
        int n = this.m_popupMenuID.size();
        for (int i = 0; i < n; ++i) {
            ActionEvent actionEvent = (ActionEvent)this.m_popupMenuID.elementAt(i);
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            menuItem.removeActionListener(this);
        }
        this.m_popupMenuID = null;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            MenuContainer menuContainer = ((MenuComponent)this.m_popup).getParent();
            if (menuContainer != null) {
                menuContainer.remove(this.m_popup);
            }
            this.m_popup = null;
        }
    }

    public void addPopupItem(int n) {
        String string = null;
        switch (n) {
            case 20500: {
                string = PsConfig.getMessage(21185);
                break;
            }
            case 20501: {
                string = PsConfig.getMessage(21226);
                break;
            }
            case 20502: {
                string = PsConfig.getMessage(21186);
                break;
            }
            case 20503: {
                string = PsConfig.getMessage(21186);
                break;
            }
            case 20504: {
                string = PsConfig.getMessage(21187);
                break;
            }
            case 20505: {
                string = PsConfig.getMessage(21187);
                break;
            }
            case 20506: {
                string = PsConfig.getMessage(21188);
                break;
            }
            case 20507: {
                string = PsConfig.getMessage(21189);
                break;
            }
            case 20508: {
                string = PsConfig.getMessage(21167);
                break;
            }
            case 20509: {
                string = PsConfig.getMessage(21191);
                break;
            }
            case 20510: {
                string = PsConfig.getMessage(21183);
                break;
            }
            case 20511: {
                string = PsConfig.getMessage(21192);
                break;
            }
            case 20512: {
                string = PsConfig.getMessage(21183);
                break;
            }
            case 20513: {
                string = PsConfig.getMessage(21103);
                break;
            }
            case 20514: {
                string = PsConfig.getMessage(21153);
                break;
            }
            case 20515: {
                string = PsConfig.getMessage(21153);
                break;
            }
            case 20516: {
                string = PsConfig.getMessage(21153);
                break;
            }
            case 102: {
                string = PsConfig.getMessage(21189);
                break;
            }
            case 41: {
                if (!PsJavaView.m_bConsoleUsable) {
                    return;
                }
                string = PsConfig.getMessage(21167);
                break;
            }
            case 2: {
                if (!PsJavaView.m_bControlUsable) {
                    return;
                }
                string = PsConfig.getMessage(21191);
                break;
            }
            case 0: {
                string = "";
                break;
            }
            default: {
                PsDebug.warning("unknown popup menu ID = " + String.valueOf(n));
                return;
            }
        }
        if (this.m_popupMenuID == null) {
            this.m_popupMenuID = new Vector();
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        ActionEvent actionEvent = new ActionEvent(menuItem, n, string);
        this.m_popupMenuID.addElement(actionEvent);
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        MenuContainer menuContainer;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            menuContainer = ((MenuComponent)this.m_popup).getParent();
            if (menuContainer != null) {
                menuContainer.remove(this.m_popup);
            }
            this.m_popup = null;
        }
        this.m_popup = new PopupMenu(PsConfig.getMessage(21184));
        if (this.m_popupMenuID != null) {
            int n = this.m_popupMenuID.size();
            for (int i = 0; i < n; ++i) {
                ActionEvent actionEvent = (ActionEvent)this.m_popupMenuID.elementAt(i);
                int n2 = actionEvent.getID();
                if (n2 == 0) {
                    this.m_popup.addSeparator();
                    continue;
                }
                if (this.m_viewer == null && (n2 == 41 || n2 == 2)) continue;
                MenuItem menuItem = (MenuItem)actionEvent.getSource();
                this.m_popup.add(menuItem);
            }
        }
        this.m_menuHelp = new MenuItem(PsConfig.getMessage(21192));
        this.m_menuHelp.addActionListener(this);
        this.m_popup.add(this.m_menuHelp);
        if (this.m_viewer != null) {
            this.m_menuAbout = new MenuItem(PsConfig.getMessage(21183));
            this.m_menuAbout.addActionListener(this);
            this.m_popup.add(this.m_menuAbout);
        }
        if (this.hasParentFrame() != null) {
            this.m_menuClose = new MenuItem(PsConfig.getMessage(21103));
            this.m_menuClose.addActionListener(this);
            if (this.m_viewer != null && this != ((PvViewer)this.m_viewer).m_mainDisplay) {
                this.m_popup.add(this.m_menuClose);
            }
        }
        if (PsConfig.isApplication()) {
            this.m_menuExit = new MenuItem(PsConfig.getMessage(21153));
            this.m_menuExit.addActionListener(this);
            this.m_popup.add(this.m_menuExit);
        }
        if ((menuContainer = this.m_renderCanvas.getParent()) == null) {
            menuContainer = this.m_renderCanvas;
        }
        ((Component)menuContainer).add(this.m_popup);
        this.m_popup.show(this.m_renderCanvas, mouseEvent.getX(), mouseEvent.getY());
    }

    private void showPopupScene(MouseEvent mouseEvent, PgGeometryIf pgGeometryIf) {
        MenuContainer menuContainer;
        this.m_popupGeometry = pgGeometryIf;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            menuContainer = ((MenuComponent)this.m_popup).getParent();
            if (menuContainer != null) {
                menuContainer.remove(this.m_popup);
            }
            this.m_popup = null;
        }
        this.m_popup = new PopupMenu(PsConfig.getMessage(true, 21000, "Scene Graph"));
        this.m_menuDelete = new MenuItem(PsConfig.getMessage(true, 21000, "Delete"));
        this.m_menuDelete.addActionListener(this);
        this.m_popup.add(this.m_menuDelete);
        this.m_menuDeleteOther = new MenuItem(PsConfig.getMessage(true, 21000, "Delete Other"));
        this.m_menuDeleteOther.addActionListener(this);
        this.m_popup.add(this.m_menuDeleteOther);
        this.m_menuDuplicate = new MenuItem(PsConfig.getMessage(true, 21000, "Duplicate"));
        this.m_menuDuplicate.addActionListener(this);
        this.m_popup.add(this.m_menuDuplicate);
        this.m_menuMerge = new MenuItem(PsConfig.getMessage(true, 21000, "Merge Visible"));
        this.m_menuMerge.addActionListener(this);
        this.m_popup.add(this.m_menuMerge);
        menuContainer = this.m_renderCanvas.getParent();
        if (menuContainer == null) {
            menuContainer = this.m_renderCanvas;
        }
        ((Component)menuContainer).add(this.m_popup);
        this.m_popup.show(this.m_renderCanvas, mouseEvent.getX(), mouseEvent.getY());
    }

    public PsPanel getInfoPanel() {
        if (this.m_infoPanel == null || this.m_infoPanel.getPanelVersion() != PsConfig.getPanelVersion()) {
            this.m_infoPanel = new PvDisplay_IP();
            this.m_infoPanel.setParent(this);
            this.m_infoPanel.update(this);
        }
        return this.m_infoPanel;
    }

    public PsPanel getCameraPanel() {
        if ((this.m_cameraPanel == null || this.m_cameraPanel.getPanelVersion() != PsConfig.getPanelVersion()) && this.m_currentCamera != null) {
            this.m_cameraPanel = this.m_currentCamera.getInfoPanel();
        }
        return this.m_cameraPanel;
    }

    public PsPanel getAxisPanel() {
        if (!this.hasAxes()) {
            this.createAxes();
        }
        return this.m_axes.getControlPanel();
    }

    public PsPanel getAxisPanel(int n) {
        if (!this.hasAxes()) {
            this.createAxes();
        }
        PgRuler[] pgRulerArray = this.m_axes.getAxes();
        n = n == 25 ? 2 : (n == 24 ? 1 : 0);
        return pgRulerArray[n].getControlPanel();
    }

    protected void createRGBLights() {
        this.removeLights();
        PvLight pvLight = new PvLight(this, 1);
        pvLight.setReference(1);
        pvLight.setName(PsConfig.getMessage(24258));
        pvLight.setColor(Color.red);
        pvLight.setPosition(-5.0, 2.0, 5.0);
        pvLight.setInterest(0.0, 0.0, 0.0);
        this.addLight(pvLight);
        pvLight = new PvLight(this, 1);
        pvLight.setReference(1);
        pvLight.setName(PsConfig.getMessage(24259));
        pvLight.setColor(Color.green);
        pvLight.setPosition(0.0, -5.0, 10.0);
        pvLight.setInterest(0.0, 0.0, 0.0);
        this.addLight(pvLight);
        pvLight = new PvLight(this, 1);
        pvLight.setReference(1);
        pvLight.setName(PsConfig.getMessage(24260));
        pvLight.setColor(Color.blue);
        pvLight.setPosition(5.0, 2.0, 5.0);
        pvLight.setInterest(0.0, 0.0, 0.0);
        this.addLight(pvLight);
        if (this.m_currentLight != null) {
            this.m_currentLight.updatePanels(this.m_currentLight);
        }
    }

    protected void createDefaultLights() {
        this.removeLights();
        PvLight pvLight = new PvLight(this, 5);
        pvLight.setName(PsConfig.getMessage(24415));
        pvLight.setColor(Color.white);
        pvLight.setIntensity(0.8);
        this.addLight(pvLight);
        pvLight = new PvLight(this, 6);
        pvLight.setName(PsConfig.getMessage(24416));
        pvLight.setColor(Color.white);
        pvLight.setIntensity(0.3);
        this.addLight(pvLight);
        if (this.m_currentLight != null) {
            this.m_currentLight.updatePanels(this.m_currentLight);
        }
    }

    protected void createDefaultHighlight() {
        this.removeLights();
        PvLight pvLight = new PvLight(this, 5);
        pvLight.setName(PsConfig.getMessage(24415));
        pvLight.setColor(Color.white);
        pvLight.setIntensity(0.5);
        this.addLight(pvLight);
        pvLight = new PvLight(this, 0);
        pvLight.setName(PsConfig.getMessage(24232));
        pvLight.setColor(Color.white);
        pvLight.setIntensity(0.1);
        this.addLight(pvLight);
        pvLight = new PvLight(this, 2);
        pvLight.setName(PsConfig.getMessage(24295));
        pvLight.setShading(2);
        pvLight.setColor(Color.white);
        pvLight.setHighlight(true);
        pvLight.setIntensity(0.4);
        pvLight.setExponent(30.0);
        this.addLight(pvLight);
        if (this.m_currentLight != null) {
            this.m_currentLight.updatePanels(this.m_currentLight);
        }
    }

    public PsPanel getLightPanel() {
        if (this.m_lightPanel == null || !this.m_lightPanel.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_lightPanel = this.m_currentLight != null ? this.m_currentLight.getInfoPanel() : new PvLight_IP();
            ((PvLight_IP)this.m_lightPanel).setDisplay(this);
        }
        return this.m_lightPanel;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.m_renderCanvas.getPreferredSize();
        dimension.width = 350;
        dimension.height = 350;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = m_renderType != 2 ? super.getPreferredSize() : this.m_renderCanvas.getPreferredSize();
        if (m_preferredSize != null) {
            dimension.width = PvDisplay.m_preferredSize.width;
            dimension.height = PvDisplay.m_preferredSize.height;
        } else {
            dimension.width = 350;
            dimension.height = 350;
        }
        return dimension;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, PsConfig.getProgram() + ": " + PsConfig.getMessage(12014));
            this.m_thread.setPriority(5);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
        }
        if (this.m_bFpsEnabled) {
            this.m_bFpsEnabled = false;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_cFps.setState(this.m_bFpsEnabled);
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(PsConfig.getMessage(24261));
                this.m_sleep.setEnabled(false);
            }
        }
    }

    public void setAutoRotation(PdVector pdVector, double d) {
        if (!PuReflect.makeRotation(this.m_currentCamera.m_incrView, pdVector, d)) {
            return;
        }
        if (this.getTransformationMode() == 0) {
            this.m_currentCamera.m_incrViewInv.transpose(this.m_currentCamera.m_incrView);
        } else {
            this.m_modelCamera.m_incrModelInv.transpose(this.m_currentCamera.m_incrView);
        }
    }

    public boolean incrementAutoRotation() {
        this.m_currentCamera.mouseAnimateGeometry();
        this.updateCameraListener(101);
        return true;
    }

    public void run() {
        double d = 0.0;
        if (this.m_bFpsEnabled) {
            this.m_pCount = 0;
            d = new Date().getTime();
        }
        while (this.m_thread != null) {
            double d2;
            if (!this.m_bDrawing) {
                if (this.isEnabledAnimation()) {
                    boolean bl;
                    boolean bl2 = bl = this.isEnabledLocalTransform() || this.m_currentCamera.getMode() == 17 && this.m_currentCamera.getProjectionMode() == 0 && this.m_mouseShiftConstraint == 2;
                    if (this.getTransformationMode() == 0) {
                        this.m_currentCamera.mouseAnimate(bl);
                    } else {
                        this.m_modelCamera.mouseAnimate();
                    }
                    boolean bl3 = this.hasPaintTag(1L);
                    this.setPaintTag(1L, false);
                    this.updateCameraListener(101);
                    this.setPaintTag(1L, bl3);
                    this.repaint();
                } else if (this.getMajorMode() == 19) {
                    PdVector pdVector = (PdVector)this.m_currentCamera.getInterest().clone();
                    PdVector pdVector2 = this.m_currentCamera.getPosition();
                    pdVector.blendBase(pdVector, 0.1, this.m_prevSteer);
                    pdVector.blend(1.0 + this.speed, pdVector, -this.speed, pdVector2);
                    this.m_currentCamera.setInterest(pdVector);
                    PdVector pdVector3 = (PdVector)this.m_currentCamera.getUpVector().clone();
                    PdVector pdVector4 = PdVector.subNew(pdVector, pdVector2);
                    if (!pdVector4.normalize()) {
                        return;
                    }
                    this.m_currentCamera.setViewDir(pdVector4);
                    this.m_currentCamera.setUpVector(pdVector3);
                    this.m_currentCamera.update(this.m_currentCamera);
                } else {
                    this.repaint();
                }
            }
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.m_bFpsEnabled || !((d2 = (double)new Date().getTime()) - d > (double)(this.m_period * 1000L))) continue;
            this.fps = (this.fps + (double)this.m_pCount / ((d2 - d) / 1000.0)) / 2.0;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(String.valueOf((double)((int)(this.fps * 100.0)) / 100.0));
            }
            d = d2;
            this.m_pCount = 0;
        }
    }

    private void drawInfo(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.m_nWidth * n3;
        int n7 = this.m_nHeight * n3;
        int n8 = n * n3;
        int n9 = n2 * n3;
        String string = "";
        PdVector pdVector = null;
        PgGeometryIf pgGeometryIf = null;
        boolean bl = false;
        if (this.m_currentGeom == null) {
            return;
        }
        String[] stringArray = this.getPickEvent(n, n2);
        if (stringArray == null) {
            return;
        }
        pgGeometryIf = stringArray.getGeometry();
        if (pgGeometryIf == null) {
            bl = true;
            pgGeometryIf = this.m_currentGeom.getGeometry();
        } else if (this.m_currentGeom.getGeometry() != pgGeometryIf) {
            return;
        }
        pdVector = stringArray.getVertex();
        int n10 = -1;
        if (this.isShowingMagnet() || this.m_bIsShowingMagnetTmp) {
            n10 = this.m_scene.getGeometryContainer(pgGeometryIf).pickVertex(this.pick2Offscreen(n8, n9), 12);
        }
        if (n10 > -1) {
            pdVector = pgGeometryIf.getVertex(n10);
            string = string + PsConfig.getMessage(24265) + "[" + n10 + "] = ";
        } else {
            string = string + PsConfig.getMessage(24263) + " = ";
        }
        if (pdVector != null) {
            for (n5 = 0; n5 < pdVector.getSize(); ++n5) {
                string = string + "\n  " + (float)pdVector.getEntry(n5);
            }
        } else {
            string = string + PsConfig.getMessage(24264);
        }
        string = string + "\n" + PsConfig.getMessage(24228) + " = " + String.valueOf((float)stringArray.getDistance());
        if (pgGeometryIf != null) {
            string = string + "\n" + PsConfig.getMessage(24262) + " = " + pgGeometryIf.getName();
            string = string + "\n";
            if (stringArray.getElementInd() != -1) {
                string = string + PsConfig.getMessage(24032) + " = " + stringArray.getElementInd();
            }
            string = string + "\n";
            if (stringArray.getVertexInd() > -1) {
                string = string + PsConfig.getMessage(24265) + " = " + stringArray.getVertexInd();
            }
        }
        stringArray = PuString.splitString(string, '\n');
        graphics.setFont(this.m_infoFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n5 = fontMetrics.getHeight();
        int n11 = 25 * fontMetrics.charWidth('0');
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n11 = Math.max(n11, fontMetrics.stringWidth(stringArray[n4]));
        }
        n4 = 7 * n3;
        int n12 = 7 * n3;
        int n13 = 3 * n3;
        int n14 = Math.min(n8, n6 - n11 - 2 * n13 - n4 - 5 * n3);
        int n15 = Math.min(n9, n7 - stringArray.length * n5 - 2 * n13 - n12 - 5 * n3);
        graphics.setColor(Color.white);
        graphics.fillRect(n14 + n4, n15 + n12, n11 + 2 * n13, stringArray.length * n5 + n13);
        graphics.setColor(Color.black);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], n14 + n4 + n13, n15 + n12 - n13 + (i + 1) * n5);
        }
        if (pdVector != null) {
            if (!bl && pgGeometryIf != null && pgGeometryIf.hasModelMatrix()) {
                PdMatrix pdMatrix = pgGeometryIf.getModelMatrix();
                pdVector.setSize(4);
                pdVector.setEntry(3, 1.0);
                pdVector.leftMultMatrix(pdMatrix);
            }
            int[] nArray = this.getOffscreenFromWorld(pdVector);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] * n3 / this.m_offFac;
            }
            graphics.setColor(Color.red);
            graphics.drawOval(nArray[0] - 5 * n3, nArray[1] - 5 * n3, 10 * n3, 10 * n3);
            PvDisplay.drawCross(graphics, 5 * n3, nArray[0], nArray[1]);
        }
    }

    private void drawDetail(Graphics graphics, int n, int n2, int n3) {
        int n4;
        String[] stringArray;
        PvGeometry pvGeometry = this.m_currentGeom;
        if (pvGeometry == null) {
            return;
        }
        int n5 = this.m_nWidth * n3;
        int n6 = this.m_nHeight * n3;
        int n7 = n * n3;
        int n8 = n2 * n3;
        int n9 = this.m_currentGeom.pickVertex(this.pick2Offscreen(n7, n8), 12);
        if (n9 != this.m_pickedVertex) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex, 12);
            this.m_pickedVertex = n9;
        }
        if (this.m_pickedVertex == -1) {
            return;
        }
        PdVector pdVector = this.m_currentGeom.getVertex(this.m_pickedVertex);
        String string = "";
        if (this.hasPaintTag(0x10000000000L) && (stringArray = pdVector.getURL()) != null && stringArray.length() > 0) {
            string = string + PsConfig.getMessage(24417) + (String)stringArray + "\n";
        }
        if (this.hasPaintTag(0x8000000000L) && (stringArray = pdVector.getDetail()) != null && stringArray.length() > 0) {
            string = string + PsConfig.getMessage(24418) + (String)stringArray + "\n";
        }
        if (PuString.isEmpty(string)) {
            return;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        stringArray = PuString.splitString(string, 25);
        graphics.setFont(this.m_infoFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n10 = fontMetrics.getHeight();
        int n11 = 25 * fontMetrics.charWidth('0');
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n11 = Math.max(n11, fontMetrics.stringWidth(stringArray[n4]));
        }
        n4 = 7 * n3;
        int n12 = 7 * n3;
        int n13 = 3 * n3;
        int n14 = Math.min(n7, n5 - n11 - 2 * n13 - n4 - 5 * n3);
        int n15 = Math.min(n8, n6 - stringArray.length * n10 - 2 * n13 - n12 - 5 * n3);
        graphics.setColor(Color.white);
        graphics.fillRect(n14 + n4, n15 + n12, n11 + 2 * n13, stringArray.length * n10 + n13);
        graphics.setColor(Color.black);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], n14 + n4 + n13, n15 + n12 - n13 + (i + 1) * n10);
        }
    }

    public void burn() {
        if (this.m_scene == null) {
            return;
        }
        this.m_scene.m_bIsBurning = true;
        this.m_scene.paint(null, this);
        this.m_scene.m_bIsBurning = false;
    }

    private static void initModeMessages() {
        m_majorModeMessage = new String[]{PsConfig.getMessage(31000), PsConfig.getMessage(31001), PsConfig.getMessage(31002), PsConfig.getMessage(31003), PsConfig.getMessage(31004), PsConfig.getMessage(31005), PsConfig.getMessage(31006), PsConfig.getMessage(31007), PsConfig.getMessage(31008), PsConfig.getMessage(31009), PsConfig.getMessage(31010), PsConfig.getMessage(31011), PsConfig.getMessage(31012), PsConfig.getMessage(31013), PsConfig.getMessage(31014), PsConfig.getMessage(31015), PsConfig.getMessage(31016), PsConfig.getMessage(true, 31000, "Rotate in xy-plane; drag up/down to adjust z-axis."), PsConfig.getMessage(true, 31000, "Draw annotations."), PsConfig.getMessage(true, 31000, "Fly camera mode"), PsConfig.getMessage(true, 31000, "Active URLs"), PsConfig.getMessage(true, 31000, "Detail information")};
        m_minorModeMessage = new String[]{PsConfig.getMessage(31017), PsConfig.getMessage(31018), PsConfig.getMessage(31019), PsConfig.getMessage(31020), PsConfig.getMessage(31021)};
    }

    public boolean selectLight(PvLightIf pvLightIf) {
        if (pvLightIf != null && !this.hasLight(pvLightIf)) {
            return false;
        }
        this.m_currentLight = (PvLight)pvLightIf;
        if (this.m_currentLight == null) {
            if (this.m_lightPanel != null) {
                this.m_lightPanel.setParent(null);
            }
            return true;
        }
        if (this.m_lightPanel != null) {
            if (!this.m_currentLight.hasInspector("Info")) {
                this.m_currentLight.addInspector("Info", this.m_lightPanel);
            } else {
                this.m_lightPanel.setParent(this.m_currentLight);
                this.m_lightPanel.update(this.m_currentLight);
            }
        }
        return true;
    }

    public void showAllViews(boolean bl) {
        if (bl == this.isShowingAllViews()) {
            return;
        }
        if (bl) {
            int n;
            if (this.m_viewer == null) {
                return;
            }
            this.m_allDisp = new PvDisplay[4];
            this.m_allDisp[0] = this;
            this.m_allDisp[0].setPaintTag(0x10000000L, false);
            this.m_allDisp[0].setPaintTag(0x20000000L, true);
            int n2 = this.m_currentCamera.getProjectionMode();
            int n3 = this.m_nWidth >> 1;
            int n4 = this.m_nHeight >> 1;
            if (this.m_frame != null) {
                this.m_origBnd = this.m_frame.getBounds();
                n3 = this.m_origBnd.width >> 1;
                n4 = this.m_origBnd.height >> 1;
                ((Component)this.m_frame).setBounds(new Rectangle(this.m_origBnd.x, this.m_origBnd.y, n3, n4));
            }
            for (n = 1; n < 4; ++n) {
                this.m_allDisp[n] = (PvDisplay)this.m_viewer.newDisplay(PsConfig.getMessage(24238) + ": " + PvCameraIf.CAMERA_NAME[n], true, false);
                this.m_allDisp[n].setPaintTag(0x10000000L, false);
                this.configure(this.m_allDisp[n]);
                this.m_allDisp[n].selectCamera((n2 + n) % 4);
                Frame frame = this.m_allDisp[n].getFrame();
                if (frame == null) continue;
                frame.pack();
                switch (n) {
                    case 1: {
                        ((Component)frame).setBounds(this.m_origBnd.x + n3, this.m_origBnd.y, n3, n4);
                        break;
                    }
                    case 2: {
                        ((Component)frame).setBounds(this.m_origBnd.x, this.m_origBnd.y + n4, n3, n4);
                        break;
                    }
                    case 3: {
                        ((Component)frame).setBounds(this.m_origBnd.x + n3, this.m_origBnd.y + n4, n3, n4);
                    }
                }
                ((Component)frame).setVisible(true);
            }
            for (n = 1; n < 4; ++n) {
                this.m_allDisp[n].setPaintTag(0x8000000L, true);
                this.m_allDisp[n].m_allParentDisp = this;
                this.m_allDisp[n].m_allDisp = this.m_allDisp;
            }
        } else {
            int n;
            for (n = 1; n < 4; ++n) {
                this.m_allDisp[n].setPaintTag(0x8000000L, false);
            }
            if (this.m_allParentDisp != null) {
                this.m_allParentDisp.showAllViews(false);
            } else {
                this.setPaintTag(0x8000000L, false);
                for (n = 1; n < 4; ++n) {
                    Frame frame = this.m_allDisp[n].getFrame();
                    if (frame == null) continue;
                    PvViewer pvViewer = (PvViewer)this.m_allDisp[n].getViewer();
                    if (pvViewer != null) {
                        pvViewer.removeFrame(frame);
                    }
                    frame.dispose();
                }
                if (this.m_origBnd != null && this.m_frame != null) {
                    ((Component)this.m_frame).setBounds(this.m_origBnd);
                }
                this.m_allDisp = null;
                this.m_origBnd = null;
            }
            if (this.isEnabledInspection() && this.m_viewer != null) {
                this.m_viewer.selectDisplay(this);
            }
        }
        this.setPaintTag(0x8000000L, bl);
    }

    public boolean selectCamera(int n) {
        if (n < 0 || PvCameraIf.CAMERA_NAME.length <= n) {
            return false;
        }
        boolean bl = false;
        if (this.getCamera(n) == null) {
            bl = true;
            this.addCamera(PvCameraIf.CAMERA_NAME[n], new PvCamera(this, n));
        }
        this.m_currentCamera = (PvCamera)this.getCamera(n);
        if (n == 1 && this.m_currentCamera.isEnabledSceneRatio()) {
            this.m_currentCamera.setSceneRatio(1.0);
            PdVector[] pdVectorArray = this.getFullBounds();
            if (pdVectorArray != null) {
                double d = pdVectorArray[1].getEntry(0) - pdVectorArray[0].getEntry(0);
                double d2 = pdVectorArray[1].getEntry(1) - pdVectorArray[0].getEntry(1);
                if (this.isEnabledBoxRatio()) {
                    d *= this.m_boxRatio.getEntry(0);
                    d2 *= this.m_boxRatio.getEntry(1);
                }
                if (d2 > 1.0E-10) {
                    double d3 = d / d2;
                    this.m_currentCamera.setSceneRatio(d3);
                }
            }
        }
        this.m_currentCamera.setEnabledFillDisplay(this.isEnabledFillDisplay());
        this.m_currentCamera.setEnabledBoxRatio(this.isEnabledBoxRatio());
        this.m_currentCamera.setBoxRatio(this.getBoxRatio());
        this.m_currentCamera.resizeImage(this.m_widthOff, this.m_heightOff);
        this.m_currentCamera.resizeImagePick(this.m_widthPick, this.m_heightPick);
        this.m_currentCamera.setMode(this.m_mode);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            this.m_modelCamera.setProjectionMode(n);
        }
        if (bl) {
            this.fit();
            this.center();
            this.saveCameraDefaults();
        }
        if (this.m_cameraPanel != null) {
            if (!this.m_currentCamera.hasInspector("Info")) {
                this.m_currentCamera.addInspector("Info", this.m_cameraPanel);
            } else {
                this.m_cameraPanel.setParent(this.m_currentCamera);
                this.m_cameraPanel.update(this.m_currentCamera);
            }
        }
        this.updateCameraListener(101);
        this.m_cameraDefault = n;
        if (this.hasAxes()) {
            this.m_axes.setCameraType(n);
        }
        return true;
    }

    static {
        PS_ZOOM = 1000.0f;
        m_bEnableFastZBuffer = false;
        m_bEnableFastClipping = true;
        m_numDisplays = 0;
    }
}

