/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Color;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvCameraEvent;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.thirdParty.ruler.PgRuler;
import jv.vecmath.PdVector;

public final class PgAxes
extends PgGeometry
implements PvCameraListenerIf {
    public static final int AXES_NONE = -1;
    public static final int AXES_3DCENTRAL = 0;
    public static final int AXES_3DCORNER = 1;
    public static final int AXES_3DBOUNDINGBOX = 2;
    public static final int AXES_2DXY_CENTER = 3;
    public static final int AXES_2DYZ_CENTER = 4;
    public static final int AXES_2DZX_CENTER = 5;
    public static final int AXES_2DXY_CORNER = 6;
    public static final int AXES_2DYZ_CORNER = 7;
    public static final int AXES_2DZX_CORNER = 8;
    public static final int AXES_2DBOUNDINGBOX = 9;
    public static final int COORD_ADJUST = 0;
    public static final int COORD_SCENE = 1;
    public static final int COORD_MODEL = 2;
    public static final int COORD_AMBIENT = 3;
    public static int OPT_HASH_NUMBER = 8;
    public static double OPT_HASH_RATIO = 4.0;
    protected static final int XN = 0;
    protected static final int XUP = 1;
    protected static final int YN = 2;
    protected static final int YUP = 3;
    protected static final int ZN = 4;
    protected static final int ZUP = 5;
    protected static final int MIN = 0;
    protected static final int MAX = 1;
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int N = 0;
    protected static final int U = 1;
    protected static final int NEGN = -1;
    protected static final int NEGU = -2;
    protected final double defScale = 1.0;
    protected final int xoff = 7;
    protected final int yoff = 4;
    protected final int[] STD_ALIGN = new int[]{1, 0, 7, 4};
    protected final int[] STD_ALIGN_X = new int[]{1, 0, 7, 4};
    protected final int[] STD_ALIGN_Y = new int[]{1, 2, -14, -16};
    protected final int[] STD_ALIGN_Z = new int[]{1, 2, -21, 0};
    protected int m_coordSystem;
    protected int m_cameraType;
    protected PvDisplayIf m_display;
    protected int m_mode;
    protected int m_dimMode;
    protected int m_numAxis;
    protected PgRuler[] m_axis;
    private final String[] m_defAxisLabel = new String[]{"x", "y", "z"};
    protected boolean[] m_showHashingFlags;
    protected int m_hashMode;
    protected boolean m_bShowAllMajors;
    protected boolean m_bShowAllMinors;
    protected boolean m_bShowLabels;
    protected boolean m_bShowRulerNames;
    protected boolean m_bAutoBounds;
    protected boolean m_bAutoHashing;
    protected boolean m_bAutoLayout;
    protected double m_scale;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    protected PdVector[] m_bndbox;
    protected PdVector[] m_bndboxDisp;
    protected PuDouble[] m_bndMin;
    protected PuDouble[] m_bndMax;
    protected PdVector m_viewVect;
    protected PdVector m_boxRatio;
    protected boolean m_bEnableBoxRatio;
    protected PdColor m_bndBoxColor;
    protected int m_indexOfColor;
    protected PdColor m_axesColor;
    protected PuDouble m_axesSize;
    protected boolean m_bEnabledX;
    protected boolean m_bEnabledY;
    protected boolean m_bEnabledZ;
    protected boolean m_bEnabledGridXY;
    protected boolean m_bEnabledGridYZ;
    protected boolean m_bEnabledGridZX;

    public PgAxes(int n) {
        super(n);
        int n2;
        this.setTag(10);
        this.setName(PsConfig.getMessage(15019));
        this.m_numAxis = 3;
        this.m_dimMode = 2;
        this.m_cameraType = 0;
        this.m_showHashingFlags = new boolean[6];
        this.m_axis = new PgRuler[this.m_numAxis];
        PdVector pdVector = new PdVector(this.m_numAxis);
        PdVector pdVector2 = new PdVector(this.m_numAxis);
        for (n2 = 0; n2 < this.m_numAxis; ++n2) {
            this.m_axis[n2] = new PgRuler(this.m_numAxis);
            this.m_axis[n2].setParent(this);
            pdVector.setConstant(0.0);
            pdVector.setEntry(n2, 1.0);
            this.m_axis[n2].setDirection(pdVector);
            pdVector2.setConstant(0.0);
            pdVector2.setEntry((n2 + 1) % this.m_numAxis, 1.0);
            this.m_axis[n2].setNormal(pdVector2);
            this.m_axis[n2].setVisible(false);
        }
        this.m_bEnabledX = false;
        this.m_bEnabledY = false;
        this.m_bEnabledZ = false;
        this.m_bEnabledGridXY = false;
        this.m_bEnabledGridYZ = false;
        this.m_bEnabledGridZX = false;
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        this.m_bndbox = PdVector.realloc(null, 2, 3);
        this.m_bndboxDisp = PdVector.realloc(null, 2, 3);
        this.m_bndMin = new PuDouble[this.m_numAxis];
        this.m_bndMax = new PuDouble[this.m_numAxis];
        for (n2 = 0; n2 < this.m_numAxis; ++n2) {
            this.m_axis[n2].m_bndMin.setName(this.m_defAxisLabel[n2] + "-" + PsConfig.getMessage(true, 24000, "Min"));
            this.m_bndMin[n2] = this.m_axis[n2].m_bndMin;
            this.m_bndMin[n2].addUpdateListener(this);
            this.m_axis[n2].m_bndMax.setName(this.m_defAxisLabel[n2] + "-" + PsConfig.getMessage(true, 24000, "Max"));
            this.m_bndMax[n2] = this.m_axis[n2].m_bndMax;
            this.m_bndMax[n2].addUpdateListener(this);
        }
        this.m_bndBoxColor = new PdColor(PsConfig.getMessage(true, 24000, "Bounding Box"), this);
        this.m_axesColor = new PdColor(PsConfig.getMessage(true, 24000, "Color"), this);
        this.m_axesSize = new PuDouble(PsConfig.getMessage(true, 24000, "Thickness"), this);
        this.m_majorHashUnits = new PuDouble(PsConfig.getMessage(24191), this);
        this.m_minorHashUnits = new PuDouble(PsConfig.getMessage(24192), this);
        this.m_numMajorHashings = new PuInteger(PsConfig.getMessage(24193), this);
        this.m_numMinorHashings = new PuInteger(PsConfig.getMessage(24194), this);
        this.init();
    }

    public void init() {
        int n;
        super.init();
        for (n = 0; n < this.m_showHashingFlags.length; ++n) {
            this.m_showHashingFlags[n] = false;
        }
        this.m_mode = 1;
        this.setMode(0);
        this.setCoordSystem(0);
        this.m_scale = 1.0;
        this.m_bAutoLayout = true;
        this.m_bAutoHashing = false;
        this.setEnabledAutoHashing(true);
        this.m_bAutoBounds = false;
        this.setEnabledAutoBounds(true);
        this.m_boxRatio = null;
        this.m_bEnableBoxRatio = false;
        this.m_indexOfColor = -1;
        for (n = 0; n < this.m_numAxis; ++n) {
            this.m_axis[n].init();
        }
        this.m_axesColor.setColor(this.m_axis[0].getGlobalPolygonColor());
        this.m_axis[0].setHashLabel(0, 3, 1, 2);
        this.m_axis[1].setHashLabel(0, 3, 1, 2);
        if (this.m_numAxis > 2) {
            this.m_axis[2].setHashLabel(-5, 0, 2, 1);
        }
        this.setFixedHashings(this.m_scale, this.m_scale / 2.0);
        this.setNames(this.m_defAxisLabel);
        this.showNames(true);
        this.m_axesSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_axesSize.setDefValue(1.0);
        this.m_axesSize.init();
        this.m_majorHashUnits.setDefBounds(0.1, 60.0, 0.1, 1.0);
        this.m_majorHashUnits.setDefValue(this.m_axis[0].getMajorUnit());
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.setDefValue(this.m_axis[0].getMinorUnit());
        this.m_minorHashUnits.setDefBounds(0.1, 30.0, 0.1, 1.0);
        this.m_minorHashUnits.init();
        this.m_numMajorHashings.setDefValue(this.m_axis[0].getNumMajorPartitions());
        this.m_numMajorHashings.setDefBounds(0, 60, 1, 2);
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.setDefValue(this.m_axis[0].getNumMinorPartitions());
        this.m_numMinorHashings.setDefBounds(0, 30, 1, 2);
        this.m_numMinorHashings.init();
        this.m_hashMode = this.m_axis[0].getHashMode();
        this.m_bShowAllMajors = this.m_axis[0].isShowingMajorHashings();
        this.m_bShowAllMinors = this.m_axis[0].isShowingMinorHashings();
        this.m_bShowLabels = this.m_axis[0].isShowingLabels();
    }

    public void reset() {
        this.init();
        this.constructAxes();
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].computeHashings();
        }
    }

    public void setEnabledBoxRatio(boolean bl) {
        if (this.m_bEnableBoxRatio == bl) {
            return;
        }
        this.m_bEnableBoxRatio = bl;
    }

    public void setBoxRatio(PdVector pdVector) {
        this.m_boxRatio = pdVector;
    }

    public boolean update(Object object) {
        if (object == this) {
            if (this.m_display != null) {
                this.m_bEnableBoxRatio = this.m_display.isEnabledBoxRatio();
                this.m_boxRatio = this.m_display.getBoxRatio();
            }
            this.constructAxes();
            if (this.m_display == null || !this.m_display.containsGeometry(this)) {
                return true;
            }
            boolean bl = this.m_display.isEnabledRepaint();
            if (!bl) {
                for (int i = 0; i < this.m_numAxis; ++i) {
                    this.m_axis[i].update(this.m_axis[i]);
                }
            } else {
                this.m_display.setEnabledRepaint(false);
                for (int i = 0; i < this.m_numAxis; ++i) {
                    this.m_axis[i].update(this.m_axis[i]);
                }
                this.m_display.setEnabledRepaint(bl);
            }
            return super.update(this);
        }
        if (object == this.m_majorHashUnits || object == this.m_minorHashUnits) {
            this.setFixedHashings(this.m_majorHashUnits.getValue(), this.m_minorHashUnits.getValue());
            return this.update(this);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            this.setPartitionedHashing(this.m_numMajorHashings.getValue(), this.m_numMinorHashings.getValue());
            return this.update(this);
        }
        if (object == this.m_axesColor) {
            for (int i = 0; i < this.m_numAxis; ++i) {
                this.m_axis[i].setGlobalPolygonColor(this.m_axesColor.getColor());
                this.m_axis[i].update(this.m_axis[i]);
            }
            return true;
        }
        if (object == this.m_axesSize) {
            for (int i = 0; i < this.m_numAxis; ++i) {
                this.m_axis[i].setGlobalPolygonSize(this.m_axesSize.getValue());
                this.m_axis[i].update(this.m_axis[i]);
            }
            return true;
        }
        if (object == this.m_bndBoxColor) {
            this.m_display.setBndBoxColor(this.m_bndBoxColor.getColor());
            this.m_display.update(this.m_display);
            return true;
        }
        for (int i = 0; i < this.m_numAxis; ++i) {
            if (object == this.m_axis[i]) {
                return true;
            }
            if (object == this.m_bndMin[i]) {
                double d = this.m_bndMin[i].getValue();
                this.m_bndbox[0].setEntry(i, d);
                if (d > this.m_bndMax[i].getValue()) {
                    this.m_bndbox[1].setEntry(i, d);
                    this.m_bndMax[i].setValue(d);
                }
            } else {
                if (object != this.m_bndMax[i]) continue;
                double d = this.m_bndMax[i].getValue();
                this.m_bndbox[1].setEntry(i, d);
                if (d < this.m_bndMin[i].getValue()) {
                    this.m_bndbox[0].setEntry(i, d);
                    this.m_bndMin[i].setValue(d);
                }
            }
            switch (this.m_mode) {
                case 3: 
                case 6: {
                    this.m_bndMax[2].setValue(this.m_bndMin[2].getValue());
                    this.m_bndbox[1].setEntry(2, this.m_bndMin[2].getValue());
                    break;
                }
                case 4: 
                case 7: {
                    this.m_bndMax[0].setValue(this.m_bndMin[0].getValue());
                    this.m_bndbox[1].setEntry(0, this.m_bndMin[0].getValue());
                    break;
                }
                case 5: 
                case 8: {
                    this.m_bndMax[1].setValue(this.m_bndMin[1].getValue());
                    this.m_bndbox[1].setEntry(1, this.m_bndMin[1].getValue());
                }
            }
            if (this.m_bAutoHashing && !this.m_bAutoBounds) {
                this.configure(null, null);
            }
            return this.update(this);
        }
        return super.update(object);
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
        if (this.m_display != null) {
            this.m_bEnableBoxRatio = this.m_display.isEnabledBoxRatio();
            this.m_boxRatio = this.m_display.getBoxRatio();
            this.m_bndBoxColor.setColor(this.m_display.getBndBoxColor());
        }
    }

    public void setAxesColor(Color color) {
        if (this.m_axesColor == null) {
            return;
        }
        this.m_axesColor.setColor(color);
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setGlobalPolygonColor(color);
        }
    }

    public void setAxesSize(double d) {
        if (this.m_axesSize == null) {
            return;
        }
        this.m_axesSize.setValue(d);
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setGlobalPolygonSize(d);
        }
    }

    public boolean isShowing() {
        if (this.m_display == null) {
            return false;
        }
        return this.m_display.isShowingAxes();
    }

    public void setShowing(boolean bl) {
        if (bl == this.isShowing()) {
            return;
        }
        if (this.m_display != null) {
            this.m_display.showAxes(bl);
        }
    }

    public int getNumRulers() {
        return this.m_numAxis;
    }

    public void setNumRulers(int n) {
        this.m_numAxis = n;
        this.m_numAxis = 3;
    }

    public boolean[] getHashingFlags() {
        return this.m_showHashingFlags;
    }

    public void setHashingsFlags(boolean[] blArray) {
        if (blArray == null || blArray.length < 6) {
            PsDebug.warning("flags array to small");
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.m_showHashingFlags[i] = blArray[i];
        }
        this.m_bEnabledGridXY = this.isShowingXYGrid();
        this.m_bEnabledGridYZ = this.isShowingYZGrid();
        this.m_bEnabledGridZX = this.isShowingZXGrid();
    }

    public boolean isShowingXYGrid() {
        return this.m_showHashingFlags[0] && this.m_showHashingFlags[3];
    }

    public void showXYGrid(boolean bl) {
        this.m_bEnabledGridXY = bl;
        this.m_showHashingFlags[0] = bl;
        this.m_showHashingFlags[3] = bl;
    }

    private void showXYGridTemp(boolean bl) {
        this.m_showHashingFlags[0] = bl;
        this.m_showHashingFlags[3] = bl;
    }

    public boolean isShowingYZGrid() {
        return this.m_showHashingFlags[2] && this.m_showHashingFlags[5];
    }

    public void showYZGrid(boolean bl) {
        this.m_bEnabledGridYZ = bl;
        this.m_showHashingFlags[2] = bl;
        this.m_showHashingFlags[5] = bl;
    }

    private void showYZGridTemp(boolean bl) {
        this.m_showHashingFlags[2] = bl;
        this.m_showHashingFlags[5] = bl;
    }

    public boolean isShowingZXGrid() {
        return this.m_showHashingFlags[4] && this.m_showHashingFlags[1];
    }

    public void showZXGrid(boolean bl) {
        this.m_bEnabledGridZX = bl;
        this.m_showHashingFlags[4] = bl;
        this.m_showHashingFlags[1] = bl;
    }

    private void showZXGridTemp(boolean bl) {
        this.m_showHashingFlags[4] = bl;
        this.m_showHashingFlags[1] = bl;
    }

    public boolean isShowingFixedMode() {
        return this.m_hashMode == 0;
    }

    public void showFixedMode(boolean bl) {
        int n = bl ? 0 : 1;
        this.setHashMode(n);
    }

    public int getHashMode() {
        return this.m_hashMode;
    }

    public void setHashMode(int n) {
        this.m_hashMode = n;
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setHashMode(n);
        }
    }

    public boolean isShowingMajorHashings() {
        return this.m_bShowAllMajors;
    }

    public void showMajorHashings(boolean bl) {
        this.m_bShowAllMajors = bl;
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].showMajorHashings(bl);
        }
    }

    public boolean isShowingMinorHashings() {
        return this.m_bShowAllMinors;
    }

    public void showMinorHashings(boolean bl) {
        this.m_bShowAllMinors = bl;
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].showMinorHashings(bl);
        }
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean bl) {
        this.m_bShowLabels = bl;
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].showLabels(bl);
        }
    }

    public void setLabelColors(Color color) {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setLabelColor(0, color);
        }
    }

    public void setLabelStyles(int n) {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setLabelStyle(0, n);
        }
    }

    public void setLabelSize(int n) {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setLabelSize(0, n);
        }
    }

    public void showTitles(boolean bl) {
        this.showNames(bl);
    }

    public String[] getTitles() {
        return this.getNames();
    }

    public void setTitles(String[] stringArray) {
        this.setNames(stringArray);
    }

    public String[] getLabels() {
        return this.getNames();
    }

    public void setLabels(String[] stringArray) {
        this.setNames(stringArray);
    }

    public boolean isShowingNames() {
        return this.m_bShowRulerNames;
    }

    public void showNames(boolean bl) {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].showRulerName(bl);
        }
        this.m_bShowRulerNames = bl;
    }

    public String[] getNames() {
        String[] stringArray = new String[this.m_numAxis];
        for (int i = 0; i < this.m_numAxis; ++i) {
            stringArray[i] = this.m_axis[i].getRulerName();
        }
        return stringArray;
    }

    public void setNames(String[] stringArray) {
        if (stringArray == null) {
            PsDebug.warning("missing array of axis names.");
            return;
        }
        if (stringArray.length < this.m_numAxis) {
            // empty if block
        }
        int n = Math.min(this.m_numAxis, stringArray.length);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            this.m_axis[i].setRulerName(stringArray[i]);
        }
    }

    public void setNameAlignments(int[] nArray, int[] nArray2, int[] nArray3) {
        this.m_axis[0].setNameAlignment(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.m_axis[1].setNameAlignment(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        if (this.m_numAxis > 2) {
            this.m_axis[2].setNameAlignment(nArray3[0], nArray3[1], nArray3[2], nArray3[3]);
        }
    }

    public void setFixedHashings(double d, double d2) {
        if (!this.m_bEnableBoxRatio) {
            for (int i = 0; i < this.m_numAxis; ++i) {
                this.m_axis[i].setFixedHashing(d, d2);
            }
        }
        if (d >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(Math.min(d / 10.0, 0.1), 2.0 * d);
        }
        if (d2 >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(Math.min(d2 / 10.0, 0.01), 2.0 * d);
        }
        this.m_majorHashUnits.setValue(d);
        this.m_majorHashUnits.setLineIncr(d / 50.0);
        this.m_majorHashUnits.setPageIncr(d / 10.0);
        this.m_majorHashUnits.updatePanels(this.m_majorHashUnits);
        this.m_minorHashUnits.setValue(d2);
        this.m_minorHashUnits.setLineIncr(d2 / 50.0);
        this.m_minorHashUnits.setPageIncr(d2 / 10.0);
        this.m_minorHashUnits.updatePanels(this.m_minorHashUnits);
    }

    public void setPartitionedHashing(int n, int n2) {
        if (!this.m_bEnableBoxRatio) {
            for (int i = 0; i < this.m_numAxis; ++i) {
                this.m_axis[i].setPartitionedHashing(n, n2);
            }
        }
        this.m_numMajorHashings.setValue(n);
        this.m_numMinorHashings.setValue(n2);
    }

    public boolean isEnabledAutoHashing() {
        return this.m_bAutoHashing;
    }

    public void setEnabledAutoHashing(boolean bl) {
        if (this.m_bAutoHashing == bl) {
            return;
        }
        this.m_bAutoHashing = bl;
        this.m_majorHashUnits.setEnabled(!bl);
        this.m_minorHashUnits.setEnabled(!bl);
        this.m_numMajorHashings.setEnabled(!bl);
        this.m_numMinorHashings.setEnabled(!bl);
        for (int i = 0; i < 3; ++i) {
            this.m_axis[i].m_majorHashUnits.setEnabled(!bl);
            this.m_axis[i].m_minorHashUnits.setEnabled(!bl);
            this.m_axis[i].m_numMajorHashings.setEnabled(!bl);
            this.m_axis[i].m_numMinorHashings.setEnabled(!bl);
        }
    }

    public boolean isEnabledAutoConfigure() {
        return this.isEnabledAutoHashing();
    }

    public void setEnabledAutoConfigure(boolean bl) {
        this.setEnabledAutoHashing(bl);
    }

    public void setAutoConfigure(boolean bl) {
        this.setEnabledAutoHashing(bl);
    }

    public boolean isEnabledAutoLayout() {
        return this.m_bAutoLayout;
    }

    public void setEnabledAutoLayout(boolean bl) {
        this.m_bAutoLayout = bl;
    }

    public boolean isEnabledAutoBounds() {
        return this.m_bAutoBounds;
    }

    public void setEnabledAutoBounds(boolean bl) {
        if (this.m_bAutoBounds == bl) {
            return;
        }
        this.m_bAutoBounds = bl;
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_bndMin[i].setEnabled(!bl);
            this.m_bndMax[i].setEnabled(!bl);
        }
        if (this.m_bAutoBounds) {
            this.setBounds(this.m_bndboxDisp);
        }
        this.constructAxes();
    }

    public int getCoordSystem() {
        return this.m_coordSystem;
    }

    public void setCoordSystem(int n) {
        this.m_coordSystem = n;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        int n2;
        if (this.m_mode == n) {
            return;
        }
        this.m_mode = n;
        if (this.m_bAutoBounds && this.m_bndboxDisp != null) {
            this.setBounds(this.m_bndboxDisp);
        }
        this.m_axis[0].setHashLabel(0, 3, 1, 2);
        this.m_axis[1].setHashLabel(0, 3, 1, 2);
        if (this.m_numAxis > 2) {
            this.m_axis[2].setHashLabel(-5, 0, 2, 1);
        }
        boolean bl = false;
        switch (this.m_mode) {
            case 0: {
                bl = true;
            }
            case 1: 
            case 2: {
                this.m_dimMode = 3;
                break;
            }
            case 3: {
                bl = true;
            }
            case 6: {
                this.m_axis[0].setHashLabel(0, 3, 1, 2);
                this.m_axis[1].setHashLabel(-3, 0, 2, 1);
                break;
            }
            default: {
                this.m_dimMode = 2;
            }
        }
        for (n2 = 0; n2 < this.m_numAxis; ++n2) {
            this.m_bndMin[n2].setEnabled(!this.m_bAutoLayout);
            this.m_bndMax[n2].setEnabled(!this.m_bAutoLayout);
        }
        switch (this.m_mode) {
            case 3: {
                bl = true;
            }
            case 6: {
                this.m_bndMax[2].setEnabled(false);
                break;
            }
            case 4: {
                bl = true;
            }
            case 7: {
                this.m_bndMax[0].setEnabled(false);
                break;
            }
            case 5: {
                bl = true;
            }
            case 8: {
                this.m_bndMax[1].setEnabled(false);
            }
        }
        for (n2 = 0; n2 < this.m_numAxis; ++n2) {
            this.m_axis[n2].m_bHashCentered = bl;
        }
        n2 = this.m_mode == 1 ? 2 : ((this.m_mode == 3 || this.m_mode == 6) && this.m_cameraType == 1 ? 1 : ((this.m_mode == 4 || this.m_mode == 7) && this.m_cameraType == 3 ? 1 : ((this.m_mode == 5 || this.m_mode == 8) && this.m_cameraType == 2 ? 1 : 1)));
        if (this.m_display != null) {
            for (int i = 0; i < this.m_numAxis; ++i) {
                if (!this.m_display.containsGeometry(this.m_axis[i])) continue;
                this.m_display.setDrawingOrder(n2, this.m_axis[i]);
            }
        }
    }

    public PgRuler[] getAxes() {
        return this.m_axis;
    }

    public void configure(PdVector[] pdVectorArray, PdVector pdVector) {
        if (this.m_bAutoBounds) {
            this.setBounds(pdVectorArray);
            if (pdVector != null) {
                this.m_viewVect.copy(pdVector);
            }
        }
        if (!this.m_bAutoHashing) {
            return;
        }
        if (!this.m_bEnableBoxRatio) {
            double d = this.nonZeroMax(this.m_bndbox[1].getEntry(0) - this.m_bndbox[0].getEntry(0), this.m_bndbox[1].getEntry(1) - this.m_bndbox[0].getEntry(1), this.m_bndbox[1].getEntry(2) - this.m_bndbox[0].getEntry(2));
            if (d < 1.0E-7) {
                return;
            }
            double d2 = PgAxes.computeOptimalScale(OPT_HASH_NUMBER, this.m_scale, d);
            if (d2 == this.m_scale && this.m_majorHashUnits.getValue() == this.m_scale && this.m_axis[0].m_majorHashUnits.getValue() == this.m_scale && this.m_axis[1].m_majorHashUnits.getValue() == this.m_scale && this.m_axis[2].m_majorHashUnits.getValue() == this.m_scale && this.m_axis[0].m_minorHashUnits.getValue() == this.m_scale / OPT_HASH_RATIO && this.m_axis[1].m_minorHashUnits.getValue() == this.m_scale / OPT_HASH_RATIO && this.m_axis[2].m_minorHashUnits.getValue() == this.m_scale / OPT_HASH_RATIO) {
                return;
            }
            this.m_scale = d2;
            this.m_majorHashUnits.setBounds(0.0, 10.0 * this.m_scale);
            this.m_minorHashUnits.setBounds(0.0, 2.0 * this.m_scale);
            this.setFixedHashings(this.m_scale, this.m_scale / OPT_HASH_RATIO);
        } else {
            for (int i = 0; i < this.m_numAxis; ++i) {
                double d;
                double d3;
                double d4 = Math.abs(this.m_bndbox[1].getEntry(i) - this.m_bndbox[0].getEntry(i));
                if (d4 < 1.0E-7 || (d3 = PgAxes.computeOptimalScale(OPT_HASH_NUMBER, d = this.m_axis[i].m_majorHashUnits.getValue(), d4)) == d) continue;
                this.m_axis[i].setFixedHashing(d3, d3 / OPT_HASH_RATIO);
                if (i != 0) continue;
                this.m_majorHashUnits.setBounds(0.0, 10.0 * d3);
                this.m_minorHashUnits.setBounds(0.0, 2.0 * d3);
                this.setFixedHashings(d3, d3 / OPT_HASH_RATIO);
            }
        }
    }

    protected static double computeOptimalScale(int n, double d, double d2) {
        int n2 = n;
        d = d2 / (double)(n2 - 1);
        boolean bl = false;
        if (d < 0.75) {
            bl = true;
            d = 1.0 / d;
        }
        boolean bl2 = false;
        double d3 = 1.0;
        while (!bl2) {
            if (0.75 * d3 < d && d <= 1.5 * d3) {
                d = d3;
                bl2 = true;
                continue;
            }
            if (1.5 * d3 < d && d <= 3.0 * d3) {
                d = 2.0 * d3;
                bl2 = true;
                continue;
            }
            if (3.0 * d3 < d && d <= 4.5 * d3) {
                d = 4.0 * d3;
                bl2 = true;
                continue;
            }
            if (4.5 * d3 < d && d <= 7.5 * d3) {
                d = 5.0 * d3;
                bl2 = true;
                continue;
            }
            if (!((d3 *= 10.0) > 1000000.0)) continue;
            PsDebug.warning("cannot find interval of suggested scale.");
            return 1.0;
        }
        if (bl) {
            d = 1.0 / d;
        }
        return d;
    }

    public void setCameraType(int n) {
        if (this.m_cameraType == n) {
            return;
        }
        this.m_cameraType = n;
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 4;
            }
        }
        this.setMode(n2);
    }

    protected void constructAxes() {
        int n;
        if (this.m_bEnableBoxRatio) {
            for (n = 0; n < this.m_numAxis; ++n) {
                this.m_axis[n].m_ratio = this.m_boxRatio.getEntry(n);
            }
        } else {
            for (n = 0; n < this.m_numAxis; ++n) {
                this.m_axis[n].m_ratio = 1.0;
            }
        }
        for (n = 0; n < this.m_numAxis; ++n) {
            this.m_axis[n].m_bHasGrid = false;
        }
        if (this.m_bAutoLayout) {
            switch (this.m_mode) {
                case 0: {
                    this.setEnabledAxes(true, true, true);
                    break;
                }
                case 1: {
                    this.setEnabledAxes(true, true, true);
                    break;
                }
                case 2: {
                    this.setEnabledAxes(true, true, true);
                    break;
                }
                case 3: {
                    this.setEnabledAxes(true, true, false);
                    break;
                }
                case 4: {
                    this.setEnabledAxes(false, true, true);
                    break;
                }
                case 5: {
                    this.setEnabledAxes(true, false, true);
                    break;
                }
                case 6: {
                    this.setEnabledAxes(true, true, false);
                    break;
                }
                case 7: {
                    this.setEnabledAxes(false, true, true);
                    break;
                }
                case 8: {
                    this.setEnabledAxes(true, false, true);
                    break;
                }
                default: {
                    this.setEnabledAxes(true, true, true);
                    break;
                }
            }
        } else {
            for (n = 0; n < this.m_numAxis; ++n) {
                this.m_axis[n].setVisible(this.m_axis[n].isVisible() && this.isVisible());
            }
        }
        for (n = 0; n < this.m_numAxis; ++n) {
            this.m_axis[n].setHashOffsetInNormalDir(0.0, 0.0, 0.0);
            this.m_axis[n].setHashOffsetInUpDir(0.0, 0.0, 0.0);
        }
        this.m_axis[0].showHashingsInUpDir(this.m_showHashingFlags[1]);
        this.m_axis[0].showHashingsInNormalDir(this.m_showHashingFlags[0]);
        this.m_axis[1].showHashingsInUpDir(this.m_showHashingFlags[3]);
        this.m_axis[1].showHashingsInNormalDir(this.m_showHashingFlags[2]);
        if (this.m_numAxis > 2) {
            this.m_axis[2].showHashingsInUpDir(this.m_showHashingFlags[5]);
            this.m_axis[2].showHashingsInNormalDir(this.m_showHashingFlags[4]);
        }
        switch (this.m_mode) {
            case 0: {
                this.modeCentral();
                break;
            }
            case 1: {
                this.modeCorner();
                break;
            }
            case 2: {
                this.modeBoundingBox();
                break;
            }
            case 3: {
                this.modeCentral();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN_X, this.STD_ALIGN_Y, this.STD_ALIGN);
                break;
            }
            case 4: {
                this.modeCentral();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN, this.STD_ALIGN, this.STD_ALIGN_Z);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                break;
            }
            case 5: {
                this.modeCentral();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN, this.STD_ALIGN, this.STD_ALIGN_Z);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                break;
            }
            case 6: {
                this.modeCorner();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN_X, this.STD_ALIGN_Y, this.STD_ALIGN);
                break;
            }
            case 7: {
                this.modeCorner();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN, this.STD_ALIGN, this.STD_ALIGN_Z);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                break;
            }
            case 8: {
                this.modeCorner();
                if (!this.m_bAutoLayout) break;
                this.setNameAlignments(this.STD_ALIGN, this.STD_ALIGN, this.STD_ALIGN_Z);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                break;
            }
            default: {
                this.modeCentral();
            }
        }
    }

    protected void modeCentral() {
        double d;
        int n;
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        for (n = 0; n < 3; ++n) {
            double d2 = this.m_bndbox[0].getEntry(n);
            d = this.m_bndbox[1].getEntry(n);
            if (d2 < 0.0 && 0.0 < d) continue;
            if (d < 0.0) {
                pdVector.setEntry(n, d);
                continue;
            }
            if (!(d2 > 0.0)) continue;
            pdVector.setEntry(n, d2);
        }
        if (this.m_mode == 3) {
            pdVector.setEntry(2, this.m_bndbox[0].getEntry(2));
        } else if (this.m_mode == 4) {
            pdVector.setEntry(0, this.m_bndbox[0].getEntry(0));
        } else if (this.m_mode == 5) {
            pdVector.setEntry(1, this.m_bndbox[0].getEntry(1));
        } else if (this.m_mode == 6) {
            pdVector.setEntry(2, this.m_bndbox[0].getEntry(2));
        } else if (this.m_mode == 7) {
            pdVector.setEntry(0, this.m_bndbox[0].getEntry(0));
        } else if (this.m_mode == 8) {
            pdVector.setEntry(1, this.m_bndbox[0].getEntry(1));
        }
        for (n = 0; n < this.m_numAxis; ++n) {
            this.m_axis[n].setOrigin(pdVector);
            this.m_axis[n].m_origin.setEntry(n, 0.0);
            this.m_axis[n].setMinMax(this.m_bndbox[0].getEntry(n), this.m_bndbox[1].getEntry(n));
        }
        PgRuler pgRuler = this.m_axis[0];
        PgRuler pgRuler2 = this.m_axis[1];
        PgRuler pgRuler3 = null;
        if (this.m_numAxis > 2) {
            pgRuler3 = this.m_axis[2];
        }
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            pgRuler.m_bHasGrid = true;
            pgRuler2.m_bHasGrid = true;
            pgRuler.setMinorHashSize(pgRuler2.getMaxParameter() - pdVector.getEntry(1), pgRuler2.getMinParameter() - pdVector.getEntry(1), 0);
            pgRuler.setMajorHashSize(pgRuler2.getMaxParameter() - pdVector.getEntry(1), pgRuler2.getMinParameter() - pdVector.getEntry(1), 0);
            pgRuler2.setMinorHashSize(pgRuler.getMaxParameter() - pdVector.getEntry(0), pgRuler.getMinParameter() - pdVector.getEntry(0), 1);
            pgRuler2.setMajorHashSize(pgRuler.getMaxParameter() - pdVector.getEntry(0), pgRuler.getMinParameter() - pdVector.getEntry(0), 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            pgRuler2.m_bHasGrid = true;
            pgRuler3.m_bHasGrid = true;
            pgRuler2.setMinorHashSize(pgRuler3.getMaxParameter() - pdVector.getEntry(2), pgRuler3.getMinParameter() - pdVector.getEntry(2), 0);
            pgRuler2.setMajorHashSize(pgRuler3.getMaxParameter() - pdVector.getEntry(2), pgRuler3.getMinParameter() - pdVector.getEntry(2), 0);
            pgRuler3.setMinorHashSize(pgRuler2.getMaxParameter() - pdVector.getEntry(1), pgRuler2.getMinParameter() - pdVector.getEntry(1), 1);
            pgRuler3.setMajorHashSize(pgRuler2.getMaxParameter() - pdVector.getEntry(1), pgRuler2.getMinParameter() - pdVector.getEntry(1), 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            pgRuler3.m_bHasGrid = true;
            pgRuler.m_bHasGrid = true;
            pgRuler3.setMinorHashSize(pgRuler.getMaxParameter() - pdVector.getEntry(0), pgRuler.getMinParameter() - pdVector.getEntry(0), 0);
            pgRuler3.setMajorHashSize(pgRuler.getMaxParameter() - pdVector.getEntry(0), pgRuler.getMinParameter() - pdVector.getEntry(0), 0);
            pgRuler.setMinorHashSize(pgRuler3.getMaxParameter() - pdVector.getEntry(2), pgRuler3.getMinParameter() - pdVector.getEntry(2), 1);
            pgRuler.setMajorHashSize(pgRuler3.getMaxParameter() - pdVector.getEntry(2), pgRuler3.getMinParameter() - pdVector.getEntry(2), 1);
        }
        d = this.m_viewVect.getEntry(0);
        double d3 = this.m_viewVect.getEntry(1);
        double d4 = this.m_viewVect.getEntry(2);
        if (d <= 0.0 && d3 <= 0.0) {
            int[] nArray = new int[]{1, 2, -7, 4};
            int[] nArray2 = new int[]{1, 0, 7, 4};
            int[] nArray3 = new int[]{1, 0, -4, -7};
            if (d4 > 0.0) {
                nArray3[0] = 0;
                nArray3[3] = 14;
            }
            this.setNameAlignments(nArray, nArray2, nArray3);
        } else if (d <= 0.0 && d3 > 0.0) {
            int[] nArray = new int[]{1, 0, 7, 4};
            int[] nArray4 = new int[]{0, 2, -7, 4};
            int[] nArray5 = new int[]{1, 0, -4, -7};
            if (d4 > 0.0) {
                nArray5[0] = 0;
                nArray5[3] = 14;
            }
            this.setNameAlignments(nArray, nArray4, nArray5);
        } else if (d > 0.0 && d3 <= 0.0) {
            int[] nArray = new int[]{0, 0, 7, 4};
            int[] nArray6 = new int[]{1, 2, -7, 4};
            int[] nArray7 = new int[]{1, 0, -4, -7};
            if (d4 > 0.0) {
                nArray7[0] = 0;
                nArray7[3] = 14;
            }
            this.setNameAlignments(nArray, nArray6, nArray7);
        } else {
            int[] nArray = new int[]{0, 2, -7, 4};
            int[] nArray8 = new int[]{0, 0, 7, 4};
            int[] nArray9 = new int[]{1, 0, -4, -7};
            if (d4 > 0.0) {
                nArray9[0] = 0;
                nArray9[3] = 14;
            }
            this.setNameAlignments(nArray, nArray8, nArray9);
        }
        this.setHashingsForUninvolvedAxes(0, 1, 0);
    }

    protected void modeCorner() {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setMinMax(this.m_bndbox[0].getEntry(i), this.m_bndbox[1].getEntry(i));
        }
        PgRuler pgRuler = this.m_axis[0];
        PgRuler pgRuler2 = this.m_axis[1];
        PgRuler pgRuler3 = null;
        if (this.m_numAxis > 2) {
            pgRuler3 = this.m_axis[2];
        }
        double d = pgRuler.getMaxParameter() - pgRuler.getMinParameter();
        double d2 = pgRuler2.getMaxParameter() - pgRuler2.getMinParameter();
        double d3 = 0.0;
        if (this.m_numAxis > 2) {
            d3 = pgRuler3.getMaxParameter() - pgRuler3.getMinParameter();
        }
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            pgRuler.setMinorHashSize(0.0, d2, 0);
            pgRuler2.setMinorHashSize(0.0, d, 1);
            pgRuler.setMajorHashSize(0.0, d2, 0);
            pgRuler2.setMajorHashSize(0.0, d, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            pgRuler2.setMinorHashSize(0.0, d3, 0);
            pgRuler3.setMinorHashSize(0.0, d2, 1);
            pgRuler2.setMajorHashSize(0.0, d3, 0);
            pgRuler3.setMajorHashSize(0.0, d2, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            pgRuler3.setMinorHashSize(0.0, d, 0);
            pgRuler.setMinorHashSize(0.0, d3, 1);
            pgRuler3.setMajorHashSize(0.0, d, 0);
            pgRuler.setMajorHashSize(0.0, d3, 1);
        }
        double d4 = this.m_viewVect.getEntry(0);
        double d5 = this.m_viewVect.getEntry(1);
        if (d4 <= 0.0 && d5 <= 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[0].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[0].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[0].getEntry(0), this.m_bndbox[0].getEntry(1), 0.0);
            int[] nArray = new int[]{1, 1, -7, 4};
            int[] nArray2 = new int[]{1, 0, 7, 4};
            int[] nArray3 = new int[]{1, 0, -4, -7};
            this.setNameAlignments(nArray, nArray2, nArray3);
            this.setHashingsForUninvolvedAxes(0, 1, 1);
        } else if (d4 <= 0.0 && d5 > 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[1].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[0].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[0].getEntry(0), this.m_bndbox[1].getEntry(1), 0.0);
            int[] nArray = new int[]{1, 0, 7, 4};
            int[] nArray4 = new int[]{0, 1, -7, 4};
            int[] nArray5 = new int[]{1, 0, -4, -7};
            this.setNameAlignments(nArray, nArray4, nArray5);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                pgRuler3.setHashOffsetInUpDir(0.0, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, 0);
        } else if (d4 > 0.0 && d5 <= 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[0].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[1].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[1].getEntry(0), this.m_bndbox[0].getEntry(1), 0.0);
            int[] nArray = new int[]{0, 0, 7, 4};
            int[] nArray6 = new int[]{1, 1, -7, 4};
            int[] nArray7 = new int[]{1, 0, -4, -7};
            this.setNameAlignments(nArray, nArray6, nArray7);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler2.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                pgRuler3.setHashOffsetInNormalDir(-d, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, -1);
        } else {
            pgRuler.setOrigin(0.0, this.m_bndbox[1].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[1].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[1].getEntry(0), this.m_bndbox[1].getEntry(1), 0.0);
            int[] nArray = new int[]{0, 1, -7, 4};
            int[] nArray8 = new int[]{0, 0, 7, 4};
            int[] nArray9 = new int[]{1, 0, -4, -7};
            this.setNameAlignments(nArray, nArray8, nArray9);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler.setHashOffsetInNormalDir(0.0, -d2, 0.0);
                pgRuler2.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                pgRuler3.setHashOffsetInNormalDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                pgRuler3.setHashOffsetInUpDir(0.0, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, -2, -2);
        }
    }

    protected void modeBoundingBox() {
        for (int i = 0; i < this.m_numAxis; ++i) {
            this.m_axis[i].setMinMax(this.m_bndbox[0].getEntry(i), this.m_bndbox[1].getEntry(i));
        }
        PgRuler pgRuler = this.m_axis[0];
        PgRuler pgRuler2 = this.m_axis[1];
        PgRuler pgRuler3 = null;
        if (this.m_numAxis > 2) {
            pgRuler3 = this.m_axis[2];
        }
        double d = pgRuler.getMaxParameter() - pgRuler.getMinParameter();
        double d2 = pgRuler2.getMaxParameter() - pgRuler2.getMinParameter();
        double d3 = 0.0;
        if (this.m_numAxis > 2) {
            d3 = pgRuler3.getMaxParameter() - pgRuler3.getMinParameter();
        }
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            pgRuler.setMinorHashSize(0.0, d2, 0);
            pgRuler2.setMinorHashSize(0.0, d, 1);
            pgRuler.setMajorHashSize(0.0, d2, 0);
            pgRuler2.setMajorHashSize(0.0, d, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            pgRuler2.setMinorHashSize(0.0, d3, 0);
            pgRuler3.setMinorHashSize(0.0, d2, 1);
            pgRuler2.setMajorHashSize(0.0, d3, 0);
            pgRuler3.setMajorHashSize(0.0, d2, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            pgRuler3.setMinorHashSize(0.0, d, 0);
            pgRuler.setMinorHashSize(0.0, d3, 1);
            pgRuler3.setMajorHashSize(0.0, d, 0);
            pgRuler.setMajorHashSize(0.0, d3, 1);
        }
        int n = 2 * (int)Math.ceil(5.0);
        double d4 = this.m_viewVect.getEntry(0);
        double d5 = this.m_viewVect.getEntry(1);
        if (d4 <= 0.0 && d5 <= 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[1].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[1].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[1].getEntry(0), this.m_bndbox[0].getEntry(1), 0.0);
            int[] nArray = new int[]{2, 0, n, n};
            int[] nArray2 = new int[]{2, 2, -n, n};
            int[] nArray3 = new int[]{2, 2, -n, n};
            this.setNameAlignments(nArray, nArray2, nArray3);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler.setHashOffsetInNormalDir(0.0, -d2, 0.0);
                pgRuler2.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                pgRuler3.setHashOffsetInNormalDir(-d, d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, -2, 1);
        } else if (d4 <= 0.0 && d5 > 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[0].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[1].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[0].getEntry(0), this.m_bndbox[0].getEntry(1), 0.0);
            int[] nArray = new int[]{2, 2, -n, n};
            int[] nArray4 = new int[]{2, 0, n, n};
            int[] nArray5 = new int[]{2, 2, -n, n};
            this.setNameAlignments(nArray, nArray4, nArray5);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler2.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                pgRuler3.setHashOffsetInUpDir(d, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, 0);
        } else if (d4 > 0.0 && d5 <= 0.0) {
            pgRuler.setOrigin(0.0, this.m_bndbox[1].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[0].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[1].getEntry(0), this.m_bndbox[1].getEntry(1), 0.0);
            int[] nArray = new int[]{2, 2, -n, n};
            int[] nArray6 = new int[]{2, 0, n, n};
            int[] nArray7 = new int[]{2, 2, -n, n};
            this.setNameAlignments(nArray, nArray6, nArray7);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                pgRuler.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                pgRuler3.setHashOffsetInNormalDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                pgRuler3.setHashOffsetInUpDir(-d, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, -1);
        } else {
            pgRuler.setOrigin(0.0, this.m_bndbox[0].getEntry(1), this.m_bndbox[0].getEntry(2));
            pgRuler2.setOrigin(this.m_bndbox[0].getEntry(0), 0.0, this.m_bndbox[0].getEntry(2));
            pgRuler3.setOrigin(this.m_bndbox[0].getEntry(0), this.m_bndbox[1].getEntry(1), 0.0);
            int[] nArray = new int[]{2, 0, n, n};
            int[] nArray8 = new int[]{2, 2, -n, n};
            int[] nArray9 = new int[]{2, 2, -n, n};
            this.setNameAlignments(nArray, nArray8, nArray9);
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                pgRuler3.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                pgRuler3.setHashOffsetInUpDir(0.0, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, 1, -2);
        }
    }

    protected void setHashingsForUninvolvedAxes(int n, int n2, int n3) {
        double d;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = this.m_bndbox[1].getEntry(0) - this.m_bndbox[0].getEntry(0);
        double d6 = this.m_bndbox[1].getEntry(1) - this.m_bndbox[0].getEntry(1);
        if (this.m_numAxis > 2) {
            d4 = this.m_bndbox[1].getEntry(2) - this.m_bndbox[0].getEntry(2);
        }
        if (this.m_bEnableBoxRatio) {
            if (Math.abs(this.m_boxRatio.getEntry(0)) > 1.0E-10) {
                d5 *= this.m_boxRatio.getEntry(0);
            }
            if (Math.abs(this.m_boxRatio.getEntry(1)) > 1.0E-10) {
                d6 *= this.m_boxRatio.getEntry(1);
            }
            if (Math.abs(this.m_boxRatio.getEntry(2)) > 1.0E-10) {
                d4 *= this.m_boxRatio.getEntry(2);
            }
        }
        double d7 = (d5 + d6 + d4) / 2.0;
        if (this.m_dimMode < 3) {
            d3 = 0.03 * d7;
            d2 = 0.02 * d7;
        } else {
            d3 = 0.03 * d7;
            d2 = 0.02 * d7;
        }
        PgRuler pgRuler = this.m_axis[0];
        PgRuler pgRuler2 = this.m_axis[1];
        PgRuler pgRuler3 = null;
        if (this.m_numAxis > 2) {
            pgRuler3 = this.m_axis[2];
        }
        if (!this.m_showHashingFlags[1] && !this.m_showHashingFlags[0]) {
            d = 1.0;
            if (this.m_bEnableBoxRatio) {
                if ((n == 0 || n == -1) && Math.abs(this.m_boxRatio.getEntry(1)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(1);
                }
                if ((n == 1 || n == -2) && Math.abs(this.m_boxRatio.getEntry(2)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(2);
                }
            }
            switch (n) {
                case 0: {
                    pgRuler.setMajorHashSize(0.0, d3 / d, 0);
                    pgRuler.setMinorHashSize(0.0, d2 / d, 0);
                    pgRuler.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    pgRuler.setMajorHashSize(0.0, -d3 / d, 0);
                    pgRuler.setMinorHashSize(0.0, -d2 / d, 0);
                    pgRuler.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    pgRuler.setMajorHashSize(0.0, d3 / d, 1);
                    pgRuler.setMinorHashSize(0.0, d2 / d, 1);
                    pgRuler.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    pgRuler.setMajorHashSize(0.0, -d3 / d, 1);
                    pgRuler.setMinorHashSize(0.0, -d2 / d, 1);
                    pgRuler.showHashingsInUpDir(true);
                }
            }
        }
        if (!this.m_showHashingFlags[3] && !this.m_showHashingFlags[2]) {
            d = 1.0;
            if (this.m_bEnableBoxRatio) {
                if ((n2 == 0 || n2 == -1) && Math.abs(this.m_boxRatio.getEntry(2)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(2);
                }
                if ((n2 == 1 || n2 == -2) && Math.abs(this.m_boxRatio.getEntry(0)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(0);
                }
            }
            switch (n2) {
                case 0: {
                    pgRuler2.setMajorHashSize(0.0, d3 / d, 0);
                    pgRuler2.setMinorHashSize(0.0, d2 / d, 0);
                    pgRuler2.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    pgRuler2.setMajorHashSize(0.0, -d3 / d, 0);
                    pgRuler2.setMinorHashSize(0.0, -d2 / d, 0);
                    pgRuler2.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    pgRuler2.setMajorHashSize(0.0, d3 / d, 1);
                    pgRuler2.setMinorHashSize(0.0, d2 / d, 1);
                    pgRuler2.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    pgRuler2.setMajorHashSize(0.0, -d3 / d, 1);
                    pgRuler2.setMinorHashSize(0.0, -d2 / d, 1);
                    pgRuler2.showHashingsInUpDir(true);
                }
            }
        }
        if (this.m_numAxis > 2 && !this.m_showHashingFlags[5] && !this.m_showHashingFlags[4]) {
            d = 1.0;
            if (this.m_bEnableBoxRatio) {
                if ((n3 == 0 || n3 == -1) && Math.abs(this.m_boxRatio.getEntry(0)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(0);
                }
                if ((n3 == 1 || n3 == -2) && Math.abs(this.m_boxRatio.getEntry(1)) > 1.0E-10) {
                    d = this.m_boxRatio.getEntry(1);
                }
            }
            switch (n3) {
                case 0: {
                    pgRuler3.setMajorHashSize(0.0, d3 / d, 0);
                    pgRuler3.setMinorHashSize(0.0, d2 / d, 0);
                    pgRuler3.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    pgRuler3.setMajorHashSize(0.0, -d3 / d, 0);
                    pgRuler3.setMinorHashSize(0.0, -d2 / d, 0);
                    pgRuler3.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    pgRuler3.setMajorHashSize(0.0, d3 / d, 1);
                    pgRuler3.setMinorHashSize(0.0, d2 / d, 1);
                    pgRuler3.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    pgRuler3.setMajorHashSize(0.0, -d3 / d, 1);
                    pgRuler3.setMinorHashSize(0.0, -d2 / d, 1);
                    pgRuler3.showHashingsInUpDir(true);
                }
            }
        }
    }

    protected void setEnabledAxes(boolean bl, boolean bl2, boolean bl3) {
        switch (this.m_cameraType) {
            case 1: {
                bl3 = false;
                break;
            }
            case 2: {
                bl2 = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                if (!this.m_bAutoBounds) break;
                if (bl && 1.0 - Math.abs(this.m_viewVect.getEntry(0)) < 0.002) {
                    bl = false;
                    break;
                }
                if (bl2 && 1.0 - Math.abs(this.m_viewVect.getEntry(1)) < 0.002) {
                    bl2 = false;
                    break;
                }
                if (!bl3 || !(1.0 - Math.abs(this.m_viewVect.getEntry(2)) < 0.002)) break;
                bl3 = false;
            }
        }
        if (this.m_numAxis > 0) {
            this.m_bEnabledX = this.m_axis[0].isVisible();
        }
        if (this.m_numAxis > 1) {
            this.m_bEnabledY = this.m_axis[1].isVisible();
        }
        if (this.m_numAxis > 2) {
            this.m_bEnabledZ = this.m_axis[2].isVisible();
        }
        if (!this.isVisible()) {
            bl = false;
            bl2 = false;
            bl3 = false;
        }
        if (this.m_bEnabledX == bl && this.m_bEnabledY == bl2 && this.m_bEnabledZ == bl3) {
            return;
        }
        this.showXYGridTemp(bl && bl2 && this.m_bEnabledGridXY);
        this.showYZGridTemp(bl2 && bl3 && this.m_bEnabledGridYZ);
        this.showZXGridTemp(bl3 && bl && this.m_bEnabledGridZX);
        if (this.m_bEnabledX != bl || this.m_axis[0].isVisible() != bl) {
            this.m_axis[0].setVisible(bl);
            this.m_bEnabledX = bl;
        }
        if (this.m_bEnabledY != bl2 || this.m_axis[1].isVisible() != bl2) {
            this.m_axis[1].setVisible(bl2);
            this.m_bEnabledY = bl2;
        }
        if (this.m_numAxis > 2 && (this.m_bEnabledZ != bl3 || this.m_axis[2].isVisible() != bl3)) {
            this.m_axis[2].setVisible(bl3);
            this.m_bEnabledZ = bl3;
        }
    }

    private double nonZeroMax(double d, double d2, double d3) {
        if (this.m_bEnableBoxRatio) {
            d *= this.m_boxRatio.getEntry(0);
            d2 *= this.m_boxRatio.getEntry(1);
            d3 *= this.m_boxRatio.getEntry(2);
        }
        return Math.max(Math.max(d, d2), d3);
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = super.getBounds();
        PdVector.copy(pdVectorArray, 0, this.m_bndbox, 0, 2);
        return pdVectorArray;
    }

    public void setBounds(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            return;
        }
        PdVector.copy(this.m_bndboxDisp, 0, pdVectorArray, 0, 2);
        PdVector.copy(this.m_bndbox, 0, pdVectorArray, 0, 2);
        for (int i = 0; i < this.m_numAxis; ++i) {
            double d = this.m_bndbox[0].getEntry(i);
            double d2 = this.m_bndbox[1].getEntry(i);
            double d3 = d2 - d;
            if (d3 < 1.0E-10) {
                d3 = 1.0;
            }
            double d4 = d3 / 10.0;
            double d5 = d3 / 100.0;
            this.m_bndMin[i].setBounds(d - 5.0 * d3, d2 + 5.0 * d3, d5, d4);
            this.m_bndMin[i].setValue(this.m_bndbox[0].getEntry(i));
            this.m_bndMax[i].setBounds(d - 5.0 * d3, d2 + 5.0 * d3, d5, d4);
            this.m_bndMax[i].setValue(this.m_bndbox[1].getEntry(i));
        }
    }

    public void pickCamera(PvCameraEvent pvCameraEvent) {
        if (!this.m_bAutoLayout) {
            return;
        }
        this.m_viewVect.copy(pvCameraEvent.getViewDir());
        if (this.m_mode != 2 && this.m_mode != 1 && this.m_mode != -1) {
            return;
        }
        this.configure(this.m_bndbox, this.m_viewVect);
        this.update(this);
    }

    public void dragCamera(PvCameraEvent pvCameraEvent) {
        this.pickCamera(pvCameraEvent);
    }
}

