/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import jv.thirdParty.acmeEncoders.GifEncoderHashitem;
import jv.thirdParty.acmeEncoders.GifEncoderOcBlock;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.IntHashtable;

public class GifEncoder
extends ImageEncoder {
    private boolean m_interlace = false;
    private IntHashtable colorHash;
    private int m_width;
    private int m_height;
    private int[][] m_rgbPixels;
    int m_width2;
    int m_height2;
    boolean m_interlace2;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int m_hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private int a_count;
    byte[] accum = new byte[256];

    public GifEncoder(Image image, OutputStream outputStream) {
        super(image, outputStream);
    }

    public GifEncoder(Image image, OutputStream outputStream, boolean bl) {
        super(image, outputStream);
        this.m_interlace = bl;
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        super(imageProducer, outputStream);
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl) {
        super(imageProducer, outputStream);
        this.m_interlace = bl;
    }

    void encodeStart(int n, int n2) throws IOException {
        this.m_width = n;
        this.m_height = n2;
        this.m_rgbPixels = new int[n2][n];
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, i * n6 + n5, this.m_rgbPixels[n2 + i], n, n3);
        }
    }

    private boolean setVariance(GifEncoderOcBlock gifEncoderOcBlock, GifEncoderHashitem[] gifEncoderHashitemArray, int n) {
        int n2 = gifEncoderHashitemArray.length;
        gifEncoderOcBlock.cr = 0.0;
        gifEncoderOcBlock.cg = 0.0;
        gifEncoderOcBlock.cb = 0.0;
        gifEncoderOcBlock.count = 0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            GifEncoderHashitem gifEncoderHashitem = gifEncoderHashitemArray[i];
            if (gifEncoderHashitem.red < gifEncoderOcBlock.pr || gifEncoderHashitem.green < gifEncoderOcBlock.pg || gifEncoderHashitem.blue < gifEncoderOcBlock.pb || gifEncoderHashitem.red > gifEncoderOcBlock.qr || gifEncoderHashitem.green > gifEncoderOcBlock.qg || gifEncoderHashitem.blue > gifEncoderOcBlock.qb) continue;
            gifEncoderHashitem.index = n;
            ++n3;
            gifEncoderOcBlock.cr += (double)gifEncoderHashitem.red;
            gifEncoderOcBlock.cg += (double)gifEncoderHashitem.green;
            gifEncoderOcBlock.cb += (double)gifEncoderHashitem.blue;
            gifEncoderOcBlock.count += gifEncoderHashitem.count;
        }
        if (n3 == 0) {
            return false;
        }
        gifEncoderOcBlock.cr /= (double)n3;
        gifEncoderOcBlock.cg /= (double)n3;
        gifEncoderOcBlock.cb /= (double)n3;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            GifEncoderHashitem gifEncoderHashitem = gifEncoderHashitemArray[i];
            if (gifEncoderHashitem.red < gifEncoderOcBlock.pr || gifEncoderHashitem.green < gifEncoderOcBlock.pg || gifEncoderHashitem.blue < gifEncoderOcBlock.pb || gifEncoderHashitem.red > gifEncoderOcBlock.qr || gifEncoderHashitem.green > gifEncoderOcBlock.qg || gifEncoderHashitem.blue > gifEncoderOcBlock.qb) continue;
            double d2 = (double)gifEncoderHashitem.red - gifEncoderOcBlock.cr;
            double d3 = (double)gifEncoderHashitem.green - gifEncoderOcBlock.cg;
            double d4 = (double)gifEncoderHashitem.blue - gifEncoderOcBlock.cb;
            d += (d2 * d2 + d3 * d3 + d4 * d4) * (double)gifEncoderHashitem.count;
        }
        gifEncoderOcBlock.var = d /= (double)n3;
        return true;
    }

    void encodeDone() throws IOException {
        Object object;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        this.colorHash = new IntHashtable();
        int n5 = 0;
        for (n2 = 0; n2 < this.m_height; ++n2) {
            for (n = 0; n < this.m_width; ++n) {
                GifEncoderHashitem gifEncoderHashitem;
                boolean bl;
                int n6 = this.m_rgbPixels[n2][n];
                boolean bl2 = bl = n6 >>> 24 < 128;
                if (bl) {
                    if (n3 < 0) {
                        n3 = n5;
                        n4 = n6;
                    } else if (n6 != n4) {
                        this.m_rgbPixels[n2][n] = n6 = n4;
                    }
                }
                if ((gifEncoderHashitem = (GifEncoderHashitem)this.colorHash.get(n6)) == null) {
                    gifEncoderHashitem = new GifEncoderHashitem(n6, 1, n5, bl);
                    ++n5;
                    this.colorHash.put(n6, (Object)gifEncoderHashitem);
                    continue;
                }
                ++gifEncoderHashitem.count;
            }
        }
        if (n5 > 256) {
            int n7;
            int n8;
            int n9;
            int n10;
            GifEncoderHashitem[] gifEncoderHashitemArray = new GifEncoderHashitem[n5];
            n = 0;
            Object object2 = this.colorHash.elements();
            while (object2.hasMoreElements()) {
                GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)object2.nextElement();
                gifEncoderHashitem.index = 0;
                gifEncoderHashitemArray[n] = gifEncoderHashitem;
                ++n;
            }
            object2 = new Vector(256);
            GifEncoderOcBlock gifEncoderOcBlock = new GifEncoderOcBlock(0, 0, 0, 255, 255, 255);
            this.setVariance(gifEncoderOcBlock, gifEncoderHashitemArray, 0);
            ((Vector)object2).addElement(gifEncoderOcBlock);
            int n11 = 1;
            int n12 = 0;
            while (n11 < 249) {
                n10 = 1;
                gifEncoderOcBlock = (GifEncoderOcBlock)((Vector)object2).elementAt(n12);
                for (int i = 0; i < 8; ++i) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    if (i < 4) {
                        n9 = gifEncoderOcBlock.pr;
                        n16 = gifEncoderOcBlock.pr + (gifEncoderOcBlock.qr - gifEncoderOcBlock.pr + 1) / 2 - 1;
                    } else {
                        n9 = gifEncoderOcBlock.pr + (gifEncoderOcBlock.qr - gifEncoderOcBlock.pr + 1) / 2;
                        n16 = gifEncoderOcBlock.qr;
                    }
                    if (i % 2 == 0) {
                        n8 = gifEncoderOcBlock.pg;
                        n15 = gifEncoderOcBlock.pg + (gifEncoderOcBlock.qg - gifEncoderOcBlock.pg + 1) / 2 - 1;
                    } else {
                        n8 = gifEncoderOcBlock.pg + (gifEncoderOcBlock.qg - gifEncoderOcBlock.pg + 1) / 2;
                        n15 = gifEncoderOcBlock.qg;
                    }
                    if (i == 0 || i == 1 || i == 4 || i == 5) {
                        n14 = gifEncoderOcBlock.pb;
                        n13 = gifEncoderOcBlock.pb + (gifEncoderOcBlock.qb - gifEncoderOcBlock.pb + 1) / 2 - 1;
                    } else {
                        n14 = gifEncoderOcBlock.pb + (gifEncoderOcBlock.qb - gifEncoderOcBlock.pb + 1) / 2;
                        n13 = gifEncoderOcBlock.qb;
                    }
                    GifEncoderOcBlock gifEncoderOcBlock2 = new GifEncoderOcBlock(n9, n8, n14, n16, n15, n13);
                    int n17 = n10 != 0 ? n12 : n11;
                    if (!this.setVariance(gifEncoderOcBlock2, gifEncoderHashitemArray, n17)) continue;
                    if (n10 != 0) {
                        ((Vector)object2).setElementAt(gifEncoderOcBlock2, n12);
                        n10 = 0;
                        continue;
                    }
                    ((Vector)object2).addElement(gifEncoderOcBlock2);
                    ++n11;
                }
                double d = ((GifEncoderOcBlock)((Vector)object2).elementAt((int)0)).var;
                n12 = 0;
                for (n8 = 1; n8 < n11; ++n8) {
                    double d2 = ((GifEncoderOcBlock)((Vector)object2).elementAt((int)n8)).var;
                    if (!(d2 > d)) continue;
                    d = d2;
                    n12 = n8;
                }
            }
            n3 = -1;
            n4 = -1;
            this.colorHash = new IntHashtable();
            for (n10 = 0; n10 < n11; ++n10) {
                gifEncoderOcBlock = (GifEncoderOcBlock)((Vector)object2).elementAt(n10);
                int n18 = -16777216;
                n18 += (int)gifEncoderOcBlock.cr << 16;
                n18 += (int)gifEncoderOcBlock.cg << 8;
                gifEncoderOcBlock.crgb = n18 += (int)gifEncoderOcBlock.cb;
                this.colorHash.put(n18, (Object)new GifEncoderHashitem(n18, gifEncoderOcBlock.count, n10, false));
            }
            n5 = n11 - 1;
            object = new IntHashtable();
            for (n7 = 0; n7 < gifEncoderHashitemArray.length; ++n7) {
                ((IntHashtable)object).put(gifEncoderHashitemArray[n7].rgb, (Object)gifEncoderHashitemArray[n7]);
            }
            for (n7 = 0; n7 < this.m_height; ++n7) {
                for (n9 = 0; n9 < this.m_width; ++n9) {
                    n8 = this.m_rgbPixels[n7][n9];
                    GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)((IntHashtable)object).get(n8);
                    if (gifEncoderHashitem == null) {
                        throw new IOException("GIF encoding failed at color reduction!");
                    }
                    this.m_rgbPixels[n7][n9] = ((GifEncoderOcBlock)((Vector)object2).elementAt((int)gifEncoderHashitem.index)).crgb;
                }
            }
        }
        n2 = n5 <= 2 ? 1 : (n5 <= 4 ? 2 : (n5 <= 16 ? 4 : 8));
        n = 1 << n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        Enumeration enumeration = this.colorHash.elements();
        while (enumeration.hasMoreElements()) {
            object = (GifEncoderHashitem)enumeration.nextElement();
            byArray[((GifEncoderHashitem)object).index] = (byte)(((GifEncoderHashitem)object).rgb >> 16 & 0xFF);
            byArray2[((GifEncoderHashitem)object).index] = (byte)(((GifEncoderHashitem)object).rgb >> 8 & 0xFF);
            byArray3[((GifEncoderHashitem)object).index] = (byte)(((GifEncoderHashitem)object).rgb & 0xFF);
        }
        this.GIFEncode(this.out, this.m_width, this.m_height, this.m_interlace, (byte)0, n3, n2, byArray, byArray2, byArray3);
    }

    byte GetPixel(int n, int n2) throws IOException {
        GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)this.colorHash.get(this.m_rgbPixels[n2][n]);
        if (gifEncoderHashitem == null) {
            throw new IOException("color not found");
        }
        return (byte)gifEncoderHashitem.index;
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void GIFEncode(OutputStream outputStream, int n, int n2, boolean bl, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.m_width2 = n;
        this.m_height2 = n2;
        this.m_interlace2 = bl;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        this.CountDown = n * n2;
        this.Pass = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        this.curx = 0;
        this.cury = 0;
        GifEncoder.writeString(outputStream, "GIF89a");
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n4 - 1));
        this.Putbyte(by2, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte((byte)0, outputStream);
        for (int i = 0; i < n5; ++i) {
            this.Putbyte(byArray[i], outputStream);
            this.Putbyte(byArray2[i], outputStream);
            this.Putbyte(byArray3[i], outputStream);
        }
        if (n3 != -1) {
            this.Putbyte((byte)33, outputStream);
            this.Putbyte((byte)-7, outputStream);
            this.Putbyte((byte)4, outputStream);
            this.Putbyte((byte)1, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)n3, outputStream);
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)44, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n6, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        if (bl) {
            this.Putbyte((byte)64, outputStream);
        } else {
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.Putbyte((byte)0, outputStream);
        this.Putbyte((byte)59, outputStream);
    }

    protected void BumpPixel() {
        ++this.curx;
        if (this.curx == this.m_width2) {
            this.curx = 0;
            if (!this.m_interlace2) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.m_height2) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.m_height2) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.m_height2) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putword(int n, OutputStream outputStream) throws IOException {
        this.Putbyte((byte)(n & 0xFF), outputStream);
        this.Putbyte((byte)(n >> 8 & 0xFF), outputStream);
    }

    void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n4 = this.GIFNextPixel();
        int n5 = 0;
        for (n3 = this.m_hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.m_hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.GIFNextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.m_hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

