/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxSrc
extends PgGeometry {
    protected boolean m_bEnabledIndexLabels;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected boolean m_bShowPolygonLabels;
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected boolean m_bShowSilhouette;
    protected boolean m_bShowBackface;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected PdVector[] m_vertex;
    protected String[][] m_vertexFunction;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected PdVector[] m_vertexTexture;
    protected PdVector m_vertexSize;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected boolean m_bShowVertexOutline;
    protected boolean m_bShowVertexColors;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected boolean m_bShowVertexSizes;
    protected double m_globalVertexSize;
    protected Color m_globalVertexColor;
    protected Color m_globalVertexTagColor;
    protected double m_globalVertexNormalLength;
    protected double m_globalVertexNormalSize;
    protected Color m_globalVertexNormalColor;
    protected int m_numVectorFields;
    private int[] m_dimOfVectors;
    protected PdVector[][] m_vector;
    protected boolean[] m_bShowVectorFieldMaterials;
    protected Color[][] m_vectorColor;
    protected String[] m_vectorName;
    protected boolean m_bShowVectorFields;
    protected boolean[] m_bShowVectorField;
    protected boolean[] m_bShowVectorArrow;
    protected boolean[] m_vectorIsElementBased;
    protected double[] m_globalVectorLength;
    protected double[] m_globalVectorSize;
    protected boolean[] m_bShowVectorColors;
    protected Color[] m_globalVectorColor;
    protected double m_shininess;
    protected Color m_specularColor;
    protected double m_transparency;
    protected boolean m_bShowTransparency;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected boolean m_bShowElementTexture;
    protected int m_textureSide;
    protected String m_textureImageName;
    protected Image m_textureImage;
    protected int m_filterType;
    protected int m_blendingMode;
    protected PdVector[] m_textureImageBnd;
    protected Dimension m_textureTiling;
    protected int m_texturePeriodic;
    protected boolean m_bShowEdgeNormals;
    protected boolean m_bShowEdgeNormalArrow;
    protected double m_globalEdgeNormalLength;
    protected double m_globalEdgeNormalSize;
    protected Color m_globalEdgeNormalColor;
    protected double m_creaseAngle;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected int m_dimOfPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected PdVector m_polygonSize;
    protected boolean m_bShowPolygonSizes;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected boolean m_bShowPolygonColors;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected Color m_globalPolygonColor;
    protected Color m_globalPolygonTagColor;
    protected double m_globalPolygonSize;
    protected double m_globalPolygonNormalLength;
    protected double m_globalPolygonNormalSize;
    protected Color m_globalPolygonNormalColor;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected Color[] m_edgeColor;
    protected PdVector m_edgeSize;
    protected PiVector[] m_elementEdge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeColorFromElements;
    protected boolean m_bShowEdgeColorFromVertices;
    protected Color m_globalEdgeColor;
    protected Color m_globalEdgeTagColor;
    protected double m_globalEdgeSize;
    protected boolean m_bShowEdgeSizes;
    protected int m_numBndPolygons;
    protected String[] m_bndName;
    protected boolean m_bShowBoundaries;
    protected boolean[] m_bShowBnd;
    protected boolean m_bShowTaggedBoundaries;
    protected Color m_globalBndColor;
    protected Color m_globalBndTagColor;
    protected Color[] m_bndColor;
    protected double m_globalBndSize;
    protected double[] m_bndSize;
    protected boolean[] m_bShowBndMaterials;
    protected PiVector[] m_bndElementInd;
    protected PiVector[] m_bndNeighbourLocInd;
    protected PiVector m_bndNumVertices;
    protected PdVector[][] m_bndVertices;
    protected PiVector[] m_bndVertexInd;
    protected int m_dimOfElements;
    protected int m_maxDimOfElements = 300;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected PdVector[] m_elementNormal;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected boolean m_bShowElementColors;
    protected Color m_globalElementColor;
    protected Color m_globalElementTagColor;
    protected Color m_globalElementBackColor;
    protected Color[] m_elementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bShowSmoothElementColors;
    protected boolean m_bShowElementColorFromVertices;
    protected double m_globalElementNormalLength;
    protected double m_globalElementNormalSize;
    protected Color m_globalElementNormalColor;
    protected PiVector[] m_neighbour;

    public PgJvxSrc() {
        this(3);
        this.init();
    }

    public PgJvxSrc(int n) {
        super(n);
        this.setDimOfSimplex(1);
        this.m_textureTiling = new Dimension(1, 1);
    }

    public void init() {
        super.init();
        this.m_geomType = -1;
        this.m_vertexColor = null;
        this.m_vertexNormal = null;
        this.m_vertexFunction = null;
        this.m_vertexTexture = null;
        this.m_bShowVertices = false;
        this.m_bShowVertexOutline = true;
        this.m_bShowTaggedVertices = true;
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_bShowVertexColors = false;
        this.setMaxNumVertices(0);
        this.m_bEnabledIndexLabels = true;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_polygonColor = null;
        this.m_polygonNormal = null;
        this.m_polygonSize = null;
        this.m_bShowPolygonSizes = false;
        this.m_bShowPolygons = false;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_bShowPolygonColors = false;
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_elementNormal = null;
        this.m_elementColor = null;
        this.m_elementTexture = null;
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_bShowElementColors = false;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothElementColors = false;
        this.m_bShowElementColorFromVertices = false;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_bShowSilhouette = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeColors = false;
        this.m_bShowSmoothEdgeColors = false;
        this.m_bShowEdgeColorFromElements = false;
        this.m_bShowEdgeColorFromVertices = false;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = true;
        this.m_shininess = 10.0;
        this.m_specularColor = Color.white;
        this.m_bShowTransparency = false;
        this.m_transparency = 0.4;
        this.m_bShowVertexSizes = false;
        this.m_globalVertexSize = 2.0;
        this.m_vertexSize = null;
        this.m_globalVertexColor = Color.red;
        this.m_globalVertexTagColor = Color.magenta;
        this.m_globalVertexNormalSize = 1.0;
        this.m_globalVertexNormalLength = 0.5;
        this.m_globalVertexNormalColor = Color.yellow;
        this.m_numVectorFields = 0;
        this.m_vector = null;
        this.m_bShowVectorFields = true;
        this.m_bShowVectorField = null;
        this.m_bShowVectorArrow = null;
        this.m_bShowVectorFieldMaterials = null;
        this.m_globalVectorColor = null;
        this.m_globalVectorLength = null;
        this.m_globalVectorSize = null;
        this.m_dimOfTextures = 2;
        this.m_blendingMode = 0;
        this.m_filterType = 0;
        this.m_bShowVertexTexture = false;
        this.m_bShowElementTexture = false;
        this.m_textureSide = 3;
        this.m_texturePeriodic = 3;
        this.m_globalEdgeColor = Color.black;
        this.m_globalEdgeTagColor = Color.magenta;
        this.m_globalEdgeSize = 1.0;
        this.m_globalEdgeNormalSize = 1.0;
        this.m_globalEdgeNormalLength = 0.5;
        this.m_globalEdgeNormalColor = Color.yellow;
        this.m_globalPolygonColor = Color.black;
        this.m_globalPolygonTagColor = Color.magenta;
        this.m_globalPolygonSize = 1.0;
        this.m_globalPolygonNormalSize = 1.0;
        this.m_globalPolygonNormalLength = 0.5;
        this.m_globalPolygonNormalColor = Color.yellow;
        this.m_globalElementColor = new Color(150, 220, 255);
        this.m_globalElementBackColor = new Color(255, 200, 0);
        this.m_globalElementTagColor = Color.magenta;
        this.m_globalElementNormalSize = 1.0;
        this.m_globalElementNormalLength = 0.5;
        this.m_globalElementNormalColor = Color.yellow;
        this.m_creaseAngle = 3.2;
        this.m_globalBndColor = Color.blue;
        this.m_globalBndTagColor = Color.magenta;
        this.m_globalBndSize = 3.0;
    }

    public void setDimOfVertices(int n) {
        int n2;
        if (this.isEnabledInstanceSharing()) {
            super.setDimOfVertices(n);
            return;
        }
        for (n2 = 0; n2 < this.m_maxNumVertices; ++n2) {
            this.m_vertex[n2].setSize(n);
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_maxNumVertices; ++n2) {
                this.m_vertexNormal[n2].setSize(n);
            }
        }
        if (this.m_elementNormal != null) {
            for (n2 = 0; n2 < this.m_maxNumElements; ++n2) {
                this.m_elementNormal[n2].setSize(n);
            }
        }
        if (this.m_polygonNormal != null) {
            for (n2 = 0; n2 < this.m_maxNumPolygons; ++n2) {
                this.m_polygonNormal[n2].setSize(n);
            }
        }
        super.setDimOfVertices(n);
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        for (int i = this.m_dim; i < 3; ++i) {
            pdVectorArray[0].m_data[i] = 0.0;
            pdVectorArray[1].m_data[i] = 0.0;
        }
        return pdVectorArray;
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getAmbientBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        return pdVectorArray;
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 50: {
                this.showVertices(bl);
                break;
            }
            default: {
                super.setState(n, bl);
            }
        }
    }

    public PgJvxSrc getJvx() {
        return this;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        this.copy(pgJvxSrc);
    }

    public void copy(PgJvxSrc pgJvxSrc) {
        int n;
        if (pgJvxSrc == null) {
            return;
        }
        if (pgJvxSrc == this) {
            return;
        }
        super.copy(pgJvxSrc);
        this.setType(pgJvxSrc.getType());
        this.setEnabledIndexLabels(pgJvxSrc.isEnabledIndexLabels());
        this.showIndices(pgJvxSrc.isShowingIndices());
        this.setNumVertices(pgJvxSrc.getNumVertices());
        this.setVertices(pgJvxSrc.m_vertex);
        this.setVertexColors(pgJvxSrc.m_vertexColor);
        this.setVertexFunctions(pgJvxSrc.m_vertexFunction);
        this.setVertexNormals(pgJvxSrc.m_vertexNormal);
        this.setVertexSizes(pgJvxSrc.m_vertexSize);
        this.setVertexTextures(pgJvxSrc.m_vertexTexture);
        this.setTextureImageBnd(pgJvxSrc.m_textureImageBnd);
        this.showVertices(pgJvxSrc.isShowingVertices());
        this.showTaggedVertices(pgJvxSrc.isShowingTaggedVertices());
        this.showVertexLabels(pgJvxSrc.isShowingVertexLabels());
        this.showVertexOutline(pgJvxSrc.isShowingVertexOutline());
        this.showVertexColors(pgJvxSrc.isShowingVertexColors());
        this.showVertexNormals(pgJvxSrc.isShowingVertexNormals());
        this.showVertexNormalArrow(pgJvxSrc.isShowingVertexNormalArrow());
        this.showVertexSizes(pgJvxSrc.isShowingVertexSizes());
        this.setGlobalVertexSize(pgJvxSrc.getGlobalVertexSize());
        if (pgJvxSrc.getGlobalVertexColor() != null) {
            this.setGlobalVertexColor(pgJvxSrc.getGlobalVertexColor());
        }
        if (pgJvxSrc.getGlobalVertexTagColor() != null) {
            this.setGlobalVertexTagColor(pgJvxSrc.getGlobalVertexTagColor());
        }
        this.setGlobalVertexNormalLength(pgJvxSrc.getGlobalVertexNormalLength());
        this.setGlobalVertexNormalSize(pgJvxSrc.getGlobalVertexNormalSize());
        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
            this.setGlobalVertexNormalColor(pgJvxSrc.getGlobalVertexNormalColor());
        }
        this.setNumPolygons(pgJvxSrc.getNumPolygons());
        this.setDimOfPolygons(pgJvxSrc.getDimOfPolygons());
        this.setPolygons(pgJvxSrc.m_polygon);
        this.setPolygonColors(pgJvxSrc.m_polygonColor);
        this.setPolygonNormals(pgJvxSrc.m_polygonNormal);
        this.setPolygonSizes(pgJvxSrc.m_polygonSize);
        this.showPolygonLabels(pgJvxSrc.isShowingPolygonLabels());
        this.showPolygons(pgJvxSrc.isShowingPolygons());
        this.showPolygonSizes(pgJvxSrc.isShowingPolygonSizes());
        this.showTaggedPolygons(pgJvxSrc.isShowingTaggedPolygons());
        this.showPolygonNormals(pgJvxSrc.isShowingPolygonNormals());
        this.showPolygonNormalArrow(pgJvxSrc.isShowingPolygonNormalArrow());
        this.showPolygonColors(pgJvxSrc.isShowingPolygonColors());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        if (pgJvxSrc.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(pgJvxSrc.getGlobalPolygonColor());
        }
        if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        }
        this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
        this.setGlobalPolygonNormalLength(pgJvxSrc.getGlobalPolygonNormalLength());
        this.setGlobalPolygonNormalSize(pgJvxSrc.getGlobalPolygonNormalSize());
        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
            this.setGlobalPolygonNormalColor(pgJvxSrc.getGlobalPolygonNormalColor());
        }
        this.setNumEdges(pgJvxSrc.getNumEdges());
        this.setEdges(pgJvxSrc.m_edge);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showEdges(pgJvxSrc.isShowingEdges());
        this.m_bShowTaggedEdges = pgJvxSrc.m_bShowTaggedEdges;
        this.showEdgeColors(pgJvxSrc.isShowingEdgeColors());
        this.showEdgeColorFromElements(pgJvxSrc.isShowingEdgeColorFromElements());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
            this.setGlobalEdgeTagColor(pgJvxSrc.getGlobalEdgeTagColor());
        }
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        this.m_bShowEdgeNormals = pgJvxSrc.m_bShowEdgeNormals;
        this.m_bShowEdgeNormalArrow = pgJvxSrc.m_bShowEdgeNormalArrow;
        this.setGlobalEdgeNormalLength(pgJvxSrc.getGlobalEdgeNormalLength());
        this.setGlobalEdgeNormalSize(pgJvxSrc.getGlobalEdgeNormalSize());
        if (pgJvxSrc.getGlobalEdgeNormalColor() != null) {
            this.setGlobalEdgeNormalColor(pgJvxSrc.getGlobalEdgeNormalColor());
        }
        this.setDimOfElements(pgJvxSrc.getDimOfElements());
        this.setNumElements(pgJvxSrc.getNumElements());
        this.setElements(pgJvxSrc.m_element);
        this.setElementColors(pgJvxSrc.m_elementColor);
        this.setElementBackColors(pgJvxSrc.m_elementBackColor);
        this.setElementNormals(pgJvxSrc.m_elementNormal);
        this.setElementTextures(pgJvxSrc.m_elementTexture);
        this.setNeighbours(pgJvxSrc.m_neighbour);
        this.showElementLabels(pgJvxSrc.isShowingElementLabels());
        this.showSilhouette(pgJvxSrc.isShowingSilhouette());
        this.showBackface(pgJvxSrc.isShowingBackface());
        this.showElements(pgJvxSrc.isShowingElements());
        this.showTaggedElements(pgJvxSrc.isShowingTaggedElements());
        this.showElementNormals(pgJvxSrc.isShowingElementNormals());
        this.showElementNormalArrow(pgJvxSrc.isShowingElementNormalArrow());
        this.showElementColors(pgJvxSrc.isShowingElementColors());
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalElementColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalElementTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        if (pgJvxSrc.getGlobalElementBackColor() != null) {
            this.setGlobalElementBackColor(pgJvxSrc.getGlobalElementBackColor());
        }
        this.showElementBackColor(pgJvxSrc.isShowingElementBackColor());
        this.showElementBackColors(pgJvxSrc.isShowingElementBackColors());
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothElementColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showElementFromVertexColors(pgJvxSrc.isShowingElementFromVertexColors());
        this.setGlobalElementNormalLength(pgJvxSrc.getGlobalElementNormalLength());
        this.setGlobalElementNormalSize(pgJvxSrc.getGlobalElementNormalSize());
        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
            this.setGlobalElementNormalColor(pgJvxSrc.getGlobalElementNormalColor());
        }
        this.m_dimOfTextures = pgJvxSrc.getDimOfTextures();
        this.showVertexTexture(pgJvxSrc.isShowingVertexTexture());
        this.showElementTexture(pgJvxSrc.isShowingElementTexture());
        this.setTextureImageName(pgJvxSrc.getTextureImageName());
        this.setTextureImage(pgJvxSrc.getTextureImage());
        this.setFilterType(pgJvxSrc.getFilterType());
        this.setBlendingMode(pgJvxSrc.getBlendingMode());
        this.setTextureTiling(pgJvxSrc.getTextureTiling());
        this.setCreaseAngle(pgJvxSrc.getCreaseAngle());
        this.setNumBndPolygons(pgJvxSrc.getNumBndPolygons());
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        this.m_bShowTaggedBoundaries = pgJvxSrc.m_bShowTaggedBoundaries;
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        this.setGlobalBndSize(pgJvxSrc.getGlobalBndSize());
        for (n = 0; n < this.m_numBndPolygons; ++n) {
            this.showBnd(n, pgJvxSrc.isShowingBnd(n));
            this.showBndMaterials(n, pgJvxSrc.isShowingBndMaterials(n));
            this.setBndName(n, pgJvxSrc.getBndName(n));
            this.setBndElementInd(n, pgJvxSrc.getBndElementInd(n));
            this.setBndNeighbourLocInd(n, pgJvxSrc.getBndNeighbourLocInd(n));
            this.setBndColor(n, pgJvxSrc.getBndColor(n));
            this.setBndSize(n, pgJvxSrc.getBndSize(n));
        }
        this.setNumVectorFields(pgJvxSrc.getNumVectorFields());
        if (pgJvxSrc.m_dimOfVectors != null) {
            this.m_dimOfVectors = (int[])pgJvxSrc.m_dimOfVectors.clone();
        }
        if (pgJvxSrc.m_vector != null) {
            this.m_vector = (PdVector[][])P_Vector.clone(pgJvxSrc.m_vector);
        }
        if (pgJvxSrc.m_bShowVectorFieldMaterials != null) {
            this.m_bShowVectorFieldMaterials = (boolean[])pgJvxSrc.m_bShowVectorFieldMaterials.clone();
        }
        if (pgJvxSrc.m_vectorColor != null) {
            this.m_vectorColor = (Color[][])pgJvxSrc.m_vectorColor.clone();
            for (n = 0; n < pgJvxSrc.m_vectorColor.length; ++n) {
                if (pgJvxSrc.m_vectorColor[n] == null) continue;
                this.m_vectorColor[n] = (Color[])pgJvxSrc.m_vectorColor[n].clone();
            }
        }
        if (pgJvxSrc.m_bShowVectorField != null) {
            this.m_bShowVectorField = (boolean[])pgJvxSrc.m_bShowVectorField.clone();
        }
        if (pgJvxSrc.m_bShowVectorArrow != null) {
            this.m_bShowVectorArrow = (boolean[])pgJvxSrc.m_bShowVectorArrow.clone();
        }
        if (pgJvxSrc.m_vectorIsElementBased != null) {
            this.m_vectorIsElementBased = (boolean[])pgJvxSrc.m_vectorIsElementBased.clone();
        }
        if (pgJvxSrc.m_globalVectorLength != null) {
            this.m_globalVectorLength = (double[])pgJvxSrc.m_globalVectorLength.clone();
        }
        if (pgJvxSrc.m_globalVectorSize != null) {
            this.m_globalVectorSize = (double[])pgJvxSrc.m_globalVectorSize.clone();
        }
        if (pgJvxSrc.m_bShowVectorColors != null) {
            this.m_bShowVectorColors = (boolean[])pgJvxSrc.m_bShowVectorColors.clone();
        }
        if (pgJvxSrc.m_globalVectorColor != null) {
            this.m_globalVectorColor = (Color[])pgJvxSrc.m_globalVectorColor.clone();
        }
        this.showVectorFields(pgJvxSrc.isShowingVectorFields());
        for (n = 0; n < this.m_numVectorFields; ++n) {
            this.setVectorFieldName(n, pgJvxSrc.getVectorFieldName(n));
        }
        this.setShininess(pgJvxSrc.getShininess());
        if (pgJvxSrc.getSpecularColor() != null) {
            this.setSpecularColor(pgJvxSrc.getSpecularColor());
        }
        this.setTransparency(pgJvxSrc.getTransparency());
        this.showTransparency(pgJvxSrc.isShowingTransparency());
    }

    public Object clone() {
        int n;
        PgJvxSrc pgJvxSrc = (PgJvxSrc)super.clone();
        if (pgJvxSrc == null) {
            return null;
        }
        this.setEnabledInstanceSharing(false);
        if (this.m_vertex != null) {
            pgJvxSrc.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            pgJvxSrc.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexFunction != null) {
            pgJvxSrc.m_vertexFunction = PuString.clone(this.m_vertexFunction);
        }
        if (this.m_vertexNormal != null) {
            pgJvxSrc.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vertexSize != null) {
            pgJvxSrc.m_vertexSize = (PdVector)this.m_vertexSize.clone();
        }
        if (this.m_vertexTexture != null) {
            pgJvxSrc.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_textureImageBnd != null) {
            pgJvxSrc.m_textureImageBnd = (PdVector[])P_Vector.clone(this.m_textureImageBnd);
        }
        if (this.m_polygon != null) {
            pgJvxSrc.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            pgJvxSrc.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        if (this.m_polygonNormal != null) {
            pgJvxSrc.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        if (this.m_polygonSize != null) {
            pgJvxSrc.m_polygonSize = (PdVector)this.m_polygonSize.clone();
        }
        if (this.m_edge != null) {
            pgJvxSrc.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_element != null) {
            pgJvxSrc.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            pgJvxSrc.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            pgJvxSrc.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            pgJvxSrc.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            pgJvxSrc.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            pgJvxSrc.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        for (n = 0; n < this.m_numBndPolygons; ++n) {
            if (this.m_bShowBnd != null) {
                pgJvxSrc.m_bShowBnd = (boolean[])this.m_bShowBnd.clone();
            }
            if (this.m_bShowBndMaterials != null) {
                pgJvxSrc.m_bShowBndMaterials = (boolean[])this.m_bShowBndMaterials.clone();
            }
            if (this.m_bndName != null) {
                pgJvxSrc.m_bndName = (String[])this.m_bndName.clone();
            }
            if (this.m_bndElementInd != null) {
                pgJvxSrc.m_bndElementInd = (PiVector[])P_Vector.clone(this.m_bndElementInd);
            }
            if (this.m_bndNeighbourLocInd != null) {
                pgJvxSrc.m_bndNeighbourLocInd = (PiVector[])P_Vector.clone(this.m_bndNeighbourLocInd);
            }
            if (this.m_bndColor != null) {
                pgJvxSrc.m_bndColor = (Color[])this.m_bndColor.clone();
            }
            if (this.m_bndSize == null) continue;
            pgJvxSrc.m_bndSize = (double[])this.m_bndSize.clone();
        }
        if (this.m_dimOfVectors != null) {
            pgJvxSrc.m_dimOfVectors = (int[])this.m_dimOfVectors.clone();
        }
        if (this.m_vector != null) {
            pgJvxSrc.m_vector = (PdVector[][])P_Vector.clone(this.m_vector);
        }
        if (this.m_bShowVectorFieldMaterials != null) {
            pgJvxSrc.m_bShowVectorFieldMaterials = (boolean[])this.m_bShowVectorFieldMaterials.clone();
        }
        if (this.m_vectorColor != null) {
            pgJvxSrc.m_vectorColor = (Color[][])this.m_vectorColor.clone();
            for (n = 0; n < this.m_vectorColor.length; ++n) {
                if (this.m_vectorColor[n] == null) continue;
                pgJvxSrc.m_vectorColor[n] = (Color[])this.m_vectorColor[n].clone();
            }
        }
        if (this.m_bShowVectorField != null) {
            pgJvxSrc.m_bShowVectorField = (boolean[])this.m_bShowVectorField.clone();
        }
        if (this.m_bShowVectorArrow != null) {
            pgJvxSrc.m_bShowVectorArrow = (boolean[])this.m_bShowVectorArrow.clone();
        }
        if (this.m_vectorIsElementBased != null) {
            pgJvxSrc.m_vectorIsElementBased = (boolean[])this.m_vectorIsElementBased.clone();
        }
        if (this.m_globalVectorLength != null) {
            pgJvxSrc.m_globalVectorLength = (double[])this.m_globalVectorLength.clone();
        }
        if (this.m_globalVectorSize != null) {
            pgJvxSrc.m_globalVectorSize = (double[])this.m_globalVectorSize.clone();
        }
        if (this.m_bShowVectorColors != null) {
            pgJvxSrc.m_bShowVectorColors = (boolean[])this.m_bShowVectorColors.clone();
        }
        if (this.m_globalVectorColor != null) {
            pgJvxSrc.m_globalVectorColor = (Color[])this.m_globalVectorColor.clone();
        }
        if (this.m_textureTiling != null) {
            pgJvxSrc.m_textureTiling = new Dimension(this.getTextureTiling());
        }
        return pgJvxSrc;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        int n;
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(80, this.isShowingIndices());
        pvGeometryIf.setState(81, this.isShowingVertexLabels());
        pvGeometryIf.setState(85, this.isEnabledIndexLabels());
        pvGeometryIf.setState(50, this.m_bShowVertices);
        pvGeometryIf.setState(51, this.m_bShowTaggedVertices);
        pvGeometryIf.setState(99, this.m_bShowVertexOutline);
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        pvGeometryIf.setGlobalVertexColor(this.m_globalVertexColor);
        pvGeometryIf.setGlobalVertexTagColor(this.m_globalVertexTagColor);
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setState(91, this.m_bShowVertexColors);
        pvGeometryIf.setVertexNormals(this.m_vertexNormal);
        pvGeometryIf.setGlobalVertexNormalSize(this.m_globalVertexNormalSize);
        pvGeometryIf.setGlobalVertexNormalLength(this.m_globalVertexNormalLength);
        pvGeometryIf.setGlobalVertexNormalColor(this.m_globalVertexNormalColor);
        pvGeometryIf.setState(60, this.m_bShowVertexNormals);
        pvGeometryIf.setState(61, this.m_bShowVertexNormalArrow);
        pvGeometryIf.setState(76, this.m_bShowVertexSizes);
        pvGeometryIf.setGlobalVertexSize(this.m_globalVertexSize);
        pvGeometryIf.setVertexSizes(this.m_vertexSize);
        pvGeometryIf.setState(71, this.m_bShowVertexTexture);
        if (this.m_textureImage != null) {
            n = this.m_textureImage.getWidth(null);
            int n2 = this.m_textureImage.getHeight(null);
            int n3 = 0;
            int n4 = 0;
            int n5 = n;
            int n6 = n2;
            if (this.m_textureImageBnd != null) {
                n3 = (int)((double)n * this.m_textureImageBnd[0].getEntry(0));
                n4 = (int)((double)n2 * this.m_textureImageBnd[0].getEntry(1));
                n5 = (int)((double)n * this.m_textureImageBnd[1].getEntry(0));
                n6 = (int)((double)n2 * this.m_textureImageBnd[1].getEntry(1));
                n = n5 - n3;
                n2 = n6 - n4;
            }
            pvGeometryIf.setTexture(PsImage.getPixels(this.m_textureImage, n3, n4, n, n2, null, 0, n), n, n2, this.m_textureTiling.width, this.m_textureTiling.height, this.getTexturePeriodic(), this.getBlendingMode(), this.getFilterType(), this.getTextureSide());
        } else {
            pvGeometryIf.setTexture(null, -1, -1, 1, 1, this.getTexturePeriodic(), this.getBlendingMode(), this.getFilterType(), this.getTextureSide());
        }
        pvGeometryIf.setVertexTextures(this.m_vertexTexture);
        pvGeometryIf.setShininess(this.m_shininess);
        pvGeometryIf.setSpecularColor(this.m_specularColor);
        pvGeometryIf.setState(75, this.m_bShowTransparency);
        pvGeometryIf.setTransparency(this.m_transparency);
        pvGeometryIf.setNumVectorFields(this.m_numVectorFields);
        pvGeometryIf.showVectorFields(this.m_bShowVectorFields);
        for (n = 0; n < this.m_numVectorFields; ++n) {
            if (this.m_vectorIsElementBased[n]) {
                pvGeometryIf.setNumVectors(n, this.m_numElements, this.m_dimOfVectors[n]);
            } else {
                pvGeometryIf.setNumVectors(n, this.m_numVertices, this.m_dimOfVectors[n]);
            }
            pvGeometryIf.setVectors(n, this.m_vector[n]);
            pvGeometryIf.setVectorElementBased(n, this.m_vectorIsElementBased[n]);
            pvGeometryIf.showVectorField(n, this.isShowingVectorField(n));
            pvGeometryIf.showVectorArrows(n, this.m_bShowVectorArrow[n]);
            pvGeometryIf.showVectorColors(n, this.m_bShowVectorColors[n]);
            pvGeometryIf.setGlobalVectorColor(n, this.m_globalVectorColor[n]);
            pvGeometryIf.setGlobalVectorLength(n, this.m_globalVectorLength[n]);
            pvGeometryIf.setGlobalVectorSize(n, this.m_globalVectorSize[n]);
        }
        pvGeometryIf.setState(82, this.isShowingPolygonLabels());
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(54, this.m_bShowPolygons);
        pvGeometryIf.setState(55, this.m_bShowTaggedPolygons);
        pvGeometryIf.setState(89, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(90, this.m_bShowPolygonEndArrow);
        pvGeometryIf.setDimOfPolygons(this.m_dimOfPolygons);
        pvGeometryIf.setNumPolygons(this.m_numPolygons);
        pvGeometryIf.setPolygons(this.m_polygon);
        pvGeometryIf.setPolygonColors(this.m_polygonColor);
        pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor);
        pvGeometryIf.setState(93, this.m_bShowPolygonColors);
        pvGeometryIf.setPolygonNormals(this.m_polygonNormal);
        pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize);
        pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength);
        pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor);
        pvGeometryIf.setState(64, this.m_bShowPolygonNormals);
        pvGeometryIf.setState(65, this.m_bShowPolygonNormalArrow);
        pvGeometryIf.setPolygonSizes(this.m_polygonSize);
        pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize);
        pvGeometryIf.setState(108, this.m_bShowPolygonSizes);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(104, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(94, this.m_bShowEdgeColors);
        pvGeometryIf.setState(95, this.m_bShowEdgeColorFromElements);
        pvGeometryIf.setState(96, this.m_bShowEdgeColorFromVertices);
        pvGeometryIf.setState(97, this.m_bShowEdgeSizes);
        if (this.m_bShowEdges || this.m_bShowSilhouette) {
            pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize);
            pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor);
            pvGeometryIf.setGlobalEdgeTagColor(this.m_globalEdgeTagColor);
        }
        pvGeometryIf.setNumEdges(this.m_numEdges);
        pvGeometryIf.setEdges(this.m_edge);
        pvGeometryIf.setEdgeColors(this.m_edgeColor);
        pvGeometryIf.setEdgeSizes(this.m_edgeSize);
        pvGeometryIf.setState(68, this.m_bShowBackface);
        pvGeometryIf.setState(88, this.m_bShowSilhouette);
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_bShowBoundaries || this.m_bShowSilhouette) {
            pvGeometryIf.setGlobalBndSize(this.m_globalBndSize);
            pvGeometryIf.setGlobalBndColor(this.m_globalBndColor);
            pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor);
        }
        pvGeometryIf.setState(84, this.isShowingElementLabels());
        pvGeometryIf.setState(56, this.m_bShowElements);
        pvGeometryIf.setState(57, true);
        pvGeometryIf.setDimOfElements(this.m_dimOfElements);
        pvGeometryIf.setNumElements(this.m_numElements);
        pvGeometryIf.setElements(this.m_element);
        pvGeometryIf.setState(107, true);
        pvGeometryIf.setNeighbours(this.m_neighbour);
        pvGeometryIf.setElementEdges(this.m_elementEdge);
        pvGeometryIf.setState(94, this.isShowingEdgeColors());
        pvGeometryIf.setEdgeColors(this.m_edgeColor);
        pvGeometryIf.setState(97, this.isShowingEdgeSizes());
        pvGeometryIf.setEdgeSizes(this.m_edgeSize);
        pvGeometryIf.setElementEdges(this.m_elementEdge);
        pvGeometryIf.setState(103, this.isShowingSmoothLighting());
        pvGeometryIf.setState(105, this.isShowingSmoothElementColors());
        pvGeometryIf.setState(106, this.isShowingElementFromVertexColors());
        pvGeometryIf.setState(98, this.isShowingElementColors());
        pvGeometryIf.setElementColors(this.m_elementColor);
        pvGeometryIf.setState(101, this.m_bShowElementBackColor);
        pvGeometryIf.setState(102, this.m_bShowElementBackColors);
        pvGeometryIf.setElementBackColors(this.m_elementBackColor);
        pvGeometryIf.setState(62, this.m_bShowElementNormals);
        pvGeometryIf.setState(63, this.m_bShowElementNormalArrow);
        pvGeometryIf.setElementNormals(this.m_elementNormal);
        pvGeometryIf.setGlobalElementNormalSize(this.m_globalElementNormalSize);
        pvGeometryIf.setGlobalElementNormalLength(this.m_globalElementNormalLength);
        pvGeometryIf.setGlobalElementNormalColor(this.m_globalElementNormalColor);
        pvGeometryIf.setCreaseAngle(this.m_creaseAngle);
        pvGeometryIf.setState(72, this.m_elementTexture != null && this.m_bShowElementTexture);
        pvGeometryIf.setElementTextures(this.m_elementTexture);
        pvGeometryIf.setGlobalElementColor(this.m_globalElementColor);
        pvGeometryIf.setGlobalElementBackColor(this.m_globalElementBackColor);
        pvGeometryIf.setGlobalElementTagColor(this.m_globalElementTagColor);
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public PdVector getVertexSizes() {
        return this.m_vertexSize;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public PdVector getPolygonSizes() {
        return this.m_polygonSize;
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public void clearTagVertex(int n, int n2) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].clearTag(n2);
    }

    public boolean hasTagVertex(int n, int n2) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_vertex[n].hasTag(n2);
    }

    public void setTagVertex(int n, int n2) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].setTag(n2);
    }

    public int addVertex(PdVector pdVector) {
        this.setNumVertices(this.m_numVertices + 1);
        this.setVertex(this.m_numVertices - 1, pdVector);
        return this.m_numVertices - 1;
    }

    public PdVector getVertex(int n) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[n];
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        this.m_maxNumVertices = n;
        if (this.isEnabledInstanceSharing()) {
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, this.m_maxNumVertices, this.m_dim);
        if (this.m_vertexColor != null) {
            this.assureVertexColors();
        }
        if (this.m_vertexNormal != null) {
            this.assureVertexNormals();
        }
        if (this.m_vertexSize != null) {
            this.assureVertexSizes();
        }
        if (this.m_vertexTexture != null) {
            this.assureVertexTextures();
        }
        if (this.m_numVertices > this.m_maxNumVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
    }

    public void setNumVertices(int n) {
        if (n > this.m_maxNumVertices) {
            this.setMaxNumVertices(n);
        }
        this.m_numVertices = n;
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices || this.m_vertexNormal.length > 0 && this.m_vertexNormal[0] != null && this.m_vertexNormal[0].getSize() != this.m_dim) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void assureVertexSizes() {
        if (this.m_vertexSize == null) {
            this.m_vertexSize = new PdVector(this.m_maxNumVertices);
            this.m_vertexSize.setConstant(this.m_globalVertexSize);
        } else if (this.m_vertexSize.getSize() != this.m_maxNumVertices) {
            this.m_vertexSize.setSize(this.m_maxNumVertices);
        }
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices || this.m_vertexTexture.length > 0 && this.m_vertexTexture[0] != null && this.m_vertexTexture[0].getSize() != this.m_dimOfTextures) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
    }

    public int getDimOfTextures() {
        return this.m_dimOfTextures;
    }

    public void setDimOfTextures(int n) {
        this.m_dimOfTextures = n;
    }

    public int getDimOfVectors(int n) {
        return this.m_dimOfVectors[n];
    }

    public int getNumVectors(int n) {
        return this.m_vector[n].length;
    }

    public void setNumVectors(int n, int n2, int n3) {
        this.m_dimOfVectors[n] = n3;
        this.m_vector[n] = PdVector.realloc(this.m_vector[n], n2, n3);
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public void setNumVectorFields(int n) {
        int n2;
        int n3;
        if (n == this.m_numVectorFields) {
            return;
        }
        PdVector[][] pdVectorArrayArray = new PdVector[n][];
        for (n3 = 0; n3 < Math.min(n, this.m_numVectorFields); ++n3) {
            pdVectorArrayArray[n3] = this.m_vector[n3];
        }
        for (n3 = Math.min(n, this.m_numVectorFields); n3 < n; ++n3) {
            pdVectorArrayArray[n3] = new PdVector[0];
        }
        this.m_vector = pdVectorArrayArray;
        Color[][] colorArrayArray = new Color[n][];
        for (n2 = 0; n2 < Math.min(n, this.m_numVectorFields); ++n2) {
            colorArrayArray[n2] = this.m_vectorColor[n2];
        }
        this.m_vectorColor = colorArrayArray;
        this.m_dimOfVectors = PuData.realloc(this.m_dimOfVectors, n);
        this.m_vectorName = PuData.realloc(this.m_vectorName, n);
        for (n2 = 0; n2 < n; ++n2) {
            if (this.m_vectorName[n2] != null) continue;
            this.m_vectorName[n2] = "vf[" + String.valueOf(n2) + "]";
        }
        this.m_bShowVectorFieldMaterials = PuData.realloc(this.m_bShowVectorFieldMaterials, n);
        this.m_bShowVectorField = PuData.realloc(this.m_bShowVectorField, n);
        this.m_bShowVectorArrow = PuData.realloc(this.m_bShowVectorArrow, n);
        this.m_bShowVectorColors = PuData.realloc(this.m_bShowVectorColors, n);
        if (n > this.m_numVectorFields) {
            for (n2 = this.m_numVectorFields; n2 < n; ++n2) {
                this.m_bShowVectorFieldMaterials[n2] = false;
                this.m_bShowVectorField[n2] = true;
                this.m_bShowVectorArrow[n2] = false;
                this.m_bShowVectorColors[n2] = false;
            }
        }
        this.m_vectorIsElementBased = PuData.realloc(this.m_vectorIsElementBased, n);
        this.m_globalVectorLength = PuData.realloc(this.m_globalVectorLength, n);
        this.m_globalVectorSize = PuData.realloc(this.m_globalVectorSize, n);
        this.m_globalVectorColor = PdColor.realloc(this.m_globalVectorColor, n);
        this.m_numVectorFields = n;
        for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
            this.m_globalVectorSize[n2] = 1.0;
            this.m_globalVectorLength[n2] = 1.0;
            this.m_globalVectorColor[n2] = Color.yellow;
        }
    }

    public PdVector[] getVectors(int n) {
        return this.m_vector[n];
    }

    public void setVectors(int n, PdVector[] pdVectorArray) {
        if (n < 0 || this.m_numVectorFields <= n) {
            PsDebug.warning("index out of bounds, ind=" + n);
            return;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing list of vectors of vector field[" + n + "].");
            return;
        }
        if (pdVectorArray.length < this.m_vector[n].length) {
            PsDebug.warning("length of argument list smaller than known size");
            return;
        }
        PdVector.copy(this.m_vector[n], 0, pdVectorArray, 0, this.m_vector[n].length);
    }

    public String getVectorFieldName(int n) {
        return this.m_vectorName[n];
    }

    public void setVectorFieldName(int n, String string) {
        this.m_vectorName[n] = string;
    }

    public boolean isShowingVectorArrows(int n) {
        return this.m_bShowVectorArrow[n];
    }

    public void showVectorArrows(int n, boolean bl) {
        this.m_bShowVectorArrow[n] = bl;
    }

    public boolean isVectorElementBased(int n) {
        return this.m_vectorIsElementBased[n];
    }

    public void setVectorElementBased(int n, boolean bl) {
        this.m_vectorIsElementBased[n] = bl;
    }

    public boolean isShowingIndividualMaterial(int n) {
        return this.isShowingVectorFieldMaterials(n);
    }

    public boolean isShowingVectorFieldMaterials(int n) {
        return this.m_bShowVectorFieldMaterials[n];
    }

    public void showIndividualMaterial(int n, boolean bl) {
        this.showVectorFieldMaterials(n, bl);
    }

    public void showVectorFieldMaterials(int n, boolean bl) {
        this.m_bShowVectorFieldMaterials[n] = bl;
    }

    public boolean isShowingVectorFields() {
        return this.m_bShowVectorFields;
    }

    public void showVectorFields(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public boolean isShowingVectorField(int n) {
        return this.m_bShowVectorField[n];
    }

    public void showVectorField(int n, boolean bl) {
        this.m_bShowVectorField[n] = bl;
    }

    public boolean isShowingVectorColors(int n) {
        return this.m_bShowVectorColors[n];
    }

    public void showVectorColors(int n, boolean bl) {
        this.m_bShowVectorColors[n] = bl;
    }

    public Color getGlobalVectorColor(int n) {
        return this.m_globalVectorColor[n];
    }

    public boolean setGlobalVectorColor(int n, Color color) {
        this.m_globalVectorColor[n] = color;
        return true;
    }

    public double getGlobalVectorLength(int n) {
        return this.m_globalVectorLength[n];
    }

    public boolean setGlobalVectorLength(int n, double d) {
        this.m_globalVectorLength[n] = d;
        return true;
    }

    public double getGlobalVectorSize(int n) {
        return this.m_globalVectorSize[n];
    }

    public boolean setGlobalVectorSize(int n, double d) {
        this.m_globalVectorSize[n] = d;
        return true;
    }

    public void assureVectorColors(int n) {
        if (n < 0 || this.m_numVectorFields <= n) {
            PsDebug.warning("index out of bounds, ind=" + n);
            return;
        }
        if (this.m_vectorColor[n] == null || this.m_vectorColor[n].length != this.m_vector[n].length) {
            this.m_vectorColor[n] = PdColor.realloc(this.m_vectorColor[n], this.m_vector[n].length);
        }
    }

    public Color[] getVectorFieldColors(int n) {
        return this.m_vectorColor[n];
    }

    public void setVectorColors(int n, Color[] colorArray) {
        if (n < 0 || this.m_numVectorFields <= n) {
            PsDebug.warning("index out of bounds, ind=" + n);
            return;
        }
        if (colorArray == null) {
            this.m_vectorColor[n] = null;
            this.m_bShowVectorColors[n] = false;
            return;
        }
        if (colorArray.length < this.m_vector[n].length) {
            PsDebug.warning("color array is too small");
            return;
        }
        this.assureVectorColors(n);
        PdColor.copy(this.m_vectorColor[n], 0, colorArray, 0, this.m_vector[n].length);
    }

    public int getDimOfPolygons() {
        return this.m_dimOfPolygons;
    }

    public void setDimOfPolygons(int n) {
        if (n > -1) {
            for (int i = 0; i < this.m_maxNumPolygons; ++i) {
                this.m_polygon[i].setSize(n);
            }
        }
        this.m_dimOfPolygons = n;
    }

    protected void setMaxNumPolygons(int n) {
        if (this.m_maxNumPolygons == n) {
            return;
        }
        this.m_maxNumPolygons = n;
        if (this.isEnabledInstanceSharing()) {
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, this.m_maxNumPolygons, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, this.m_maxNumPolygons);
        if (this.m_polygonColor != null) {
            this.assurePolygonColors();
        }
        if (this.m_polygonNormal != null) {
            this.assurePolygonNormals();
        }
        if (this.m_polygonSize != null) {
            this.assurePolygonSizes();
        }
        if (this.m_numPolygons > this.m_maxNumPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public void setNumPolygons(int n) {
        this.setDimOfSimplex(1);
        if (n > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(n);
        }
        this.m_numPolygons = n;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public int getNumEdges() {
        return this.m_numEdges;
    }

    public void setNumEdges(int n) {
        if (this.m_numEdges == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numEdges = n;
            return;
        }
        this.m_edge = PiVector.realloc(this.m_edge, n);
        if (this.m_edgeColor != null) {
            this.assureEdgeColors();
        }
        if (this.m_edgeSize != null) {
            this.assureEdgeSizes();
        }
        this.m_numEdges = n;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    public void setEdges(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_edge = null;
            return;
        }
        if (piVectorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of edge array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_edge = piVectorArray;
            return;
        }
        PiVector.copy(this.m_edge, 0, piVectorArray, 0, this.m_numEdges);
    }

    public PiVector[] getElementEdges() {
        return this.m_elementEdge;
    }

    public void setElementEdges(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_elementEdge = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_elementEdge = piVectorArray;
            return;
        }
        this.assureElementEdges();
        PiVector.copy(this.m_elementEdge, 0, piVectorArray, 0, this.m_numElements);
    }

    public void assureElementEdges() {
        if (this.m_dimOfElements != -1) {
            this.m_elementEdge = PiVector.realloc(this.m_elementEdge, this.m_numElements, this.m_dimOfElements);
        } else {
            this.m_elementEdge = PiVector.realloc(this.m_elementEdge, this.m_numElements);
            for (int i = 0; i < this.m_numElements; ++i) {
                this.m_elementEdge[i].setSize(this.m_element[i].getSize());
            }
        }
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public boolean hasEdgeColors() {
        return this.m_edgeColor != null && this.m_edgeColor.length == this.m_numEdges;
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdges) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdges);
        }
    }

    public void setEdgeColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_edgeColor = null;
            return;
        }
        if (colorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_edgeColor = colorArray;
            return;
        }
        this.assureEdgeColors();
        PdColor.copy(this.m_edgeColor, 0, colorArray, 0, this.m_numEdges);
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public PdVector getEdgeSizes() {
        return this.m_edgeSize;
    }

    public void assureEdgeSizes() {
        if (this.m_edgeSize == null) {
            this.m_edgeSize = new PdVector(this.m_numEdges);
            this.m_edgeSize.setConstant(this.m_globalEdgeSize);
        } else if (this.m_edgeSize.getSize() != this.m_numEdges) {
            this.m_edgeSize.setSize(this.m_numEdges);
        }
    }

    public void setEdgeSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_edgeSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numEdges) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_edgeSize = pdVector;
            return;
        }
        this.assureEdgeSizes();
        this.m_edgeSize.copy(0, pdVector, 0, this.m_numEdges);
    }

    public boolean isShowingEdgeSizes() {
        return this.m_bShowEdgeSizes;
    }

    public void showEdgeSizes(boolean bl) {
        this.m_bShowEdgeSizes = bl;
    }

    public int getDimOfElements() {
        return this.m_dimOfElements;
    }

    public void setDimOfElements(int n) {
        if (n == this.m_dimOfElements) {
            return;
        }
        if (n != -1 && n < 3) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfElements = n;
        if (n == -1) {
            for (int i = this.m_numElements; i < this.m_maxNumElements; ++i) {
                this.m_element[i].setSize(0);
                if (this.m_neighbour == null) continue;
                this.m_neighbour[i].setSize(0);
            }
        } else {
            for (int i = 0; i < this.m_maxNumElements; ++i) {
                this.m_element[i].setSize(n);
                if (this.m_neighbour == null) continue;
                this.m_neighbour[i].setSize(n);
                this.m_neighbour[i].setConstant(-1);
            }
        }
    }

    protected void setDimOfElement(int n, int n2) {
        if (this.m_dimOfElements == n2) {
            return;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return;
        }
        if (n2 < 3) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(n2);
        } else if (this.m_dimOfElements != -1) {
            this.setDimOfElements(-1);
        }
        this.m_element[n].setSize(n2);
        if (this.m_neighbour != null) {
            this.m_neighbour[n].setSize(n2);
            this.m_neighbour[n].setConstant(-1);
        }
    }

    protected void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        this.m_maxNumElements = n;
        if (this.isEnabledInstanceSharing()) {
            return;
        }
        this.m_element = this.m_dimOfElements > -1 ? PiVector.realloc(this.m_element, n, this.m_dimOfElements) : PiVector.realloc(this.m_element, n);
        if (this.m_neighbour != null) {
            this.assureNeighbours();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_elementEdge != null) {
            this.assureElementEdges();
        }
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
    }

    public void setNumElements(int n) {
        this.setDimOfSimplex(2);
        if (this.m_numElements == n) {
            return;
        }
        if (n > this.m_maxNumElements || n < this.m_maxNumElements / 2 && n < this.m_maxNumElements - 100) {
            this.setMaxNumElements(n);
        }
        this.m_numElements = n;
    }

    public void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            for (n = 0; n < this.m_maxNumElements; ++n) {
                if (this.m_neighbour[n].m_data != null && this.m_element[n].m_data != null && this.m_neighbour[n].m_data.length == this.m_element[n].m_data.length) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            for (n = 0; n < this.m_maxNumElements; ++n) {
                this.m_neighbour[n].setSize(this.m_element[n].getSize());
            }
        }
        for (n = 0; n < this.m_maxNumElements; ++n) {
            this.m_neighbour[n].setConstant(-1);
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements || this.m_elementNormal.length > 0 && this.m_elementNormal[0] != null && this.m_elementNormal[0].getSize() != this.m_dim) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null || this.m_elementTexture.length != this.m_maxNumElements) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        for (int i = 0; i < this.m_maxNumElements; ++i) {
            this.m_elementTexture[i] = PdVector.realloc(this.m_elementTexture[i], this.m_element[i].getSize(), this.m_dimOfTextures);
        }
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor;
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor;
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize;
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor;
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength;
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize;
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor = color;
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor = color;
    }

    public void setGlobalVertexSize(double d) {
        this.m_globalVertexSize = d;
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor = color;
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalVertexNormalLength = d;
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor;
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor;
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize;
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor;
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength;
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize;
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor = color;
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor = color;
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = d;
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor = color;
    }

    public void setGlobalPolygonNormalLength(double d) {
        this.m_globalPolygonNormalLength = d;
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor;
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor;
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize;
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor = color;
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor = color;
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
    }

    public Color getGlobalEdgeNormalColor() {
        return this.m_globalPolygonNormalColor;
    }

    public double getGlobalEdgeNormalLength() {
        return this.m_globalEdgeNormalLength;
    }

    public double getGlobalEdgeNormalSize() {
        return this.m_globalEdgeNormalSize;
    }

    public void setGlobalEdgeNormalColor(Color color) {
        this.m_globalEdgeNormalColor = color;
    }

    public void setGlobalEdgeNormalLength(double d) {
        this.m_globalEdgeNormalLength = d;
    }

    public void setGlobalEdgeNormalSize(double d) {
        this.m_globalEdgeNormalSize = d;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor;
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor;
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor;
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength;
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize;
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor = color;
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor = color;
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor = color;
    }

    public void setGlobalElementNormalColor(Color color) {
        this.m_globalElementNormalColor = color;
    }

    public void setGlobalElementNormalLength(double d) {
        this.m_globalElementNormalLength = d;
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
    }

    public double getCreaseAngle() {
        return this.m_creaseAngle;
    }

    public void setCreaseAngle(double d) {
        this.m_creaseAngle = d;
    }

    public String getBndName(int n) {
        return this.m_bndName[n];
    }

    public void setBndName(int n, String string) {
        this.m_bndName[n] = string;
    }

    public PiVector getBndElementInd(int n) {
        return this.m_bndElementInd[n];
    }

    public void setBndElementInd(int n, PiVector piVector) {
        this.m_bndElementInd[n].setSize(piVector.getSize());
        this.m_bndElementInd[n].copy(piVector);
    }

    public PiVector getBndNeighbourLocInd(int n) {
        return this.m_bndNeighbourLocInd[n];
    }

    public void setBndNeighbourLocInd(int n, PiVector piVector) {
        this.m_bndNeighbourLocInd[n].setSize(piVector.getSize());
        this.m_bndNeighbourLocInd[n].copy(piVector);
    }

    public void setBndNumVertices(int n, int n2) {
        this.m_bndNumVertices.setEntry(n, n2);
    }

    public int getBndNumVertices(int n) {
        return this.m_bndNumVertices.getEntry(n);
    }

    public void setBndVertices(int n, PdVector[] pdVectorArray) {
        this.m_bndVertices[n] = pdVectorArray;
    }

    public PdVector[] getBndVertices(int n) {
        return this.m_bndVertices[n];
    }

    public void setBndVertexInd(int n, PiVector piVector) {
        this.m_bndVertexInd[n] = piVector;
    }

    public PiVector getBndVertexInd(int n) {
        return this.m_bndVertexInd[n];
    }

    public boolean isShowingBnd(int n) {
        return this.m_bShowBnd[n];
    }

    public void showBnd(int n, boolean bl) {
        this.m_bShowBnd[n] = bl;
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor;
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor = color;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor;
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor = color;
    }

    public Color getBndColor(int n) {
        return this.m_bndColor[n];
    }

    public boolean setBndColor(int n, Color color) {
        this.m_bndColor[n] = color;
        return true;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize;
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
    }

    public double getBndSize(int n) {
        return this.m_bndSize[n];
    }

    public boolean setBndSize(int n, double d) {
        this.m_bndSize[n] = d;
        return true;
    }

    public boolean isShowingBndMaterials(int n) {
        return this.m_bShowBndMaterials[n];
    }

    public void showBndMaterials(int n, boolean bl) {
        this.m_bShowBndMaterials[n] = bl;
    }

    public int getNumBndPolygons() {
        return this.m_numBndPolygons;
    }

    public void setNumBndPolygons(int n) {
        int n2;
        int n3;
        if (n == this.m_numBndPolygons) {
            return;
        }
        this.m_bndName = PuData.realloc(this.m_bndName, n);
        for (n3 = 0; n3 < n; ++n3) {
            if (this.m_bndName[n3] != null) continue;
            this.m_bndName[n3] = "bnd[" + String.valueOf(n3) + "]";
        }
        this.m_bShowBndMaterials = PuData.realloc(this.m_bShowBndMaterials, n);
        this.m_bShowBnd = PuData.realloc(this.m_bShowBnd, n);
        if (n > this.m_numBndPolygons) {
            for (n3 = this.m_numBndPolygons; n3 < n; ++n3) {
                this.m_bShowBndMaterials[n3] = false;
                this.m_bShowBnd[n3] = true;
            }
        }
        if (this.m_bndNumVertices == null) {
            this.m_bndNumVertices = new PiVector(n);
        } else {
            this.m_bndNumVertices.setSize(n);
        }
        this.m_bndVertexInd = PiVector.realloc(this.m_bndVertexInd, n);
        PdVector[][] pdVectorArrayArray = new PdVector[n][];
        if (n > this.m_numBndPolygons) {
            for (n2 = 0; n2 < this.m_numBndPolygons; ++n2) {
                pdVectorArrayArray[n2] = this.m_bndVertices[n2];
            }
        }
        this.m_bndVertices = pdVectorArrayArray;
        this.m_bndElementInd = PiVector.realloc(this.m_bndElementInd, n);
        this.m_bndNeighbourLocInd = PiVector.realloc(this.m_bndNeighbourLocInd, n);
        this.m_bndColor = PdColor.realloc(this.m_bndColor, n);
        this.m_bndSize = PuData.realloc(this.m_bndSize, n);
        this.m_numBndPolygons = n;
        for (n2 = 0; n2 < this.m_numBndPolygons; ++n2) {
            this.m_bndColor[n2] = this.m_globalBndColor;
            this.m_bndSize[n2] = this.m_globalBndSize;
        }
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if ((pdVectorArray == null || pdVectorArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        if (pdVectorArray[0] == null || pdVectorArray[0].getSize() != this.getDimOfVertices()) {
            PsDebug.warning("wrong dimension at least of first argument vertex.");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertex = pdVectorArray;
            if (this.m_maxNumVertices != pdVectorArray.length) {
                this.setMaxNumVertices(pdVectorArray.length);
            }
            return;
        }
        PdVector.copy(this.m_vertex, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public String[][] getVertexFunctions() {
        return this.m_vertexFunction;
    }

    public void setVertexFunctions(String[][] stringArray) {
        if (stringArray == null) {
            this.m_vertexFunction = null;
            return;
        }
        if (stringArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexFunction = stringArray;
            return;
        }
        this.m_vertexFunction = new String[this.m_numVertices][this.m_dim];
        for (int i = 0; i < this.m_numVertices; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                this.m_vertexFunction[i][j] = stringArray[i][j];
            }
        }
    }

    public void setVertexColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vertexColor = null;
            return;
        }
        if (colorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexColor = colorArray;
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, colorArray, 0, this.m_numVertices);
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexNormal = pdVectorArray;
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void setVertexSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_vertexSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexSize = pdVector;
            return;
        }
        this.assureVertexSizes();
        this.m_vertexSize.copy(0, pdVector, 0, this.m_numVertices);
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexTexture = pdVectorArray;
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public String getTextureImageName() {
        return this.m_textureImageName;
    }

    public void setTextureImageName(String string) {
        this.m_textureImageName = string;
    }

    public Image getTextureImage() {
        return this.m_textureImage;
    }

    public void setTextureImage(Image image) {
        this.m_textureImage = image;
    }

    public PdVector[] getTextureImageBnd() {
        return this.m_textureImageBnd;
    }

    public void setTextureImageBnd(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_textureImageBnd = null;
            return;
        }
        if (pdVectorArray.length != 2) {
            PsDebug.warning("missing or void length of texture image bounds");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_textureImageBnd = pdVectorArray;
            return;
        }
        this.m_textureImageBnd = new PdVector[2];
        this.m_textureImageBnd[0] = (PdVector)pdVectorArray[0].clone();
        this.m_textureImageBnd[1] = (PdVector)pdVectorArray[1].clone();
    }

    public int getFilterType() {
        return this.m_filterType;
    }

    public void setFilterType(int n) {
        this.m_filterType = n;
    }

    public int getBlendingMode() {
        return this.m_blendingMode;
    }

    public void setBlendingMode(int n) {
        this.m_blendingMode = n;
    }

    public int getTexturePeriodic() {
        return this.m_texturePeriodic;
    }

    public void setTexturePeriodic(int n) {
        this.m_texturePeriodic = n;
    }

    public Dimension getTextureTiling() {
        return this.m_textureTiling;
    }

    public void setTextureTiling(Dimension dimension) {
        this.m_textureTiling.setSize(dimension);
    }

    public double getShininess() {
        return this.m_shininess;
    }

    public void setShininess(double d) {
        this.m_shininess = d;
    }

    public Color getSpecularColor() {
        return this.m_specularColor;
    }

    public void setSpecularColor(Color color) {
        this.m_specularColor = color;
    }

    public boolean isShowingTransparency() {
        return this.m_bShowTransparency;
    }

    public void showTransparency(boolean bl) {
        this.m_bShowTransparency = bl;
    }

    public double getTransparency() {
        return this.m_transparency;
    }

    public void setTransparency(double d) {
        this.m_transparency = d;
    }

    public void setPolygons(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numPolygons == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of polygon array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygon = piVectorArray;
            if (this.m_maxNumPolygons != piVectorArray.length) {
                this.setMaxNumPolygons(piVectorArray.length);
            }
            return;
        }
        for (int i = 0; i < this.m_numPolygons; ++i) {
            this.m_polygon[i].setSize(piVectorArray[i].getSize());
        }
        PiVector.copy(this.m_polygon, 0, piVectorArray, 0, this.m_numPolygons);
    }

    public void setPolygonColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_polygonColor = null;
            return;
        }
        if (colorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonColor = colorArray;
            return;
        }
        this.assurePolygonColors();
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, this.m_numPolygons);
    }

    public void setPolygonNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonNormal = pdVectorArray;
            return;
        }
        this.assurePolygonNormals();
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, this.m_numPolygons);
    }

    public void removePolygonSizes() {
        this.setPolygonSizes(null);
    }

    public void setPolygonSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_polygonSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numPolygons) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonSize = pdVector;
            return;
        }
        this.assurePolygonSizes();
        this.m_polygonSize.copy(0, pdVector, 0, this.m_numPolygons);
    }

    public void assurePolygonSizes() {
        if (this.m_polygonSize == null) {
            this.m_polygonSize = new PdVector(this.m_maxNumPolygons);
            this.m_polygonSize.setConstant(this.m_globalPolygonSize);
        } else if (this.m_polygonSize.getSize() != this.m_maxNumPolygons) {
            this.m_polygonSize.setSize(this.m_maxNumPolygons);
        }
    }

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.setPolygon(this.m_numPolygons - 1, piVector);
        return this.m_numPolygons - 1;
    }

    public PiVector getPolygon(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygon[n];
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (n < 0) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " >= " + this.m_numPolygons + "=m_numPolygons, bad programming style", this);
            this.setNumPolygons(n + 1);
        }
        int n2 = piVector.getSize();
        this.m_polygon[n].setSize(n2);
        this.m_polygon[n].copy(piVector);
        if (this.m_dimOfPolygons != n2) {
            this.m_dimOfPolygons = -1;
        }
        return true;
    }

    public void setElements(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_element = piVectorArray;
            if (this.m_maxNumElements != piVectorArray.length) {
                this.setMaxNumElements(piVectorArray.length);
            }
            return;
        }
        int n = 0;
        int n2 = piVectorArray[0].getSize();
        if (n2 < 3) {
            n2 = -1;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            int n3 = piVectorArray[i].getSize();
            if (n3 > this.m_maxDimOfElements) {
                n = n3;
                n3 = this.m_maxDimOfElements;
            }
            if (n3 != this.m_element[i].getSize()) {
                this.m_element[i].setSize(n3);
                if (this.m_neighbour != null) {
                    this.m_neighbour[i].setSize(n3);
                }
            }
            if (n2 == -1 || n3 == n2) continue;
            n2 = -1;
        }
        if (this.m_dimOfElements != n2) {
            this.setDimOfElements(n2);
        }
        PiVector.copy(this.m_element, 0, piVectorArray, 0, this.m_numElements);
        if (n > 0) {
            PsDebug.error("maximal dimension of an element = " + n + " truncated to size = " + this.m_maxDimOfElements);
        }
    }

    public void setElementColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_elementColor = colorArray;
            return;
        }
        this.assureElementColors();
        PdColor.copy(this.m_elementColor, 0, colorArray, 0, this.m_numElements);
    }

    public void setElementBackColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_elementBackColor = colorArray;
            return;
        }
        this.assureElementBackColors();
        PdColor.copy(this.m_elementBackColor, 0, colorArray, 0, this.m_numElements);
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_elementNormal = pdVectorArray;
            return;
        }
        this.assureElementNormals();
        PdVector.copy(this.m_elementNormal, 0, pdVectorArray, 0, this.m_numElements);
    }

    public void setElementTextures(PdVector[][] pdVectorArray) {
        int n;
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_elementTexture = pdVectorArray;
            return;
        }
        for (n = 0; n < this.m_numElements; ++n) {
            if (pdVectorArray[n] != null && pdVectorArray[n].length == this.m_element[n].getSize()) continue;
            PsDebug.warning("void length of texCoords[" + n + "]");
            return;
        }
        this.assureElementTextures();
        for (n = 0; n < this.m_numElements; ++n) {
            PdVector.copy(this.m_elementTexture[n], 0, pdVectorArray[n], 0, this.m_element[n].getSize());
        }
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_neighbour = piVectorArray;
            return;
        }
        this.assureNeighbours();
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
    }

    public int addElement(PiVector piVector) {
        this.setNumElements(this.m_numElements + 1);
        this.setElement(this.m_numElements - 1, piVector);
        return this.m_numElements - 1;
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_element[n];
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        int n2 = piVector.getSize();
        if (n2 > this.m_maxDimOfElements) {
            n2 = this.m_maxDimOfElements;
            PsDebug.error("maximal dimension of element = " + n2 + " truncated to size = " + this.m_maxDimOfElements);
        }
        this.setDimOfElement(n, n2);
        this.m_element[n].copy(piVector);
        return true;
    }

    public boolean isEnabledIndexLabels() {
        return this.m_bEnabledIndexLabels;
    }

    public boolean isDefaultLabelEnabled() {
        return this.isEnabledIndexLabels();
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public boolean isShowingVertexSizes() {
        return this.m_bShowVertexSizes;
    }

    public boolean isShowingSilhouette() {
        return this.m_bShowSilhouette;
    }

    public void showSilhouette(boolean bl) {
        this.m_bShowSilhouette = bl;
    }

    public boolean isShowingVertexOutline() {
        return this.m_bShowVertexOutline;
    }

    public void showVertexOutline(boolean bl) {
        this.m_bShowVertexOutline = bl;
    }

    public boolean isShowingTaggedVertices() {
        return this.m_bShowTaggedVertices;
    }

    public void showTaggedVertices(boolean bl) {
        this.m_bShowTaggedVertices = bl;
    }

    public void setEnabledIndexLabels(boolean bl) {
        this.m_bEnabledIndexLabels = bl;
    }

    public void setDefaultLabelEnabled(boolean bl) {
        this.setEnabledIndexLabels(bl);
    }

    public void showIndices(boolean bl) {
        this.m_bShowIndices = bl;
    }

    public void showVertexLabels(boolean bl) {
        this.m_bShowVertexLabels = bl;
    }

    public void showPolygonLabels(boolean bl) {
        this.m_bShowPolygonLabels = bl;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public void showElementLabels(boolean bl) {
        this.m_bShowElementLabels = bl;
    }

    public void showVertices(boolean bl) {
        this.m_bShowVertices = bl;
    }

    public void showVertexColors(boolean bl) {
        this.m_bShowVertexColors = bl;
    }

    public void showVertexNormals(boolean bl) {
        this.m_bShowVertexNormals = bl;
    }

    public void showVertexNormalArrow(boolean bl) {
        this.m_bShowVertexNormalArrow = bl;
    }

    public void showVertexSizes(boolean bl) {
        this.m_bShowVertexSizes = bl;
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public boolean isShowingPolygonSizes() {
        return this.m_bShowPolygonSizes;
    }

    public boolean isShowingTaggedPolygons() {
        return this.m_bShowTaggedPolygons;
    }

    public void showTaggedPolygons(boolean bl) {
        this.m_bShowTaggedPolygons = bl;
    }

    public void showPolygons(boolean bl) {
        this.m_bShowPolygons = bl;
    }

    public void showPolygonNormals(boolean bl) {
        this.m_bShowPolygonNormals = bl;
    }

    public void showPolygonNormalArrow(boolean bl) {
        this.m_bShowPolygonNormalArrow = bl;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public void showPolygonSizes(boolean bl) {
        this.m_bShowPolygonSizes = bl;
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public boolean isShowingEdgeColorFromElements() {
        return this.m_bShowEdgeColorFromElements;
    }

    public void showEdgeColorFromElements(boolean bl) {
        this.m_bShowEdgeColorFromElements = bl;
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromVertices() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeColorFromVertices(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public boolean isShowingSmoothElementColors() {
        return this.m_bShowSmoothElementColors;
    }

    public void showSmoothElementColors(boolean bl) {
        this.m_bShowSmoothElementColors = bl;
    }

    public boolean isShowingElementFromVertexColors() {
        return this.m_bShowElementColorFromVertices;
    }

    public void showElementFromVertexColors(boolean bl) {
        this.m_bShowElementColorFromVertices = bl;
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public boolean isShowingElementTexture() {
        return this.m_bShowElementTexture;
    }

    public boolean isShowingTaggedElements() {
        return this.m_bShowTaggedElements;
    }

    public void showTaggedElements(boolean bl) {
        this.m_bShowTaggedElements = bl;
    }

    public void showElements(boolean bl) {
        this.m_bShowElements = bl;
    }

    public void showBackface(boolean bl) {
        if (this.m_bShowBackface == bl) {
            return;
        }
        this.m_bShowBackface = bl;
        if (!this.m_bShowBackface && this.m_elementNormal == null) {
            this.makeElementNormals();
        }
    }

    public void showElementNormals(boolean bl) {
        this.m_bShowElementNormals = bl;
    }

    public void showElementNormalArrow(boolean bl) {
        this.m_bShowElementNormalArrow = bl;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public void showElementBackColor(boolean bl) {
        this.m_bShowElementBackColor = bl;
    }

    public void showElementBackColors(boolean bl) {
        this.m_bShowElementBackColors = bl;
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void showVertexTexture(boolean bl) {
        this.m_bShowVertexTexture = bl;
    }

    public void showElementTexture(boolean bl) {
        this.m_bShowElementTexture = bl;
    }

    public int getTextureSide() {
        return this.m_textureSide;
    }

    public void setTextureSide(int n) {
        this.m_textureSide = n;
    }

    public boolean makeVertexNormals() {
        int n;
        if (this.m_numVertices < 1 || this.m_numElements < 1) {
            return false;
        }
        if (this.m_dim != 3) {
            return false;
        }
        this.assureVertexNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector.setConstant(this.m_vertexNormal, 0.0);
        for (n = 0; n < this.m_numElements; ++n) {
            int n2 = this.m_element[n].getSize();
            if (n2 < 3) continue;
            int[] nArray = this.m_element[n].m_data;
            PdVector pdVector4 = this.m_vertex[nArray[(-2 + n2) % n2]];
            PdVector pdVector5 = this.m_vertex[nArray[(-1 + n2) % n2]];
            pdVector.sub(pdVector5, pdVector4);
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[(i - 1 + n2) % n2];
                pdVector4 = pdVector5;
                pdVector5 = this.m_vertex[nArray[i]];
                pdVector2.sub(pdVector5, pdVector4);
                boolean bl = pdVector3.cross(pdVector, pdVector2);
                pdVector.copyArray(pdVector2);
                if (!bl || !pdVector3.normalize()) continue;
                this.m_vertexNormal[n3].add(pdVector3);
            }
        }
        for (n = 0; n < this.m_numVertices; ++n) {
            this.m_vertexNormal[n].normalize();
        }
        return true;
    }

    public boolean makeElementNormals() {
        int n;
        if (this.m_numElements < 1) {
            return false;
        }
        if (this.m_dim == 1 || this.m_dim == 2) {
            return false;
        }
        this.assureElementNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector.setConstant(this.m_elementNormal, 0.0);
        for (n = 0; n < this.m_numElements; ++n) {
            int n2 = this.m_element[n].getSize();
            for (int i = 0; i < n2; ++i) {
                PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[i]];
                PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(i + 1) % n2]];
                PdVector pdVector6 = this.m_vertex[this.m_element[n].m_data[(i + 2) % n2]];
                pdVector.sub(pdVector4, pdVector5);
                pdVector2.sub(pdVector6, pdVector5);
                pdVector3.cross(pdVector2, pdVector);
                if (!pdVector3.normalize()) continue;
                this.m_elementNormal[n].add(pdVector3);
            }
        }
        for (n = 0; n < this.m_numElements; ++n) {
            this.m_elementNormal[n].normalize();
        }
        return true;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_numElements; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[i].m_data), pdVectorArray[0]);
            if (this.m_dim == 1) {
                colorArray[i] = new Color((float)(pdVector.m_data[0] / dArray[0]), 0.0f, 0.0f);
                continue;
            }
            if (this.m_dim == 2) {
                colorArray[i] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), 0.0f);
                continue;
            }
            if (this.m_dim < 3) continue;
            colorArray[i] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), (float)(pdVector.m_data[2] / dArray[2]));
        }
        return true;
    }

    public void makeQuadrConn(int n, int n2, boolean bl, boolean bl2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (bl) {
            ++n3;
        }
        if (bl2) {
            ++n4;
        }
        int n5 = 0;
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * n3 * n4);
            for (int i = 0; i < n3; ++i) {
                int n6 = (i + 1) % n;
                for (int j = 0; j < n4; ++j) {
                    int n7 = (j + 1) % n2;
                    this.m_element[n5].m_data[0] = i * n2 + j;
                    this.m_element[n5].m_data[1] = n6 * n2 + j;
                    this.m_element[n5].m_data[2] = i * n2 + n7;
                    this.m_element[++n5].m_data[0] = i * n2 + n7;
                    this.m_element[n5].m_data[1] = n6 * n2 + j;
                    this.m_element[n5].m_data[2] = n6 * n2 + n7;
                    ++n5;
                }
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements(n3 * n4);
            for (int i = 0; i < n3; ++i) {
                int n8 = (i + 1) % n;
                for (int j = 0; j < n4; ++j) {
                    int n9 = (j + 1) % n2;
                    this.m_element[n5].m_data[0] = i * n2 + j;
                    this.m_element[n5].m_data[1] = n8 * n2 + j;
                    this.m_element[n5].m_data[2] = n8 * n2 + n9;
                    this.m_element[n5].m_data[3] = i * n2 + n9;
                    ++n5;
                }
            }
        }
    }

    public boolean makeElementFromVertexColors() {
        PsDebug.error("method no longer supported");
        return false;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        PsDebug.error("method no longer supported");
        return null;
    }
}

