/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;

public final class PsConsole
extends PsDialog
implements Runnable,
ItemListener {
    protected static final String HEADER_TEXT = "*** " + PsConfig.getMessage(28003) + " " + PsConfig.getProgram() + " *********\n" + "\t" + PsConfig.getProgramAndVersion() + ", " + PsConfig.getMessage(28004) + " " + PsConfig.getHomepage() + "\n" + "\t" + PsConfig.getMessage(28005) + " = " + PsConfig.getTopic() + "\n\n";
    protected Checkbox m_cNotify;
    protected Checkbox m_cWarning;
    protected Checkbox m_cError;
    protected TextArea m_textArea;
    private boolean bRunning;

    public PsConsole(Frame frame) {
        super(frame, PsConfig.getProgram() + " " + PsConfig.getMessage(15016), false);
        this.init();
    }

    public void init() {
        super.init();
        this.setLayout(new BorderLayout(5, 5));
        PsPanel psPanel = new PsPanel(new GridLayout(1, 3));
        psPanel.setInsetSizeHorizontal(5);
        this.add((Component)psPanel, "North");
        this.m_cNotify = new Checkbox(PsConfig.getMessage(24133));
        this.m_cNotify.addItemListener(this);
        this.m_cNotify.setState(PsDebug.isNotify());
        this.m_cNotify.setEnabled(false);
        psPanel.add(this.m_cNotify);
        this.m_cWarning = new Checkbox(PsConfig.getMessage(24134));
        this.m_cWarning.addItemListener(this);
        this.m_cWarning.setState(PsDebug.isWarning());
        psPanel.add(this.m_cWarning);
        this.m_cError = new Checkbox(PsConfig.getMessage(24135));
        this.m_cError.addItemListener(this);
        this.m_cError.setState(PsDebug.isError());
        psPanel.add(this.m_cError);
        this.m_textArea = this.getTextArea();
        this.add((Component)this.m_textArea, "Center");
        Panel panel = this.getBottomButtons(66);
        this.add((Component)panel, "South");
        this.pack();
    }

    public TextArea getTextArea() {
        if (this.m_textArea == null) {
            this.m_textArea = new TextArea(HEADER_TEXT, 50, 80, 0);
            this.m_textArea.setFont(new Font("Monospaced", 0, 12));
            this.m_textArea.setEditable(false);
        }
        return this.m_textArea;
    }

    public void append(StringBuffer stringBuffer) {
        if (this.getTextArea() == null) {
            System.out.println("PsDebug.append(): missing text area, msg = " + stringBuffer.toString());
            return;
        }
        this.m_textArea.append(stringBuffer.toString());
    }

    public void removeAll() {
        this.m_textArea.setText("");
    }

    public boolean update() {
        this.m_cNotify.setState(PsDebug.isNotify());
        this.m_cWarning.setState(PsDebug.isWarning());
        this.m_cError.setState(PsDebug.isError());
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cNotify) {
            PsDebug.setNotify(this.m_cNotify.getState());
        } else if (object == this.m_cWarning) {
            PsDebug.setWarning(this.m_cWarning.getState());
        } else if (object == this.m_cError) {
            PsDebug.setError(this.m_cError.getState());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bClear) {
            this.m_textArea.setText(HEADER_TEXT);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void run() {
        this.bRunning = true;
        if (this.bRunning) {
            try {
                Thread.sleep(PsDebug.getFlushInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PsDebug.flushMessages();
            return;
        }
    }

    protected void stop() {
        this.bRunning = false;
    }
}

