/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Font;
import java.awt.Frame;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsResource;
import jv.object.PsUtil;
import jv.object.PsViewerIf;

public final class PsConfig {
    protected static final String PROGRAM = "JavaView";
    protected static final String PROJECT = "Visual Geometry Pages";
    protected static final String VERSION = "4.09.011";
    protected static final String TOPIC = "scene graph in display, new parameter instBase, image source, visual studio project files removed.";
    protected static final String COPYRIGHT = "\u00a9 1996-2014";
    public static final String[] AUTHOR = new String[]{"Konrad Polthier", "Ulrich Reitebuch", "Konstantin Poelke", "Faniry Razafindrazaka"};
    public static final int NUM_OF_ARCHIVES = 5;
    public static final boolean JV_LITE = false;
    public static String[] CONTRIBUTOR;
    public static String HOMEPAGE;
    public static String EMAIL;
    public static String HELP_HTML;
    public static String FONTS_HTML;
    public static String JAVAVIEW_LOGO;
    private static String JAVAVIEW_ICON;
    private static String JAVAVIEW_LAUNCH;
    private static String JAVAVIEW_TOOLBAR;
    private static String JAVAVIEW_SCENEGRAPH;
    public static final int VERSION_DTD_JVX = 11;
    public static final int VERSION_DTD_JVD = 12;
    public static final int VERSION_DTD_JVR = 13;
    public static final int VERSION_DTD_JVF = 14;
    public static final int VERSION_DTD_JVV = 15;
    public static final int VERSION_DTD_JVA = 16;
    public static final int VERSION_DTD_LIC = 17;
    protected static final int[] m_versionDtdJvx;
    protected static final int[] m_versionDtdJvd;
    protected static final int[] m_versionDtdJvr;
    protected static final int[] m_versionDtdJvf;
    protected static final int[] m_versionDtdJvv;
    protected static final int[] m_versionDtdJva;
    protected static final int[] m_versionDtdLic;
    protected static Locale m_locale;
    protected static ResourceBundle[] m_messages;
    protected static String m_codeBase;
    protected static String m_instBase;
    protected static String m_userBase;
    protected static char m_fileSeparator;
    protected static boolean m_bStandAlone;
    protected static Applet m_applet;
    protected static Frame m_frame;
    protected static Frame m_dialogFrame;
    protected static boolean m_bIsInitialized;
    protected static PsViewerIf m_viewer;
    public static final int OS_WIN = 0;
    public static final int OS_IRIX = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_OTHER = 4;
    public static int m_osId;
    protected static String m_osName;
    protected static final int m_numFonts = 5;
    public static final int FONT_TEXT = 0;
    public static final int FONT_FIXED = 1;
    public static final int FONT_MENU = 2;
    public static final int FONT_HEADER2 = 3;
    public static final int FONT_HEADER4 = 4;
    protected static Font[] m_font;
    protected static String[][] m_fontName;
    protected static int[][] m_fontStyle;
    protected static int[][] m_fontSize;
    protected static int m_panelVersion;
    public static final int ARCHIVE_JV = 0;
    public static final int ARCHIVE_JVX = 1;
    public static final int ARCHIVE_VGP = 2;
    public static final int ARCHIVE_DEV = 3;
    public static final int ARCHIVE_DEV6 = 4;
    public static final String[] ARCHIVE_NAME;
    private static boolean[] m_bIsArchiveTested;
    private static boolean[] m_bHasArchive;
    public static final int NUM_OF_RESOURCES = 3;
    public static final String[] RESOURCE_NAME;

    public static boolean isApplication() {
        return m_bStandAlone;
    }

    public static void setApplication(boolean bl) {
        m_bStandAlone = bl;
    }

    public static Applet getApplet() {
        return m_applet;
    }

    public static Frame getFrame() {
        if (m_dialogFrame == null) {
            m_dialogFrame = new Frame(PsConfig.getProgramAndVersion());
        }
        return m_dialogFrame;
    }

    public static PsViewerIf getViewer() {
        return m_viewer;
    }

    public static void runGC() {
        PsConfig.runGC(1, 1);
    }

    public static void runGC(int n, int n2) {
        Runtime runtime = Runtime.getRuntime();
        try {
            for (int i = 0; i < n; ++i) {
                PsConfig._runGC(runtime, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void _runGC(Runtime runtime, int n) throws Exception {
        long l = runtime.totalMemory() - runtime.freeMemory();
        long l2 = Long.MAX_VALUE;
        for (int i = 0; l < l2 && i < n; ++i) {
            runtime.runFinalization();
            runtime.gc();
            Thread.yield();
            l2 = l;
            l = runtime.totalMemory() - runtime.freeMemory();
        }
    }

    public static void reset() {
        m_applet = null;
        m_frame = null;
        m_dialogFrame = null;
        m_viewer = null;
        m_bIsInitialized = false;
    }

    public static void init(Applet applet, PsViewerIf psViewerIf, Frame frame) {
        m_viewer = psViewerIf;
        PsConfig.init(applet, frame);
    }

    public static void init(Applet applet, Frame frame) {
        m_applet = applet;
        m_frame = frame;
        m_locale = Locale.ENGLISH;
        PsConfig.m_bIsArchiveTested[3] = true;
        PsConfig.setApplication(m_frame != null || applet == null);
        PsConfig.parseSystemProperties();
        String string = null;
        if (!PsConfig.isApplication()) {
            String string2 = m_applet.getAppletInfo();
            if (string2 != null) {
                string2 = string2.replace('\n', '\t');
                string2 = string2.replace('\r', '\n');
                PsDebug.message("*** Info of Current Applet ***\n\t" + string2, false);
            }
            URL uRL = m_applet.getCodeBase();
            PsConfig.setCodeBase(uRL.toString());
            string = applet.getParameter("language");
        } else {
            String string3;
            String string4 = null;
            try {
                string4 = System.getProperty("user.dir");
                if (string4 != null) {
                    string4 = PsUtil.assureFileSeparator(string4, true);
                    PsConfig.setUserBase(string4);
                }
                PsDebug.message("Property: userBase = " + string4, false);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            String string5 = PsConfig.getInstBase();
            if (PuString.isEmpty(string5)) {
                try {
                    string3 = System.getProperty("path.separator");
                    String string6 = System.getProperty("java.class.path");
                    if (string3 != null && string6 != null) {
                        String[] stringArray = PuString.splitString(string6, string3.charAt(0));
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n = stringArray[i].indexOf("jars" + m_fileSeparator + "javaview.jar");
                            if (n > -1) {
                                string5 = stringArray[i].substring(0, n);
                                break;
                            }
                            n = stringArray[i].indexOf("javaview.exe");
                            if (n <= -1) continue;
                            string5 = stringArray[i].substring(0, n);
                            break;
                        }
                        if (string5 != null) {
                            string5 = PsUtil.assureFileSeparator(string5, true);
                        }
                        PsDebug.message("Property: instBase = " + string5, false);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (PuString.isEmpty(string3 = PsConfig.getCodeBase())) {
                try {
                    string3 = System.getProperty("codebase");
                    PsDebug.message("Property: codebase = " + string3, false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (PuString.isEmpty(string3) && string5 != null) {
                    string3 = string5;
                }
                if (PuString.isEmpty(string3) && string4 != null) {
                    string3 = string4;
                }
                if (!PuString.isEmpty(string3)) {
                    PsConfig.setCodeBase(string3);
                }
            }
            try {
                string = System.getProperty("language");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string != null) {
            PsDebug.message("Argument: language = " + string, false);
        } else {
            string = "en";
        }
        PsConfig.setLanguage(string);
        if (!m_bIsInitialized && PsConfig.isApplication() && m_fileSeparator != '/') {
            HELP_HTML = PsUtil.assureFileSeparator(HELP_HTML, false);
            FONTS_HTML = PsUtil.assureFileSeparator(FONTS_HTML, false);
            JAVAVIEW_LOGO = PsUtil.assureFileSeparator(JAVAVIEW_LOGO, false);
            JAVAVIEW_ICON = PsUtil.assureFileSeparator(JAVAVIEW_ICON, false);
            JAVAVIEW_LAUNCH = PsUtil.assureFileSeparator(JAVAVIEW_LAUNCH, false);
            JAVAVIEW_TOOLBAR = PsUtil.assureFileSeparator(JAVAVIEW_TOOLBAR, false);
            JAVAVIEW_SCENEGRAPH = PsUtil.assureFileSeparator(JAVAVIEW_SCENEGRAPH, false);
        }
        m_bIsInitialized = true;
    }

    public static int[] getVersion(int n) {
        switch (n) {
            case 16: {
                return m_versionDtdJva;
            }
            case 12: {
                return m_versionDtdJvd;
            }
            case 14: {
                return m_versionDtdJvf;
            }
            case 13: {
                return m_versionDtdJvr;
            }
            case 15: {
                return m_versionDtdJvv;
            }
            case 11: {
                return m_versionDtdJvx;
            }
            case 17: {
                return m_versionDtdLic;
            }
        }
        PsDebug.warning("unknown version id = " + n);
        return null;
    }

    public static Locale getLocale() {
        if (m_locale == null) {
            return Locale.ENGLISH;
        }
        return m_locale;
    }

    private static void incrementPanelVersion() {
        ++m_panelVersion;
    }

    public static int getPanelVersion() {
        return m_panelVersion;
    }

    public static String getLanguage() {
        if (m_messages == null || m_messages[0] == null) {
            return "en";
        }
        return m_messages[0].getString("_language");
    }

    public static void setLanguage(String string) {
        PsConfig.incrementPanelVersion();
        if (string == null || string.equalsIgnoreCase("en")) {
            m_messages = null;
            return;
        }
        m_locale = Locale.ENGLISH;
        m_locale = string.equalsIgnoreCase("de") ? Locale.GERMAN : (string.equalsIgnoreCase("fr") ? Locale.FRENCH : (string.equalsIgnoreCase("zh") ? Locale.CHINESE : (string.equalsIgnoreCase("it") ? Locale.ITALIAN : (string.equalsIgnoreCase("jp") ? Locale.JAPANESE : new Locale(string, "")))));
        m_messages = new ResourceBundle[3];
        for (int i = 0; i < 3; ++i) {
            String string2 = "rsrc/Messages_" + RESOURCE_NAME[i];
            String string3 = string2 + "_" + string + ".properties";
            try {
                PsConfig.m_messages[i] = ResourceBundle.getBundle(string2, m_locale);
                if (m_messages[i] != null && !m_locale.getLanguage().equals(m_messages[i].getString("_language"))) {
                    PsConfig.m_messages[i] = null;
                }
                if (m_messages[i] != null) continue;
                String string4 = m_locale.getCountry();
                if (string4.length() != 0) {
                    string4 = "' and country '" + string4;
                }
                PsDebug.warning("Property file: " + string3);
                PsDebug.message("\twrong '_language' or '_country' key values in message file or no message file for language '" + m_locale.getLanguage() + string4 + "' found in /rsrc");
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                PsConfig.m_messages[i] = null;
                PsDebug.warning("missing property file for language = " + string);
                PsDebug.message("\tMust supply file: " + string3);
            }
        }
        if (m_messages[0] == null) {
            m_messages = null;
        }
    }

    public static boolean hasArchive(int n) {
        Class<?> clazz;
        if (n < 0 || n >= 5) {
            PsDebug.warning("Index of archive out of bounds, index = " + String.valueOf(n));
            return false;
        }
        if (m_bIsArchiveTested[n]) {
            return m_bHasArchive[n];
        }
        PsConfig.m_bIsArchiveTested[n] = true;
        String string = ARCHIVE_NAME[n] + ".rsrc.PsResource";
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        catch (SecurityException securityException) {
            clazz = null;
        }
        catch (Exception exception) {
            PsDebug.warning("failed with exception, className = " + string + "\n\tException = " + exception.toString() + ", Message = " + exception.getMessage());
            clazz = null;
        }
        PsConfig.m_bHasArchive[n] = clazz != null;
        return m_bHasArchive[n];
    }

    public static String getMessage(int n) {
        return PsConfig.getMessage(Integer.toString(n));
    }

    public static String getMessage(boolean bl, int n, String string) {
        if (!bl) {
            return PsConfig.getMessage(string);
        }
        return string;
    }

    public static String getMessage(String string) {
        String string2 = null;
        if (m_messages != null) {
            for (int i = 0; i < 3; ++i) {
                if (m_messages[i] == null) continue;
                try {
                    string2 = m_messages[i].getString(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 != null) break;
            }
        }
        if (string2 == null) {
            string2 = PsResource.getString(string);
        }
        return string2;
    }

    public static String getAuthors() {
        String string = AUTHOR[0];
        for (int i = 1; i < AUTHOR.length; ++i) {
            string = string + ", " + AUTHOR[i];
        }
        return string;
    }

    public static String[] getContributors() {
        CONTRIBUTOR = new String[]{"Felix K\u00e4lberer " + PsConfig.getMessage(true, 12000, "Long-time co-author of JavaView"), "Matthias Nieser " + PsConfig.getMessage(true, 12000, "Long-time co-author of JavaView"), "Klaus Hildebrandt " + PsConfig.getMessage(true, 12000, "Long-time co-author of JavaView"), "Eike Preuss " + PsConfig.getMessage(true, 12000, "Long-time co-author of JavaView"), "Samy Khadem-Al-Charieh " + PsConfig.getMessage(true, 12000, "Long-time co-author of JavaView"), "Peter Liepa " + PsConfig.getMessage(12019), "Steve Dugaro " + PsConfig.getMessage(12002) + ", " + PsConfig.getMessage(12003), "Axel Friedrich " + PsConfig.getMessage(12004), "Tom Dudziak " + PsConfig.getMessage(12005), "Ernest Friedman-Hill / Sandia National Labs " + PsConfig.getMessage(12006), "Darius Bacon " + PsConfig.getMessage(12007), "James R. Weeks and BioElectroMech JpegEncoder", "Jef Poskanzer " + PsConfig.getMessage(12008) + ", " + PsConfig.getMessage(12009)};
        return CONTRIBUTOR;
    }

    public static String getEmail() {
        return EMAIL;
    }

    public static String getHomepage() {
        return HOMEPAGE;
    }

    public static String getTopic() {
        return TOPIC;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static String getVersion() {
        int n = VERSION.lastIndexOf(".000");
        if (n == -1) {
            return VERSION;
        }
        return VERSION.substring(0, n);
    }

    public static String getJavaViewLogo() {
        return JAVAVIEW_LOGO;
    }

    public static String getImageIcon() {
        return JAVAVIEW_ICON;
    }

    public static String getImageLaunch() {
        return JAVAVIEW_LAUNCH;
    }

    public static String getImageToolbar() {
        return JAVAVIEW_TOOLBAR;
    }

    public static String getImageScenegraph() {
        return JAVAVIEW_SCENEGRAPH;
    }

    public static String getProgram() {
        return PROGRAM;
    }

    public static String getProgramAndVersion() {
        return PsConfig.getProgram() + " v" + PsConfig.getVersion();
    }

    public static String getProject() {
        return PROJECT;
    }

    public static String getOSName() {
        return m_osName;
    }

    public static int getOSId() {
        return m_osId;
    }

    private static void parseSystemProperties() {
        try {
            String string;
            m_osName = System.getProperty("os.name");
            if (m_osName != null) {
                if ((m_osName = m_osName.toLowerCase()).startsWith("win")) {
                    m_osId = 0;
                } else if (m_osName.startsWith("irix")) {
                    m_osId = 1;
                } else if (m_osName.startsWith("sun")) {
                    m_osId = 2;
                } else if (m_osName.startsWith("linux")) {
                    m_osId = 3;
                }
                m_font = null;
            }
            if (PsConfig.isApplication()) {
                String string2 = System.getProperty("file.separator");
                if (string2 == null) {
                    PsDebug.warning("no propKey obtained");
                } else if (string2.length() == 0) {
                    PsDebug.warning("empty propKey obtained");
                } else {
                    m_fileSeparator = string2.charAt(0);
                }
                String string3 = System.getProperty("archive.dev");
                if (string3 != null) {
                    PsConfig.m_bHasArchive[3] = true;
                    PsConfig.m_bIsArchiveTested[4] = false;
                }
            } else if (m_applet != null && (string = m_applet.getParameter("archive.dev")) != null) {
                PsConfig.m_bHasArchive[3] = true;
                PsConfig.m_bIsArchiveTested[4] = false;
            }
        }
        catch (SecurityException securityException) {
            System.out.println("... not succeeded to access OS.NAME !!!\nException = " + securityException.toString());
        }
    }

    public static Hashtable getProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        try {
            Properties properties = System.getProperties();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                hashtable.put(string.toLowerCase(), System.getProperty(string));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        hashtable.put("is_application", String.valueOf(PsConfig.isApplication()));
        if (!hashtable.containsKey("codebase")) {
            hashtable.put("codebase", PsConfig.getCodeBase());
        }
        return hashtable;
    }

    public static void parseArgs(String[] stringArray, Properties properties) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (stringArray.length > 0) {
            PsDebug.message(PsConfig.getMessage(33035) + ":", false);
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            PsDebug.message("\targ[" + i + "] = " + stringArray[i], false);
            String string2 = stringArray[i];
            if (string2.equals("<") && i + 1 < stringArray.length) {
                PsDebug.message("\targ[" + ++i + "] = " + stringArray[i], false);
                ((Hashtable)properties).put("stdin", stringArray[i]);
                continue;
            }
            if (string2.equals(">") && i + 1 < stringArray.length) {
                PsDebug.message("\targ[" + ++i + "] = " + stringArray[i], false);
                ((Hashtable)properties).put("stdout", stringArray[i]);
                continue;
            }
            int n = string2.indexOf(61);
            if (n > -1) {
                String string3 = string2.substring(0, n).toLowerCase();
                String string4 = string2.substring(n + 1);
                if (string4.startsWith("\"")) {
                    string4 = string4.substring(1);
                }
                if (string4.endsWith("\"")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                ((Hashtable)properties).put(string3, string4);
                continue;
            }
            if (string2.endsWith(".jvd")) {
                ((Hashtable)properties).put("displayfile", string2);
                continue;
            }
            string = string == null ? string2 : string + ";" + string2;
        }
        if (string != null) {
            ((Hashtable)properties).put("model", string);
        }
    }

    public static String getParameter(String string) {
        return System.getProperty(string.toLowerCase());
    }

    public static String getUserBase() {
        return m_userBase;
    }

    public static void setUserBase(String string) {
        m_userBase = string;
    }

    public static String getCodeBase() {
        return m_codeBase;
    }

    public static void setCodeBase(String string) {
        m_codeBase = string;
        if (m_codeBase == null) {
            PsDebug.message("codeBase = null", false);
            return;
        }
        if (m_codeBase.startsWith("file:")) {
            m_codeBase = PuString.replace(m_codeBase, "%20", " ");
        }
        m_codeBase = PsUtil.assureFileSeparator(m_codeBase, true);
        PsDebug.message("Assigned: codeBase = " + m_codeBase, false);
    }

    public static String getInstBase() {
        return m_instBase;
    }

    public static void setInstBase(String string) {
        m_instBase = string;
        if (m_instBase == null) {
            return;
        }
        m_instBase = PsUtil.assureFileSeparator(m_instBase, true);
        PsDebug.message("Assigned: instBase = " + m_instBase, false);
    }

    public static char getFileSeparator() {
        return m_fileSeparator;
    }

    public static Font getFont(int n) {
        if (n < 0 || n >= 5) {
            PsDebug.warning("type = " + n + " out of bounds.");
            n = 0;
        }
        if (m_font == null) {
            m_font = new Font[5];
        }
        if (m_font[n] == null) {
            PsConfig.m_font[n] = new Font(m_fontName[m_osId][n], m_fontStyle[m_osId][n], m_fontSize[m_osId][n]);
        }
        return m_font[n];
    }

    public static boolean setFont(int n, int n2, String string, int n3, int n4) {
        if (n2 < 0 || n2 >= 5) {
            PsDebug.warning("type = " + n2 + " out of bounds.");
            return false;
        }
        PsConfig.incrementPanelVersion();
        if (n == -1) {
            n = m_osId;
        }
        if (n < 0 || n >= m_fontName.length) {
            PsDebug.warning("os = " + n + " out of bounds.");
            return false;
        }
        if (string != null) {
            PsConfig.m_fontName[n][n2] = string;
        }
        if (n3 != -1) {
            PsConfig.m_fontStyle[n][n2] = n3;
        }
        if (n4 != -1) {
            PsConfig.m_fontSize[n][n2] = n4;
        }
        if (n == m_osId) {
            if (m_font == null) {
                m_font = new Font[5];
            }
            if (m_font[n2] != null) {
                PsConfig.m_font[n2] = new Font(m_fontName[m_osId][n2], m_fontStyle[m_osId][n2], m_fontSize[m_osId][n2]);
            }
        }
        return true;
    }

    public static final boolean isDev() {
        return m_bHasArchive[3];
    }

    static {
        HOMEPAGE = "www.javaview.de";
        EMAIL = "support@javaview.de";
        HELP_HTML = "jars/help.html";
        FONTS_HTML = "jars/systemFonts.html";
        JAVAVIEW_LOGO = "images/JavaViewLogo.gif";
        JAVAVIEW_ICON = "images/jvIcon.gif";
        JAVAVIEW_LAUNCH = "images/jvLaunch.jpg";
        JAVAVIEW_TOOLBAR = "rsrc/jvToolbar16.gif";
        JAVAVIEW_SCENEGRAPH = "rsrc/jvScenegraph14.gif";
        m_versionDtdJvx = new int[]{3, 1, 0};
        m_versionDtdJvd = new int[]{1, 10, 2};
        m_versionDtdJvr = new int[]{0, 99, 12};
        m_versionDtdJvf = new int[]{0, 0, 1};
        m_versionDtdJvv = new int[]{0, 0, 2};
        m_versionDtdJva = new int[]{0, 90, 1};
        m_versionDtdLic = new int[]{1, 0, 0};
        m_codeBase = null;
        m_instBase = null;
        m_userBase = null;
        m_fileSeparator = (char)47;
        m_bStandAlone = true;
        m_bIsInitialized = false;
        m_osId = 0;
        m_osName = null;
        m_font = new Font[5];
        m_fontName = new String[][]{{"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}};
        m_fontStyle = new int[][]{{0, 0, 1, 1, 1}, {0, 0, 1, 1, 1}, {0, 0, 1, 1, 1}, {0, 0, 1, 1, 1}, {0, 0, 1, 1, 1}};
        m_fontSize = new int[][]{{12, 12, 12, 14, 12}, {8, 8, 10, 10, 8}, {12, 12, 14, 14, 12}, {10, 10, 12, 12, 10}, {8, 8, 10, 10, 8}};
        m_panelVersion = 0;
        ARCHIVE_NAME = new String[]{"jv", "jvx", "vgp", "dev", "dev6"};
        m_bIsArchiveTested = new boolean[]{false, false, false, true, true};
        m_bHasArchive = new boolean[]{false, false, false, false, false};
        RESOURCE_NAME = ARCHIVE_NAME;
    }
}

