/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.P_Vector_CP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.objectGui.PsToolbarItem;
import jv.vecmath.PiVector;

public class PiArray_IP
extends PsPanel
implements ActionListener,
AdjustmentListener,
ItemListener {
    protected PiVector[] m_vector;
    protected Scrollbar m_scroll;
    protected Panel m_coordPanel;
    protected Panel m_configPanel;
    protected TextField[][] m_text;
    protected PsToolbarItem[] m_toolItem;
    protected Label[] m_headerLabel;
    protected Checkbox[] m_indexLabel;
    protected int m_index = 0;
    protected int m_shownDim = -1;
    protected int m_shownVectors = -1;
    protected int m_maxVisibleDim = 5;
    protected int m_maxVisibleVectors = 5;
    protected int m_minValue = Integer.MIN_VALUE;
    protected int m_maxValue = Integer.MAX_VALUE;
    static /* synthetic */ Class class$jv$number$PiArray_IP;

    public PiArray_IP(int n, int n2) {
        this.m_maxVisibleVectors = n;
        this.m_maxVisibleDim = n2;
        if (this.getClass() == (class$jv$number$PiArray_IP == null ? (class$jv$number$PiArray_IP = PiArray_IP.class$("jv.number.PiArray_IP")) : class$jv$number$PiArray_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setLayout(new PsSlotLayout(5));
        Panel panel = new Panel(new BorderLayout());
        this.add("1", panel);
        panel.add((Component)new Label(PsConfig.getMessage(24120), 1), "North");
        this.m_scroll = new Scrollbar(1);
        this.m_scroll.addAdjustmentListener(this);
        panel.add((Component)this.m_scroll, "West");
        PsPanel psPanel = new PsPanel(new GridLayout(this.m_maxVisibleVectors, 1));
        psPanel.setInsetSize(4);
        this.m_indexLabel = new Checkbox[this.m_maxVisibleVectors];
        for (int i = 0; i < this.m_maxVisibleVectors; ++i) {
            this.m_indexLabel[i] = new Checkbox(String.valueOf(i));
            this.m_indexLabel[i].addItemListener(this);
            psPanel.add(this.m_indexLabel[i]);
        }
        panel.add((Component)psPanel, "Center");
        psPanel = new PsPanel(new BorderLayout());
        this.add("4", psPanel);
        this.m_coordPanel = new Panel();
        psPanel.add((Component)this.m_coordPanel, "Center");
        this.m_configPanel = new Panel();
        psPanel.add((Component)this.m_configPanel, "East");
    }

    public boolean setNumOfEntries(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n = this.m_maxVisibleVectors;
        }
        if (n2 < 1) {
            n2 = this.m_maxVisibleDim;
        }
        if (this.m_shownDim == Math.min(this.m_maxVisibleDim, n2) && this.m_shownVectors == Math.min(this.m_maxVisibleVectors, n)) {
            return true;
        }
        if (n2 > this.m_maxVisibleDim) {
            // empty if block
        }
        this.m_coordPanel.removeAll();
        this.m_shownVectors = Math.min(this.m_maxVisibleVectors, n);
        this.m_shownDim = Math.min(this.m_maxVisibleDim, n2);
        this.m_coordPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, this.m_shownDim));
        this.m_headerLabel = new Label[this.m_shownDim];
        for (n4 = 0; n4 < this.m_shownDim; ++n4) {
            this.m_headerLabel[n4] = new Label("", 1);
            this.m_coordPanel.add(this.m_headerLabel[n4]);
        }
        this.m_text = new TextField[this.m_maxVisibleVectors][];
        for (n3 = 0; n3 < this.m_maxVisibleVectors; ++n3) {
            this.m_text[n3] = new TextField[this.m_shownDim];
            for (n4 = 0; n4 < this.m_shownDim; ++n4) {
                this.m_text[n3][n4] = new TextField(10);
                this.m_text[n3][n4].addActionListener(this);
                this.m_coordPanel.add(this.m_text[n3][n4]);
            }
        }
        this.m_coordPanel.validate();
        this.m_configPanel.removeAll();
        this.m_configPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, 1));
        this.m_configPanel.add(new Label(""));
        this.m_toolItem = new PsToolbarItem[this.m_maxVisibleVectors];
        for (n3 = 0; n3 < this.m_maxVisibleVectors; ++n3) {
            this.m_toolItem[n3] = new PsToolbarItem(43);
            this.m_toolItem[n3].addActionListener(this);
            this.m_toolItem[n3].setChoice("Open configuration panel");
            this.m_configPanel.add(this.m_toolItem[n3]);
        }
        this.m_configPanel.validate();
        return true;
    }

    public void setBounds(int n, int n2) {
        if (n > n2) {
            return;
        }
        this.m_minValue = n;
        this.m_maxValue = n2;
    }

    public void setHeader(String[] stringArray) {
        if (stringArray == null) {
            PsDebug.warning("missing header labels");
            return;
        }
        for (int i = 0; i < this.m_shownDim; ++i) {
            this.m_headerLabel[i].setText(stringArray[i]);
        }
    }

    public void setVector(PiVector[] piVectorArray, String[] stringArray, int n, int n2) {
        if (n2 < 1) {
            n2 = this.m_maxVisibleDim;
        }
        if (stringArray == null || piVectorArray == null) {
            PsDebug.warning("missing or empty argument");
            return;
        }
        this.m_vector = piVectorArray;
        if (!this.setNumOfEntries(n, n2)) {
            PsDebug.error("invalid length", this);
            return;
        }
        if (this.m_index >= n - this.m_shownVectors) {
            this.m_index = Math.max(0, n - this.m_shownVectors);
        }
        this.m_scroll.setValues(this.m_index, 1, 0, Math.max(0, n - this.m_shownVectors + 1));
        for (int i = 0; i < this.m_shownDim; ++i) {
            PsPanel.setText(this.m_headerLabel[i], stringArray[i]);
        }
        this.updateContent();
    }

    private void updateContent() {
        int n;
        for (n = Math.max(0, this.m_shownVectors); n < this.m_maxVisibleVectors; ++n) {
            PsPanel.setLabel(this.m_indexLabel[n], "");
            PsPanel.setState(this.m_indexLabel[n], false);
        }
        if (this.m_vector != null && this.m_vector.length >= this.m_shownVectors + this.m_index) {
            for (n = 0; n < this.m_shownVectors; ++n) {
                PsPanel.setLabel(this.m_indexLabel[n], String.valueOf(n + this.m_index));
                PsPanel.setState(this.m_indexLabel[n], this.m_vector[n + this.m_index].hasTag(1));
            }
            PiArray_IP.fillTable(this.m_text, this.m_maxVisibleVectors, this.m_shownDim, this.m_vector, this.m_index, 0, this.m_shownVectors);
        }
    }

    protected static void fillTable(TextField[][] textFieldArray, int n, int n2, PiVector[] piVectorArray, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        if (piVectorArray != null) {
            n8 = Math.min(n, n5);
        }
        for (n7 = 0; n7 < n8; ++n7) {
            if (piVectorArray[n7 + n3] != null) {
                n9 = Math.min(n2, piVectorArray[n7 + n3].getSize());
            }
            for (n6 = 0; n6 < n9; ++n6) {
                int n10 = piVectorArray[n7 + n3].m_data[n6 + n4];
                PsPanel.setText(textFieldArray[n7][n6], String.valueOf(n10));
            }
            for (n6 = n9; n6 < n2; ++n6) {
                PsPanel.setText(textFieldArray[n7][n6], "");
            }
        }
        for (n7 = n8; n7 < n; ++n7) {
            for (n6 = n9; n6 < n2; ++n6) {
                PsPanel.setText(textFieldArray[n7][n6], "");
            }
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
    }

    public boolean update(Object object) {
        if (this.m_parent == null) {
            PsDebug.warning("missing parent");
            return true;
        }
        if (object == this.m_parent) {
            this.updateContent();
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.m_shownVectors; ++i) {
            PiVector piVector = this.m_vector[i + this.m_index];
            for (int j = 0; j < this.m_shownDim; ++j) {
                if (object != this.m_text[i][j]) continue;
                if (j >= piVector.getSize()) {
                    piVector.setSize(j + 1);
                    PsDebug.warning("empty field edited, j=" + j);
                }
                try {
                    int n = Integer.parseInt(this.m_text[i][j].getText());
                    if (this.m_minValue <= n && n <= this.m_maxValue) {
                        piVector.m_data[j] = n;
                    } else {
                        PsDebug.warning("value out of range = " + n);
                        PsPanel.setText(this.m_text[i][j], String.valueOf(piVector.m_data[j]));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + this.m_text[i][j].getText());
                    PsPanel.setText(this.m_text[i][j], String.valueOf(piVector.getEntry(j)));
                    return;
                }
                if (this.m_parent != null) {
                    this.m_parent.update(this);
                }
                return;
            }
            if (object != this.m_toolItem[i]) continue;
            P_Vector_CP p_Vector_CP = new P_Vector_CP(piVector);
            ((Component)p_Vector_CP).setVisible(true);
            if (p_Vector_CP.getUserAction() == 4) {
                this.m_parent.update(this);
            }
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.m_scroll) {
            if (this.m_index == this.m_scroll.getValue()) {
                return;
            }
            this.m_index = this.m_scroll.getValue();
            this.updateContent();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        for (int i = 0; i < this.m_shownVectors; ++i) {
            if (object != this.m_indexLabel[i]) continue;
            PiVector piVector = this.m_vector[i + this.m_index];
            if (this.m_indexLabel[i].getState()) {
                piVector.setTag(1);
            } else {
                piVector.clearTag(1);
            }
            if (this.m_parent != null) {
                this.m_parent.update(this);
            } else {
                PsDebug.warning("missing parent");
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

