/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgAbstractLoader;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgJvxLoader
extends PgAbstractLoader {
    private int m_jvVersion = Integer.MAX_VALUE;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgJvxLoader pgJvxLoader = new PgJvxLoader();
        PgJvxSrc[] pgJvxSrcArray = pgJvxLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pgJvxLoader = null;
        if (pgJvxSrcArray != null) {
            for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                String string2;
                if (pgJvxSrcArray[i] == null || (string2 = pgJvxSrcArray[i].getName()) != null && !string2.toLowerCase().startsWith("object_")) continue;
                String string3 = PsUtil.getFileBaseName(string);
                if (i == 0) {
                    pgJvxSrcArray[i].setName(string3);
                    continue;
                }
                pgJvxSrcArray[i].setName(string3 + "[" + i + "]");
            }
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parseRsrcTree(psXmlSrc);
        if (pgJvxSrcArray == null) {
            PsDebug.warning("failed to interpret JVX tree");
            return null;
        }
        return pgJvxSrcArray;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null) {
            PsDebug.warning("missing geometries.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write(writer, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("failed to write XML tree", iOException);
            return false;
        }
    }

    public String write(PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometries.");
            return null;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected PgJvxSrc[] parseRsrcTree(PsXmlSrc var1_1) {
        block363: {
            block355: {
                var2_2 = var1_1.getRootNode();
                if (var2_2 == null) {
                    PsDebug.warning("missing root node.");
                    return null;
                }
                if (var2_2.getType() == null || !var2_2.getType().equalsIgnoreCase("jvx-model")) {
                    PsDebug.warning("missing <jvx-model> element,\nthis is not a valid JavaView geometry file.");
                    return null;
                }
                var3_3 = PsXmlSrc.getRsrcNodes(var2_2, "meta");
                if (var3_3 != null && var3_3.length > 0) {
                    block2: for (var4_4 = 0; var4_4 < var3_3.length; ++var4_4) {
                        var5_6 = var3_3[var4_4].getAttribute("generator");
                        if (var5_6 != null && (var6_7 /* !! */  = var5_6).startsWith("JavaView v.")) {
                            var7_8 = var6_7 /* !! */ .substring(var6_7 /* !! */ .indexOf(".") + 1);
                            var8_9 /* !! */  = PuString.splitString((String)var7_8, '.');
                            if (var8_9 /* !! */  != null && var8_9 /* !! */ .length <= 3) {
                                for (var9_14 = 0; var9_14 < var8_9 /* !! */ .length; ++var9_14) {
                                    if (var9_14 == 0) {
                                        this.m_jvVersion = 100000 * Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                        continue;
                                    }
                                    if (var9_14 == 1) {
                                        this.m_jvVersion += 1000 * Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                        continue;
                                    }
                                    if (var9_14 != 2) continue;
                                    try {
                                        this.m_jvVersion += Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                        continue;
                                    }
                                    catch (NumberFormatException var10_15) {
                                        // empty catch block
                                    }
                                }
                            } else {
                                PsDebug.warning("void JavaView version information in meta tag, generator = " + (String)var6_7 /* !! */ );
                            }
                        }
                        if ((var5_6 = var3_3[var4_4].getAttribute("dtd")) == null || (var6_7 /* !! */  = PuString.splitString(var5_6, '.')) == null || var6_7 /* !! */ .length <= 0) continue;
                        var7_8 = new int[var6_7 /* !! */ .length];
                        for (var8_10 = 0; var8_10 < var6_7 /* !! */ .length; ++var8_10) {
                            var7_8[var8_10] = Integer.parseInt(var6_7 /* !! */ [var8_10]);
                        }
                        var8_9 /* !! */  = (String[])PsConfig.getVersion(11);
                        for (var9_14 = 0; var9_14 < Math.min(1, var6_7 /* !! */ .length); ++var9_14) {
                            if (var8_9 /* !! */ [var9_14] == var7_8[var9_14]) continue;
                            if (var8_9 /* !! */ [var9_14] > var7_8[var9_14]) continue block2;
                            PsDebug.message("Parsing a JVX file with jvx.dtd version=" + var5_6 + " which is newer than\n" + "\tversion=" + (int)var8_9 /* !! */ [0] + "." + (int)var8_9 /* !! */ [1] + "." + (int)var8_9 /* !! */ [2] + " implemented by the loader of this JavaView program." + "\n\tMight need to upgrade JavaView.", false);
                            continue block2;
                        }
                    }
                }
                var4_5 = null;
                var5_6 = null;
                var6_7 /* !! */  = PsXmlSrc.getRsrcNode(var2_2, "version");
                if (var6_7 /* !! */  == null) {
                    var4_5 = "0.0";
                    var5_6 = "dump";
                } else {
                    var4_5 = var6_7 /* !! */ .getContent();
                    var5_6 = var6_7 /* !! */ .getAttribute("type");
                }
                var7_8 = PsXmlSrc.getRsrc(var2_2, "title");
                var11_17 = null;
                var12_18 = new String[]{"tag", "name", "url", "detail"};
                var13_19 = PsXmlSrc.getRsrcNode(var2_2, "geometries");
                if (var13_19 == null) break block355;
                var14_20 /* !! */  = PsXmlSrc.getRsrcNodes(var13_19, "geometry");
                if (var14_20 /* !! */  == null || var14_20 /* !! */ .length == 0) {
                    return null;
                }
                var11_17 = new PgJvxSrc[var14_20 /* !! */ .length];
                for (var8_11 = 0; var8_11 < var11_17.length; ++var8_11) {
                    block356: {
                        block360: {
                            block362: {
                                block361: {
                                    block357: {
                                        block359: {
                                            block358: {
                                                var15_21 = new PgJvxSrc();
                                                var11_17[var8_11] = var15_21;
                                                var15_21.setVersion(var4_5);
                                                var15_21.setVersionType(var5_6);
                                                var15_21.setTitle((String)var7_8);
                                                var16_22 = var14_20 /* !! */ [var8_11].getAttribute("name");
                                                if (var16_22 != null) {
                                                    var15_21.setName((String)var16_22);
                                                }
                                                var15_21.setVisible(PgJvxLoader.parseVisibility(var14_20 /* !! */ [var8_11].getAttribute("visible")) != 0);
                                                var17_23 = null;
                                                if (var14_20 /* !! */ [var8_11].hasChild("labelAtt")) {
                                                    var18_24 = var14_20 /* !! */ [var8_11].getChild("labelAtt");
                                                    var17_23 = this.parseLabelAtt(var18_24);
                                                    if (var17_23 != null) {
                                                        var15_21.setLabelAttribute(5, (PiVector)var17_23);
                                                        var15_21.showName(var17_23.getEntry(5) == 1);
                                                        var19_25 = var18_24.getAttribute("name");
                                                        if (var19_25 != null) {
                                                            var15_21.setLabelFont(5, (String)var19_25);
                                                            var15_21.setLabelSize(5, var17_23.getEntry(6));
                                                            var15_21.setLabelStyle(5, var17_23.getEntry(7));
                                                        }
                                                    }
                                                    if (var18_24.hasChild("color")) {
                                                        var19_25 = PsXmlLoader.parseColorRGB(var18_24, "color");
                                                        var15_21.setLabelColor(5, (Color)var19_25);
                                                    }
                                                }
                                                if ((var18_24 = var14_20 /* !! */ [var8_11].getChild("material")) != null) {
                                                    var19_25 = var18_24.getAttribute("shading");
                                                    if (var19_25 != null && var19_25.equalsIgnoreCase("gouraud")) {
                                                        var15_21.showSmoothLighting(true);
                                                    } else {
                                                        var15_21.showSmoothLighting(false);
                                                    }
                                                    if (var18_24.hasChild("specular")) {
                                                        var20_26 = PsXmlLoader.parseColorRGB(var18_24.getChild("specular"), "color");
                                                        var15_21.setSpecularColor((Color)var20_26);
                                                    }
                                                    if ((var20_26 = var18_24.getChild("transparency")) != null) {
                                                        var21_27 = PsXmlSrc.getRsrcAsDouble(var18_24, "transparency");
                                                        var15_21.setTransparency(var21_27);
                                                        var23_28 = PgJvxLoader.parseVisibility(var20_26.getAttribute("visible"));
                                                        if (this.m_jvVersion < 280000 && var23_28 != 0) {
                                                            var15_21.showTransparency(true);
                                                        } else {
                                                            var15_21.showTransparency(var23_28 == 1);
                                                        }
                                                    }
                                                }
                                                var20_26 = null;
                                                var21_27 = 0.0;
                                                var26_38 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "pointSet");
                                                if (var26_38 != null) {
                                                    var27_39 = var26_38.getAttribute("dim");
                                                    if (var27_39 == null) {
                                                        PsDebug.warning("missing dimension of geometry[" + var8_11 + "]");
                                                        return null;
                                                    }
                                                    var15_21.setDimOfVertices(Integer.parseInt((String)var27_39));
                                                    var15_21.showVertices(PgJvxLoader.parseVisibility(var26_38.getAttribute("point")) != 0);
                                                    var15_21.showVertexColors(PgJvxLoader.parseVisibility(var26_38.getAttribute("color")) == 1);
                                                    var15_21.showVertexNormals(PgJvxLoader.parseVisibility(var26_38.getAttribute("normal")) == 1);
                                                    var15_21.showVertexNormalArrow(PgJvxLoader.parseVisibility(var26_38.getAttribute("normalArrow")) == 1);
                                                    var15_21.showVertexSizes(PgJvxLoader.parseVisibility(var26_38.getAttribute("thicknesses")) == 1);
                                                    var15_21.showTaggedVertices(PgJvxLoader.parseVisibility(var26_38.getAttribute("pointMark")) != 0);
                                                    var15_21.showVertexOutline(PgJvxLoader.parseVisibility(var26_38.getAttribute("pointOutline")) != 0);
                                                    var15_21.setType(30);
                                                    var28_40 = PsXmlSrc.getRsrcNode(var26_38, "points");
                                                    if (var28_40 != null) {
                                                        var29_42 = PsXmlLoader.parseDoubleList(var28_40, "p", var12_18);
                                                        if (var29_42 != null) {
                                                            var15_21.setDimOfVertices(var29_42[0].getSize());
                                                            var15_21.setNumVertices(var29_42.length);
                                                            var15_21.setVertices(var29_42);
                                                        } else {
                                                            var30_46 = PgJvxLoader.parseFunList(var28_40, "pf", var12_18);
                                                            if (var30_46 != null) {
                                                                var15_21.setDimOfVertices(var30_46[0].length);
                                                                var15_21.setNumVertices(((String[][])var30_46).length);
                                                                var15_21.setVertexFunctions((String[][])var30_46);
                                                            }
                                                        }
                                                        if (var28_40.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble(var28_40, "thickness");
                                                            var15_21.setGlobalVertexSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB(var28_40, "color")) != null) {
                                                            var15_21.setGlobalVertexColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB(var28_40, "colorTag")) != null) {
                                                            var15_21.setGlobalVertexTagColor((Color)var20_26);
                                                        }
                                                        if (var28_40.hasChild("labelAtt")) {
                                                            var30_46 = var28_40.getChild("labelAtt");
                                                            v0 = var31_51 = PgJvxLoader.parseVisibility(var30_46.getAttribute("auto")) != 0;
                                                            if (!var31_51) {
                                                                var15_21.setEnabledIndexLabels(false);
                                                            }
                                                            if ((var17_23 = this.parseLabelAtt((PsXmlNode)var30_46)) != null) {
                                                                var15_21.setLabelAttribute(0, (PiVector)var17_23);
                                                                var15_21.showVertexLabels(var17_23.getEntry(5) == 1);
                                                                var32_54 = var30_46.getAttribute("name");
                                                                if (var32_54 != null) {
                                                                    var15_21.setLabelFont(0, (String)var32_54);
                                                                    var15_21.setLabelSize(0, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(0, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var30_46.hasChild("color")) {
                                                                var32_54 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_46, "color");
                                                                var15_21.setLabelColor(0, (Color)var32_54);
                                                            }
                                                        }
                                                    }
                                                    if ((var29_42 = PsXmlSrc.getRsrcNode(var26_38, "colors")) != null && (var23_29 = PsXmlLoader.parseColorList((PsXmlNode)var29_42, "c")) != null) {
                                                        var15_21.setVertexColors(var23_29);
                                                    }
                                                    if ((var30_46 = PsXmlSrc.getRsrcNode(var26_38, "normals")) != null) {
                                                        var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var30_46, "n", null);
                                                        if (var24_36 != null) {
                                                            var15_21.setVertexNormals(var24_36);
                                                        }
                                                        if (var30_46.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_46, "thickness");
                                                            var15_21.setGlobalVertexNormalSize(var21_27);
                                                        }
                                                        if (var30_46.hasChild("length")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_46, "length");
                                                            var15_21.setGlobalVertexNormalLength(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_46, "color")) != null) {
                                                            var15_21.setGlobalVertexNormalColor((Color)var20_26);
                                                        }
                                                    }
                                                    if ((var31_50 = PsXmlSrc.getRsrcNode(var26_38, "textures")) != null) {
                                                        var32_54 = var31_50.getAttribute("blend");
                                                        if (var32_54 != null) {
                                                            if (var32_54.equals("replace")) {
                                                                var15_21.setBlendingMode(0);
                                                            } else if (var32_54.equals("material")) {
                                                                var15_21.setBlendingMode(1);
                                                            } else if (var32_54.equals("alpha")) {
                                                                var15_21.setBlendingMode(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: blend = " + (String)var32_54);
                                                            }
                                                        } else {
                                                            var15_21.setBlendingMode(0);
                                                        }
                                                        var33_59 = var31_50.getAttribute("filter");
                                                        if (var33_59 != null) {
                                                            if (var33_59.equals("direct")) {
                                                                var15_21.setFilterType(0);
                                                            } else if (var33_59.equals("linear")) {
                                                                var15_21.setFilterType(1);
                                                            } else if (var33_59.equals("quadratic")) {
                                                                var15_21.setFilterType(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: filter = " + (String)var33_59);
                                                            }
                                                        } else {
                                                            var15_21.setFilterType(0);
                                                        }
                                                        var34_65 = var31_50.getAttribute("side");
                                                        if (var34_65 != null) {
                                                            if (var34_65.equals("both")) {
                                                                var15_21.setTextureSide(3);
                                                            } else if (var34_65.equals("front")) {
                                                                var15_21.setTextureSide(1);
                                                            } else if (var34_65.equals("back")) {
                                                                var15_21.setTextureSide(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: side = " + (String)var34_65);
                                                            }
                                                        } else {
                                                            var15_21.setTextureSide(3);
                                                        }
                                                        var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var31_50, "t", null);
                                                        if (var24_36 != null) {
                                                            var15_21.setVertexTextures(var24_36);
                                                        }
                                                        if ((var35_66 = var31_50.getChild("image")) != null) {
                                                            var36_69 = PsXmlSrc.getRsrcNode((PsXmlNode)var35_66, "url");
                                                            if (var36_69 != null) {
                                                                var19_25 = var36_69.getContent();
                                                            } else {
                                                                var19_25 = var35_66.getContent();
                                                                if (var19_25 != null) {
                                                                    PsDebug.warning("Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                }
                                                            }
                                                            var37_74 = var35_66.getAttribute("repeat");
                                                            if (var37_74 != null) {
                                                                if ("no".equals(var37_74)) {
                                                                    var15_21.setTexturePeriodic(0);
                                                                } else if ("s".equals(var37_74)) {
                                                                    var15_21.setTexturePeriodic(1);
                                                                } else if ("t".equals(var37_74)) {
                                                                    var15_21.setTexturePeriodic(2);
                                                                } else if ("st".equals(var37_74)) {
                                                                    var15_21.setTexturePeriodic(3);
                                                                }
                                                            } else {
                                                                var15_21.setTexturePeriodic(0);
                                                            }
                                                            if (var19_25 != null) {
                                                                var15_21.setTextureImageName((String)var19_25);
                                                            }
                                                        }
                                                        if ((var36_69 = var31_50.getChild("imageCoords")) != null && (var37_74 = PsXmlLoader.parseDoubleList((PsXmlNode)var36_69, "p", null)) != null) {
                                                            var15_21.setTextureImageBnd((PdVector[])var37_74);
                                                        }
                                                        if ((var37_74 = var31_50.getChild("tiling")) != null) {
                                                            var38_77 = PsXmlLoader.parsePiVector((PsXmlNode)var37_74, null);
                                                            if (var38_77 != null && var38_77.getSize() == 2) {
                                                                var15_21.setTextureTiling(new Dimension(var38_77.getEntry(0), var38_77.getEntry(1)));
                                                            } else {
                                                                PsDebug.warning("Found texture <repeat> element with missing or invalid data.");
                                                            }
                                                        }
                                                    }
                                                    if ((var32_54 = PsXmlSrc.getRsrcNode(var26_38, "thicknesses")) != null && (var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var32_54, "th", null)) != null) {
                                                        var33_59 = new PdVector(var24_36.length);
                                                        for (var10_16 = 0; var10_16 < var24_36.length; ++var10_16) {
                                                            var33_59.setEntry(var10_16, var24_36[var10_16].getEntry(0));
                                                        }
                                                        var15_21.setVertexSizes((PdVector)var33_59);
                                                    }
                                                }
                                                if ((var27_39 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "polygon")) != null) {
                                                    var15_21.showPolygonStartArrow(PgJvxLoader.parseVisibility(var27_39.getAttribute("arrowStart")) == 1);
                                                    var15_21.showPolygonEndArrow(PgJvxLoader.parseVisibility(var27_39.getAttribute("arrow")) == 1);
                                                    var15_21.showPolygons(PgJvxLoader.parseVisibility(var27_39.getAttribute("edge")) != 0);
                                                    var28_41 = PgJvxLoader.parseVisibility(var27_39.getAttribute("color")) == 1;
                                                    v1 = var29_43 = PgJvxLoader.parseVisibility(var27_39.getAttribute("colorFromPoints")) == 1;
                                                    if (var29_43 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var29_43 = false;
                                                    }
                                                    var15_21.showPolygonColors(var28_41);
                                                    var15_21.showElementFromVertexColors(var29_43);
                                                    var15_21.showPolygonNormals(PgJvxLoader.parseVisibility(var27_39.getAttribute("normal")) == 1);
                                                    var15_21.showPolygonNormalArrow(PgJvxLoader.parseVisibility(var27_39.getAttribute("normalArrow")) == 1);
                                                    var15_21.showPolygonSizes(PgJvxLoader.parseVisibility(var27_39.getAttribute("thicknesses")) == 1);
                                                    var15_21.showSmoothElementColors(PgJvxLoader.parseVisibility(var27_39.getAttribute("colorSmooth")) == 1);
                                                    var15_21.showTaggedPolygons(PgJvxLoader.parseVisibility(var27_39.getAttribute("edgeMark")) != 0);
                                                    var15_21.setType(31);
                                                    var30_46 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_39, "edges");
                                                    if (var30_46 != null) {
                                                        var31_50 = PsXmlLoader.parseIntegerList((PsXmlNode)var30_46, "e", var12_18);
                                                        if (var31_50 != null) {
                                                            var15_21.setDimOfPolygons(-1);
                                                            var15_21.setNumPolygons(((Object)var31_50).length);
                                                            var15_21.setPolygons((PiVector[])var31_50);
                                                        }
                                                        if (var30_46.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_46, "thickness");
                                                            var15_21.setGlobalPolygonSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_46, "color")) != null) {
                                                            var15_21.setGlobalPolygonColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_46, "colorTag")) != null) {
                                                            var15_21.setGlobalPolygonTagColor((Color)var20_26);
                                                        }
                                                        if (var30_46.hasChild("labelAtt")) {
                                                            var32_54 = var30_46.getChild("labelAtt");
                                                            var17_23 = this.parseLabelAtt((PsXmlNode)var32_54);
                                                            if (var17_23 != null) {
                                                                var15_21.setLabelAttribute(2, (PiVector)var17_23);
                                                                var15_21.showPolygonLabels(var17_23.getEntry(5) == 1);
                                                                var33_59 = var32_54.getAttribute("name");
                                                                if (var33_59 != null) {
                                                                    var15_21.setLabelFont(2, (String)var33_59);
                                                                    var15_21.setLabelSize(2, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(2, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var32_54.hasChild("color")) {
                                                                var33_59 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_54, "color");
                                                                var15_21.setLabelColor(2, (Color)var33_59);
                                                            }
                                                        }
                                                    }
                                                    if ((var31_50 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_39, "colors")) != null) {
                                                        var23_30 = PsXmlLoader.parseColorList((PsXmlNode)var31_50, "c");
                                                        if (var23_30 != null) {
                                                            var15_21.setPolygonColors(var23_30);
                                                        }
                                                    } else if (var28_41 && !var29_43) {
                                                        PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual edge nor vertex colors.\n");
                                                        var29_43 = false;
                                                    }
                                                    if ((var32_54 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_39, "normals")) != null) {
                                                        var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var32_54, "n", null);
                                                        if (var24_36 != null) {
                                                            var15_21.setPolygonNormals(var24_36);
                                                        }
                                                        if (var32_54.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_54, "thickness");
                                                            var15_21.setGlobalPolygonNormalSize(var21_27);
                                                        }
                                                        if (var32_54.hasChild("length")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_54, "length");
                                                            var15_21.setGlobalPolygonNormalLength(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_54, "color")) != null) {
                                                            var15_21.setGlobalPolygonNormalColor((Color)var20_26);
                                                        }
                                                    }
                                                    if ((var33_59 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_39, "thicknesses")) != null && (var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var33_59, "th", null)) != null) {
                                                        var34_65 = new PdVector(var24_36.length);
                                                        for (var10_16 = 0; var10_16 < var24_36.length; ++var10_16) {
                                                            var34_65.setEntry(var10_16, var24_36[var10_16].getEntry(0));
                                                        }
                                                        var15_21.setPolygonSizes((PdVector)var34_65);
                                                    }
                                                }
                                                if ((var28_40 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "lineSet")) != null) {
                                                    var15_21.showPolygonStartArrow(PgJvxLoader.parseVisibility(var28_40.getAttribute("arrowStart")) == 1);
                                                    var15_21.showPolygonEndArrow(PgJvxLoader.parseVisibility(var28_40.getAttribute("arrow")) == 1);
                                                    var15_21.showPolygons(PgJvxLoader.parseVisibility(var28_40.getAttribute("line")) != 0);
                                                    var29_45 = PgJvxLoader.parseVisibility(var28_40.getAttribute("color")) == 1;
                                                    v2 = var30_47 = PgJvxLoader.parseVisibility(var28_40.getAttribute("colorFromPoints")) == 1;
                                                    if (var30_47 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var30_47 = false;
                                                    }
                                                    var15_21.showPolygonColors(var29_45);
                                                    var15_21.showElementFromVertexColors(var30_47);
                                                    if (!var29_45 && var30_47 && PgJvxLoader.parseVisibility(var28_40.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                        PsDebug.warning("Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                        var15_21.showPolygonColors(true);
                                                    }
                                                    var15_21.showPolygonNormals(PgJvxLoader.parseVisibility(var28_40.getAttribute("normal")) == 1);
                                                    var15_21.showPolygonNormalArrow(PgJvxLoader.parseVisibility(var28_40.getAttribute("normalArrow")) == 1);
                                                    var15_21.showPolygonSizes(PgJvxLoader.parseVisibility(var28_40.getAttribute("thicknesses")) == 1);
                                                    var15_21.showSmoothElementColors(PgJvxLoader.parseVisibility(var28_40.getAttribute("colorSmooth")) == 1);
                                                    var15_21.showTaggedPolygons(PgJvxLoader.parseVisibility(var28_40.getAttribute("lineMark")) != 0);
                                                    var15_21.setType(32);
                                                    var31_50 = PsXmlSrc.getRsrcNode(var28_40, "lines");
                                                    if (var31_50 != null) {
                                                        var32_54 = PsXmlLoader.parseIntegerList((PsXmlNode)var31_50, "l", var12_18);
                                                        if (var32_54 != null) {
                                                            var15_21.setDimOfPolygons(-1);
                                                            var15_21.setNumPolygons(((PiVector[])var32_54).length);
                                                            var15_21.setPolygons((PiVector[])var32_54);
                                                        }
                                                        if (var31_50.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var31_50, "thickness");
                                                            var15_21.setGlobalPolygonSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var31_50, "color")) != null) {
                                                            var15_21.setGlobalPolygonColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var31_50, "colorTag")) != null) {
                                                            var15_21.setGlobalPolygonTagColor((Color)var20_26);
                                                        }
                                                        if (var31_50.hasChild("labelAtt")) {
                                                            var33_59 = var31_50.getChild("labelAtt");
                                                            var17_23 = this.parseLabelAtt((PsXmlNode)var33_59);
                                                            if (var17_23 != null) {
                                                                var15_21.setLabelAttribute(2, (PiVector)var17_23);
                                                                var15_21.showPolygonLabels(var17_23.getEntry(5) == 1);
                                                                var34_65 = var33_59.getAttribute("name");
                                                                if (var34_65 != null) {
                                                                    var15_21.setLabelFont(2, (String)var34_65);
                                                                    var15_21.setLabelSize(2, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(2, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var33_59.hasChild("color")) {
                                                                var34_65 = PsXmlLoader.parseColorRGB((PsXmlNode)var33_59, "color");
                                                                var15_21.setLabelColor(2, (Color)var34_65);
                                                            }
                                                        }
                                                    }
                                                    if ((var32_54 = PsXmlSrc.getRsrcNode(var28_40, "colors")) != null) {
                                                        var23_31 = PsXmlLoader.parseColorList((PsXmlNode)var32_54, "c");
                                                        if (var23_31 != null) {
                                                            var15_21.setPolygonColors(var23_31);
                                                        }
                                                    } else if (var29_45 && !var30_47) {
                                                        PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual edge nor vertex colors.\n");
                                                        var30_47 = false;
                                                    }
                                                    if ((var33_59 = PsXmlSrc.getRsrcNode(var28_40, "normals")) != null) {
                                                        var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var33_59, "n", null);
                                                        if (var24_36 != null) {
                                                            var15_21.setPolygonNormals(var24_36);
                                                        }
                                                        if (var33_59.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var33_59, "thickness");
                                                            var15_21.setGlobalPolygonNormalSize(var21_27);
                                                        }
                                                        if (var33_59.hasChild("length")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var33_59, "length");
                                                            var15_21.setGlobalPolygonNormalLength(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var33_59, "color")) != null) {
                                                            var15_21.setGlobalPolygonNormalColor((Color)var20_26);
                                                        }
                                                    }
                                                    if ((var34_65 = PsXmlSrc.getRsrcNode(var28_40, "thicknesses")) != null && (var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var34_65, "th", null)) != null) {
                                                        var35_66 = new PdVector(var24_36.length);
                                                        for (var10_16 = 0; var10_16 < var24_36.length; ++var10_16) {
                                                            var35_66.setEntry(var10_16, var24_36[var10_16].getEntry(0));
                                                        }
                                                        var15_21.setPolygonSizes((PdVector)var35_66);
                                                    }
                                                }
                                                if ((var29_42 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "faceSet")) != null) {
                                                    var15_21.showElements(PgJvxLoader.parseVisibility(var29_42.getAttribute("face")) != 0);
                                                    var15_21.showEdges(PgJvxLoader.parseVisibility(var29_42.getAttribute("edge")) != 0);
                                                    var15_21.showElementNormals(PgJvxLoader.parseVisibility(var29_42.getAttribute("normal")) == 1);
                                                    var15_21.showElementNormalArrow(PgJvxLoader.parseVisibility(var29_42.getAttribute("normalArrow")) == 1);
                                                    var30_49 = PgJvxLoader.parseVisibility(var29_42.getAttribute("color")) == 1;
                                                    v3 = var31_52 = PgJvxLoader.parseVisibility(var29_42.getAttribute("colorFromPoints")) == 1;
                                                    if (var31_52 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var31_52 = false;
                                                    }
                                                    var15_21.showElementColors(var30_49);
                                                    var15_21.showElementFromVertexColors(var31_52);
                                                    if (!var30_49 && var31_52 && PgJvxLoader.parseVisibility(var29_42.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                        PsDebug.warning("Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                        var15_21.showElementColors(true);
                                                    }
                                                    var15_21.showElementBackColor(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorBackGlobal")) == 1);
                                                    var15_21.showElementBackColors(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorBackLocal")) == 1);
                                                    var15_21.showSmoothElementColors(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorSmooth")) == 1);
                                                    var15_21.showEdgeColors(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorEdge")) == 1);
                                                    var15_21.showEdgeColorFromElements(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorEdgeInduced")) == 1);
                                                    v4 = var32_55 = PgJvxLoader.parseVisibility(var29_42.getAttribute("colorEdgeFromPoints")) == 1;
                                                    if (var32_55 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorEdgeFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var32_55 = false;
                                                    }
                                                    var15_21.showEdgeColorFromVertices(var32_55);
                                                    var15_21.showSmoothEdgeColors(PgJvxLoader.parseVisibility(var29_42.getAttribute("colorEdgeSmooth")) == 1);
                                                    var33_60 = PgJvxLoader.parseVisibility(var29_42.getAttribute("backface")) != 0;
                                                    var15_21.showBackface(var33_60);
                                                    var15_21.showBoundaries(PgJvxLoader.parseVisibility(var29_42.getAttribute("boundary")) == 1);
                                                    var15_21.showSilhouette(PgJvxLoader.parseVisibility(var29_42.getAttribute("silhouette")) == 1);
                                                    var15_21.showTaggedElements(PgJvxLoader.parseVisibility(var29_42.getAttribute("faceMark")) != 0);
                                                    var15_21.setType(33);
                                                    var34_65 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "faces");
                                                    if (var34_65 != null) {
                                                        var35_66 = PsXmlLoader.parseIntegerList((PsXmlNode)var34_65, "f", var12_18);
                                                        if (var35_66 != null) {
                                                            var15_21.setDimOfElements(-1);
                                                            var15_21.setNumElements(((Serializable)var35_66).length);
                                                            var15_21.setElements((PiVector[])var35_66);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_65, "color")) != null) {
                                                            var15_21.setGlobalElementColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_65, "colorBack")) != null) {
                                                            var15_21.setGlobalElementBackColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_65, "colorTag")) != null) {
                                                            var15_21.setGlobalElementTagColor((Color)var20_26);
                                                        }
                                                        if (var34_65.hasChild("creaseAngle")) {
                                                            var36_70 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var34_65, "creaseAngle");
                                                            var15_21.setCreaseAngle(var36_70);
                                                        }
                                                        if (var34_65.hasChild("labelAtt")) {
                                                            var36_72 = var34_65.getChild("labelAtt");
                                                            var17_23 = this.parseLabelAtt(var36_72);
                                                            if (var17_23 != null) {
                                                                var15_21.setLabelAttribute(3, (PiVector)var17_23);
                                                                var15_21.showElementLabels(var17_23.getEntry(5) == 1);
                                                                var37_74 = var36_72.getAttribute("name");
                                                                if (var37_74 != null) {
                                                                    var15_21.setLabelFont(3, (String)var37_74);
                                                                    var15_21.setLabelSize(3, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(3, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var36_72.hasChild("color")) {
                                                                var37_74 = PsXmlLoader.parseColorRGB(var36_72, "color");
                                                                var15_21.setLabelColor(3, (Color)var37_74);
                                                            }
                                                        }
                                                    }
                                                    if ((var35_66 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "neighbours")) != null) {
                                                        var36_73 = PsXmlLoader.parseIntegerList((PsXmlNode)var35_66, "nb", null);
                                                        if (var36_73 != null) {
                                                            var15_21.setNeighbours(var36_73);
                                                        } else {
                                                            this.m_bIsEnabledOptimization = PgJvxLoader.parseVisibility(var35_66.getAttribute("auto")) == 1;
                                                        }
                                                    } else {
                                                        this.m_bIsEnabledOptimization = true;
                                                        PsDebug.message("JVX surface (name=" + var15_21.getName() + ") with no neighbour information found, identifying equal vertices.", false);
                                                    }
                                                    var36_69 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "edges");
                                                    if (var36_69 != null) {
                                                        var25_37 = PsXmlLoader.parseIntegerList((PsXmlNode)var36_69, "e", var12_18);
                                                        if (var25_37 != null) {
                                                            var15_21.setNumEdges(var25_37.length);
                                                            var15_21.setEdges(var25_37);
                                                        }
                                                        if (var36_69.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var36_69, "thickness");
                                                            var15_21.setGlobalEdgeSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var36_69, "color")) != null) {
                                                            var15_21.setGlobalEdgeColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var36_69, "colorTag")) != null) {
                                                            var15_21.setGlobalEdgeTagColor((Color)var20_26);
                                                        }
                                                        if (var36_69.hasChild("labelAtt")) {
                                                            var37_74 = var36_69.getChild("labelAtt");
                                                            var17_23 = this.parseLabelAtt((PsXmlNode)var37_74);
                                                            if (var17_23 != null) {
                                                                var15_21.setLabelAttribute(1, (PiVector)var17_23);
                                                                var15_21.showEdgeLabels(var17_23.getEntry(5) == 1);
                                                                var38_77 = var37_74.getAttribute("name");
                                                                if (var38_77 != null) {
                                                                    var15_21.setLabelFont(1, (String)var38_77);
                                                                    var15_21.setLabelSize(1, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(1, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var37_74.hasChild("color")) {
                                                                var38_77 = PsXmlLoader.parseColorRGB((PsXmlNode)var37_74, "color");
                                                                var15_21.setLabelColor(1, (Color)var38_77);
                                                            }
                                                        }
                                                    }
                                                    if ((var37_74 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "colors")) != null) {
                                                        var23_32 = PsXmlLoader.parseColorList((PsXmlNode)var37_74, "c");
                                                        if (var23_32 != null) {
                                                            var15_21.setElementColors(var23_32);
                                                        }
                                                    } else if (var30_49 && !var31_52) {
                                                        PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual element nor vertex colors.\n");
                                                        var31_52 = false;
                                                    }
                                                    if ((var38_77 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "colorsBack")) != null && (var23_33 = PsXmlLoader.parseColorList((PsXmlNode)var38_77, "c")) != null) {
                                                        var15_21.setElementBackColors(var23_33);
                                                    }
                                                    if ((var39_78 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "normals")) != null) {
                                                        var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var39_78, "n", null);
                                                        if (var24_36 != null) {
                                                            var15_21.setElementNormals(var24_36);
                                                        }
                                                        if (var39_78.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var39_78, "thickness");
                                                            var15_21.setGlobalElementNormalSize(var21_27);
                                                        }
                                                        if (var39_78.hasChild("length")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var39_78, "length");
                                                            var15_21.setGlobalElementNormalLength(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var39_78, "color")) != null) {
                                                            var15_21.setGlobalElementNormalColor((Color)var20_26);
                                                        }
                                                    } else if ((!var33_60 || var15_21.isShowingElementNormals()) && var15_21.getDimOfVertices() == 3) {
                                                        var15_21.makeElementNormals();
                                                    }
                                                    var40_81 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "textures");
                                                    v5 = var41_82 = PgJvxLoader.parseVisibility(var29_42.getAttribute("texture")) == 1;
                                                    if (var40_81 == null) {
                                                        var15_21.showVertexTexture(var41_82);
                                                    } else {
                                                        var15_21.showElementTexture(var41_82);
                                                        var42_84 = var40_81.getAttribute("blend");
                                                        if (var42_84 != null) {
                                                            if (var42_84.equals("replace")) {
                                                                var15_21.setBlendingMode(0);
                                                            } else if (var42_84.equals("material")) {
                                                                var15_21.setBlendingMode(1);
                                                            } else if (var42_84.equals("alpha")) {
                                                                var15_21.setBlendingMode(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: blend = " + (String)var42_84);
                                                            }
                                                        } else {
                                                            var15_21.setBlendingMode(0);
                                                        }
                                                        var43_86 = var40_81.getAttribute("filter");
                                                        if (var43_86 != null) {
                                                            if (var43_86.equals("direct")) {
                                                                var15_21.setFilterType(0);
                                                            } else if (var43_86.equals("linear")) {
                                                                var15_21.setFilterType(1);
                                                            } else if (var43_86.equals("quadratic")) {
                                                                var15_21.setFilterType(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: filter = " + (String)var43_86);
                                                            }
                                                        } else {
                                                            var15_21.setFilterType(0);
                                                        }
                                                        var44_88 = var40_81.getAttribute("side");
                                                        if (var44_88 != null) {
                                                            if (var44_88.equals("both")) {
                                                                var15_21.setTextureSide(3);
                                                            } else if (var44_88.equals("front")) {
                                                                var15_21.setTextureSide(1);
                                                            } else if (var44_88.equals("back")) {
                                                                var15_21.setTextureSide(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: side = " + (String)var44_88);
                                                            }
                                                        } else {
                                                            var15_21.setTextureSide(3);
                                                        }
                                                        var45_89 = PsXmlLoader.parseDoubleList((PsXmlNode)var40_81, "t", null);
                                                        var46_91 = var15_21.getNumElements();
                                                        if (var45_89 != null && var46_91 > 0) {
                                                            var15_21.assureElementTextures();
                                                            var47_94 = var15_21.getElementTextures();
                                                            var48_96 = 0;
                                                            var49_100 /* !! */  = var15_21.getElements();
                                                            for (var10_16 = 0; var10_16 < var46_91; ++var10_16) {
                                                                var50_101 = var49_100 /* !! */ [var10_16].getSize();
                                                                for (var51_103 = 0; var51_103 < var50_101; ++var51_103) {
                                                                    var47_94[var10_16][var51_103].copy(var45_89[var48_96++]);
                                                                }
                                                            }
                                                            if (var48_96 != var45_89.length) {
                                                                PsDebug.warning("element texture coordinates do not match elements.");
                                                                var15_21.setElementTextures(null);
                                                            } else {
                                                                var15_21.setVertexTextures(null);
                                                            }
                                                        }
                                                        if ((var47_94 = var40_81.getChild("image")) != null) {
                                                            var48_97 = PsXmlSrc.getRsrcNode((PsXmlNode)var47_94, "url");
                                                            if (var48_97 != null) {
                                                                var19_25 = var48_97.getContent();
                                                            } else {
                                                                var19_25 = var47_94.getContent();
                                                                if (var19_25 != null) {
                                                                    PsDebug.warning("Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                }
                                                            }
                                                            var49_100 /* !! */  = var47_94.getAttribute("repeat");
                                                            if (var49_100 /* !! */  != null) {
                                                                if ("no".equals(var49_100 /* !! */ )) {
                                                                    var15_21.setTexturePeriodic(0);
                                                                } else if ("s".equals(var49_100 /* !! */ )) {
                                                                    var15_21.setTexturePeriodic(1);
                                                                } else if ("t".equals(var49_100 /* !! */ )) {
                                                                    var15_21.setTexturePeriodic(2);
                                                                } else if ("st".equals(var49_100 /* !! */ )) {
                                                                    var15_21.setTexturePeriodic(3);
                                                                }
                                                            } else {
                                                                var15_21.setTexturePeriodic(0);
                                                            }
                                                            if (var19_25 != null) {
                                                                var15_21.setTextureImageName((String)var19_25);
                                                            }
                                                        }
                                                        if ((var48_98 = var40_81.getChild("imageCoords")) != null && (var49_100 /* !! */  = PsXmlLoader.parseDoubleList(var48_98, "p", null)) != null) {
                                                            var15_21.setTextureImageBnd((PdVector[])var49_100 /* !! */ );
                                                        }
                                                        if ((var49_100 /* !! */  = var40_81.getChild("tiling")) != null) {
                                                            var50_102 = PsXmlLoader.parsePiVector((PsXmlNode)var49_100 /* !! */ , null);
                                                            if (var50_102 != null && var50_102.getSize() == 2) {
                                                                var15_21.setTextureTiling(new Dimension(var50_102.getEntry(0), var50_102.getEntry(1)));
                                                            } else {
                                                                PsDebug.warning("Found texture <repeat> element with missing or invalid data.");
                                                            }
                                                        }
                                                    }
                                                    var42_84 = PsXmlSrc.getRsrcNode((PsXmlNode)var29_42, "boundaries");
                                                    if (var42_84 != null) {
                                                        if (var42_84.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var42_84, "thickness");
                                                            var15_21.setGlobalBndSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var42_84, "color")) != null) {
                                                            var15_21.setGlobalBndColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var42_84, "colorTag")) != null) {
                                                            var15_21.setGlobalBndTagColor((Color)var20_26);
                                                        }
                                                    }
                                                }
                                                if ((var30_46 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "tetraSet")) != null) {
                                                    var15_21.showElements(PgJvxLoader.parseVisibility(var30_46.getAttribute("face")) != 0);
                                                    var15_21.showEdges(PgJvxLoader.parseVisibility(var30_46.getAttribute("edge")) != 0);
                                                    var31_53 = PgJvxLoader.parseVisibility(var30_46.getAttribute("color")) == 1;
                                                    v6 = var32_57 = PgJvxLoader.parseVisibility(var30_46.getAttribute("colorFromPoints")) == 1;
                                                    if (var32_57 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var32_57 = false;
                                                    }
                                                    var15_21.showElementColors(var31_53);
                                                    var15_21.showElementFromVertexColors(var32_57);
                                                    var15_21.showSmoothElementColors(PgJvxLoader.parseVisibility(var30_46.getAttribute("colorSmooth")) == 1);
                                                    var15_21.showEdgeColors(PgJvxLoader.parseVisibility(var30_46.getAttribute("colorEdge")) == 1);
                                                    var15_21.showEdgeColorFromElements(PgJvxLoader.parseVisibility(var30_46.getAttribute("colorEdgeInduced")) == 1);
                                                    v7 = var32_57 = PgJvxLoader.parseVisibility(var30_46.getAttribute("colorEdgeFromPoints")) == 1;
                                                    if (var32_57 && var15_21.getVertexColors() == null) {
                                                        PsDebug.warning("Missing vertex colors, found <colorEdgeFromPoints> attribute but missing <color> section of pointSet.\n");
                                                        var32_57 = false;
                                                    }
                                                    var15_21.showEdgeColorFromVertices(var32_57);
                                                    var15_21.showSmoothEdgeColors(PgJvxLoader.parseVisibility(var30_46.getAttribute("colorEdgeSmooth")) == 1);
                                                    var15_21.showBoundaries(PgJvxLoader.parseVisibility(var30_46.getAttribute("boundary")) == 1);
                                                    var15_21.showTaggedElements(PgJvxLoader.parseVisibility(var30_46.getAttribute("tetraMark")) != 0);
                                                    var15_21.setType(34);
                                                    var33_62 = PsXmlSrc.getRsrcNode((PsXmlNode)var30_46, "tetras");
                                                    if (var33_62 != null) {
                                                        var34_65 = PsXmlLoader.parseIntegerList(var33_62, "tet", var12_18);
                                                        if (var34_65 != null) {
                                                            var15_21.setNumElements(((PiVector[])var34_65).length);
                                                            var15_21.setElements((PiVector[])var34_65);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB(var33_62, "color")) != null) {
                                                            var15_21.setGlobalElementColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB(var33_62, "colorTag")) != null) {
                                                            var15_21.setGlobalElementTagColor((Color)var20_26);
                                                        }
                                                        if (var33_62.hasChild("labelAtt")) {
                                                            var35_66 = var33_62.getChild("labelAtt");
                                                            var17_23 = this.parseLabelAtt((PsXmlNode)var35_66);
                                                            if (var17_23 != null) {
                                                                var15_21.setLabelAttribute(3, (PiVector)var17_23);
                                                                var15_21.showElementLabels(var17_23.getEntry(5) == 1);
                                                                var36_69 = var35_66.getAttribute("name");
                                                                if (var36_69 != null) {
                                                                    var15_21.setLabelFont(3, (String)var36_69);
                                                                    var15_21.setLabelSize(3, var17_23.getEntry(6));
                                                                    var15_21.setLabelStyle(3, var17_23.getEntry(7));
                                                                }
                                                            }
                                                            if (var35_66.hasChild("color")) {
                                                                var36_69 = PsXmlLoader.parseColorRGB((PsXmlNode)var35_66, "color");
                                                                var15_21.setLabelColor(3, (Color)var36_69);
                                                            }
                                                        }
                                                    }
                                                    if ((var34_65 = PsXmlSrc.getRsrcNode((PsXmlNode)var30_46, "neighbours")) != null) {
                                                        var35_66 = PsXmlLoader.parseIntegerList((PsXmlNode)var34_65, "nb", null);
                                                        if (var35_66 != null) {
                                                            var15_21.setNeighbours((PiVector[])var35_66);
                                                        } else {
                                                            this.m_bIsEnabledOptimization = PgJvxLoader.parseVisibility(var34_65.getAttribute("auto")) == 1;
                                                        }
                                                    } else {
                                                        this.m_bIsEnabledOptimization = true;
                                                        PsDebug.message("JVX surface (name=" + var15_21.getName() + ") with no neighbour information found, identifying equal vertices.", false);
                                                    }
                                                    var35_66 = PsXmlSrc.getRsrcNode((PsXmlNode)var30_46, "colors");
                                                    if (var35_66 != null) {
                                                        var23_34 = PsXmlLoader.parseColorList((PsXmlNode)var35_66, "c");
                                                        if (var23_34 != null) {
                                                            var15_21.setElementColors(var23_34);
                                                        }
                                                    } else if (var31_53 && !var32_57) {
                                                        PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual element nor vertex colors.\n");
                                                        var32_57 = false;
                                                    }
                                                    var36_69 = PsXmlSrc.getRsrcNode((PsXmlNode)var30_46, "textures");
                                                    v8 = var37_75 = PgJvxLoader.parseVisibility(var30_46.getAttribute("texture")) == 1;
                                                    if (var36_69 == null) {
                                                        var15_21.showVertexTexture(var37_75);
                                                    } else {
                                                        var15_21.showElementTexture(var37_75);
                                                        var38_77 = var36_69.getAttribute("blend");
                                                        if (var38_77 != null) {
                                                            if (var38_77.equals("replace")) {
                                                                var15_21.setBlendingMode(0);
                                                            } else if (var38_77.equals("material")) {
                                                                var15_21.setBlendingMode(1);
                                                            } else if (var38_77.equals("alpha")) {
                                                                var15_21.setBlendingMode(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: blend = " + (String)var38_77);
                                                            }
                                                        } else {
                                                            var15_21.setBlendingMode(0);
                                                        }
                                                        var39_78 = var36_69.getAttribute("filter");
                                                        if (var39_78 != null) {
                                                            if (var39_78.equals("direct")) {
                                                                var15_21.setFilterType(0);
                                                            } else if (var39_78.equals("linear")) {
                                                                var15_21.setFilterType(1);
                                                            } else if (var39_78.equals("quadratic")) {
                                                                var15_21.setFilterType(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: filter = " + (String)var39_78);
                                                            }
                                                        } else {
                                                            var15_21.setFilterType(0);
                                                        }
                                                        var40_81 = var36_69.getAttribute("side");
                                                        if (var40_81 != null) {
                                                            if (var40_81.equals("both")) {
                                                                var15_21.setTextureSide(3);
                                                            } else if (var40_81.equals("front")) {
                                                                var15_21.setTextureSide(1);
                                                            } else if (var40_81.equals("back")) {
                                                                var15_21.setTextureSide(2);
                                                            } else {
                                                                PsDebug.warning("Unknown texture attribute: side = " + (String)var40_81);
                                                            }
                                                        } else {
                                                            var15_21.setTextureSide(3);
                                                        }
                                                        var41_83 = PsXmlLoader.parseDoubleList((PsXmlNode)var36_69, "t", null);
                                                        var42_85 = var15_21.getNumElements();
                                                        if (var41_83 != null && var42_85 > 0) {
                                                            var43_87 = var41_83[0].getSize();
                                                            var15_21.setDimOfTextures(var43_87);
                                                            var15_21.assureElementTextures();
                                                            var44_88 = var15_21.getElementTextures();
                                                            var45_90 = 0;
                                                            var46_92 = var15_21.getElements();
                                                            for (var10_16 = 0; var10_16 < var42_85; ++var10_16) {
                                                                var47_95 = var46_92[var10_16].getSize();
                                                                for (var48_99 = 0; var48_99 < var47_95; ++var48_99) {
                                                                    var44_88[var10_16][var48_99].copy(var41_83[var45_90++]);
                                                                }
                                                            }
                                                            if (var45_90 != var41_83.length) {
                                                                PsDebug.warning("element texture coordinates do not match elements.");
                                                                var15_21.setElementTextures(null);
                                                            } else {
                                                                var15_21.setVertexTextures(null);
                                                            }
                                                        }
                                                        if ((var43_86 = var36_69.getChild("image")) != null) {
                                                            var44_88 = PsXmlSrc.getRsrcNode((PsXmlNode)var43_86, "url");
                                                            if (var44_88 != null) {
                                                                var19_25 = var44_88.getContent();
                                                            } else {
                                                                var19_25 = var43_86.getContent();
                                                                if (var19_25 != null) {
                                                                    PsDebug.warning("Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                }
                                                            }
                                                            var45_89 = var43_86.getAttribute("repeat");
                                                            if (var45_89 != null) {
                                                                if ("no".equals(var45_89)) {
                                                                    var15_21.setTexturePeriodic(0);
                                                                } else if ("s".equals(var45_89)) {
                                                                    var15_21.setTexturePeriodic(1);
                                                                } else if ("t".equals(var45_89)) {
                                                                    var15_21.setTexturePeriodic(2);
                                                                } else if ("st".equals(var45_89)) {
                                                                    var15_21.setTexturePeriodic(3);
                                                                }
                                                            } else {
                                                                var15_21.setTexturePeriodic(0);
                                                            }
                                                            if (var19_25 != null) {
                                                                var15_21.setTextureImageName((String)var19_25);
                                                            }
                                                        }
                                                        if ((var44_88 = var36_69.getChild("imageCoords")) != null && (var45_89 = PsXmlLoader.parseDoubleList((PsXmlNode)var44_88, "p", null)) != null) {
                                                            var15_21.setTextureImageBnd(var45_89);
                                                        }
                                                        if ((var45_89 = var36_69.getChild("tiling")) != null) {
                                                            var46_93 = PsXmlLoader.parsePiVector((PsXmlNode)var45_89, null);
                                                            if (var46_93 != null && var46_93.getSize() == 2) {
                                                                var15_21.setTextureTiling(new Dimension(var46_93.getEntry(0), var46_93.getEntry(1)));
                                                            } else {
                                                                PsDebug.warning("Found texture <repeat> element with missing or invalid data.");
                                                            }
                                                        }
                                                    }
                                                    var38_77 = PsXmlSrc.getRsrcNode((PsXmlNode)var30_46, "boundaries");
                                                    if (var38_77 != null) {
                                                        if (var38_77.hasChild("thickness")) {
                                                            var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var38_77, "thickness");
                                                            var15_21.setGlobalBndSize(var21_27);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var38_77, "color")) != null) {
                                                            var15_21.setGlobalBndColor((Color)var20_26);
                                                        }
                                                        if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var38_77, "colorTag")) != null) {
                                                            var15_21.setGlobalBndTagColor((Color)var20_26);
                                                        }
                                                    }
                                                }
                                                if ((var31_50 = PsXmlSrc.getRsrcNodes(var14_20 /* !! */ [var8_11], "vectorField")) != null && ((PsXmlNode[])var31_50).length > 0) {
                                                    var15_21.setNumVectorFields(((PsXmlNode[])var31_50).length);
                                                    var15_21.showVectorFields(true);
                                                    for (var9_14 = 0; var9_14 < ((PsXmlNode[])var31_50).length; ++var9_14) {
                                                        var32_58 = var31_50[var9_14].getAttribute("name");
                                                        if (var32_58 != null) {
                                                            var15_21.setVectorFieldName(var9_14, var32_58);
                                                        }
                                                        if ((var33_63 = var31_50[var9_14].getAttribute("base")) != null) {
                                                            var15_21.setVectorElementBased(var9_14, var33_63.equals("element"));
                                                        }
                                                        var15_21.showVectorField(var9_14, PgJvxLoader.parseVisibility(var31_50[var9_14].getAttribute("vector")) != 0);
                                                        var15_21.showVectorFieldMaterials(var9_14, PgJvxLoader.parseVisibility(var31_50[var9_14].getAttribute("material")) != 0);
                                                        var15_21.showVectorArrows(var9_14, PgJvxLoader.parseVisibility(var31_50[var9_14].getAttribute("arrow")) == 1);
                                                        var15_21.showVectorColors(var9_14, PgJvxLoader.parseVisibility(var31_50[var9_14].getAttribute("color")) == 1);
                                                        var34_65 = PsXmlSrc.getRsrcNode((PsXmlNode)var31_50[var9_14], "vectors");
                                                        if (var34_65 != null) {
                                                            var24_36 = PsXmlLoader.parseDoubleList((PsXmlNode)var34_65, "v", var12_18);
                                                            if (var24_36 != null && (var35_67 = var24_36.length) > 0) {
                                                                var15_21.setNumVectors(var9_14, var35_67, var24_36[0].getSize());
                                                                var15_21.setVectors(var9_14, var24_36);
                                                            }
                                                            if (var34_65.hasChild("thickness")) {
                                                                var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var34_65, "thickness");
                                                                var15_21.setGlobalVectorSize(var9_14, var21_27);
                                                            }
                                                            if (var34_65.hasChild("length")) {
                                                                var21_27 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var34_65, "length");
                                                                var15_21.setGlobalVectorLength(var9_14, var21_27);
                                                            }
                                                            if ((var20_26 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_65, "color")) != null) {
                                                                var15_21.setGlobalVectorColor(var9_14, (Color)var20_26);
                                                            }
                                                        }
                                                        if ((var35_66 = PsXmlSrc.getRsrcNode((PsXmlNode)var31_50[var9_14], "colors")) == null || (var23_35 = PsXmlLoader.parseColorList((PsXmlNode)var35_66, "c")) == null) continue;
                                                        var15_21.setVectorColors(var9_14, var23_35);
                                                    }
                                                }
                                                if ((var32_54 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "center")) != null) {
                                                    var33_64 = var32_54.getAttribute("visible");
                                                    var15_21.showCenter(var33_64 == null || var33_64.equalsIgnoreCase("show") != false);
                                                    var34_65 = PsXmlLoader.parsePdVector((PsXmlNode)var32_54, "p", null);
                                                    var15_21.setCenter((PdVector)var34_65);
                                                }
                                                if ((var33_59 = PsXmlSrc.getRsrcNode(var14_20 /* !! */ [var8_11], "primitive")) != null) {
                                                    PsDebug.warning("parsing of primitives not implemented yet.");
                                                }
                                                if ((var34_65 = var14_20 /* !! */ [var8_11].getChild("transform")) == null) continue;
                                                if (var34_65.hasChild("modelMat") && (var35_66 = PsXmlLoader.parsePdMatrix((PsXmlNode)var34_65, "modelMat")) != null) {
                                                    var15_21.setModelMatrix((PdMatrix)var35_66);
                                                }
                                                if ((var35_66 = var34_65.getChild("ambient")) == null) continue;
                                                var36_69 = var35_66.getAttribute("dim");
                                                var37_76 = var35_66.getAttribute("space");
                                                var38_77 = var35_66.getAttribute("projection");
                                                if (var37_76 == null || var36_69 == null || var38_77 == null) break block356;
                                                var39_79 = Integer.parseInt((String)var36_69);
                                                if (!var37_76.equalsIgnoreCase("euclidean")) break block357;
                                                if (var39_79 == 1) {
                                                    var15_21.setAmbientSpace(0);
                                                } else if (var39_79 == 2) {
                                                    var15_21.setAmbientSpace(1);
                                                } else if (var39_79 == 3) {
                                                    var15_21.setAmbientSpace(3);
                                                } else if (var39_79 == 4) {
                                                    var15_21.setAmbientSpace(6);
                                                } else if (var39_79 == 5) {
                                                    var15_21.setAmbientSpace(9);
                                                } else {
                                                    PsDebug.warning("combination of ambient space and dimension not allowed");
                                                    return null;
                                                }
                                                if (!var38_77.equalsIgnoreCase("parallel")) break block358;
                                                var15_21.setAmbientProjection(0);
                                                break block356;
                                            }
                                            if (!var38_77.equalsIgnoreCase("stereographic")) break block359;
                                            var15_21.setAmbientProjection(1);
                                            break block356;
                                        }
                                        PsDebug.warning("combination of ambient space and projection not allowed");
                                        return null;
                                    }
                                    if (!var37_76.equalsIgnoreCase("spherical")) break block360;
                                    if (var39_79 == 2) {
                                        var15_21.setAmbientSpace(2);
                                    } else if (var39_79 == 3) {
                                        var15_21.setAmbientSpace(4);
                                    } else if (var39_79 == 4) {
                                        var15_21.setAmbientSpace(7);
                                    } else if (var39_79 == 5) {
                                        var15_21.setAmbientSpace(10);
                                    } else {
                                        PsDebug.warning("combination of ambient space and dimension not allowed");
                                        return null;
                                    }
                                    if (!var38_77.equalsIgnoreCase("parallel")) break block361;
                                    var15_21.setAmbientProjection(0);
                                    break block356;
                                }
                                if (!var38_77.equalsIgnoreCase("stereographic")) break block362;
                                var15_21.setAmbientProjection(1);
                                break block356;
                            }
                            PsDebug.warning("combination of ambient space and projection not allowed");
                            return null;
                        }
                        if (!var37_76.equalsIgnoreCase("hyperbolic")) ** GOTO lbl944
                        if (var39_79 == 3) {
                            var15_21.setAmbientSpace(5);
                        } else if (var39_79 == 4) {
                            var15_21.setAmbientSpace(8);
                        } else if (var39_79 == 5) {
                            var15_21.setAmbientSpace(11);
                        } else {
                            PsDebug.warning("combination of ambient space and dimension not allowed");
                            return null;
                        }
                        if (var38_77.equalsIgnoreCase("parallel")) {
                            var15_21.setAmbientProjection(0);
                        } else if (var38_77.equalsIgnoreCase("poincare")) {
                            var15_21.setAmbientProjection(1);
                        } else if (var38_77.equalsIgnoreCase("klein")) {
                            var15_21.setAmbientProjection(2);
                        } else if (var38_77.equalsIgnoreCase("uhs")) {
                            var15_21.setAmbientProjection(3);
                        } else {
                            PsDebug.warning("combination of ambient space and projection not allowed");
                            return null;
lbl944:
                            // 1 sources

                            if (var37_76.equalsIgnoreCase("lorentz")) {
                                PsDebug.warning("not implemented yet, ambient space = " + var37_76);
                                return null;
                            }
                            PsDebug.warning("unknown ambient space = " + var37_76);
                            return null;
                        }
                    }
                    var39_78 = PsXmlLoader.parsePdMatrix((PsXmlNode)var35_66, "ambientMat");
                    var40_81 = PsXmlLoader.parsePdMatrix((PsXmlNode)var35_66, "ambientInvMat");
                    if (var39_78 == null || var40_81 == null) continue;
                    var15_21.setAmbientMatrix((PdMatrix)var39_78, (PdMatrix)var40_81);
                }
                break block363;
            }
            PsDebug.warning("missing XML node <geometries>.");
        }
        var14_20 /* !! */  = PsXmlSrc.getRsrcNode(var2_2, "authors");
        var15_21 = null;
        if (var14_20 /* !! */  != null) {
            var15_21 = new PsAuthorInfo();
            var15_21.setXmlNode((PsXmlNode)var14_20 /* !! */ );
        }
        var16_22 = PsXmlSrc.getRsrcNode(var2_2, "description");
        var17_23 = null;
        if (var16_22 != null) {
            var17_23 = new PsGeometryInfo();
            var17_23.setXmlNode((PsXmlNode)var16_22, null);
        }
        if (var11_17 != null) {
            for (var8_13 = 0; var8_13 < var11_17.length; ++var8_13) {
                if (var15_21 != null) {
                    var11_17[var8_13].setAuthorInfo((PsAuthorInfo)var15_21);
                }
                if (var17_23 == null) continue;
                var11_17[var8_13].setGeometryInfo((PsGeometryInfo)var17_23);
            }
        }
        return var11_17;
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        Object object;
        Object object2;
        Serializable serializable;
        PsXmlNode psXmlNode;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            return null;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
            bl4 = this.m_geometryOption.get(3);
            bl5 = this.m_geometryOption.get(4);
            bl6 = this.m_geometryOption.get(5);
            bl7 = this.m_geometryOption.get(6);
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode = psXmlSrc.getRootNode()) == null) {
            psXmlNode = new PsXmlNode("jvx-model");
            psXmlSrc.setRootNode(psXmlNode);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvx-model");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jvx.dtd");
        if (bl) {
            serializable = psXmlNode.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("generator", PsConfig.getProgramAndVersion());
            serializable = psXmlNode.addChild("meta");
            object2 = PsConfig.getVersion(11);
            object = String.valueOf((int)object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf((int)object2[1]);
            if (object2[2] != false) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf((int)object2[2]);
            }
            ((PsXmlNode)serializable).addAttribute("dtd", (String)object);
            serializable = psXmlNode.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("date", new Date().toString());
            PsXmlNode psXmlNode2 = psXmlNode.addChild("version", pgJvxSrc.getVersion());
            psXmlNode2.addAttribute("type", pgJvxSrc.getVersionType());
            if (pgJvxSrc.getTitle() != null) {
                psXmlNode.addChild("title", pgJvxSrc.getTitle());
            } else {
                psXmlNode.addChild("title", pgJvxSrc.getName());
            }
        }
        if (bl2 && (serializable = pgJvxSrc.getAuthorInfo()) != null && ((PsAuthorInfo)serializable).getNumAuthors() > 0 && (object2 = ((PsAuthorInfo)serializable).getXmlNode()) != null) {
            psXmlNode.addChild((PsXmlNode)object2);
        }
        if (bl3 && (serializable = pgJvxSrc.getGeometryInfo()) != null && (object2 = ((PsGeometryInfo)serializable).getXmlNode()) != null) {
            psXmlNode.addChild((PsXmlNode)object2);
        }
        object2 = psXmlNode.addChild("geometries");
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            boolean bl8;
            Object object3;
            Object object4;
            int n;
            Object object5;
            Object object6;
            Serializable serializable2;
            Serializable serializable3;
            PdVector[] pdVectorArray;
            int n2;
            pgJvxSrc = pgJvxSrcArray[i];
            object = ((PsXmlNode)object2).addChild("geometry");
            ((PsXmlNode)object).addAttribute("name", pgJvxSrc.getName());
            if (!pgJvxSrc.isVisible()) {
                ((PsXmlNode)object).addAttribute("visible", "hide");
            }
            if ((n2 = pgJvxSrc.getType()) == -1) {
                PsDebug.error("geom = " + pgJvxSrc.getName() + " has unknown geometry type, JVX may not conform to jvx.dtd.");
                n2 = 30;
            }
            if (n2 == 30 || n2 == 31 || n2 == 32 || n2 == 33 || n2 == 34) {
                pdVectorArray = ((PsXmlNode)object).addChild("pointSet");
                pdVectorArray.addAttribute("dim", String.valueOf(pgJvxSrc.getDimOfVertices()));
                if (pgJvxSrc.isShowingVertices()) {
                    pdVectorArray.addAttribute("point", "show");
                } else {
                    pdVectorArray.addAttribute("point", "hide");
                }
                if (bl5 && pgJvxSrc.isShowingVertexColors() && pgJvxSrc.getVertexColors() != null) {
                    pdVectorArray.addAttribute("color", "show");
                }
                if (bl4 && pgJvxSrc.isShowingVertexNormals() && pgJvxSrc.getVertexNormals() != null) {
                    pdVectorArray.addAttribute("normal", "show");
                }
                if (bl4 && pgJvxSrc.isShowingVertexNormalArrow() && pgJvxSrc.getVertexNormals() != null) {
                    pdVectorArray.addAttribute("normalArrow", "show");
                }
                if (pgJvxSrc.isShowingVertexSizes() && pgJvxSrc.getVertexSizes() != null) {
                    pdVectorArray.addAttribute("thicknesses", "show");
                }
                if (!pgJvxSrc.isShowingTaggedVertices()) {
                    pdVectorArray.addAttribute("pointMark", "hide");
                }
                if (!pgJvxSrc.isShowingVertexOutline()) {
                    pdVectorArray.addAttribute("pointOutline", "hide");
                }
                serializable3 = pdVectorArray.addChild("points");
                PsXmlLoader.addVectorList((PsXmlNode)serializable3, "p", pgJvxSrc.getVertices(), pgJvxSrc.getNumVertices());
                ((PsXmlNode)serializable3).addChild("thickness", pgJvxSrc.getGlobalVertexSize());
                if (pgJvxSrc.getGlobalVertexColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalVertexColor());
                }
                if (pgJvxSrc.getGlobalVertexTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalVertexTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingVertexLabels() || !pgJvxSrc.isEnabledIndexLabels()) {
                    serializable2 = pgJvxSrc.getLabelAttribute(0);
                    object6 = null;
                    if (serializable2 != null) {
                        serializable2 = (PiVector)((PiVector)serializable2).clone();
                        ((PiVector)serializable2).setSize(8);
                        ((PiVector)serializable2).setEntry(5, 1);
                        ((PiVector)serializable2).setEntry(6, (int)pgJvxSrc.getLabelSize(0));
                        ((PiVector)serializable2).setEntry(7, pgJvxSrc.getLabelStyle(0));
                        object6 = PgJvxLoader.fillLabelAttr((PiVector)serializable2, pgJvxSrc.getLabelFont(0));
                    } else {
                        object6 = PgJvxLoader.fillLabelAttr(true);
                    }
                    if (!pgJvxSrc.isEnabledIndexLabels()) {
                        ((PsXmlNode)object6).addAttribute("auto", "hide");
                    }
                    PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getLabelColor(0));
                    ((PsXmlNode)serializable3).addChild((PsXmlNode)object6);
                }
                if (bl5 && pgJvxSrc.getVertexColors() != null) {
                    serializable2 = pdVectorArray.addChild("colors");
                    ((PsXmlNode)serializable2).addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "c", pgJvxSrc.getVertexColors(), pgJvxSrc.getNumVertices());
                }
                if (bl4 && pgJvxSrc.getVertexNormals() != null) {
                    serializable2 = pdVectorArray.addChild("normals");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "n", pgJvxSrc.getVertexNormals(), pgJvxSrc.getNumVertices());
                    ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalVertexNormalSize());
                    ((PsXmlNode)serializable2).addChild("length", pgJvxSrc.getGlobalVertexNormalLength());
                    if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalVertexNormalColor());
                    }
                }
                if (bl6 && pgJvxSrc.getVertexTextures() != null) {
                    serializable2 = pdVectorArray.addChild("textures");
                    ((PsXmlNode)serializable2).addAttribute("dim", String.valueOf(2));
                    if (pgJvxSrc.getBlendingMode() == 0) {
                        ((PsXmlNode)serializable2).addAttribute("blend", "replace");
                    } else if (pgJvxSrc.getBlendingMode() == 1) {
                        ((PsXmlNode)serializable2).addAttribute("blend", "material");
                    } else if (pgJvxSrc.getBlendingMode() == 2) {
                        ((PsXmlNode)serializable2).addAttribute("blend", "alpha");
                    }
                    if (pgJvxSrc.getFilterType() == 1) {
                        ((PsXmlNode)serializable2).addAttribute("filter", "linear");
                    } else if (pgJvxSrc.getFilterType() == 2) {
                        ((PsXmlNode)serializable2).addAttribute("filter", "quadratic");
                    }
                    if (pgJvxSrc.getTextureSide() == 1) {
                        ((PsXmlNode)serializable2).addAttribute("side", "front");
                    } else if (pgJvxSrc.getTextureSide() == 2) {
                        ((PsXmlNode)serializable2).addAttribute("side", "back");
                    }
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "t", pgJvxSrc.getVertexTextures(), pgJvxSrc.getNumVertices());
                    if (pgJvxSrc.getTextureImage() != null) {
                        object6 = ((PsXmlNode)serializable2).addChild("image");
                        object5 = pgJvxSrc.getTextureImageName();
                        if (object5 == null) {
                            PsDebug.warning("missing texture filename.");
                        }
                        ((PsXmlNode)object6).addChild("url", (String)object5);
                        n = pgJvxSrc.getTexturePeriodic();
                        if (n == 0) {
                            ((PsXmlNode)object6).addAttribute("repeat", "no");
                        } else if (n == 3) {
                            ((PsXmlNode)object6).addAttribute("repeat", "st");
                        } else if (n == 1) {
                            ((PsXmlNode)object6).addAttribute("repeat", "s");
                        } else if (n == 2) {
                            ((PsXmlNode)object6).addAttribute("repeat", "t");
                        }
                        object4 = pgJvxSrc.getTextureImageBnd();
                        if (object4[0].getEntry(0) != 0.0 || object4[0].getEntry(1) != 0.0 || object4[1].getEntry(0) != 1.0 || object4[1].getEntry(1) != 1.0) {
                            object3 = ((PsXmlNode)serializable2).addChild("imageCoords");
                            PsXmlLoader.addVectorList((PsXmlNode)object3, "p", (PdVector[])object4, 2);
                        }
                    }
                    object6 = pgJvxSrc.getTextureTiling();
                    ((PsXmlNode)serializable2).addChild("tiling", Integer.toString(((Dimension)object6).width) + " " + Integer.toString(((Dimension)object6).height));
                }
                if (pgJvxSrc.getVertexSizes() != null) {
                    serializable2 = pdVectorArray.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "th", pgJvxSrc.getVertexSizes(), pgJvxSrc.getNumVertices());
                }
            }
            if (n2 == 31) {
                pdVectorArray = ((PsXmlNode)object).addChild("polygon");
                if (pgJvxSrc.isShowingPolygons()) {
                    pdVectorArray.addAttribute("edge", "show");
                } else {
                    pdVectorArray.addAttribute("edge", "hide");
                }
                if (pgJvxSrc.isShowingPolygonStartArrow()) {
                    pdVectorArray.addAttribute("arrowStart", "show");
                }
                if (pgJvxSrc.isShowingPolygonEndArrow()) {
                    pdVectorArray.addAttribute("arrow", "show");
                }
                if (bl5 && pgJvxSrc.isShowingPolygonColors() && (pgJvxSrc.getPolygonColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                    pdVectorArray.addAttribute("color", "show");
                }
                if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                    pdVectorArray.addAttribute("colorFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                    pdVectorArray.addAttribute("colorSmooth", "show");
                }
                if (bl4 && pgJvxSrc.isShowingPolygonNormals()) {
                    pdVectorArray.addAttribute("normal", "show");
                }
                if (bl4 && pgJvxSrc.isShowingPolygonNormalArrow()) {
                    pdVectorArray.addAttribute("normalArrow", "show");
                }
                if (!pgJvxSrc.isShowingTaggedPolygons()) {
                    pdVectorArray.addAttribute("edgeMark", "hide");
                }
                if (pgJvxSrc.isShowingPolygonSizes() && pgJvxSrc.getPolygonSizes() != null) {
                    pdVectorArray.addAttribute("thicknesses", "show");
                }
                serializable3 = pdVectorArray.addChild("edges");
                PsXmlLoader.addVectorList((PsXmlNode)serializable3, "e", pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
                ((PsXmlNode)serializable3).addChild("thickness", pgJvxSrc.getGlobalPolygonSize());
                if (pgJvxSrc.getGlobalPolygonColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalPolygonColor());
                }
                if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalPolygonTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingPolygonLabels()) {
                    serializable2 = pgJvxSrc.getLabelAttribute(2);
                    object6 = null;
                    if (serializable2 != null) {
                        serializable2 = (PiVector)((PiVector)serializable2).clone();
                        ((PiVector)serializable2).setSize(8);
                        ((PiVector)serializable2).setEntry(5, 1);
                        ((PiVector)serializable2).setEntry(6, (int)pgJvxSrc.getLabelSize(2));
                        ((PiVector)serializable2).setEntry(7, pgJvxSrc.getLabelStyle(2));
                        object6 = PgJvxLoader.fillLabelAttr((PiVector)serializable2, pgJvxSrc.getLabelFont(2));
                    } else {
                        object6 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getLabelColor(2));
                    ((PsXmlNode)serializable3).addChild((PsXmlNode)object6);
                }
                if (bl5 && pgJvxSrc.getPolygonColors() != null) {
                    serializable2 = pdVectorArray.addChild("colors");
                    ((PsXmlNode)serializable2).addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "c", pgJvxSrc.getPolygonColors(), pgJvxSrc.getNumPolygons());
                }
                if (bl4 && pgJvxSrc.getPolygonNormals() != null) {
                    serializable2 = pdVectorArray.addChild("normals");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "n", pgJvxSrc.getPolygonNormals(), pgJvxSrc.getNumPolygons());
                    ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalPolygonNormalSize());
                    ((PsXmlNode)serializable2).addChild("length", pgJvxSrc.getGlobalPolygonNormalLength());
                    if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalPolygonNormalColor());
                    }
                }
                if (pgJvxSrc.getPolygonSizes() != null) {
                    serializable2 = pdVectorArray.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "th", pgJvxSrc.getPolygonSizes(), pgJvxSrc.getNumPolygons());
                }
            }
            if (n2 == 32) {
                pdVectorArray = ((PsXmlNode)object).addChild("lineSet");
                if (pgJvxSrc.isShowingPolygons()) {
                    pdVectorArray.addAttribute("line", "show");
                } else {
                    pdVectorArray.addAttribute("line", "hide");
                }
                if (pgJvxSrc.isShowingPolygonStartArrow()) {
                    pdVectorArray.addAttribute("arrowStart", "show");
                }
                if (pgJvxSrc.isShowingPolygonEndArrow()) {
                    pdVectorArray.addAttribute("arrow", "show");
                }
                if (bl5 && pgJvxSrc.isShowingPolygonColors() && (pgJvxSrc.getPolygonColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                    pdVectorArray.addAttribute("color", "show");
                }
                if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                    pdVectorArray.addAttribute("colorFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                    pdVectorArray.addAttribute("colorSmooth", "show");
                }
                if (bl4 && pgJvxSrc.isShowingPolygonNormals()) {
                    pdVectorArray.addAttribute("normal", "show");
                }
                if (bl4 && pgJvxSrc.isShowingPolygonNormalArrow()) {
                    pdVectorArray.addAttribute("normalArrow", "show");
                }
                if (!pgJvxSrc.isShowingTaggedPolygons()) {
                    pdVectorArray.addAttribute("lineMark", "hide");
                }
                if (pgJvxSrc.isShowingPolygonSizes() && pgJvxSrc.getPolygonSizes() != null) {
                    pdVectorArray.addAttribute("thicknesses", "show");
                }
                serializable3 = pdVectorArray.addChild("lines");
                PsXmlLoader.addVectorList((PsXmlNode)serializable3, "l", pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
                ((PsXmlNode)serializable3).addChild("thickness", pgJvxSrc.getGlobalPolygonSize());
                if (pgJvxSrc.getGlobalPolygonColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalPolygonColor());
                }
                if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalPolygonTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingPolygonLabels()) {
                    serializable2 = pgJvxSrc.getLabelAttribute(2);
                    object6 = null;
                    if (serializable2 != null) {
                        serializable2 = (PiVector)((PiVector)serializable2).clone();
                        ((PiVector)serializable2).setSize(8);
                        ((PiVector)serializable2).setEntry(5, 1);
                        ((PiVector)serializable2).setEntry(6, (int)pgJvxSrc.getLabelSize(2));
                        ((PiVector)serializable2).setEntry(7, pgJvxSrc.getLabelStyle(2));
                        object6 = PgJvxLoader.fillLabelAttr((PiVector)serializable2, pgJvxSrc.getLabelFont(2));
                    } else {
                        object6 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getLabelColor(2));
                    ((PsXmlNode)serializable3).addChild((PsXmlNode)object6);
                }
                if (bl5 && pgJvxSrc.getPolygonColors() != null) {
                    serializable2 = pdVectorArray.addChild("colors");
                    ((PsXmlNode)serializable2).addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "c", pgJvxSrc.getPolygonColors(), pgJvxSrc.getNumPolygons());
                }
                if (bl4 && pgJvxSrc.getPolygonNormals() != null) {
                    serializable2 = pdVectorArray.addChild("normals");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "n", pgJvxSrc.getPolygonNormals(), pgJvxSrc.getNumPolygons());
                    ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalPolygonNormalSize());
                    ((PsXmlNode)serializable2).addChild("length", pgJvxSrc.getGlobalPolygonNormalLength());
                    if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalPolygonNormalColor());
                    }
                }
                if (pgJvxSrc.getPolygonSizes() != null) {
                    serializable2 = pdVectorArray.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "th", pgJvxSrc.getPolygonSizes(), pgJvxSrc.getNumPolygons());
                }
            }
            if (n2 == 33) {
                pdVectorArray = ((PsXmlNode)object).addChild("faceSet");
                if (pgJvxSrc.isShowingElements()) {
                    pdVectorArray.addAttribute("face", "show");
                } else {
                    pdVectorArray.addAttribute("face", "hide");
                }
                if (pgJvxSrc.isShowingEdges()) {
                    pdVectorArray.addAttribute("edge", "show");
                } else {
                    pdVectorArray.addAttribute("edge", "hide");
                }
                if (bl5 && pgJvxSrc.isShowingElementColors() && (pgJvxSrc.getElementColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                    pdVectorArray.addAttribute("color", "show");
                }
                if (pgJvxSrc.isShowingElementBackColor()) {
                    pdVectorArray.addAttribute("colorBackGlobal", "show");
                }
                if (bl5 && pgJvxSrc.isShowingElementBackColors() && pgJvxSrc.getElementBackColors() != null) {
                    pdVectorArray.addAttribute("colorBackLocal", "show");
                }
                if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                    pdVectorArray.addAttribute("colorFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                    pdVectorArray.addAttribute("colorSmooth", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColors()) {
                    pdVectorArray.addAttribute("colorEdge", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColorFromElements()) {
                    pdVectorArray.addAttribute("colorEdgeInduced", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColorFromVertices()) {
                    pdVectorArray.addAttribute("colorEdgeFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothEdgeColors()) {
                    pdVectorArray.addAttribute("colorEdgeSmooth", "show");
                }
                if (bl4 && pgJvxSrc.isShowingElementNormals() && pgJvxSrc.getElementNormals() != null) {
                    pdVectorArray.addAttribute("normal", "show");
                }
                if (bl4 && pgJvxSrc.isShowingElementNormalArrow() && pgJvxSrc.getElementNormals() != null) {
                    pdVectorArray.addAttribute("normalArrow", "show");
                }
                if (bl6 && (pgJvxSrc.isShowingVertexTexture() && pgJvxSrc.getVertexTextures() != null || pgJvxSrc.isShowingElementTexture() && pgJvxSrc.getElementTextures() != null)) {
                    pdVectorArray.addAttribute("texture", "show");
                }
                if (!pgJvxSrc.isShowingBackface()) {
                    pdVectorArray.addAttribute("backface", "hide");
                }
                if (pgJvxSrc.isShowingBoundaries()) {
                    pdVectorArray.addAttribute("boundary", "show");
                }
                if (pgJvxSrc.isShowingSilhouette()) {
                    pdVectorArray.addAttribute("silhouette", "show");
                }
                if (!pgJvxSrc.isShowingTaggedElements()) {
                    pdVectorArray.addAttribute("faceMark", "hide");
                }
                serializable3 = pdVectorArray.addChild("faces");
                PsXmlLoader.addVectorList((PsXmlNode)serializable3, "f", pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
                if (pgJvxSrc.getGlobalElementColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalElementColor());
                }
                if (pgJvxSrc.isShowingElementBackColor()) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorBack", pgJvxSrc.getGlobalElementBackColor());
                }
                if (pgJvxSrc.getGlobalElementTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalElementTagColor());
                }
                double d = pgJvxSrc.getCreaseAngle();
                ((PsXmlNode)serializable3).addChild("creaseAngle", d);
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingElementLabels()) {
                    object5 = pgJvxSrc.getLabelAttribute(3);
                    PsXmlNode psXmlNode3 = null;
                    if (object5 != null) {
                        object5 = (PiVector)((PiVector)object5).clone();
                        ((PiVector)object5).setSize(8);
                        ((PiVector)object5).setEntry(5, 1);
                        ((PiVector)object5).setEntry(6, (int)pgJvxSrc.getLabelSize(3));
                        ((PiVector)object5).setEntry(7, pgJvxSrc.getLabelStyle(3));
                        psXmlNode3 = PgJvxLoader.fillLabelAttr((PiVector)object5, pgJvxSrc.getLabelFont(3));
                    } else {
                        psXmlNode3 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor(psXmlNode3, "color", pgJvxSrc.getLabelColor(3));
                    ((PsXmlNode)serializable3).addChild(psXmlNode3);
                }
                if (pgJvxSrc.getNeighbours() != null) {
                    object5 = pdVectorArray.addChild("neighbours");
                    PsXmlLoader.addVectorList((PsXmlNode)object5, "nb", pgJvxSrc.getNeighbours(), pgJvxSrc.getNumElements());
                }
                object5 = pdVectorArray.addChild("edges");
                if (pgJvxSrc.getNumEdges() > 0) {
                    PsXmlLoader.addVectorList((PsXmlNode)object5, "e", pgJvxSrc.getEdges(), pgJvxSrc.getNumEdges());
                }
                ((PsXmlNode)object5).addChild("thickness", pgJvxSrc.getGlobalEdgeSize());
                if (pgJvxSrc.getGlobalEdgeColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getGlobalEdgeColor());
                }
                if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)object5, "colorTag", pgJvxSrc.getGlobalEdgeTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingEdgeLabels()) {
                    PiVector piVector = pgJvxSrc.getLabelAttribute(1);
                    object4 = null;
                    if (piVector != null) {
                        piVector = (PiVector)piVector.clone();
                        piVector.setSize(8);
                        piVector.setEntry(5, 1);
                        piVector.setEntry(6, (int)pgJvxSrc.getLabelSize(1));
                        piVector.setEntry(7, pgJvxSrc.getLabelStyle(1));
                        object4 = PgJvxLoader.fillLabelAttr(piVector, pgJvxSrc.getLabelFont(1));
                    } else {
                        object4 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object4, "color", pgJvxSrc.getLabelColor(1));
                    ((PsXmlNode)object5).addChild((PsXmlNode)object4);
                }
                if (bl5 && pgJvxSrc.getElementColors() != null) {
                    PsXmlNode psXmlNode4 = pdVectorArray.addChild("colors");
                    psXmlNode4.addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList(psXmlNode4, "c", pgJvxSrc.getElementColors(), pgJvxSrc.getNumElements());
                }
                if (bl5 && pgJvxSrc.getElementBackColors() != null) {
                    PsXmlNode psXmlNode5 = pdVectorArray.addChild("colorsBack");
                    psXmlNode5.addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList(psXmlNode5, "c", pgJvxSrc.getElementBackColors(), pgJvxSrc.getNumElements());
                }
                if (bl4 && pgJvxSrc.getElementNormals() != null) {
                    PsXmlNode psXmlNode6 = pdVectorArray.addChild("normals");
                    PsXmlLoader.addVectorList(psXmlNode6, "n", pgJvxSrc.getElementNormals(), pgJvxSrc.getNumElements());
                    psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalElementNormalSize());
                    psXmlNode6.addChild("length", pgJvxSrc.getGlobalElementNormalLength());
                    if (pgJvxSrc.getGlobalElementNormalColor() != null) {
                        PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalElementNormalColor());
                    }
                }
                if (bl6 && pgJvxSrc.getElementTextures() != null) {
                    PsXmlNode psXmlNode7 = pdVectorArray.addChild("textures");
                    psXmlNode7.addAttribute("dim", String.valueOf(2));
                    if (pgJvxSrc.getBlendingMode() == 0) {
                        psXmlNode7.addAttribute("blend", "replace");
                    } else if (pgJvxSrc.getBlendingMode() == 1) {
                        psXmlNode7.addAttribute("blend", "material");
                    } else if (pgJvxSrc.getBlendingMode() == 2) {
                        psXmlNode7.addAttribute("blend", "alpha");
                    }
                    if (pgJvxSrc.getFilterType() == 1) {
                        psXmlNode7.addAttribute("filter", "linear");
                    } else if (pgJvxSrc.getFilterType() == 2) {
                        psXmlNode7.addAttribute("filter", "quadratic");
                    }
                    if (pgJvxSrc.getTextureSide() == 1) {
                        psXmlNode7.addAttribute("side", "front");
                    } else if (pgJvxSrc.getTextureSide() == 2) {
                        psXmlNode7.addAttribute("side", "back");
                    }
                    PsXmlLoader.addVectorList(psXmlNode7, "t", pgJvxSrc.getElementTextures(), pgJvxSrc.getNumElements());
                    if (pgJvxSrc.getTextureImage() != null) {
                        object4 = psXmlNode7.addChild("image");
                        object3 = pgJvxSrc.getTextureImageName();
                        if (object3 == null) {
                            PsDebug.warning("missing texture filename.");
                        }
                        ((PsXmlNode)object4).addChild("url", (String)object3);
                        int n3 = pgJvxSrc.getTexturePeriodic();
                        if (n3 == 0) {
                            ((PsXmlNode)object4).addAttribute("repeat", "no");
                        } else if (n3 == 3) {
                            ((PsXmlNode)object4).addAttribute("repeat", "st");
                        } else if (n3 == 1) {
                            ((PsXmlNode)object4).addAttribute("repeat", "s");
                        } else if (n3 == 2) {
                            ((PsXmlNode)object4).addAttribute("repeat", "t");
                        }
                        PdVector[] pdVectorArray2 = pgJvxSrc.getTextureImageBnd();
                        if (pdVectorArray2[0].getEntry(0) != 0.0 || pdVectorArray2[0].getEntry(1) != 0.0 || pdVectorArray2[1].getEntry(0) != 1.0 || pdVectorArray2[1].getEntry(1) != 1.0) {
                            PsXmlNode psXmlNode8 = psXmlNode7.addChild("imageCoords");
                            PsXmlLoader.addVectorList(psXmlNode8, "p", pdVectorArray2, 2);
                        }
                    }
                    object4 = pgJvxSrc.getTextureTiling();
                    psXmlNode7.addChild("tiling", Integer.toString(((Dimension)object4).width) + " " + Integer.toString(((Dimension)object4).height));
                }
                if (pgJvxSrc.isShowingBoundaries() || pgJvxSrc.isShowingSilhouette()) {
                    PsXmlNode psXmlNode9 = pdVectorArray.addChild("boundaries");
                    psXmlNode9.addChild("thickness", pgJvxSrc.getGlobalBndSize());
                    if (pgJvxSrc.getGlobalBndColor() != null) {
                        PsXmlLoader.addColor(psXmlNode9, "color", pgJvxSrc.getGlobalBndColor());
                    }
                    if (pgJvxSrc.getGlobalBndTagColor() != null) {
                        PsXmlLoader.addColor(psXmlNode9, "colorTag", pgJvxSrc.getGlobalBndTagColor());
                    }
                }
            }
            if (n2 == 34) {
                pdVectorArray = ((PsXmlNode)object).addChild("tetraSet");
                if (pgJvxSrc.isShowingElements()) {
                    pdVectorArray.addAttribute("face", "show");
                } else {
                    pdVectorArray.addAttribute("face", "hide");
                }
                if (pgJvxSrc.isShowingEdges()) {
                    pdVectorArray.addAttribute("edge", "show");
                } else {
                    pdVectorArray.addAttribute("edge", "hide");
                }
                if (bl5 && pgJvxSrc.isShowingElementColors() && (pgJvxSrc.getElementColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                    pdVectorArray.addAttribute("color", "show");
                }
                if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                    pdVectorArray.addAttribute("colorFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                    pdVectorArray.addAttribute("colorSmooth", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColors()) {
                    pdVectorArray.addAttribute("colorEdge", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColorFromElements()) {
                    pdVectorArray.addAttribute("colorEdgeInduced", "show");
                }
                if (bl5 && pgJvxSrc.isShowingEdgeColorFromVertices()) {
                    pdVectorArray.addAttribute("colorEdgeFromPoints", "show");
                }
                if (bl5 && pgJvxSrc.isShowingSmoothEdgeColors()) {
                    pdVectorArray.addAttribute("colorEdgeSmooth", "show");
                }
                if (bl6 && (pgJvxSrc.isShowingVertexTexture() && pgJvxSrc.getVertexTextures() != null || pgJvxSrc.isShowingElementTexture() && pgJvxSrc.getElementTextures() != null)) {
                    pdVectorArray.addAttribute("texture", "show");
                }
                if (pgJvxSrc.isShowingBoundaries()) {
                    pdVectorArray.addAttribute("boundary", "show");
                }
                if (!pgJvxSrc.isShowingTaggedElements()) {
                    pdVectorArray.addAttribute("faceMark", "hide");
                }
                serializable3 = pdVectorArray.addChild("tetras");
                PsXmlLoader.addVectorList((PsXmlNode)serializable3, "tet", pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
                if (pgJvxSrc.getGlobalElementColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalElementColor());
                }
                if (pgJvxSrc.getGlobalElementTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalElementTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingElementLabels()) {
                    PiVector piVector = pgJvxSrc.getLabelAttribute(3);
                    object6 = null;
                    if (piVector != null) {
                        piVector = (PiVector)piVector.clone();
                        piVector.setSize(8);
                        piVector.setEntry(5, 1);
                        piVector.setEntry(6, (int)pgJvxSrc.getLabelSize(3));
                        piVector.setEntry(7, pgJvxSrc.getLabelStyle(3));
                        object6 = PgJvxLoader.fillLabelAttr(piVector, pgJvxSrc.getLabelFont(3));
                    } else {
                        object6 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getLabelColor(3));
                    ((PsXmlNode)serializable3).addChild((PsXmlNode)object6);
                }
                if (pgJvxSrc.getNeighbours() != null) {
                    PsXmlNode psXmlNode10 = pdVectorArray.addChild("neighbours");
                    PsXmlLoader.addVectorList(psXmlNode10, "nb", pgJvxSrc.getNeighbours(), pgJvxSrc.getNumElements());
                }
                PsXmlNode psXmlNode11 = pdVectorArray.addChild("edges");
                psXmlNode11.addChild("thickness", pgJvxSrc.getGlobalEdgeSize());
                if (pgJvxSrc.getGlobalEdgeColor() != null) {
                    PsXmlLoader.addColor(psXmlNode11, "color", pgJvxSrc.getGlobalEdgeColor());
                }
                if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
                    PsXmlLoader.addColor(psXmlNode11, "colorTag", pgJvxSrc.getGlobalEdgeTagColor());
                }
                if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingEdgeLabels()) {
                    object6 = pgJvxSrc.getLabelAttribute(1);
                    object5 = null;
                    if (object6 != null) {
                        object6 = (PiVector)((PiVector)object6).clone();
                        ((PiVector)object6).setSize(8);
                        ((PiVector)object6).setEntry(5, 1);
                        ((PiVector)object6).setEntry(6, (int)pgJvxSrc.getLabelSize(1));
                        ((PiVector)object6).setEntry(7, pgJvxSrc.getLabelStyle(1));
                        object5 = PgJvxLoader.fillLabelAttr((PiVector)object6, pgJvxSrc.getLabelFont(1));
                    } else {
                        object5 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getLabelColor(1));
                    psXmlNode11.addChild((PsXmlNode)object5);
                }
                if (bl5 && pgJvxSrc.getElementColors() != null) {
                    object6 = pdVectorArray.addChild("colors");
                    ((PsXmlNode)object6).addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)object6, "c", pgJvxSrc.getElementColors(), pgJvxSrc.getNumElements());
                }
                if (bl6 && pgJvxSrc.getElementTextures() != null) {
                    object6 = pdVectorArray.addChild("textures");
                    ((PsXmlNode)object6).addAttribute("dim", String.valueOf(2));
                    if (pgJvxSrc.getBlendingMode() == 0) {
                        ((PsXmlNode)object6).addAttribute("blend", "replace");
                    } else if (pgJvxSrc.getBlendingMode() == 1) {
                        ((PsXmlNode)object6).addAttribute("blend", "material");
                    } else if (pgJvxSrc.getBlendingMode() == 2) {
                        ((PsXmlNode)object6).addAttribute("blend", "alpha");
                    }
                    if (pgJvxSrc.getFilterType() == 1) {
                        ((PsXmlNode)object6).addAttribute("filter", "linear");
                    } else if (pgJvxSrc.getFilterType() == 2) {
                        ((PsXmlNode)object6).addAttribute("filter", "quadratic");
                    }
                    if (pgJvxSrc.getTextureSide() == 1) {
                        ((PsXmlNode)object6).addAttribute("side", "front");
                    } else if (pgJvxSrc.getTextureSide() == 2) {
                        ((PsXmlNode)object6).addAttribute("side", "back");
                    }
                    PsXmlLoader.addVectorList((PsXmlNode)object6, "t", pgJvxSrc.getElementTextures(), pgJvxSrc.getNumElements());
                    if (pgJvxSrc.getTextureImage() != null) {
                        object5 = ((PsXmlNode)object6).addChild("image");
                        String string = pgJvxSrc.getTextureImageName();
                        if (string == null) {
                            PsDebug.warning("missing texture filename.");
                        }
                        ((PsXmlNode)object5).addChild("url", string);
                        int n4 = pgJvxSrc.getTexturePeriodic();
                        if (n4 == 0) {
                            ((PsXmlNode)object5).addAttribute("repeat", "no");
                        } else if (n4 == 3) {
                            ((PsXmlNode)object5).addAttribute("repeat", "st");
                        } else if (n4 == 1) {
                            ((PsXmlNode)object5).addAttribute("repeat", "s");
                        } else if (n4 == 2) {
                            ((PsXmlNode)object5).addAttribute("repeat", "t");
                        }
                        object3 = pgJvxSrc.getTextureImageBnd();
                        if (object3[0].getEntry(0) != 0.0 || object3[0].getEntry(1) != 0.0 || object3[1].getEntry(0) != 1.0 || object3[1].getEntry(1) != 1.0) {
                            PsXmlNode psXmlNode12 = ((PsXmlNode)object6).addChild("imageCoords");
                            PsXmlLoader.addVectorList(psXmlNode12, "p", object3, 2);
                        }
                    }
                    object5 = pgJvxSrc.getTextureTiling();
                    ((PsXmlNode)object6).addChild("tiling", Integer.toString(((Dimension)object5).width) + " " + Integer.toString(((Dimension)object5).height));
                }
                if (pgJvxSrc.isShowingBoundaries()) {
                    object6 = pdVectorArray.addChild("boundaries");
                    ((PsXmlNode)object6).addChild("thickness", pgJvxSrc.getGlobalBndSize());
                    if (pgJvxSrc.getGlobalBndColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getGlobalBndColor());
                    }
                    if (pgJvxSrc.getGlobalBndTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)object6, "colorTag", pgJvxSrc.getGlobalBndTagColor());
                    }
                }
            }
            if (bl7 && pgJvxSrc.getNumVectorFields() != 0) {
                int n5 = pgJvxSrc.getNumVectorFields();
                for (int j = 0; j < n5; ++j) {
                    PsXmlNode psXmlNode13 = ((PsXmlNode)object).addChild("vectorField");
                    if (pgJvxSrc.getVectorFieldName(j) != null) {
                        psXmlNode13.addAttribute("name", pgJvxSrc.getVectorFieldName(j));
                    }
                    if (!pgJvxSrc.isShowingVectorFields() || !pgJvxSrc.isShowingVectorField(j)) {
                        psXmlNode13.addAttribute("vector", "hide");
                    }
                    if (!pgJvxSrc.isShowingVectorFieldMaterials(j)) {
                        psXmlNode13.addAttribute("material", "hide");
                    }
                    if (pgJvxSrc.isShowingVectorArrows(j)) {
                        psXmlNode13.addAttribute("arrow", "show");
                    }
                    if (pgJvxSrc.isShowingVectorColors(j)) {
                        psXmlNode13.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isVectorElementBased(j)) {
                        psXmlNode13.addAttribute("base", "element");
                    } else {
                        psXmlNode13.addAttribute("base", "vertex");
                    }
                    object6 = pgJvxSrc.getVectors(j);
                    if (object6 == null || ((PdVector[])object6).length == 0) {
                        PsDebug.warning("missing vectors of vector field[" + j + "]");
                        continue;
                    }
                    object5 = psXmlNode13.addChild("vectors");
                    PsXmlLoader.addVectorList((PsXmlNode)object5, "v", (PdVector[])object6, ((PdVector[])object6).length);
                    ((PsXmlNode)object5).addChild("thickness", pgJvxSrc.getGlobalVectorSize(j));
                    ((PsXmlNode)object5).addChild("length", pgJvxSrc.getGlobalVectorLength(j));
                    if (pgJvxSrc.getGlobalVectorColor(j) != null) {
                        PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getGlobalVectorColor(j));
                    }
                    if (pgJvxSrc.getVectorFieldColors(j) == null) continue;
                    PsXmlNode psXmlNode14 = psXmlNode13.addChild("colors");
                    psXmlNode14.addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList(psXmlNode14, "c", pgJvxSrc.getVectorFieldColors(j), ((Object)object6).length);
                }
            }
            if ((pdVectorArray = pgJvxSrc.getBounds()) != null && pdVectorArray.length == 2) {
                PsXmlNode psXmlNode15 = ((PsXmlNode)object).addChild("bndbox");
                if (pgJvxSrc.isShowingBndBox()) {
                    psXmlNode15.addAttribute("visible", "show");
                } else {
                    psXmlNode15.addAttribute("visible", "hide");
                }
                psXmlNode15.addChild("p", PuString.toString(pdVectorArray[0].getEntries()));
                psXmlNode15.addChild("p", PuString.toString(pdVectorArray[1].getEntries()));
            }
            if ((serializable3 = pgJvxSrc.getCenter()) != null) {
                PsXmlNode psXmlNode16 = ((PsXmlNode)object).addChild("center");
                if (pgJvxSrc.isShowingCenter()) {
                    psXmlNode16.addAttribute("visible", "show");
                } else {
                    psXmlNode16.addAttribute("visible", "hide");
                }
                psXmlNode16.addChild("p", PuString.toString(((PdVector)serializable3).getEntries()));
            }
            if (pgJvxSrc.isShowingName()) {
                PiVector piVector = pgJvxSrc.getLabelAttribute(5);
                object6 = null;
                if (piVector != null) {
                    piVector = (PiVector)piVector.clone();
                    piVector.setSize(8);
                    piVector.setEntry(5, 1);
                    piVector.setEntry(6, (int)pgJvxSrc.getLabelSize(5));
                    piVector.setEntry(7, pgJvxSrc.getLabelStyle(5));
                    object6 = PgJvxLoader.fillLabelAttr(piVector, pgJvxSrc.getLabelFont(5));
                } else {
                    object6 = PgJvxLoader.fillLabelAttr(true);
                }
                PsXmlLoader.addColor((PsXmlNode)object6, "color", pgJvxSrc.getLabelColor(5));
                ((PsXmlNode)object).addChild((PsXmlNode)object6);
            }
            if (pgJvxSrc.isShowingTransparency() || pgJvxSrc.isShowingSmoothLighting()) {
                PsXmlNode psXmlNode17 = ((PsXmlNode)object).addChild("material");
                if (pgJvxSrc.isShowingSmoothLighting()) {
                    psXmlNode17.addAttribute("shading", "gouraud");
                }
                psXmlNode17.addChild("ambientIntensity", 0.2);
                PsXmlLoader.addColor(psXmlNode17, "diffuse", "color", new Color(0.8f, 0.8f, 0.8f));
                PsXmlLoader.addColor(psXmlNode17, "emissive", "color", Color.black);
                psXmlNode17.addChild("shininess", pgJvxSrc.getShininess());
                PsXmlLoader.addColor(psXmlNode17, "specular", "color", pgJvxSrc.getSpecularColor());
                object6 = psXmlNode17.addChild("transparency", pgJvxSrc.getTransparency());
                if (pgJvxSrc.isShowingTransparency()) {
                    ((PsXmlNode)object6).addAttribute("visible", "show");
                }
            }
            boolean bl9 = pgJvxSrc.hasModelMatrix();
            boolean bl10 = bl8 = pgJvxSrc.hasAmbientMatrix() || pgJvxSrc.getAmbientSpace() != 1 && pgJvxSrc.getAmbientSpace() != 3;
            if (!bl9 && !bl8) continue;
            object5 = ((PsXmlNode)object).addChild("transform");
            if (bl9) {
                PsXmlLoader.addMatrix((PsXmlNode)object5, "modelMat", pgJvxSrc.getModelMatrix());
            }
            if (!bl8) continue;
            n = pgJvxSrc.getAmbientSpace();
            int n6 = pgJvxSrc.getAmbientProjection();
            int n7 = pgJvxSrc.getDimOfVertices();
            PsXmlNode psXmlNode18 = ((PsXmlNode)object5).addChild("ambient");
            psXmlNode18.addAttribute("dim", String.valueOf(n7));
            if (n == 0 | n == 1 | n == 3 | n == 6 | n == 9) {
                psXmlNode18.addAttribute("space", "euclidean");
            } else if (n == 2 | n == 4 | n == 7 | n == 10) {
                psXmlNode18.addAttribute("space", "spherical");
            } else if (n == 5 | n == 8 | n == 11) {
                psXmlNode18.addAttribute("space", "hyperbolic");
            } else {
                PsDebug.warning("unknown ambient space = " + n);
                return null;
            }
            if (n6 == 0) {
                psXmlNode18.addAttribute("projection", "parallel");
            } else if (n6 == 1) {
                psXmlNode18.addAttribute("projection", "stereographic");
            } else if (n6 == 1) {
                psXmlNode18.addAttribute("projection", "poincare");
            } else if (n6 == 2) {
                psXmlNode18.addAttribute("projection", "klein");
            } else if (n6 == 3) {
                psXmlNode18.addAttribute("projection", "uhs");
            } else {
                PsDebug.warning("unknown ambient projection = " + n6);
                return null;
            }
            PsXmlLoader.addMatrix(psXmlNode18, "ambientMat", pgJvxSrc.getAmbientMatrix());
            PsXmlLoader.addMatrix(psXmlNode18, "ambientInvMat", pgJvxSrc.getAmbientInvMatrix());
        }
        return psXmlSrc;
    }

    protected static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    protected static String fillVisibility(boolean bl) {
        if (bl) {
            return "show";
        }
        return "hide";
    }

    protected static PsXmlNode fillLabelAttr(boolean bl) {
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(bl));
        return psXmlNode;
    }

    protected static PsXmlNode fillLabelAttr(PiVector piVector, String string) {
        int n = piVector.getEntry(0);
        int n2 = piVector.getEntry(1);
        int n3 = piVector.getEntry(2);
        int n4 = piVector.getEntry(3);
        int n5 = piVector.getEntry(4);
        int n6 = piVector.getEntry(5);
        int n7 = piVector.getEntry(6);
        int n8 = piVector.getEntry(7);
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(n6 == 1));
        switch (n3) {
            case 0: {
                psXmlNode.addAttribute("horAlign", "head");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("horAlign", "center");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("horAlign", "tail");
                break;
            }
        }
        switch (n4) {
            case 2: {
                psXmlNode.addAttribute("verAlign", "top");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("verAlign", "middle");
                break;
            }
            case 0: {
                psXmlNode.addAttribute("verAlign", "bottom");
                break;
            }
        }
        switch (n5) {
            case 0: {
                psXmlNode.addAttribute("font", "text");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("font", "fixed");
                break;
            }
            case 3: {
                psXmlNode.addAttribute("font", "header2");
                break;
            }
            case 4: {
                psXmlNode.addAttribute("font", "header4");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("font", "menu");
                break;
            }
        }
        psXmlNode.addChild("xOffset", String.valueOf(n));
        psXmlNode.addChild("yOffset", String.valueOf(n2));
        if (string != null) {
            psXmlNode.addAttribute("name", string);
            switch (n8) {
                case 0: {
                    psXmlNode.addAttribute("style", "plain");
                    break;
                }
                case 1: {
                    psXmlNode.addAttribute("style", "bold");
                    break;
                }
                case 2: {
                    psXmlNode.addAttribute("style", "italic");
                    break;
                }
                case 3: {
                    psXmlNode.addAttribute("style", "bold+italic");
                }
            }
            psXmlNode.addChild("size", String.valueOf(n7));
        }
        return psXmlNode;
    }

    protected PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        Object object;
        Object object2;
        String string;
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(8);
        String string2 = psXmlNode.getAttribute("visible");
        if (string2 != null && "hide".equalsIgnoreCase(string2)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string3 = psXmlNode.getAttribute("horAlign");
        if (string3 == null || "head".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 2);
        }
        String string4 = psXmlNode.getAttribute("verAlign");
        if ("bottom".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 0);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning("Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                piVector.setEntry(3, 2);
            }
        } else if (string4 == null || "middle".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 2);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning("Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                piVector.setEntry(3, 0);
            }
        } else if ("head".equalsIgnoreCase(string4)) {
            PsDebug.warning("Encountered void use of attribute \"verAlign\".\n\tSave JVX file with a newer JavaView such as v.2.99.030");
            piVector.setEntry(3, 1);
        }
        if ((string = psXmlNode.getAttribute("font")) == null) {
            piVector.setEntry(4, 0);
        } else if ("text".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 2);
        }
        try {
            object2 = PsXmlSrc.getRsrcNode(psXmlNode, "xOffset");
            if (object2 != null) {
                piVector.setEntry(0, Integer.parseInt(((PsXmlNode)object2).getContent()));
            }
            if ((object = PsXmlSrc.getRsrcNode(psXmlNode, "yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(((PsXmlNode)object).getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format parsing offset");
            return null;
        }
        object2 = psXmlNode.getAttribute("name");
        if (object2 != null) {
            object = psXmlNode.getAttribute("style");
            if (object == null) {
                piVector.setEntry(7, 0);
            } else if (((String)object).equals("plain")) {
                piVector.setEntry(7, 0);
            } else if (((String)object).equals("bold")) {
                piVector.setEntry(7, 1);
            } else if (((String)object).equals("italic")) {
                piVector.setEntry(7, 2);
            } else if (((String)object).equals("bold+italic")) {
                piVector.setEntry(7, 3);
            }
            if (psXmlNode.hasChild("size")) {
                int n = (int)PsXmlSrc.getRsrcAsDouble(psXmlNode, "size");
                piVector.setEntry(6, n);
            } else {
                piVector.setEntry(6, 12);
            }
        }
        return piVector;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            String string2 = psXmlNodeArray[i].getContent();
            if (string2 == null) continue;
            String[] stringArray3 = PuString.splitString(string2, ' ');
            stringArray2[i] = new String[stringArray3.length];
            for (int j = 0; j < stringArray3.length; ++j) {
                stringArray2[i][j] = stringArray3[j];
            }
        }
        return stringArray2;
    }
}

