/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Date;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.objectGui.PsSlotLayout;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PjWorkshopIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.rsrc.PsJavaView;
import jv.viewer.PvDisplay;
import jv.viewer.PvViewer;

public class javaview
extends Applet
implements Runnable {
    protected PsMainFrame m_frame = null;
    protected Point m_framePosition = null;
    protected Dimension m_frameSize = null;
    protected PvViewer m_viewer;
    protected PvDisplayIf m_disp;
    protected PvDisplayOption m_dispOption = null;
    protected Color m_backgroundColor = null;
    private boolean m_bProfile = false;
    private boolean m_bBatch = false;
    private String[] m_drawString = new String[]{PsConfig.getMessage(28009)};
    private Image m_imageLaunch = null;
    private static int m_appletCnt = 0;
    private int m_appletCntOwn = 0;

    public PvViewer getViewer() {
        return this.m_viewer;
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier\r\n" + "Loads the JavaView standalone and basis of many projects. " + "3D geometry plugin and viewer for multiple file formats " + "including Jvx/Maple/Mathematica/Mupad/Obj/Off/Dxf/Wrl/etc models.\r\n";
    }

    public void init() {
        this.m_appletCntOwn = m_appletCnt++;
        this.repaint();
        if (this.m_viewer == null) {
            this.m_viewer = new PvViewer(this, this.m_frame);
        }
        if (!this.m_bBatch) {
            this.m_imageLaunch = PsImage.getImageResource(PsConfig.getImageLaunch());
            if (this.m_imageLaunch == null) {
                this.m_imageLaunch = PsImage.getImageResource("images/JavaViewLaunch_tiny.jpg");
                if (this.m_imageLaunch == null) {
                    PsDebug.message("missing JavaView image: " + PsConfig.getImageLaunch(), false);
                }
            }
        }
        String string = null;
        string = this.m_viewer.getParameter("Background");
        if (string != null || (string = this.m_viewer.getParameter("BGCOLOR")) != null) {
            this.m_backgroundColor = PdColor.parseColor(string);
        }
        Thread thread = new Thread((Runnable)this, PsConfig.getProgram() + ": initialize applet [" + String.valueOf(m_appletCnt) + "]");
        thread.setPriority(5);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            Frame frame = PsConfig.getFrame();
            synchronized (frame) {
                String string;
                Object object;
                Object object2;
                boolean bl;
                boolean bl2;
                String string2;
                String string3;
                boolean bl3;
                boolean bl4;
                String string4;
                double d;
                block65: {
                    String string5;
                    boolean bl5;
                    boolean bl6;
                    block66: {
                        String[] stringArray;
                        block64: {
                            if (this.m_viewer == null) {
                                return;
                            }
                            this.m_viewer.showPanel(13);
                            String string6 = this.m_viewer.getParameter("Profile");
                            if (string6 != null) {
                                this.m_bProfile = string6.equalsIgnoreCase("show");
                            }
                            d = 0.0;
                            if (this.m_bProfile) {
                                d = new Date().getTime();
                            }
                            if (!((string4 = this.m_viewer.getParameter("displayFile")) == null || PsConfig.isApplication() || string4.startsWith("http:") || string4.startsWith("https:") || string4.startsWith("ftp:") || string4.startsWith("file:"))) {
                                string4 = PsConfig.getCodeBase() + string4;
                            }
                            this.m_disp = this.m_viewer.getDisplay();
                            if (this.m_backgroundColor != null) {
                                this.m_disp.setBackgroundColor(this.m_backgroundColor);
                            }
                            if (string4 != null) {
                                this.m_disp.setAutoCenter(false);
                            }
                            bl4 = true;
                            bl3 = true;
                            String string7 = this.m_viewer.getParameter("Animate");
                            bl6 = false;
                            if (string7 != null && string7.equalsIgnoreCase("show")) {
                                PsDebug.message("Argument: animation parameter ...", false);
                                bl6 = true;
                            }
                            bl5 = false;
                            String string8 = this.m_viewer.getParameter("Debug");
                            if (string8 != null && string8.equalsIgnoreCase("Show")) {
                                bl5 = true;
                            }
                            if ((string3 = this.m_viewer.getParameter("Model")) == null) {
                                string3 = this.m_viewer.getParameter("INPUT_FILE");
                            }
                            stringArray = new String[1];
                            if (string3 != null) {
                                if (string3.indexOf(";") > -1) {
                                    stringArray = PuString.splitString(string3, ';');
                                } else {
                                    stringArray[0] = string3;
                                }
                                for (int i = 0; i < stringArray.length; ++i) {
                                    if (PsConfig.isApplication()) {
                                        stringArray[i] = PsUtil.assureFileSeparator(stringArray[i], false);
                                    }
                                    if (!PsUtil.isAbsolutePath(stringArray[i])) {
                                        stringArray[i] = PsConfig.isApplication() ? PsConfig.getUserBase() + stringArray[i] : PsConfig.getCodeBase() + stringArray[i];
                                    }
                                    if (i == 0) {
                                        PsJavaView.setFullFileName(7, stringArray[i]);
                                    }
                                    if (stringArray.length == 0) {
                                        PsDebug.message("Argument: model   = " + stringArray[i], false);
                                        continue;
                                    }
                                    PsDebug.message("Argument: model[" + String.valueOf(i) + "] = " + stringArray[i], false);
                                }
                            } else {
                                String string9;
                                String string10 = PsConfig.getCodeBase();
                                string5 = this.m_viewer.getParameter("project.import.baseDir");
                                if (string5 != null) {
                                    string10 = string10 + string5;
                                }
                                if ((string9 = this.m_viewer.getParameter("project.import.select")) != null) {
                                    stringArray[0] = string10 = string10 + string9;
                                }
                            }
                            string3 = stringArray[0];
                            string2 = this.m_viewer.getParameter("Project");
                            if (string2 != null && string3 != null) {
                                PsDebug.message("Argument: project = " + string2, false);
                            }
                            if ((string5 = this.m_viewer.getParameter("file")) != null && string2 != null && string3 != null) {
                                PsDebug.message("Argument: file    = " + string5, false);
                            }
                            bl2 = false;
                            bl = false;
                            if (string3 == null || string3.indexOf(".*.") <= -1 && string3.indexOf(".0*.") <= -1) break block64;
                            bl2 = this.loadAnimation(string3, this.m_viewer);
                            break block65;
                        }
                        if (string3 == null) break block66;
                        for (int i = 0; i < stringArray.length; ++i) {
                            bl2 = this.loadModels(stringArray[i], this.m_viewer, bl6, string4 != null);
                        }
                        if (PsConfig.isApplication()) break block65;
                        String string11 = this.m_viewer.getParameter("project.panel");
                        if (string11 == null) {
                            string11 = this.m_viewer.getParameter("ProjectPanel");
                        }
                        if (string11 != null && "Show".equalsIgnoreCase(string11)) {
                            bl3 = false;
                        }
                        break block65;
                    }
                    if (string5 != null && string5.equalsIgnoreCase("stdin") && this.m_frame != null) {
                        String string12 = this.m_viewer.getParameter("stdin");
                        BufferedReader bufferedReader = null;
                        if (string12 != null) {
                            bufferedReader = PsUtil.open(string12);
                        } else {
                            string12 = "System.in";
                            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                        }
                        object2 = this.m_viewer.getParameter("format");
                        bl2 = this.loadModelFromStream(bufferedReader, string12, (String)object2, bl6);
                    } else {
                        String[][] stringArrayArray = new String[][]{{"input", "mgs"}, {"mathematica", "mgs"}, {"maple", "mpl"}, {"javaview", "jvx"}};
                        for (int i = 0; i < stringArrayArray.length; ++i) {
                            object2 = this.m_viewer.getParameter(stringArrayArray[i][0]);
                            if (object2 == null) continue;
                            if (bl5) {
                                PsDebug.message("Argument: " + (String)object2, false);
                            }
                            if (bl2 = this.loadModelFromStream((BufferedReader)(object = new BufferedReader(new StringReader((String)object2))), stringArrayArray[i][0], stringArrayArray[i][1], bl6)) break;
                            PsDebug.warning("Geometry as parameter encountered, type = " + stringArrayArray[i][0] + "\n\tbut loading of geometry failed");
                            break;
                        }
                    }
                }
                if (string2 != null) {
                    Object object3 = PsUtil.newInstance(string2);
                    if (object3 == null) {
                        PsDebug.warning("cannot find or load project = " + string2);
                    } else if (!(object3 instanceof PjProject)) {
                        PsDebug.warning("class does not inherit from jv.project.PjProject: " + string2);
                    } else {
                        PjProject pjProject = (PjProject)object3;
                        this.m_viewer.addProject(pjProject);
                        this.m_viewer.selectProject(pjProject);
                        if (string3 != null) {
                            pjProject.setGeometry(this.m_viewer.getGeometry());
                        }
                        this.m_viewer.showPanel(10);
                    }
                }
                boolean bl7 = bl4 = !bl2 && !bl;
                if (bl4) {
                    PgElementSet pgElementSet = new PgElementSet(3);
                    pgElementSet.setName("Snail");
                    pgElementSet.computeSnail(20, 15, 2.0);
                    pgElementSet.makeVertexNormals();
                    pgElementSet.makeElementNormals();
                    pgElementSet.makeElementColorsFromZHue();
                    pgElementSet.showSmoothElementColors(true);
                    this.m_disp.setBackgroundColor(Color.white);
                    this.m_disp.addGeometry(pgElementSet);
                    this.m_disp.selectGeometry(pgElementSet);
                }
                if ((string = this.m_viewer.getParameter("Workshop")) != null) {
                    PsDebug.message("Argument: workshop = " + string, false);
                    Object object4 = PsUtil.newInstance(string);
                    if (object4 == null) {
                        PsDebug.warning("cannot find or load workshop = " + string);
                    } else if (!(object4 instanceof PjWorkshopIf)) {
                        PsDebug.warning("class does not implement interface jv.project.PjWorkshopIf: " + string);
                    } else {
                        object2 = (PjWorkshopIf)object4;
                        object2.setDisplay(this.m_disp);
                        object = this.m_viewer.getGeometry();
                        if (object == null) {
                            PsDebug.warning("missing geometry for workshop.");
                        } else {
                            object2.setGeometry((PgGeometry)object);
                            if (object2.getGeometry() == null) {
                                PsDebug.warning("geometry was not accepted by workshop, check class type.");
                            } else {
                                PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
                                if (psDialog != null) {
                                    psDialog.setParent((PsUpdateIf)object2);
                                    psDialog.update(object2);
                                    ((Component)psDialog).setVisible(true);
                                }
                            }
                        }
                    }
                }
                if (bl3) {
                    this.setLayout(new BorderLayout());
                    this.add((Component)this.m_disp.getCanvas(), "Center");
                }
                if (string4 != null && this.m_dispOption == null) {
                    PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.read(string4);
                    if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
                        PsDebug.warning("reading of display configuration failed, file = " + string4);
                    } else {
                        this.m_dispOption = pvDisplayOptionArray[0];
                    }
                }
                if (this.m_dispOption != null) {
                    this.m_dispOption.configure(this.m_disp);
                    if (this.m_backgroundColor != null) {
                        this.m_disp.setBackgroundColor(this.m_backgroundColor);
                    }
                } else {
                    PgGeometryIf[] pgGeometryIfArray = this.m_disp.getGeometries();
                    if (pgGeometryIfArray != null && pgGeometryIfArray.length > 0) {
                        int n = 2;
                        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                            if (pgGeometryIfArray[i] == null || pgGeometryIfArray[i].getDimOfVertices() <= 2) continue;
                            n = 3;
                            break;
                        }
                        if (n == 2) {
                            this.m_disp.selectCamera(1);
                        }
                    }
                }
                if (this.m_bProfile) {
                    double d2 = (double)new Date().getTime() - d;
                    PsDebug.message("Launching JavaView: time = " + d2 + " ms", false);
                }
                this.validate();
                this.startFromThread();
            }
            this.m_imageLaunch = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PsDebug.outOfMemory(outOfMemoryError);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        PsMainFrame psMainFrame;
        javaview javaview2 = new javaview();
        javaview2.m_frame = psMainFrame = new PsMainFrame(javaview2, stringArray);
        javaview2.m_viewer = new PvViewer(javaview2, psMainFrame);
        String string = javaview2.m_viewer.getParameter("renderDevice");
        if (string != null && string.equalsIgnoreCase("opengl")) {
            PvDisplay.m_renderType = 2;
        } else if (string != null && string.equalsIgnoreCase("lwjgl")) {
            PvDisplay.m_renderType = 3;
        }
        String string2 = javaview2.m_viewer.getParameter("mode");
        if (string2 != null && string2.equalsIgnoreCase("batch")) {
            javaview2.m_bBatch = true;
        }
        javaview2.m_framePosition = new Point(375, 5);
        javaview2.m_frameSize = new Dimension(640, 512);
        String string3 = javaview2.m_viewer.getParameter("displayFile");
        if (string3 != null) {
            object = PvDisplayLoader.read(string3);
            if (object == null || ((PvDisplayOption[])object).length == 0 || object[0] == null) {
                PsDebug.warning("reading of display configuration failed, file = " + string3);
            } else {
                javaview2.m_dispOption = object[0];
                if (((PvDisplayOption)object[0]).getWindowPosition() != null) {
                    javaview2.m_framePosition = ((PvDisplayOption)object[0]).getWindowPosition();
                }
                if (((PvDisplayOption)object[0]).getWindowSize() != null) {
                    javaview2.m_frameSize = ((PvDisplayOption)object[0]).getWindowSize();
                }
            }
        } else {
            object = System.getProperty("os.name");
            if (object == null || ((String)object).toLowerCase().startsWith("win")) {
                // empty if block
            }
        }
        try {
            int n2;
            String[] stringArray2;
            object = javaview2.m_viewer.getParameter("Size");
            if (object != null) {
                stringArray2 = PuString.splitString((String)object, 'x');
                if (stringArray2 != null && stringArray2.length == 2) {
                    n = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    javaview2.m_frameSize = new Dimension(n, n2);
                    if (javaview2.m_dispOption != null) {
                        javaview2.m_dispOption.setWindowSize(javaview2.m_frameSize);
                    }
                } else {
                    PsDebug.warning("wrong format in size of display = " + (String)object);
                }
            }
            if ((object = javaview2.m_viewer.getParameter("Position")) != null) {
                stringArray2 = PuString.splitString((String)object, 'x');
                if (stringArray2 != null && stringArray2.length == 2) {
                    n = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    javaview2.m_framePosition = new Point(n, n2);
                    if (javaview2.m_dispOption != null) {
                        javaview2.m_dispOption.setWindowPosition(javaview2.m_framePosition);
                    }
                } else {
                    PsDebug.warning("wrong format in size of display = " + (String)object);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in size/position of display");
        }
        psMainFrame.pack();
        javaview2.init();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = javaview2.m_frameSize.height;
        int n4 = psMainFrame.getComponentCount();
        for (n = 1; n < n4; ++n) {
            Dimension dimension = psMainFrame.getComponent(n).getSize();
            n3 += dimension.height;
        }
        javaview2.m_frameSize = new Dimension(javaview2.m_frameSize.width, n3);
        if (javaview2.m_framePosition != null) {
            psMainFrame.setInnerBounds(new Rectangle(javaview2.m_framePosition, javaview2.m_frameSize));
        } else {
            psMainFrame.setInnerSize(javaview2.m_frameSize);
        }
        if (!javaview2.m_bBatch) {
            ((Component)psMainFrame).setVisible(true);
            psMainFrame.toFront();
        }
    }

    private boolean loadAnimation(String string, PvViewer pvViewer) {
        boolean bl = false;
        PgLoader pgLoader = new PgLoader();
        pgLoader.setAnimated(false);
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        String string2 = this.m_viewer.getParameter("Animation.firstKey");
        String string3 = this.m_viewer.getParameter("Animation.lastKey");
        String string4 = this.m_viewer.getParameter("Animation.fixedLen");
        if (string2 == null) {
            string2 = this.m_viewer.getParameter("firstKey");
        }
        if (string3 == null) {
            string3 = this.m_viewer.getParameter("lastKey");
        }
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n3 = Integer.parseInt(string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in firstKey=" + string2 + ", or in lastKey=" + string3);
        }
        PsKeyframe[] psKeyframeArray = pgLoader.readAnimation(null, n, n2, string, n3);
        if (psKeyframeArray == null || psKeyframeArray.length == 0) {
            PsDebug.warning("failed loading animation = " + string);
        } else {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            int n4 = psKeyframeArray.length;
            for (int i = 0; i < n4; ++i) {
                this.m_disp.addGeometry(psKeyframeArray[i].getDynamic());
            }
            this.m_disp.selectGeometry(psKeyframeArray[0].getDynamic());
            String string11 = PsUtil.getFileName(string);
            PsAnimation psAnimation = new PsAnimation();
            psAnimation.setName(string11);
            psAnimation.enableKeys(true);
            for (int i = 0; i < n4; ++i) {
                psAnimation.addTimeListener(psKeyframeArray[i]);
            }
            String string12 = this.m_viewer.getParameter("Animation.dialog");
            if (string12 == null) {
                string12 = this.m_viewer.getParameter("Animation");
            }
            if (string12 == null || string12.equalsIgnoreCase("show")) {
                ((Component)psAnimation.getAnimationPanel()).setVisible(true);
            }
            if ((string10 = this.m_viewer.getParameter("Animation.interpolType")) != null) {
                if (string10.equalsIgnoreCase("None")) {
                    psAnimation.setInterpolType(0);
                } else {
                    psAnimation.setInterpolType(1);
                }
            }
            if ((string9 = this.m_viewer.getParameter("Animation.speedType")) != null) {
                if (string9.equalsIgnoreCase("FastForward")) {
                    psAnimation.setSpeedType(2);
                } else if (string9.equalsIgnoreCase("FastRewind")) {
                    psAnimation.setSpeedType(3);
                } else if (string9.equalsIgnoreCase("Rewind")) {
                    psAnimation.setSpeedType(1);
                } else {
                    psAnimation.setSpeedType(0);
                }
            }
            if ((string8 = this.m_viewer.getParameter("Animation.framesPerSecond")) != null) {
                try {
                    int n5 = 1000 / Integer.parseInt(string8);
                    psAnimation.setSleepInterval(n5);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format in Animation.framesPerSecond");
                }
            }
            if ((string7 = this.m_viewer.getParameter("Animation.timeStepIncr")) != null) {
                try {
                    double d = new Double(string7);
                    psAnimation.setTimeStepIncr(d);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format in Animation.timeStepIncr");
                }
            }
            if ((string6 = this.m_viewer.getParameter("Animation.timePageIncr")) != null) {
                try {
                    double d = new Double(string6);
                    psAnimation.setTimePageIncr(d);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format in Animation.TimePageIncr");
                }
            }
            if ((string5 = this.m_viewer.getParameter("Animation.start")) != null && string5.equalsIgnoreCase("show")) {
                psAnimation.start();
            }
            psAnimation.update(psAnimation);
            bl = true;
        }
        return bl;
    }

    public void loadModel(String string) {
        string = PsConfig.getCodeBase() + string;
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        pvDisplayIf.removeGeometries();
        PgLoader pgLoader = new PgLoader();
        PgGeometry[] pgGeometryArray = pgLoader.loadGeometry((PgGeometry[])null, string);
        if (pgGeometryArray == null || pgGeometryArray.length == 0) {
            PsDebug.warning("failed loading file = " + string);
            return;
        }
        for (int i = 0; i < pgGeometryArray.length; ++i) {
            pvDisplayIf.addGeometry(pgGeometryArray[i]);
        }
        pvDisplayIf.selectGeometry(pgGeometryArray[0]);
        pvDisplayIf.fit();
        pvDisplayIf.update(pvDisplayIf);
    }

    private boolean loadModels(String string, PvViewer pvViewer, boolean bl, boolean bl2) {
        PjImportModel pjImportModel = new PjImportModel();
        if (bl) {
            pjImportModel.setAnimated(bl);
        }
        if (bl2 || string.endsWith(".mgs") || string.endsWith(".m") || string.endsWith(".jvd") || this.m_viewer.getParameter("Distance") != null || this.m_viewer.getParameter("Interest") != null) {
            pjImportModel.setEnabledAutoFit(false);
            this.m_disp.setAutoCenter(false);
        }
        if (string.endsWith(".mgs") || string.endsWith(".m") || string.endsWith(".mpl")) {
            pjImportModel.setEnabledLoadCamera(true);
        }
        this.m_viewer.addProject(pjImportModel);
        this.m_viewer.selectProject(pjImportModel);
        this.drawMessage("Loading " + string + " ...");
        pjImportModel.setFileName(string);
        if (!PsConfig.isApplication()) {
            String string2 = this.m_viewer.getParameter("project.panel");
            if (string2 == null) {
                string2 = this.m_viewer.getParameter("ProjectPanel");
            }
            if ("Show".equalsIgnoreCase(string2)) {
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                Object object;
                String string9;
                String string10 = this.m_viewer.getParameter("project.title");
                if (string10 != null) {
                    pjImportModel.setTitle(string10);
                }
                if ((string9 = this.m_viewer.getParameter("project.panel.backColor")) != null) {
                    object = PdColor.parseColor(string9);
                    pjImportModel.setBackColor((Color)object);
                }
                if ((object = this.m_viewer.getParameter("project.panel.borderType")) != null) {
                    if (((String)object).equalsIgnoreCase("none")) {
                        pjImportModel.setBorderType(0);
                    } else if (((String)object).equalsIgnoreCase("line")) {
                        pjImportModel.setBorderType(1);
                    } else if (((String)object).equalsIgnoreCase("sunk")) {
                        pjImportModel.setBorderType(2);
                    } else if (((String)object).equalsIgnoreCase("groove")) {
                        pjImportModel.setBorderType(3);
                    }
                }
                if ((string8 = this.m_viewer.getParameter("project.notice")) != null) {
                    pjImportModel.setNotice(string8);
                }
                if ((string7 = this.m_viewer.getParameter("project.import.loadCamera")) != null) {
                    pjImportModel.setEnabledLoadCamera(string7.equalsIgnoreCase("enable"));
                }
                if ((string6 = this.m_viewer.getParameter("project.import.autoFit")) != null) {
                    pjImportModel.setEnabledAutoFit(string6.equalsIgnoreCase("enable"));
                }
                if ((string5 = this.m_viewer.getParameter("project.import.baseDir")) != null) {
                    pjImportModel.setBase(PsConfig.getCodeBase() + string5);
                }
                if ((string4 = this.m_viewer.getParameter("project.panel.numRows")) != null) {
                    try {
                        int n = Integer.parseInt(string4);
                        pjImportModel.setNumRows(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PsDebug.warning("wrong integer format in project.panel.numRows");
                    }
                }
                if ((string3 = this.m_viewer.getParameter("project.panel.type")) == null) {
                    string3 = this.m_viewer.getParameter("projectpaneltype");
                }
                if ("Small".equalsIgnoreCase(string3)) {
                    pjImportModel.setTypeOfInfoPanel(1);
                    this.setLayout(new BorderLayout());
                    this.add((Component)this.m_disp.getCanvas(), "Center");
                    this.add((Component)this.m_viewer.getPanel(10), "South");
                } else if ("Medium".equalsIgnoreCase(string3)) {
                    String[] stringArray;
                    String string11 = this.m_viewer.getParameter("project.import.models");
                    if (string11 != null) {
                        stringArray = PuString.splitString(string11, ';');
                        pjImportModel.setModelNames(stringArray);
                    }
                    if ((stringArray = this.m_viewer.getParameter("project.import.select")) != null) {
                        pjImportModel.setFileName(pjImportModel.getBaseDir() + (String)stringArray);
                        pjImportModel.setSelectedFileName((String)stringArray);
                    }
                    pjImportModel.setTypeOfInfoPanel(2);
                    this.setLayout(new PsSlotLayout(8));
                    this.add("5", this.m_disp.getCanvas());
                    this.add("3", this.m_viewer.getPanel(10));
                } else {
                    this.setLayout(new PsSlotLayout(8));
                    this.add("5", this.m_disp.getCanvas());
                    this.add("3", this.m_viewer.getPanel(10));
                }
            }
        } else {
            pjImportModel.setEnabledRemoveGeometry(true);
            if (!pjImportModel.load(string)) {
                return false;
            }
            this.m_frame.setTitle(PsConfig.getProgramAndVersion() + ": " + string);
            PsJavaView.setFullFileName(7, string);
            pjImportModel.setFileName(null);
            this.m_viewer.removeProject(pjImportModel);
        }
        return true;
    }

    private boolean loadModelFromStream(BufferedReader bufferedReader, String string, String string2, boolean bl) {
        PgGeometry[] pgGeometryArray;
        if (bufferedReader == null) {
            PsDebug.warning("missing stream = " + string);
            return false;
        }
        try {
            if (!bufferedReader.ready()) {
                PsDebug.warning("stream not ready for reading, stream = " + string);
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 == null) {
            PsDebug.warning("Format of geometry model not supplied, assuming JVX format.\n\tAdd command line parameter: format=jvx");
            string2 = "jvx";
        }
        PsDebug.message("Reading from stream = " + string + ", format = " + string2, false);
        PgLoader pgLoader = new PgLoader();
        if (bl) {
            pgLoader.setAnimated(bl);
        }
        if ((pgGeometryArray = pgLoader.loadGeometry(null, bufferedReader, string2)) == null) {
            PsDebug.warning("failed reading from stream = " + string);
            return false;
        }
        for (int i = 0; i < pgGeometryArray.length; ++i) {
            if (pgGeometryArray[i] == null) continue;
            this.m_disp.addGeometry(pgGeometryArray[i]);
        }
        if (this.m_dispOption == null) {
            this.m_dispOption = pgLoader.getDisplayOption();
        }
        return true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = 400;
        dimension.height = 500;
        return dimension;
    }

    private void drawMessage(String string) {
        if (string == null) {
            return;
        }
        this.m_drawString = PuString.splitString(string, '\n');
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        if (graphics == null || dimension == null || dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        if (this.m_backgroundColor != null) {
            graphics.setColor(this.m_backgroundColor);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgramAndVersion(), 20, 40);
        graphics.drawString(PsConfig.getHomepage(), 20, 55);
        if (this.m_drawString != null) {
            String[] stringArray = (String[])this.m_drawString.clone();
            for (n = 0; n < stringArray.length; ++n) {
                graphics.drawString(stringArray[n], 20, 80 + n * 15);
            }
        }
        if (this.m_imageLaunch != null) {
            int n2 = this.m_imageLaunch.getWidth(null);
            n = this.m_imageLaunch.getHeight(null);
            if (n2 <= 0 || n <= 0) {
                return;
            }
            if (n2 <= dimension.width && n <= dimension.height) {
                graphics.drawImage(this.m_imageLaunch, (dimension.width - n2) / 2, (dimension.height - n) / 2, null);
            }
        }
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        try {
            int n = 100;
            int n2 = 5000;
            for (int i = 0; this.m_disp == null && i < n2 / n; ++i) {
                Thread.sleep(n);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_disp == null) {
            PsDebug.warning("missing display, could not register pick listener.");
            return;
        }
        this.m_disp.addPickListener(pvPickListenerIf);
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_disp == null) {
            return false;
        }
        return this.m_disp.removePickListener(pvPickListenerIf);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            if (this.m_bProfile) {
                System.out.println("jv[" + String.valueOf(this.m_appletCntOwn) + "] Destroy");
            }
            this.m_viewer.destroy();
        }
        this.m_frame = null;
        this.m_framePosition = null;
        this.m_frameSize = null;
        this.m_viewer = null;
        this.m_disp = null;
        this.m_dispOption = null;
        PsConfig.reset();
        PsConfig.runGC();
    }

    public void stop() {
        if (this.m_viewer != null) {
            if (this.m_bProfile) {
                System.out.println("jv[" + String.valueOf(this.m_appletCntOwn) + "] Stop");
            }
            this.m_viewer.stop();
        }
    }

    public void finalize() throws Throwable {
        if (this.m_bProfile) {
            System.out.println("jv[" + String.valueOf(this.m_appletCntOwn) + "] Finalize");
        }
        super.finalize();
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
        if (PsConfig.isApplication()) {
            Object object;
            String string = this.m_viewer.getParameter("ExportModel");
            if (string != null) {
                object = new PgLoader();
                ((PgLoader)object).saveGeometry(this.m_disp.getGeometries(), string);
                System.out.println("saved model: " + string);
            }
            if (this.m_viewer != null && (object = this.m_viewer.getParameter("ExportImage")) != null) {
                String string2 = PsUtil.getFileExtension((String)object);
                int n = 60;
                if (string2 != null && string2.equalsIgnoreCase("jpg")) {
                    n = 62;
                } else if (string2 != null && string2.equalsIgnoreCase("ppm")) {
                    n = 64;
                } else if (string2 != null && string2.equalsIgnoreCase("eps")) {
                    n = 68;
                } else if (string2 != null && string2.equalsIgnoreCase("ps")) {
                    n = 69;
                } else {
                    System.out.println("unknown image file extension: ext = " + string2);
                }
                if (this.m_frameSize != null) {
                    int n2 = this.m_frameSize.width;
                    int n3 = this.m_frameSize.height;
                    this.m_viewer.export(n, (String)object, n2, n3);
                    System.out.println("saved image(" + n2 + "," + n3 + ") " + (String)object);
                } else {
                    this.m_viewer.export(n, (String)object);
                    System.out.println("saved image(default) " + (String)object);
                }
            }
            if (this.m_bBatch) {
                this.destroy();
            }
        }
    }
}

