/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.transformAmbient;

import jv.geom.PgPolygonSet;
import jv.loader.PgLoader;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PjTransformAmbient
extends PjProject {
    protected PgPolygonSet m_surfaceSave;
    protected PgPolygonSet m_surface;
    protected PuDouble m_angleXW = new PuDouble("angleXW", (PsUpdateIf)this);
    protected PuDouble m_angleYW = new PuDouble("angleYW", (PsUpdateIf)this);
    protected PuDouble m_angleZW = new PuDouble("angleZW", (PsUpdateIf)this);
    protected PdMatrix m_modelMat = new PdMatrix(5);
    protected PdMatrix m_modelMatInv = new PdMatrix(5);
    protected double m_angleXWPrev;
    protected double m_angleYWPrev;
    protected double m_angleZWPrev;
    static /* synthetic */ Class class$vgp$tutor$transformAmbient$PjTransformAmbient;

    public PjTransformAmbient() {
        super("Transform Ambient");
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$transformAmbient$PjTransformAmbient == null ? (class$vgp$tutor$transformAmbient$PjTransformAmbient = PjTransformAmbient.class$("vgp.tutor.transformAmbient.PjTransformAmbient")) : class$vgp$tutor$transformAmbient$PjTransformAmbient)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_angleXW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleXW.setDefValue(0.0);
        this.m_angleXW.init();
        this.m_angleXWPrev = 0.0;
        this.m_angleYW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleYW.setDefValue(0.0);
        this.m_angleYW.init();
        this.m_angleYWPrev = 0.0;
        this.m_angleZW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleZW.setDefValue(0.0);
        this.m_angleZW.init();
        this.m_angleZWPrev = 0.0;
        if (this.m_surfaceSave != null && this.m_surface != null) {
            this.m_surface.copy((PsObject)this.m_surfaceSave);
        }
    }

    public void start() {
        PgLoader pgLoader = new PgLoader();
        PgGeometry[] pgGeometryArray = pgLoader.loadGeometry(new PgGeometry[]{this.m_surface}, PsConfig.getCodeBase() + "models/polytope/Cube4d.jvx");
        if (pgGeometryArray == null || pgGeometryArray.length == 0 || pgGeometryArray[0] == null) {
            PsDebug.warning((String)"loading failed.");
            return;
        }
        this.m_surface = (PgPolygonSet)pgGeometryArray[0];
        this.m_surface.setName("Exhibited Surface");
        this.m_surface.projectToSphere(new PdVector(4), 1.0);
        this.m_surface.setAmbientSpace(7);
        this.m_surface.setAmbientProjection(1);
        this.m_surfaceSave = (PgPolygonSet)this.m_surface.clone();
        this.addGeometry((PgGeometryIf)this.m_surface);
        this.selectGeometry((PgGeometryIf)this.m_surface);
        this.m_surface.update((Object)this.m_surface);
        super.start();
    }

    public boolean update(Object object) {
        if (object == this.m_angleXW) {
            double d = this.m_angleXW.getValue() - this.m_angleXWPrev;
            this.m_angleXWPrev = this.m_angleXW.getValue();
            this.rotateXW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        if (object == this.m_angleYW) {
            double d = this.m_angleYW.getValue() - this.m_angleYWPrev;
            this.m_angleYWPrev = this.m_angleYW.getValue();
            this.rotateYW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        if (object == this.m_angleZW) {
            double d = this.m_angleZW.getValue() - this.m_angleZWPrev;
            this.m_angleZWPrev = this.m_angleZW.getValue();
            this.rotateZW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        return false;
    }

    public void rotateXW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[0][0] = Math.cos(d);
        this.m_modelMat.m_data[0][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][0] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        this.m_modelMatInv.transpose(this.m_modelMat);
        PdMatrix pdMatrix = this.m_surface.getAmbientMatrix();
        pdMatrix.rightMult(this.m_modelMat, 5);
        PdMatrix pdMatrix2 = this.m_surface.getAmbientInvMatrix();
        pdMatrix2.rightMult(this.m_modelMatInv, 5);
        this.m_surface.setAmbientMatrix(pdMatrix, pdMatrix2);
    }

    public void rotateYW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[1][1] = Math.cos(d);
        this.m_modelMat.m_data[1][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][1] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        this.m_modelMatInv.transpose(this.m_modelMat);
        PdMatrix pdMatrix = this.m_surface.getAmbientMatrix();
        pdMatrix.rightMult(this.m_modelMat, 5);
        PdMatrix pdMatrix2 = this.m_surface.getAmbientInvMatrix();
        pdMatrix2.rightMult(this.m_modelMatInv, 5);
        this.m_surface.setAmbientMatrix(pdMatrix, pdMatrix2);
    }

    public void rotateZW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[2][2] = Math.cos(d);
        this.m_modelMat.m_data[2][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][2] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        this.m_modelMatInv.transpose(this.m_modelMat);
        PdMatrix pdMatrix = this.m_surface.getAmbientMatrix();
        pdMatrix.rightMult(this.m_modelMat, 5);
        PdMatrix pdMatrix2 = this.m_surface.getAmbientInvMatrix();
        pdMatrix2.rightMult(this.m_modelMatInv, 5);
        this.m_surface.setAmbientMatrix(pdMatrix, pdMatrix2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

