/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.firstProject;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import vgp.tutor.firstProject.MySurface;

public class MyProject
extends PjProject {
    protected MySurface m_geom = new MySurface();
    protected PuInteger m_numULines;
    protected PuInteger m_numVLines;

    public MyProject() {
        super("MyProject");
        this.m_geom.setName("Catenoid");
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName("Associate Family");
        psAnimation.addTimeListener((PsTimeListenerIf)this);
        this.m_numULines = new PuInteger("Number u-Lines", (PsUpdateIf)this);
        this.m_numVLines = new PuInteger("Number v-Lines", (PsUpdateIf)this);
        this.init();
    }

    public void init() {
        super.init();
        this.m_numULines.setDefBounds(2, 50, 1, 5);
        this.m_numULines.setDefValue(15);
        this.m_numULines.init();
        this.m_numVLines.setDefBounds(2, 50, 1, 5);
        this.m_numVLines.setDefValue(9);
        this.m_numVLines.init();
        this.m_geom.setGlobalElementColor(new Color(255, 37, 113));
        this.m_geom.showElementColors(false);
        this.m_geom.setGlobalElementBackColor(new Color(200, 200, 0));
        this.m_geom.showElementBackColor(true);
        this.m_geom.computeSurface(this.m_numULines.getValue(), this.m_numVLines.getValue());
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        if (super.hasAnimation()) {
            PsAnimation psAnimation = super.getAnimation();
            psAnimation.setTimeInterval(0.0, 720.0, 10.0, 20.0);
            psAnimation.getAnimationPanel().setVisible(true);
            psAnimation.start();
        }
        super.start();
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        this.m_geom.computeAnimation(d);
        this.m_geom.update((Object)this.m_geom);
        return super.update((Object)this);
    }

    public boolean update(Object object) {
        if (object == this.getInfoPanel()) {
            this.m_geom.computeSurface(this.m_numULines.getValue(), this.m_numVLines.getValue());
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        if (object == this.m_numULines || object == this.m_numVLines) {
            this.m_geom.computeSurface(this.m_numULines.getValue(), this.m_numVLines.getValue());
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        return super.update(object);
    }
}

