/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.object.PsObject;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_SchwarzD
extends PgWeierstrassDescr {
    private static PuComplex r0 = new PuComplex((Math.sqrt(3.0) - 1.0) / 2.0, (Math.sqrt(3.0) - 1.0) / 2.0);
    private static PuComplex r1 = new PuComplex((Math.sqrt(3.0) - 1.0) / 2.0, -(Math.sqrt(3.0) - 1.0) / 2.0);
    private static PuComplex r2 = new PuComplex(-(Math.sqrt(3.0) - 1.0) / 2.0, (Math.sqrt(3.0) - 1.0) / 2.0);
    private static PuComplex r3 = new PuComplex(-(Math.sqrt(3.0) - 1.0) / 2.0, -(Math.sqrt(3.0) - 1.0) / 2.0);
    private static PuComplex r4 = new PuComplex((Math.sqrt(3.0) + 1.0) / 2.0, (Math.sqrt(3.0) + 1.0) / 2.0);
    private static PuComplex r5 = new PuComplex((Math.sqrt(3.0) + 1.0) / 2.0, -(Math.sqrt(3.0) + 1.0) / 2.0);
    private static PuComplex r6 = new PuComplex(-(Math.sqrt(3.0) + 1.0) / 2.0, (Math.sqrt(3.0) + 1.0) / 2.0);
    private static PuComplex r7 = new PuComplex(-(Math.sqrt(3.0) + 1.0) / 2.0, -(Math.sqrt(3.0) + 1.0) / 2.0);
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_SchwarzD;

    public PgWeierstrass_SchwarzD() {
        super(1);
        this.setName("Schwarz D");
        this.m_bMarkBnd = true;
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_SchwarzD == null ? (class$vgp$minimal$weier$PgWeierstrass_SchwarzD = PgWeierstrass_SchwarzD.class$("vgp.minimal.weier.PgWeierstrass_SchwarzD")) : class$vgp$minimal$weier$PgWeierstrass_SchwarzD)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(7);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(13);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.setNumIntegratedPatches(2);
        this.setDomain(0, 0.0, 0.5, 0.0, 1.0);
        this.setDomain(1, 0.5, 1.0, 0.0, 1.0);
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(-puComplex.im * ((Math.sqrt(3.0) - 1.0) / 2.0 + puComplex.re * (3.0 - Math.sqrt(3.0)) / 2.0) - (1.0 - puComplex.im) * puComplex.re * (Math.sqrt(3.0) - 1.0) / 2.0, -puComplex.re * ((Math.sqrt(3.0) - 1.0) / 2.0 * (puComplex.im - 1.0)) - (1.0 - puComplex.re) * puComplex.im * (Math.sqrt(3.0) - 1.0) / 2.0);
        PuComplex puComplex3 = PuComplex.polarToRect((double)Math.sqrt(2.0), (double)(Math.PI * (0.4166666666666667 - puComplex.re / 6.0)));
        puComplex2 = PuComplex.add((PuComplex)puComplex2, (PuComplex)new PuComplex(puComplex.im * puComplex3.re + (1.0 - puComplex.im) * puComplex.re * (Math.sqrt(3.0) - 1.0) / 2.0, puComplex.im * (puComplex3.im - 1.0) - (1.0 - puComplex.im) * puComplex.re * (Math.sqrt(3.0) - 1.0) / 2.0));
        puComplex3 = PuComplex.polarToRect((double)Math.sqrt(2.0), (double)(Math.PI * (0.4166666666666667 - puComplex.im / 6.0)));
        puComplex2 = PuComplex.add((PuComplex)puComplex2, (PuComplex)new PuComplex(puComplex.re * puComplex3.re + (1.0 - puComplex.re) * puComplex.im * (Math.sqrt(3.0) - 1.0) / 2.0, puComplex.re * (1.0 - puComplex3.im) + (1.0 - puComplex.re) * puComplex.im * (Math.sqrt(3.0) - 1.0) / 2.0));
        if (n == 0) {
            PuComplex puComplex4 = PuComplex.sqrt((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r0));
            puComplex4 = new PuComplex(puComplex4.re - 1.0, puComplex4.im);
            return puComplex4;
        }
        PuComplex puComplex5 = PuComplex.sqrt((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r1));
        puComplex5 = new PuComplex(puComplex5.re + 1.0, puComplex5.im);
        return puComplex5;
    }

    public PuComplex f(PuComplex puComplex) {
        if (puComplex.re < 0.0) {
            PuComplex puComplex2 = PuComplex.add((PuComplex)PuComplex.sqr((PuComplex)new PuComplex(puComplex.re + 1.0, puComplex.im)), (PuComplex)r0);
            PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex2, (PuComplex)r1);
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r2));
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r3));
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r4));
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r5));
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r6));
            puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)r7));
            puComplex3.sqrt();
            puComplex3.inv();
            puComplex3.mult(PuComplex.I);
            return puComplex3;
        }
        PuComplex puComplex4 = PuComplex.add((PuComplex)PuComplex.sqr((PuComplex)new PuComplex(puComplex.re - 1.0, puComplex.im)), (PuComplex)r1);
        PuComplex puComplex5 = PuComplex.sub((PuComplex)puComplex4, (PuComplex)r0);
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r2));
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r3));
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r4));
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r5));
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r6));
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)r7));
        puComplex5.sqrt();
        puComplex5.inv();
        puComplex5.mult(PuComplex.I);
        return puComplex5;
    }

    public PuComplex g(PuComplex puComplex) {
        if (puComplex.re < 0.0) {
            PuComplex puComplex2 = PuComplex.add((PuComplex)PuComplex.sqr((PuComplex)new PuComplex(puComplex.re + 1.0, puComplex.im)), (PuComplex)r0);
            return puComplex2;
        }
        PuComplex puComplex3 = PuComplex.add((PuComplex)PuComplex.sqr((PuComplex)new PuComplex(puComplex.re - 1.0, puComplex.im)), (PuComplex)r1);
        return puComplex3;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(5, 1, 3, 1);
            this.connectPart(1, 5, 0, 5);
            this.connectPart(4, 5, 2, 5);
            this.connectPart(5, 5, 3, 5);
        }
        if (this.equals(piVector, new int[]{0, 0})) {
            this.connectPart(1, 3, 0, 1);
        }
    }

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 1);
            this.reflectPart(2, 0, 2);
            this.reflectPart(3, 1, 2);
            this.reflectPart(4, 2, 1);
            this.reflectPart(5, 4, 2);
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        piVector2.m_data[0] = 0;
        piVector2.m_data[2] = 0;
        if (n == 0) {
            piVector2.m_data[3] = 0;
        } else {
            piVector2.m_data[1] = 0;
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return piVector != null;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0 || this.equals(piVector, 0) && n == 0;
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 6;
        }
        if (this.equals(piVector, new int[]{0, 0})) {
            return 2;
        }
        return this.m_numUserReflections + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

