/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.subdivision;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwGeodesic;

public class PjSubdivisionCurve
extends PjProject {
    protected PgElementSet m_baseGeom = new PgElementSet(3);
    protected PgPolygonOnElementSet m_subdivCurve = new PgPolygonOnElementSet(this.m_baseGeom);
    protected PgPolygon m_controlPolygon;
    protected PgPointSet m_controlPoints;
    protected PdVector[] m_refpointPoints;
    protected PiVector m_refpointElem;
    protected PdBary[] m_refpointBary;
    protected PuInteger m_numPoints;
    protected PuInteger m_depth;
    protected boolean m_bUpdateSender = false;
    protected boolean m_bReuseTriangleRuns = true;
    protected boolean m_bShowTorus;
    protected boolean m_bShowTube;
    protected boolean m_bShowKnot;
    static /* synthetic */ Class class$vgp$curve$subdivision$PjSubdivisionCurve;
    static /* synthetic */ Class class$jv$geom$PgPointSet;

    public PjSubdivisionCurve() {
        super("Subdivision Curves");
        this.m_subdivCurve.setName("Subdivision curve");
        this.m_controlPolygon = new PgPolygon(3);
        this.m_controlPolygon.setName("Control polygon");
        this.m_controlPoints = new PgPointSet(3);
        this.m_controlPoints.setName("Control points");
        this.m_controlPoints.addUpdateListener((PsUpdateIf)this);
        this.m_refpointElem = new PiVector(0);
        this.m_refpointBary = new PdBary[0];
        this.m_depth = new PuInteger("Subdivision Depth", (PsUpdateIf)this);
        this.m_numPoints = new PuInteger("Num Control Points", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$subdivision$PjSubdivisionCurve == null ? (class$vgp$curve$subdivision$PjSubdivisionCurve = PjSubdivisionCurve.class$("vgp.curve.subdivision.PjSubdivisionCurve")) : class$vgp$curve$subdivision$PjSubdivisionCurve)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_depth.setDefBounds(0, 50, 1, 5);
        this.m_depth.setDefValue(0);
        this.m_depth.init();
        this.m_numPoints.setDefBounds(2, 20, 1, 2);
        this.m_numPoints.setDefValue(5);
        this.m_numPoints.init();
        this.m_controlPoints.setGlobalVertexSize(5.0);
        this.m_subdivCurve.setGlobalEdgeSize(3.0);
        this.m_subdivCurve.setGlobalEdgeColor(Color.blue);
        this.m_subdivCurve.showVertices(false);
        this.m_controlPolygon.setGlobalEdgeSize(2.0);
        this.m_controlPolygon.setGlobalEdgeColor(Color.red);
        this.m_controlPolygon.showVertices(false);
        this.m_baseGeom.setName("Torus");
        this.m_baseGeom.setDimOfElements(3);
        this.m_baseGeom.computeTorus(30, 30, 2.0, 1.0);
        this.m_baseGeom.makeElementNormals();
        this.m_baseGeom.makeVertexNormals();
        this.m_baseGeom.setGlobalElementColor(Color.lightGray);
        this.m_baseGeom.showTransparency(true);
        this.m_baseGeom.close();
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_baseGeom);
        this.addGeometry((PgGeometryIf)this.m_controlPoints);
        this.addGeometry((PgGeometryIf)this.m_controlPolygon);
        this.addGeometry((PgGeometryIf)this.m_subdivCurve);
        this.selectGeometry((PgGeometryIf)this.m_controlPoints);
        if (this.getDisplay() != null) {
            this.getDisplay().getCamera().setFieldOfView(0.0);
        }
        this.makeDefaultRefPoints();
        this.update((Object)this);
        super.start();
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (this.m_bUpdateSender) {
            return true;
        }
        if (object == this) {
            if (this.m_baseGeom != null) {
                this.m_bUpdateSender = true;
                this.computeCurve();
                this.m_subdivCurve.update((Object)this.m_subdivCurve);
                this.m_controlPoints.update((Object)this.m_controlPoints);
                this.m_controlPolygon.update((Object)this.m_controlPolygon);
                this.m_bUpdateSender = false;
            }
        } else {
            if (object == this.m_baseGeom) {
                return super.update(null);
            }
            if (object == this.m_numPoints) {
                this.makeDefaultRefPoints();
                this.update((Object)this);
                return true;
            }
            if (object == this.m_depth) {
                if (this.m_baseGeom != null) {
                    this.m_bUpdateSender = true;
                    this.computeCurve();
                    this.m_subdivCurve.update((Object)this.m_subdivCurve);
                    this.m_controlPoints.update(null);
                    this.m_controlPolygon.update(null);
                    this.m_bUpdateSender = false;
                }
                return super.update(null);
            }
            if (object == this.m_subdivCurve) {
                return super.update(null);
            }
            if (object == this.m_controlPoints) {
                if (this.m_baseGeom != null && !this.m_bUpdateSender) {
                    this.m_bUpdateSender = true;
                    this.projectRefpointsToGeom();
                    this.makeOrigCurve();
                    this.computeCurve();
                    this.m_subdivCurve.update((Object)this.m_subdivCurve);
                    this.m_controlPoints.update(null);
                    this.m_controlPolygon.update((Object)this.m_controlPolygon);
                    this.m_bUpdateSender = false;
                }
                return super.update(null);
            }
            if (object == this.m_controlPolygon) {
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public void removeGeometry() {
    }

    public boolean setGeometry(PgGeometryIf pgGeometryIf) {
        if (!(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        if (((PgElementSet)pgGeometryIf).getDimOfElements() != 3) {
            PsDebug.warning((String)("geometry must be triangulated, geom = " + pgGeometryIf.getName()));
            return false;
        }
        if (this.m_baseGeom != pgGeometryIf) {
            this.m_baseGeom.removeUpdateListener((PsUpdateIf)this);
            this.m_subdivCurve.setNumVertices(0);
            this.m_controlPolygon.setNumVertices(0);
            this.m_controlPoints.setNumVertices(0);
            this.m_baseGeom = null;
        }
        this.m_baseGeom = (PgElementSet)pgGeometryIf;
        this.m_baseGeom.addUpdateListener((PsUpdateIf)this);
        int n = this.m_baseGeom.getDimOfVertices();
        this.m_subdivCurve.setDimOfVertices(n);
        this.m_subdivCurve.setGeometry(this.m_baseGeom);
        this.m_controlPoints.setDimOfVertices(n);
        this.makeDefaultRefPoints();
        this.m_subdivCurve.update(null);
        this.m_controlPolygon.update(null);
        this.m_controlPoints.update(null);
        return true;
    }

    public boolean getReuseTriangleRunsWhileIterating() {
        return this.m_bReuseTriangleRuns;
    }

    public void setReuseTriangleRunsWhileIterating(boolean bl) {
        this.m_bReuseTriangleRuns = bl;
    }

    void useGivenReferencePoints() {
        PgGeometryIf pgGeometryIf = this.getDisplay().getSelectedGeometry();
        if (pgGeometryIf.getClass() != (class$jv$geom$PgPointSet == null ? (class$jv$geom$PgPointSet = PjSubdivisionCurve.class$("jv.geom.PgPointSet")) : class$jv$geom$PgPointSet)) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometryIf;
        int n = pgPointSet.getNumVertices();
        int n2 = pgPointSet.getDimOfVertices();
        this.m_refpointPoints = PdVector.realloc((PdVector[])this.m_refpointPoints, (int)n, (int)n2);
        this.m_refpointBary = PdBary.realloc((PdBary[])this.m_refpointBary, (int)n, (int)3);
        for (int i = 0; i < n; ++i) {
            this.m_refpointBary[i].copy(PdBary.TRIANGLE_CENTER);
        }
        this.m_refpointElem.setSize(n);
        this.m_controlPoints.copy((PsObject)pgPointSet);
        this.projectRefpointsToGeom();
        this.makeOrigCurve();
        this.m_subdivCurve.update((Object)this.m_subdivCurve);
        this.m_controlPolygon.update((Object)this.m_controlPolygon);
        this.m_controlPoints.update((Object)this.m_controlPoints);
    }

    protected void makeDefaultRefPoints() {
        int n;
        int n2;
        int n3 = this.m_numPoints.getValue();
        int n4 = this.m_baseGeom.getNumElements();
        if (n4 == 0) {
            return;
        }
        if (n4 < n3) {
            this.m_refpointBary = PdBary.realloc((PdBary[])this.m_refpointBary, (int)2, (int)3);
            this.m_refpointBary[0].copy(PdBary.TRIANGLE_VERTEX[0]);
            this.m_refpointBary[1].copy(PdBary.TRIANGLE_VERTEX[1]);
            this.m_refpointElem.setSize(2);
            this.m_refpointElem.setConstant(0);
        } else {
            this.m_refpointBary = PdBary.realloc((PdBary[])this.m_refpointBary, (int)n3, (int)3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_refpointBary[n2].copy(PdBary.TRIANGLE_CENTER);
            }
            this.m_refpointElem.setSize(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                int n5;
                boolean bl;
                block2: do {
                    n5 = (int)(Math.random() * (double)n4);
                    bl = false;
                    for (int i = 0; i < n2; ++i) {
                        if (this.m_refpointElem.m_data[i] != n5) continue;
                        bl = true;
                        continue block2;
                    }
                } while (bl);
                this.m_refpointElem.m_data[n2] = n5;
            }
        }
        n2 = this.m_baseGeom.getDimOfVertices();
        PdVector[] pdVectorArray = this.m_baseGeom.getVertices();
        PiVector[] piVectorArray = this.m_baseGeom.getElements();
        this.m_controlPoints.setNumVertices(n3);
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        for (n = 0; n < n3; ++n) {
            pdVector.setConstant(0.0);
            for (int i = 0; i < 3; ++i) {
                pdVector2.copyArray(pdVectorArray[piVectorArray[this.m_refpointElem.m_data[n]].m_data[i]]);
                pdVector2.multScalar(this.m_refpointBary[n].m_data[i]);
                pdVector.add(pdVector2);
                this.m_controlPoints.setVertex(n, pdVector);
            }
        }
        this.m_refpointPoints = PdVector.realloc((PdVector[])this.m_refpointPoints, (int)n3, (int)n2);
        for (n = 0; n < n3; ++n) {
            this.m_refpointPoints[n].copy(this.m_controlPoints.getVertex(n));
        }
        this.makeOrigCurve();
    }

    private void makeOrigCurve() {
        this.m_subdivCurve.setNumVertices(0);
        PjSubdivisionCurve.computeSubdivisionCurve(this.m_baseGeom, this.m_refpointElem, this.m_refpointBary, 0, this.m_subdivCurve, this.m_bReuseTriangleRuns);
        int n = this.m_controlPolygon.getNumVertices();
        for (int i = 0; i < n; ++i) {
            this.m_controlPolygon.clearTagVertex(i, 1);
        }
        this.m_controlPolygon.copy((PsObject)this.m_subdivCurve);
    }

    private void computeCurve() {
        PjSubdivisionCurve.computeSubdivisionCurve(this.m_baseGeom, this.m_refpointElem, this.m_refpointBary, this.m_depth.getValue(), this.m_subdivCurve, this.m_bReuseTriangleRuns);
    }

    public static PgPolygonOnElementSet computeSubdivisionCurve(PgElementSet pgElementSet, PiVector piVector, PdBary[] pdBaryArray, int n, PgPolygonOnElementSet pgPolygonOnElementSet, boolean bl) {
        int n2;
        int n3;
        if (piVector.getSize() < 2) {
            return null;
        }
        if (pgPolygonOnElementSet == null) {
            pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        }
        if (pgPolygonOnElementSet.getGeometry() != pgElementSet) {
            pgPolygonOnElementSet.setGeometry(pgElementSet);
        }
        double d = 0.25;
        double d2 = 0.75;
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n4 = piVector.getSize();
        PiVector piVector2 = new PiVector();
        PgPolygonOnElementSet pgPolygonOnElementSet2 = null;
        int n5 = n4;
        for (int i = 0; i < n; ++i) {
            n5 = 2 * n5 - 2;
        }
        Object object = null;
        if (bl) {
            object = new int[n5 - 1][];
            for (int i = 0; i < n4 - 1; ++i) {
                object[i] = PwGeodesic.getConnectingStrip((PgElementSet)pgElementSet, (int)piVector.m_data[i], (int)piVector.m_data[i + 1]);
                if (object[i] != null && object[i].length >= 1) continue;
                PsDebug.warning((String)"could not connect control points");
                return null;
            }
        }
        int[] nArray = new int[]{};
        PiVector piVector3 = new PiVector(n5);
        PdBary[] pdBaryArray2 = PdBary.realloc(null, (int)n5, (int)3);
        for (int i = 0; i < n4; ++i) {
            piVector3.m_data[i] = piVector.m_data[i];
            pdBaryArray2[i].copy(pdBaryArray[i]);
        }
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PgVertexStar pgVertexStar = new PgVertexStar();
        while (n4 < n5) {
            int n6;
            pdBaryArray2[2 * n4 - 2 - 1].copy(pdBaryArray2[n4 - 1]);
            piVector3.m_data[2 * n4 - 2 - 1] = piVector3.m_data[n4 - 1];
            n3 = (n4 - 2) * 2;
            for (n2 = n4 - 2; n2 >= 1; --n2) {
                pdBaryArray2[n3].copy(pdBaryArray2[n2]);
                piVector3.m_data[n3] = piVector3.m_data[n2];
                n3 -= 2;
            }
            n2 = 0;
            int n7 = piVector3.m_data[0];
            pdBary.copy(pdBaryArray2[0]);
            for (n6 = 1; n6 < n4; ++n6) {
                int n8 = n6 < n4 - 1 ? n2 + 2 : n2 + 1;
                if (bl) {
                    piVector2.setSize(object[n6 - 1].length);
                    pdBary2.copy(pdBaryArray2[n8]);
                    System.arraycopy(object[n6 - 1], 0, piVector2.m_data, 0, object[n6 - 1].length);
                    pgPolygonOnElementSet2 = PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBary, (int)n7, (PdBary)pdBaryArray2[n8], (int)piVector3.m_data[n8], (PiVector)piVector2, (PgPolygonOnElementSet)pgPolygonOnElementSet2);
                    n7 = piVector3.m_data[n8];
                    piVector3.m_data[n8] = piVector2.getLastEntry();
                    pdBary.copy(pdBary2);
                    if (object[n6 - 1].length != piVector2.getSize()) {
                        object[n6 - 1] = new int[piVector2.getSize()];
                    }
                    System.arraycopy(piVector2.m_data, 0, object[n6 - 1], 0, object[n6 - 1].length);
                } else {
                    piVector2.setSize(0);
                    pgPolygonOnElementSet2 = PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBaryArray2[n2], (int)piVector3.m_data[n2], (PdBary)pdBaryArray2[n8], (int)piVector3.m_data[n8], (PiVector)piVector2, pgPolygonOnElementSet2);
                }
                PjSubdivisionCurve.subdivideEdge(pgPolygonOnElementSet2, (PgPolygon)pgPolygonOnElementSet, d, d2, pdBaryArray2, piVector3, n2, n2 + 1, piVector2);
                n2 += 2;
            }
            if (bl) {
                n3 = (n4 - 2) * 2;
                for (n6 = n4 - 2; n6 >= 1; --n6) {
                    object[n3] = object[n6];
                    n3 -= 2;
                }
                n3 = 0;
                while (object[0][n3] != piVector3.m_data[0]) {
                    ++n3;
                }
                for (n6 = 0; n6 < n4 - 1; ++n6) {
                    int n9 = 2 * n6;
                    int n10 = 0;
                    do {
                        if (nArray.length < n10 + 1) {
                            int[] nArray2 = nArray;
                            nArray = new int[n10 + 11];
                            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                        }
                        if (n10 >= nArray.length || n9 >= ((int[][])object).length || n3 >= object[n9].length) {
                            PsDebug.error((String)"computation error, aborting");
                            return null;
                        }
                        nArray[n10] = object[n9][n3];
                        ++n3;
                    } while (nArray[++n10 - 1] != piVector3.m_data[n9 + 1]);
                    if (n6 < n4 - 2) {
                        object[n9 + 1] = object[n9];
                    }
                    object[n9] = new int[n10];
                    System.arraycopy(nArray, 0, object[n9], 0, n10);
                    if (n6 >= n4 - 2) continue;
                    n10 = object[n9 + 1].length - (n3 - 1);
                    if (nArray.length < n10) {
                        nArray = new int[n10 + 11];
                    }
                    System.arraycopy(object[n9 + 1], n3 - 1, nArray, 0, n10);
                    --n10;
                    int n11 = object[n9 + 1][object[n9 + 1].length - 1];
                    int n12 = object[n9 + 2][0];
                    if (n11 != n12) {
                        int n13;
                        int n14 = -1;
                        block10: for (n13 = 0; n13 < 3; ++n13) {
                            for (int i = 0; i < 3; ++i) {
                                if (piVectorArray[n11].m_data[n13] != piVectorArray[n12].m_data[i]) continue;
                                n14 = piVectorArray[n11].m_data[n13];
                                n13 = 2;
                                continue block10;
                            }
                        }
                        if (n14 < 0) {
                            PsDebug.error((String)"strips are not connected");
                            return null;
                        }
                        pgVertexStar.makeVertexStar(pgElementSet, n14, n11);
                        n13 = pgVertexStar.getFirstElemInd();
                        PiVector piVector4 = pgVertexStar.getElement();
                        int n15 = pgVertexStar.getSize();
                        while (piVector4.m_data[n13] != n12) {
                            if (nArray.length < n10 + 2) {
                                int[] nArray3 = nArray;
                                nArray = new int[n10 + 11];
                                System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
                            }
                            nArray[n10] = piVector4.m_data[n13];
                            ++n10;
                            if (++n13 < n15) continue;
                            n13 -= n15;
                        }
                        nArray[n10] = piVector4.m_data[n13];
                    }
                    n3 = 0;
                    while (object[n9 + 2][n3] != piVector3.m_data[n9 + 2]) {
                        ++n3;
                        if (nArray.length < ++n10 + 1) {
                            int[] nArray4 = nArray;
                            nArray = new int[n10 + 11];
                            System.arraycopy(nArray4, 0, nArray, 0, nArray4.length);
                        }
                        if (n10 >= nArray.length || n9 + 2 >= ((int[][])object).length || n3 >= object[n9 + 2].length) {
                            PsDebug.error((String)"sorry, computation failed");
                            return null;
                        }
                        nArray[n10] = object[n9 + 2][n3];
                    }
                    object[n9 + 1] = new int[++n10];
                    System.arraycopy(nArray, 0, object[n9 + 1], 0, n10);
                }
            }
            n4 = 2 * n4 - 2;
        }
        pgPolygonOnElementSet.setNumVertices(0);
        for (n3 = 1; n3 < n5; ++n3) {
            if (bl) {
                piVector2.setSize(object[n3 - 1].length);
                pdBary.copy(pdBaryArray2[n3 - 1]);
                pdBary2.copy(pdBaryArray2[n3]);
                System.arraycopy(object[n3 - 1], 0, piVector2.m_data, 0, object[n3 - 1].length);
                pgPolygonOnElementSet.merge((PgGeometryIf)PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBary, (int)piVector3.m_data[n3 - 1], (PdBary)pdBary2, (int)piVector3.m_data[n3], (PiVector)piVector2, null));
            } else {
                pgPolygonOnElementSet.merge((PgGeometryIf)PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBaryArray2[n3 - 1], (int)piVector3.m_data[n3 - 1], (PdBary)pdBaryArray2[n3], (int)piVector3.m_data[n3]));
            }
            piVector3.m_data[n3 - 1] = pgPolygonOnElementSet.getNumVertices() - 1;
        }
        PdVector[] pdVectorArray = pgPolygonOnElementSet.getVertices();
        for (n2 = 1; n2 < n5 - 1; ++n2) {
            pdVectorArray[piVector3.m_data[n2 - 1]].setTag(1);
        }
        return pgPolygonOnElementSet;
    }

    private static void subdivideEdge(PgPolygonOnElementSet pgPolygonOnElementSet, PgPolygon pgPolygon, double d, double d2, PdBary[] pdBaryArray, PiVector piVector, int n, int n2, PiVector piVector2) {
        pgPolygonOnElementSet.getPolygon(pgPolygon);
        double d3 = pgPolygon.getLength();
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        PdVector pdVector = new PdVector(pgPolygon.getDimOfVertices());
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        double[] dArray = new double[]{d3 * d, d3 * d2};
        int[] nArray = new int[]{n, n2};
        double d4 = 0.0;
        double d5 = 1.0;
        int n3 = 0;
        int n4 = 0;
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        for (int i = 0; i < 2; ++i) {
            while (d4 < dArray[i]) {
                pdVector.sub(pdVectorArray[++n3], pdVectorArray[n3 - 1]);
                d5 = pdVector.length();
                d4 += d5;
            }
            double d6 = (dArray[i] - (d4 - d5)) / d5;
            int n5 = pgPolygonOnElementSet.getVertexElemInd(n3);
            int n6 = pgPolygonOnElementSet.getVertexElemInd(n3 - 1);
            pdBary.copy(pgPolygonOnElementSet.getVertexBary(n3));
            pdBary2.copy(pgPolygonOnElementSet.getVertexBary(n3 - 1));
            n4 = PjSubdivisionCurve.equalizeElementIndex(pgPolygonOnElementSet, n3 - 1, n3, piVector2, n4);
            pdBaryDir.sub(pgPolygonOnElementSet.getVertexBary(n3), pgPolygonOnElementSet.getVertexBary(n3 - 1));
            pdBaryDir.multScalar(d6);
            pdBaryArray[nArray[i]].add(pgPolygonOnElementSet.getVertexBary(n3 - 1), pdBaryDir);
            piVector.m_data[nArray[i]] = pgPolygonOnElementSet.getVertexElemInd(n3);
            pgPolygonOnElementSet.setVertexBary(n3, n5, pdBary);
            pgPolygonOnElementSet.setVertexBary(n3 - 1, n6, pdBary2);
            --n3;
            d4 -= d5;
        }
    }

    private static int equalizeElementIndex(PgPolygonOnElementSet pgPolygonOnElementSet, int n, int n2, PiVector piVector, int n3) {
        int n4;
        int n5;
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray = n <= n2 ? new int[]{n, n2} : new int[]{n2, n};
        PiVector[] piVectorArray3 = PiVector.realloc(null, (int)2);
        PgVertexStar[] pgVertexStarArray = new PgVertexStar[]{null, null};
        int[] nArray2 = new int[]{-1, -1};
        for (int i = 0; i < 2; ++i) {
            int n6 = pgPolygonOnElementSet.getVertexElemInd(nArray[i]);
            PdBary pdBary = pgPolygonOnElementSet.getVertexBary(nArray[i]);
            int n7 = PwBary.liesOnVertex((PdBary)pdBary);
            if (n7 >= 0) {
                pgVertexStarArray[i] = new PgVertexStar();
                pgVertexStarArray[i].makeVertexStar(pgElementSet, piVectorArray[n6].m_data[n7], n6);
                piVectorArray3[i].setSize(pgVertexStarArray[i].getSize());
                piVectorArray3[i].copyArray(pgVertexStarArray[i].getElement());
                continue;
            }
            nArray2[i] = PwBary.getEdgeIndex((PdBary)pdBary);
            if (nArray2[i] != -1) {
                piVectorArray3[i].setSize(2);
                piVectorArray3[i].set(n6, piVectorArray2[n6].m_data[nArray2[i]]);
                continue;
            }
            piVectorArray3[i].setSize(1);
            piVectorArray3[i].set(n6);
        }
        int[] nArray3 = new int[]{-1, -1};
        int n8 = -1;
        int n9 = piVectorArray3[0].getSize();
        int n10 = piVectorArray3[1].getSize();
        if (piVector == null || pgVertexStarArray[0] == null || pgVertexStarArray[1] == null) {
            block1: for (n5 = 0; n5 < n9; ++n5) {
                for (n4 = 0; n4 < n10; ++n4) {
                    if (piVectorArray3[0].m_data[n5] != piVectorArray3[1].m_data[n4]) continue;
                    nArray3[0] = n5;
                    nArray3[1] = n4;
                    n8 = piVectorArray3[0].m_data[n5];
                    continue block1;
                }
            }
        } else {
            int n11;
            n5 = 0;
            n4 = 0;
            while (n4 == 0 && n3 < piVector.getSize()) {
                if (n5 == 0) {
                    for (n11 = 0; n11 < n9; ++n11) {
                        if (piVector.m_data[n3] != piVectorArray3[0].m_data[n11]) continue;
                        n5 = 1;
                        nArray3[0] = n11;
                        break;
                    }
                } else {
                    n5 = 0;
                    for (n11 = 0; n11 < n9; ++n11) {
                        if (piVector.m_data[n3] != piVectorArray3[0].m_data[n11]) continue;
                        n5 = 1;
                        nArray3[0] = n11;
                        break;
                    }
                    if (n5 == 0) {
                        n4 = 1;
                    }
                }
                ++n3;
            }
            n3 = n3 >= piVector.getSize() ? --n3 : (n3 -= 2);
            if (n3 >= 0) {
                n8 = piVector.m_data[n3];
                for (n11 = 0; n11 < n10; ++n11) {
                    if (n8 != piVectorArray3[1].m_data[n11]) continue;
                    nArray3[1] = n11;
                    break;
                }
            }
        }
        if (n8 < 0) {
            return -1;
        }
        for (n5 = 0; n5 < 2; ++n5) {
            if (nArray3[n5] == 0) continue;
            if (pgVertexStarArray[n5] != null) {
                pgPolygonOnElementSet.setVertexBary(nArray[n5], n8, PdBary.TRIANGLE_VERTEX[pgVertexStarArray[n5].getVertexLocInd().getEntry(nArray3[n5])]);
                continue;
            }
            PwBary.changeBarycentricOnEdge((PdBary)pgPolygonOnElementSet.getVertexBary(nArray[n5]), (int)nArray2[n5], (int)pgElementSet.getOppVertexLocInd(pgPolygonOnElementSet.getVertexElemInd(nArray[n5]), nArray2[n5]));
            pgPolygonOnElementSet.setVertexBary(nArray[n5], n8, pgPolygonOnElementSet.getVertexBary(nArray[n5]));
        }
        return n3;
    }

    private void projectRefpointsToGeom() {
        int n;
        if (this.m_controlPoints == null || this.m_refpointPoints == null) {
            return;
        }
        int n2 = this.m_controlPoints.getNumVertices();
        if (n2 != (n = this.m_refpointPoints.length)) {
            this.m_controlPoints.setNumVertices(n);
            this.m_controlPoints.setVertices(this.m_refpointPoints);
            return;
        }
        PdVector pdVector = this.getDisplay().getCamera().getViewDir();
        PdVector pdVector2 = new PdVector(this.m_baseGeom.getDimOfVertices());
        PdVector[] pdVectorArray = this.m_baseGeom.getVertices();
        PiVector[] piVectorArray = this.m_baseGeom.getElements();
        for (int i = 0; i < n2; ++i) {
            if (this.m_refpointPoints[i] != null && PdVector.sqrDist((PdVector)this.m_controlPoints.getVertex(i), (PdVector)this.m_refpointPoints[i]) < 1.0E-10) continue;
            PvPickEvent pvPickEvent = this.m_baseGeom.intersectionWithLine(this.m_controlPoints.getVertex(i), pdVector);
            if (pvPickEvent != null) {
                this.m_refpointElem.m_data[i] = pvPickEvent.getElementInd();
                this.m_refpointBary[i].copy(pvPickEvent.getBary());
            }
            this.m_refpointBary[i].getVertex(pdVector2, pdVectorArray[piVectorArray[this.m_refpointElem.m_data[i]].m_data[0]], pdVectorArray[piVectorArray[this.m_refpointElem.m_data[i]].m_data[1]], pdVectorArray[piVectorArray[this.m_refpointElem.m_data[i]].m_data[2]]);
            this.m_controlPoints.setVertex(i, pdVector2);
            this.m_refpointPoints[i].copy(pdVector2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

