/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;

public class PnStraightestGeodesic {
    public static double BARYEPS = 0.005;
    public double m_eps = BARYEPS;
    protected PgElementSet m_geom;
    protected PiVector[] m_opposingElement;
    protected PdMatrix[][] m_edgeTransformation;
    protected double m_accuracy = 1.0E-10;
    protected final boolean m_bPrecomputeMatrices;
    protected boolean m_bIsSavingMatrices;
    private PdBary m_transformedPoint = new PdBary(3);
    private PdBaryDir m_transformedDir = new PdBaryDir(3);
    private PdBary m_intersectionPoint = new PdBary(3);
    private PdMatrix m_transformationMatrix = null;
    private PdVector m_vector = null;
    private PdVector m_thisVertex = null;
    private PdVector m_otherVertex = null;
    private PdVector m_edge = null;
    private PdVector m_proj = null;

    public PnStraightestGeodesic(PgElementSet pgElementSet) {
        this(pgElementSet, false);
    }

    public PnStraightestGeodesic(PgElementSet pgElementSet, boolean bl) {
        this.m_bIsSavingMatrices = bl;
        this.m_bPrecomputeMatrices = bl;
        this.setGeometry(pgElementSet);
    }

    public int eval(PdBary pdBary, PdBaryDir pdBaryDir, PdBary pdBary2) {
        return this.eval(pdBary, pdBaryDir, pdBary2, null, null);
    }

    public int eval(PdBary pdBary, PdBaryDir pdBaryDir, PdBary pdBary2, PdBaryDir pdBaryDir2) {
        return this.eval(pdBary, pdBaryDir, pdBary2, pdBaryDir2, null);
    }

    public int eval(PdBary pdBary, PdBaryDir pdBaryDir, PgPolygonOnElementSet pgPolygonOnElementSet, PdBaryDir pdBaryDir2) {
        return this.eval(pdBary, pdBaryDir, null, pdBaryDir2, pgPolygonOnElementSet);
    }

    public int eval(PdBary pdBary, PdBaryDir pdBaryDir, PgPolygonOnElementSet pgPolygonOnElementSet) {
        return this.eval(pdBary, pdBaryDir, null, null, pgPolygonOnElementSet);
    }

    public int eval(PdBary pdBary, PdBaryDir pdBaryDir, PdBary pdBary2, PdBaryDir pdBaryDir2, PgPolygonOnElementSet pgPolygonOnElementSet) {
        int n;
        int n2;
        if (pdBary.m_elementInd < 0) {
            return -1;
        }
        PdBary[] pdBaryArray = null;
        int n3 = 1;
        if (pgPolygonOnElementSet != null) {
            pgPolygonOnElementSet.setMaxNumVertices(100);
            pgPolygonOnElementSet.setNumVertices(2);
            pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        }
        PdBary pdBary3 = pgPolygonOnElementSet != null ? pdBaryArray[0] : (pdBary2 != null ? pdBary2 : this.m_transformedPoint);
        PdBaryDir pdBaryDir3 = pdBaryDir2 != null ? pdBaryDir2 : this.m_transformedDir;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        pdBary3.copy(pdBary);
        pdBaryDir3.copy(pdBaryDir);
        double[] dArray = pdBary3.m_data;
        double[] dArray2 = pdBaryDir3.m_data;
        for (n2 = 0; n2 < 3 && !(dArray[n2] < -this.m_accuracy); ++n2) {
            if (!(dArray[n2] <= this.m_accuracy)) continue;
            int n4 = n2;
            dArray2[n4] = dArray2[n4] + dArray[n2];
            dArray[n2] = 0.0;
            bl3 = bl2;
            bl2 = true;
            bl4 |= dArray2[n2] < -this.m_accuracy;
        }
        if (bl2) {
            pdBary3.validate();
            pdBaryDir3.validate();
        }
        if (bl) {
            return -1;
        }
        if (bl3 && bl4) {
            n = PnStraightestGeodesic.createVectorAtVertexThatShowsIntoElement(this.m_geom, pdBary3.m_elementInd, pdBary3, pdBaryDir3);
            if (n != -1) {
                pdBary3.m_elementInd = n;
            } else {
                if (pgPolygonOnElementSet != null) {
                    pgPolygonOnElementSet.setNumVertices(1);
                    pgPolygonOnElementSet.setVertexBary(0, pdBary);
                }
                if (pdBaryDir2 != null) {
                    pdBaryDir2.setZero();
                }
                if (pdBary2 != null) {
                    pdBary2.copy(pdBary);
                }
                return 0;
            }
        }
        int n5 = n = bl2 && !bl3 && bl4 ? 1 : 0;
        if (pgPolygonOnElementSet != null && n == 0) {
            n3 = 2;
            pdBaryArray[0].copy(pdBary3);
            pdBary3 = pdBaryArray[1];
            pdBary3.add(pdBaryArray[0], pdBaryDir3);
            pdBary3.m_elementInd = pdBaryArray[0].m_elementInd;
            dArray = pdBary3.m_data;
        } else {
            pdBary3.add(pdBaryDir3);
        }
        int n6 = 1;
        PdBary pdBary4 = this.m_intersectionPoint;
        while (true) {
            int n7;
            int n8 = -1;
            double d = 0.0;
            int n9 = -1;
            for (n7 = 0; n7 < 3; ++n7) {
                double d2;
                if (!(dArray[n7] < -this.m_accuracy) || !(dArray2[n7] < 0.0) || !((d2 = dArray[n7] / dArray2[n7]) > d)) continue;
                d = d2;
                n9 = n7;
            }
            if (n9 == -1) break;
            if (pgPolygonOnElementSet != null) {
                pgPolygonOnElementSet.setNumVertices(n3 + 1);
                pdBaryArray = pgPolygonOnElementSet.getVertexBary();
                pdBary4 = pdBaryArray[n3];
                pdBaryArray[n3] = pdBary3;
                pdBaryArray[n3 - 1] = pdBary4;
                ++n3;
            }
            boolean bl5 = false;
            for (n7 = 0; n7 < 3; ++n7) {
                if (n7 == n9) continue;
                if (dArray[n7] < this.m_accuracy && Math.abs(dArray[n7] - d * dArray2[n7]) < this.m_accuracy) {
                    bl5 = true;
                    continue;
                }
                n8 = n7;
            }
            if (bl5) {
                pdBaryDir3.multScalar(-1.0);
                n2 = PwBary.rotateAtVertex(this.m_geom, pdBary3.m_elementInd, n8, pdBaryDir3, pdBaryDir3, pdBary4, Math.PI);
                if (n2 < 0) {
                    pdBaryDir3.multScalar(-(1.0 - d));
                    int n10 = pdBary3.m_elementInd;
                    pdBary3.copy(PdBary.TRIANGLE_VERTEX[n8]);
                    pdBary3.m_elementInd = n10;
                    n6 = 0;
                    break;
                }
                pdBary4.m_elementInd = n2;
                PdBary.add((PdBary)pdBary4, (double)d, (PdBaryDir)pdBaryDir3, (PdBary)pdBary3);
            } else {
                PdMatrix pdMatrix;
                n2 = this.m_opposingElement[pdBary3.m_elementInd].m_data[n9];
                PdMatrix pdMatrix2 = pdMatrix = n2 < 0 ? null : this.getTransformation(pdBary3.m_elementInd, n9);
                if (pdMatrix == null) {
                    n6 = 0;
                    PdBary.add((PdBary)pdBary3, (double)(-d), (PdBaryDir)pdBaryDir3, (PdBary)pdBary3);
                    pdBaryDir3.multScalar(1.0 - d);
                    break;
                }
                pdBary3.leftMultMatrix(pdMatrix);
                pdBaryDir3.leftMultMatrix(pdMatrix);
                if (pgPolygonOnElementSet != null) {
                    PdBary.add((PdBary)pdBary3, (double)(-d), (PdBaryDir)pdBaryDir3, (PdBary)pdBary4);
                    int n11 = this.m_geom.getOppVertexLocInd(pdBary3.m_elementInd, n9);
                    pdBary4.m_data[n11] = 0.0;
                    pdBary4.m_elementInd = n2;
                }
            }
            pdBary3.m_elementInd = n2;
        }
        if (pgPolygonOnElementSet != null) {
            if (n6 == 0) {
                pgPolygonOnElementSet.setNumVertices(--n3);
                pdBaryArray[n3 - 1] = pdBary3;
                pdBaryArray[n3] = pdBary4;
            }
            if (pdBary2 != null) {
                pdBary2.copy(pdBary3);
            }
        }
        return n6;
    }

    private static int createVectorAtVertexThatShowsIntoElement(PgElementSet pgElementSet, int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        int n2 = PwBary.liesOnVertex(pdBary);
        if (n2 == -1 || PwBary.showsIntoElement(pdBaryDir, n2)) {
            return n;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.copyArray(PdBaryDir.TRIANGLE_EDGE[(n2 + 2) % 3]);
        pdBaryDir2.multScalar(PwBary.norm(pgElementSet, n, pdBaryDir, true) / PwBary.norm(pgElementSet, n, pdBaryDir2, false));
        double d = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir2, pdBaryDir, true);
        if (d == Double.NEGATIVE_INFINITY) {
            return -1;
        }
        n = PwBary.rotateAtVertex(pgElementSet, n, n2, pdBaryDir2, pdBaryDir, pdBary, d);
        return n;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        boolean bl = this.m_bPrecomputeMatrices;
        this.m_geom = pgElementSet;
        if (bl || this.m_bIsSavingMatrices) {
            int n = pgElementSet.getNumElements();
            this.m_edgeTransformation = new PdMatrix[n][3];
        }
        this.m_opposingElement = pgElementSet.getNeighbours();
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.getEdgeStars();
        pgEdgeStarArray = pgElementSet.makeEdgeStars();
        int n = pgElementSet.getNumEdgeStars();
        for (int i = 0; i < n; ++i) {
            PdMatrix pdMatrix;
            PgEdgeStar pgEdgeStar = pgEdgeStarArray[i];
            int n2 = pgEdgeStar.getValence();
            if (n2 == 1) continue;
            int n3 = pgEdgeStar.getElementInd(0);
            int n4 = pgEdgeStar.getNeighbourLocInd(0);
            int n5 = pgEdgeStar.getElementInd(1);
            int n6 = pgEdgeStar.getNeighbourLocInd(1);
            if (!bl) continue;
            this.m_edgeTransformation[n3][n4] = pdMatrix = this.computeTransformation(n3, n4, new PdMatrix(3));
            this.m_edgeTransformation[n5][n6] = pdMatrix = this.computeTransformation(n5, n6, new PdMatrix(3));
        }
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    private PdMatrix computeTransformation(int n, int n2, PdMatrix pdMatrix) {
        int n3;
        int n4;
        int n5;
        int n6 = this.m_opposingElement[n].m_data[n2];
        if (n6 == -1) {
            return null;
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        if (this.m_vector == null) {
            n5 = this.m_geom.getDimOfVertices();
            this.m_vector = new PdVector(n5);
            this.m_thisVertex = new PdVector(n5);
            this.m_otherVertex = new PdVector(n5);
            this.m_edge = new PdVector(n5);
            this.m_proj = new PdVector(n5);
        }
        n5 = (n2 + 1) % 3;
        int n7 = (n2 + 2) % 3;
        int[] nArray = piVectorArray[n].m_data;
        int[] nArray2 = piVectorArray[n6].m_data;
        int n8 = nArray[n2];
        int n9 = nArray[n5];
        int n10 = nArray[n7];
        for (n4 = 0; n4 < 3 && n9 != nArray2[n4]; ++n4) {
        }
        for (n3 = 0; n3 < 3 && n10 != nArray2[n3]; ++n3) {
        }
        int n11 = (2 * n4 - n3 + 3) % 3;
        pdMatrix.setConstant(0.0);
        pdMatrix.setEntry(n4, n5, 1.0);
        pdMatrix.setEntry(n3, n7, 1.0);
        this.m_thisVertex.sub(pdVectorArray[n8], pdVectorArray[n9]);
        this.m_otherVertex.sub(pdVectorArray[nArray2[n11]], pdVectorArray[n9]);
        this.m_edge.sub(pdVectorArray[n10], pdVectorArray[n9]);
        this.m_edge.normalize();
        this.m_proj.multScalar(this.m_edge, this.m_thisVertex.dot(this.m_edge));
        double d = PdVector.dist((PdVector)this.m_thisVertex, (PdVector)this.m_proj);
        this.m_otherVertex.orthonormalize(this.m_edge);
        this.m_otherVertex.multScalar(d);
        this.m_vector.sub(this.m_proj, this.m_otherVertex);
        this.m_vector.add(pdVectorArray[n9]);
        PdBary pdBary = new PdBary(3);
        PdBary.getBary((PdBary)pdBary, (PdVector)this.m_vector, (PdVector)pdVectorArray[nArray2[0]], (PdVector)pdVectorArray[nArray2[1]], (PdVector)pdVectorArray[nArray2[2]]);
        if (pdBary.m_data[n11] > -this.m_accuracy) {
            return null;
        }
        pdMatrix.setColumn(n2, new PdVector(pdBary.m_data));
        return pdMatrix;
    }

    private PdMatrix getTransformation(int n, int n2) {
        PdMatrix pdMatrix = null;
        if (this.m_bIsSavingMatrices) {
            pdMatrix = this.m_edgeTransformation[n][n2];
            if (pdMatrix != null) {
                return pdMatrix;
            }
            pdMatrix = new PdMatrix(3);
        } else {
            if (this.m_transformationMatrix == null) {
                this.m_transformationMatrix = new PdMatrix(3);
            }
            pdMatrix = this.m_transformationMatrix;
        }
        pdMatrix = this.computeTransformation(n, n2, pdMatrix);
        if (this.m_bIsSavingMatrices) {
            this.m_edgeTransformation[n][n2] = pdMatrix;
        }
        return pdMatrix;
    }

    public double getAccuracy() {
        return this.m_accuracy;
    }

    public void setAccuracy(double d) {
        this.m_accuracy = d;
    }

    public boolean isSavingMatrices() {
        return this.m_bIsSavingMatrices;
    }

    public void setSavingMatrices(boolean bl) {
        if (!bl) {
            this.m_edgeTransformation = null;
        } else if (this.m_edgeTransformation == null) {
            int n = this.m_geom.getNumElements();
            this.m_edgeTransformation = new PdMatrix[n][3];
        }
        this.m_bIsSavingMatrices = bl;
    }
}

