/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnStiffMatrix;

public class PnStiffConformal
extends PnStiffMatrix {
    static /* synthetic */ Class class$jvx$numeric$PnStiffConformal;

    public PnStiffConformal(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        super(pgElementSet);
        int n;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        this.setSize(pgElementSet.getNumVertices());
        this.m_noe = pgElementSet.getNumElements();
        this.m_snoe.setConstant(0);
        for (n = 0; n < this.m_noe; ++n) {
            int n2 = piVectorArray[n].getSize();
            for (int i = 0; i < n2; ++i) {
                if (piVectorArray2[n].m_data[i] >= 0 && piVectorArray2[n].m_data[i] <= n) continue;
                int n3 = piVectorArray[n].m_data[(i + 1) % n2];
                this.m_snoe.m_data[n3] = this.m_snoe.m_data[n3] + 1;
                int n4 = piVectorArray[n].m_data[(i + 2) % n2];
                this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] + 1;
            }
        }
        for (n = 0; n < this.m_iSize; ++n) {
            if (this.m_snoe.m_data[n] <= 0) continue;
            int n5 = n;
            this.m_snoe.m_data[n5] = this.m_snoe.m_data[n5] + 1;
        }
        for (n = 0; n < this.m_iSize; ++n) {
            if (this.m_snoe.m_data[n] <= 0) continue;
            if (this.m_sindx[n] == null) {
                this.m_sindx[n] = new PiVector(this.m_snoe.m_data[n]);
            } else {
                this.m_sindx[n].setSize(this.m_snoe.m_data[n]);
            }
            if (this.m_stiff[n] == null) {
                this.m_stiff[n] = new PdVector(this.m_snoe.m_data[n]);
                continue;
            }
            this.m_stiff[n].setSize(this.m_snoe.m_data[n]);
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnStiffConformal == null ? (class$jvx$numeric$PnStiffConformal = PnStiffConformal.class$("jvx.numeric.PnStiffConformal")) : class$jvx$numeric$PnStiffConformal)) {
            this.init(pgElementSet, pgElementSet2);
        }
    }

    public void init(PgElementSet pgElementSet) {
        super.init();
    }

    public void init(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        super.init();
        if (pgElementSet.getNumVertices() != this.m_iSize || pgElementSet.getNumElements() != this.m_noe || pgElementSet2.getNumVertices() != this.m_iSize || pgElementSet2.getNumElements() != this.m_noe) {
            PsDebug.warning((String)"meshes of domain and surface differ.");
            return;
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (n4 = 0; n4 < this.m_iSize; ++n4) {
            if (this.m_snoe.m_data[n4] <= 0) continue;
            this.m_sindx[n4].setConstant(-1);
            this.m_stiff[n4].setConstant(0.0);
        }
        PdVector pdVector = new PdVector(3);
        double[] dArray = pdVector.m_data;
        boolean bl = false;
        for (n4 = 0; n4 < this.m_noe; ++n4) {
            nArray = piVectorArray[n4].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            if (!bl && pdVector.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + n4));
            }
            for (n3 = 0; n3 < 3; ++n3) {
                n2 = nArray[n3];
                n = nArray[(n3 + 2) % 3];
                int n5 = this.getIndex(n2, n2);
                this.m_stiff[n2].m_data[n5] = this.m_stiff[n2].m_data[n5] + (dArray[(n3 - 1 + 3) % 3] + dArray[(n3 + 1) % 3]) / 4.0;
                int n6 = this.getIndex(n2, n);
                this.m_stiff[n2].m_data[n6] = this.m_stiff[n2].m_data[n6] - dArray[(n3 + 1) % 3] / 4.0;
                int n7 = this.getIndex(n, n2);
                this.m_stiff[n].m_data[n7] = this.m_stiff[n].m_data[n7] - dArray[(n3 + 1) % 3] / 4.0;
            }
        }
        pdVectorArray = pgElementSet2.getVertices();
        for (n4 = 0; n4 < this.m_noe; ++n4) {
            nArray = piVectorArray[n4].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            if (!bl && pdVector.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + n4));
            }
            for (n3 = 0; n3 < 3; ++n3) {
                n2 = nArray[n3];
                n = nArray[(n3 + 2) % 3];
                int n8 = this.getIndex(n2, n2);
                this.m_stiff[n2].m_data[n8] = this.m_stiff[n2].m_data[n8] - (dArray[(n3 - 1 + 3) % 3] + dArray[(n3 + 1) % 3]) / 4.0;
                int n9 = this.getIndex(n2, n);
                this.m_stiff[n2].m_data[n9] = this.m_stiff[n2].m_data[n9] + dArray[(n3 + 1) % 3] / 4.0;
                int n10 = this.getIndex(n, n2);
                this.m_stiff[n].m_data[n10] = this.m_stiff[n].m_data[n10] + dArray[(n3 + 1) % 3] / 4.0;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

