/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;

public class PnBiconjugateGradient
extends PnConjugateGradientMatrix {
    private PdVector m_qq;
    private PdVector m_pp = new PdVector();
    private PdVector m_rr;
    private PdVector m_zz;
    private PdVector m_z;
    private boolean m_bUseStab = true;

    public PnBiconjugateGradient() {
        this.m_qq = new PdVector();
        this.m_rr = new PdVector();
        this.m_zz = new PdVector();
        this.m_z = new PdVector();
    }

    public void setUseStabilized(boolean bl) {
        this.m_bUseStab = bl;
    }

    public boolean getUseStabilized() {
        return this.m_bUseStab;
    }

    protected void setSize(int n) {
        super.setSize(n);
        this.m_pp.setSize(n * this.m_dim);
        this.m_qq.setSize(n * this.m_dim);
        this.m_rr.setSize(n * this.m_dim);
        this.m_zz.setSize(n * this.m_dim);
        this.m_z.setSize(n * this.m_dim);
    }

    public double solve(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        if (pnSparseMatrix == null || pdVector == null || pdVector2 == null) {
            PsDebug.warning((String)"One of the arguments is null.");
            return -1.0;
        }
        if (!pnSparseMatrix.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return -1.0;
        }
        if (pdVector.getSize() != this.m_dim * pnSparseMatrix.m_iSize) {
            pdVector.setSize(this.m_dim * pnSparseMatrix.m_iSize);
        }
        if (pdVector2.getSize() != this.m_dim * pnSparseMatrix.m_iSize) {
            PsDebug.warning((String)"Dimension of b and smat do not match.");
            return -1.0;
        }
        if (this.m_size != pnSparseMatrix.m_iSize) {
            this.setSize(pnSparseMatrix.m_iSize);
        }
        if (this.m_prec == null) {
            this.m_prec = new PnPreconditioner();
        }
        if (this.m_bUseStab) {
            return this.solveBCGStab(pnSparseMatrix, pdVector, pdVector2);
        }
        return this.solveBCG(pnSparseMatrix, pdVector, pdVector2);
    }

    private double solveBCGStab(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        int n = pnSparseMatrix.m_iSize * this.m_dim;
        pnSparseMatrix.rightMultVector(pdVector, this.m_r, this.m_dim);
        this.m_r.multScalar(-1.0);
        this.m_r.add(pdVector2);
        this.m_rr.set(this.m_r.m_data);
        this.m_iter = 0;
        while (true) {
            int n2;
            double d6;
            this.m_err = this.getResidualNorm();
            if (!(d6 > this.m_tol) || this.m_iter >= this.m_itmax) break;
            d = this.m_rr.dot(this.m_r);
            if (d == 0.0) {
                PsDebug.warning((String)("rho_1 == 0 in solveBCGStab at iteration " + this.m_iter));
                return -1.0;
            }
            if (d5 == 0.0) {
                PsDebug.warning((String)("omega == 0 in solveBCGStab at iteration " + this.m_iter));
                return -1.0;
            }
            if (this.m_iter == 0) {
                this.m_p.set(this.m_r.m_data);
            } else {
                d4 = d / d2 * (d3 / d5);
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_p.m_data[n2] = this.m_r.m_data[n2] + d4 * (this.m_p.m_data[n2] - this.m_z.m_data[n2] * d5);
                }
            }
            this.m_prec.apply(this.m_p, this.m_pp, this.m_dim);
            pnSparseMatrix.rightMultVector(this.m_pp, this.m_z, this.m_dim);
            d3 = d / this.m_rr.dot(this.m_z);
            for (n2 = 0; n2 < n; ++n2) {
                this.m_q.m_data[n2] = this.m_r.m_data[n2] - d3 * this.m_z.m_data[n2];
            }
            if (this.converged()) {
                for (n2 = 0; n2 < n; ++n2) {
                    int n3 = n2;
                    pdVector.m_data[n3] = pdVector.m_data[n3] + d3 * this.m_pp.m_data[n2];
                }
                return 0.0;
            }
            this.m_prec.apply(this.m_q, this.m_qq, this.m_dim);
            pnSparseMatrix.rightMultVector(this.m_qq, this.m_zz, this.m_dim);
            d5 = this.m_zz.dot(this.m_q) / this.m_zz.dot(this.m_zz);
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = n2;
                pdVector.m_data[n4] = pdVector.m_data[n4] + (d3 * this.m_pp.m_data[n2] + d5 * this.m_qq.m_data[n2]);
                this.m_r.m_data[n2] = this.m_q.m_data[n2] - d5 * this.m_zz.m_data[n2];
            }
            d2 = d;
            ++this.m_iter;
        }
        return this.getResidualNorm();
    }

    private double solveBCG(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = pnSparseMatrix.m_iSize * this.m_dim;
        pnSparseMatrix.rightMultVector(pdVector, this.m_r, this.m_dim);
        this.m_r.multScalar(-1.0);
        this.m_r.add(pdVector2);
        this.m_rr.copy(this.m_r);
        this.m_iter = 0;
        while (true) {
            int n2;
            double d5;
            this.m_err = this.getResidualNorm();
            if (!(d5 > this.m_tol) || this.m_iter >= this.m_itmax) break;
            this.m_prec.apply(this.m_r, this.m_z, this.m_dim);
            this.m_prec.applyTransposed(this.m_rr, this.m_zz, this.m_dim);
            d = this.m_z.dot(this.m_rr);
            if (d == 0.0) {
                PsDebug.warning((String)("rho_1 == 0 in solveBCG at iteration " + this.m_iter));
                return -1.0;
            }
            if (this.m_iter == 0) {
                this.m_p.copy(this.m_z);
                this.m_pp.copy(this.m_zz);
            } else {
                d4 = d / d2;
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_p.m_data[n2] = d4 * this.m_p.m_data[n2] + this.m_z.m_data[n2];
                    this.m_pp.m_data[n2] = d4 * this.m_pp.m_data[n2] + this.m_zz.m_data[n2];
                }
            }
            pnSparseMatrix.rightMultVector(this.m_p, this.m_q, this.m_dim);
            pnSparseMatrix.leftMultVector(this.m_pp, this.m_qq, this.m_dim);
            d3 = d / this.m_pp.dot(this.m_q);
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = n2;
                pdVector.m_data[n3] = pdVector.m_data[n3] + d3 * this.m_p.m_data[n2];
                int n4 = n2;
                this.m_r.m_data[n4] = this.m_r.m_data[n4] - d3 * this.m_q.m_data[n2];
                int n5 = n2;
                this.m_rr.m_data[n5] = this.m_rr.m_data[n5] - d3 * this.m_qq.m_data[n2];
            }
            d2 = d;
            ++this.m_iter;
        }
        return this.getResidualNorm();
    }

    public double linbcg(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        return this.solve(pnSparseMatrix, pdVector, pdVector2);
    }
}

