/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jv.viewer.PvViewer;
import jvx.numeric.PnBiconjugateGradient;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnPreconditionerJacobi;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffAniso;
import jvx.project.PjWorkshop;

public class PwSmooth
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geom;
    protected int m_method;
    public static int METHOD_ANISOTROPIC = 0;
    public static int METHOD_ANSIO_PRECRIBED = 1;
    protected PuDouble m_featureDetect = new PuDouble(PsConfig.getMessage((int)54354), (PsUpdateIf)this);
    protected double m_stepwidth;
    protected int m_numOfStepBetweenUpdates;
    protected int m_currLoop;
    protected int m_maxNumLoops;
    protected boolean m_bkeepSelected;
    protected boolean m_bkeepBoundary;
    protected boolean m_bshowVertCol;
    protected boolean m_bUseRedGreen;
    protected boolean m_bImplicit;
    protected boolean m_bStepFunc;
    protected int m_prescSteps;
    protected double m_prescStepWidth;
    protected int m_prescRecompute;
    protected boolean m_bprescRecompute;
    protected boolean m_bUpdateElementNormals;
    protected boolean m_bUpdateVertexNormals;
    protected boolean m_bShowGradient;
    protected int m_methodDetect;
    protected boolean m_bMarkFeatures;
    protected boolean m_bFlip;
    protected PdVector[] anisoAreaGrad;
    protected PdVector[] volGrad;
    PgVectorField m_vf;
    double m_fac = 0.8;
    double m_val = 1.0;
    boolean m_b = true;
    private boolean btest = false;
    protected PdVector m_mean;
    protected PdVector[] aVolGrad;
    protected boolean[] onEdge;
    protected boolean m_useScaleColor = false;
    protected double m_scaleColor = 0.004;
    protected double colVal = 0.0;
    protected PnBiconjugateGradient m_solver;
    protected PnPreconditionerJacobi m_preconditioner;
    protected PdVector m_Coord;
    protected PdVector m_newCoord;
    protected PnStiffAniso m_A;
    private PnMassMatrix m_massMatrix;
    protected boolean m_bUseMassMatrix;
    protected boolean m_bUseLumpedMass;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    private boolean createImages = false;
    private int imagenr = 1;
    private String imagename = "d:\\_tmp\\geom";
    private int width = 1280;
    private int height = 1024;
    private int type = 64;
    private String fileExt = ".ppm";
    public PvViewer viewer;
    private boolean createModels = false;
    private boolean createDispFile = true;
    private int modelType = 52;
    private int dispFileType = 59;
    private String modelFileExt = ".obj";
    protected long m_time = 0L;
    protected double m_solverErr = 0.0;
    protected int m_solverIter = 0;
    static /* synthetic */ Class class$jvx$geom$PwSmooth;

    public PwSmooth() {
        super(PsConfig.getMessage((int)48023));
        this.m_featureDetect.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_featureDetect.setDefValue(0.5);
        if (this.getClass() == (class$jvx$geom$PwSmooth == null ? (class$jvx$geom$PwSmooth = PwSmooth.class$("jvx.geom.PwSmooth")) : class$jvx$geom$PwSmooth)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_method = METHOD_ANISOTROPIC;
        this.m_stepwidth = 0.01;
        this.m_maxNumLoops = 100000;
        this.m_numOfStepBetweenUpdates = 10;
        this.m_currLoop = 1;
        this.m_bStepFunc = true;
        this.m_bImplicit = false;
        this.m_featureDetect.init();
        this.m_bkeepSelected = false;
        this.m_bkeepBoundary = true;
        this.m_bshowVertCol = false;
        this.m_bUseRedGreen = false;
        this.m_bUpdateElementNormals = true;
        this.m_bUpdateVertexNormals = true;
        this.m_bShowGradient = false;
        this.m_bUseMassMatrix = true;
        this.m_bUseLumpedMass = true;
        this.m_bFlip = false;
        this.m_prescSteps = 5;
        this.m_prescStepWidth = 0.4;
        this.m_prescRecompute = 1;
        this.m_bprescRecompute = true;
        this.m_methodDetect = 0;
    }

    public boolean update(Object object) {
        boolean bl = false;
        if (this.m_bShowGradient) {
            this.showGradient();
            bl = true;
        } else if (this.m_vf != null) {
            this.showNone();
            bl = true;
        }
        if (this.m_bshowVertCol) {
            this.updateColors();
            bl = true;
        }
        if (bl) {
            this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_featureDetect) {
            return true;
        }
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        if (!pgElementSet.checkNeighbour(true)) {
            PsDebug.warning((String)("Workshop surface smoothing cannot process geometry " + pgElementSet.getName() + ". " + "The neighbour infomation is incorrect." + " " + "Call makeNeighbour to creat new neighbour information."));
            return;
        }
        this.m_geom = pgElementSet;
        if (this.m_geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
        }
        this.m_geom.markBoundary();
        this.adjustSlider();
        this.m_massMatrix = null;
        this.m_stepwidth = 0.01;
    }

    public void cancel() {
        if (this.m_geomSave != null) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
            this.m_geom.showVertices(pgElementSet.isShowingVertices());
            this.m_geom.showVertexColors(pgElementSet.isShowingVectorColors());
            this.m_geom.showElementColors(pgElementSet.isShowingElementColors());
            this.m_geom.showElementFromVertexColors(pgElementSet.isShowingElementFromVertexColors());
            this.m_geom.showSmoothElementColors(pgElementSet.isShowingSmoothElementColors());
        }
        super.cancel();
    }

    protected void resetVertices() {
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < n; ++i) {
            System.arraycopy(pdVectorArray2[i].m_data, 0, pdVectorArray[i].m_data, 0, 3);
        }
        if (this.m_bUpdateElementNormals) {
            this.m_geom.makeElementNormals();
        }
        if (this.m_bUpdateVertexNormals) {
            this.m_geom.makeVertexNormals();
        }
    }

    protected void anisoAreaGrad() {
        int n;
        int n2 = this.m_geom.getNumVertices();
        if (this.anisoAreaGrad == null || this.anisoAreaGrad.length < n2) {
            this.anisoAreaGrad = PdVector.realloc(null, (int)n2, (int)3);
        } else {
            for (n = 0; n < n2; ++n) {
                this.anisoAreaGrad[n].setConstant(0.0);
            }
        }
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n4 = this.m_geom.getDimOfVertices();
        PdVector pdVector = new PdVector(n4);
        double[] dArray = new double[3];
        double d = this.m_featureDetect.getValue();
        double[] dArray2 = new double[3];
        for (n = 0; n < n3; ++n) {
            PiVector piVector = piVectorArray[n];
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
            for (int i = 0; i < 3; ++i) {
                double d2;
                if (piVectorArray2[n].m_data[i] < n) continue;
                PiVector piVector2 = piVectorArray[piVectorArray2[n].m_data[i]];
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                int n5 = this.m_geom.getOppVertexLocInd(n, i);
                int n6 = piVector.m_data[i];
                int n7 = piVector.m_data[(i + 1) % 3];
                int n8 = piVector.m_data[(i + 2) % 3];
                int n9 = piVector2.m_data[n5];
                int n10 = piVector2.m_data[(n5 + 1) % 3];
                int n11 = piVector2.m_data[(n5 + 2) % 3];
                for (int j = 0; j < n4; ++j) {
                    pdVector.m_data[j] = 0.5 * (dArray[(i + 1) % 3] * (pdVectorArray[n8].m_data[j] - pdVectorArray[n6].m_data[j]) + dArray[(i + 2) % 3] * (pdVectorArray[n7].m_data[j] - pdVectorArray[n6].m_data[j]) + dArray2[(n5 + 1) % 3] * (pdVectorArray[n11].m_data[j] - pdVectorArray[n9].m_data[j]) + dArray2[(n5 + 2) % 3] * (pdVectorArray[n10].m_data[j] - pdVectorArray[n9].m_data[j]));
                }
                double d3 = pdVector.length();
                if (this.btest) {
                    d2 = PdVector.area((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
                    d2 += PdVector.area((PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                    PsDebug.message((String)(n + "," + i + " , " + d3 + " : " + d3 / (d2 /= 2.0)));
                }
                if (this.m_methodDetect == 1 && (d2 = PdVector.subNew((PdVector)pdVectorArray[n7], (PdVector)pdVectorArray[n8]).length()) > 1.0E-10) {
                    d3 /= d2;
                }
                if (d3 > d) {
                    if (this.m_bStepFunc) continue;
                    pdVector.multScalar(d * d / (d * d + 10.0 * (d3 - d) * (d3 - d)));
                }
                this.anisoAreaGrad[n7].sub(pdVector);
                this.anisoAreaGrad[n8].sub(pdVector);
            }
        }
    }

    protected void volGradient() {
        int n;
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n2 = this.m_geom.getNumVertices();
        if (this.volGrad == null || this.volGrad.length < n2) {
            this.volGrad = PdVector.realloc(null, (int)n2, (int)3);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        PdVector pdVector = new PdVector(3);
        for (n = 0; n < n2; ++n) {
            this.volGrad[n].setConstant(0.0);
        }
        for (n = 0; n < n3; ++n) {
            double d = PdVector.area((PdVector)pdVectorArray[piVectorArray[n].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n].m_data[2]]);
            pdVector.copyArray(pdVectorArray2[n]);
            pdVector.multScalar(d);
            for (int i = 0; i < 3; ++i) {
                this.volGrad[piVectorArray[n].m_data[i]].add(pdVector);
            }
        }
    }

    private void moveVertices(PdVector[] pdVectorArray) {
        double d = this.m_stepwidth;
        if (this.m_bUseMassMatrix) {
            d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        int n = this.m_geom.getNumVertices();
        if (!this.m_bkeepSelected) {
            if (!this.m_bkeepBoundary) {
                for (int i = 0; i < n; ++i) {
                    pdVectorArray2[i].blendBase(pdVectorArray2[i], d, pdVectorArray[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (pdVectorArray2[i].hasTag(14)) continue;
                    pdVectorArray2[i].blendBase(pdVectorArray2[i], d, pdVectorArray[i]);
                }
            }
        } else if (!this.m_bkeepBoundary) {
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray2[i].hasTag(1)) continue;
                pdVectorArray2[i].blendBase(pdVectorArray2[i], d, pdVectorArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray2[i].hasTag(1) || pdVectorArray2[i].hasTag(14)) continue;
                pdVectorArray2[i].blendBase(pdVectorArray2[i], d, pdVectorArray[i]);
            }
        }
    }

    public void setMethod(int n) {
        if (n < 0 || n > 1) {
            PsDebug.warning((String)("Cannot set Method. Method " + n + " is unknown."));
        }
        this.m_method = n;
    }

    public int getMethod() {
        return this.m_method;
    }

    public void setFeatureDetect(double d) {
        this.m_featureDetect.setValue(d);
    }

    public double getFeatureDetect() {
        return this.m_featureDetect.getValue();
    }

    public void useImplicit(boolean bl) {
    }

    public boolean isUsingImplicit() {
        return this.m_bImplicit;
    }

    public void setStepWidth(double d) {
        this.m_stepwidth = d;
    }

    public double getStepWidth() {
        return this.m_stepwidth;
    }

    public void setMaxNumLoops(int n) {
        this.m_maxNumLoops = n;
    }

    public int getMaxNumLoops() {
        return this.m_maxNumLoops;
    }

    public void setKeepBoundary(boolean bl) {
        this.m_bkeepBoundary = bl;
    }

    public boolean getKeepBoundary() {
        return this.m_bkeepBoundary;
    }

    public void setKeepSelected(boolean bl) {
        this.m_bkeepSelected = bl;
    }

    public boolean getKeepSelected() {
        return this.m_bkeepSelected;
    }

    protected void showGradient() {
        if (this.m_vf != null) {
            this.m_vf = this.m_geom.getVectorField(PsConfig.getMessage((int)45069));
        }
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(3);
            this.m_vf.setName(PsConfig.getMessage((int)45069));
            this.m_geom.addVectorField(this.m_vf);
        }
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        boolean bl = this.m_bprescRecompute;
        this.m_bprescRecompute = true;
        this.computeGradient();
        this.m_bprescRecompute = bl;
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        double d = 1.0;
        if (this.m_bUseMassMatrix) {
            d = 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_bkeepSelected && pdVectorArray2[i].hasTag(1) || this.m_bkeepBoundary && pdVectorArray2[i].hasTag(14)) {
                pdVectorArray[i].setConstant(0.0);
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                pdVectorArray[i].m_data[j] = -d * this.anisoAreaGrad[i].m_data[j];
            }
        }
    }

    protected void showNone() {
        this.m_geom.removeVectorField((PgGeometryIf)this.m_vf);
        this.m_vf = null;
    }

    private PdVector[] computeGradient() {
        int n;
        int n2;
        if (this.m_method == METHOD_ANISOTROPIC) {
            this.anisoAreaGrad();
        } else {
            if (this.m_bprescRecompute || this.aVolGrad == null) {
                this.aVolGrad();
                this.computeHE();
                this.smoothHE();
            } else {
                this.anisoAreaGrad();
            }
            n2 = this.m_geom.getNumVertices();
            n = this.m_geom.getDimOfVertices();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n3 = j;
                    this.anisoAreaGrad[i].m_data[n3] = this.anisoAreaGrad[i].m_data[n3] + this.m_mean.m_data[i] * this.aVolGrad[i].m_data[j];
                }
            }
        }
        if (this.btest) {
            this.volGradient();
            n2 = this.m_geom.getNumVertices();
            for (n = 0; n < n2; ++n) {
                PsDebug.message((String)(n + " volgrad: " + 3.0 * this.anisoAreaGrad[n].length() / this.volGrad[n].length()));
            }
        }
        if (this.m_bUseMassMatrix) {
            if (this.m_massMatrix == null) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom, this.m_bUseLumpedMass);
            } else {
                this.m_massMatrix.useLumpedMass(this.m_bUseLumpedMass);
                this.m_massMatrix.init();
            }
            this.m_massMatrix.multInvMassMatrix(this.anisoAreaGrad);
        }
        if (this.btest) {
            n2 = this.m_geom.getNumVertices();
            for (n = 0; n < n2; ++n) {
                PsDebug.message((String)(n + " : " + this.anisoAreaGrad[n].length()));
            }
        }
        return this.anisoAreaGrad;
    }

    public void smoothingStep() {
        if (this.m_bImplicit) {
            this.smoothImplicit();
        } else {
            this.moveVertices(this.computeGradient());
        }
        if (this.m_bUpdateElementNormals) {
            this.m_geom.makeElementNormals();
        }
        if (this.m_bUpdateVertexNormals) {
            this.m_geom.makeVertexNormals();
        }
    }

    private void aVolGrad() {
        int n;
        int n2;
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n3 = this.m_geom.getNumVertices();
        if (this.aVolGrad == null || this.aVolGrad.length < n3) {
            this.aVolGrad = PdVector.realloc(null, (int)n3, (int)3);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n4 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector pdVector = new PdVector(3);
        this.anisoAreaGrad();
        this.volGradient();
        this.detectEdges();
        for (n2 = 0; n2 < n3; ++n2) {
            this.aVolGrad[n2].setConstant(0.0);
        }
        double[] dArray = new double[3];
        for (n2 = 0; n2 < n4; ++n2) {
            PdVector.angle((double[])dArray, (PdVector)pdVectorArray[piVectorArray[n2].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n2].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n2].m_data[2]]);
            for (n = 0; n < 3; ++n) {
                if (!this.onEdge[piVectorArray[n2].m_data[n]]) continue;
                pdVector.copyArray(this.anisoAreaGrad[piVectorArray[n2].m_data[(n + 1) % 3]]);
                pdVector.multScalar(dArray[n]);
                this.aVolGrad[piVectorArray[n2].m_data[n]].add(pdVector);
                pdVector.copyArray(this.anisoAreaGrad[piVectorArray[n2].m_data[(n + 2) % 3]]);
                pdVector.multScalar(dArray[n]);
                this.aVolGrad[piVectorArray[n2].m_data[n]].add(pdVector);
            }
        }
        double d = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.onEdge[n2]) {
                this.aVolGrad[n2].normalize();
                pdVector.copyArray(this.anisoAreaGrad[n2]);
                pdVector.setLength(d);
                this.aVolGrad[n2].add(pdVector);
                this.aVolGrad[n2].normalize();
                if (!(PdVector.dot((PdVector)this.volGrad[n2], (PdVector)this.aVolGrad[n2]) < 0.0)) continue;
                this.aVolGrad[n2].multScalar(-1.0);
                continue;
            }
            this.aVolGrad[n2].copyArray(this.volGrad[n2]);
        }
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            double d2 = PdVector.area((PdVector)pdVectorArray[piVectorArray[n2].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n2].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n2].m_data[2]]);
            pdVector.copyArray(pdVectorArray2[n2]);
            pdVector.multScalar(d2);
            for (n = 0; n < 3; ++n) {
                if (!this.onEdge[piVectorArray[n2].m_data[n]]) continue;
                int n5 = piVectorArray[n2].m_data[n];
                dArray2[n5] = dArray2[n5] + d2 * Math.abs(PdVector.dot((PdVector)this.aVolGrad[piVectorArray[n2].m_data[n]], (PdVector)pdVectorArray2[n2]));
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.onEdge[n2]) continue;
            this.aVolGrad[n2].multScalar(dArray2[n2]);
        }
    }

    private void computeHE() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n = this.m_geom.getNumVertices();
        if (this.m_mean == null || this.m_mean.getSize() < n) {
            this.m_mean = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            double d;
            this.m_mean.m_data[i] = PdVector.dot((PdVector)this.volGrad[i], (PdVector)this.anisoAreaGrad[i]) < 0.0 ? this.anisoAreaGrad[i].length() : -this.anisoAreaGrad[i].length();
            double d2 = this.aVolGrad[i].length();
            if (!(d > 1.0E-10)) continue;
            int n2 = i;
            this.m_mean.m_data[n2] = this.m_mean.m_data[n2] / d2;
        }
    }

    protected void detectEdges() {
        int n;
        int n2 = this.m_geom.getNumVertices();
        if (this.onEdge == null || this.onEdge.length < n2) {
            this.onEdge = new boolean[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.onEdge[n] = false;
        }
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double d = this.m_featureDetect.getValue();
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < 3; ++i) {
                if (piVectorArray2[n].m_data[i] < n) continue;
                pdVector3.sub(pdVectorArray[piVectorArray[n].m_data[(i + 2) % 3]], pdVectorArray[piVectorArray[n].m_data[(i + 1) % 3]]);
                pdVector.cross(pdVectorArray2[n], pdVector3);
                pdVector3.multScalar(-1.0);
                pdVector2.cross(pdVectorArray2[piVectorArray2[n].m_data[i]], pdVector3);
                pdVector4.add(pdVector, pdVector2);
                double d2 = pdVector4.length();
                if (!(d2 > d)) continue;
                this.onEdge[piVectorArray[n].m_data[(i + 1) % 3]] = true;
                this.onEdge[piVectorArray[n].m_data[(i + 2) % 3]] = true;
            }
        }
    }

    protected void updateColors() {
        int n;
        int n2 = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        int n4 = this.m_geom.getDimOfVertices();
        PdVector pdVector = new PdVector(n4);
        double[] dArray = new double[3];
        double d = this.m_useScaleColor ? this.m_scaleColor : this.m_featureDetect.getValue();
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[n2];
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        for (n = 0; n < n3; ++n) {
            PiVector piVector = piVectorArray[n];
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
            for (int i = 0; i < 3; ++i) {
                double d4;
                if (piVectorArray2[n].m_data[i] < n) continue;
                PiVector piVector2 = piVectorArray[piVectorArray2[n].m_data[i]];
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                int n5 = this.m_geom.getOppVertexLocInd(n, i);
                int n6 = piVector.m_data[i];
                int n7 = piVector.m_data[(i + 1) % 3];
                int n8 = piVector.m_data[(i + 2) % 3];
                int n9 = piVector2.m_data[n5];
                int n10 = piVector2.m_data[(n5 + 1) % 3];
                int n11 = piVector2.m_data[(n5 + 2) % 3];
                for (int j = 0; j < n4; ++j) {
                    pdVector.m_data[j] = 0.5 * (dArray[(i + 1) % 3] * (pdVectorArray[n8].m_data[j] - pdVectorArray[n6].m_data[j]) + dArray[(i + 2) % 3] * (pdVectorArray[n7].m_data[j] - pdVectorArray[n6].m_data[j]) + dArray2[(n5 + 1) % 3] * (pdVectorArray[n11].m_data[j] - pdVectorArray[n9].m_data[j]) + dArray2[(n5 + 2) % 3] * (pdVectorArray[n10].m_data[j] - pdVectorArray[n9].m_data[j]));
                }
                double d5 = pdVector.length();
                if (this.m_methodDetect == 1 && (d4 = PdVector.subNew((PdVector)pdVectorArray[n7], (PdVector)pdVectorArray[n8]).length()) > 1.0E-10) {
                    d5 /= d4;
                }
                if (d5 > d && !this.m_bStepFunc) {
                    pdVector.multScalar(d * d / (d * d + 10.0 * (d5 - d) * (d5 - d)));
                }
                if (dArray3[n7] < d5) {
                    dArray3[n7] = d5;
                }
                if (dArray3[n8] < d5) {
                    dArray3[n8] = d5;
                }
                if (d2 < d5) {
                    d2 = d5;
                }
                if (!(d3 > d5)) continue;
                d3 = d5;
            }
        }
        if (this.m_bUseRedGreen) {
            for (n = 0; n < n2; ++n) {
                if (dArray3[n] > d) {
                    this.m_geom.setVertexColor(n, Color.red);
                    continue;
                }
                this.m_geom.setVertexColor(n, Color.green);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.m_geom.setVertexColor(n, PwSmooth.colorMap(dArray3[n] / d));
            }
        }
        if (this.m_bMarkFeatures) {
            for (n = 0; n < n2; ++n) {
                if (dArray3[n] > d) {
                    pdVectorArray[n].setTag(1);
                    continue;
                }
                pdVectorArray[n].clearTag(1);
            }
        }
        if (this.m_bkeepBoundary) {
            for (n = 0; n < n2; ++n) {
                if (!pdVectorArray[n].hasTag(14)) continue;
                this.m_geom.setVertexColor(n, Color.red);
            }
        }
    }

    protected void smoothHE() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.m_geom.getNumVertices();
        int n7 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        if (this.m_mean == null || this.m_mean.getSize() < n6) {
            this.computeHE();
        }
        PdVector pdVector = new PdVector(n6);
        double d = this.m_prescStepWidth;
        int n8 = this.m_prescSteps;
        int[][] nArrayArray = new int[n6][];
        int n9 = 0;
        int n10 = 0;
        int[] nArray = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < 3; ++n4) {
                if (piVectorArray2[n5].m_data[n4] < n5) continue;
                n3 = piVectorArray[n5].m_data[(n4 + 1) % 3];
                n2 = piVectorArray[n5].m_data[(n4 + 2) % 3];
                if (pdVectorArray[n3].hasTag(14)) continue;
                if (this.onEdge[n3]) {
                    if (pdVectorArray[n2].hasTag(14) || !this.onEdge[n2]) continue;
                    int n11 = n3;
                    nArray[n11] = nArray[n11] + 1;
                    int n12 = n2;
                    nArray[n12] = nArray[n12] + 1;
                    continue;
                }
                if (pdVectorArray[n2].hasTag(14) || this.onEdge[n2]) continue;
                int n13 = n3;
                nArray[n13] = nArray[n13] + 1;
                int n14 = n2;
                nArray[n14] = nArray[n14] + 1;
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            if (pdVectorArray[n5].hasTag(14)) continue;
            if (this.onEdge[n5]) {
                ++n9;
                continue;
            }
            ++n10;
        }
        int[] nArray2 = new int[n9];
        int[] nArray3 = new int[n10];
        n9 = 0;
        n10 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            if (pdVectorArray[n5].hasTag(14)) continue;
            if (this.onEdge[n5]) {
                nArray2[n9] = n5;
                ++n9;
                continue;
            }
            nArray3[n10] = n5;
            ++n10;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            nArrayArray[n5] = new int[nArray[n5]];
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < 3; ++n4) {
                if (piVectorArray2[n5].m_data[n4] < n5) continue;
                n3 = piVectorArray[n5].m_data[(n4 + 1) % 3];
                n2 = piVectorArray[n5].m_data[(n4 + 2) % 3];
                if (pdVectorArray[n3].hasTag(14)) continue;
                if (this.onEdge[n3]) {
                    if (pdVectorArray[n2].hasTag(14) || !this.onEdge[n2]) continue;
                    nArrayArray[n3][nArray[n3]] = n2;
                    int n15 = n3;
                    nArray[n15] = nArray[n15] + 1;
                    nArrayArray[n2][nArray[n2]] = n3;
                    int n16 = n2;
                    nArray[n16] = nArray[n16] + 1;
                    continue;
                }
                if (pdVectorArray[n2].hasTag(14) || this.onEdge[n2]) continue;
                nArrayArray[n3][nArray[n3]] = n2;
                int n17 = n3;
                nArray[n17] = nArray[n17] + 1;
                nArrayArray[n2][nArray[n2]] = n3;
                int n18 = n2;
                nArray[n18] = nArray[n18] + 1;
            }
        }
        for (n = 0; n < n8; ++n) {
            pdVector.setConstant(0.0);
            for (n5 = 0; n5 < n10; ++n5) {
                n3 = nArray3[n5];
                for (n4 = 0; n4 < nArray[n3]; ++n4) {
                    int n19 = n3;
                    pdVector.m_data[n19] = pdVector.m_data[n19] + this.m_mean.m_data[nArrayArray[n3][n4]];
                }
                if (nArray[n3] > 1) {
                    int n20 = n3;
                    pdVector.m_data[n20] = pdVector.m_data[n20] / (double)nArray[n3];
                } else if (nArray[n3] < 1) continue;
                int n21 = n3;
                pdVector.m_data[n21] = pdVector.m_data[n21] - this.m_mean.m_data[n3];
            }
            for (n5 = 0; n5 < n10; ++n5) {
                int n22 = nArray3[n5];
                this.m_mean.m_data[n22] = this.m_mean.m_data[n22] + d * pdVector.m_data[nArray3[n5]];
            }
        }
        for (n = 0; n < n8; ++n) {
            pdVector.setConstant(0.0);
            for (n5 = 0; n5 < n9; ++n5) {
                n3 = nArray2[n5];
                for (n4 = 0; n4 < nArray[n3]; ++n4) {
                    int n23 = n3;
                    pdVector.m_data[n23] = pdVector.m_data[n23] + this.m_mean.m_data[nArrayArray[n3][n4]];
                }
                if (nArray[n3] > 1) {
                    int n24 = n3;
                    pdVector.m_data[n24] = pdVector.m_data[n24] / (double)nArray[n3];
                } else if (nArray[n3] < 1) continue;
                int n25 = n3;
                pdVector.m_data[n25] = pdVector.m_data[n25] - this.m_mean.m_data[n3];
            }
            for (n5 = 0; n5 < n9; ++n5) {
                int n26 = nArray2[n5];
                this.m_mean.m_data[n26] = this.m_mean.m_data[n26] + d * pdVector.m_data[nArray2[n5]];
            }
        }
    }

    public static Color colorMapGray(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        float f = (float)d;
        return new Color(f, f, f);
    }

    public static Color colorMap(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    protected void adjustSlider() {
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double d = 0.0;
        int n2 = 0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (piVectorArray2[i].m_data[j] < i) continue;
                pdVector3.sub(pdVectorArray[piVectorArray[i].m_data[(j + 2) % 3]], pdVectorArray[piVectorArray[i].m_data[(j + 1) % 3]]);
                d += pdVector3.length();
                ++n2;
                pdVector.cross(pdVectorArray2[i], pdVector3);
                pdVector3.multScalar(-1.0);
                pdVector2.cross(pdVectorArray2[piVectorArray2[i].m_data[j]], pdVector3);
                pdVector4.add(pdVector, pdVector2);
                double d4 = pdVector4.length() / 2.0;
                if (d2 > d4) {
                    d2 = d4;
                }
                if (!(d3 < d4)) continue;
                d3 = d4;
            }
        }
        this.m_featureDetect.setBounds(d2 /= 2.0, d3 *= 2.0, (d3 - d2) / 100.0, (d3 - d2) / 10.0);
        this.m_featureDetect.setValue((d /= (double)n2) * 0.5);
        this.m_featureDetect.update((Object)this.m_featureDetect);
    }

    public static boolean scaleGeomByVolume(PgElementSet pgElementSet, double d, double d2, int n) {
        PdVector pdVector = pgElementSet.getCenterOfGravity();
        double d3 = pgElementSet.getVolume();
        int n2 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector pdVector2 = new PdVector(3);
        double d4 = 0.01;
        int n3 = 0;
        while (Math.abs(d3 - d) > d2 && n3 < n) {
            for (int i = 0; i < n2; ++i) {
                pdVector2.sub(pdVectorArray[i], pdVector);
                pdVector2.multScalar(d4);
                pdVectorArray[i].add(pdVector2);
            }
            d3 = pgElementSet.getVolume();
        }
        return n3 != n;
    }

    private void initImplicit() {
        int n = this.m_geom.getNumVertices();
        if (this.m_Coord == null) {
            this.m_Coord = new PdVector(3 * n);
        } else if (this.m_Coord.getSize() != 3 * n) {
            this.m_Coord.setSize(3 * n);
        }
        if (this.m_newCoord == null) {
            this.m_newCoord = new PdVector(3 * n);
        } else if (this.m_newCoord.getSize() != 3 * n) {
            this.m_newCoord.setSize(3 * n);
        }
        if (this.m_A == null) {
            this.m_A = new PnStiffAniso(this.m_geom);
        } else if (this.m_A.getNumRows() != n) {
            this.m_A = new PnStiffAniso(this.m_geom);
        }
        if (this.m_preconditioner == null) {
            this.m_preconditioner = new PnPreconditionerJacobi(this.m_A);
        }
        if (this.m_solver == null) {
            this.m_solver = new PnBiconjugateGradient();
            this.m_solver.setDimension(3);
            this.m_solver.setPreconditioner(this.m_preconditioner);
        }
        if (this.m_bUseMassMatrix) {
            if (this.m_massMatrix == null) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom, this.m_bUseLumpedMass);
            } else if (this.m_massMatrix.getNumRows() != n) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom, this.m_bUseLumpedMass);
            }
        }
    }

    protected void smoothImplicit() {
        int n;
        int n2;
        this.initImplicit();
        int n3 = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_bUseMassMatrix) {
            if (this.m_bUseLumpedMass == this.m_massMatrix.isUsingLumpedMass()) {
                this.m_massMatrix.init();
            } else {
                this.m_massMatrix.useLumpedMass(this.m_bUseLumpedMass);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    this.m_newCoord.m_data[3 * n + n2] = pdVectorArray[n].m_data[n2];
                }
            }
            this.m_Coord = PnSparseMatrix.rightMultVector(this.m_massMatrix, this.m_newCoord, this.m_Coord, 3);
        } else {
            for (n = 0; n < n3; ++n) {
                for (n2 = 0; n2 < 3; ++n2) {
                    this.m_Coord.m_data[3 * n + n2] = pdVectorArray[n].m_data[n2];
                }
            }
        }
        this.m_A.setFeatureDetect(this.m_featureDetect.getValue());
        this.m_A.useStepFunction(this.m_bStepFunc);
        this.initImplicitEuler();
        double d = this.m_stepwidth;
        if (this.m_method == METHOD_ANSIO_PRECRIBED) {
            this.aVolGrad();
            this.computeHE();
            this.smoothHE();
            if (this.m_bUseMassMatrix) {
                d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
            }
        }
        this.m_newCoord.copyArray(this.m_Coord);
        this.m_preconditioner.setSparseMatrix(this.m_A);
        this.m_solver.solve(this.m_A, this.m_newCoord, this.m_Coord);
        this.m_solverErr = this.m_solver.getActualEstimatedError();
        this.m_solverIter = this.m_solver.getActualNumOfTakenIterations();
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (this.m_bkeepBoundary && pdVectorArray[n].hasTag(14) || this.m_bkeepSelected && pdVectorArray[n].hasTag(1)) continue;
                pdVectorArray[n].m_data[n2] = this.m_newCoord.m_data[3 * n + n2];
            }
        }
        if (this.m_method == METHOD_ANSIO_PRECRIBED) {
            for (n = 0; n < n3; ++n) {
                this.aVolGrad[n].multScalar(this.m_mean.m_data[n]);
            }
            if (this.m_bUseMassMatrix) {
                this.m_massMatrix.multInvMassMatrix(this.aVolGrad);
            }
            for (n = 0; n < n3; ++n) {
                for (n2 = 0; n2 < 3; ++n2) {
                    if (this.m_bkeepBoundary && pdVectorArray[n].hasTag(14) || this.m_bkeepSelected && pdVectorArray[n].hasTag(1)) continue;
                    int n4 = n2;
                    pdVectorArray[n].m_data[n4] = pdVectorArray[n].m_data[n4] + d * this.aVolGrad[n].m_data[n2];
                }
            }
        }
    }

    protected void initImplicitEuler() {
        int n;
        int n2;
        this.m_A.init(this.m_geom);
        double d = this.m_stepwidth;
        if (this.m_bUseMassMatrix) {
            d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        int n3 = this.m_A.getNumRows();
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            while (n < this.m_A.getNumEntries(n2)) {
                int n4 = n++;
                this.m_A.getEntries((int)n2).m_data[n4] = this.m_A.getEntries((int)n2).m_data[n4] * d;
            }
        }
        if (!this.m_bUseMassMatrix) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.m_A.getNumEntries(n2) <= 0) continue;
                int n5 = this.m_A.getIndex(n2, n2);
                this.m_A.getEntries((int)n2).m_data[n5] = this.m_A.getEntries((int)n2).m_data[n5] + 1.0;
            }
        } else {
            n3 = this.m_massMatrix.getNumRows();
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < this.m_massMatrix.getNumEntries(n2); ++n) {
                    if (this.m_massMatrix.getColIndex(n2, n) < 0) continue;
                    int n6 = this.m_A.getIndex(n2, this.m_massMatrix.getColIndex(n2, n));
                    this.m_A.getEntries((int)n2).m_data[n6] = this.m_A.getEntries((int)n2).m_data[n6] + this.m_massMatrix.getEntries((int)n2).m_data[n];
                }
            }
        }
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 0;
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
        }
    }

    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            this.m_bprescRecompute = this.m_currLoop % this.m_prescRecompute == 0;
            this.m_time = -System.currentTimeMillis();
            this.smoothingStep();
            this.m_time += System.currentTimeMillis();
            ++this.m_currLoop;
            if ((this.m_maxNumLoops - this.m_currLoop) % this.m_numOfStepBetweenUpdates == 0) {
                this.update(this);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.viewer != null && (this.createImages || this.createModels)) {
                    if (this.imagenr < 10) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".000" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".000" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".000" + this.imagenr + ".jvd");
                            }
                        }
                    } else if (this.imagenr < 100) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".00" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".00" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".00" + this.imagenr + ".jvd");
                            }
                        }
                    } else if (this.imagenr < 1000) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".0" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".0" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".0" + this.imagenr + ".jvd");
                            }
                        }
                    } else {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + "." + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + "." + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + "." + this.imagenr + ".jvd");
                            }
                        }
                    }
                    ++this.imagenr;
                }
            }
            if (this.m_currLoop < this.m_maxNumLoops) continue;
            this.stop();
        }
        this.m_bStopped = true;
        this.update(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

