/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwRefinePolygon
extends PjWorkshop {
    protected boolean m_bSinglePolygon;
    protected PgPolygon m_controlPolygon;
    protected PgPolygonSet m_controlPolygonSet;
    protected PiVector m_refinementSequence = new PiVector();
    protected boolean m_bShowControl = false;
    public static final int REFINE_DLG = 0;
    public static final int COARSEN_DLG = 1;
    public static final int REFINE_CHAIKIN = 2;
    public static final int COARSEN_CHAIKIN = 3;
    public static final int REFINE_LINEAR = 4;
    public static final int COARSEN_LINEAR = 5;
    public static final int REFINE_DFH = 6;
    public static final int COARSEN_DFH = 7;
    static /* synthetic */ Class class$jvx$geom$PwRefinePolygon;

    public PwRefinePolygon() {
        super(PsConfig.getMessage((int)48012));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwRefinePolygon == null ? (class$jvx$geom$PwRefinePolygon = PwRefinePolygon.class$("jvx.geom.PwRefinePolygon")) : class$jvx$geom$PwRefinePolygon)) {
            this.init();
        }
    }

    public void setGeometry(PgPolygon pgPolygon) {
        super.setGeometry((PgGeometry)pgPolygon);
        this.m_bSinglePolygon = true;
        this.m_controlPolygon = (PgPolygon)pgPolygon.clone();
        this.m_controlPolygon.setName(PsConfig.getMessage((int)45043) + " " + pgPolygon.getName());
        this.m_controlPolygon.setGlobalEdgeColor(Color.blue);
        this.m_refinementSequence = new PiVector();
    }

    public void setGeometry(PgPolygonSet pgPolygonSet) {
        super.setGeometry((PgGeometry)pgPolygonSet);
        this.m_bSinglePolygon = false;
        this.m_controlPolygonSet = (PgPolygonSet)pgPolygonSet.clone();
        this.m_controlPolygonSet.setName(PsConfig.getMessage((int)45044) + " " + pgPolygonSet.getName());
        this.m_controlPolygonSet.setGlobalPolygonColor(Color.red);
        this.m_refinementSequence = new PiVector();
    }

    public boolean update(Object object) {
        if (object == this.m_controlPolygon || object == this.m_controlPolygonSet) {
            if (this.m_bSinglePolygon) {
                this.m_geom.copy((PsObject)this.m_controlPolygon);
                this.sequenceRefine();
            } else {
                this.m_geom.copy((PsObject)this.m_controlPolygonSet);
                this.sequenceRefine();
            }
            return super.update((Object)this);
        }
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void reset() {
        super.reset();
        if (this.m_bSinglePolygon) {
            this.m_controlPolygon.copy((PsObject)this.m_geomSave);
            this.m_controlPolygon.setName(PsConfig.getMessage((int)45043) + " " + this.m_geomSave.getName());
            this.m_controlPolygon.update((Object)this.m_controlPolygon);
        } else {
            this.m_controlPolygonSet.copy((PsObject)this.m_geomSave);
            this.m_controlPolygonSet.setName(PsConfig.getMessage((int)45044) + " " + this.m_geomSave.getName());
            this.m_controlPolygonSet.update((Object)this.m_controlPolygonSet);
        }
        this.m_refinementSequence = new PiVector();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.update((Object)this);
    }

    public boolean isShowingControlGrid() {
        return this.m_bShowControl;
    }

    public void showControlGrid(boolean bl) {
        this.m_bShowControl = bl;
        if (bl) {
            if (this.m_bSinglePolygon) {
                this.m_display.addGeometry((PgGeometryIf)this.m_controlPolygon);
                this.m_display.selectGeometry((PgGeometryIf)this.m_controlPolygon);
                this.m_controlPolygon.addUpdateListener((PsUpdateIf)this);
            } else {
                this.m_display.addGeometry((PgGeometryIf)this.m_controlPolygonSet);
                this.m_display.selectGeometry((PgGeometryIf)this.m_controlPolygonSet);
                this.m_controlPolygonSet.addUpdateListener((PsUpdateIf)this);
            }
        } else if (this.m_bSinglePolygon) {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_controlPolygon)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_controlPolygon);
                this.m_display.selectGeometry((PgGeometryIf)this.m_geom);
            }
            if (this.m_controlPolygon.hasUpdateListener((PsUpdateIf)this)) {
                this.m_controlPolygon.removeUpdateListener((PsUpdateIf)this);
            }
        } else {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_controlPolygonSet)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_controlPolygonSet);
                this.m_display.selectGeometry((PgGeometryIf)this.m_geom);
            }
            if (this.m_controlPolygonSet.hasUpdateListener((PsUpdateIf)this)) {
                this.m_controlPolygonSet.removeUpdateListener((PsUpdateIf)this);
            }
        }
    }

    public void close() {
        this.showControlGrid(false);
        super.close();
    }

    public void addSequenceEntry(int n) {
        int n2 = this.m_refinementSequence.getSize();
        if (n2 > 0) {
            int n3 = this.m_refinementSequence.m_data[n2 - 1];
            if (n == 2 && n3 == 3 || n == 3 && n3 == 2 || n == 0 && n3 == 1 || n == 1 && n3 == 0 || n == 6 && n3 == 7 || n == 7 && n3 == 6 || n == 1 && n3 == 4 || n == 5 && n3 == 0 || n == 4 && n3 == 5 || n == 5 && n3 == 4) {
                this.m_refinementSequence.setSize(n2 - 1);
                return;
            }
        }
        this.m_refinementSequence.setSize(n2 + 1);
        this.m_refinementSequence.m_data[n2] = n;
    }

    public void sequenceRefine() {
        int n = this.m_refinementSequence.getSize();
        if (this.m_bSinglePolygon) {
            for (int i = 0; i < n; ++i) {
                if (this.m_refinementSequence.m_data[i] == 2) {
                    PwRefinePolygon.refineChaikin((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 3) {
                    PwRefinePolygon.coarsenChaikin((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 0) {
                    PwRefinePolygon.refineDLG((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 1) {
                    PwRefinePolygon.coarsenDLG((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 4) {
                    PwRefinePolygon.refineLinear((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 5) {
                    PwRefinePolygon.coarsenLinear((PgPolygon)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 6) {
                    PwRefinePolygon.refineDFH((PgPolygon)this.m_geom, PwRefinePolygon.getFourPointMask());
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] != 7) continue;
                PwRefinePolygon.coarsenDFH((PgPolygon)this.m_geom);
            }
            this.m_geom.update((Object)this.m_geom);
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.m_refinementSequence.m_data[i] == 2) {
                    PwRefinePolygon.refineChaikin((PgPolygonSet)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 3) {
                    PwRefinePolygon.coarsenChaikin((PgPolygonSet)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 0) {
                    PwRefinePolygon.refineDLG((PgPolygonSet)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 1) {
                    PwRefinePolygon.coarsenDLG((PgPolygonSet)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] == 4) {
                    PwRefinePolygon.refineLinear((PgPolygonSet)this.m_geom);
                    continue;
                }
                if (this.m_refinementSequence.m_data[i] != 5) continue;
                PwRefinePolygon.coarsenLinear((PgPolygonSet)this.m_geom);
            }
            this.m_geom.update((Object)this.m_geom);
        }
    }

    public static PdVector getFourPointMask() {
        return PwRefinePolygon.getFourPointMask(1.0);
    }

    public static PdVector getFourPointMask(double d) {
        return new PdVector(-7.0 * d / 128.0, 0.75 + 9.0 * d / 128.0, 0.25 + 3.0 * d / 128.0, -5.0 * d / 128.0);
    }

    public static void refineLinear(PgPolygon pgPolygon) {
        int n;
        Color[] colorArray;
        int n2;
        Color[] colorArray2;
        boolean bl;
        int n3 = pgPolygon.getNumVertices();
        if (n3 < 2) {
            return;
        }
        boolean bl2 = pgPolygon.isClosed();
        PdVector[] pdVectorArray = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 1];
        boolean bl3 = pgPolygon.hasVertexNormals();
        PdVector[] pdVectorArray2 = new PdVector[]{};
        if (bl3) {
            pdVectorArray2 = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 1];
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            colorArray2 = pgPolygon.getEdgeColors();
            n2 = 2 * n3 - 2;
            if (bl2) {
                n2 = 2 * n3;
            }
            colorArray = new Color[n2];
            for (n = 0; n < n2; ++n) {
                colorArray[n] = colorArray2[n / 2];
            }
        } else {
            colorArray = new Color[]{};
        }
        colorArray2 = pgPolygon.getVertices();
        for (n2 = 0; n2 < n3; ++n2) {
            pdVectorArray[2 * n2] = PdVector.copyNew((PdVector)colorArray2[n2]);
        }
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                pdVectorArray2[2 * n2] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(n2));
            }
        }
        if (bl2) {
            if (n3 == 2) {
                pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
                pdVectorArray[3] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
            } else {
                pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
                pdVectorArray[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[n3 - 2], (double)0.5, (PdVector)colorArray2[n3 - 1]);
                pdVectorArray[2 * n3 - 1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[n3 - 1], (double)0.5, (PdVector)colorArray2[0]);
            }
        } else if (n3 == 2) {
            pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
        } else {
            pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
            pdVectorArray[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[n3 - 1], (double)0.5, (PdVector)colorArray2[n3 - 2]);
        }
        for (n2 = 2; n2 < n3 - 1; ++n2) {
            pdVectorArray[2 * n2 - 1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[n2 - 1], (double)0.5, (PdVector)colorArray2[n2]);
        }
        if (bl3) {
            if (bl2) {
                if (n3 == 2) {
                    pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[3] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[3].normalize();
                } else {
                    pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 2), (double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 1));
                    pdVectorArray2[2 * n3 - 3].normalize();
                    pdVectorArray2[2 * n3 - 1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 1), (double)0.5, (PdVector)pgPolygon.getVertexNormal(0));
                    pdVectorArray2[2 * n3 - 1].normalize();
                }
            } else if (n3 == 2) {
                pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                pdVectorArray2[1].normalize();
            } else {
                pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                pdVectorArray2[1].normalize();
                pdVectorArray2[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 1), (double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 2));
                pdVectorArray2[2 * n3 - 3].normalize();
            }
            for (n2 = 2; n2 < n3 - 1; ++n2) {
                pdVectorArray2[2 * n2 - 1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(n2 - 1), (double)0.5, (PdVector)pgPolygon.getVertexNormal(n2));
                pdVectorArray2[2 * n2 - 1].normalize();
            }
        }
        if (bl2) {
            pgPolygon.setNumVertices(2 * n3);
        } else {
            pgPolygon.setNumVertices(2 * n3 - 1);
        }
        pgPolygon.setVertices(pdVectorArray);
        if (bl3) {
            pgPolygon.setVertexNormals(pdVectorArray2);
        }
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
        if (pgPolygon.hasVertexColors()) {
            Color[] colorArray3 = pgPolygon.getVertexColors();
            for (n = n3 - 1; n > 0; --n) {
                colorArray3[2 * n] = colorArray3[n];
            }
            for (n = 0; n < n3 - 1; ++n) {
                colorArray3[2 * n + 1] = PdColor.blend((double)0.5, (Color)colorArray3[2 * n], (double)0.5, (Color)colorArray3[2 * n + 2]);
            }
            if (bl2) {
                colorArray3[2 * n3 - 1] = PdColor.blend((double)0.5, (Color)colorArray3[2 * n3 - 2], (double)0.5, (Color)colorArray3[0]);
            }
        }
    }

    public static void refineDLG(PgPolygon pgPolygon) {
        int n;
        Color[] colorArray;
        int n2;
        Color[] colorArray2;
        boolean bl;
        int n3 = pgPolygon.getNumVertices();
        if (n3 < 2) {
            return;
        }
        boolean bl2 = pgPolygon.isClosed();
        PdVector[] pdVectorArray = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 1];
        boolean bl3 = pgPolygon.hasVertexNormals();
        PdVector[] pdVectorArray2 = new PdVector[]{};
        if (bl3) {
            pdVectorArray2 = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 1];
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            colorArray2 = pgPolygon.getEdgeColors();
            n2 = 2 * n3 - 2;
            if (bl2) {
                n2 = 2 * n3;
            }
            colorArray = new Color[n2];
            for (n = 0; n < n2; ++n) {
                colorArray[n] = colorArray2[n / 2];
            }
        } else {
            colorArray = new Color[]{};
        }
        colorArray2 = pgPolygon.getVertices();
        for (n2 = 0; n2 < n3; ++n2) {
            pdVectorArray[2 * n2] = PdVector.copyNew((PdVector)colorArray2[n2]);
        }
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                pdVectorArray2[2 * n2] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(n2));
            }
        }
        if (bl2) {
            if (n3 == 2) {
                pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
                pdVectorArray[3] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
            } else {
                pdVectorArray[1] = PdVector.blendNew((double)-0.0625, (PdVector)colorArray2[n3 - 1], (double)0.5625, (PdVector)colorArray2[0]);
                pdVectorArray[1].blendBase(pdVectorArray[1], 0.5625, (PdVector)colorArray2[1]);
                pdVectorArray[1].blendBase(pdVectorArray[1], -0.0625, (PdVector)colorArray2[2]);
                pdVectorArray[2 * n3 - 3] = PdVector.blendNew((double)-0.0625, (PdVector)colorArray2[0], (double)0.5625, (PdVector)colorArray2[n3 - 1]);
                pdVectorArray[2 * n3 - 3].blendBase(pdVectorArray[2 * n3 - 3], 0.5625, (PdVector)colorArray2[n3 - 2]);
                pdVectorArray[2 * n3 - 3].blendBase(pdVectorArray[2 * n3 - 3], -0.0625, (PdVector)colorArray2[n3 - 3]);
                pdVectorArray[2 * n3 - 1] = PdVector.blendNew((double)-0.0625, (PdVector)colorArray2[1], (double)0.5625, (PdVector)colorArray2[0]);
                pdVectorArray[2 * n3 - 1].blendBase(pdVectorArray[2 * n3 - 1], 0.5625, (PdVector)colorArray2[n3 - 1]);
                pdVectorArray[2 * n3 - 1].blendBase(pdVectorArray[2 * n3 - 1], -0.0625, (PdVector)colorArray2[n3 - 2]);
            }
        } else if (n3 == 2) {
            pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5, (PdVector)colorArray2[1]);
        } else {
            pdVectorArray[1] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[0], (double)0.5625, (PdVector)colorArray2[1], (double)-0.0625, (PdVector)colorArray2[2]);
            pdVectorArray[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)colorArray2[n3 - 1], (double)0.5625, (PdVector)colorArray2[n3 - 2], (double)-0.0625, (PdVector)colorArray2[n3 - 3]);
        }
        for (n2 = 2; n2 < n3 - 1; ++n2) {
            pdVectorArray[2 * n2 - 1] = PdVector.blendNew((double)-0.0625, (PdVector)colorArray2[n2 - 2], (double)0.5625, (PdVector)colorArray2[n2 - 1]);
            pdVectorArray[2 * n2 - 1].blendBase(pdVectorArray[2 * n2 - 1], 0.5625, (PdVector)colorArray2[n2]);
            pdVectorArray[2 * n2 - 1].blendBase(pdVectorArray[2 * n2 - 1], -0.0625, (PdVector)colorArray2[n2 + 1]);
        }
        if (bl3) {
            if (bl2) {
                if (n3 == 2) {
                    pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[3] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[3].normalize();
                } else {
                    pdVectorArray2[1] = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygon.getVertexNormal(n3 - 1), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(0));
                    pdVectorArray2[1].blendBase(pdVectorArray2[1], 0.5625, pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].blendBase(pdVectorArray2[1], -0.0625, pgPolygon.getVertexNormal(2));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[2 * n3 - 3] = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(n3 - 1));
                    pdVectorArray2[2 * n3 - 3].blendBase(pdVectorArray2[2 * n3 - 3], 0.5625, pgPolygon.getVertexNormal(n3 - 2));
                    pdVectorArray2[2 * n3 - 3].blendBase(pdVectorArray2[2 * n3 - 3], -0.0625, pgPolygon.getVertexNormal(n3 - 3));
                    pdVectorArray2[2 * n3 - 3].normalize();
                    pdVectorArray2[2 * n3 - 1] = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygon.getVertexNormal(1), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(0));
                    pdVectorArray2[2 * n3 - 1].blendBase(pdVectorArray2[2 * n3 - 1], 0.5625, pgPolygon.getVertexNormal(n3 - 1));
                    pdVectorArray2[2 * n3 - 1].blendBase(pdVectorArray2[2 * n3 - 1], -0.0625, pgPolygon.getVertexNormal(n3 - 2));
                    pdVectorArray2[2 * n3 - 1].normalize();
                }
            } else if (n3 == 2) {
                pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5, (PdVector)pgPolygon.getVertexNormal(1));
                pdVectorArray2[1].normalize();
            } else {
                pdVectorArray2[1] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(0), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(1));
                pdVectorArray2[1].blendBase(pdVectorArray2[1], -0.0625, pgPolygon.getVertexNormal(2));
                pdVectorArray2[1].normalize();
                pdVectorArray2[2 * n3 - 3] = PdVector.blendNew((double)0.5, (PdVector)pgPolygon.getVertexNormal(n3 - 1), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(n3 - 2));
                pdVectorArray2[2 * n3 - 3].blendBase(pdVectorArray2[2 * n3 - 3], -0.0625, pgPolygon.getVertexNormal(n3 - 3));
                pdVectorArray2[2 * n3 - 3].normalize();
            }
            for (n2 = 2; n2 < n3 - 1; ++n2) {
                pdVectorArray2[2 * n2 - 1] = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygon.getVertexNormal(n2 - 2), (double)0.5625, (PdVector)pgPolygon.getVertexNormal(n2 - 1));
                pdVectorArray2[2 * n2 - 1].blendBase(pdVectorArray2[2 * n2 - 1], 0.5625, pgPolygon.getVertexNormal(n2));
                pdVectorArray2[2 * n2 - 1].blendBase(pdVectorArray2[2 * n2 - 1], -0.0625, pgPolygon.getVertexNormal(n2 + 1));
                pdVectorArray2[2 * n2 - 1].normalize();
            }
        }
        if (bl2) {
            pgPolygon.setNumVertices(2 * n3);
        } else {
            pgPolygon.setNumVertices(2 * n3 - 1);
        }
        pgPolygon.setVertices(pdVectorArray);
        if (bl3) {
            pgPolygon.setVertexNormals(pdVectorArray2);
        }
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
        if (pgPolygon.hasVertexColors()) {
            Color[] colorArray3 = pgPolygon.getVertexColors();
            for (n = n3 - 1; n > 0; --n) {
                colorArray3[2 * n] = colorArray3[n];
            }
            for (n = 0; n < n3 - 1; ++n) {
                colorArray3[2 * n + 1] = PdColor.blend((double)0.5, (Color)colorArray3[2 * n], (double)0.5, (Color)colorArray3[2 * n + 2]);
            }
            if (bl2) {
                colorArray3[2 * n3 - 1] = PdColor.blend((double)0.5, (Color)colorArray3[2 * n3 - 2], (double)0.5, (Color)colorArray3[0]);
            }
        }
    }

    public static void coarsenDLG(PgPolygon pgPolygon) {
        PwRefinePolygon.coarsenLinear(pgPolygon);
    }

    public static void coarsenLinear(PgPolygon pgPolygon) {
        Color[] colorArray;
        boolean bl;
        int n = pgPolygon.getNumVertices();
        for (int i = 0; i < n - 1; ++i) {
            if (i % 2 != 1) continue;
            pgPolygon.setTagVertex(i, 2);
        }
        if (pgPolygon.isClosed() && n % 2 == 0) {
            pgPolygon.setTagVertex(n - 1, 2);
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            Color[] colorArray2 = pgPolygon.getEdgeColors();
            int n2 = n / 2;
            if (pgPolygon.isClosed()) {
                n2 = (n + 1) / 2;
            }
            colorArray = new Color[n2];
            for (int i = 0; i < n2; ++i) {
                colorArray[i] = colorArray2[i * 2];
            }
        } else {
            colorArray = new Color[]{};
        }
        pgPolygon.removeMarkedVertices();
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
    }

    public static void refineChaikin(PgPolygon pgPolygon) {
        int n;
        Color[] colorArray;
        int n2;
        Color[] colorArray2;
        boolean bl;
        double d = 0.25;
        double d2 = 1.0 - d;
        int n3 = pgPolygon.getNumVertices();
        if (n3 < 2) {
            return;
        }
        if (n3 == 2 && !pgPolygon.isClosed()) {
            PwRefinePolygon.refineDLG(pgPolygon);
            return;
        }
        boolean bl2 = pgPolygon.isClosed();
        PdVector[] pdVectorArray = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 2];
        boolean bl3 = pgPolygon.hasVertexNormals();
        PdVector[] pdVectorArray2 = new PdVector[]{};
        if (bl3) {
            pdVectorArray2 = bl2 ? new PdVector[2 * n3] : new PdVector[2 * n3 - 2];
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            colorArray2 = pgPolygon.getEdgeColors();
            n2 = 2 * n3 - 3;
            if (bl2) {
                n2 = 2 * n3;
            }
            colorArray = new Color[n2];
            for (n = 0; n < n3; ++n) {
                if (bl2 || n < n3 - 1) {
                    colorArray[2 * n] = colorArray2[n];
                }
                if (!bl2 && n >= n3 - 2) continue;
                colorArray[2 * n + 1] = PdColor.blend((double)0.5, (Color)colorArray2[n], (double)0.5, (Color)colorArray2[(n + 1) % n3]);
            }
        } else {
            colorArray = new Color[]{};
        }
        colorArray2 = pgPolygon.getVertices();
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                pdVectorArray[2 * n2] = PdVector.blendNew((double)d2, (PdVector)colorArray2[n2], (double)d, (PdVector)colorArray2[(n2 + 1) % n3]);
                pdVectorArray[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)colorArray2[n2], (double)d2, (PdVector)colorArray2[(n2 + 1) % n3]);
            }
            pgPolygon.setNumVertices(2 * n3);
        } else {
            for (n2 = 1; n2 < n3 - 2; ++n2) {
                pdVectorArray[2 * n2] = PdVector.blendNew((double)d2, (PdVector)colorArray2[n2], (double)d, (PdVector)colorArray2[n2 + 1]);
                pdVectorArray[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)colorArray2[n2], (double)d2, (PdVector)colorArray2[n2 + 1]);
            }
            pdVectorArray[0] = PdVector.copyNew((PdVector)colorArray2[0]);
            if (n3 > 2) {
                pdVectorArray[1] = PdVector.blendNew((double)(2.0 * d), (PdVector)colorArray2[0], (double)(d2 - d), (PdVector)colorArray2[1]);
                pdVectorArray[2 * n3 - 4] = PdVector.blendNew((double)(d2 - d), (PdVector)colorArray2[n3 - 2], (double)(2.0 * d), (PdVector)colorArray2[n3 - 1]);
            }
            pdVectorArray[2 * n3 - 3] = PdVector.copyNew((PdVector)colorArray2[n3 - 1]);
            pgPolygon.setNumVertices(2 * n3 - 2);
        }
        pgPolygon.setVertices(pdVectorArray);
        if (bl3) {
            if (bl2) {
                for (n2 = 0; n2 < n3; ++n2) {
                    pdVectorArray2[2 * n2] = PdVector.blendNew((double)d2, (PdVector)pgPolygon.getVertexNormal(n2), (double)d, (PdVector)pgPolygon.getVertexNormal((n2 + 1) % n3));
                    pdVectorArray2[2 * n2].normalize();
                    pdVectorArray2[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)pgPolygon.getVertexNormal(n2), (double)d2, (PdVector)pgPolygon.getVertexNormal((n2 + 1) % n3));
                    pdVectorArray2[2 * n2 + 1].normalize();
                }
            } else {
                for (n2 = 1; n2 < n3 - 2; ++n2) {
                    pdVectorArray2[2 * n2] = PdVector.blendNew((double)d2, (PdVector)pgPolygon.getVertexNormal(n2), (double)d, (PdVector)pgPolygon.getVertexNormal(n2 + 1));
                    pdVectorArray2[2 * n2].normalize();
                    pdVectorArray2[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)pgPolygon.getVertexNormal(n2), (double)d2, (PdVector)pgPolygon.getVertexNormal(n2 + 1));
                    pdVectorArray2[2 * n2 + 1].normalize();
                }
                pdVectorArray2[0] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(0));
                pdVectorArray2[0].normalize();
                if (n3 > 2) {
                    pdVectorArray2[1] = PdVector.blendNew((double)(2.0 * d), (PdVector)pgPolygon.getVertexNormal(0), (double)(d2 - d), (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[2 * n3 - 4] = PdVector.blendNew((double)(d2 - d), (PdVector)pgPolygon.getVertexNormal(n3 - 2), (double)(2.0 * d), (PdVector)pgPolygon.getVertexNormal(n3 - 1));
                    pdVectorArray2[2 * n3 - 4].normalize();
                }
                pdVectorArray2[2 * n3 - 3] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(n3 - 1));
                pdVectorArray2[2 * n3 - 3].normalize();
            }
            pgPolygon.setVertexNormals(pdVectorArray2);
        }
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
        if (pgPolygon.hasVertexColors()) {
            Color[] colorArray3 = pgPolygon.getVertexColors();
            for (n = n3 - 1; n > 0; --n) {
                colorArray3[2 * n - 1] = colorArray3[n];
                colorArray3[2 * n - 2] = colorArray3[n - 1];
            }
            if (bl2) {
                colorArray3[2 * n3 - 2] = colorArray3[2 * n3 - 3];
                colorArray3[2 * n3 - 1] = colorArray3[0];
            }
        }
    }

    public static void coarsenChaikin(PgPolygon pgPolygon) {
        int n;
        int n2;
        Color[] colorArray;
        boolean bl;
        int n3;
        int n4;
        PdVector[] pdVectorArray;
        double d = 0.25;
        double d2 = 1.0 - d;
        double d3 = d2 / (d2 * d2 - d * d);
        double d4 = -d / (d2 * d2 - d * d);
        double d5 = -d / d2;
        double d6 = 1.0 / d2;
        int n5 = pgPolygon.getNumVertices();
        if (n5 < 2) {
            return;
        }
        boolean bl2 = false;
        if (n5 % 2 == 1) {
            bl2 = true;
            pdVectorArray = new PdVector[n5 + 1];
            for (n4 = 0; n4 < n5; ++n4) {
                pdVectorArray[n4] = pgPolygon.getVertex(n4);
            }
            pdVectorArray[n5] = PdVector.copyNew((PdVector)pdVectorArray[n5 - 1]);
            ++n5;
        } else {
            pdVectorArray = pgPolygon.getVertices();
        }
        n4 = pgPolygon.hasVertexNormals();
        PdVector[] pdVectorArray2 = new PdVector[]{};
        PdVector[] pdVectorArray3 = new PdVector[]{};
        if (n4 != 0) {
            if (bl2) {
                pdVectorArray2 = new PdVector[n5 + 1];
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    pdVectorArray2[n3] = pgPolygon.getVertexNormal(n3);
                }
                pdVectorArray2[n5 - 1] = PdVector.copyNew((PdVector)pdVectorArray2[n5 - 2]);
            } else {
                pdVectorArray2 = pgPolygon.getVertexNormals();
            }
        }
        n3 = pgPolygon.isClosed();
        int n6 = n5 / 2;
        PdVector[] pdVectorArray4 = n3 != 0 ? new PdVector[n6] : new PdVector[n6 + 1];
        if (n4 != 0) {
            pdVectorArray3 = n3 != 0 ? new PdVector[n6] : new PdVector[n6 + 1];
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            Color[] colorArray2 = pgPolygon.getEdgeColors();
            colorArray = new Color[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                colorArray[n2] = n2 != n6 - 1 || !bl2 ? colorArray2[n2 * 2] : colorArray2[n2 * 2 - 1];
            }
        } else {
            colorArray = new Color[]{};
        }
        if (n3 != 0) {
            for (n = 0; n < n6; ++n) {
                pdVectorArray[2 * n] = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[2 * n], (double)d4, (PdVector)pdVectorArray[2 * n + 1]);
                pdVectorArray[2 * n + 1] = PdVector.blendNew((double)d5, (PdVector)pdVectorArray[2 * n], (double)d6, (PdVector)pdVectorArray[2 * n + 1]);
            }
        } else {
            for (n = 1; n < n6 - 1; ++n) {
                pdVectorArray[2 * n] = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[2 * n], (double)d4, (PdVector)pdVectorArray[2 * n + 1]);
                pdVectorArray[2 * n + 1] = PdVector.blendNew((double)d5, (PdVector)pdVectorArray[2 * n], (double)d6, (PdVector)pdVectorArray[2 * n + 1]);
            }
            if (n6 > 1) {
                pdVectorArray[1] = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[1], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[0]);
                pdVectorArray[2 * n6 - 2] = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[2 * n6 - 2], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[2 * n6 - 1]);
            }
        }
        for (n = 1; n < n6; ++n) {
            pdVectorArray4[n] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[2 * n - 1], (double)0.5, (PdVector)pdVectorArray[2 * n]);
        }
        if (n3 != 0) {
            pdVectorArray4[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[0], (double)0.5, (PdVector)pdVectorArray[n5 - 1]);
            pgPolygon.setNumVertices(n6);
        } else {
            pdVectorArray4[0] = pdVectorArray[0];
            pdVectorArray4[n6] = pdVectorArray[n5 - 1];
            pgPolygon.setNumVertices(n6 + 1);
        }
        pgPolygon.setVertices(pdVectorArray4);
        if (n4 != 0) {
            if (n3 != 0) {
                for (n = 0; n < n6; ++n) {
                    pdVectorArray2[2 * n] = PdVector.blendNew((double)d3, (PdVector)pdVectorArray2[2 * n], (double)d4, (PdVector)pdVectorArray2[2 * n + 1]);
                    pdVectorArray2[2 * n + 1] = PdVector.blendNew((double)d5, (PdVector)pdVectorArray2[2 * n], (double)d6, (PdVector)pdVectorArray2[2 * n + 1]);
                }
            } else {
                for (n = 1; n < n6 - 1; ++n) {
                    pdVectorArray2[2 * n] = PdVector.blendNew((double)d3, (PdVector)pdVectorArray2[2 * n], (double)d4, (PdVector)pdVectorArray2[2 * n + 1]);
                    pdVectorArray2[2 * n + 1] = PdVector.blendNew((double)d5, (PdVector)pdVectorArray2[2 * n], (double)d6, (PdVector)pdVectorArray2[2 * n + 1]);
                }
                pdVectorArray2[0] = PdVector.copyNew((PdVector)pdVectorArray2[0]);
                pdVectorArray2[1] = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray2[1], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray2[0]);
                pdVectorArray2[2 * n6 - 2] = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray2[2 * n6 - 2], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray2[2 * n6 - 1]);
                pdVectorArray2[2 * n6 - 1] = PdVector.copyNew((PdVector)pdVectorArray2[2 * n6 - 1]);
            }
            for (n = 1; n < n6; ++n) {
                pdVectorArray3[n] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray2[2 * n - 1], (double)0.5, (PdVector)pdVectorArray2[2 * n]);
                pdVectorArray3[n].normalize();
            }
            if (n3 != 0) {
                pdVectorArray3[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray2[0], (double)0.5, (PdVector)pdVectorArray2[n5 - 1]);
                pdVectorArray3[0].normalize();
            } else {
                pdVectorArray3[0] = pdVectorArray2[0];
                pdVectorArray3[0].normalize();
                pdVectorArray3[n6] = pdVectorArray2[n5 - 1];
                pdVectorArray3[n6].normalize();
            }
            pgPolygon.setVertexNormals(pdVectorArray3);
        }
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
        if (pgPolygon.hasVertexColors()) {
            Color[] colorArray3 = pgPolygon.getVertexColors();
            for (n2 = 0; n2 < n6; ++n2) {
                colorArray3[n2] = new Color(colorArray3[2 * n2].getRGB());
            }
            if (n3 == 0) {
                colorArray3[n6] = bl2 ? colorArray3[n5 - 2] : colorArray3[n5 - 1];
            }
        }
    }

    public static void refineDFH(PgPolygon pgPolygon, PdVector pdVector) {
        int n;
        int n2;
        int n3;
        int n4;
        Color[] colorArray;
        int n5;
        Color[] colorArray2;
        boolean bl;
        int n6 = pdVector.getSize();
        if (n6 % 2 != 0 || n6 == 0) {
            return;
        }
        int n7 = n6 / 2;
        int n8 = pgPolygon.getNumVertices();
        if (n8 < 2) {
            return;
        }
        if (n8 == 2 && !pgPolygon.isClosed()) {
            PwRefinePolygon.refineDLG(pgPolygon);
            return;
        }
        boolean bl2 = pgPolygon.isClosed();
        PdVector[] pdVectorArray = bl2 ? new PdVector[2 * n8] : new PdVector[2 * n8 - 2];
        boolean bl3 = pgPolygon.hasVertexNormals();
        PdVector[] pdVectorArray2 = new PdVector[]{};
        if (bl3) {
            pdVectorArray2 = bl2 ? new PdVector[2 * n8] : new PdVector[2 * n8 - 2];
        }
        if (bl = pgPolygon.hasEdgeColors()) {
            colorArray2 = pgPolygon.getEdgeColors();
            n5 = 2 * n8 - 3;
            if (bl2) {
                n5 = 2 * n8;
            }
            colorArray = new Color[n5];
            for (n4 = 0; n4 < n8; ++n4) {
                if (bl2 || n4 < n8 - 1) {
                    colorArray[2 * n4] = colorArray2[n4];
                }
                if (!bl2 && n4 >= n8 - 2) continue;
                colorArray[2 * n4 + 1] = PdColor.blend((double)0.5, (Color)colorArray2[n4], (double)0.5, (Color)colorArray2[(n4 + 1) % n8]);
            }
        } else {
            colorArray = new Color[]{};
        }
        colorArray2 = pgPolygon.getVertices();
        if (bl2) {
            for (n5 = 0; n5 < n8; ++n5) {
                pdVectorArray[2 * n5] = PdVector.blendNew((double)pdVector.m_data[n7 - 1], (PdVector)colorArray2[n5], (double)pdVector.m_data[n7], (PdVector)colorArray2[(n5 + 1) % n8]);
                pdVectorArray[2 * n5 + 1] = PdVector.blendNew((double)pdVector.m_data[n7], (PdVector)colorArray2[n5], (double)pdVector.m_data[n7 - 1], (PdVector)colorArray2[(n5 + 1) % n8]);
                n4 = n5;
                while (n4 - n7 + 1 < 0) {
                    n4 += n8;
                }
                for (n3 = 1; n3 < n7; ++n3) {
                    pdVectorArray[2 * n5].blendBase(pdVectorArray[2 * n5], pdVector.m_data[n7 - 1 - n3], (PdVector)colorArray2[(n4 - n3) % n8]);
                    pdVectorArray[2 * n5].blendBase(pdVectorArray[2 * n5], pdVector.m_data[n7 + n3], (PdVector)colorArray2[(n4 + 1 + n3) % n8]);
                    pdVectorArray[2 * n5 + 1].blendBase(pdVectorArray[2 * n5 + 1], pdVector.m_data[n7 - 1 - n3], (PdVector)colorArray2[(n4 + 1 + n3) % n8]);
                    pdVectorArray[2 * n5 + 1].blendBase(pdVectorArray[2 * n5 + 1], pdVector.m_data[n7 + n3], (PdVector)colorArray2[(n4 - n3) % n8]);
                }
            }
            pgPolygon.setNumVertices(2 * n8);
        } else {
            int[] nArray = new int[n6];
            PdVector pdVector2 = PdVector.copyNew((PdVector)pdVector);
            for (n3 = 0; n3 < n8 - 1; ++n3) {
                for (int i = 0; i < 2; ++i) {
                    int n9;
                    if (n3 == 0 && i == 0) {
                        pdVectorArray[2 * n3 + i] = PdVector.copyNew((PdVector)colorArray2[0]);
                        continue;
                    }
                    if (n3 == n8 - 2 && i == 1) {
                        pdVectorArray[2 * n3 + i] = PdVector.copyNew((PdVector)colorArray2[n8 - 1]);
                        continue;
                    }
                    pdVector2.copy(pdVector);
                    if (i == 1) {
                        pdVector2.invert(n6);
                    }
                    n2 = -1;
                    n = -1;
                    for (n9 = 0; n9 < n7; ++n9) {
                        nArray[n9] = n3 - n7 + 1 + n9;
                        if (nArray[n9] == 0) {
                            n2 = n9;
                        }
                        nArray[n7 + n9] = n3 + n9 + 1;
                        if (nArray[n7 + n9] != n8 - 1) continue;
                        n = n7 + n9;
                    }
                    for (n9 = 0; n9 < n7; ++n9) {
                        if (nArray[n9] < 1) {
                            int n10 = n2 + 1 - nArray[n9];
                            pdVector2.m_data[n10] = pdVector2.m_data[n10] - pdVector2.m_data[n9];
                            nArray[n9] = 0;
                            int n11 = n9;
                            pdVector2.m_data[n11] = pdVector2.m_data[n11] * 2.0;
                        }
                        if (nArray[n6 - 1 - n9] <= n8 - 2) continue;
                        int n12 = n - 1 - (nArray[n6 - 1 - n9] - (n8 - 1));
                        pdVector2.m_data[n12] = pdVector2.m_data[n12] - pdVector2.m_data[n6 - 1 - n9];
                        nArray[n6 - 1 - n9] = n8 - 1;
                        int n13 = n6 - 1 - n9;
                        pdVector2.m_data[n13] = pdVector2.m_data[n13] * 2.0;
                    }
                    pdVectorArray[2 * n3 + i] = PdVector.blendNew((double)pdVector2.m_data[n7 - 1], (PdVector)colorArray2[n3], (double)pdVector2.m_data[n7], (PdVector)colorArray2[(n3 + 1) % n8]);
                    for (n9 = 0; n9 < n7 - 1; ++n9) {
                        pdVectorArray[2 * n3 + i].blendBase(pdVectorArray[2 * n3 + i], pdVector2.m_data[n9], (PdVector)colorArray2[nArray[n9]]);
                        pdVectorArray[2 * n3 + i].blendBase(pdVectorArray[2 * n3 + i], pdVector2.m_data[n6 - 1 - n9], (PdVector)colorArray2[nArray[n6 - 1 - n9]]);
                    }
                }
            }
            pgPolygon.setNumVertices(2 * n8 - 2);
        }
        pgPolygon.setVertices(pdVectorArray);
        double d = 0.25;
        double d2 = 0.75;
        if (bl3) {
            if (bl2) {
                for (n2 = 0; n2 < n8; ++n2) {
                    pdVectorArray2[2 * n2] = PdVector.blendNew((double)d2, (PdVector)pgPolygon.getVertexNormal(n2), (double)d, (PdVector)pgPolygon.getVertexNormal((n2 + 1) % n8));
                    pdVectorArray2[2 * n2].normalize();
                    pdVectorArray2[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)pgPolygon.getVertexNormal(n2), (double)d2, (PdVector)pgPolygon.getVertexNormal((n2 + 1) % n8));
                    pdVectorArray2[2 * n2 + 1].normalize();
                }
            } else {
                for (n2 = 1; n2 < n8 - 2; ++n2) {
                    pdVectorArray2[2 * n2] = PdVector.blendNew((double)d2, (PdVector)pgPolygon.getVertexNormal(n2), (double)d, (PdVector)pgPolygon.getVertexNormal(n2 + 1));
                    pdVectorArray2[2 * n2].normalize();
                    pdVectorArray2[2 * n2 + 1] = PdVector.blendNew((double)d, (PdVector)pgPolygon.getVertexNormal(n2), (double)d2, (PdVector)pgPolygon.getVertexNormal(n2 + 1));
                    pdVectorArray2[2 * n2 + 1].normalize();
                }
                pdVectorArray2[0] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(0));
                pdVectorArray2[0].normalize();
                if (n8 > 2) {
                    pdVectorArray2[1] = PdVector.blendNew((double)(2.0 * d), (PdVector)pgPolygon.getVertexNormal(0), (double)(d2 - d), (PdVector)pgPolygon.getVertexNormal(1));
                    pdVectorArray2[1].normalize();
                    pdVectorArray2[2 * n8 - 4] = PdVector.blendNew((double)(d2 - d), (PdVector)pgPolygon.getVertexNormal(n8 - 2), (double)(2.0 * d), (PdVector)pgPolygon.getVertexNormal(n8 - 1));
                    pdVectorArray2[2 * n8 - 4].normalize();
                }
                pdVectorArray2[2 * n8 - 3] = PdVector.copyNew((PdVector)pgPolygon.getVertexNormal(n8 - 1));
                pdVectorArray2[2 * n8 - 3].normalize();
            }
            pgPolygon.setVertexNormals(pdVectorArray2);
        }
        if (bl) {
            pgPolygon.setEdgeColors(colorArray);
        }
        if (pgPolygon.hasVertexColors()) {
            Color[] colorArray3 = pgPolygon.getVertexColors();
            for (n = n8 - 1; n > 0; --n) {
                colorArray3[2 * n - 1] = colorArray3[n];
                colorArray3[2 * n - 2] = colorArray3[n - 1];
            }
            if (bl2) {
                colorArray3[2 * n8 - 2] = colorArray3[2 * n8 - 3];
                colorArray3[2 * n8 - 1] = colorArray3[0];
            }
        }
    }

    public static void coarsenDFH(PgPolygon pgPolygon) {
        PwRefinePolygon.coarsenChaikin(pgPolygon);
    }

    public static void refineLinear(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n3];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        Vector<PdVector> vector = new Vector<PdVector>();
        Vector<PdVector> vector2 = new Vector<PdVector>();
        int n4 = n2 = pgPolygonSet.getNumVertices();
        boolean bl = pgPolygonSet.hasVertexNormals();
        for (n = 0; n < n3; ++n) {
            PdVector pdVector;
            int n5;
            boolean bl2 = pgPolygonSet.isClosed(n);
            PiVector piVector = pgPolygonSet.getPolygon(n);
            int n6 = piVector.getSize();
            if (n6 < 2 || bl2 && n6 < 3) {
                piVectorArray[n] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            piVectorArray[n] = new PiVector(2 * n6 - 1);
            for (n5 = 0; n5 < n6; ++n5) {
                piVectorArray[n].m_data[2 * n5] = piVector.m_data[n5];
            }
            if (bl2) {
                if (n6 == 3) {
                    piVectorArray[n].m_data[1] = n4++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
                    piVectorArray[n].m_data[3] = n4++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
                } else {
                    PdVector pdVector2 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]);
                    piVectorArray[n].m_data[1] = n4++;
                    vector.addElement(PdVector.copyNew((PdVector)pdVector2));
                    pdVector2 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6 - 2]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6 - 1]]);
                    piVectorArray[n].m_data[2 * n6 - 3] = n4++;
                    vector.addElement(PdVector.copyNew((PdVector)pdVector2));
                }
            } else if (n6 == 2) {
                piVectorArray[n].m_data[1] = n4++;
                vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
            } else {
                PdVector pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]);
                piVectorArray[n].m_data[1] = n4++;
                vector.addElement(PdVector.copyNew((PdVector)pdVector3));
                pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6 - 1]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6 - 2]]);
                piVectorArray[n].m_data[2 * n6 - 3] = n4++;
                vector.addElement(pdVector3);
            }
            for (n5 = 2; n5 < n6 - 1; ++n5) {
                pdVector = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n5 - 1]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[n5]]);
                piVectorArray[n].m_data[2 * n5 - 1] = n4++;
                vector.addElement(pdVector);
            }
            if (bl) {
                if (bl2) {
                    if (n6 == 3) {
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                        if (bl) {
                            vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                        }
                    } else {
                        PdVector pdVector4 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]));
                        vector2.addElement(pdVector4);
                        pdVector4 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 2]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 1]));
                        vector2.addElement(pdVector4);
                    }
                } else if (n6 == 2) {
                    vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                } else {
                    PdVector pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]));
                    vector2.addElement(pdVector5);
                    pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 1]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 2]));
                    vector2.addElement(pdVector5);
                }
                for (n5 = 2; n5 < n6 - 1; ++n5) {
                    pdVector = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n5 - 1]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n5]));
                    vector2.addElement(pdVector);
                }
            }
            if (!pgPolygonSet.hasVertexColors()) continue;
            pgPolygonSet.setNumVertices(n4);
            Color[] colorArray = pgPolygonSet.getVertexColors();
            for (int i = 0; i < n6 - 1; ++i) {
                colorArray[piVectorArray[n].m_data[2 * i + 1]] = PdColor.blend((double)0.5, (Color)colorArray[piVector.m_data[i]], (double)0.5, (Color)colorArray[piVector.m_data[i + 1]]);
            }
        }
        pgPolygonSet.setNumVertices(n4);
        for (n = n2; n < n4; ++n) {
            pgPolygonSet.setVertex(n, (PdVector)vector.elementAt(n - n2));
        }
        if (bl) {
            for (n = n2; n < n4; ++n) {
                ((PdVector)vector2.elementAt(n - n2)).normalize();
                pgPolygonSet.setVertexNormal(n, (PdVector)vector2.elementAt(n - n2));
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
    }

    public static void refineDLG(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n3];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        Vector<PdVector> vector = new Vector<PdVector>();
        Vector<PdVector> vector2 = new Vector<PdVector>();
        int n4 = n2 = pgPolygonSet.getNumVertices();
        boolean bl = pgPolygonSet.hasVertexNormals();
        for (n = 0; n < n3; ++n) {
            PdVector pdVector;
            int n5;
            boolean bl2 = pgPolygonSet.isClosed(n);
            PiVector piVector = pgPolygonSet.getPolygon(n);
            int n6 = piVector.getSize();
            if (n6 < 2 || bl2 && n6 < 3) {
                piVectorArray[n] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            piVectorArray[n] = new PiVector(2 * n6 - 1);
            for (n5 = 0; n5 < n6; ++n5) {
                piVectorArray[n].m_data[2 * n5] = piVector.m_data[n5];
            }
            if (bl2) {
                if (n6 == 3) {
                    piVectorArray[n].m_data[1] = n4++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
                    piVectorArray[n].m_data[3] = n4++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
                } else {
                    PdVector pdVector2 = PdVector.blendNew((double)-0.0625, (PdVector)pdVectorArray[piVector.m_data[n6 - 2]], (double)0.5625, (PdVector)pdVectorArray[piVector.m_data[0]]);
                    pdVector2.blendBase(pdVector2, 0.5625, pdVectorArray[piVector.m_data[1]]);
                    pdVector2.blendBase(pdVector2, -0.0625, pdVectorArray[piVector.m_data[2]]);
                    piVectorArray[n].m_data[1] = n4++;
                    vector.addElement(PdVector.copyNew((PdVector)pdVector2));
                    pdVector2 = PdVector.blendNew((double)-0.0625, (PdVector)pdVectorArray[piVector.m_data[1]], (double)0.5625, (PdVector)pdVectorArray[piVector.m_data[n6 - 1]]);
                    pdVector2.blendBase(pdVector2, 0.5625, pdVectorArray[piVector.m_data[n6 - 2]]);
                    pdVector2.blendBase(pdVector2, -0.0625, pdVectorArray[piVector.m_data[n6 - 3]]);
                    piVectorArray[n].m_data[2 * n6 - 3] = n4++;
                    vector.addElement(PdVector.copyNew((PdVector)pdVector2));
                }
            } else if (n6 == 2) {
                piVectorArray[n].m_data[1] = n4++;
                vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]));
            } else {
                PdVector pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5625, (PdVector)pdVectorArray[piVector.m_data[1]]);
                pdVector3.blendBase(pdVector3, -0.0625, pdVectorArray[piVector.m_data[2]]);
                piVectorArray[n].m_data[1] = n4++;
                vector.addElement(PdVector.copyNew((PdVector)pdVector3));
                pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6 - 1]], (double)0.5625, (PdVector)pdVectorArray[piVector.m_data[n6 - 2]]);
                pdVector3.blendBase(pdVector3, -0.0625, pdVectorArray[piVector.m_data[n6 - 3]]);
                piVectorArray[n].m_data[2 * n6 - 3] = n4++;
                vector.addElement(pdVector3);
            }
            for (n5 = 2; n5 < n6 - 1; ++n5) {
                pdVector = PdVector.blendNew((double)-0.0625, (PdVector)pdVectorArray[piVector.m_data[n5 - 2]], (double)0.5625, (PdVector)pdVectorArray[piVector.m_data[n5 - 1]]);
                pdVector.blendBase(pdVector, 0.5625, pdVectorArray[piVector.m_data[n5]]);
                pdVector.blendBase(pdVector, -0.0625, pdVectorArray[piVector.m_data[n5 + 1]]);
                piVectorArray[n].m_data[2 * n5 - 1] = n4++;
                vector.addElement(pdVector);
            }
            if (bl) {
                if (bl2) {
                    if (n6 == 3) {
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                        if (bl) {
                            vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                        }
                    } else {
                        PdVector pdVector4 = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 2]), (double)0.5625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]));
                        pdVector4.blendBase(pdVector4, 0.5625, pgPolygonSet.getVertexNormal(piVector.m_data[1]));
                        pdVector4.blendBase(pdVector4, -0.0625, pgPolygonSet.getVertexNormal(piVector.m_data[2]));
                        vector2.addElement(pdVector4);
                        pdVector4 = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]), (double)0.5625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 1]));
                        pdVector4.blendBase(pdVector4, 0.5625, pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 2]));
                        pdVector4.blendBase(pdVector4, -0.0625, pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 3]));
                        vector2.addElement(pdVector4);
                    }
                } else if (n6 == 2) {
                    vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                } else {
                    PdVector pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)0.5625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]));
                    pdVector5.blendBase(pdVector5, -0.0625, pgPolygonSet.getVertexNormal(piVector.m_data[2]));
                    vector2.addElement(pdVector5);
                    pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 1]), (double)0.5625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 2]));
                    pdVector5.blendBase(pdVector5, -0.0625, pgPolygonSet.getVertexNormal(piVector.m_data[n6 - 3]));
                    vector2.addElement(pdVector5);
                }
                for (n5 = 2; n5 < n6 - 1; ++n5) {
                    pdVector = PdVector.blendNew((double)-0.0625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n5 - 2]), (double)0.5625, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n5 - 1]));
                    pdVector.blendBase(pdVector, 0.5625, pgPolygonSet.getVertexNormal(piVector.m_data[n5]));
                    pdVector.blendBase(pdVector, -0.0625, pgPolygonSet.getVertexNormal(piVector.m_data[n5 + 1]));
                    vector2.addElement(pdVector);
                }
            }
            if (!pgPolygonSet.hasVertexColors()) continue;
            pgPolygonSet.setNumVertices(n4);
            Color[] colorArray = pgPolygonSet.getVertexColors();
            for (int i = 0; i < n6 - 1; ++i) {
                colorArray[piVectorArray[n].m_data[2 * i + 1]] = PdColor.blend((double)0.5, (Color)colorArray[piVector.m_data[i]], (double)0.5, (Color)colorArray[piVector.m_data[i + 1]]);
            }
        }
        pgPolygonSet.setNumVertices(n4);
        for (n = n2; n < n4; ++n) {
            pgPolygonSet.setVertex(n, (PdVector)vector.elementAt(n - n2));
        }
        if (bl) {
            for (n = n2; n < n4; ++n) {
                ((PdVector)vector2.elementAt(n - n2)).normalize();
                pgPolygonSet.setVertexNormal(n, (PdVector)vector2.elementAt(n - n2));
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
    }

    public static void coarsenDLG(PgPolygonSet pgPolygonSet) {
        PwRefinePolygon.coarsenLinear(pgPolygonSet);
    }

    public static void coarsenLinear(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3;
        int n4 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            PiVector piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            if (n2 < 3) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            piVectorArray[n3] = new PiVector(n2 / 2 + 1);
            piVectorArray[n3].m_data[n2 / 2] = piVector.m_data[n2 - 1];
            for (n = 0; n < n2 / 2; ++n) {
                piVectorArray[n3].m_data[n] = piVector.m_data[2 * n];
                pgPolygonSet.setTagVertex(piVector.m_data[2 * n + 1], 2);
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = piVectorArray[n3].getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.clearTagVertex(piVectorArray[n3].m_data[n], 2);
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
        pgPolygonSet.removeMarkedVertices();
    }

    public static void refineChaikin(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        PiVector piVector;
        int n3;
        int n4;
        double d = 0.25;
        double d2 = 1.0 - d;
        int n5 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n5];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        Vector<PdVector> vector = new Vector<PdVector>();
        boolean bl = pgPolygonSet.hasVertexNormals();
        Vector<PdVector> vector2 = new Vector<PdVector>();
        int n6 = n4 = pgPolygonSet.getNumVertices();
        for (n3 = 0; n3 < n5; ++n3) {
            int n7;
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = pgPolygonSet.isClosed(n3);
            n = piVector.getSize();
            if (n < 2 || n2 != 0 && n < 3) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            if (n2 != 0) {
                piVectorArray[n3] = new PiVector(2 * n - 1);
                for (n7 = 0; n7 < n - 1; ++n7) {
                    piVectorArray[n3].m_data[2 * n7] = n6++;
                    vector.addElement(PdVector.blendNew((double)d2, (PdVector)pdVectorArray[piVector.m_data[n7]], (double)d, (PdVector)pdVectorArray[piVector.m_data[(n7 + 1) % n]]));
                    piVectorArray[n3].m_data[2 * n7 + 1] = n6++;
                    vector.addElement(PdVector.blendNew((double)d, (PdVector)pdVectorArray[piVector.m_data[n7]], (double)d2, (PdVector)pdVectorArray[piVector.m_data[(n7 + 1) % n]]));
                }
                piVectorArray[n3].m_data[2 * n - 2] = piVectorArray[n3].m_data[0];
            } else if (n == 2) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
            } else {
                piVectorArray[n3] = new PiVector(2 * n - 2);
                for (int i = 1; i < n - 2; ++i) {
                    piVectorArray[n3].m_data[2 * i] = n6++;
                    vector.addElement(PdVector.blendNew((double)d2, (PdVector)pdVectorArray[piVector.m_data[i]], (double)d, (PdVector)pdVectorArray[piVector.m_data[i + 1]]));
                    piVectorArray[n3].m_data[2 * i + 1] = n6++;
                    vector.addElement(PdVector.blendNew((double)d, (PdVector)pdVectorArray[piVector.m_data[i]], (double)d2, (PdVector)pdVectorArray[piVector.m_data[i + 1]]));
                }
                piVectorArray[n3].m_data[0] = piVector.m_data[0];
                piVectorArray[n3].m_data[1] = n6++;
                vector.addElement(PdVector.blendNew((double)(2.0 * d), (PdVector)pdVectorArray[piVector.m_data[0]], (double)(d2 - d), (PdVector)pdVectorArray[piVector.m_data[1]]));
                piVectorArray[n3].m_data[2 * n - 4] = n6++;
                vector.addElement(PdVector.blendNew((double)(d2 - d), (PdVector)pdVectorArray[piVector.m_data[n - 2]], (double)(2.0 * d), (PdVector)pdVectorArray[piVector.m_data[n - 1]]));
                piVectorArray[n3].m_data[2 * n - 3] = piVector.m_data[n - 1];
            }
            if (bl) {
                if (n2 != 0) {
                    for (n7 = 0; n7 < n - 1; ++n7) {
                        vector2.addElement(PdVector.blendNew((double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7]), (double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[(n7 + 1) % n])));
                        vector2.addElement(PdVector.blendNew((double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7]), (double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[(n7 + 1) % n])));
                    }
                } else if (n != 2) {
                    for (n7 = 1; n7 < n - 2; ++n7) {
                        vector2.addElement(PdVector.blendNew((double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7]), (double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7 + 1])));
                        vector2.addElement(PdVector.blendNew((double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7]), (double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n7 + 1])));
                    }
                    vector2.addElement(PdVector.blendNew((double)(2.0 * d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)(d2 - d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                    vector2.addElement(PdVector.blendNew((double)(d2 - d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n - 2]), (double)(2.0 * d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n - 1])));
                }
            }
            if (!pgPolygonSet.hasVertexColors()) continue;
            pgPolygonSet.setNumVertices(n6);
            Color[] colorArray = pgPolygonSet.getVertexColors();
            for (int i = 0; i < n - 1; ++i) {
                colorArray[piVectorArray[n3].m_data[2 * i]] = colorArray[piVector.m_data[i]];
                colorArray[piVectorArray[n3].m_data[2 * i + 1]] = colorArray[piVector.m_data[i + 1]];
            }
            if (n2 == 0) continue;
            colorArray[piVectorArray[n3].m_data[2 * n - 2]] = colorArray[piVectorArray[n3].m_data[0]];
        }
        pgPolygonSet.setNumVertices(n6);
        for (n3 = n4; n3 < n6; ++n3) {
            pgPolygonSet.setVertex(n3, (PdVector)vector.elementAt(n3 - n4));
        }
        if (bl) {
            for (n3 = n4; n3 < n6; ++n3) {
                ((PdVector)vector2.elementAt(n3 - n4)).normalize();
                pgPolygonSet.setVertexNormal(n3, (PdVector)vector2.elementAt(n3 - n4));
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.setTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
        for (n3 = 0; n3 < n5; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.clearTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.removeMarkedVertices();
    }

    public static void coarsenChaikin(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        PiVector piVector;
        int n3;
        int n4;
        double d = 0.25;
        double d2 = 1.0 - d;
        double d3 = d2 / (d2 * d2 - d * d);
        double d4 = -d / (d2 * d2 - d * d);
        int n5 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n5];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        Vector<PdVector> vector = new Vector<PdVector>();
        boolean bl = pgPolygonSet.hasVertexNormals();
        Vector<PdVector> vector2 = new Vector<PdVector>();
        int n6 = n4 = pgPolygonSet.getNumVertices();
        for (n3 = 0; n3 < n5; ++n3) {
            int n7;
            PdVector pdVector;
            PdVector pdVector2;
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            n = pgPolygonSet.isClosed(n3);
            if (n2 < 2 || n == 1 && n2 < 3) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            if (n2 % 2 == 1 && n == 0 || n2 % 2 == 0 && n != 0) {
                piVector.setSize(n2 + 1);
                piVector.m_data[n2] = piVector.m_data[n2 - 1];
                ++n2;
            }
            piVectorArray[n3] = new PiVector(n2 / 2 + 1);
            if (n != 0) {
                if (n2 == 3) {
                    piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
                } else {
                    pdVector2 = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[piVector.m_data[n2 - 3]], (double)d3, (PdVector)pdVectorArray[piVector.m_data[n2 - 2]]);
                    pdVector = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[piVector.m_data[0]], (double)d4, (PdVector)pdVectorArray[piVector.m_data[1]]);
                    piVectorArray[n3].m_data[0] = n6++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                    piVectorArray[n3].m_data[n2 / 2] = piVectorArray[n3].m_data[0];
                    for (n7 = 1; n7 < n2 / 2; ++n7) {
                        pdVector2 = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[piVector.m_data[2 * n7 - 2]], (double)d3, (PdVector)pdVectorArray[piVector.m_data[2 * n7 - 1]]);
                        pdVector = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[piVector.m_data[2 * n7]], (double)d4, (PdVector)pdVectorArray[piVector.m_data[2 * n7 + 1]]);
                        piVectorArray[n3].m_data[n7] = n6++;
                        vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                    }
                }
            } else if (n2 == 2) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
            } else {
                PdVector pdVector3;
                piVectorArray[n3].m_data[0] = piVector.m_data[0];
                if (n2 > 4) {
                    pdVector2 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[piVector.m_data[1]], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[piVector.m_data[0]]);
                    pdVector3 = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[piVector.m_data[2]], (double)d4, (PdVector)pdVectorArray[piVector.m_data[3]]);
                    piVectorArray[n3].m_data[1] = n6++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector3));
                    pdVector2 = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[piVector.m_data[n2 - 4]], (double)d3, (PdVector)pdVectorArray[piVector.m_data[n2 - 3]]);
                    pdVector3 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[piVector.m_data[n2 - 2]], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[piVector.m_data[n2 - 1]]);
                    piVectorArray[n3].m_data[n2 / 2 - 1] = n6++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector3));
                } else {
                    pdVector2 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[piVector.m_data[1]], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[piVector.m_data[0]]);
                    pdVector3 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pdVectorArray[piVector.m_data[n2 - 2]], (double)(2.0 * d / (d - d2)), (PdVector)pdVectorArray[piVector.m_data[n2 - 1]]);
                    piVectorArray[n3].m_data[1] = n6++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector3));
                }
                piVectorArray[n3].m_data[n2 / 2] = piVector.m_data[n2 - 1];
                for (n7 = 2; n7 < n2 / 2 - 1; ++n7) {
                    pdVector2 = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[piVector.m_data[2 * n7 - 2]], (double)d3, (PdVector)pdVectorArray[piVector.m_data[2 * n7 - 1]]);
                    pdVector3 = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[piVector.m_data[2 * n7]], (double)d4, (PdVector)pdVectorArray[piVector.m_data[2 * n7 + 1]]);
                    piVectorArray[n3].m_data[n7] = n6++;
                    vector.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector3));
                }
            }
            if (bl) {
                if (n != 0) {
                    if (n2 != 3) {
                        pdVector2 = PdVector.blendNew((double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 3]), (double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 2]));
                        pdVector = PdVector.blendNew((double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]));
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                        for (n7 = 1; n7 < n2 / 2; ++n7) {
                            pdVector2 = PdVector.blendNew((double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 - 2]), (double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 - 1]));
                            pdVector = PdVector.blendNew((double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7]), (double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 + 1]));
                            vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                        }
                    }
                } else if (n2 != 2) {
                    if (n2 > 4) {
                        pdVector2 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]), (double)(2.0 * d / (d - d2)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]));
                        pdVector = PdVector.blendNew((double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2]), (double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[3]));
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                        pdVector2 = PdVector.blendNew((double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 4]), (double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 3]));
                        pdVector = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 2]), (double)(2.0 * d / (d - d2)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 1]));
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                    } else {
                        pdVector2 = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1]), (double)(2.0 * d / (d - d2)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]));
                        pdVector = PdVector.blendNew((double)(1.0 / (d2 - d)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 2]), (double)(2.0 * d / (d - d2)), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n2 - 1]));
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                    }
                    for (n7 = 2; n7 < n2 / 2 - 1; ++n7) {
                        pdVector2 = PdVector.blendNew((double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 - 2]), (double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 - 1]));
                        pdVector = PdVector.blendNew((double)d3, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7]), (double)d4, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[2 * n7 + 1]));
                        vector2.addElement(PdVector.blendNew((double)0.5, (PdVector)pdVector2, (double)0.5, (PdVector)pdVector));
                    }
                }
            }
            if (!pgPolygonSet.hasVertexColors()) continue;
            pgPolygonSet.setNumVertices(n6);
            pdVector2 = pgPolygonSet.getVertexColors();
            for (int i = 0; i < n2 / 2; ++i) {
                pdVector2[piVectorArray[n3].m_data[i]] = pdVector2[piVector.m_data[2 * i]];
            }
            pdVector2[piVectorArray[n3].m_data[n2 / 2]] = pdVector2[piVector.m_data[n2 - 1]];
        }
        pgPolygonSet.setNumVertices(n6);
        for (n3 = n4; n3 < n6; ++n3) {
            pgPolygonSet.setVertex(n3, (PdVector)vector.elementAt(n3 - n4));
        }
        if (bl) {
            for (n3 = n4; n3 < n6; ++n3) {
                ((PdVector)vector2.elementAt(n3 - n4)).normalize();
                pgPolygonSet.setVertexNormal(n3, (PdVector)vector2.elementAt(n3 - n4));
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.setTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
        for (n3 = 0; n3 < n5; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.clearTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.removeMarkedVertices();
    }

    public static void refineDFH(PgPolygonSet pgPolygonSet, PdVector pdVector) {
        int n;
        int n2;
        PiVector piVector;
        int n3;
        int n4;
        int n5 = pdVector.getSize();
        if (n5 % 2 != 0 || n5 == 0) {
            return;
        }
        int n6 = n5 / 2;
        int n7 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = new PiVector[n7];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        Vector<PdVector> vector = new Vector<PdVector>();
        boolean bl = pgPolygonSet.hasVertexNormals();
        Vector<PdVector> vector2 = new Vector<PdVector>();
        int n8 = n4 = pgPolygonSet.getNumVertices();
        PdVector[] pdVectorArray2 = new PdVector[2];
        PdVector pdVector2 = new PdVector(n5);
        for (n3 = 0; n3 < n7; ++n3) {
            int n9;
            int n10;
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = pgPolygonSet.isClosed(n3);
            n = piVector.getSize();
            if (n < 2 || n2 != 0 && n < 3) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
                continue;
            }
            if (n2 != 0) {
                piVectorArray[n3] = new PiVector(2 * n - 1);
                for (int i = 0; i < n - 1; ++i) {
                    piVectorArray[n3].m_data[2 * i] = n8++;
                    piVectorArray[n3].m_data[2 * i + 1] = n8++;
                    pdVectorArray2[0] = PdVector.blendNew((double)pdVector.m_data[n6 - 1], (PdVector)pdVectorArray[piVector.m_data[i]], (double)pdVector.m_data[n6], (PdVector)pdVectorArray[piVector.m_data[(i + 1) % n]]);
                    pdVectorArray2[1] = PdVector.blendNew((double)pdVector.m_data[n6], (PdVector)pdVectorArray[piVector.m_data[i]], (double)pdVector.m_data[n6 - 1], (PdVector)pdVectorArray[piVector.m_data[(i + 1) % n]]);
                    n10 = i;
                    while (n10 - n6 + 1 < 0) {
                        n10 += n;
                    }
                    for (int j = 1; j < n6; ++j) {
                        pdVectorArray2[0].blendBase(pdVectorArray2[0], pdVector.m_data[n6 - 1 - j], pdVectorArray[piVector.m_data[(n10 - j) % n]]);
                        pdVectorArray2[0].blendBase(pdVectorArray2[0], pdVector.m_data[n6 + j], pdVectorArray[piVector.m_data[(n10 + 1 + j) % n]]);
                        pdVectorArray2[1].blendBase(pdVectorArray2[1], pdVector.m_data[n6 - 1 - j], pdVectorArray[piVector.m_data[(n10 + 1 + j) % n]]);
                        pdVectorArray2[1].blendBase(pdVectorArray2[1], pdVector.m_data[n6 + j], pdVectorArray[piVector.m_data[(n10 - j) % n]]);
                    }
                    vector.addElement(pdVectorArray2[0]);
                    vector.addElement(pdVectorArray2[1]);
                }
                piVectorArray[n3].m_data[2 * n - 2] = piVectorArray[n3].m_data[0];
            } else if (n == 2) {
                piVectorArray[n3] = PiVector.copyNew((PiVector)piVector);
            } else {
                piVectorArray[n3] = new PiVector(2 * n - 2);
                int[] nArray = new int[n5];
                for (n10 = 0; n10 < n - 1; ++n10) {
                    for (int i = 0; i < 2; ++i) {
                        piVectorArray[n3].m_data[2 * n10 + i] = n8;
                        if (n10 == 0 && i == 0) {
                            pdVectorArray2[0] = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[0]]);
                        } else if (n10 == n - 2 && i == 1) {
                            pdVectorArray2[1] = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[n - 1]]);
                        } else {
                            int n11;
                            pdVector2.copy(pdVector);
                            if (i == 1) {
                                pdVector2.invert(n5);
                            }
                            int n12 = -1;
                            n9 = -1;
                            for (n11 = 0; n11 < n6; ++n11) {
                                nArray[n11] = n10 - n6 + 1 + n11;
                                if (nArray[n11] == 0) {
                                    n12 = n11;
                                }
                                nArray[n6 + n11] = n10 + n11 + 1;
                                if (nArray[n6 + n11] != n - 1) continue;
                                n9 = n6 + n11;
                            }
                            for (n11 = 0; n11 < n6; ++n11) {
                                if (nArray[n11] < 1) {
                                    int n13 = n12 + 1 - nArray[n11];
                                    pdVector2.m_data[n13] = pdVector2.m_data[n13] - pdVector2.m_data[n11];
                                    nArray[n11] = 0;
                                    int n14 = n11;
                                    pdVector2.m_data[n14] = pdVector2.m_data[n14] * 2.0;
                                }
                                if (nArray[n5 - 1 - n11] <= n - 2) continue;
                                int n15 = n9 - 1 - (nArray[n5 - 1 - n11] - (n - 1));
                                pdVector2.m_data[n15] = pdVector2.m_data[n15] - pdVector2.m_data[n5 - 1 - n11];
                                nArray[n5 - 1 - n11] = n - 1;
                                int n16 = n5 - 1 - n11;
                                pdVector2.m_data[n16] = pdVector2.m_data[n16] * 2.0;
                            }
                            pdVectorArray2[i] = PdVector.blendNew((double)pdVector2.m_data[n6 - 1], (PdVector)pdVectorArray[piVector.m_data[n10]], (double)pdVector2.m_data[n6], (PdVector)pdVectorArray[piVector.m_data[(n10 + 1) % n]]);
                            for (n11 = 0; n11 < n6 - 1; ++n11) {
                                pdVectorArray2[i].blendBase(pdVectorArray2[i], pdVector2.m_data[n11], pdVectorArray[piVector.m_data[nArray[n11]]]);
                                pdVectorArray2[i].blendBase(pdVectorArray2[i], pdVector2.m_data[n5 - 1 - n11], pdVectorArray[piVector.m_data[nArray[n5 - 1 - n11]]]);
                            }
                        }
                        vector.addElement(pdVectorArray2[i]);
                    }
                }
            }
            if (bl) {
                double d = 0.25;
                double d2 = 1.0 - d;
                if (n2 != 0) {
                    for (n9 = 0; n9 < n - 1; ++n9) {
                        vector2.addElement(PdVector.blendNew((double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9]), (double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[(n9 + 1) % n])));
                        vector2.addElement(PdVector.blendNew((double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9]), (double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[(n9 + 1) % n])));
                    }
                } else if (n != 2) {
                    for (n9 = 1; n9 < n - 2; ++n9) {
                        vector2.addElement(PdVector.blendNew((double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9]), (double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9 + 1])));
                        vector2.addElement(PdVector.blendNew((double)d, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9]), (double)d2, (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n9 + 1])));
                    }
                    vector2.addElement(PdVector.blendNew((double)(2.0 * d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[0]), (double)(d2 - d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[1])));
                    vector2.addElement(PdVector.blendNew((double)(d2 - d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n - 2]), (double)(2.0 * d), (PdVector)pgPolygonSet.getVertexNormal(piVector.m_data[n - 1])));
                }
            }
            if (!pgPolygonSet.hasVertexColors()) continue;
            pgPolygonSet.setNumVertices(n8);
            Color[] colorArray = pgPolygonSet.getVertexColors();
            for (n10 = 0; n10 < n - 1; ++n10) {
                colorArray[piVectorArray[n3].m_data[2 * n10]] = colorArray[piVector.m_data[n10]];
                colorArray[piVectorArray[n3].m_data[2 * n10 + 1]] = colorArray[piVector.m_data[n10 + 1]];
            }
            if (n2 == 0) continue;
            colorArray[piVectorArray[n3].m_data[2 * n - 2]] = colorArray[piVectorArray[n3].m_data[0]];
        }
        pgPolygonSet.setNumVertices(n8);
        for (n3 = n4; n3 < n8; ++n3) {
            pgPolygonSet.setVertex(n3, (PdVector)vector.elementAt(n3 - n4));
        }
        if (bl) {
            for (n3 = n4; n3 < n8; ++n3) {
                ((PdVector)vector2.elementAt(n3 - n4)).normalize();
                pgPolygonSet.setVertexNormal(n3, (PdVector)vector2.elementAt(n3 - n4));
            }
        }
        for (n3 = 0; n3 < n7; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.setTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.setPolygons(piVectorArray);
        for (n3 = 0; n3 < n7; ++n3) {
            piVector = pgPolygonSet.getPolygon(n3);
            n2 = piVector.getSize();
            for (n = 0; n < n2; ++n) {
                pgPolygonSet.clearTagVertex(piVector.m_data[n], 2);
            }
        }
        pgPolygonSet.removeMarkedVertices();
    }

    public static void coarsenDFH(PgPolygonSet pgPolygonSet) {
        PwRefinePolygon.coarsenChaikin(pgPolygonSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

