/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.Random;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;
import jvx.project.PjWorkshop;

public class PwNoise
extends PjWorkshop {
    protected PgPointSet m_pointSet;
    protected PgElementSet m_elemSet;
    protected PdVector[] m_vertices;
    protected PdVector[] m_normals;
    protected PdVector[] m_noise;
    protected boolean[] m_bNoise;
    protected PuInteger m_frequency = new PuInteger(PsConfig.getMessage((int)54311), (PsUpdateIf)this);
    protected PuDouble m_eps = new PuDouble(PsConfig.getMessage((int)54133), (PsUpdateIf)this);
    protected boolean m_bKeepBoundary;
    protected boolean m_bKeepSelected;
    protected boolean m_bTangential;
    protected boolean m_bNormal;
    protected boolean m_bUpdateNormals;
    protected boolean m_bHasElementNormals;
    protected boolean m_bHasVertexNormals;
    static /* synthetic */ Class class$jvx$geom$PwNoise;

    public PwNoise() {
        super(PsConfig.getMessage((int)54128));
        this.m_eps.setDefValue(0.0);
        this.m_eps.setDefBounds(0.0, 1.0, 0.001, 0.01);
        this.m_eps.init();
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwNoise == null ? (class$jvx$geom$PwNoise = PwNoise.class$("jvx.geom.PwNoise")) : class$jvx$geom$PwNoise)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bKeepBoundary = false;
        this.m_bKeepSelected = false;
        this.m_bTangential = false;
        this.m_bNormal = true;
        this.m_bUpdateNormals = true;
        this.m_bHasElementNormals = false;
        this.m_bHasVertexNormals = false;
        this.m_frequency.setDefBounds(1, 10, 1, 2);
        this.m_frequency.setDefValue(1);
        this.m_frequency.init();
    }

    public void reset() {
        super.reset();
        if (this.m_pointSet != null) {
            double d = this.m_pointSet.getDiameter();
            this.m_eps.setDefValue(0.0);
            this.m_eps.setDefBounds(0.0, d / 5.0, d / 1000.0, d / 100.0);
            this.m_eps.init();
            this.m_bHasVertexNormals = this.m_pointSet.hasVertexNormals();
            if (!this.m_bHasVertexNormals) {
                this.m_normals = null;
                this.m_bNormal = true;
                this.m_bTangential = true;
            }
        }
        this.m_bHasElementNormals = this.m_elemSet != null ? this.m_elemSet.hasElementNormals() : false;
        if (!this.m_bHasElementNormals && !this.m_bHasVertexNormals) {
            this.m_bUpdateNormals = false;
        }
        if (this.m_pointSet != null) {
            this.newNoise();
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning((String)"workshop requires instance of PgPointSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_pointSet = (PgPointSet)pgGeometry;
        this.m_pointSet.addUpdateListener((PsUpdateIf)this);
        int n = this.m_pointSet.getNumVertices();
        int n2 = this.m_pointSet.getDimOfVertices();
        this.m_vertices = PdVector.realloc((PdVector[])this.m_vertices, (int)n, (int)n2);
        PdVector.copy((PdVector[])this.m_vertices, (int)0, (PdVector[])this.m_pointSet.getVertices(), (int)0, (int)n);
        this.m_bHasVertexNormals = this.m_pointSet.hasVertexNormals();
        if (this.m_bHasVertexNormals) {
            this.m_normals = PdVector.realloc((PdVector[])this.m_normals, (int)n, (int)n2);
            PdVector.copy((PdVector[])this.m_normals, (int)0, (PdVector[])this.m_pointSet.getVertexNormals(), (int)0, (int)n);
        } else {
            this.m_normals = null;
            this.m_bNormal = true;
            this.m_bTangential = true;
        }
        this.m_noise = PdVector.realloc((PdVector[])this.m_noise, (int)n, (int)n2);
        this.m_bNoise = PuData.realloc((boolean[])this.m_bNoise, (int)n, (boolean)true);
        if (pgGeometry instanceof PgElementSet) {
            this.m_elemSet = (PgElementSet)pgGeometry;
            this.m_elemSet.markBoundary();
        } else {
            this.m_elemSet = null;
        }
        this.reset();
    }

    public void setAmplitude(double d) {
        this.m_eps.setValue(d);
    }

    public double getAmplitude() {
        return this.m_eps.getValue();
    }

    public boolean isEnabledKeepBoundary() {
        return this.m_bKeepBoundary;
    }

    public void setEnabledKeepBoundary(boolean bl) {
        this.m_bKeepBoundary = bl;
    }

    public boolean isEnabledKeepSelected() {
        return this.m_bKeepSelected;
    }

    public void setEnabledKeepSelected(boolean bl) {
        this.m_bKeepSelected = bl;
    }

    public boolean isEnabledNoiseTangential() {
        return this.m_bTangential;
    }

    public void setEnabledNoiseTangential(boolean bl) {
        this.m_bTangential = bl;
    }

    public boolean isEnabledNoiseNormal() {
        return this.m_bNormal;
    }

    public void setEnabledNoiseNormal(boolean bl) {
        this.m_bNormal = bl;
    }

    public boolean isEnabledUpdateNormals() {
        return this.m_bUpdateNormals;
    }

    public void setEnabledUpdateNormals(boolean bl) {
        this.m_bUpdateNormals = bl;
    }

    public void keepBoundary(boolean bl) {
        this.m_bKeepBoundary = bl;
    }

    public void keepSelected(boolean bl) {
        this.m_bKeepSelected = bl;
    }

    public void noiseTangential(boolean bl) {
        this.m_bTangential = bl;
    }

    public void noiseNormal(boolean bl) {
        this.m_bNormal = bl;
    }

    public void updateNormals(boolean bl) {
        this.m_bUpdateNormals = bl;
    }

    public boolean update(Object object) {
        if (object == this.m_pointSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry((PgGeometry)this.m_pointSet);
            this.noise();
            return super.update((Object)this);
        }
        if (object == this.m_frequency) {
            this.newFrequence();
            this.noise();
            return super.update((Object)this);
        }
        if (object == this.m_eps) {
            this.noise();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void close() {
        if (this.m_pointSet != null) {
            this.m_pointSet.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_pointSet = null;
        this.m_elemSet = null;
        this.m_noise = null;
        this.m_normals = null;
        this.m_vertices = null;
    }

    public void newFrequence() {
        int n;
        int n2;
        int n3 = this.m_pointSet.getNumVertices();
        if (n3 <= (n2 = n3 / this.m_frequency.getValue())) {
            for (int i = 0; i < n3; ++i) {
                this.m_bNoise[i] = true;
            }
            return;
        }
        Random random = new Random();
        for (n = 0; n < n3; ++n) {
            this.m_bNoise[n] = false;
        }
        for (n = 0; n < n2; ++n) {
            int n4 = Math.abs(random.nextInt()) % n3;
            while (this.m_bNoise[n4]) {
                n4 = Math.abs(random.nextInt()) % n3;
            }
            this.m_bNoise[n4] = true;
        }
    }

    public void newNoise() {
        int n = this.m_pointSet.getNumVertices();
        int n2 = this.m_pointSet.getDimOfVertices();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_noise[i].m_data[j] = (Math.random() - 0.5) * 2.0;
            }
        }
    }

    public void noise(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    public void noise() {
        double d = this.m_eps.getValue();
        int n = this.m_pointSet.getDimOfVertices();
        PdVector pdVector = new PdVector(n);
        PdVector pdVector2 = new PdVector(n);
        boolean bl = this.m_bNormal && this.m_bTangential;
        int n2 = this.m_pointSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_pointSet.getVertices();
        for (int i = 0; i < n2; ++i) {
            PdVector pdVector3;
            if (this.m_bNoise[i]) {
                if (this.m_bKeepBoundary && this.m_pointSet.hasTagVertex(i, 14) || this.m_bKeepSelected && this.m_pointSet.hasTagVertex(i, 1) || this.m_pointSet.hasTagVertex(i, 3)) {
                    pdVector3 = this.m_vertices[i];
                } else if (bl || this.m_bNormal || this.m_bTangential) {
                    double d2;
                    if (bl) {
                        pdVector2.copyArray(this.m_noise[i]);
                    } else if (this.m_bNormal) {
                        d2 = PdVector.dot((PdVector)this.m_normals[i], (PdVector)this.m_noise[i]);
                        pdVector2.multScalar(this.m_normals[i], d2);
                    } else if (this.m_bTangential) {
                        d2 = PdVector.dot((PdVector)this.m_normals[i], (PdVector)this.m_noise[i]);
                        pdVector2.blendBase(this.m_noise[i], -d2, this.m_normals[i]);
                    }
                    pdVector.blendBase(this.m_vertices[i], d, pdVector2);
                    pdVector3 = pdVector;
                } else {
                    pdVector3 = this.m_vertices[i];
                }
            } else {
                pdVector3 = this.m_vertices[i];
            }
            pdVectorArray[i].copyArray(pdVector3);
        }
        if (this.m_bUpdateNormals && this.m_bHasVertexNormals) {
            this.m_pointSet.makeVertexNormals();
        }
        if (this.m_bUpdateNormals && this.m_bHasElementNormals && this.m_elemSet != null) {
            this.m_elemSet.makeElementNormals();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

