/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;

public class PwModel
extends PjWorkshop {
    public static final int SHRINK = 0;
    public static final int TRUNCATE = 1;
    public static final int STELLATE = 2;
    public static final int TRUNCATEFILL = 3;
    public static final int PUNCH = 4;
    public static final int EXTRUDE = 5;
    public static final int EXTRUDE_SYMMETRIC = 6;
    public static final int RHOMBIFICATE = 7;
    protected PgElementSet m_elementSet;
    protected PuDouble m_parameter = new PuDouble(PsConfig.getMessage((int)54120), (PsUpdateIf)this);
    protected int m_modelingType;
    protected double m_parameterTrunc;
    protected double m_parameterShrink;
    protected double m_parameterStellate;
    protected double m_parameterPunch;
    protected double m_parameterExtrude;
    protected double m_parameterExtrudeSymm;
    protected double m_parameterRhombificate;
    protected double m_truncParamLowerBound;
    protected double m_truncParamUpperBound;
    protected double m_shrinkParamLowerBound;
    protected double m_shrinkParamUpperBound;
    protected double m_stellateParamLowerBound;
    protected double m_stellateParamUpperBound;
    protected double m_punchParamLowerBound;
    protected double m_punchParamUpperBound;
    protected double m_extrudeParamLowerBound;
    protected double m_extrudeParamUpperBound;
    protected double m_extrudeSymmParamLowerBound;
    protected double m_extrudeSymmParamUpperBound;
    protected double m_rhombificateParamLowerBound;
    protected double m_rhombificateParamUpperBound;
    private boolean m_bApplyModeling = true;
    private static final boolean m_bExtrudePlanar = false;
    static /* synthetic */ Class class$jvx$geom$PwModel;

    public PwModel(PgElementSet pgElementSet) {
        this();
        this.setGeometry((PgGeometry)pgElementSet);
        this.reset();
    }

    public PwModel() {
        super(PsConfig.getMessage((int)51068));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwModel == null ? (class$jvx$geom$PwModel = PwModel.class$("jvx.geom.PwModel")) : class$jvx$geom$PwModel)) {
            this.init();
        }
    }

    public void init() {
        this.m_modelingType = 0;
        this.m_parameterTrunc = 0.3;
        this.m_parameterShrink = 0.9;
        this.m_parameterStellate = 1.0;
        this.m_parameterPunch = 0.6;
        this.m_parameterExtrude = 1.0;
        this.m_parameterExtrudeSymm = 1.0;
        this.m_parameterRhombificate = 0.5;
        this.m_truncParamLowerBound = 0.01;
        this.m_truncParamUpperBound = 0.49;
        this.m_shrinkParamLowerBound = 0.0;
        this.m_shrinkParamUpperBound = 1.0;
        this.m_stellateParamLowerBound = -3.0;
        this.m_stellateParamUpperBound = 3.0;
        this.m_punchParamLowerBound = 0.0;
        this.m_punchParamUpperBound = 1.0;
        this.m_extrudeParamLowerBound = 0.0;
        this.m_extrudeParamUpperBound = 1.0;
        this.m_extrudeSymmParamLowerBound = 0.0;
        this.m_extrudeSymmParamUpperBound = 1.0;
        this.m_rhombificateParamLowerBound = 0.01;
        this.m_rhombificateParamUpperBound = 0.99;
        this.m_parameter.setDefBounds(this.m_shrinkParamLowerBound, this.m_shrinkParamUpperBound, 0.01, 0.05);
        this.m_parameter.setDefValue(this.m_parameterShrink);
        this.m_parameter.init();
    }

    public void reset() {
        super.reset();
        this.setModelingType(this.m_modelingType);
        this.compute();
        this.update(null);
    }

    public boolean update(Object object) {
        if (object == this.m_elementSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            this.setGeometry((PgGeometry)this.m_elementSet);
            this.compute();
            this.update(null);
            return true;
        }
        if (object == this.m_parameter) {
            this.m_elementSet.copy((PsObject)this.m_geomSave);
            if (this.m_modelingType == 3) {
                this.m_parameterTrunc = this.m_parameter.getValue();
            } else if (this.m_modelingType == 1) {
                this.m_parameterTrunc = this.m_parameter.getValue();
            } else if (this.m_modelingType == 0) {
                this.m_parameterShrink = this.m_parameter.getValue();
            } else if (this.m_modelingType == 2) {
                this.m_parameterStellate = this.m_parameter.getValue();
            } else if (this.m_modelingType == 4) {
                this.m_parameterPunch = this.m_parameter.getValue();
            } else if (this.m_modelingType == 5) {
                this.m_parameterExtrude = this.m_parameter.getValue();
            } else if (this.m_modelingType == 6) {
                this.m_parameterExtrudeSymm = this.m_parameter.getValue();
            } else if (this.m_modelingType == 7) {
                this.m_parameterRhombificate = this.m_parameter.getValue();
            }
            this.compute();
            this.update(null);
            return true;
        }
        return super.update(object);
    }

    public boolean compute() {
        if (this.m_elementSet == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        this.m_elementSet.copy((PsObject)this.m_geomSave);
        if (!this.m_bApplyModeling) {
            return true;
        }
        if (this.m_modelingType == 3) {
            PwModel.truncate(this.m_elementSet, this.m_parameterTrunc, true);
        } else if (this.m_modelingType == 1) {
            PwModel.truncate(this.m_elementSet, this.m_parameterTrunc, false);
        } else if (this.m_modelingType == 0) {
            PwModel.shrink(this.m_elementSet, this.m_parameterShrink);
        } else if (this.m_modelingType == 2) {
            PwModel.stellate(this.m_elementSet, this.m_parameterStellate);
        } else if (this.m_modelingType == 4) {
            PwModel.punch(this.m_elementSet, this.m_parameterPunch);
        } else if (this.m_modelingType == 5) {
            PwModel.extrude(this.m_elementSet, this.m_parameterExtrude, false);
        } else if (this.m_modelingType == 6) {
            PwModel.extrude(this.m_elementSet, this.m_parameterExtrudeSymm, true);
        } else if (this.m_modelingType == 7) {
            PwModel.rhombificate(this.m_elementSet, this.m_parameterRhombificate);
        }
        return true;
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_elementSet = (PgElementSet)pgGeometry;
    }

    public void setElementSet(PgElementSet pgElementSet) {
        this.setGeometry((PgGeometry)pgElementSet);
    }

    public int getModelingType() {
        return this.m_modelingType;
    }

    public void setModelingType(int n) {
        if (this.m_modelingType == 3) {
            this.m_truncParamUpperBound = this.m_parameter.getMax();
            this.m_truncParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 1) {
            this.m_truncParamUpperBound = this.m_parameter.getMax();
            this.m_truncParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 0) {
            this.m_shrinkParamUpperBound = this.m_parameter.getMax();
            this.m_shrinkParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 2) {
            this.m_stellateParamUpperBound = this.m_parameter.getMax();
            this.m_stellateParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 4) {
            this.m_punchParamUpperBound = this.m_parameter.getMax();
            this.m_punchParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 5) {
            this.m_extrudeParamUpperBound = this.m_parameter.getMax();
            this.m_extrudeParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 6) {
            this.m_extrudeSymmParamUpperBound = this.m_parameter.getMax();
            this.m_extrudeSymmParamLowerBound = this.m_parameter.getMin();
        } else if (this.m_modelingType == 7) {
            this.m_rhombificateParamUpperBound = this.m_parameter.getMax();
            this.m_rhombificateParamLowerBound = this.m_parameter.getMin();
        }
        if (n == 3) {
            this.m_parameter.setBounds(this.m_truncParamLowerBound, this.m_truncParamUpperBound);
            this.m_parameter.setValue(this.m_parameterTrunc);
        } else if (n == 1) {
            this.m_parameter.setBounds(this.m_truncParamLowerBound, this.m_truncParamUpperBound);
            this.m_parameter.setValue(this.m_parameterTrunc);
        } else if (n == 0) {
            this.m_parameter.setBounds(this.m_shrinkParamLowerBound, this.m_shrinkParamUpperBound);
            this.m_parameter.setValue(this.m_parameterShrink);
        } else if (n == 2) {
            this.m_parameter.setBounds(this.m_stellateParamLowerBound, this.m_stellateParamUpperBound);
            this.m_parameter.setValue(this.m_parameterStellate);
        } else if (n == 4) {
            this.m_parameter.setBounds(this.m_punchParamLowerBound, this.m_punchParamUpperBound);
            this.m_parameter.setValue(this.m_parameterPunch);
        } else if (n == 5) {
            this.m_parameter.setBounds(this.m_extrudeParamLowerBound, this.m_extrudeParamUpperBound);
            this.m_parameter.setValue(this.m_parameterExtrude);
        } else if (n == 6) {
            this.m_parameter.setBounds(this.m_extrudeSymmParamLowerBound, this.m_extrudeSymmParamUpperBound);
            this.m_parameter.setValue(this.m_parameterExtrudeSymm);
        } else if (n == 7) {
            this.m_parameter.setBounds(this.m_rhombificateParamLowerBound, this.m_rhombificateParamUpperBound);
            this.m_parameter.setValue(this.m_parameterRhombificate);
        }
        this.m_modelingType = n;
    }

    public void setEnabledModeling(boolean bl) {
        this.m_bApplyModeling = bl;
    }

    public boolean isEnabledModeling() {
        return this.m_bApplyModeling;
    }

    public static void shrink(PgElementSet pgElementSet, double d) {
        int n;
        int n2;
        int n3;
        PdVector pdVector;
        PdVector[][] pdVectorArrayArray;
        PdVector[][] pdVectorArray;
        int n4;
        int n5;
        int n6;
        int n7 = pgElementSet.getNumVertices();
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfVertices());
        double d2 = 1.0 - d;
        PiVector piVector = new PiVector(pgElementSet.getNumVertices());
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n8 = pgElementSet.getNumElements();
        boolean bl = pgElementSet.hasVertexColors();
        int n9 = n6 = pgElementSet.getNumUnusedVertices();
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = piVectorArray[n5].getSize();
            for (int i = 0; i < n4; ++i) {
                ++n9;
                int n10 = piVectorArray[n5].m_data[i];
                piVector.m_data[n10] = piVector.m_data[n10] + 1;
            }
        }
        pgElementSet.setNumVertices(n9);
        if (pgElementSet.hasElementTextures()) {
            double d3;
            double d4;
            if (d > 1.0) {
                d4 = 1.0;
                d3 = 0.0;
            } else {
                d4 = d;
                d3 = d2;
            }
            pdVectorArray = pgElementSet.getElementTextures();
            pdVectorArrayArray = new PdVector[pgElementSet.getNumElements()][];
            pdVector = new PdVector(pgElementSet.getDimOfTextures());
            for (n3 = 0; n3 < n8; ++n3) {
                pdVector.copy(pdVectorArray[n3][0]);
                int n11 = piVectorArray[n3].getSize();
                for (n2 = 1; n2 < n11; ++n2) {
                    pdVector.add(pdVectorArray[n3][n2]);
                }
                pdVector.multScalar(1.0 / (double)n11);
                pdVectorArrayArray[n3] = new PdVector[n11];
                for (n2 = 0; n2 < n11; ++n2) {
                    pdVectorArrayArray[n3][n2] = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[n3][n2], (double)d3, (PdVector)pdVector);
                }
            }
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        }
        if (pgElementSet.hasVertexTextures()) {
            double d5;
            double d6;
            if (d > 1.0) {
                d6 = 1.0;
                d5 = 0.0;
            } else {
                d6 = d;
                d5 = d2;
            }
            pdVectorArray = pgElementSet.getVertexTextures();
            pdVectorArrayArray = new PdVector[n9];
            pdVector = new PdVector(pgElementSet.getDimOfTextures());
            n3 = n7;
            PiVector piVector2 = PiVector.copyNew((PiVector)piVector);
            for (n2 = 0; n2 < n8; ++n2) {
                PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pdVectorArray, (int[])piVectorArray[n2].m_data);
                n = piVectorArray[n2].getSize();
                for (int i = 0; i < n; ++i) {
                    int n12 = piVectorArray[n2].m_data[i];
                    if (piVector2.m_data[n12] > 1) {
                        int n13 = n12;
                        piVector2.m_data[n13] = piVector2.m_data[n13] - 1;
                        pdVectorArrayArray[n3] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray[n12], (double)d5, (PdVector)pdVector);
                        ++n3;
                        continue;
                    }
                    pdVectorArrayArray[n12] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray[n12], (double)d5, (PdVector)pdVector);
                }
            }
            pgElementSet.setVertexTextures((PdVector[])pdVectorArrayArray);
        }
        n5 = pgElementSet.getNumVectorFields();
        for (n4 = 0; n4 < n5; ++n4) {
            if (pgElementSet.getVectorField(n4).getBasedOn() != 0) continue;
            PgVectorField pgVectorField = pgElementSet.getVectorField(n4);
            PdVector[] pdVectorArray2 = pgVectorField.getVectors();
            pdVectorArray = new PdVector[n9];
            int n14 = n7;
            pdVector = PiVector.copyNew((PiVector)piVector);
            for (n3 = 0; n3 < n8; ++n3) {
                int n15 = piVectorArray[n3].getSize();
                for (n2 = 0; n2 < n15; ++n2) {
                    n = piVectorArray[n3].m_data[n2];
                    if (pdVector.m_data[n] > 1) {
                        int n16 = n;
                        pdVector.m_data[n16] = pdVector.m_data[n16] - 1;
                        pdVectorArray[n14] = PdVector.copyNew((PdVector)pdVectorArray2[n]);
                        ++n14;
                        continue;
                    }
                    pdVectorArray[n] = PdVector.copyNew((PdVector)pdVectorArray2[n]);
                }
            }
            pgVectorField.setNumVectors(n9);
            pgVectorField.setVectors((PdVector[])pdVectorArray);
        }
        for (n4 = 0; n4 < n8; ++n4) {
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgElementSet.getVertices(), (int[])piVectorArray[n4].m_data);
            int n17 = piVectorArray[n4].getSize();
            for (int i = 0; i < n17; ++i) {
                int n18 = piVectorArray[n4].m_data[i];
                if (piVector.m_data[n18] > 1) {
                    int n19 = n18;
                    piVector.m_data[n19] = piVector.m_data[n19] - 1;
                    pgElementSet.getVertex(n7).blend(d, pgElementSet.getVertex(n18), d2, pdVector2);
                    if (bl) {
                        pgElementSet.setVertexColor(n7, pgElementSet.getVertexColor(n18));
                    }
                    piVectorArray[n4].m_data[i] = n7++;
                    continue;
                }
                pgElementSet.getVertex(n18).blend(d, pgElementSet.getVertex(n18), d2, pdVector2);
            }
        }
        if (pgElementSet.hasBoundary()) {
            pgElementSet.removeBoundaries();
        }
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
        pgElementSet.makeNeighbour();
    }

    public static void stellate(PgElementSet pgElementSet, double d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PdVector[] pdVectorArray;
        int n8;
        int n9 = 0;
        int n10 = pgElementSet.getNumElements();
        int n11 = n8 = pgElementSet.getNumVertices();
        int n12 = 0;
        PiVector[] piVectorArray = new PiVector[n10];
        for (int i = 0; i < n10; ++i) {
            piVectorArray[i] = PiVector.copyNew((PiVector)pgElementSet.getElement(i));
        }
        boolean bl = pgElementSet.hasElementNormals();
        if (!bl) {
            bl = pgElementSet.makeElementNormals();
        }
        PdVector[] pdVectorArray2 = pgElementSet.getElementNormals();
        int n13 = n10 + n8;
        pgElementSet.setNumVertices(n13);
        if (pgElementSet.hasVertexTextures()) {
            PdVector[] pdVectorArray3 = pgElementSet.getVertexTextures();
            pdVectorArray = new PdVector[n13];
            for (n7 = 0; n7 < n8; ++n7) {
                pdVectorArray[n7] = pdVectorArray3[n7];
            }
            for (n7 = 0; n7 < n10; ++n7) {
                pdVectorArray[n8 + n7] = PdVector.copyNew((PdVector)pdVectorArray3[piVectorArray[n7].m_data[0]]);
                int n14 = piVectorArray[n7].getSize();
                for (n6 = 1; n6 < n14; ++n6) {
                    pdVectorArray[n8 + n7].add(pdVectorArray3[piVectorArray[n7].m_data[n6]]);
                }
                pdVectorArray[n8 + n7].multScalar(1.0 / (double)n14);
            }
            pgElementSet.setVertexTextures(pdVectorArray);
        }
        for (n5 = 0; n5 < n10; ++n5) {
            n9 += piVectorArray[n5].m_data.length;
        }
        n5 = pgElementSet.getNumVectorFields();
        pdVectorArray = new PdVector[n5][];
        for (n7 = 0; n7 < n5; ++n7) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n7);
            if (pgVectorField.getBasedOn() == 1) {
                pdVectorArray[n7] = PdVector.copyNew((PdVector[])pgVectorField.getVectors(), (int)n10);
                pgVectorField.setNumVectors(n9);
                continue;
            }
            pgVectorField.setNumVectors(n13);
        }
        n7 = pgElementSet.hasVertexColors() ? 1 : 0;
        PiVector[] piVectorArray2 = new PiVector[n9];
        for (n6 = 0; n6 < n10; ++n6) {
            PdVector pdVector = pgElementSet.getVertex(n11);
            PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pgElementSet.getVertices(), (int[])piVectorArray[n6].m_data);
            if (bl) {
                pdVector.blendBase(pdVector, d, pdVectorArray2[n6]);
            }
            int n15 = piVectorArray[n6].m_data.length;
            for (n4 = 0; n4 < n15; ++n4) {
                piVectorArray2[n12] = new PiVector(3);
                piVectorArray2[n12].m_data[0] = n11;
                piVectorArray2[n12].m_data[1] = piVectorArray[n6].m_data[n4];
                piVectorArray2[n12].m_data[2] = piVectorArray[n6].m_data[(n4 + 1) % n15];
                ++n12;
            }
            if (n7 != 0) {
                n4 = 0;
                n3 = 0;
                n2 = 0;
                for (n = 0; n < n15; ++n) {
                    n4 += pgElementSet.getVertexColor(piVectorArray[n6].m_data[n]).getRed();
                    n3 += pgElementSet.getVertexColor(piVectorArray[n6].m_data[n]).getGreen();
                    n2 += pgElementSet.getVertexColor(piVectorArray[n6].m_data[n]).getBlue();
                }
                pgElementSet.setVertexColor(n11, new Color(n4 /= n15, n3 /= n15, n2 /= n15));
            }
            for (n4 = 0; n4 < n5; ++n4) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n4);
                if (pgVectorField.getBasedOn() != 0) continue;
                PdVector pdVector2 = PdVector.copyNew((PdVector)pgVectorField.getVector(piVectorArray[n6].m_data[0]));
                for (n = 1; n < n15; ++n) {
                    pdVector2.add(pgVectorField.getVector(piVectorArray[n6].m_data[n]));
                }
                pdVector2.multScalar(1.0 / (double)n15);
                pgVectorField.setVector(n11, pdVector2);
            }
            ++n11;
        }
        if (pgElementSet.hasElementTextures()) {
            PdVector[][] pdVectorArray4 = pgElementSet.getElementTextures();
            PdVector[][] pdVectorArrayArray = new PdVector[n9][];
            n4 = 0;
            n2 = pgElementSet.getDimOfTextures();
            for (n = 0; n < n10; ++n) {
                int n16;
                PdVector pdVector = new PdVector(n2);
                pdVector.copy(pdVectorArray4[n][0]);
                int n17 = pdVectorArray4[n].length;
                for (n16 = 1; n16 < n17; ++n16) {
                    pdVector.add(pdVectorArray4[n][n16]);
                }
                pdVector.multScalar(1.0 / (double)n17);
                for (n16 = 0; n16 < n17; ++n16) {
                    pdVectorArrayArray[n4] = new PdVector[3];
                    pdVectorArrayArray[n4][0] = new PdVector(n2);
                    pdVectorArrayArray[n4][0].copy(pdVector);
                    pdVectorArrayArray[n4][1] = new PdVector(n2);
                    pdVectorArrayArray[n4][1].copy(pdVectorArray4[n][n16]);
                    pdVectorArrayArray[n4][2] = new PdVector(n2);
                    pdVectorArrayArray[n4][2].copy(pdVectorArray4[n][(n16 + 1) % n17]);
                    ++n4;
                }
            }
            pgElementSet.setNumElements(n9);
            pgElementSet.setDimOfElements(3);
            for (n = 0; n < n9; ++n) {
                pgElementSet.setElement(n, piVectorArray2[n]);
            }
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        } else {
            pgElementSet.setNumElements(n9);
            pgElementSet.setDimOfElements(3);
            for (n6 = 0; n6 < n9; ++n6) {
                pgElementSet.setElement(n6, piVectorArray2[n6]);
            }
        }
        int n18 = n9 - 1;
        if (pgElementSet.hasElementColors()) {
            for (int i = n10 - 1; i >= 0; --i) {
                n4 = piVectorArray[i].getSize();
                for (n3 = n4 - 1; n3 >= 0; --n3) {
                    pgElementSet.setElementColor(n18, pgElementSet.getElementColor(i));
                    --n18;
                }
            }
        }
        n18 = n9 - 1;
        if (pgElementSet.hasElementBackColors()) {
            for (int i = n10 - 1; i >= 0; --i) {
                n4 = piVectorArray[i].getSize();
                for (n3 = n4 - 1; n3 >= 0; --n3) {
                    pgElementSet.setElementBackColor(n18, pgElementSet.getElementBackColor(i));
                    --n18;
                }
            }
        }
        for (int i = 0; i < n5; ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() != 1) continue;
            n18 = n9 - 1;
            for (n3 = n10 - 1; n3 >= 0; --n3) {
                n2 = piVectorArray[n3].getSize();
                for (n = n2 - 1; n >= 0; --n) {
                    pgVectorField.setVector(n18, pdVectorArray[i][n3]);
                    --n18;
                }
            }
        }
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n19 = pgBndPolygonArray.length;
            for (n3 = 0; n3 < n19; ++n3) {
                if (pgBndPolygonArray[n3].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
    }

    public static void truncate(PgElementSet pgElementSet, double d, boolean bl) {
        int n;
        PgBndPolygon pgBndPolygon;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        PdVector[][] pdVectorArray;
        int n17;
        PgVertexStar pgVertexStar = new PgVertexStar();
        double d2 = 1.0 - d;
        int n18 = 0;
        n18 = pgElementSet.getNumUnusedVertices();
        int n19 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        boolean bl2 = pgElementSet.hasVertexColors();
        boolean bl3 = pgElementSet.hasVertexTextures();
        boolean bl4 = pgElementSet.hasElementTextures();
        boolean bl5 = pgElementSet.hasElementColors();
        boolean bl6 = pgElementSet.hasElementBackColors();
        int n20 = pgElementSet.getNumVectorFields();
        boolean[] blArray = new boolean[pgElementSet.getNumVertices()];
        if (bl) {
            for (n17 = 0; n17 < pgElementSet.getNumVertices(); ++n17) {
                blArray[n17] = false;
            }
            if (pgElementSet.hasBoundary()) {
                PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                    blArray[pgBndPolygonArray[i].getVertexInd().m_data[0]] = true;
                    blArray[pgBndPolygonArray[i].getVertexInd().m_data[pgBndPolygonArray[i].getVertexInd().getSize() - 1]] = true;
                }
            }
        }
        n17 = 0;
        int n21 = bl ? pgElementSet.getNumElements() + pgElementSet.getNumVertices() : pgElementSet.getNumElements();
        PiVector[] piVectorArray3 = new PiVector[n21];
        PdVector[][] pdVectorArrayArray = new PdVector[n21][];
        if (bl4) {
            pdVectorArray = pgElementSet.getElementTextures();
            n16 = pgElementSet.getNumElements();
            for (n15 = 0; n15 < n16; ++n15) {
                PdVector[] pdVectorArray2 = pdVectorArray[n15];
                n14 = pdVectorArray2.length;
                pdVectorArrayArray[n15] = new PdVector[2 * n14];
                for (int i = 0; i < n14; ++i) {
                    pdVectorArrayArray[n15][2 * i + 1] = PdVector.blendNew((double)d2, (PdVector)pdVectorArray2[i], (double)d, (PdVector)pdVectorArray2[(i + 1) % n14]);
                    pdVectorArrayArray[n15][(2 * i + 2) % (2 * n14)] = PdVector.blendNew((double)d, (PdVector)pdVectorArray2[i], (double)d2, (PdVector)pdVectorArray2[(i + 1) % n14]);
                }
            }
        }
        pdVectorArray = new Color[n21];
        if (bl5) {
            n16 = pgElementSet.getNumElements();
            for (n15 = 0; n15 < n16; ++n15) {
                pdVectorArray[n15] = pgElementSet.getElementColor(n15);
            }
        }
        Color[] colorArray = new Color[n21];
        if (bl6) {
            n15 = pgElementSet.getNumElements();
            for (int i = 0; i < n15; ++i) {
                colorArray[i] = pgElementSet.getElementBackColor(i);
            }
        }
        PiVector piVector = new PiVector(pgElementSet.getNumVertices());
        for (n13 = 0; n13 < pgElementSet.getNumElements(); ++n13) {
            for (n14 = 0; n14 < piVectorArray[n13].m_data.length; ++n14) {
                ++n18;
                if (piVectorArray2[n13].m_data[n14] == -1) {
                    ++n18;
                }
                int n22 = piVectorArray[n13].m_data[n14];
                piVector.m_data[n22] = piVector.m_data[n22] + 1;
            }
        }
        for (n13 = 0; n13 < pgElementSet.getNumVertices(); ++n13) {
            if (!bl || piVector.m_data[n13] != 1 && !blArray[n13]) continue;
            ++n18;
        }
        PdVector[] pdVectorArray3 = new PdVector[n18];
        Color[] colorArray2 = new Color[n18];
        PdVector[] pdVectorArray4 = new PdVector[n18];
        PdVector[] pdVectorArray5 = pgElementSet.getVertexTextures();
        PdVector[][] pdVectorArrayArray2 = new PdVector[n20][];
        for (n12 = 0; n12 < n20; ++n12) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n12);
            if (pgVectorField.getBasedOn() == 1) {
                pdVectorArrayArray2[n12] = new PdVector[n21];
                n11 = pgVectorField.getNumVectors();
                for (n10 = 0; n10 < n11; ++n10) {
                    pdVectorArrayArray2[n12][n10] = PdVector.copyNew((PdVector)pgVectorField.getVector(n10));
                }
                continue;
            }
            pdVectorArrayArray2[n12] = new PdVector[n18];
        }
        n12 = pgElementSet.getDimOfTextures();
        int n23 = pgElementSet.getNumElements();
        int n24 = pgElementSet.getNumVertices();
        boolean[] blArray2 = new boolean[n24];
        for (n9 = 0; n9 < n24; ++n9) {
            blArray2[n9] = false;
        }
        for (n9 = 0; n9 < n23; ++n9) {
            n8 = piVectorArray[n9].getSize();
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = piVectorArray[n9].m_data[n7];
                if (blArray2[n6]) continue;
                blArray2[n6] = true;
                pgVertexStar.makeVertexStar(pgElementSet, n6, n9);
                n10 = pgVertexStar.getLink().getSize();
                if (bl) {
                    Color color;
                    int n25;
                    if (n10 > 2) {
                        if (blArray[n6]) {
                            piVectorArray3[n19] = new PiVector(n10 + 1);
                            for (int i = 0; i < n10 + 1; ++i) {
                                piVectorArray3[n19].m_data[i] = n17 + i;
                            }
                            if (bl4) {
                                pdVectorArrayArray[n19] = PdVector.realloc(null, (int)(n10 + 1), (int)n12);
                            }
                            ++n19;
                        } else {
                            piVectorArray3[n19] = new PiVector(n10);
                            for (int i = 0; i < n10; ++i) {
                                piVectorArray3[n19].m_data[i] = n17 + i;
                            }
                            if (bl4) {
                                pdVectorArrayArray[n19] = PdVector.realloc(null, (int)n10, (int)n12);
                            }
                            ++n19;
                        }
                    } else {
                        piVectorArray3[n19] = new PiVector(3);
                        piVectorArray3[n19].m_data[0] = n17;
                        piVectorArray3[n19].m_data[1] = n17 + 1;
                        piVectorArray3[n19].m_data[2] = n17 + 2;
                        if (bl4) {
                            pdVectorArrayArray[n19] = PdVector.realloc(null, (int)3, (int)n12);
                        }
                        ++n19;
                    }
                    if (bl5) {
                        PiVector piVector2 = pgVertexStar.getElement();
                        n25 = 0;
                        n5 = 0;
                        n4 = 0;
                        n3 = piVector2.getSize();
                        for (n2 = 0; n2 < n3; ++n2) {
                            color = pgElementSet.getElementColor(piVector2.m_data[n2]);
                            n25 += color.getRed();
                            n5 += color.getGreen();
                            n4 += color.getBlue();
                        }
                        pdVectorArray[n19 - 1] = new Color(n25 /= n3, n5 /= n3, n4 /= n3);
                    }
                    if (bl6) {
                        PiVector piVector3 = pgVertexStar.getElement();
                        n25 = 0;
                        n5 = 0;
                        n4 = 0;
                        n3 = piVector3.getSize();
                        for (n2 = 0; n2 < n3; ++n2) {
                            color = pgElementSet.getElementBackColor(piVector3.m_data[n2]);
                            n25 += color.getRed();
                            n5 += color.getGreen();
                            n4 += color.getBlue();
                        }
                        colorArray[n19 - 1] = new Color(n25 /= n3, n5 /= n3, n4 /= n3);
                    }
                    for (int i = 0; i < n20; ++i) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                        if (pgVectorField.getBasedOn() != 1) continue;
                        PiVector piVector4 = pgVertexStar.getElement();
                        n4 = piVector4.getSize();
                        color = PdVector.copyNew((PdVector)pgVectorField.getVector(piVector4.m_data[0]));
                        for (n3 = 1; n3 < n4; ++n3) {
                            color.add(pgVectorField.getVector(piVector4.m_data[n3]));
                        }
                        color.multScalar(1.0 / (double)n4);
                        pdVectorArrayArray2[i][n19 - 1] = color;
                    }
                }
                pgBndPolygon = pgVertexStar.getElement();
                PiVector piVector5 = pgVertexStar.getVertexLocInd();
                n5 = 0;
                if (pgVertexStar.isClosed()) {
                    for (n4 = 0; n4 < n10; ++n4) {
                        int n26 = pgBndPolygon.m_data[n4];
                        n11 = piVector5.m_data[n4];
                        if (piVectorArray3[n26] == null) {
                            piVectorArray3[n26] = new PiVector(piVectorArray[n26].m_data.length * 2);
                        }
                        if (n4 > 0) {
                            int n27 = pgBndPolygon.m_data[n4 - 1];
                            PiVector piVector6 = piVectorArray2[n26];
                            n2 = piVector6.getSize();
                            n5 = piVector6.m_data[(n11 - 1 + n2) % n2] == n27 ? 0 : 1;
                        }
                        if (n5 == 0) {
                            piVectorArray3[n26].m_data[2 * n11 + 1] = n17 + n4;
                            piVectorArray3[n26].m_data[2 * n11] = n17 + (n4 + 1) % n10;
                        } else {
                            piVectorArray3[n26].m_data[2 * n11] = n17 + n4;
                            piVectorArray3[n26].m_data[2 * n11 + 1] = n17 + (n4 + 1) % n10;
                        }
                        pdVectorArray3[n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pgElementSet.getVertex(n6), (double)d, (PdVector)pgElementSet.getVertex(pgVertexStar.getLink().m_data[n4]));
                        if (bl2) {
                            Color color;
                            colorArray2[n17 + n4] = color = PdColor.blend((double)d2, (Color)pgElementSet.getVertexColor(n6), (double)d, (Color)pgElementSet.getVertexColor(pgVertexStar.getLink().m_data[n4]));
                        }
                        if (bl3) {
                            pdVectorArray4[n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pdVectorArray5[n6], (double)d, (PdVector)pdVectorArray5[pgVertexStar.getLink().m_data[n4]]);
                        }
                        for (int i = 0; i < n20; ++i) {
                            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                            if (pgVectorField.getBasedOn() != 0) continue;
                            pdVectorArrayArray2[i][n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pgVectorField.getVector(n6), (double)d, (PdVector)pgVectorField.getVector(pgVertexStar.getLink().m_data[n4]));
                        }
                    }
                    n17 += n10;
                    continue;
                }
                for (n4 = 0; n4 < n10 - 1; ++n4) {
                    int n28 = pgBndPolygon.m_data[n4];
                    n11 = piVector5.m_data[n4];
                    if (piVectorArray3[n28] == null) {
                        piVectorArray3[n28] = new PiVector(piVectorArray[n28].m_data.length * 2);
                    }
                    if (n4 == 0 && n10 > 2) {
                        int n29 = pgBndPolygon.m_data[1];
                        PiVector piVector7 = piVectorArray2[n28];
                        n2 = piVector7.getSize();
                        n5 = piVector7.m_data[(n11 - 1 + n2) % n2] == n29 ? 1 : 0;
                    }
                    if (n4 > 0) {
                        int n30 = pgBndPolygon.m_data[n4 - 1];
                        PiVector piVector8 = piVectorArray2[n28];
                        n2 = piVector8.getSize();
                        n5 = piVector8.m_data[(n11 - 1 + n2) % n2] == n30 ? 0 : 1;
                    }
                    if (n5 == 0) {
                        piVectorArray3[n28].m_data[2 * n11 + 1] = n17 + n4;
                        piVectorArray3[n28].m_data[2 * n11] = n17 + n4 + 1;
                    } else {
                        piVectorArray3[n28].m_data[2 * n11] = n17 + n4;
                        piVectorArray3[n28].m_data[2 * n11 + 1] = n17 + n4 + 1;
                    }
                    pdVectorArray3[n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pgElementSet.getVertex(n6), (double)d, (PdVector)pgElementSet.getVertex(pgVertexStar.getLink().m_data[n4]));
                    if (bl2) {
                        Color color;
                        colorArray2[n17 + n4] = color = PdColor.blend((double)d2, (Color)pgElementSet.getVertexColor(n6), (double)d, (Color)pgElementSet.getVertexColor(pgVertexStar.getLink().m_data[n4]));
                    }
                    if (bl3) {
                        pdVectorArray4[n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pdVectorArray5[n6], (double)d, (PdVector)pdVectorArray5[pgVertexStar.getLink().m_data[n4]]);
                    }
                    for (int i = 0; i < n20; ++i) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        pdVectorArrayArray2[i][n17 + n4] = PdVector.blendNew((double)d2, (PdVector)pgVectorField.getVector(n6), (double)d, (PdVector)pgVectorField.getVector(pgVertexStar.getLink().m_data[n4]));
                    }
                }
                pdVectorArray3[n17 + n10 - 1] = PdVector.blendNew((double)d2, (PdVector)pgElementSet.getVertex(n6), (double)d, (PdVector)pgElementSet.getVertex(pgVertexStar.getLink().m_data[n10 - 1]));
                if (bl2) {
                    Color color;
                    colorArray2[n17 + n10 - 1] = color = PdColor.blend((double)d2, (Color)pgElementSet.getVertexColor(n6), (double)d, (Color)pgElementSet.getVertexColor(pgVertexStar.getLink().m_data[n10 - 1]));
                }
                if (bl3) {
                    pdVectorArray4[n17 + n10 - 1] = PdVector.blendNew((double)d2, (PdVector)pdVectorArray5[n6], (double)d, (PdVector)pdVectorArray5[pgVertexStar.getLink().m_data[n10 - 1]]);
                }
                for (n4 = 0; n4 < n20; ++n4) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n4);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pdVectorArrayArray2[n4][n17 + n10 - 1] = PdVector.blendNew((double)d2, (PdVector)pgVectorField.getVector(n6), (double)d, (PdVector)pgVectorField.getVector(pgVertexStar.getLink().m_data[n10 - 1]));
                }
                n17 += n10;
                if (!bl || n10 != 2 && !blArray[n6]) continue;
                pdVectorArray3[n17] = PdVector.copyNew((PdVector)pgElementSet.getVertex(n6));
                if (bl2) {
                    colorArray2[n17] = pgElementSet.getVertexColor(n6);
                }
                if (bl3) {
                    pdVectorArray4[n17] = PdVector.copyNew((PdVector)pdVectorArray5[n6]);
                }
                for (n4 = 0; n4 < n20; ++n4) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n4);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pdVectorArrayArray2[n4][n17] = PdVector.copyNew((PdVector)pgVectorField.getVector(n6));
                }
                ++n17;
            }
        }
        if (pgElementSet.hasBoundary()) {
            if (bl) {
                PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                n7 = pgElementSet.getNumElements();
                for (n6 = 0; n6 < pgBndPolygonArray.length; ++n6) {
                    pgBndPolygon = pgBndPolygonArray[n6];
                    int n31 = pgBndPolygon.getNumVertices();
                    PiVector piVector9 = new PiVector(n31 * 3);
                    n5 = 1;
                    piVector9.m_data[0] = piVectorArray3[n7 + pgBndPolygon.getVertexInd().m_data[0]].m_data[piVectorArray3[n7 + pgBndPolygon.getVertexInd().m_data[0]].getSize() - 1];
                    for (n4 = 0; n4 < n31 - 1; ++n4) {
                        int n32 = pgBndPolygon.getElementInd().m_data[n4];
                        n3 = -1;
                        n2 = -1;
                        PiVector piVector10 = pgElementSet.getElement(n32);
                        int n33 = piVector10.getSize();
                        for (int i = 0; i < n33; ++i) {
                            if (piVector10.m_data[i] == pgBndPolygon.getVertexInd().m_data[n4]) {
                                n3 = i;
                            }
                            if (piVector10.m_data[i] != pgBndPolygon.getVertexInd().m_data[n4 + 1]) continue;
                            n2 = i;
                        }
                        if ((n3 + 1) % n33 == n2) {
                            piVector9.m_data[n5] = piVectorArray3[n32].m_data[2 * n3 + 1];
                            piVector9.m_data[++n5] = piVectorArray3[n32].m_data[2 * n2];
                            ++n5;
                        } else {
                            piVector9.m_data[n5] = piVectorArray3[n32].m_data[2 * n3];
                            piVector9.m_data[++n5] = piVectorArray3[n32].m_data[2 * n2 + 1];
                            ++n5;
                        }
                        if (piVector.m_data[pgBndPolygon.getVertexInd().m_data[n4]] != 1 || n4 == n31 - 2 || n4 == 0) continue;
                        piVector9.m_data[n5] = piVectorArray3[n7 + pgBndPolygon.getVertexInd().m_data[n4 + 1]].m_data[2];
                        ++n5;
                    }
                    n4 = n7 + pgBndPolygon.getVertexInd().m_data[n31 - 1];
                    PiVector piVector11 = piVectorArray3[n4];
                    piVector9.m_data[n5] = piVector11.m_data[piVector11.getSize() - 1];
                    piVector9.setSize(++n5);
                    pgBndPolygon.setNumVertices(n5);
                    pgBndPolygon.getVertexInd().copy(piVector9);
                }
            } else {
                pgElementSet.removeBoundaries();
            }
        }
        if (pgElementSet.getDimOfElements() > -1 && !bl) {
            pgElementSet.setDimOfElements(2 * pgElementSet.getDimOfElements());
        } else {
            pgElementSet.setDimOfElements(-1);
        }
        pgElementSet.setNumVertices(n18);
        pgElementSet.setNumElements(n21);
        piVectorArray = pgElementSet.getElements();
        for (n = 0; n < n21; ++n) {
            piVectorArray[n] = new PiVector(piVectorArray3[n].m_data.length);
            for (n8 = 0; n8 < piVectorArray3[n].m_data.length; ++n8) {
                piVectorArray[n].m_data[n8] = piVectorArray3[n].m_data[n8];
            }
        }
        if (bl5) {
            for (n = 0; n < n21; ++n) {
                pgElementSet.setElementColor(n, (Color)pdVectorArray[n]);
            }
        }
        if (bl6) {
            for (n = 0; n < n21; ++n) {
                pgElementSet.setElementBackColor(n, colorArray[n]);
            }
        }
        if (bl2) {
            for (n = 0; n < n18; ++n) {
                pgElementSet.setVertexColor(n, colorArray2[n]);
            }
        }
        if (bl3) {
            pgElementSet.setVertexTextures(pdVectorArray4);
        }
        for (n = 0; n < n20; ++n) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n);
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setNumVectors(n18);
            } else {
                pgVectorField.setNumVectors(n21);
            }
            pgVectorField.setVectors(pdVectorArrayArray2[n]);
        }
        for (n = 0; n < pgElementSet.getNumVertices(); ++n) {
            pgElementSet.getVertex(n).copy(pdVectorArray3[n]);
        }
        if (bl4) {
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        }
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
        pgElementSet.makeNeighbour();
        if (bl && pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                if (pgBndPolygonArray[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
    }

    public static void rhombificate(PgElementSet pgElementSet, double d) {
        double d2;
        double d3;
        PiVector piVector;
        int n;
        int n2;
        PdVector[] pdVectorArray;
        int n3;
        int n4;
        PiVector[] piVectorArray;
        int n5;
        int n6;
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n7 = pgElementSet.getNumElements();
        int n8 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        boolean bl = pgElementSet.hasVertexColors();
        boolean bl2 = pgElementSet.hasVertexTextures();
        boolean bl3 = pgElementSet.hasElementTextures();
        boolean bl4 = pgElementSet.hasElementColors();
        boolean bl5 = pgElementSet.hasElementBackColors();
        boolean[] blArray = new boolean[n8];
        for (int i = 0; i < n8; ++i) {
            blArray[i] = false;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n6 = 0; n6 < pgBndPolygonArray.length; ++n6) {
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[0]] = true;
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[pgBndPolygonArray[n6].getNumVertices() - 1]] = true;
            }
        }
        PiVector[][] piVectorArrayArray = new PiVector[n8][];
        n6 = 0;
        int n9 = n7 + n8;
        for (n5 = 0; n5 < n8; ++n5) {
            if (!blArray[n5]) continue;
            ++n6;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            piVectorArray = pgElementSet.getNeighbour(n5);
            int n10 = piVectorArray.getSize();
            for (n4 = 0; n4 < n10; ++n4) {
                if (piVectorArray.m_data[n4] < n5) {
                    ++n9;
                }
                if (piVectorArray.m_data[n4] != -1) continue;
                n6 += 2;
            }
            n6 += n10;
        }
        PdVector[] pdVectorArray3 = new PdVector[n6];
        piVectorArray = new PiVector[n9];
        Color[] colorArray = new Color[n9];
        if (bl4) {
            for (n4 = 0; n4 < n7; ++n4) {
                colorArray[n4] = pgElementSet.getElementColor(n4);
            }
        }
        Color[] colorArray2 = new Color[n9];
        if (bl5) {
            for (n3 = 0; n3 < n7; ++n3) {
                colorArray2[n3] = pgElementSet.getElementBackColor(n3);
            }
        }
        n3 = pgElementSet.getNumVectorFields();
        PdVector[][] pdVectorArrayArray = new PdVector[n3][];
        for (int i = 0; i < n3; ++i) {
            pdVectorArray = pgElementSet.getVectorField(i);
            if (pdVectorArray.getBasedOn() == 1) {
                pdVectorArrayArray[i] = new PdVector[n9];
                for (n2 = 0; n2 < n7; ++n2) {
                    pdVectorArrayArray[i][n2] = PdVector.copyNew((PdVector)pdVectorArray.getVector(n2));
                }
                continue;
            }
            pdVectorArrayArray[i] = new PdVector[n6];
        }
        Color[] colorArray3 = new Color[n6];
        pdVectorArray = new PdVector[n6];
        for (n2 = 0; n2 < n7; ++n2) {
            piVectorArray[n2] = new PiVector(piVectorArray2[n2].getSize());
        }
        n2 = n8;
        int n11 = n7;
        PiVector piVector2 = new PiVector(n8);
        for (n = n7 - 1; n >= 0; --n) {
            int n12 = piVectorArray2[n].getSize();
            for (int i = 0; i < n12; ++i) {
                piVector2.m_data[piVectorArray2[n].m_data[i]] = n;
            }
        }
        for (n = 0; n < n8; ++n) {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            pgVertexStar.makeVertexStar(pgElementSet, n, piVector2.m_data[n]);
            PiVector piVector3 = pgVertexStar.getElement();
            PiVector piVector4 = pgVertexStar.getLink();
            PiVector piVector5 = pgVertexStar.getVertexLocInd();
            int n18 = pgVertexStar.getSize();
            if (pgVertexStar.isClosed()) {
                piVector = new PiVector(n18);
                piVector.m_data[0] = n;
                for (n17 = 1; n17 < n18; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                n17 = 0;
                for (n16 = 0; n16 < n18; ++n16) {
                    piVectorArray[piVector3.m_data[n16]].m_data[piVector5.m_data[n16]] = piVector.m_data[n16];
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18; ++n16) {
                    n15 = piVector4.m_data[n16];
                    if (n15 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n15;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n][n17].m_data[2] = piVector3.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16];
                        piVectorArrayArray[n][n17].m_data[4] = piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n15].length;
                    for (n13 = 0; n13 < n14; ++n13) {
                        if (piVectorArrayArray[n15][n13].m_data[0] != n) continue;
                        piVectorArrayArray[n15][n13].m_data[5] = piVector.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n15][n13].m_data[6] = piVector3.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n15][n13].m_data[7] = piVector.m_data[n16];
                        piVectorArrayArray[n15][n13].m_data[8] = piVector3.m_data[n16];
                    }
                }
            } else if (blArray[n]) {
                piVector = new PiVector(n18 + 3);
                piVector.m_data[0] = n;
                pdVectorArray3[n] = PdVector.copyNew((PdVector)pdVectorArray2[n]);
                for (n17 = 1; n17 < n18 + 3; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                for (n17 = 0; n17 < n18; ++n17) {
                    piVectorArray[piVector3.m_data[n17]].m_data[piVector5.m_data[n17]] = piVector.m_data[n17 + 2];
                }
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    int n19 = piVector4.m_data[n16];
                    if (n19 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n19;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n][n17].m_data[2] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16 + 2];
                        piVectorArrayArray[n][n17].m_data[4] = n16 == n18 ? -1 : piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n19].length;
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArrayArray[n19][i].m_data[0] != n) continue;
                        piVectorArrayArray[n19][i].m_data[5] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n19][i].m_data[6] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n19][i].m_data[7] = piVector.m_data[n16 + 2];
                        piVectorArrayArray[n19][i].m_data[8] = n16 == n18 ? -1 : piVector3.m_data[n16];
                    }
                }
                if (bl2) {
                    pdVectorArray[n] = pgElementSet.getVertexTexture(n);
                }
                for (n16 = 0; n16 < n3; ++n16) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n16);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pdVectorArrayArray[n16][n] = PdVector.copyNew((PdVector)pgVectorField.getVector(n));
                }
            } else {
                piVector = new PiVector(n18 + 2);
                piVector.m_data[0] = n;
                for (n17 = 1; n17 < n18 + 2; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                for (n17 = 0; n17 < n18; ++n17) {
                    piVectorArray[piVector3.m_data[n17]].m_data[piVector5.m_data[n17]] = piVector.m_data[n17 + 1];
                }
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    int n20 = piVector4.m_data[n16];
                    if (n20 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n20;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[n16];
                        piVectorArrayArray[n][n17].m_data[2] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n][n17].m_data[4] = n16 == n18 ? -1 : piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n20].length;
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArrayArray[n20][i].m_data[0] != n) continue;
                        piVectorArrayArray[n20][i].m_data[5] = piVector.m_data[n16];
                        piVectorArrayArray[n20][i].m_data[6] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n20][i].m_data[7] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n20][i].m_data[8] = n16 == n18 ? -1 : piVector3.m_data[n16];
                    }
                }
            }
            piVectorArray[n11] = piVector;
            if (bl4) {
                Color color;
                n17 = 0;
                n16 = 0;
                n15 = 0;
                for (n13 = 0; n13 < n18; ++n13) {
                    Color color2 = pgElementSet.getElementColor(piVector3.m_data[n13]);
                    n17 += color2.getRed();
                    n16 += color2.getGreen();
                    n15 += color2.getBlue();
                }
                colorArray[n11] = color = new Color(n17 / n18, n16 / n18, n15 / n18);
            }
            if (bl5) {
                Color color;
                n17 = 0;
                n16 = 0;
                n15 = 0;
                for (int i = 0; i < n18; ++i) {
                    Color color3 = pgElementSet.getElementBackColor(piVector3.m_data[i]);
                    n17 += color3.getRed();
                    n16 += color3.getGreen();
                    n15 += color3.getBlue();
                }
                colorArray2[n11] = color = new Color(n17 / n18, n16 / n18, n15 / n18);
            }
            for (n17 = 0; n17 < n3; ++n17) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n17);
                if (pgVectorField.getBasedOn() != 1) continue;
                PdVector pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(piVector3.m_data[0]));
                for (n14 = 1; n14 < n18; ++n14) {
                    pdVector.add(pgVectorField.getVector(piVector3.m_data[n14]));
                }
                pdVector.multScalar(1.0 / (double)n18);
                pdVectorArrayArray[n17][n11] = pdVector;
            }
            ++n11;
        }
        for (n = 0; n < n7; ++n) {
            int n21;
            int n22;
            PiVector piVector6 = piVectorArray2[n];
            PiVector piVector7 = piVectorArray[n];
            int n23 = piVector6.getSize();
            PdVector[] pdVectorArray4 = new PdVector[n23];
            piVector = new PdVector[n23];
            PdVector pdVector = new PdVector(n23);
            pdVector.m_data[0] = 1.0 - d * (((double)n23 - 1.0) / (double)n23);
            for (n22 = 0; n22 < n23; ++n22) {
                pdVectorArray4[n22] = pdVectorArray2[piVector6.m_data[n22]];
                piVector[n22] = PdVector.copyNew((PdVector)pdVectorArray4[n22]);
                piVector[n22].multScalar(pdVector.m_data[0]);
                pdVectorArray3[piVector7.m_data[n22]] = piVector[n22];
            }
            for (n22 = 1; n22 < n23; ++n22) {
                pdVector.m_data[n22] = d * 1.0 / (double)n23;
                for (int i = 0; i < n23; ++i) {
                    piVector[i].blendBase((PdVector)piVector[i], pdVector.m_data[n22], pdVectorArray4[(i + n22) % n23]);
                }
            }
            if (bl) {
                int n24;
                PdVector pdVector2 = new PdVector(n23);
                PdVector pdVector3 = new PdVector(n23);
                PdVector pdVector4 = new PdVector(n23);
                for (n24 = 0; n24 < n23; ++n24) {
                    Color color = pgElementSet.getVertexColor(piVector6.m_data[n24]);
                    double d4 = color.getRed();
                    d3 = color.getGreen();
                    d2 = color.getBlue();
                    for (int i = 0; i < n23; ++i) {
                        int n25 = i;
                        pdVector2.m_data[n25] = pdVector2.m_data[n25] + d4 * pdVector.m_data[(i - n24 + n23) % n23];
                        int n26 = i;
                        pdVector3.m_data[n26] = pdVector3.m_data[n26] + d3 * pdVector.m_data[(i - n24 + n23) % n23];
                        int n27 = i;
                        pdVector4.m_data[n27] = pdVector4.m_data[n27] + d2 * pdVector.m_data[(i - n24 + n23) % n23];
                    }
                }
                for (n24 = 0; n24 < n23; ++n24) {
                    colorArray3[piVector7.m_data[n24]] = new Color((int)pdVector2.m_data[n24], (int)pdVector3.m_data[n24], (int)pdVector4.m_data[n24]);
                }
            }
            for (int i = 0; i < n3; ++i) {
                int n28;
                PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                if (pgVectorField.getBasedOn() != 0) continue;
                PdVector[] pdVectorArray5 = new PdVector[n23];
                PdVector[] pdVectorArray6 = new PdVector[n23];
                for (n28 = 0; n28 < n23; ++n28) {
                    pdVectorArray5[n28] = pgVectorField.getVector(piVector6.m_data[n28]);
                    pdVectorArray6[n28] = PdVector.copyNew((PdVector)pdVectorArray5[n28]);
                    pdVectorArray6[n28].multScalar(pdVector.m_data[0]);
                    pdVectorArrayArray[i][piVector7.m_data[n28]] = pdVectorArray6[n28];
                }
                for (n28 = 1; n28 < n23; ++n28) {
                    for (int j = 0; j < n23; ++j) {
                        pdVectorArray6[j].blendBase(pdVectorArray6[j], pdVector.m_data[n28], pdVectorArray5[(j + n28) % n23]);
                    }
                }
            }
            if (bl2) {
                int n29;
                PdVector[] pdVectorArray7 = new PdVector[n23];
                for (int i = 0; i < n23; ++i) {
                    pdVectorArray7[i] = pgElementSet.getVertexTextures()[piVector6.m_data[i]];
                }
                PdVector[] pdVectorArray8 = new PdVector[n23];
                for (n29 = 0; n29 < n23; ++n29) {
                    pdVectorArray8[n29] = PdVector.copyNew((PdVector)pdVectorArray7[n29]);
                    pdVectorArray8[n29].multScalar(pdVector.m_data[0]);
                    pdVectorArray[piVector7.m_data[n29]] = pdVectorArray8[n29];
                }
                for (n29 = 1; n29 < n23; ++n29) {
                    for (int i = 0; i < n23; ++i) {
                        pdVectorArray8[i].blendBase(pdVectorArray8[i], pdVector.m_data[n29], pdVectorArray7[(i + n29) % n23]);
                    }
                }
            }
            if (!bl3) continue;
            PdVector[] pdVectorArray9 = pgElementSet.getElementTexture(n);
            PdVector[] pdVectorArray10 = new PdVector[n23];
            for (n21 = 0; n21 < n23; ++n21) {
                pdVectorArray10[n21] = PdVector.copyNew((PdVector)pdVectorArray9[n21]);
                pdVectorArray10[n21].multScalar(pdVector.m_data[0]);
            }
            for (n21 = 1; n21 < n23; ++n21) {
                for (int i = 0; i < n23; ++i) {
                    pdVectorArray10[i].blendBase(pdVectorArray10[i], pdVector.m_data[n21], pdVectorArray9[(i + n21) % n23]);
                }
            }
            pgElementSet.setElementTexture(n, pdVectorArray10);
        }
        for (n = 0; n < n8; ++n) {
            int n30 = piVectorArrayArray[n].length;
            for (int i = 0; i < n30; ++i) {
                PdVector pdVector;
                PiVector piVector8 = piVectorArrayArray[n][i];
                if (piVector8.m_data[2] == -1 || piVector8.m_data[4] == -1) {
                    PgVectorField pgVectorField;
                    int n31;
                    pdVector = pdVectorArray2[n];
                    PdVector pdVector5 = pdVectorArray2[piVector8.m_data[0]];
                    PdVector pdVector6 = PdVector.subNew((PdVector)pdVector5, (PdVector)pdVector);
                    double d5 = 1.0;
                    PiVector piVector9 = new PiVector(2);
                    if (piVector8.m_data[2] == -1) {
                        pdVectorArray3[piVector8.m_data[1]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[3]]);
                        piVector9.m_data[0] = piVector8.m_data[1];
                    } else {
                        pdVectorArray3[piVector8.m_data[3]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[1]]);
                        piVector9.m_data[0] = piVector8.m_data[3];
                    }
                    if (piVector8.m_data[6] == -1) {
                        pdVectorArray3[piVector8.m_data[5]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[7]]);
                        piVector9.m_data[1] = piVector8.m_data[5];
                    } else {
                        pdVectorArray3[piVector8.m_data[7]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[5]]);
                        piVector9.m_data[1] = piVector8.m_data[7];
                    }
                    PdVector pdVector7 = new PdVector(2);
                    pdVector7.m_data[0] = 0.5 * d;
                    pdVector7.m_data[1] = 1.0 - 0.5 * d;
                    for (int j = 0; j < 2; ++j) {
                        pdVectorArray3[piVector9.m_data[j]].copy(pdVector6);
                        pdVectorArray3[piVector9.m_data[j]].multScalar(pdVector7.m_data[j]);
                        pdVectorArray3[piVector9.m_data[j]].add(pdVector);
                    }
                    if (bl) {
                        Color color = pgElementSet.getVertexColor(n);
                        Color color4 = pgElementSet.getVertexColor(piVector8.m_data[0]);
                        for (n31 = 0; n31 < 2; ++n31) {
                            d3 = (double)color.getRed() * (1.0 - pdVector7.m_data[n31] / d5) + (double)color4.getRed() * pdVector7.m_data[n31] / d5;
                            d2 = (double)color.getGreen() * (1.0 - pdVector7.m_data[n31] / d5) + (double)color4.getGreen() * pdVector7.m_data[n31] / d5;
                            double d6 = (double)color.getBlue() * (1.0 - pdVector7.m_data[n31] / d5) + (double)color4.getBlue() * pdVector7.m_data[n31] / d5;
                            colorArray3[piVector9.m_data[n31]] = new Color((int)d3, (int)d2, (int)d6);
                        }
                    }
                    for (int j = 0; j < n3; ++j) {
                        pgVectorField = pgElementSet.getVectorField(j);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        PdVector pdVector8 = pgVectorField.getVector(n);
                        PdVector pdVector9 = pgVectorField.getVector(piVector8.m_data[0]);
                        for (int k = 0; k < 2; ++k) {
                            pdVectorArrayArray[j][piVector9.m_data[k]] = PdVector.blendNew((double)(1.0 - pdVector7.m_data[k] / d5), (PdVector)pdVector8, (double)(pdVector7.m_data[k] / d5), (PdVector)pdVector9);
                        }
                    }
                    if (bl2) {
                        PdVector pdVector10 = pgElementSet.getVertexTextures()[n];
                        pgVectorField = pgElementSet.getVertexTextures()[piVector8.m_data[0]];
                        for (n31 = 0; n31 < 2; ++n31) {
                            pdVectorArray[piVector9.m_data[n31]] = PdVector.blendNew((double)(1.0 - pdVector7.m_data[n31] / d5), (PdVector)pdVector10, (double)(pdVector7.m_data[n31] / d5), (PdVector)pgVectorField);
                        }
                    }
                }
                pdVector = new PiVector(4);
                pdVector.m_data[0] = piVector8.m_data[3];
                pdVector.m_data[1] = piVector8.m_data[1];
                if (piVector8.m_data[2] == piVector8.m_data[6]) {
                    pdVector.m_data[2] = piVector8.m_data[5];
                    pdVector.m_data[3] = piVector8.m_data[7];
                } else {
                    pdVector.m_data[2] = piVector8.m_data[7];
                    pdVector.m_data[3] = piVector8.m_data[5];
                }
                piVectorArray[n11] = pdVector;
                if (bl4) {
                    Color color;
                    int n32 = 0;
                    int n33 = 0;
                    int n34 = 0;
                    int n35 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (piVector8.m_data[2 + 2 * j] == -1) continue;
                        Color color5 = pgElementSet.getElementColor(piVector8.m_data[2 + 2 * j]);
                        n32 += color5.getRed();
                        n33 += color5.getGreen();
                        n34 += color5.getBlue();
                        ++n35;
                    }
                    colorArray[n11] = color = new Color(n32 / n35, n33 / n35, n34 / n35);
                }
                if (bl5) {
                    Color color;
                    int n36 = 0;
                    int n37 = 0;
                    int n38 = 0;
                    int n39 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (piVector8.m_data[2 + 2 * j] == -1) continue;
                        Color color6 = pgElementSet.getElementBackColor(piVector8.m_data[2 + 2 * j]);
                        n36 += color6.getRed();
                        n37 += color6.getGreen();
                        n38 += color6.getBlue();
                        ++n39;
                    }
                    colorArray2[n11] = color = new Color(n36 / n39, n37 / n39, n38 / n39);
                }
                for (int j = 0; j < n3; ++j) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                    if (pgVectorField.getBasedOn() != 1) continue;
                    PdVector pdVector11 = new PdVector(pgVectorField.getDimOfVectors());
                    int n40 = 0;
                    for (int k = 0; k < 2; ++k) {
                        if (piVector8.m_data[2 + 2 * k] == -1) continue;
                        pdVector11.add(pgVectorField.getVector(piVector8.m_data[2 + 2 * k]));
                        ++n40;
                    }
                    pdVector11.multScalar(1.0 / (double)n40);
                    pdVectorArrayArray[j][n11] = pdVector11;
                }
                ++n11;
            }
        }
        pgElementSet.setNumVertices(n6);
        pgElementSet.setVertices(pdVectorArray3);
        pgElementSet.setNumElements(n9);
        pgElementSet.setElements(piVectorArray);
        if (bl3) {
            pgElementSet.assureElementTextures();
            PdVector[][] pdVectorArray11 = pgElementSet.getElementTextures();
            for (int i = n7; i < n9; ++i) {
                int n41 = pdVectorArray11[i].length;
                for (int j = 0; j < n41; ++j) {
                    pdVectorArray11[i][j].setConstant(0.0);
                }
            }
        }
        if (bl4) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementColor(i, colorArray[i]);
            }
        }
        if (bl5) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementBackColor(i, colorArray2[i]);
            }
        }
        if (bl) {
            for (int i = 0; i < n6; ++i) {
                pgElementSet.setVertexColor(i, colorArray3[i]);
            }
        }
        if (bl2) {
            pgElementSet.setVertexTextures(pdVectorArray);
        }
        for (int i = 0; i < n3; ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setNumVectors(n9);
            } else {
                pgVectorField.setNumVectors(n6);
            }
            pgVectorField.setVectors(pdVectorArrayArray[i]);
        }
        if (pgElementSet.hasBoundary()) {
            int n42;
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n42 = 0; n42 < pgBndPolygonArray.length; ++n42) {
                PiVector piVector10 = pgBndPolygonArray[n42].getVertexInd();
                int n43 = pgBndPolygonArray[n42].getNumVertices();
                PiVector piVector11 = new PiVector(n43 * 2);
                piVector11.m_data[0] = piVector10.m_data[0];
                piVector11.m_data[n43 * 2 - 1] = piVector10.m_data[n43 - 1];
                for (int i = 1; i < n43; ++i) {
                    int n44;
                    int n45;
                    PiVector[] piVectorArray3;
                    int n46 = -1;
                    int n47 = -1;
                    int n48 = piVector10.m_data[i - 1];
                    int n49 = piVector10.m_data[i];
                    if (n48 < n49) {
                        piVectorArray3 = piVectorArrayArray[n48];
                        n45 = piVectorArray3.length;
                        for (n44 = 0; n44 < n45; ++n44) {
                            if (piVectorArray3[n44].m_data[0] != n49) continue;
                            n46 = piVectorArray3[n44].m_data[2] == -1 ? piVectorArray3[n44].m_data[1] : piVectorArray3[n44].m_data[3];
                            n47 = piVectorArray3[n44].m_data[6] == -1 ? piVectorArray3[n44].m_data[5] : piVectorArray3[n44].m_data[7];
                        }
                    } else {
                        piVectorArray3 = piVectorArrayArray[n49];
                        n45 = piVectorArray3.length;
                        for (n44 = 0; n44 < n45; ++n44) {
                            if (piVectorArray3[n44].m_data[0] != n48) continue;
                            n47 = piVectorArray3[n44].m_data[2] == -1 ? piVectorArray3[n44].m_data[1] : piVectorArray3[n44].m_data[3];
                            n46 = piVectorArray3[n44].m_data[6] == -1 ? piVectorArray3[n44].m_data[5] : piVectorArray3[n44].m_data[7];
                        }
                    }
                    piVector11.m_data[2 * i - 1] = n46;
                    piVector11.m_data[2 * i] = n47;
                }
                pgBndPolygonArray[n42].setNumVertices(n43 * 2);
                pgBndPolygonArray[n42].getVertexInd().copy(piVector11);
            }
            for (n42 = 0; n42 < pgBndPolygonArray.length; ++n42) {
                if (pgBndPolygonArray[n42].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        pgElementSet.makeNeighbour();
    }

    public static void snubTruncate(PgElementSet pgElementSet, double d, double d2) {
        double d3;
        double d4;
        PiVector piVector;
        int n;
        int n2;
        PdVector[] pdVectorArray;
        int n3;
        int n4;
        PiVector[] piVectorArray;
        int n5;
        int n6;
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n7 = pgElementSet.getNumElements();
        int n8 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        boolean bl = pgElementSet.hasVertexColors();
        boolean bl2 = pgElementSet.hasVertexTextures();
        boolean bl3 = pgElementSet.hasElementTextures();
        boolean bl4 = pgElementSet.hasElementColors();
        boolean bl5 = pgElementSet.hasElementBackColors();
        boolean[] blArray = new boolean[n8];
        for (int i = 0; i < n8; ++i) {
            blArray[i] = false;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n6 = 0; n6 < pgBndPolygonArray.length; ++n6) {
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[0]] = true;
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[pgBndPolygonArray[n6].getNumVertices() - 1]] = true;
            }
        }
        PiVector[][] piVectorArrayArray = new PiVector[n8][];
        n6 = 0;
        int n9 = n7 + n8;
        for (n5 = 0; n5 < n8; ++n5) {
            if (!blArray[n5]) continue;
            ++n6;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            piVectorArray = pgElementSet.getNeighbour(n5);
            int n10 = piVectorArray.getSize();
            for (n4 = 0; n4 < n10; ++n4) {
                if (piVectorArray.m_data[n4] < n5) {
                    n9 += 2;
                }
                if (piVectorArray.m_data[n4] != -1) continue;
                n6 += 2;
            }
            n6 += n10;
        }
        PdVector[] pdVectorArray3 = new PdVector[n6];
        piVectorArray = new PiVector[n9];
        Color[] colorArray = new Color[n9];
        if (bl4) {
            for (n4 = 0; n4 < n7; ++n4) {
                colorArray[n4] = pgElementSet.getElementColor(n4);
            }
        }
        Color[] colorArray2 = new Color[n9];
        if (bl5) {
            for (n3 = 0; n3 < n7; ++n3) {
                colorArray2[n3] = pgElementSet.getElementBackColor(n3);
            }
        }
        n3 = pgElementSet.getNumVectorFields();
        PdVector[][] pdVectorArrayArray = new PdVector[n3][];
        for (int i = 0; i < n3; ++i) {
            pdVectorArray = pgElementSet.getVectorField(i);
            if (pdVectorArray.getBasedOn() == 1) {
                pdVectorArrayArray[i] = new PdVector[n9];
                for (n2 = 0; n2 < n7; ++n2) {
                    pdVectorArrayArray[i][n2] = PdVector.copyNew((PdVector)pdVectorArray.getVector(n2));
                }
                continue;
            }
            pdVectorArrayArray[i] = new PdVector[n6];
        }
        Color[] colorArray3 = new Color[n6];
        pdVectorArray = new PdVector[n6];
        for (n2 = 0; n2 < n7; ++n2) {
            piVectorArray[n2] = new PiVector(piVectorArray2[n2].getSize());
        }
        n2 = n8;
        int n11 = n7;
        PiVector piVector2 = new PiVector(n8);
        for (n = n7 - 1; n >= 0; --n) {
            int n12 = piVectorArray2[n].getSize();
            for (int i = 0; i < n12; ++i) {
                piVector2.m_data[piVectorArray2[n].m_data[i]] = n;
            }
        }
        for (n = 0; n < n8; ++n) {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            pgVertexStar.makeVertexStar(pgElementSet, n, piVector2.m_data[n]);
            PiVector piVector3 = pgVertexStar.getElement();
            PiVector piVector4 = pgVertexStar.getLink();
            PiVector piVector5 = pgVertexStar.getVertexLocInd();
            int n18 = pgVertexStar.getSize();
            if (pgVertexStar.isClosed()) {
                piVector = new PiVector(n18);
                piVector.m_data[0] = n;
                for (n17 = 1; n17 < n18; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                n17 = 0;
                for (n16 = 0; n16 < n18; ++n16) {
                    piVectorArray[piVector3.m_data[n16]].m_data[piVector5.m_data[n16]] = piVector.m_data[n16];
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18; ++n16) {
                    n15 = piVector4.m_data[n16];
                    if (n15 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n15;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n][n17].m_data[2] = piVector3.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16];
                        piVectorArrayArray[n][n17].m_data[4] = piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n15].length;
                    for (n13 = 0; n13 < n14; ++n13) {
                        if (piVectorArrayArray[n15][n13].m_data[0] != n) continue;
                        piVectorArrayArray[n15][n13].m_data[5] = piVector.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n15][n13].m_data[6] = piVector3.m_data[(n18 + n16 - 1) % n18];
                        piVectorArrayArray[n15][n13].m_data[7] = piVector.m_data[n16];
                        piVectorArrayArray[n15][n13].m_data[8] = piVector3.m_data[n16];
                    }
                }
            } else if (blArray[n]) {
                piVector = new PiVector(n18 + 3);
                piVector.m_data[0] = n;
                pdVectorArray3[n] = PdVector.copyNew((PdVector)pdVectorArray2[n]);
                for (n17 = 1; n17 < n18 + 3; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                for (n17 = 0; n17 < n18; ++n17) {
                    piVectorArray[piVector3.m_data[n17]].m_data[piVector5.m_data[n17]] = piVector.m_data[n17 + 2];
                }
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    int n19 = piVector4.m_data[n16];
                    if (n19 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n19;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n][n17].m_data[2] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16 + 2];
                        piVectorArrayArray[n][n17].m_data[4] = n16 == n18 ? -1 : piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n19].length;
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArrayArray[n19][i].m_data[0] != n) continue;
                        piVectorArrayArray[n19][i].m_data[5] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n19][i].m_data[6] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n19][i].m_data[7] = piVector.m_data[n16 + 2];
                        piVectorArrayArray[n19][i].m_data[8] = n16 == n18 ? -1 : piVector3.m_data[n16];
                    }
                }
                if (bl2) {
                    pdVectorArray[n] = pgElementSet.getVertexTexture(n);
                }
                for (n16 = 0; n16 < n3; ++n16) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n16);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pdVectorArrayArray[n16][n] = PdVector.copyNew((PdVector)pgVectorField.getVector(n));
                }
            } else {
                piVector = new PiVector(n18 + 2);
                piVector.m_data[0] = n;
                for (n17 = 1; n17 < n18 + 2; ++n17) {
                    piVector.m_data[n17] = n2++;
                }
                for (n17 = 0; n17 < n18; ++n17) {
                    piVectorArray[piVector3.m_data[n17]].m_data[piVector5.m_data[n17]] = piVector.m_data[n17 + 1];
                }
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    if (piVector4.m_data[n16] <= n) continue;
                    ++n17;
                }
                piVectorArrayArray[n] = new PiVector[n17];
                n17 = 0;
                for (n16 = 0; n16 < n18 + 1; ++n16) {
                    int n20 = piVector4.m_data[n16];
                    if (n20 > n) {
                        piVectorArrayArray[n][n17] = new PiVector(9);
                        piVectorArrayArray[n][n17].m_data[0] = n20;
                        piVectorArrayArray[n][n17].m_data[1] = piVector.m_data[n16];
                        piVectorArrayArray[n][n17].m_data[2] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n][n17].m_data[3] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n][n17].m_data[4] = n16 == n18 ? -1 : piVector3.m_data[n16];
                        ++n17;
                        continue;
                    }
                    n14 = piVectorArrayArray[n20].length;
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArrayArray[n20][i].m_data[0] != n) continue;
                        piVectorArrayArray[n20][i].m_data[5] = piVector.m_data[n16];
                        piVectorArrayArray[n20][i].m_data[6] = n16 == 0 ? -1 : piVector3.m_data[n16 - 1];
                        piVectorArrayArray[n20][i].m_data[7] = piVector.m_data[n16 + 1];
                        piVectorArrayArray[n20][i].m_data[8] = n16 == n18 ? -1 : piVector3.m_data[n16];
                    }
                }
            }
            piVectorArray[n11] = piVector;
            if (bl4) {
                Color color;
                n17 = 0;
                n16 = 0;
                n15 = 0;
                for (n13 = 0; n13 < n18; ++n13) {
                    Color color2 = pgElementSet.getElementColor(piVector3.m_data[n13]);
                    n17 += color2.getRed();
                    n16 += color2.getGreen();
                    n15 += color2.getBlue();
                }
                colorArray[n11] = color = new Color(n17 / n18, n16 / n18, n15 / n18);
            }
            if (bl5) {
                Color color;
                n17 = 0;
                n16 = 0;
                n15 = 0;
                for (int i = 0; i < n18; ++i) {
                    Color color3 = pgElementSet.getElementBackColor(piVector3.m_data[i]);
                    n17 += color3.getRed();
                    n16 += color3.getGreen();
                    n15 += color3.getBlue();
                }
                colorArray2[n11] = color = new Color(n17 / n18, n16 / n18, n15 / n18);
            }
            for (n17 = 0; n17 < n3; ++n17) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n17);
                if (pgVectorField.getBasedOn() != 1) continue;
                PdVector pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(piVector3.m_data[0]));
                for (n14 = 1; n14 < n18; ++n14) {
                    pdVector.add(pgVectorField.getVector(piVector3.m_data[n14]));
                }
                pdVector.multScalar(1.0 / (double)n18);
                pdVectorArrayArray[n17][n11] = pdVector;
            }
            ++n11;
        }
        for (n = 0; n < n7; ++n) {
            int n21;
            int n22;
            PiVector piVector6 = piVectorArray2[n];
            PiVector piVector7 = piVectorArray[n];
            int n23 = piVector6.getSize();
            PdVector[] pdVectorArray4 = new PdVector[n23];
            piVector = new PdVector[n23];
            PdVector pdVector = new PdVector(n23);
            pdVector.m_data[0] = (1.0 - d) * (1.0 - d2) + d * 1.0 / (double)n23;
            for (n22 = 0; n22 < n23; ++n22) {
                pdVectorArray4[n22] = pdVectorArray2[piVector6.m_data[n22]];
                piVector[n22] = PdVector.copyNew((PdVector)pdVectorArray4[n22]);
                piVector[n22].multScalar(pdVector.m_data[0]);
                pdVectorArray3[piVector7.m_data[n22]] = piVector[n22];
            }
            for (n22 = 1; n22 < n23; ++n22) {
                pdVector.m_data[n22] = n22 == 1 ? (1.0 - d) * d2 + d * 1.0 / (double)n23 : d * 1.0 / (double)n23;
                for (int i = 0; i < n23; ++i) {
                    piVector[i].blendBase((PdVector)piVector[i], pdVector.m_data[n22], pdVectorArray4[(i + n22) % n23]);
                }
            }
            if (bl) {
                int n24;
                PdVector pdVector2 = new PdVector(n23);
                PdVector pdVector3 = new PdVector(n23);
                PdVector pdVector4 = new PdVector(n23);
                for (n24 = 0; n24 < n23; ++n24) {
                    Color color = pgElementSet.getVertexColor(piVector6.m_data[n24]);
                    double d5 = color.getRed();
                    d4 = color.getGreen();
                    d3 = color.getBlue();
                    for (int i = 0; i < n23; ++i) {
                        int n25 = i;
                        pdVector2.m_data[n25] = pdVector2.m_data[n25] + d5 * pdVector.m_data[(i - n24 + n23) % n23];
                        int n26 = i;
                        pdVector3.m_data[n26] = pdVector3.m_data[n26] + d4 * pdVector.m_data[(i - n24 + n23) % n23];
                        int n27 = i;
                        pdVector4.m_data[n27] = pdVector4.m_data[n27] + d3 * pdVector.m_data[(i - n24 + n23) % n23];
                    }
                }
                for (n24 = 0; n24 < n23; ++n24) {
                    colorArray3[piVector7.m_data[n24]] = new Color((int)pdVector2.m_data[n24], (int)pdVector3.m_data[n24], (int)pdVector4.m_data[n24]);
                }
            }
            for (int i = 0; i < n3; ++i) {
                int n28;
                PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                if (pgVectorField.getBasedOn() != 0) continue;
                PdVector[] pdVectorArray5 = new PdVector[n23];
                PdVector[] pdVectorArray6 = new PdVector[n23];
                for (n28 = 0; n28 < n23; ++n28) {
                    pdVectorArray5[n28] = pgVectorField.getVector(piVector6.m_data[n28]);
                    pdVectorArray6[n28] = PdVector.copyNew((PdVector)pdVectorArray5[n28]);
                    pdVectorArray6[n28].multScalar(pdVector.m_data[0]);
                    pdVectorArrayArray[i][piVector7.m_data[n28]] = pdVectorArray6[n28];
                }
                for (n28 = 1; n28 < n23; ++n28) {
                    for (int j = 0; j < n23; ++j) {
                        pdVectorArray6[j].blendBase(pdVectorArray6[j], pdVector.m_data[n28], pdVectorArray5[(j + n28) % n23]);
                    }
                }
            }
            if (bl2) {
                int n29;
                PdVector[] pdVectorArray7 = new PdVector[n23];
                for (int i = 0; i < n23; ++i) {
                    pdVectorArray7[i] = pgElementSet.getVertexTextures()[piVector6.m_data[i]];
                }
                PdVector[] pdVectorArray8 = new PdVector[n23];
                for (n29 = 0; n29 < n23; ++n29) {
                    pdVectorArray8[n29] = PdVector.copyNew((PdVector)pdVectorArray7[n29]);
                    pdVectorArray8[n29].multScalar(pdVector.m_data[0]);
                    pdVectorArray[piVector7.m_data[n29]] = pdVectorArray8[n29];
                }
                for (n29 = 1; n29 < n23; ++n29) {
                    for (int i = 0; i < n23; ++i) {
                        pdVectorArray8[i].blendBase(pdVectorArray8[i], pdVector.m_data[n29], pdVectorArray7[(i + n29) % n23]);
                    }
                }
            }
            if (!bl3) continue;
            PdVector[] pdVectorArray9 = pgElementSet.getElementTexture(n);
            PdVector[] pdVectorArray10 = new PdVector[n23];
            for (n21 = 0; n21 < n23; ++n21) {
                pdVectorArray10[n21] = PdVector.copyNew((PdVector)pdVectorArray9[n21]);
                pdVectorArray10[n21].multScalar(pdVector.m_data[0]);
            }
            for (n21 = 1; n21 < n23; ++n21) {
                for (int i = 0; i < n23; ++i) {
                    pdVectorArray10[i].blendBase(pdVectorArray10[i], pdVector.m_data[n21], pdVectorArray9[(i + n21) % n23]);
                }
            }
            pgElementSet.setElementTexture(n, pdVectorArray10);
        }
        for (n = 0; n < n8; ++n) {
            int n30 = piVectorArrayArray[n].length;
            for (int i = 0; i < n30; ++i) {
                int n31;
                PdVector pdVector;
                PiVector piVector8 = piVectorArrayArray[n][i];
                if (piVector8.m_data[2] == -1 || piVector8.m_data[4] == -1) {
                    PgVectorField pgVectorField;
                    int n32;
                    pdVector = pdVectorArray2[n];
                    piVector = pdVectorArray2[piVector8.m_data[0]];
                    PdVector pdVector5 = PdVector.subNew((PdVector)piVector, (PdVector)pdVector);
                    double d6 = 1.0;
                    PiVector piVector9 = new PiVector(2);
                    if (piVector8.m_data[2] == -1) {
                        pdVectorArray3[piVector8.m_data[1]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[3]]);
                        piVector9.m_data[0] = piVector8.m_data[1];
                    } else {
                        pdVectorArray3[piVector8.m_data[3]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[1]]);
                        piVector9.m_data[0] = piVector8.m_data[3];
                    }
                    if (piVector8.m_data[6] == -1) {
                        pdVectorArray3[piVector8.m_data[5]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[7]]);
                        piVector9.m_data[1] = piVector8.m_data[5];
                    } else {
                        pdVectorArray3[piVector8.m_data[7]] = PdVector.copyNew((PdVector)pdVectorArray3[piVector8.m_data[5]]);
                        piVector9.m_data[1] = piVector8.m_data[7];
                    }
                    PdVector pdVector6 = new PdVector(2);
                    pdVector6.m_data[0] = 0.5 * d + d2 * (1.0 - d);
                    pdVector6.m_data[1] = 1.0 - 0.5 * d;
                    for (int j = 0; j < 2; ++j) {
                        pdVectorArray3[piVector9.m_data[j]].copy(pdVector5);
                        pdVectorArray3[piVector9.m_data[j]].multScalar(pdVector6.m_data[j]);
                        pdVectorArray3[piVector9.m_data[j]].add(pdVector);
                    }
                    if (bl) {
                        Color color = pgElementSet.getVertexColor(n);
                        Color color4 = pgElementSet.getVertexColor(piVector8.m_data[0]);
                        for (n32 = 0; n32 < 2; ++n32) {
                            d4 = (double)color.getRed() * (1.0 - pdVector6.m_data[n32] / d6) + (double)color4.getRed() * pdVector6.m_data[n32] / d6;
                            d3 = (double)color.getGreen() * (1.0 - pdVector6.m_data[n32] / d6) + (double)color4.getGreen() * pdVector6.m_data[n32] / d6;
                            double d7 = (double)color.getBlue() * (1.0 - pdVector6.m_data[n32] / d6) + (double)color4.getBlue() * pdVector6.m_data[n32] / d6;
                            colorArray3[piVector9.m_data[n32]] = new Color((int)d4, (int)d3, (int)d7);
                        }
                    }
                    for (int j = 0; j < n3; ++j) {
                        pgVectorField = pgElementSet.getVectorField(j);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        PdVector pdVector7 = pgVectorField.getVector(n);
                        PdVector pdVector8 = pgVectorField.getVector(piVector8.m_data[0]);
                        for (int k = 0; k < 2; ++k) {
                            pdVectorArrayArray[j][piVector9.m_data[k]] = PdVector.blendNew((double)(1.0 - pdVector6.m_data[k] / d6), (PdVector)pdVector7, (double)(pdVector6.m_data[k] / d6), (PdVector)pdVector8);
                        }
                    }
                    if (bl2) {
                        PdVector pdVector9 = pgElementSet.getVertexTextures()[n];
                        pgVectorField = pgElementSet.getVertexTextures()[piVector8.m_data[0]];
                        for (n32 = 0; n32 < 2; ++n32) {
                            pdVectorArray[piVector9.m_data[n32]] = PdVector.blendNew((double)(1.0 - pdVector6.m_data[n32] / d6), (PdVector)pdVector9, (double)(pdVector6.m_data[n32] / d6), (PdVector)pgVectorField);
                        }
                    }
                }
                pdVector = new PiVector(3);
                piVector = new PiVector(3);
                pdVector.m_data[0] = piVector8.m_data[3];
                pdVector.m_data[1] = piVector8.m_data[1];
                if (piVector8.m_data[2] == piVector8.m_data[6]) {
                    pdVector.m_data[2] = piVector8.m_data[5];
                    piVector.m_data[0] = piVector8.m_data[3];
                    piVector.m_data[1] = piVector8.m_data[5];
                    piVector.m_data[2] = piVector8.m_data[7];
                } else {
                    pdVector.m_data[2] = piVector8.m_data[7];
                    piVector.m_data[0] = piVector8.m_data[3];
                    piVector.m_data[1] = piVector8.m_data[7];
                    piVector.m_data[2] = piVector8.m_data[5];
                }
                piVectorArray[n11] = pdVector;
                piVectorArray[n11 + 1] = piVector;
                if (bl4) {
                    Color color;
                    int n33 = 0;
                    int n34 = 0;
                    n31 = 0;
                    int n35 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (piVector8.m_data[2 + 2 * j] == -1) continue;
                        Color color5 = pgElementSet.getElementColor(piVector8.m_data[2 + 2 * j]);
                        n33 += color5.getRed();
                        n34 += color5.getGreen();
                        n31 += color5.getBlue();
                        ++n35;
                    }
                    colorArray[n11] = color = new Color(n33 / n35, n34 / n35, n31 / n35);
                    colorArray[n11 + 1] = color;
                }
                if (bl5) {
                    Color color;
                    int n36 = 0;
                    int n37 = 0;
                    n31 = 0;
                    int n38 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (piVector8.m_data[2 + 2 * j] == -1) continue;
                        Color color6 = pgElementSet.getElementBackColor(piVector8.m_data[2 + 2 * j]);
                        n36 += color6.getRed();
                        n37 += color6.getGreen();
                        n31 += color6.getBlue();
                        ++n38;
                    }
                    colorArray2[n11] = color = new Color(n36 / n38, n37 / n38, n31 / n38);
                    colorArray2[n11 + 1] = color;
                }
                for (int j = 0; j < n3; ++j) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                    if (pgVectorField.getBasedOn() != 1) continue;
                    PdVector pdVector10 = new PdVector(pgVectorField.getDimOfVectors());
                    int n39 = 0;
                    for (int k = 0; k < 2; ++k) {
                        if (piVector8.m_data[2 + 2 * k] == -1) continue;
                        pdVector10.add(pgVectorField.getVector(piVector8.m_data[2 + 2 * k]));
                        ++n39;
                    }
                    pdVector10.multScalar(1.0 / (double)n39);
                    pdVectorArrayArray[j][n11] = pdVector10;
                    pdVectorArrayArray[j][n11 + 1] = pdVector10;
                }
                n11 += 2;
            }
        }
        pgElementSet.setNumVertices(n6);
        pgElementSet.setVertices(pdVectorArray3);
        pgElementSet.setNumElements(n9);
        pgElementSet.setElements(piVectorArray);
        if (bl3) {
            pgElementSet.assureElementTextures();
            PdVector[][] pdVectorArray11 = pgElementSet.getElementTextures();
            for (int i = n7; i < n9; ++i) {
                int n40 = pdVectorArray11[i].length;
                for (int j = 0; j < n40; ++j) {
                    pdVectorArray11[i][j].setConstant(0.0);
                }
            }
        }
        if (bl4) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementColor(i, colorArray[i]);
            }
        }
        if (bl5) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementBackColor(i, colorArray2[i]);
            }
        }
        if (bl) {
            for (int i = 0; i < n6; ++i) {
                pgElementSet.setVertexColor(i, colorArray3[i]);
            }
        }
        if (bl2) {
            pgElementSet.setVertexTextures(pdVectorArray);
        }
        for (int i = 0; i < n3; ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setNumVectors(n9);
            } else {
                pgVectorField.setNumVectors(n6);
            }
            pgVectorField.setVectors(pdVectorArrayArray[i]);
        }
        if (pgElementSet.hasBoundary()) {
            pgElementSet.removeBoundaries();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        pgElementSet.makeNeighbour();
    }

    public static void rhombiTruncate(PgElementSet pgElementSet, double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        pgElementSet.removeUnusedVertices();
        double d3 = 1.0 - d;
        double d4 = 1.0 - d2;
        int n6 = pgElementSet.getNumElements();
        int n7 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        boolean bl = pgElementSet.hasVertexColors();
        boolean bl2 = pgElementSet.hasElementColors();
        boolean bl3 = pgElementSet.hasElementBackColors();
        boolean bl4 = pgElementSet.hasVertexTextures();
        boolean bl5 = pgElementSet.hasElementTextures();
        int n8 = pgElementSet.getNumVectorFields();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n15 = 0;
        int n16 = n6 + n7;
        for (n9 = 0; n9 < n6; ++n9) {
            n11 = piVectorArray[n9].getSize();
            n15 += 2 * n11;
        }
        boolean[] blArray = new boolean[n7];
        boolean[] blArray2 = new boolean[n7];
        for (n5 = 0; n5 < n7; ++n5) {
            blArray[n5] = false;
            blArray2[n5] = false;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                blArray[pgBndPolygonArray[i].getVertexInd().m_data[0]] = true;
                blArray[pgBndPolygonArray[i].getVertexInd().m_data[pgBndPolygonArray[i].getVertexInd().getSize() - 1]] = true;
            }
        }
        for (n9 = 0; n9 < n6; ++n9) {
            n11 = piVectorArray[n9].getSize();
            for (n10 = 0; n10 < n11; ++n10) {
                if (piVectorArray2[n9].m_data[n10] == -1) {
                    n15 += 2;
                }
                if (piVectorArray2[n9].m_data[n10] < n9) {
                    ++n16;
                }
                if (blArray2[piVectorArray[n9].m_data[n10]]) continue;
                pgVertexStar.makeVertexStar(pgElementSet, piVectorArray[n9].m_data[n10], n9);
                if (pgVertexStar.getElement().getSize() == 1) {
                    blArray[piVectorArray[n9].m_data[n10]] = true;
                }
                blArray2[piVectorArray[n9].m_data[n10]] = true;
            }
        }
        for (n5 = 0; n5 < n7; ++n5) {
            blArray2[n5] = false;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            if (!blArray[n5]) continue;
            ++n15;
        }
        PdVector[] pdVectorArray2 = new PdVector[n15];
        PiVector[] piVectorArray3 = new PiVector[n16];
        Color[] colorArray = null;
        if (bl) {
            colorArray = new Color[n15];
        }
        PdVector[] pdVectorArray3 = null;
        if (bl4) {
            pdVectorArray3 = new PdVector[n15];
        }
        Color[] colorArray2 = null;
        if (bl2) {
            colorArray2 = new Color[n16];
            for (n9 = 0; n9 < n6; ++n9) {
                colorArray2[n9] = pgElementSet.getElementColor(n9);
            }
        }
        Color[] colorArray3 = null;
        if (bl3) {
            colorArray3 = new Color[n16];
            for (n9 = 0; n9 < n6; ++n9) {
                colorArray3[n9] = pgElementSet.getElementBackColor(n9);
            }
        }
        PdVector[][] pdVectorArray4 = null;
        if (bl5) {
            pdVectorArray4 = new PdVector[n16][];
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[n8];
        for (int i = 0; i < n8; ++i) {
            if (pgElementSet.getVectorField(i).getBasedOn() == 0) {
                pgVectorFieldArray[i] = new PgVectorField(0);
                pgVectorFieldArray[i].setNumVectors(n15);
                continue;
            }
            pgVectorFieldArray[i] = new PgVectorField(1);
            pgVectorFieldArray[i].setNumVectors(n16);
        }
        PdVector[] pdVectorArray5 = new PdVector[n8];
        for (n4 = 0; n4 < n8; ++n4) {
            pdVectorArray5[n4] = new PdVector(pgElementSet.getVectorField(n4).getDimOfVectors());
        }
        n4 = 0;
        int n17 = n6 + n7;
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfTextures());
        PdVector pdVector3 = new PdVector(pgElementSet.getDimOfTextures());
        for (n9 = 0; n9 < n6; ++n9) {
            n11 = piVectorArray[n9].getSize();
            piVectorArray3[n9] = new PiVector(2 * n11);
            pdVector.copy(pdVectorArray[piVectorArray[n9].m_data[0]]);
            for (n10 = 1; n10 < n11; ++n10) {
                pdVector.add(pdVectorArray[piVectorArray[n9].m_data[n10]]);
            }
            pdVector.multScalar(1.0 / (double)n11);
            if (bl4) {
                pdVector2.copy(pgElementSet.getVertexTexture(piVectorArray[n9].m_data[0]));
                for (n10 = 1; n10 < n11; ++n10) {
                    pdVector2.add(pgElementSet.getVertexTexture(piVectorArray[n9].m_data[n10]));
                }
                pdVector2.multScalar(1.0 / (double)n11);
            }
            if (bl5) {
                pdVector3.copy(pgElementSet.getElementTexture(n9)[0]);
                for (n10 = 1; n10 < n11; ++n10) {
                    pdVector3.add(pgElementSet.getElementTexture(n9)[n10]);
                }
                pdVector3.multScalar(1.0 / (double)n11);
                pdVectorArray4[n9] = new PdVector[2 * n11];
            }
            for (n3 = 0; n3 < n8; ++n3) {
                if (pgVectorFieldArray[n3].getBasedOn() == 0) {
                    pdVectorArray5[n3].copy(pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[0]));
                    for (n10 = 1; n10 < n11; ++n10) {
                        pdVectorArray5[n3].add(pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[n10]));
                    }
                    pdVectorArray5[n3].multScalar(1.0 / (double)n11);
                    continue;
                }
                pgVectorFieldArray[n3].setVector(n9, PdVector.copyNew((PdVector)pgElementSet.getVectorField(n3).getVector(n9)));
            }
            for (n10 = 0; n10 < n11; ++n10) {
                piVectorArray3[n9].m_data[2 * n10] = n4;
                piVectorArray3[n9].m_data[2 * n10 + 1] = n4 + 1;
                pdVectorArray2[n4] = PdVector.blendNew((double)d2, (PdVector)pdVectorArray[piVectorArray[n9].m_data[(n10 + 1) % n11]], (double)d4, (PdVector)pdVectorArray[piVectorArray[n9].m_data[n10]]);
                pdVectorArray2[n4 + 1] = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[piVectorArray[n9].m_data[(n10 + 1) % n11]], (double)d2, (PdVector)pdVectorArray[piVectorArray[n9].m_data[n10]]);
                pdVectorArray2[n4].blend(d3, pdVectorArray2[n4], d, pdVector);
                pdVectorArray2[n4 + 1].blend(d3, pdVectorArray2[n4 + 1], d, pdVector);
                if (bl) {
                    colorArray[n4] = pgElementSet.getVertexColor(piVectorArray[n9].m_data[n10]);
                    colorArray[n4 + 1] = pgElementSet.getVertexColor(piVectorArray[n9].m_data[(n10 + 1) % n11]);
                }
                if (bl4) {
                    pdVectorArray3[n4] = PdVector.blendNew((double)d2, (PdVector)pgElementSet.getVertexTexture(piVectorArray[n9].m_data[(n10 + 1) % n11]), (double)d4, (PdVector)pgElementSet.getVertexTexture(piVectorArray[n9].m_data[n10]));
                    pdVectorArray3[n4 + 1] = PdVector.blendNew((double)d4, (PdVector)pgElementSet.getVertexTexture(piVectorArray[n9].m_data[(n10 + 1) % n11]), (double)d2, (PdVector)pgElementSet.getVertexTexture(piVectorArray[n9].m_data[n10]));
                    pdVectorArray3[n4].blend(d3, pdVectorArray3[n4], d, pdVector2);
                    pdVectorArray3[n4 + 1].blend(d3, pdVectorArray3[n4 + 1], d, pdVector2);
                }
                if (bl5) {
                    pdVectorArray4[n9][2 * n10] = PdVector.blendNew((double)d2, (PdVector)pgElementSet.getElementTexture(n9)[(n10 + 1) % n11], (double)d4, (PdVector)pgElementSet.getElementTexture(n9)[n10]);
                    pdVectorArray4[n9][2 * n10 + 1] = PdVector.blendNew((double)d4, (PdVector)pgElementSet.getElementTexture(n9)[(n10 + 1) % n11], (double)d2, (PdVector)pgElementSet.getElementTexture(n9)[n10]);
                    pdVectorArray4[n9][2 * n10].blend(d3, pdVectorArray4[n9][2 * n10], d, pdVector3);
                    pdVectorArray4[n9][2 * n10 + 1].blend(d3, pdVectorArray4[n9][2 * n10 + 1], d, pdVector3);
                }
                for (n3 = 0; n3 < n8; ++n3) {
                    if (pgVectorFieldArray[n3].getBasedOn() != 0) continue;
                    pgVectorFieldArray[n3].setVector(n4, PdVector.blendNew((double)d2, (PdVector)pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[(n10 + 1) % n11]), (double)d4, (PdVector)pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[n10])));
                    pgVectorFieldArray[n3].setVector(n4 + 1, PdVector.blendNew((double)d4, (PdVector)pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[(n10 + 1) % n11]), (double)d2, (PdVector)pgElementSet.getVectorField(n3).getVector(piVectorArray[n9].m_data[n10])));
                    pgVectorFieldArray[n3].setVector(n4, PdVector.blendNew((double)d3, (PdVector)pgVectorFieldArray[n3].getVector(n4), (double)d, (PdVector)pdVectorArray5[n3]));
                    pgVectorFieldArray[n3].setVector(n4 + 1, PdVector.blendNew((double)d3, (PdVector)pgVectorFieldArray[n3].getVector(n4 + 1), (double)d, (PdVector)pdVectorArray5[n3]));
                }
                n4 += 2;
            }
        }
        for (n9 = 0; n9 < n6; ++n9) {
            n11 = piVectorArray[n9].getSize();
            for (n10 = 0; n10 < n11; ++n10) {
                Color color;
                n12 = piVectorArray[n9].m_data[n10];
                if (blArray2[n12]) continue;
                pgVertexStar.makeVertexStar(pgElementSet, n12, n9);
                PiVector piVector = pgVertexStar.getLink();
                n13 = piVector.getSize();
                piVectorArray3[n6 + n12] = blArray[n12] ? new PiVector(2 * n13 + 1) : new PiVector(2 * n13);
                if (bl5) {
                    if (blArray[n12]) {
                        pdVectorArray4[n6 + n12] = new PdVector[2 * n13 + 1];
                        for (n14 = 0; n14 < 2 * n13 + 1; ++n14) {
                            pdVectorArray4[n6 + n12][n14] = new PdVector(pgElementSet.getDimOfTextures());
                        }
                    } else {
                        pdVectorArray4[n6 + n12] = new PdVector[2 * n13];
                        for (n14 = 0; n14 < 2 * n13; ++n14) {
                            pdVectorArray4[n6 + n12][n14] = new PdVector(pgElementSet.getDimOfTextures());
                        }
                    }
                }
                PiVector piVector2 = pgVertexStar.getElement();
                PiVector piVector3 = pgVertexStar.getVertexLocInd();
                n13 = piVector2.getSize();
                for (n14 = 0; n14 < n13; ++n14) {
                    int n18 = piVectorArray[piVector2.m_data[n14]].getSize();
                    if (piVector.m_data[n14] == piVectorArray[piVector2.m_data[n14]].m_data[(piVector3.m_data[n14] + 1) % n18]) {
                        piVectorArray3[n6 + n12].m_data[n14 * 2] = piVectorArray3[piVector2.m_data[n14]].m_data[piVector3.m_data[n14] * 2];
                        piVectorArray3[n6 + n12].m_data[n14 * 2 + 1] = piVectorArray3[piVector2.m_data[n14]].m_data[(piVector3.m_data[n14] * 2 + 2 * n18 - 1) % (2 * n18)];
                        continue;
                    }
                    piVectorArray3[n6 + n12].m_data[n14 * 2 + 1] = piVectorArray3[piVector2.m_data[n14]].m_data[piVector3.m_data[n14] * 2];
                    piVectorArray3[n6 + n12].m_data[n14 * 2] = piVectorArray3[piVector2.m_data[n14]].m_data[(piVector3.m_data[n14] * 2 + 2 * n18 - 1) % (2 * n18)];
                }
                if (!pgVertexStar.isClosed()) {
                    pdVectorArray2[n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pdVectorArray[piVector.m_data[n13]], (double)(d4 * d3 + d * 0.5), (PdVector)pdVectorArray[n12]);
                    piVectorArray3[n6 + n12].m_data[2 * n13] = n4;
                    if (bl4) {
                        pdVectorArray3[n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(piVector.m_data[n13]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(n12));
                    }
                    for (n3 = 0; n3 < n8; ++n3) {
                        if (pgVectorFieldArray[n3].getBasedOn() != 0) continue;
                        pgVectorFieldArray[n3].setVector(n4, PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(piVector.m_data[n13]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(n12)));
                    }
                    ++n4;
                    if (blArray[n12]) {
                        pdVectorArray2[n4] = PdVector.copyNew((PdVector)pdVectorArray[n12]);
                        piVectorArray3[n6 + n12].m_data[2 * n13 + 1] = n4;
                        if (bl) {
                            colorArray[n4] = pgElementSet.getVertexColor(n12);
                        }
                        if (bl4) {
                            pdVectorArray3[n4] = PdVector.copyNew((PdVector)pgElementSet.getVertexTexture(n12));
                        }
                        for (n3 = 0; n3 < n8; ++n3) {
                            if (pgVectorFieldArray[n3].getBasedOn() != 0) continue;
                            pgVectorFieldArray[n3].setVector(n4, pgElementSet.getVectorField(n3).getVector(n12));
                        }
                        pdVectorArray2[++n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pdVectorArray[piVector.m_data[0]], (double)(d4 * d3 + d * 0.5), (PdVector)pdVectorArray[n12]);
                        piVectorArray3[n6 + n12].m_data[2 * n13 + 2] = n4;
                        if (bl4) {
                            pdVectorArray3[n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(piVector.m_data[0]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(n12));
                        }
                        for (n3 = 0; n3 < n8; ++n3) {
                            if (pgVectorFieldArray[n3].getBasedOn() != 0) continue;
                            pgVectorFieldArray[n3].setVector(n4, PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(piVector.m_data[0]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(n12)));
                        }
                        ++n4;
                    } else {
                        pdVectorArray2[n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pdVectorArray[piVector.m_data[0]], (double)(d4 * d3 + d * 0.5), (PdVector)pdVectorArray[n12]);
                        piVectorArray3[n6 + n12].m_data[2 * n13 + 1] = n4;
                        if (bl4) {
                            pdVectorArray3[n4] = PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(piVector.m_data[0]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVertexTexture(n12));
                        }
                        for (n3 = 0; n3 < n8; ++n3) {
                            if (pgVectorFieldArray[n3].getBasedOn() != 0) continue;
                            pgVectorFieldArray[n3].setVector(n4, PdVector.blendNew((double)(d2 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(piVector.m_data[0]), (double)(d4 * d3 + d * 0.5), (PdVector)pgElementSet.getVectorField(n3).getVector(n12)));
                        }
                        ++n4;
                    }
                }
                if (bl2) {
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    for (n14 = 0; n14 < n13; ++n14) {
                        color = pgElementSet.getElementColor(piVector2.m_data[n14]);
                        n3 += color.getRed();
                        n2 += color.getGreen();
                        n += color.getBlue();
                    }
                    colorArray2[n6 + n12] = new Color(n3 / n13, n2 / n13, n / n13);
                }
                if (bl3) {
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    for (n14 = 0; n14 < n13; ++n14) {
                        color = pgElementSet.getElementBackColor(piVector2.m_data[n14]);
                        n3 += color.getRed();
                        n2 += color.getGreen();
                        n += color.getBlue();
                    }
                    colorArray3[n6 + n12] = new Color(n3 / n13, n2 / n13, n / n13);
                }
                for (n3 = 0; n3 < n8; ++n3) {
                    if (pgVectorFieldArray[n3].getBasedOn() != 1) continue;
                    pgVectorFieldArray[n3].setVector(n6 + n12, PdVector.copyNew((PdVector)pgElementSet.getVectorField(n3).getVector(piVector2.m_data[0])));
                    for (n14 = 1; n14 < n13; ++n14) {
                        pgVectorFieldArray[n3].getVector(n6 + n12).add(pgElementSet.getVectorField(n3).getVector(piVector2.m_data[n14]));
                    }
                    pgVectorFieldArray[n3].getVector(n6 + n12).multScalar(1.0 / (double)n13);
                }
                blArray2[n12] = true;
            }
        }
        n3 = 0;
        n2 = 0;
        for (n9 = 0; n9 < n6; ++n9) {
            n11 = piVectorArray[n9].getSize();
            for (n10 = 0; n10 < n11; ++n10) {
                if (piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11] > n9) continue;
                piVectorArray3[n17] = new PiVector(4);
                n12 = piVectorArray[n9].m_data[(n10 + 1) % n11];
                n3 = piVectorArray3[n6 + n12].getIndexOf(piVectorArray3[n9].m_data[2 * n10 + 1]);
                piVectorArray3[n17].m_data[0] = piVectorArray3[n6 + n12].m_data[(n3 + 1) % (n2 = piVectorArray3[n6 + n12].getSize())] == piVectorArray3[n9].m_data[(2 * n10 + 2) % (2 * n11)] ? piVectorArray3[n6 + n12].m_data[(n3 + n2 - 1) % n2] : piVectorArray3[n6 + n12].m_data[(n3 + 1) % n2];
                piVectorArray3[n17].m_data[1] = piVectorArray3[n9].m_data[2 * n10 + 1];
                piVectorArray3[n17].m_data[2] = piVectorArray3[n9].m_data[2 * n10];
                n12 = piVectorArray[n9].m_data[n10];
                n3 = piVectorArray3[n6 + n12].getIndexOf(piVectorArray3[n9].m_data[2 * n10]);
                n2 = piVectorArray3[n6 + n12].getSize();
                piVectorArray3[n17].m_data[3] = piVectorArray3[n6 + n12].m_data[(n3 + 1) % n2] == piVectorArray3[n9].m_data[(2 * n10 + 2 * n11 - 1) % (2 * n11)] ? piVectorArray3[n6 + n12].m_data[(n3 + n2 - 1) % n2] : piVectorArray3[n6 + n12].m_data[(n3 + 1) % n2];
                if (bl2) {
                    colorArray2[n17] = piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11] == -1 ? pgElementSet.getElementColor(n9) : PdColor.blend((double)0.5, (Color)pgElementSet.getElementColor(n9), (double)0.5, (Color)pgElementSet.getElementColor(piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11]));
                }
                if (bl3) {
                    colorArray3[n17] = piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11] == -1 ? pgElementSet.getElementBackColor(n9) : PdColor.blend((double)0.5, (Color)pgElementSet.getElementBackColor(n9), (double)0.5, (Color)pgElementSet.getElementBackColor(piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11]));
                }
                for (n = 0; n < n8; ++n) {
                    if (pgVectorFieldArray[n].getBasedOn() != 1) continue;
                    if (piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11] == -1) {
                        pgVectorFieldArray[n].setVector(n17, PdVector.copyNew((PdVector)pgElementSet.getVectorField(n).getVector(n9)));
                        continue;
                    }
                    pgVectorFieldArray[n].setVector(n17, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVectorField(n).getVector(n9), (double)0.5, (PdVector)pgElementSet.getVectorField(n).getVector(piVectorArray2[n9].m_data[(n10 + n11 - 1) % n11])));
                }
                if (bl5) {
                    pdVectorArray4[n17] = new PdVector[4];
                    for (n = 0; n < 4; ++n) {
                        pdVectorArray4[n17][n] = new PdVector(pgElementSet.getDimOfTextures());
                    }
                }
                ++n17;
            }
        }
        pgElementSet.setNumVertices(n15);
        pgElementSet.setVertices(pdVectorArray2);
        pgElementSet.setNumElements(n16);
        pgElementSet.setElements(piVectorArray3);
        pgElementSet.makeNeighbour();
        if (bl) {
            pgElementSet.setVertexColors(colorArray);
        }
        if (bl4) {
            pgElementSet.setVertexTextures(pdVectorArray3);
        }
        if (bl2) {
            pgElementSet.setElementColors(colorArray2);
        }
        if (bl3) {
            pgElementSet.setElementBackColors(colorArray3);
        }
        if (bl5) {
            pgElementSet.setElementTextures(pdVectorArray4);
        }
        if (pgElementSet.getBoundaries() != null) {
            pgElementSet.removeBoundaries();
        }
        pgElementSet.removeAllVectorFields();
        for (n = 0; n < n8; ++n) {
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgElementSet.addVectorField(pgVectorFieldArray[n]);
        }
        pgElementSet.makeVertexNormals();
        pgElementSet.makeElementNormals();
    }

    public static void punch(PgElementSet pgElementSet, double d) {
        int n;
        int n2;
        PdVector[][] pdVectorArrayArray;
        int n3;
        int n4;
        double d2 = 1.0 - d;
        int n5 = pgElementSet.getNumElements();
        int n6 = pgElementSet.getNumVertices();
        int n7 = 0;
        int n8 = n6;
        PiVector[] piVectorArray = new PiVector[n5];
        for (int i = 0; i < n5; ++i) {
            piVectorArray[i] = PiVector.copyNew((PiVector)pgElementSet.getElement(i));
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        for (int i = 0; i < n5; ++i) {
            n7 += piVectorArray[i].getSize();
        }
        n8 += n7;
        PiVector[] piVectorArray2 = new PiVector[n7];
        int n9 = n6;
        int n10 = 0;
        int n11 = pgElementSet.getNumVectorFields();
        PdVector[][] pdVectorArrayArray2 = new PdVector[n11][];
        for (int i = 0; i < n11; ++i) {
            int n12;
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            PdVector[] pdVectorArray2 = pgVectorField.getVectors();
            if (pgVectorField.getBasedOn() == 1) {
                n10 = 0;
                pdVectorArrayArray2[i] = new PdVector[n7];
                for (int j = 0; j < n5; ++j) {
                    n4 = piVectorArray[j].getSize();
                    for (n12 = 0; n12 < n4; ++n12) {
                        pdVectorArrayArray2[i][n10] = PdVector.copyNew((PdVector)pdVectorArray2[j]);
                        ++n10;
                    }
                }
                continue;
            }
            PdVector pdVector = new PdVector(pgVectorField.getDimOfVectors());
            n9 = n6;
            pdVectorArrayArray2[i] = new PdVector[n8];
            for (n12 = 0; n12 < n6; ++n12) {
                pdVectorArrayArray2[i][n12] = PdVector.copyNew((PdVector)pgVectorField.getVector(n12));
            }
            for (n12 = 0; n12 < n5; ++n12) {
                PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pdVectorArray2, (int[])piVectorArray[i].m_data);
                n4 = piVectorArray[n12].getSize();
                for (int j = 0; j < n4; ++j) {
                    pdVectorArrayArray2[i][n9 + j] = PdVector.blendNew((double)d, (PdVector)pdVectorArray2[piVectorArray[n12].m_data[j]], (double)d2, (PdVector)pdVector);
                }
                n9 += n4;
            }
        }
        pgElementSet.setNumVertices(n8);
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        n9 = n6;
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pdVectorArray, (int[])piVectorArray[n3].m_data);
            n4 = piVectorArray[n3].getSize();
            for (int i = 0; i < n4; ++i) {
                pgElementSet.setVertex(n9 + i, PdVector.blendNew((double)d, (PdVector)pdVectorArray[piVectorArray[n3].m_data[i]], (double)d2, (PdVector)pdVector));
                piVectorArray2[n10] = new PiVector(piVectorArray[n3].m_data[i], piVectorArray[n3].m_data[(i + 1) % n4], n9 + (i + 1) % n4, n9 + i);
                ++n10;
            }
            n9 += n4;
        }
        if (pgElementSet.hasVertexColors()) {
            n9 = n6;
            for (n3 = 0; n3 < n5; ++n3) {
                n4 = piVectorArray[n3].getSize();
                for (int i = 0; i < n4; ++i) {
                    pgElementSet.setVertexColor(n9, pgElementSet.getVertexColor(piVectorArray[n3].m_data[i]));
                    ++n9;
                }
            }
        }
        if (pgElementSet.hasVertexTextures()) {
            double d3;
            double d4;
            if (d > 1.0) {
                d4 = 1.0 / d;
                d3 = 1.0 - d4;
            } else {
                d4 = d;
                d3 = d2;
            }
            PdVector[] pdVectorArray3 = pgElementSet.getVertexTextures();
            pdVectorArrayArray = new PdVector(pgElementSet.getDimOfTextures());
            n9 = n6;
            for (int i = 0; i < n5; ++i) {
                PgGeometry.getCenterOfElement((PdVector)pdVectorArrayArray, (PdVector[])pdVectorArray3, (int[])piVectorArray[i].m_data);
                n4 = piVectorArray[i].getSize();
                for (n2 = 0; n2 < n4; ++n2) {
                    pdVectorArray3[n9 + n2] = PdVector.blendNew((double)d4, (PdVector)pdVectorArray3[piVectorArray[i].m_data[n2]], (double)d3, (PdVector)pdVectorArrayArray);
                }
                n9 += n4;
            }
        }
        n10 = 0;
        if (pgElementSet.hasElementTextures()) {
            double d5;
            double d6;
            if (d > 1.0) {
                d6 = 1.0 / d;
                d5 = 1.0 - d6;
            } else {
                d6 = d;
                d5 = d2;
            }
            PdVector[][] pdVectorArray4 = pgElementSet.getElementTextures();
            pdVectorArrayArray = new PdVector[n7][];
            PdVector pdVector2 = new PdVector(pgElementSet.getDimOfTextures());
            for (n2 = 0; n2 < n5; ++n2) {
                int n13;
                pdVector2.copy(pdVectorArray4[n2][0]);
                int n14 = piVectorArray[n2].getSize();
                for (n13 = 1; n13 < n14; ++n13) {
                    pdVector2.add(pdVectorArray4[n2][n13]);
                }
                pdVector2.multScalar(1.0 / (double)n14);
                for (n13 = 0; n13 < n14; ++n13) {
                    pdVectorArrayArray[n10] = new PdVector[4];
                    if (d > 1.0) {
                        pdVectorArrayArray[n10][0] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray4[n2][n13], (double)d5, (PdVector)pdVector2);
                        pdVectorArrayArray[n10][1] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray4[n2][(n13 + 1) % n14], (double)d5, (PdVector)pdVector2);
                        pdVectorArrayArray[n10][2] = PdVector.copyNew((PdVector)pdVectorArray4[n2][(n13 + 1) % n14]);
                        pdVectorArrayArray[n10][3] = PdVector.copyNew((PdVector)pdVectorArray4[n2][n13]);
                    } else {
                        pdVectorArrayArray[n10][0] = PdVector.copyNew((PdVector)pdVectorArray4[n2][n13]);
                        pdVectorArrayArray[n10][1] = PdVector.copyNew((PdVector)pdVectorArray4[n2][(n13 + 1) % n14]);
                        pdVectorArrayArray[n10][2] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray4[n2][(n13 + 1) % n14], (double)d5, (PdVector)pdVector2);
                        pdVectorArrayArray[n10][3] = PdVector.blendNew((double)d6, (PdVector)pdVectorArray4[n2][n13], (double)d5, (PdVector)pdVector2);
                    }
                    ++n10;
                }
            }
            pgElementSet.setDimOfElements(4);
            pgElementSet.setNumElements(n7);
            pgElementSet.setElements(piVectorArray2);
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        } else {
            pgElementSet.setDimOfElements(4);
            pgElementSet.setNumElements(n7);
            pgElementSet.setElements(piVectorArray2);
        }
        for (n = 0; n < n11; ++n) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setNumVectors(n7);
            } else {
                pgVectorField.setNumVectors(n8);
            }
            pgVectorField.setVectors(pdVectorArrayArray2[n]);
        }
        if (pgElementSet.hasElementColors()) {
            n = n7 - 1;
            for (int i = n5 - 1; i >= 0; --i) {
                n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    pgElementSet.setElementColor(n, pgElementSet.getElementColor(i));
                    --n;
                }
            }
        }
        if (pgElementSet.hasElementBackColors()) {
            n = n7 - 1;
            for (int i = n5 - 1; i >= 0; --i) {
                n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    pgElementSet.setElementBackColor(n, pgElementSet.getElementBackColor(i));
                    --n;
                }
            }
        }
        pgElementSet.makeNeighbour();
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                if (pgBndPolygonArray[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
    }

    public static void dual(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        pgElementSet.removeUnusedVertices();
        PuCleanMesh.removeDegenerateElements((PgElementSet)pgElementSet);
        PwCleanMesh.splitNonManifoldVertices(pgElementSet);
        int n12 = pgElementSet.getNumVertices();
        int n13 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        Vector<PiVector> vector = new Vector<PiVector>();
        for (n11 = 0; n11 < n13; ++n11) {
            vector.addElement(new PiVector());
        }
        n11 = n13;
        PiVector[] piVectorArray3 = new PiVector[n12];
        PiVector[] piVectorArray4 = new PiVector[n12];
        boolean[] blArray = new boolean[n12];
        for (int i = 0; i < n12; ++i) {
            blArray[i] = false;
            pgElementSet.clearTagVertex(i, 1);
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n14 = pgElementSet.getNumBoundaries();
            for (n10 = 0; n10 < n14; ++n10) {
                n9 = pgBndPolygonArray[n10].getNumVertices();
                if (pgBndPolygonArray[n10].getVertexInd().m_data[n9 - 1] == pgBndPolygonArray[n10].getVertexInd().m_data[0]) continue;
                pgElementSet.setTagVertex(pgBndPolygonArray[n10].getVertexInd().m_data[n9 - 1], 1);
                pgElementSet.setTagVertex(pgBndPolygonArray[n10].getVertexInd().m_data[0], 1);
            }
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        for (n9 = 0; n9 < n13; ++n9) {
            PiVector piVector = piVectorArray[n9];
            n10 = piVector.getSize();
            ((PiVector)vector.elementAt(n9)).setSize(n10);
            ((PiVector)vector.elementAt(n9)).copy(piVector);
            for (n8 = 0; n8 < n10; ++n8) {
                if (blArray[piVector.m_data[n8]]) continue;
                pgVertexStar.makeVertexStar(pgElementSet, piVector.m_data[n8], n9);
                if (pgVertexStar.isClosed()) {
                    piVectorArray3[piVector.m_data[n8]] = PiVector.copyNew((PiVector)pgVertexStar.getElement());
                    piVectorArray4[piVector.m_data[n8]] = new PiVector(piVectorArray3[piVector.m_data[n8]].getSize());
                } else {
                    PiVector piVector2 = pgVertexStar.getElement();
                    int n15 = pgVertexStar.getSize() + 2;
                    piVectorArray3[piVector.m_data[n8]] = new PiVector(n15);
                    piVectorArray4[piVector.m_data[n8]] = new PiVector(n15);
                    for (int i = 0; i < n15 - 2; ++i) {
                        piVectorArray3[piVector.m_data[n8]].m_data[i + 1] = piVector2.m_data[i];
                    }
                    PiVector piVector3 = pgVertexStar.getLink();
                    piVectorArray3[piVector.m_data[n8]].m_data[0] = -1 - piVector3.m_data[0];
                    piVectorArray3[piVector.m_data[n8]].m_data[n15 - 1] = -1 - piVector3.m_data[n15 - 2];
                    piVectorArray4[piVector.m_data[n8]].m_data[n15 - 2] = -1;
                }
                blArray[piVector.m_data[n8]] = true;
            }
            for (n8 = 0; n8 < n10; ++n8) {
                int n16;
                PiVector piVector4;
                int n17 = piVectorArray2[n9].m_data[n8];
                if (n17 > n9) {
                    piVector4 = piVectorArray3[piVector.m_data[(n8 + 1) % n10]];
                    n16 = piVector4.getSize();
                    for (n7 = 0; n7 < n16; ++n7) {
                        if ((piVector4.m_data[(n7 + 1) % n16] != n9 || piVector4.m_data[(n7 + 2) % n16] != n17) && (piVector4.m_data[(n7 + 2) % n16] != n9 || piVector4.m_data[(n7 + 1) % n16] != n17)) continue;
                        piVectorArray4[piVector.m_data[(n8 + 1) % n10]].m_data[n7] = piVector.m_data[(n8 + 2) % n10];
                        break;
                    }
                    piVector4 = piVectorArray3[piVector.m_data[(n8 + 2) % n10]];
                    n16 = piVector4.getSize();
                    for (n7 = 0; n7 < n16; ++n7) {
                        if ((piVector4.m_data[(n7 + 1) % n16] != n9 || piVector4.m_data[(n7 + 2) % n16] != n17) && (piVector4.m_data[(n7 + 2) % n16] != n9 || piVector4.m_data[(n7 + 1) % n16] != n17)) continue;
                        piVectorArray4[piVector.m_data[(n8 + 2) % n10]].m_data[n7] = piVector.m_data[(n8 + 1) % n10];
                        break;
                    }
                }
                if (n17 != -1) continue;
                vector.addElement(new PiVector(piVector.m_data[(n8 + 1) % n10], piVector.m_data[(n8 + 2) % n10], n9));
                piVector4 = piVectorArray3[piVector.m_data[(n8 + 1) % n10]];
                n16 = piVector4.getSize();
                if (piVector4.m_data[0] == -1 - piVector.m_data[(n8 + 2) % n10]) {
                    piVector4.m_data[0] = n11;
                    piVectorArray4[piVector.m_data[(n8 + 1) % n10]].m_data[n16 - 1] = piVector.m_data[(n8 + 2) % n10];
                } else {
                    piVector4.m_data[n16 - 1] = n11;
                    piVectorArray4[piVector.m_data[(n8 + 1) % n10]].m_data[n16 - 3] = piVector.m_data[(n8 + 2) % n10];
                }
                piVector4 = piVectorArray3[piVector.m_data[(n8 + 2) % n10]];
                n16 = piVector4.getSize();
                if (piVector4.m_data[0] == -1 - piVector.m_data[(n8 + 1) % n10]) {
                    piVector4.m_data[0] = n11;
                    piVectorArray4[piVector.m_data[(n8 + 2) % n10]].m_data[n16 - 1] = piVector.m_data[(n8 + 1) % n10];
                } else {
                    piVector4.m_data[n16 - 1] = n11;
                    piVectorArray4[piVector.m_data[(n8 + 2) % n10]].m_data[n16 - 3] = piVector.m_data[(n8 + 1) % n10];
                }
                ++n11;
            }
        }
        for (n9 = 0; n9 < n12; ++n9) {
            if ((piVectorArray4[n9].getSize() != 3 || piVectorArray4[n9].m_data[1] != -1) && !pgElementSet.hasTagVertex(n9, 1)) continue;
            n10 = piVectorArray3[n9].getSize() + 1;
            piVectorArray3[n9].setSize(n10);
            piVectorArray3[n9].m_data[n10 - 1] = n11;
            piVectorArray4[n9].setSize(n10);
            piVectorArray4[n9].m_data[n10 - 1] = piVectorArray4[n9].m_data[n10 - 2];
            piVectorArray4[n9].m_data[n10 - 2] = -1;
            n8 = piVectorArray3[n9].m_data[0];
            int n18 = piVectorArray3[n9].m_data[n10 - 2];
            int n19 = ((PiVector)vector.elementAt((int)n8)).m_data[0];
            int n20 = ((PiVector)vector.elementAt((int)n8)).m_data[1];
            n7 = ((PiVector)vector.elementAt((int)n18)).m_data[0];
            n6 = ((PiVector)vector.elementAt((int)n18)).m_data[1];
            int n21 = n19 == n7 || n19 == n6 ? n19 : n20;
            vector.addElement(new PiVector(n21, ((PiVector)vector.elementAt((int)n8)).m_data[2]));
            ++n11;
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector[] pdVectorArray2 = new PdVector[n11];
        for (n5 = 0; n5 < n13; ++n5) {
            PiVector piVector = (PiVector)vector.elementAt(n5);
            int n22 = piVector.getSize();
            pdVectorArray2[n5] = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[0]]);
            for (int i = 1; i < n22; ++i) {
                pdVectorArray2[n5].add(pdVectorArray[piVector.m_data[i]]);
            }
            pdVectorArray2[n5].multScalar(1.0 / (double)n22);
        }
        for (n5 = n13; n5 < n11; ++n5) {
            PiVector piVector = (PiVector)vector.elementAt(n5);
            pdVectorArray2[n5] = piVector.getSize() == 3 ? PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[1]]) : PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[0]]);
        }
        n5 = pgElementSet.hasVertexColors() ? 1 : 0;
        boolean bl = pgElementSet.isShowingVertexColors();
        Color[] colorArray = null;
        if (n5 != 0) {
            colorArray = pgElementSet.getVertexColors();
        }
        n7 = pgElementSet.hasElementColors();
        n6 = pgElementSet.isShowingElementColors();
        Color[] colorArray2 = null;
        if (n7 != 0) {
            colorArray2 = new Color[n11];
            for (n4 = 0; n4 < n13; ++n4) {
                colorArray2[n4] = pgElementSet.getElementColor(n4);
            }
            for (n4 = n13; n4 < n11; ++n4) {
                PiVector piVector = (PiVector)vector.elementAt(n4);
                colorArray2[n4] = piVector.getSize() == 3 ? pgElementSet.getElementColor(piVector.m_data[2]) : pgElementSet.getElementColor(piVector.m_data[1]);
            }
        }
        n4 = pgElementSet.hasVertexNormals();
        boolean bl2 = pgElementSet.isShowingVertexNormals();
        PdVector[] pdVectorArray3 = null;
        if (n4 != 0) {
            pdVectorArray3 = pgElementSet.getVertexNormals();
        }
        boolean bl3 = pgElementSet.hasElementNormals();
        boolean bl4 = pgElementSet.isShowingElementNormals();
        PdVector[] pdVectorArray4 = null;
        if (bl3) {
            pdVectorArray4 = PdVector.realloc(null, (int)n11, (int)pgElementSet.getDimOfVertices());
            for (n3 = 0; n3 < n13; ++n3) {
                pdVectorArray4[n3].copyArray(pgElementSet.getElementNormal(n3));
            }
            for (n3 = n13; n3 < n11; ++n3) {
                PiVector piVector = (PiVector)vector.elementAt(n3);
                if (piVector.getSize() == 3) {
                    pdVectorArray4[n3].copyArray(pgElementSet.getElementNormal(piVector.m_data[2]));
                    continue;
                }
                pdVectorArray4[n3].copyArray(pgElementSet.getElementNormal(piVector.m_data[1]));
            }
        }
        n3 = pgElementSet.hasVertexTextures();
        boolean bl5 = pgElementSet.isShowingVertexTexture();
        PdVector[] pdVectorArray5 = null;
        if (n3 != 0) {
            pdVectorArray5 = new PdVector[n11];
            PdVector[] pdVectorArray6 = pgElementSet.getVertexTextures();
            for (n2 = 0; n2 < n13; ++n2) {
                PiVector piVector = (PiVector)vector.elementAt(n2);
                int n23 = piVector.getSize();
                pdVectorArray5[n2] = PdVector.copyNew((PdVector)pdVectorArray6[piVector.m_data[0]]);
                for (n = 1; n < n23; ++n) {
                    pdVectorArray5[n2].add(pdVectorArray6[piVector.m_data[n]]);
                }
                pdVectorArray5[n2].multScalar(1.0 / (double)n23);
            }
            for (n2 = n13; n2 < n11; ++n2) {
                PiVector piVector = (PiVector)vector.elementAt(n2);
                pdVectorArray5[n2] = piVector.getSize() == 3 ? PdVector.blendNew((double)0.5, (PdVector)pdVectorArray6[piVector.m_data[0]], (double)0.5, (PdVector)pdVectorArray6[piVector.m_data[1]]) : PdVector.copyNew((PdVector)pdVectorArray6[piVector.m_data[0]]);
            }
        }
        if (pgElementSet.hasElementTextures()) {
            pgElementSet.setElementTextures((PdVector[][])null);
        }
        pgElementSet.showElementTexture(false);
        int n24 = pgElementSet.getNumVectorFields();
        for (n2 = 0; n2 < n24; ++n2) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setBasedOn(0);
                pgVectorField.setNumVectors(n11);
                for (n = n13; n < n11; ++n) {
                    PiVector piVector = (PiVector)vector.elementAt(n);
                    if (piVector.getSize() == 3) {
                        pgVectorField.setVector(n, PdVector.copyNew((PdVector)pgVectorField.getVector(piVector.m_data[2])));
                        continue;
                    }
                    pgVectorField.setVector(n, PdVector.copyNew((PdVector)pgVectorField.getVector(piVector.m_data[1])));
                }
                continue;
            }
            pgVectorField.setBasedOn(1);
        }
        pgElementSet.setNumVertices(n11);
        pgElementSet.setVertices(pdVectorArray2);
        pgElementSet.setNumElements(n12);
        pgElementSet.setElements(piVectorArray3);
        pgElementSet.assureDimOfElements();
        pgElementSet.setNeighbours(piVectorArray4);
        for (n2 = n13; n2 < n11; ++n2) {
            if (((PiVector)vector.elementAt(n2)).getSize() != 2) continue;
            pgElementSet.setTagVertex(n2, 1);
        }
        if (pgElementSet.hasBoundary()) {
            PwBoundary.makeBoundary(pgElementSet);
        }
        for (n2 = 0; n2 < n11; ++n2) {
            pgElementSet.clearTagVertex(n2, 1);
        }
        if (n4 != 0) {
            pgElementSet.setElementNormals(pdVectorArray3);
        } else {
            pgElementSet.setElementNormals(null);
        }
        pgElementSet.showElementNormals(bl2);
        if (bl3) {
            pgElementSet.setVertexNormals(pdVectorArray4);
        } else {
            pgElementSet.setVertexNormals(null);
        }
        pgElementSet.showVertexNormals(bl4);
        if (n5 != 0) {
            pgElementSet.setElementColors(colorArray);
        } else {
            pgElementSet.setElementColors(null);
        }
        pgElementSet.showElementColors(bl);
        pgElementSet.showElementBackColors(false);
        pgElementSet.setElementBackColors(null);
        if (n7 != 0) {
            pgElementSet.setVertexColors(colorArray2);
        } else {
            pgElementSet.setVertexColors(null);
        }
        pgElementSet.showVertexColors(n6 != 0);
        if (n3 != 0) {
            pgElementSet.setVertexTextures(pdVectorArray5);
            pgElementSet.showVertexTexture(bl5);
        }
    }

    public static void extrude(PgElementSet pgElementSet, double d) {
        PwModel.extrude(pgElementSet, d, false);
    }

    public static void extrude(PgElementSet pgElementSet, double d, boolean bl) {
        int n;
        PdVector[] pdVectorArray;
        PiVector piVector;
        int n2;
        int n3;
        PiVector piVector2;
        int n4;
        if (pgElementSet.getDimOfElements() != 4) {
            pgElementSet.setDimOfElements(-1);
        }
        int n5 = pgElementSet.getNumVertices();
        int n6 = pgElementSet.getNumElements();
        int n7 = 2 * n6;
        int n8 = 2 * n5;
        Vector<PiVector> vector = new Vector<PiVector>();
        Vector<PiVector> vector2 = new Vector<PiVector>();
        PiVector piVector3 = new PiVector(n5);
        piVector3.setConstant(-1);
        if (!pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        pgElementSet.setNumVertices(n8);
        for (n4 = 0; n4 < n5; ++n4) {
            if (bl) {
                pgElementSet.setVertex(n5 + n4, PdVector.blendNew((double)1.0, (PdVector)pgElementSet.getVertex(n4), (double)(-d), (PdVector)pgElementSet.getVertexNormal(n4)));
                pgElementSet.getVertex(n4).blendBase(pgElementSet.getVertex(n4), d, pgElementSet.getVertexNormal(n4));
                continue;
            }
            pgElementSet.setVertex(n5 + n4, pgElementSet.getVertex(n4));
            pgElementSet.setVertex(n4, PdVector.blendNew((double)1.0, (PdVector)pgElementSet.getVertex(n5 + n4), (double)d, (PdVector)pgElementSet.getVertexNormal(n4)));
        }
        for (n4 = 0; n4 < n6; ++n4) {
            piVector2 = pgElementSet.getNeighbour(n4);
            n3 = piVector2.getSize();
            for (n2 = 0; n2 < n3; ++n2) {
                if (piVector2.m_data[n2] != -1) continue;
                piVector2.m_data[n2] = n7;
                piVector = pgElementSet.getElement(n4);
                vector.addElement(new PiVector(piVector.m_data[(n2 + 2) % n3], piVector.m_data[(n2 + 1) % n3], piVector.m_data[(n2 + 1) % n3] + n5, piVector.m_data[(n2 + 2) % n3] + n5));
                vector2.addElement(new PiVector(piVector3.m_data[piVector.m_data[(n2 + 1) % n3]] + 2 * n6, n4 + n6, piVector3.m_data[piVector.m_data[(n2 + 2) % n3]] + 2 * n6, n4));
                for (int i = 1; i < 3; ++i) {
                    if (piVector3.m_data[piVector.m_data[(n2 + i) % n3]] == -1) {
                        piVector3.m_data[piVector.m_data[(n2 + i) % n3]] = n7 - 2 * n6;
                        continue;
                    }
                    PiVector piVector4 = (PiVector)vector2.elementAt(piVector3.m_data[piVector.m_data[(n2 + i) % n3]]);
                    PiVector piVector5 = (PiVector)vector.elementAt(piVector3.m_data[piVector.m_data[(n2 + i) % n3]]);
                    if (piVector5.m_data[0] == piVector.m_data[(n2 + i) % n3]) {
                        piVector4.m_data[2] = n7;
                    } else {
                        piVector4.m_data[0] = n7;
                    }
                    piVector3.m_data[piVector.m_data[(n2 + i) % n3]] = -1;
                }
                ++n7;
            }
        }
        pgElementSet.setNumElements(n7);
        if (pgElementSet.hasVertexColors()) {
            for (n4 = 0; n4 < n5; ++n4) {
                pgElementSet.setVertexColor(n4 + n5, pgElementSet.getVertexColor(n4));
            }
        }
        if (pgElementSet.hasVertexTextures()) {
            for (n4 = 0; n4 < n5; ++n4) {
                pgElementSet.setVertexTexture(n4 + n5, PdVector.copyNew((PdVector)pgElementSet.getVertexTexture(n4)));
            }
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        for (n2 = 0; n2 < n6; ++n2) {
            piVector = pgElementSet.getElement(n2);
            piVector2 = pgElementSet.getNeighbour(n2);
            n3 = piVector.getSize();
            PiVector piVector6 = new PiVector(n3);
            pdVectorArray = new PiVector(n3);
            for (n = 1; n <= n3; ++n) {
                piVector6.m_data[n3 - n] = piVector.m_data[n - 1] + n5;
                pdVectorArray.m_data[(2 * n3 - n - 3) % n3] = piVector2.m_data[n - 1] < n6 ? piVector2.m_data[n - 1] + n6 : piVector2.m_data[n - 1];
            }
            pgElementSet.setElement(n2 + n6, piVector6);
            piVectorArray[n2 + n6] = pdVectorArray;
        }
        for (n2 = 0; n2 < n7 - 2 * n6; ++n2) {
            pgElementSet.setElement(n2 + 2 * n6, (PiVector)vector.elementAt(n2));
            piVectorArray[n2 + 2 * n6] = (PiVector)vector2.elementAt(n2);
        }
        if (pgElementSet.hasElementColors()) {
            for (n2 = 0; n2 < n6; ++n2) {
                pgElementSet.setElementColor(n2 + n6, pgElementSet.getElementColor(n2));
            }
            for (n2 = 0; n2 < n7 - 2 * n6; ++n2) {
                pgElementSet.setElementColor(n2 + 2 * n6, pgElementSet.getElementColor(piVectorArray[n2 + 2 * n6].m_data[3]));
            }
        }
        if (pgElementSet.hasElementBackColors()) {
            for (n2 = 0; n2 < n6; ++n2) {
                pgElementSet.setElementBackColor(n2 + n6, pgElementSet.getElementBackColor(n2));
            }
            for (n2 = 0; n2 < n7 - 2 * n6; ++n2) {
                pgElementSet.setElementBackColor(n2 + 2 * n6, pgElementSet.getElementBackColor(piVectorArray[n2 + 2 * n6].m_data[3]));
            }
        }
        if (pgElementSet.hasElementTextures()) {
            int n9;
            PdVector[][] pdVectorArray2 = pgElementSet.getElementTextures();
            for (n9 = 0; n9 < n6; ++n9) {
                n3 = pgElementSet.getElement(n9).getSize();
                pdVectorArray = new PdVector[n3];
                for (n = 1; n <= n3; ++n) {
                    pdVectorArray[n3 - n] = PdVector.copyNew((PdVector)pdVectorArray2[n9][n - 1]);
                }
                pgElementSet.setElementTexture(n9 + n6, pdVectorArray);
            }
            for (n = 0; n < n7 - 2 * n6; ++n) {
                PdVector[] pdVectorArray3 = new PdVector[4];
                n9 = pgElementSet.getOppVertexLocInd(n + 2 * n6, 3);
                int n10 = pgElementSet.getNeighbour((int)(n + 2 * n6)).m_data[3];
                n3 = pgElementSet.getElement(n10).getSize();
                pdVectorArray3[0] = PdVector.copyNew((PdVector)pdVectorArray2[n10][(n9 + 2) % n3]);
                pdVectorArray3[1] = PdVector.copyNew((PdVector)pdVectorArray2[n10][(n9 + 1) % n3]);
                pdVectorArray3[2] = PdVector.copyNew((PdVector)pdVectorArray2[n10][(n9 + 1) % n3]);
                pdVectorArray3[3] = PdVector.copyNew((PdVector)pdVectorArray2[n10][(n9 + 2) % n3]);
                pgElementSet.setElementTexture(n + 2 * n6, pdVectorArray3);
            }
        }
        int n11 = pgElementSet.getNumVectorFields();
        for (int i = 0; i < n11; ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setNumVectors(2 * n5);
                for (n = 0; n < n5; ++n) {
                    pgVectorField.setVector(n + n5, PdVector.copyNew((PdVector)pgVectorField.getVector(n)));
                }
                continue;
            }
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setNumVectors(n7);
            for (n = 0; n < n6; ++n) {
                pgVectorField.setVector(n + n6, PdVector.copyNew((PdVector)pgVectorField.getVector(n)));
            }
            for (n = 0; n < n7 - 2 * n6; ++n) {
                pgVectorField.setVector(n + 2 * n6, PdVector.copyNew((PdVector)pgVectorField.getVector(pgElementSet.getNeighbour((int)(n + 2 * n6)).m_data[3])));
            }
        }
        pgElementSet.makeVertexNormals();
        pgElementSet.makeElementNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

